/***************************************************************/
//
//
//		DirectX	[ window.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/11
/*---------------------------------------------------------------
Update : 2017/5/11
			Create Header File -> window.h.h 
 			< Add Class Function >
				WiNDOW->Constructor
				WiNDOW->Destructor
				WiNDOW->Create ( static member )
				WiNDOW->Init
				WiNDOW->Uninit
				WiNDOW->Update
				WiNDOW->Draw

Update : 2017/5/11



/*-------------------------------------------------------------*/
#ifndef _WINDOW_H_

#define _WINDOW_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <Windows.h>
#include <map>

#include "proc_method.h"

#pragma comment (lib,"winmm.lib")				// VXe擾ɕKv

#ifndef SAFE_DELETE
#define SAFE_DELETE(p)       { if (p) { delete (p);     (p)=NULL; } }
#endif // SAFE_DELETE

#ifndef SAFE_DELETE_ARRAY
#define SAFE_DELETE_ARRAY(p) { if (p) { delete[] (p);   (p)=NULL; } }
#endif // SAFE_DELETE_ARRAY

#ifndef SAFE_RELEASE
#define SAFE_RELEASE(p)      { if (p) { (p)->Release(); (p)=NULL; } }
#endif // SAFE_RELEASE

/*---------------------------------------------------------------
	Macro Definition
---------------------------------------------------------------*/

#define WINDOW_WIDTH  (1280)
#define WINDOW_HEIGHT (720)

#define APPLICATION_NAME "Chain Pass"

class GameManager;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Window Using Window Process
class Window
{
public:
	
	Window( );								// Window Constructor
	~Window( );								// Window Destructor

	static Window* Create( void );			// Window Create Instance Class
	static HWND GetWindowHandle( void );	// Window Get Window Handle
	static int GetFPS( void );				// Window Get Update Frame/Second
	
	static LRESULT CALLBACK WndProc( 
		HWND hWnd,
		UINT uMsg,
		WPARAM wParam,
		LPARAM lParam ); 

	bool Init( 								// Window Init
		HINSTANCE hInstance,
		HINSTANCE hPravInstance,
		LPTSTR IpCmdLine,
		int nCmdShow );
	int  Uninit( void );					// Window Uninit
	void Application( void );				// Window Update (Mainloop)

	static const int SCREEN_WIDTH;
	static const int SCREEN_HEIGHT;

	static int height;
	static int width;

private:
	
	ATOM MyRegisterClass( 					// Registry WindowClass
		HINSTANCE hInstance );
	bool InitInstance(						// Create Window Process
		HINSTANCE hInstance,
		int nCmdShow );

	// Member Function
	HWND hWnd;
	MSG msg;

	int FPSCounter;							// FPSJEgp

	GameManager* pManager;
	
	static Window* pWindow;
	static std::map<unsigned int,MethodFunc> CallBackMethod;

};


#endif	//	_WINDOW_H_


