/***************************************************************/
//
//
//		System	[ xact.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/26
/*---------------------------------------------------------------
Update : 2017/6/26
			xact.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#define _WIN32_DCOM
#include <Windows.h>

#include "xact.h"
#include "window.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/



/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

IXACT3Engine* XACT::_pXACT3Engine = nullptr;
std::map<std::string,XACTCATEGORY> XACT::group;



// XACT Constructor
XACT::XACT( )
{

	// Member Clear Process

}

// XACT Destructor
XACT::~XACT( )
{

	// Do Nothing!!

}

// XACT Initialize
void XACT::Init( void )
{

	const char* pFileName = nullptr;

	// Initialize Process
	if( FAILED( CoInitializeEx(NULL, COINIT_MULTITHREADED) ) ){
		// COM̏Ɏs
	}
		
	// XACTGW̃CX^X쐬܂B
	if( FAILED( XACT3CreateEngine(0, &_pXACT3Engine) ) ) {
		// XACTGW̍쐬s
	}
		
	XACT_RUNTIME_PARAMETERS xrParams = {};
	if( FAILED( _pXACT3Engine->Initialize(&xrParams) ) ) {
		// XACTGW̏Ɏs
	}
		
	/*
	 oN̍쐬
	 ֘AWaveoN(.xwb)ƃTEhoN(.xsb)iobt@jɃ[h܂B
	 t@C̓ǂݍ݂łAłXACT̃Tv\[XR[hɏ
	 Windows APĨt@Co͊֐𗘗pǂݍ݂̗p܂B
	 ƂɃXg[~OpWaveoN̓ǂݍ݂̓t@Cnh擾ăɓǂݍ
	 ̂ł͂ȂÃnhXg[~OpWaveoÑC^[tF[XɓnƂŒKv
 	 ȂƂɃt@C̓ǂݍ݂񓯊łȂĂ܂B
	 oN̎ނɂAǂݍݕ쐬̕@Ⴂ܂̂ŒӂȂ쐬
 	 傤B
	 ܂͏dvȕϐɂāB*/
	IXACT3WaveBank* _pInMemoryWaveBank;
	IXACT3WaveBank* _pStreamingWaveBank;
	IXACT3SoundBank* _pSoundBank;
	HANDLE _hStreamingWaveBankFile;
	VOID* _pBufInMemoryWaveBank;
	BYTE* _pBufSoundBank;
		
	/* ォ珇ɁAInMemorypWaveoÑCX^X|C^AXg[~OpWaveoN
	 CX^X|C^ATEhoÑCX^X|C^AXg[~OpWaveoNt@
 	 C̃t@CnhAInMemoryWaveoN̓ǂݍݐobt@̈̃|C^ATEho 
 	 Nt@C̓ǂݍݐobt@̈̃|C^ɂȂ܂B*/
		
	{ // ܂InMemoryWaveoNt@C̓ǂݍ݂ƍ쐬B
		HRESULT hr = E_FAIL;
		HANDLE hFile = CreateFile(pFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
		if( hFile != INVALID_HANDLE_VALUE ) {
		DWORD fileSize = GetFileSize(hFile, NULL);
		if( fileSize != -1 ) {
		HANDLE hMapFile = CreateFileMapping(hFile, NULL, PAGE_READONLY, 0, fileSize, NULL);
		if( hMapFile ) {
			_pBufInMemoryWaveBank = MapViewOfFile(hMapFile, FILE_MAP_READ, 0, 0, 0);
				if( _pBufInMemoryWaveBank ) {
					hr = _pXACT3Engine->CreateInMemoryWaveBank(_pBufInMemoryWaveBank,
					fileSize, 0, 0, &_pInMemoryWaveBank);
				}
				CloseHandle(hMapFile);
				}
			}
			CloseHandle(hFile);
		}
		if( FAILED( hr ) ) {
			// InMemoryWaveoN̍쐬Ɏs
		}
	}
		
	{ // ɃXg[~OpWaveoNt@C̓ǂݍ݂ƍ쐬łB
		
		HRESULT hr = E_FAIL;
		_hStreamingWaveBankFile = CreateFile(pFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
		FILE_FLAG_OVERLAPPED | FILE_FLAG_NO_BUFFERING, NULL);
		if( _hStreamingWaveBankFile != INVALID_HANDLE_VALUE ) {
			XACT_WAVEBANK_STREAMING_PARAMETERS xwsParams = {};
			xwsParams.file = _hStreamingWaveBankFile;
			xwsParams.packetSize = 64;
			hr = _pXACT3Engine->CreateStreamingWaveBank(&xwsParams, &_pStreamingWaveBank);
		}
		if( FAILED( hr ) ) {
			// Xg[~OpWaveoN̍쐬Ɏs
		}
	}
		
		
	// Create SoundBank & Load SoundBankData
	HRESULT hr = E_FAIL;
	HANDLE hFile = CreateFile(pFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
	if( hFile != INVALID_HANDLE_VALUE ) {
		DWORD fileSize = GetFileSize(hFile, NULL);
		if( fileSize != -1 ) {
			_pBufSoundBank = new BYTE[fileSize];
			if( _pBufSoundBank ) {
				DWORD byteRead;
				if( 0 != ReadFile(hFile, _pBufSoundBank, fileSize, &byteRead, NULL) ) {
					hr = _pXACT3Engine->CreateSoundBank(_pBufSoundBank, fileSize, 0, 0, &_pSoundBank);
				}
			}
		}
		CloseHandle(hFile);
	}
	if( FAILED( hr ) ) {
		// TEhoN̍쐬Ɏs
	}
		
	// oN̂ƂÂ
	if( _hStreamingWaveBankFile != INVALID_HANDLE_VALUE ) {
		CloseHandle( _hStreamingWaveBankFile );
	}
	SAFE_DELETE_ARRAY(_pBufSoundBank);
	if( _pBufInMemoryWaveBank ) {
		UnmapViewOfFile(_pBufInMemoryWaveBank);
	}


}

// XACT Uninitialize
void XACT::Uninit( void )
{

	// Uninitialize Process
	// XACT Engine Release
	if( _pXACT3Engine != NULL ) {
		_pXACT3Engine->ShutDown();
		_pXACT3Engine->Release();
	}
		
	// COM Release
	CoUninitialize();

}

// XACT Update
void XACT::Update( void )
{

	// Update Process
	_pXACT3Engine->DoWork();

}

// XACT Play
void XACT::Play( void )
{

	const char* pCueName = nullptr;

	// Đ
	/* ł̓TEhĐĂ݂܂傤B
	   TEh̑I̓L[ł邱Ƃł܂B
	   TEh̐L[̌̎擾Ȃǂ̓TEhoNōs܂B*/
	XACTINDEX index = _pSoundBank->GetCueIndex(pCueName);
	_pSoundBank->Play(index, 0, 0, NULL);
}

// XACT Stop
void XACT::Stop( void )
{

	const char* pCueName = nullptr;

	// Đ
	/* ł̓TEhĐĂ݂܂傤B
	   TEh̑I̓L[ł邱Ƃł܂B
	   TEh̐L[̌̎擾Ȃǂ̓TEhoNōs܂B*/
	XACTINDEX index = _pSoundBank->GetCueIndex(pCueName);
	_pSoundBank->Stop(index, 0);	
	
}

/*
{ // CATEGORY
	
	
	XACTCATEGORY@musicCategory = _pXACT3Engine->GetCategory(gMusich);
	_pXACT3Engine->SetVolume(musicCategory, 1.0f);
	Ƃ܂B
	{[́A_lŎ܂B0.0  -96dbA1.0  0dbA2.0  +6db \܂B
	ʂグƃXs[J[󂷋ꂪ܂BXACTł̐ݒlƂƂɋCt܂傤B
	@GlobalJeS[ׂ͂Ă̐ɂȂ܂B
	@Ƃ΂ׂẲꎞ~ꍇ
	XACTCATEGORY@globalCategory = _pXACT3Engine->GetCategory(gGlobalh);
	_pXACT3Engine->Pause(globalCategory, TRUE);
	
	
}
	
	
{ // CUE OPERATE

	
	IXACT3Cue* _pCue = NULL;
	̓TvȂ̂łP擾܂A肽TEhɂĂ͕KvłB
	@L[CX^X̎擾̓TEhoNPlay()֐Ă񂾂ƂɂȂ܂B
	_pSoundBank->Play(index, 0, 0, &_pCue);
	TEhoNPrepare()֐ł擾邱Ƃł܂B
	@ł̓L[~(STOP)Ă݂܂傤B
	_pCue->Stop(0);
	͂Ƃɂ0ĂĉB
	@L[~A_pCue->Play()ĂłL[͍Đ܂łB
	@炭Ȃ炩̎葱KvA~Ă܂ƍēxĐ邱Ƃ͂łȂ̂
	܂B
	@L[CX^XPʂŒ~邱ƂłƂƂ͓ȂʉdȂĖ
	ĂA̒IĒ~邱ƂłƂƂɂȂ܂B
	@ɂꎞ~邱Ƃł܂B
	_pCue->Pause(TRUE);
	@ꎞ~ĊJɂ
	_pCue->Pause(FALSE);
	Ƃ܂B
	@TRUȄꍇꎞ~FALSȄꍇĊJƂȂ܂B
	@L[CX^Xł̐ŊoĂ݂̂͌L[CX^XǂȏԂ
	邩擾ł֐̎głB
	DWORD stateFlag;
	_pCue->GetState(&stateFlag);
	@擾Xe[gtOǂȂĂ̂`FbN邱ƂŏԂ킩܂B
	@Ƃ΍Đł邩ǂmFꍇ
	if( stateFlag & XACT_CUESTATE_PLAYING != 0 ) {
	// Đ
	}
	ƂȂ܂B
	tOȂ̂== (equal) Zł͂ȂA& (and) ZgĉB
	mFłԂ͉̂ƂłB
	l
	XACT_CUESTATE_CREATED 쐬ς݂łAs܂
	XACT_CUESTATE_PREPARING Đ̏ł
	XACT_CUESTATE_PREPARED ς݂łAĐ܂
	XACT_CUESTATE_PLAYING ĐłAꎞ~\ł
	XACT_CUESTATE_STOPPING ~ł
	XACT_CUESTATE_STOPPED ~ς݂ł
	XACT_CUESTATE_PAUSED ꎞ~Ă܂
	ĐɃL[ꎞ~ꂽꍇAXACT_CUESTATE_PLAYING XACT_CUESTATE_PAUSED
	tOɃZbg邱Ƃ܂B
	

}
*/

	
