/***************************************************************/
//
//
//		System	[ xact.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/26
/*---------------------------------------------------------------
Update : 2017/6/26
			Create Header File -> xact.h.h 
 			< Add Class Function >
				XACT->Constructor
				XACT->Destructor
				XACT->Create ( static member )
				XACT->Init
				XACT->Uninit
				XACT->Update
				XACT->Draw

Update : 2017/6/26



/*-------------------------------------------------------------*/
#ifndef _XACT_H_

#define _XACT_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <map>
#include <string>

#include <xact3.h>

#include "audio.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class XACT Using XACT
class XACT // : public Audio
{
public:
	
	XACT( );						// XACT Constructor
	~XACT( );						// XACT Destructor

	void Init( void );				// XACT Initialize
	void Uninit( void );			// XACT Uninitialize
	void Update( void );			// XACT Update
	
	void Play( void );				// XACT Play
	void Stop( void );				// XACT Stop

private:

	// Member Variable
	static IXACT3Engine* _pXACT3Engine;
	static std::map<std::string,XACTCATEGORY> group;
	
	IXACT3WaveBank* _pInMemoryWaveBank;
	IXACT3WaveBank* _pStreamingWaveBank;
	IXACT3SoundBank* _pSoundBank;
	HANDLE _hStreamingWaveBankFile;
	VOID* _pBufInMemoryWaveBank;
	BYTE* _pBufSoundBank;
	
	XACTINDEX index;
	
};


#endif	//	_XACT_H_


