/***************************************************************/
//
//
//		DirectX	[ xboxcontroller.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 2/22
/*---------------------------------------------------------------
Update : 2017/2/22
			xboxcontroller.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <Windows.h>
#include <stdio.h>
#define STRICT
#include <commdlg.h>
#include <basetsd.h>
#pragma warning( disable : 4996 ) // disable deprecated warning 
#include <strsafe.h>
#pragma warning( default : 4996 )

#include "game_manager.h"
#include "xboxcontroller.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

CXboxController* CXboxController::pXboxController[ XBOXCONTROLLER_MAX ] = { };



// CXboxController Constructor
CXboxController::CXboxController( )
	: CInput( CInput::TYPE_XINPUTGAMEPAD )
{

	// Member Clear Process
	ZeroMemory( &press, sizeof press );
	ZeroMemory( &trigger, sizeof trigger );

	// Registration Class( XboxController )
	for( int index = 0; index < XBOXCONTROLLER_MAX; index++ ){
		if( pXboxController[index] == NULL ){
			pXboxController[index] = this;
			pXboxController[index]->deviceIndex = index;
			break;
		}
	}


}

// CXboxController Destructor
CXboxController::~CXboxController( )
{

	// Do Nothing!!

}

// CXboxController Create Instance 
CXboxController* CXboxController::Create( const char* XBOXCONTROLLER_NAME )
{

	// Create Class Instance
	CXboxController* pObject;
	pObject = new CXboxController;

	// Setting Class Name for Access
	strcpy( pObject->xboxcontrollerName, XBOXCONTROLLER_NAME );


	return pObject;

}

// CXboxController Access Outside Function  
CXboxController* CXboxController::Access( const char* XBOXCONTROLLER_NAME )
{

	// Search CXboxController Class
	for( int index = 0; index < XBOXCONTROLLER_MAX; index ++ ){
		if( pXboxController[index] != NULL ){
			if( strcmp( pXboxController[index]->xboxcontrollerName, XBOXCONTROLLER_NAME ) == 0 ){

				return pXboxController[index];
				break;
			}
		}
	}

	return 0;

}

// CXboxController Initialize
void CXboxController::Init( void )
{

	// Initialize Process


}

// CXboxController Uninitialize
void CXboxController::Uninit( void )
{

	// Uninitialize Process


}

// CXboxController Update
void CXboxController::Update( void )
{

	// Update Process
	XINPUT_STATE state = { };	
	DWORD dwResult = 0;

	int i = deviceIndex;

	// Xbox360Controller 
	dwResult = XInputGetState( i, &state );

    if( dwResult == ERROR_SUCCESS ){
        bConnected = true;
	}
	else{
        bConnected = false;
	}
	
	// if Connnected InputDeivce
	if( bConnected ){

		// GetKeyTriggerState
		trigger.Gamepad.wButtons = ( state.Gamepad.wButtons ^ press.Gamepad.wButtons ) & state.Gamepad.wButtons;

		// GetKeyPressState
		press = state;

    } // -> Xbox Controller Process Completed


}

// CXboxController Release Class All
void CXboxController::ReleaseAll( void )
{

	// Release CXboxController All
	for( int index = 0; index < XBOXCONTROLLER_MAX; index ++ ){
		if( pXboxController[ index ] ){

			pXboxController[ index ] ->Uninit( );
			SAFE_DELETE( pXboxController[ index ] )
		}
	}


}

// CXboxController Update Class All
void CXboxController::UpdateAll( void )
{

	// Update CXboxController All
	for( int index = 0; index < XBOXCONTROLLER_MAX; index ++ ){
		if( pXboxController[ index ] != NULL ){

			pXboxController[ index ] ->Update( );
		}
	}


}

// CXboxController GetKeyPressState
bool CXboxController::GetKeyPress( int nKey )
{
	return ( press.Gamepad.wButtons & nKey ) ? true: false;
}

// CXboxController GetKeyTriggerState
bool CXboxController::GetKeyTrigger( int key )
{
	return ( trigger.Gamepad.wButtons & key ) ? true: false;
}

















