// TvvO

#pragma comment(lib, "dxguid.lib")
#pragma comment(lib, "d3d9.lib")
#pragma comment(lib, "d3dx9.lib")

#include <windows.h>
#include <tchar.h>
#include <stdio.h>
#include <d3d9.h>
#include <d3dx9.h>


// _obt@
struct Vtx {
	float x, y;
	float u, v;
};

// `bvUVobt@
struct UV {
	float u, v;
};

// |̃[hWʒuobt@
struct WorldPos {
	float x, y;
};


TCHAR gName[100] = _T( "TvvO" );
IDirect3DDevice9 *g_pD3DDev = 0;
ID3DXFont *pD3DFont = 0;
LARGE_INTEGER startTime;
double lapTime = 0.0;

int mode = 0;	// 0: instancing, 1: normal

const char* modeStr = 0;
const char* modeStr_instancing = "Instancing";
const char* modeStr_normal = "Normal";

const float screenW = 640.0f;			// XN[
const float screenH = 480.0f;			// XN[
const int texPx = 64;					// eNX`̃sNZTCY
const int tipPx = 16;					// `bṽsNZTCY
const float u = ( float )tipPx / texPx;	// `bvUVTCY
const int tipNumInTex = texPx / tipPx;	// eNX`̃`bv̕ѐ
const int W = screenW / tipPx;			// XN[ɕׂ|̉
const int H = screenH / tipPx;			// XN[ɕׂ|̏c
const int tipNum = W * H;				// XN[̃`bv


void copyBuf( unsigned sz, void *src, IDirect3DVertexBuffer9 *buf ) {
	void *p = 0;
	buf->Lock( 0, 0, &p, 0 );
	memcpy( p, src, sz );
	buf->Unlock();
}

void startLap() {
	QueryPerformanceCounter( &startTime );
	lapTime = 0.0;
}

void endLap() {
	LARGE_INTEGER e, f;
	QueryPerformanceCounter( &e );
	QueryPerformanceFrequency( &f );
	lapTime = (double)( e.QuadPart - startTime.QuadPart ) / f.QuadPart;
}

void drawLapTime() {
	RECT r = { 0, 0, 0, 0 };
	char c[ 512 ];
	sprintf_s( c, 512, "mode = %s, time = %f", modeStr, lapTime );
	pD3DFont->DrawText( NULL, c, -1, &r, DT_LEFT | DT_SINGLELINE | DT_NOCLIP, 0xffffffff );
}


class NormalMode {

	UV *uv;
	WorldPos *worldPos;
	IDirect3DVertexBuffer9 *vtxBuf;
	IDirect3DIndexBuffer9 *indexBuf;
	IDirect3DVertexDeclaration9 *decl;
	ID3DXEffect *effect;
	IDirect3DTexture9 *tex;

public:
	NormalMode() : uv(), worldPos(), vtxBuf(), indexBuf(), decl(), tex() {

		Vtx vtx[ 4 ] = {				// Pʔ|obt@
				{ 0.0f, 0.0f, 0.0f, 0.0f },
				{ tipPx, 0.0f, u, 0.0f },
				{ 0.0f, tipPx, 0.0f, u },
				{ tipPx, tipPx, u, u }
		};

		uv = new UV[ tipNum ];				// `bvUVobt@
		for ( int i = 0; i < tipNum; i++ ) {
			uv[ i ].u = u * ( rand() % tipNumInTex );
			uv[ i ].v = u * ( rand() % tipNumInTex );
		}

		worldPos = new WorldPos[ tipNum ];	// [hWʒuobt@
		for ( int w = 0; w < W; w++ ) {
			for ( int h = 0; h < H; h++ ) {
				int e = h * W + w;
				worldPos[ e ].x = tipPx * w;
				worldPos[ e ].y = tipPx * h;
			}
		}

		// _obt@쐬
		g_pD3DDev->CreateVertexBuffer( sizeof( vtx ), 0, 0, D3DPOOL_MANAGED, &vtxBuf, 0 );
		copyBuf( sizeof( vtx ), vtx, vtxBuf );

		// CfbNXobt@
		WORD index[ 6 ] = { 0, 1, 2, 2, 1, 3 };
		g_pD3DDev->CreateIndexBuffer( sizeof( index ), 0, D3DFMT_INDEX16, D3DPOOL_MANAGED, &indexBuf, 0 );
		void *p = 0;
		indexBuf->Lock( 0, 0, &p, 0 );
		memcpy( p, index, sizeof( index ) );
		indexBuf->Unlock();

		// _錾쐬
		D3DVERTEXELEMENT9 declElems[] = {
				{ 0, 0, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },	// Local coord
				{ 0, 8, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },	// UV
				D3DDECL_END()
		};
		g_pD3DDev->CreateVertexDeclaration( declElems, &decl );

		// VF[_쐬
		ID3DXBuffer *errBuf = 0;
		D3DXCreateEffectFromFileA( g_pD3DDev, "tip_normal.fx", 0, 0, 0, 0, &effect, &errBuf );
		if ( errBuf ) {
			const char *errMsg = ( const char* )errBuf->GetBufferPointer();
			OutputDebugStringA( errMsg );
			return;
		}

		// `bveNX`
		D3DXCreateTextureFromFileA( g_pD3DDev, "tips.bmp", &tex );
	}

	~NormalMode() {

		delete[] uv;
		delete[] worldPos;
		vtxBuf->Release();
		indexBuf->Release();
		decl->Release();
		tex->Release();
	}

	void draw() {
		modeStr = modeStr_normal;

		// _ƃCfbNXݒ肵ĕ`
		g_pD3DDev->SetVertexDeclaration( decl );
		g_pD3DDev->SetStreamSource( 0, vtxBuf, 0, sizeof( Vtx ) );
		g_pD3DDev->SetIndices( indexBuf );

		effect->SetTechnique( "tech" );
		UINT passNum = 0;
		effect->Begin( &passNum, 0 );
		effect->BeginPass( 0 );

		for ( int i = 0; i < tipNum; i++ ) {
			effect->CommitChanges();
			effect->SetTexture( "tex", tex );
			effect->SetFloat( "screenW", screenW / 2 );
			effect->SetFloat( "screenH", screenH / 2 );
			effect->SetVector( "tipUV", &D3DXVECTOR4( uv[ i ].u, uv[ i ].v, 0.0f, 0.0f ) );
			effect->SetVector( "worldPos", &D3DXVECTOR4( worldPos[ i ].x, worldPos[ i ].y, 0.0f, 0.0f ) );

			g_pD3DDev->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 0, 4, 0, 2 );
		}

		effect->EndPass();
		effect->End();
	}
};


class InstancingMode {

	IDirect3DVertexBuffer9 *vtxBuf, *uvBuf, *worldPosBuf;
	IDirect3DVertexDeclaration9 *decl;
	IDirect3DIndexBuffer9 *indexBuf;
	IDirect3DTexture9 *tex;
	ID3DXEffect *effect;

public:
	InstancingMode() : vtxBuf(), uvBuf(), worldPosBuf(), decl(), indexBuf(), tex(), effect() {

		Vtx vtx[ 4 ] = {				// Pʔ|obt@
				{ 0.0f, 0.0f, 0.0f, 0.0f },
				{ tipPx, 0.0f, u, 0.0f },
				{ 0.0f, tipPx, 0.0f, u },
				{ tipPx, tipPx, u, u }
		};

		UV *uv = new UV[ tipNum ];				// `bvUVobt@
		for ( int i = 0; i < tipNum; i++ ) {
			uv[ i ].u = u * ( rand() % tipNumInTex );
			uv[ i ].v = u * ( rand() % tipNumInTex );
		}

		WorldPos *worldPos = new WorldPos[ tipNum ];	// [hWʒuobt@
		for ( int w = 0; w < W; w++ ) {
			for ( int h = 0; h < H; h++ ) {
				int e = h * W + w;
				worldPos[ e ].x = tipPx * w;
				worldPos[ e ].y = tipPx * h;
			}
		}

		// _obt@쐬
		g_pD3DDev->CreateVertexBuffer( sizeof( vtx ), 0, 0, D3DPOOL_MANAGED, &vtxBuf, 0 );
		g_pD3DDev->CreateVertexBuffer( sizeof( WorldPos ) * tipNum, 0, 0, D3DPOOL_MANAGED, &worldPosBuf, 0 );
		g_pD3DDev->CreateVertexBuffer( sizeof( UV ) * tipNum, 0, 0, D3DPOOL_MANAGED, &uvBuf, 0 );

		copyBuf( sizeof( vtx ), vtx, vtxBuf );
		copyBuf( sizeof( WorldPos ) * tipNum, worldPos, worldPosBuf );
		copyBuf( sizeof( UV ) * tipNum, uv, uvBuf );

		delete[] uv;
		delete[] worldPos;

		// CfbNXobt@
		WORD index[ 6 ] = { 0, 1, 2, 2, 1, 3 };
		g_pD3DDev->CreateIndexBuffer( sizeof( index ), 0, D3DFMT_INDEX16, D3DPOOL_MANAGED, &indexBuf, 0 );
		void *p = 0;
		indexBuf->Lock( 0, 0, &p, 0 );
		memcpy( p, index, sizeof( index ) );
		indexBuf->Unlock();

		// _錾쐬
		D3DVERTEXELEMENT9 declElems[] = {
				{ 0, 0, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },	// Local coord
				{ 0, 8, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },	// UV
				{ 1, 0, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 1 },	// [hʒu
				{ 2, 0, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 2 },	// `bvUV
				D3DDECL_END()
		};
		g_pD3DDev->CreateVertexDeclaration( declElems, &decl );

		// VF[_쐬
		ID3DXBuffer *errBuf = 0;
		D3DXCreateEffectFromFileA( g_pD3DDev, "tip.fx", 0, 0, 0, 0, &effect, &errBuf );
		if ( errBuf ) {
			const char *errMsg = ( const char* )errBuf->GetBufferPointer();
			OutputDebugStringA( errMsg );
			return;
		}

		// `bveNX`
		D3DXCreateTextureFromFileA( g_pD3DDev, "tips.bmp", &tex );
	}

	~InstancingMode() {

		vtxBuf->Release();
		uvBuf->Release();
		worldPosBuf->Release();
		decl->Release();
		indexBuf->Release();
		tex->Release();
		effect->Release();
	}

	void draw() {

		modeStr = modeStr_instancing;

		// CX^X錾
		g_pD3DDev->SetStreamSourceFreq( 0, D3DSTREAMSOURCE_INDEXEDDATA | ( W*H ) );
		g_pD3DDev->SetStreamSourceFreq( 1, D3DSTREAMSOURCE_INSTANCEDATA | 1 );
		g_pD3DDev->SetStreamSourceFreq( 2, D3DSTREAMSOURCE_INSTANCEDATA | 1 );

		// _ƃCfbNXݒ肵ĕ`
		g_pD3DDev->SetVertexDeclaration( decl );
		g_pD3DDev->SetStreamSource( 0, vtxBuf, 0, sizeof( Vtx ) );
		g_pD3DDev->SetStreamSource( 1, worldPosBuf, 0, sizeof( WorldPos ) );
		g_pD3DDev->SetStreamSource( 2, uvBuf, 0, sizeof( UV ) );
		g_pD3DDev->SetIndices( indexBuf );

		effect->SetTechnique( "tech" );
		UINT passNum = 0;
		effect->Begin( &passNum, 0 );
		effect->BeginPass( 0 );

		effect->SetTexture( "tex", tex );
		effect->SetFloat( "screenW", screenW / 2 );
		effect->SetFloat( "screenH", screenH / 2 );

		g_pD3DDev->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 0, 4, 0, 2 );

		effect->EndPass();
		effect->End();

		// n
		g_pD3DDev->SetStreamSourceFreq( 0, 1 );
		g_pD3DDev->SetStreamSourceFreq( 1, 1 );
		g_pD3DDev->SetStreamSourceFreq( 2, 1 );
	}
};

LRESULT CALLBACK WndProc( HWND hWnd, UINT mes, WPARAM wParam, LPARAM lParam ){
	switch ( mes ) {
	case WM_DESTROY:
		PostQuitMessage( 0 );
		return 0;

	case WM_CHAR:
		if ( wParam == 'c' )
			mode = ( ++mode ) % 2;
		break;
	}

	return DefWindowProc( hWnd, mes, wParam, lParam );
}

int APIENTRY _tWinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
{
	// AvP[V̏
	HWND hWnd;
	WNDCLASSEX wcex = { sizeof( WNDCLASSEX ), CS_HREDRAW | CS_VREDRAW, WndProc, 0, 0, hInstance, NULL, NULL,
		(HBRUSH)(COLOR_WINDOW + 1), NULL, (TCHAR*)gName, NULL };
	if (!RegisterClassEx( &wcex ))
		return 0;

	int w = 640, h = 480;
	RECT clientRect = { 0, 0, w, h };
	::AdjustWindowRect( &clientRect, WS_OVERLAPPEDWINDOW, FALSE );

	if (!(hWnd = CreateWindow( gName, gName, WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, 0,
		clientRect.right - clientRect.left, clientRect.bottom - clientRect.top,
		NULL, NULL, hInstance, NULL )))
		return 0;

	// Direct3D̏
	LPDIRECT3D9 g_pD3D;
	if (!(g_pD3D = Direct3DCreate9( D3D_SDK_VERSION ))) return 0;

	D3DPRESENT_PARAMETERS d3dpp = { w, h, D3DFMT_UNKNOWN, 0, D3DMULTISAMPLE_NONE, 0,
		D3DSWAPEFFECT_DISCARD, NULL, TRUE, TRUE, D3DFMT_D24S8, 0, 0 };

	if (FAILED( g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &g_pD3DDev ) ))
		if (FAILED( g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &g_pD3DDev ) ))
			if (FAILED( g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &g_pD3DDev ) ))
				if (FAILED( g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &g_pD3DDev ) ))
				{
					g_pD3D->Release();	
					return 0;
				}

	// tHg
	int fontsize = 24;
	D3DXFONT_DESC lf = { fontsize, 0, 0, 1, 0, SHIFTJIS_CHARSET, OUT_TT_ONLY_PRECIS,
		PROOF_QUALITY, FIXED_PITCH | FF_MODERN, _T( "lr SVbN" ) };
	if ( FAILED( D3DXCreateFontIndirect( g_pD3DDev, &lf, &pD3DFont ) ) ) {
		g_pD3DDev->Release();  g_pD3D->Release();
		return 0;
	}

	InstancingMode instancingMode;
	NormalMode normalMode;

	ShowWindow( hWnd, nCmdShow );

	// bZ[W [v
	MSG msg;
	do {
		if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) ) {
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		} else {
			g_pD3DDev->Clear( 0, NULL, D3DCLEAR_TARGET | D3DCLEAR_STENCIL | D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB( 0, 0, 255 ), 1.0f, 0 );
			g_pD3DDev->BeginScene();

			startLap();

			if ( mode == 0 )
				instancingMode.draw();
			else
				normalMode.draw();

			endLap();
			drawLapTime();

			g_pD3DDev->EndScene();
			g_pD3DDev->Present( NULL, NULL, NULL, NULL );
		}
	} while ( msg.message != WM_QUIT );

//	normalDrawTest();

	g_pD3DDev->Release();
	g_pD3D->Release();

	return 0;
}