/***************************************************************/
//
//
//		DirectX	[ fieldmap.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/29
/*---------------------------------------------------------------
Update : 2017/5/29
			Create Header File -> fieldmap.h.h 
 			< Add Class Function >
				TUTRIALMAP->Constructor
				TUTRIALMAP->Destructor
				TUTRIALMAP->Create ( static member )
				TUTRIALMAP->Init
				TUTRIALMAP->Uninit
				TUTRIALMAP->Update
				TUTRIALMAP->Draw

Update : 2017/6/19@
			}bvIuWFNg̍쐬ƊȒPɂ邽߂ɁA
			fXg[ const char* MODEL_NAME ]
			ǉ

/*-------------------------------------------------------------*/
#ifndef _TUTRIALMAP_H_

#define _TUTRIALMAP_H_


//#include "block.h"

#include "system_component.h"
#include "rendererdx9.h"

class GameObject;
class TutorialBase;

#include "fieldmap.h"
#include "playercontrol.h"
#include "k_tutprialplayer.h"
#include "grid.h"

#include "menulist.h"
#include "currentframe.h"

#define GRID_FVF_FORMAT ( D3DFVF_XYZ | D3DFVF_DIFFUSE )

#define MAP_SIZE (8)

#define MAP_HEIGHT (50)

#define NUM_OBJECT  (512)
#define OBJ_PRIORITY (3)

#define HOTATE_OKU_BASYO_X ( 24.0f )
#define HOTATE_OKU_BASYO_Z ( 24.0f )

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/
class	KPolygon3D;
class	KPolygon;

// Class TutorialMap Using TutorialMap
class TutorialMap : public FieldMap
{
public:
	typedef enum{
		TEXT_NONE = -1 ,
		TEXT_0_0  = 0,
		TEXT_0_1 ,
		TEXT_1 ,
		TEXT_2 ,
		TEXT_3_0 ,
		TEXT_3_1 ,
		TEXT_4_0 ,
		TEXT_4_1 ,
		TEXT_5 ,
		TEXT_MAX 
	}TEXT;

	typedef enum{
		STATE_NONE = -1 ,
		STATE_CROSSBUTTAN = 0,
		STATE_LRROTATE ,
		STATE_ABUTTONSET ,
		STATE_STARTBUTTON ,
		STATE_HANEKAERU ,
		STATE_GOAL ,
		STATE_MAX
	}STATE;


	typedef enum{
		NONE = 0,
		IMMORTAL,	//TS݂Ȃ
		GOAL,		//I
		START,		//X^[g
		MOVE,		//z^e
		TYPE_MAX ,
	}TYPE;
	
	TutorialMap( );						// TutorialMap Constructor
	~TutorialMap( );						// TutorialMap Destructor

	static TutorialMap* Create( void );	// TutorialMap Create Instance Class

	void Init( const char* filename = nullptr );	// TutorialMap Initialize
	void Uninit( void );				// TutorialMap Uninitialize
	void Update( void );				// TutorialMap Update
	void Draw( void );					// TutorialMap Draw

	static void PutObject( TYPE type, Base* pObj );
	static Vector2& SetObject( Vector3& pos, TYPE type, GameObject* pObj );
	void FieldCheck( void );
	static int* GetStatus( void );

	bool Scissor( const int& z, const int& x );
	bool OnScissor( const int& z, const int& x );
	void Attack( const int& z, const int& x );
	

	static	TutorialMap*	GetMap( void ){return pMap;};

	int	GetState( void ){ return state; } ;
	void	TransitionState( void ){ state++; Counter = 0; };

private:

	// Member Variable
	static TutorialMap* pMap;
	/*
	int vertical;
	int horizonal;
	
	int* map;							// map[][]ƂĎgp
	GameObject** pObj;
	*/
	KTutorialPlayer* player;
	Grid* grid;

	int frame;

	UserInterface* select;
	MenuList* menu;

	static	const char* MODEL_NAME[TYPE_MAX];
	/*
	Base*		other[OBJ_PRIORITY][NUM_OBJECT];
	Base*		start;
	*/
	static	const char* FILE_NAME[];

	static	const char* TEXT_TEXTURE_NAME[];

	int flag;

	int state;

	KPolygon3D*	arrow;
	int	Counter;

	LPDIRECT3DTEXTURE9		m_pTexture[ TEXT_MAX ];
	KPolygon*	m_TextPolygon[ TEXT_MAX ];
};


#endif	//	_TUTRIALMAP_H_


