/** @file
 */
#if defined(HAVE_CONFIG_H)
#  include "../../config.h"
#endif

#include "document_draft_filter.hpp"


namespace gdestraier {
  namespace builder {
    namespace filter {

      from_document_draft::from_document_draft()
      {
      }

      from_document_draft::~from_document_draft()
      {
      }


      factory::extention_map_type from_document_draft::extentions_[] = {
        { "est", 0 },
        { "estraier", 0 },
        { 0, 0 }
      };

      factory const& from_document_draft::get_factory()
      {
        static factory f("Document draft", &from_document_draft::create,
                         from_document_draft::extentions_);
        return f;
      }


      abstract_filter* from_document_draft::create() { return new from_document_draft; }



      bool from_document_draft::operator()(hyperestraier::local_document* doc,
                                           gdestraier::model::index_type const& /*index*/,
                                           ::GnomeVFSURI* uri,
                                           char const* /*text_uri*/,
                                           ::GnomeVFSFileInfo* info,
                                           char const* /*mime_type*/) const
      {
        ::GnomeVFSFileSize bytes_read;
        void* content = load_file_content(uri, info->size, &bytes_read);
        if (content == 0) return false;

        doc->create(static_cast<char const*>(content));

        std::free(content);

        return true;
      }
    }
  }
}

