/**
 */
#include <dbus/dbus-glib-lowlevel.h>
#include "dbus-server.hpp"


#define GDESTRAIER_OBJECT_PATH "/com/no_ip/mitsuki/gdestraier"

namespace gdestraier {
  namespace dbus {


    server::server() :
      connection_(0)
    {
    }



    server::~server()
    {
      stop();
    }



    server& server::instance()
    {
      static server inst;
      return inst;
    }





    ::DBusObjectPathVTable server::searcher_vtable = {
      0,
      server::path_message_func,
      0,
    };


    int server::start()
    {
      if (connection_ != 0) return E_ALREADY_START;


      ::DBusError err;
      ::dbus_error_init(&err);

      ::DBusConnection* conn = ::dbus_bus_get(DBUS_BUS_SESSION, &err);
      if (! conn || ::dbus_error_is_set(&err)) {
        ::g_warning("Failed to connect to D-BUS daemon; %s", err.message);
        ::dbus_error_free(&err);
        return E_CONNECT_FAIL;
      }
      ::dbus_connection_set_exit_on_disconnect(conn, FALSE);
      ::dbus_connection_setup_with_g_main(conn, 0);


      if (! ::dbus_connection_add_filter(conn, &server::filter_func, (void*)this, 0)) {
        ::g_warning("D-BUS: Failed to install filter.");
        ::dbus_connection_unref(conn);
        return E_CONNECT_FAIL;
      }


      if (! ::dbus_connection_register_object_path(conn,
                                                   GDESTRAIER_OBJECT_PATH,
                                                   &searcher_vtable,
                                                   (void*)this ) ) {
        ::g_warning("D-BUS: Failed to register object path.");
        ::dbus_connection_remove_filter(conn, &server::filter_func, 0);
        ::dbus_connection_disconnect(conn);
        ::dbus_connection_unref(conn);
        return E_CONNECT_FAIL;
      }


      if (! ::dbus_bus_request_name(conn,
                                    "com.no_ip.mitsuki.gdestraier",
                                    0, &err) ||
          ::dbus_error_is_set(&err) ) {
        ::g_warning("D-BUS: acquire service: %s", (::dbus_error_is_set(&err)? err.message : "Unknown error"));
        ::dbus_error_free(&err);
        ::dbus_connection_unregister_object_path(conn, GDESTRAIER_OBJECT_PATH);
        ::dbus_connection_remove_filter(conn, &server::filter_func, 0);
        ::dbus_connection_disconnect(conn);
        ::dbus_connection_unref(conn);

        return E_CONNECT_FAIL;
      }



      connection_ = conn;

      return E_SUCCESS;
    }


    int server::stop()
    {
      if (connection_ == 0) return E_NOT_RUNNING;

      ::DBusConnection* conn = connection_;

      connection_ = 0;
      ::dbus_connection_unregister_object_path(conn, GDESTRAIER_OBJECT_PATH);
      ::dbus_connection_remove_filter(conn, &server::filter_func, 0);
      ::dbus_connection_disconnect(conn);
      ::dbus_connection_unref(conn);

      return E_SUCCESS;
    }



    ::DBusHandlerResult server::filter_func(::DBusConnection* conn,
                                            ::DBusMessage*    msg,
                                            void*             user_data)
    {
      server* svr = (server*)user_data;

#if !defined(DBUS_INTERFACE_LOCAL)
#  define DBUS_INTERFACE_LOCAL DBUS_INTERFACE_ORG_FREEDESKTOP_LOCAL
#endif
      if (::dbus_message_is_signal(msg, DBUS_INTERFACE_LOCAL,
                                   "Disconnected")) {
        svr->stop();
        return DBUS_HANDLER_RESULT_HANDLED;
      }
      return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
    }


    ::DBusHandlerResult
    server::path_message_func(::DBusConnection* conn,
                              ::DBusMessage*    msg, 
                              void*             user_data)
    {
      server* svr = (server*)user_data;

      if (::dbus_message_is_method_call(msg,
                                        "com.no_ip.mitsuki.gdestraier.searcher",
                                        "search")) {
        ::DBusError err;
        ::dbus_error_init(&err);

        char* cond = 0;
        if (! ::dbus_message_get_args(msg, &err,
                                      DBUS_TYPE_STRING, &cond,
                                      DBUS_TYPE_INVALID)) {
          ::g_warning("D-BUS: com.no-ip.mitsuki.gdestraier.searcher.search method received. But failed to get args.");

          ::DBusMessage* reply = 0;
          reply = ::dbus_message_new_error(msg, err.name, err.message);
          if (reply == 0)
            ::g_warning("No memory");
          else {
            if (! ::dbus_connection_send(conn, reply, 0))
              ::g_warning("Fialed to response error.");
            ::dbus_message_unref(reply);
          }

          return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
        }

        svr->signal_on_search_request_.emit(cond);

        ::dbus_free(cond);
        return DBUS_HANDLER_RESULT_HANDLED;
      }

      return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
    }

  }
}

