/**
 */
#if !defined(__GDESTRAIER__DBUS__SERVER__HPP__)
#define __GDESTRAIER__DBUS__SERVER__HPP__

#include <glib.h>
#include <sigc++/signal.h>
#include <dbus/dbus.h>

namespace gdestraier {

  namespace dbus {

    class server
    {
    protected:
      server();

    public:
      virtual ~server();

      static server& instance();

      enum {
        E_SUCCESS = 0,
        E_ALREADY_START = -1,
        E_NOT_RUNNING = -2,
        E_CONNECT_FAIL = -3,
      };

      int start();
      int stop();


    public:
      sigc::signal<void, char const*> signal_on_search_request_;

    protected:
      ::DBusConnection*  connection_;

      static ::DBusObjectPathVTable searcher_vtable;

      static ::DBusHandlerResult filter_func(::DBusConnection* conn,
                                             ::DBusMessage*    msg,
                                             void*             user_data);

      static ::DBusHandlerResult path_message_func(::DBusConnection* conn,
                                                   ::DBusMessage*    msg,
                                                   void*             user_data);

    };


  }

}

#endif
