/** @file
 */
#if defined(HAVE_CONFIG_H)
#  include "../config.h"
#endif
#include <boost/bind.hpp>
#include <libgnome/gnome-program.h>
#include <libgnomeui/gnome-ui-init.h>
//#include <X11/Xlib.h>
#include <glibmm/thread.h>
#include <gtkmm/main.h>
#include <popt.h>
#if HAVE_DBUS_GLIB
#  include <dbus/dbus-glib.h>
#  include "dbus-server.hpp"
#endif

#include "gdestraier.hpp"
#include "model/preferences.hpp"
#include "thumbnail_loader.hpp"
#include "mainwindow.hpp"
#include "glade-helper.hpp"
#include "builder/builder.hpp"

static char* gather_target = 0;
static char* user_config_path = 0;

poptOption const options[] = {
  { "gather",      0, POPT_ARG_STRING, (void*)&gather_target, 0, "Run gather and exit.", "INDEX_NAME" },
  { "user-config", 0, POPT_ARG_STRING, (void*)&user_config_path, 0, "Set user configration file", "PATH" },
  { 0, '\0', 0, 0, 0, 0, 0 }
};


static void cprint(char const* msg) { ::g_print("%s", msg); }


extern "C" int
main(int argc, char* argv[])
{
#if defined(ENABLE_NLS)
  ::setlocale(LC_ALL, "");
  bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);
#endif //ENABLE_NLS

  //  ::XInitThreads();
  Glib::thread_init();
#if HAVE_DBUS_GLIB
  ::dbus_g_thread_init();
#endif

  Gtk::Main app(argc, argv, true);

  ::GnomeProgram* gnome_prg = 
      ::gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc, argv, 
                           GNOME_PARAM_POPT_TABLE,
                           options, 
                           GNOME_PROGRAM_STANDARD_PROPERTIES,
                           GNOME_PARAM_NONE);

  // この時点でpreferencesの最初の初期化が行われる。
  gdestraier::model::preferences& pref = gdestraier::gui::get_preferences();
  pref.load();

  if (gather_target != 0) {
    gdestraier::model::index_type* idx = pref.find_index_by_name(gather_target);
    if (idx == 0) {
      ::g_error("No index found: %s", gather_target);
    } else {
      gdestraier::builder::builder b;
      b.reset();
      b.lock_timeout_ = 0;
      b.collect_overwrite_spaces_ = false;
      b.collect_deleted_spaces_ = false;
      b.gather_documents_ = true;
      b.purge_nonexist_documents_ = false;
      b.optimize_ = true;
      b.generate_keywords_ = true;
      b.cache_size_ = 64;
      b.signal_stdout_.connect(&::cprint);
      b.signal_stderr_.connect(&::cprint);
      b.launch(idx);
    }
  } else {
    gdestraier::gui::thumbnail_loader::get_default(); // get_default() to initialize a loader.

    gdestraier::gui::mainwindow* wnd = 0;
    gdestraier::gui::load_toplevel_widget_derived("mainwindow", &wnd);

#if HAVE_DBUS_GLIB
    // Start D-BUS server
    gdestraier::dbus::server::instance().start();
#endif

    wnd->show();

    app.run(*dynamic_cast<Gtk::Window*>(wnd));

    pref.save();

#if HAVE_DBUS_GLIB
    gdestraier::dbus::server::instance().stop();
#endif
    gdestraier::gui::thumbnail_loader::get_default().stop();
  }

  return 0;
}



namespace gdestraier {
  namespace gui {
    gdestraier::model::preferences& get_preferences() {
      static gdestraier::model::preferences instance(user_config_path);
      return instance;
    }
  }
}
