/** @file
 */
#if !defined(__GDESTRAIER__MAINWINDOW__HPP__)
#define __GDESTRAIER__MAINWINDOW__HPP__

#include <boost/noncopyable.hpp>

#include <gtkmm/window.h>
#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/combobox.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/toolbutton.h>
#include <gtkmm/statusbar.h>
#include <gtkmm/liststore.h>
#include <glade/glade-xml.h>

#include "resultview.hpp"


namespace gdestraier {
  namespace gui {


    class mainwindow :
      public Gtk::Window,
      public boost::noncopyable
    {
    protected:
      Gtk::Entry*       keyword_entry_;
      resultview*       resultview_;
      Gtk::Button*      search_button_;
      Gtk::ComboBox*    where_index_combobox_;
      Gtk::Statusbar*   statusbar_;
      //Glib::RefPtr<Gnome::Glade::Xml> const glade_;

      struct {
        Gtk::RadioButton* none_;
        Gtk::RadioButton* by_index_;
        Gtk::RadioButton* by_mime_type_;
        Gtk::RadioButton* by_author_;
        Gtk::RadioButton* by_language_;
        Gtk::RadioButton* by_last_modified_;
      } grouping_buttons_;

      struct {
        Gtk::RadioButton* by_score_;
        Gtk::RadioButton* by_last_modified_;
        Gtk::RadioButton* by_title_;
      } order_buttons_;


      Glib::RefPtr<Gtk::ListStore> where_index_model_;

    protected:
      void      on_quit();
      bool      on_close(::GdkEventAny* event);

      void      on_search();
      void      on_menu_file_activate();
      void      on_menu_preference_activate();
      void      on_menu_build_index_activate();
      void      on_menu_about();
      void      on_grouping_changed();
      void      on_order_changed();
      void      on_quick_build_activate();
      void      on_quick_build_message(Glib::ustring const& msg);

      void      on_indexes_update();

      void      search(char const* phrase);

      void      save_position();
      void      restore_position();

    protected:
      mainwindow();

    public:
      mainwindow(Gtk::Window::BaseObjectType* cobject, ::GladeXML* glade);
      virtual ~mainwindow();
    };

  }
}

#endif

