/** @file
 */
#if !defined(__GDESTRAIER__MODEL__ENCODINGS__HPP__)
#define __GDESTRAIER__MODEL__ENCODINGS__HPP__
#include <cstddef>
#include <string>

namespace gdestraier {
  namespace model {

    struct encoding {
      char const* id_;
      bool        is_utf8_compatible_;

      static std::size_t     num_encodings;
      static encoding const encodings[];
      static encoding const* find(char const* enc);

      std::string to_utf8(std::string const& src) const;
      std::string to_utf8(char const* src) const;
      std::string to_utf8(char const* first, char const* last) const;
    };


  }
}


#endif
