/** @file
 */
#if defined(HAVE_CONFIG_H)
#  include "../../config.h"
#endif
#include <iterator>
#include <boost/spirit.hpp>
#include <boost/bind.hpp>
#include <glib/gmessages.h>
#include "../../gettext.h"
#include <glibmm/i18n.h>

#include "languages.hpp"

namespace gdestraier {
  namespace model {

    language::language(char const* id, char const* name) :
      id_(id), name_(name) { }

    languages::languages()
    {
      push_back(language("en", _("English")));
      push_back(language("ko", _("Korian")));
      push_back(language("ja", _("Japanese")));
      push_back(language("zh", _("Chinese")));
    }

    languages::~languages()
    {
    }


    languages const& languages::instance()
    {
      static languages inst;
      return inst;
    }

  }
}
