/** @file
 */
#if !defined(__GDESTRAIER__MODEL__PREFERENCES__HPP__)
#define __GDESTRAIER__MODEL__PREFERENCES__HPP__

#include <unistd.h>
#include <sys/types.h>

#include <list>
#include <set>
#include <string>

#include "index.hpp"
#include "font_and_colors.hpp"


namespace gdestraier {
  namespace model {

    /** @brief アプリケーションの設定を表すモデル
     */
    class  preferences {
    public:

      /** @brief Default constractor
       *  @param path  設定ファイルのパス。0を指定すると ~/.gdestraierrcを使用します。
       */
      preferences(char const* path);

      /** @brief Constractor
       * 指定されたuidのhomeを取得して設定ファイルの場所を決定するコンストラクタ
       */
      preferences(::uid_t uid);



      /** @brief Destractor
       */
      virtual ~preferences();


    /* @name シリアライズ */
    /* @{ */
    protected:
      std::string       path_;

    public:
      void              save() const;
      void              load();
      /* @} */

      /** @name インデックス */
      /* @{ */
    public:
      typedef std::list<index_type> indexes_type;
      indexes_type indexes_;

      index_type* find_index_by_name(char const* name);

      /* @} */


      /** @name ネットワーク */
      /* @{ */
    public:
      struct {
        int         timeout_;
        std::string proxy_host_;
        int         proxy_port_;
        bool        use_gnome_proxy_settings_;
      } network_;

      void          get_proxy(std::string* host, int* port) const;
      /* @} */


      /** @name 外部コマンド */
      /* @{ */
    public:
      std::string estcmd_path_;
      /* @} */


      /** @name フォント */
      /* @{ */
    public:
      enum { NUM_HIGHLIGHT = 3 };

      struct font_and_colors_type {
        font_and_color background_;
        font_and_color group_header_;
        font_and_color title_;
        font_and_color score_;
        font_and_color file_type_;
        font_and_color author_;
        font_and_color last_modified_;
        font_and_color language_;
        font_and_color index_;
        font_and_color keyword_[NUM_HIGHLIGHT];
      } font_and_colors_;

      font_and_color*       get_font_and_color(char const* name);
      font_and_color const* get_font_and_color(char const* name) const;

      /* @} */

      /** @name アイコンとサムネイル */
      /* @{ */
    public:
      std::size_t thumbnail_size_;
      /* @} */


      /** @name GUIの状態 */
      /** @{ */
    public:
      struct {
        struct {
          int     top_;
          int     left_;
          int     width_;
          int     height_;
        } mainwindow_;
      } GUI_;
      /** @} */

    public:
      /* FIXME: 設定ダイアログ中のリストと同じ並びの必要があるのを改善する */
      enum { GROUP_BY_NONE = 0, GROUP_BY_INDEX, GROUP_BY_MIME_TYPE, GROUP_BY_AUTHOR, GROUP_BY_LANGUAGE, GROUP_BY_LAST_MODIFIED };
      int group_key_;

      /* FIXME: 設定ダイアログ中のリストと同じ並びの必要があるのを改善する */
      enum { SORT_BY_SCORE = 0, SORT_BY_LAST_MODIFIED, SORT_BY_TITLE };
      int sort_key_;
    };
  }
}

#endif

