/** @file
 */
#if !defined(__GDESTRAIER__RESULTVIEW__HPP__)
#define __GDESTRAIER__RESULTVIEW__HPP__

#include <list>
#include <map>
//#include <ctime>

#include <boost/function.hpp>

//#include <gdkmm/dragcontext.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treestore.h>
#include <gtkmm/cellrenderertext.h>
#include <gtkmm/cellrendererpixbuf.h>

#include <glade/glade-xml.h>

#include <hyperestraier/doc.hpp>
#include <hyperestraier/cond.hpp>

#include "result_document.hpp"
#include "model/preferences.hpp"
//#include "model/timestamp.hpp"
#include "context_menu.hpp"

namespace gdestraier {
  namespace gui {

    class resultview :
      public Gtk::TreeView
    {
    public:
      typedef Gtk::TreeNodeChildren::size_type size_type;


    protected:
      Glib::RefPtr<Gtk::TreeStore> model_;
      context_menu                 context_menu_;

      Gtk::TreeViewColumn          main_column_;
      Gtk::CellRendererText        info_renderer_;
      Gtk::CellRendererPixbuf      thumbnail_renderer_;

      struct keyword_data_type {
        unsigned int num_docs_;   //!< キーワードに合致した文書数
        unsigned int score_;      //!< スコア (NOT IN USE)
        unsigned int highlight_;  //!< 使用するハイライト番号

        keyword_data_type() : num_docs_(0), score_(0), highlight_(0) { }
      };

      typedef std::map<Glib::ustring, keyword_data_type> keywords_type;
      keywords_type                keywords_; //!< 現在の検索結果におけるキーワードのセット

      unsigned int found_documents_;    //!< 現在までに見付かった文書数
      unsigned int found_indexes_;      //!< 現在までに文書がヒットしたインデックス数
      unsigned int total_indexes_;      //!< 現在までに検索試行したインデックス数


    public:

    protected:
      typedef std::list<result_document> results_type;
      results_type results_;

      int group_key_;
      int sort_key_;

    public:
      resultview();
      resultview(GtkTreeView* cobject, ::GladeXML* refGlade);
      virtual ~resultview();

      void clear();
      void do_search(Glib::ustring const& phrase, gdestraier::model::index_type const* target_index = 0);
      void update_tree();
    protected:
      template<typename GetKeyProc> void update_tree_impl(GetKeyProc get_key);
      void search_impl(hyperestraier::condition& cond, gdestraier::model::index_type const* target_index);
      void add_result_doc(hyperestraier::document const* doc,
                          int   score,
                          char* snippet,
                          gdestraier::model::index_type const* target_index);

    public:


      int  get_group_key() const { return group_key_; }
      void set_group_key(int gk) { if (group_key_ != gk) { group_key_ = gk; update_tree(); } }

      int get_sort_key() const { return sort_key_; }
      void set_sort_key(int key) {
        if (sort_key_ != key) {
          sort_key_ = key;
          model_->set_sort_column(GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID, Gtk::SORT_ASCENDING);
          model_->set_sort_column(GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, Gtk::SORT_ASCENDING);
        }
      }

      unsigned int get_found_documents() const { return found_documents_; }
      unsigned int get_found_indexes() const { return found_indexes_; }
      unsigned int get_total_indexes() const { return total_indexes_; }


      void add_filemenu(Gtk::Menu* filemenu) { context_menu_.add_filemenu(filemenu); }
      void remove_filemenu(Gtk::Menu* filemenu) { context_menu_.remove_filemenu(filemenu); }

      bool update_context_menu();

      size_type size() const;


    protected:
      void on_button_pressed(GdkEventButton *ev);
      void on_sel_changed();

      void on_open_document_activate(Glib::ustring const& appid);
      void on_open_document_with_activate();
      void on_open_document_parent_activate();
      void on_document_properties_activate();

      int on_compare_row(Gtk::TreeModel::iterator const& l,
                         Gtk::TreeModel::iterator const& r) const;

      void on_thumbnail_cell_data(Gtk::CellRenderer* renderer, Gtk::TreeModel::iterator const&) const;
      void on_info_cell_data(Gtk::CellRenderer* renderer, Gtk::TreeModel::iterator const&);
    };

  }
}

#endif

