/** @file
 *  @brief Thumbnail loader for gdestraier
 *
 */
#if !defined(__GDESTRAIER_THUMBNAIL_LOADER__HPP__)
#define __GDESTRAIER_THUMBNAIL_LOADER__HPP__

#include <boost/noncopyable.hpp>
#include <glibmm/refptr.h>
#include <gdkmm/pixbuf.h>

namespace gdestraier {
  namespace gui {

    /**
     * @brief Abstract interface for thumbnail_loader
     */
    class thumbnail_loader : public boost::noncopyable {
    protected:
      thumbnail_loader();
      virtual ~thumbnail_loader();

    public:

      enum {
        NO_THUMBNAIL = -2,
        LOAD_FAILED = -1,
        LOAD_SUCCESS = 0,
        LOAD_SCHEDULED = 1,
      };

      static thumbnail_loader& get_default();

      virtual int load(Glib::RefPtr<Gdk::Pixbuf>* pixbuf,
                       char const* uri, std::time_t mtime, char const* mime_type) = 0;

      virtual void stop() = 0;
    };

  }
}

#endif

