#!/bin/sh --
#
#	Bourne shell script, to build gearhead.
#
#
#	How to Use This Script?
#	% sh ./build.sh help
#
#
#	How to Compile for Unix-like OS:
#
#		GL mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh gl build clean
#
#		CUTE mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh cute build clean
#
#		SDL mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh sdl build clean
#
#		ASCII without VIDEBUF mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh ascii_novideobuf build clean
#
#		ASCII mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh ascii_utf8 build clean
#
#		ASCII-Emulation(SDL) mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh ascii_sdl build clean
#
#		For Developper
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh build clean definedebug
#
#
#
#	How to Compile for MS-Windows:
#		GL mode
#	% C:\FPC\2.6.0\bin\x86-win64\fpc.exe -g -Ci -Co -CR -Cr -Ct -O1 -Op2 -dHAVE_NO_TERMINAL gearhead2.pas -FUbuild.gl.mswin32 -FEbuild.gl.mswin32
#
#		CUTE mode
#	% C:\FPC\2.6.0\bin\x86-win64\fpc.exe -g -Ci -Co -CR -Cr -Ct -O1 -Op2 -dHAVE_NO_TERMINAL gearhead2.pas -dCUTE -FUbuild.cute.mswin32 -FEbuild.cute.mswin32
#
#		SDL mode
#	% C:\FPC\2.6.0\bin\x86-win64\fpc.exe -g -Ci -Co -CR -Cr -Ct -O1 -Op2 -dHAVE_NO_TERMINAL gearhead2.pas -FUbuild.sdl.mswin32 -FEbuild.sdl.mswin32
#
#		ASCII(SDL) mode
#	% C:\FPC\2.6.0\bin\x86-win64\fpc.exe -g -Ci -Co -CR -Cr -Ct -O1 -Op2 -dHAVE_NO_TERMINAL gearhead2.pas -dASCII -dASCII_SDL -FUbuild.ascii.mswin32 -FEbuild.ascii.mswin32
#
#		ASCII(GDI) mode
#	% C:\FPC\2.6.0\bin\x86-win64\fpc.exe -g -Ci -Co -CR -Cr -Ct -O1 -Op2 -dHAVE_NO_TERMINAL gearhead2.pas -dASCII -dASCII_MSWINGUI -FUbuild.ascii.mswin32 -FEbuild.ascii.mswin32
#
#
#
#	Compiler Options:
#
#		-dHAVE_NO_TERMINAL
#			Compiling for "Window-mode Application" on MS-Windows. MS-Windows only.
#			NOTE: Applications using SDL on MS-Windows can not use terminal without creating a console window.
#			NOTE: If you set this option, the program create a console window.
#

check_exec()
{
  _check_file="$1"
  if [ -x ${_check_file} -a ! -d ${_check_file} ]; then
    return 0
  fi
  return 1
}

search_exec()
{
  _env_name="$1"
  _search_file="$2"
  _default_file="$3"
  if [ "x${_default_file}" = "x" ]; then
    if check_exec /bin/${_search_file}; then
      _ret=/bin/${_search_file}
      return 0
    elif check_exec /usr/bin/${_search_file}; then
      _ret=/usr/bin/${_search_file}
      return 0
    elif check_exec /usr/local/bin/${_search_file}; then
      _ret=/usr/local/bin/${_search_file}
      return 0
    else
      echo "${_search_file} not found."
      echo "Please set environment ${_env_name} where ${_search_file} is."
      return 1
    fi
  elif check_exec ${_default_file}; then
    _ret=${_default_file}
    return 0
  else
    echo "${_default_file} not found."
    echo "Please set environment ${_env_name} where ${_search_file} is."
    return 1
  fi
}

# Parse arguments
#
# Default Settings
MODE_SHOW=
MODE_CLEAN=
MODE_BUILD=
MODE_CROSS=
MODE_OPTIMIZE=
MODE_DEBUG=yes
MODE_PARANOID_SAFER=yes
MODE_DEFINE_DEBUG=
MODE_STATIC=
MODE_GL=
MODE_CUTE=
MODE_SDL=yes
MODE_ASCII=
MODE_ASCII_NOVIDEOBUF=
MODE_ASCII_UTF8=
MODE_ASCII_SDL=
MODE_ASCII_MSWINGUI=
USE_SDL=yes
MODE_UNIX=
MODE_32EMU=
OPTIONS="${OPTIONS}"
PCMODE="-Mfpc"
#PCMODE="-Mobjfpc"
LDFLAGS=
LD_RES=
#
for FOO in $*
do
  MODE_=yes
  MODEnot_=
  case $FOO in
  no*)
    MODE_=
    MODEnot_=yes
    ;;
  esac
  case $FOO in
  show|noshow)
    MODE_SHOW=${MODE_}
    ;;
  clean|noclean)
    MODE_CLEAN=${MODE_}
    ;;
  build|nobuild)
    MODE_BUILD=${MODE_}
    ;;

  cross*|nocross)
    case $FOO in
    cross|nocross)
      MODE_CROSS=
      ;;
    crossemx)
      MODE_CROSS=EMX
      ;;
    crossdarwin)
      MODE_CROSS=Darwin
      ;;
    crossfreebsd)
      MODE_CROSS=FreeBSD
      ;;
    crossgo32v2)
      MODE_CROSS=GO32v2
      ;;
    crosslinux)
      MODE_CROSS=Linux
      ;;
    crossnetbsd)
      MODE_CROSS=NetBSD
      ;;
    crossnetware)
      MODE_CROSS=NetWare
      ;;
    crossopenbsd)
      MODE_CROSS=OpenBSD
      ;;
    crossos2)
      MODE_CROSS=OS2
      ;;
    crosssolaris)
      MODE_CROSS=Solaris
      ;;
    crosswatcom)
      MODE_CROSS=Watcom
      ;;
    crosswdosx)
      MODE_CROSS=WDosX
      ;;
    crosswin32)
      MODE_CROSS=Win32
      ;;
    *)
      echo "Cross-platform option '"$FOO"' is unknown."
      exit 0
      ;;
    esac
    ;;

  optimize|nooptimize)
    MODE_OPTIMIZE=${MODE_}
    ;;
  debug|nodebug)
    MODE_DEBUG=${MODE_}
    ;;
  paranoid_safer|noparanoid_safer)
    MODE_PARANOID_SAFER=${MODE_}
    ;;
  definedebug|nodefinedebug)
    MODE_DEFINE_DEBUG=${MODE_}
    ;;
  static|nostatic)
    MODE_STATIC=${MODE_}
    ;;

  gl)
    MODE_GL=${MODE_}
    MODE_CUTE=${MODEnot_}
    MODE_SDL=${MODEnot_}
    MODE_ASCII=${MODEnot_}
    MODE_ASCII_NOVIDEOBUF=${MODEnot_}
    MODE_ASCII_UTF8=${MODEnot_}
    MODE_ASCII_SDL=${MODEnot_}
    MODE_ASCII_MSWINGUI=${MODEnot_}
    USE_SDL=${MODE_}
    ;;

  cute)
    MODE_GL=${MODEnot_}
    MODE_CUTE=${MODE_}
    MODE_SDL=${MODEnot_}
    MODE_ASCII=${MODEnot_}
    MODE_ASCII_NOVIDEOBUF=${MODEnot_}
    MODE_ASCII_UTF8=${MODEnot_}
    MODE_ASCII_SDL=${MODEnot_}
    MODE_ASCII_MSWINGUI=${MODEnot_}
    USE_SDL=${MODE_}
    ;;

  sdl)
    MODE_GL=${MODEnot_}
    MODE_CUTE=${MODEnot_}
    MODE_SDL=${MODE_}
    MODE_ASCII=${MODEnot_}
    MODE_ASCII_NOVIDEOBUF=${MODEnot_}
    MODE_ASCII_UTF8=${MODEnot_}
    MODE_ASCII_SDL=${MODEnot_}
    MODE_ASCII_MSWINGUI=${MODEnot_}
    USE_SDL=${MODE_}
    ;;

  ascii)
    MODE_GL=${MODEnot_}
    MODE_CUTE=${MODEnot_}
    MODE_SDL=${MODEnot_}
    MODE_ASCII=${MODE_}
    MODE_ASCII_NOVIDEOBUF=${MODEnot_}
    MODE_ASCII_UTF8=${MODEnot_}
    MODE_ASCII_SDL=${MODEnot_}
    MODE_ASCII_MSWINGUI=${MODEnot_}
    USE_SDL=${MODEnot_}
    ;;

  ascii_novideobuf)
    MODE_GL=${MODEnot_}
    MODE_CUTE=${MODEnot_}
    MODE_SDL=${MODEnot_}
    MODE_ASCII=${MODEnot_}
    MODE_ASCII_NOVIDEOBUF=${MODE_}
    MODE_ASCII_UTF8=${MODEnot_}
    MODE_ASCII_SDL=${MODEnot_}
    MODE_ASCII_MSWINGUI=${MODEnot_}
    USE_SDL=${MODEnot_}
    ;;

  ascii_utf8)
    MODE_GL=${MODEnot_}
    MODE_CUTE=${MODEnot_}
    MODE_SDL=${MODEnot_}
    MODE_ASCII=${MODE_}
    MODE_ASCII_NOVIDEOBUF=${MODEnot_}
    MODE_ASCII_UTF8=${MODE_}
    MODE_ASCII_SDL=${MODEnot_}
    MODE_ASCII_MSWINGUI=${MODEnot_}
    USE_SDL=${MODEnot_}
    ;;

  ascii_mswingui)
    MODE_GL=${MODEnot_}
    MODE_CUTE=${MODEnot_}
    MODE_SDL=${MODEnot_}
    MODE_ASCII=${MODEnot_}
    MODE_ASCII_NOVIDEOBUF=${MODEnot_}
    MODE_ASCII_UTF8=${MODEnot_}
    MODE_ASCII_SDL=${MODEnot_}
    MODE_ASCII_MSWINGUI=${MODE_}
    USE_SDL=${MODE_}
    ;;

  ascii_sdl)
    MODE_GL=${MODEnot_}
    MODE_CUTE=${MODEnot_}
    MODE_SDL=${MODEnot_}
    MODE_ASCII=${MODEnot_}
    MODE_ASCII_NOVIDEOBUF=${MODEnot_}
    MODE_ASCII_UTF8=${MODEnot_}
    MODE_ASCII_SDL=${MODE_}
    MODE_ASCII_MSWINGUI=${MODEnot_}
    USE_SDL=${MODE_}
    ;;

  unix|nounix)
    MODE_UNIX=${MODE_}
    ;;

  *|help|h)
    echo "build.sh , It is a script, to build GearHead."
    echo ""
    echo "Arguments:"
    echo "	help		Show these messages."
    echo "	"
    echo "	(no)show	Show only. Not execute.(default no)"
    echo "	(no)clean	Erase all object files, such as *.o and *.ppu .(default no)"
    echo "	(no)build	Build gearhead.(default no)"
    echo "	(no)cross(darwin|freebsd|linux|netbsd|openbsd|os2|solaris|win32)	Cross Compile.(default no)"
    echo "	"
    echo "	(no)optimize	Build with optimization.(default no)"
    echo "	(no)debug	Build with debugger informations.(default yes)"
    echo "	(no)paranoid_safer	Build with define PATCH_GH_PARANOID_SAFER.(default yes)"
    echo "	(no)definedebug	Build with define DEBUG.(default no)"
    echo "	"
    echo "	gl		Build for GL-mode.(default no)"
    echo "	cute		Build for CUTE-mode.(default no)"
    echo "	sdl		Build for SDL-mode.(default yes)"
    echo "	ascii		Build for ASCII-mode.(default no)"
    echo "	ascii_novidebuf	Build for ASCII-mode(without VIDEOBUF).(default no)"
    echo "	ascii_utf8	Build for ASCII-mode.(default no)"
    echo "	ascii_sdl	Build for ASCII(Emulation by SDL)-mode.(default no)"
    echo "	"
    echo "	(no)unix	Build for unixlike os.(default autodetect)"
    echo "	(no)static	Link with static mode.(default no)"
    echo "	"
    echo "Enviroments:"
    echo "	UNAME		Command for 'uname' with fullpath."
    echo "	RM		Command for 'rm' with fullpath."
    echo "	MKDIR		Command for 'mkdir' with fullpath."
    echo "	PC		Command for 'fpc' with fullpath."
    echo "	PC_ENV		Additional environment for 'fpc'."
    echo "	LD		Command for 'ld' with fullpath."
    echo "	INCLUDE		Additional directory for include."
    echo "	UNIT		Additional directory for unit."
    echo "	OPTIONS		Additional options for compiler."
    echo "	DEFINE		Additional define the symbols for compiler."
    echo "	SRC		Source file.(default gearhead2.pas)"
    echo ""
    exit 0
    ;;
  esac
done
#

#
search_exec UNAME uname ${UNAME} || exit 1
UNAME=${_ret}
search_exec RM rm ${RM} || exit 1
RM=${_ret}
search_exec MKDIR mkdir ${MKDIR} || exit 1
MKDIR=${_ret}
search_exec PC fpc ${PC} || exit 1
PC=${_ret}
search_exec LD ld ${LD} || exit 1
LD=${_ret}
#
if [ x$MODE_CROSS = x ]; then
  OS_IDENT=`${UNAME} -s`
  PLATFORM_IDENT=`${UNAME} -p`
  if [ "x" = "x${PLATFORM_IDENT}" -o "xunknown" = "x${PLATFORM_IDENT}" ]; then
    PLATFORM_IDENT=`${UNAME} -m`
  fi
else
  OPTIONS="${OPTIONS} -T${MODE_CROSS}"
  OS_IDENT="${MODE_CROSS}"
  PLATFORM_IDENT="${MODE_CROSS_PLATFORM}"
  if [ "x" = "x${PLATFORM_IDENT}" -o "xunknown" = "x${PLATFORM_IDENT}" ]; then
    echo "Please set the architecture name to an environment variable MODE_CROSS_PLATFORM."
    exit 1
  fi
fi
case ${OS_IDENT} in
FreeBSD|NetBSD|OpenBSD|*BSD|Darwin)
  MODE_UNIX=yes
#  if [ x$PC_ENV = x -a x$FPC_LDPATH = x -a x$LOCALBASE = x ]; then
#    PC_ENV="FPC_LDPATH=/usr/bin/ld"
#  fi
  ;;
Linux|linux)
  MODE_UNIX=yes
  ;;
*Solaris*|*solaris*)
  MODE_UNIX=yes
  ;;
*Win32*|*win32*|*Windows*|*CYGWIN*|*MINGW*)
  MODE_UNIX=
  DEFINE="${DEFINE} -dHAVE_NO_TERMINAL"
  ;;
*)
  ;;
esac
#
if [ x$MODE_GL = xyes ]; then
  DEFINE="${DEFINE}"
  MODE_STRING="gl"
fi
if [ x$MODE_CUTE = xyes ]; then
  DEFINE="${DEFINE} -dCUTE"
  MODE_STRING="cute"
fi
if [ x$MODE_SDL = xyes ]; then
  DEFINE="${DEFINE}"
  MODE_STRING="sdl"
fi
if [ x$MODE_ASCII = xyes ]; then
  DEFINE="${DEFINE} -dASCII"
  MODE_STRING="ascii"
fi
if [ x$MODE_ASCII_NOVIDEOBUF = xyes ]; then
  DEFINE="${DEFINE} -dASCII -dASCII_NOVIDEOBUF"
  MODE_STRING="ascii_novideobuf"
fi
if [ x$MODE_ASCII_UTF8 = xyes ]; then
  DEFINE="${DEFINE} -dASCII -dASCII_UTF8"
  MODE_STRING="ascii_utf8"
fi
if [ x$MODE_ASCII_MSWINGUI = xyes ]; then
  DEFINE="${DEFINE} -dASCII -dASCII_MSWINGUI"
  MODE_STRING="ascii_mswingui"
fi
if [ x$MODE_ASCII_SDL = xyes ]; then
  DEFINE="${DEFINE} -dASCII -dASCII_SDL"
  MODE_STRING="ascii_sdl"
fi
#
if [ x$MODE_DEBUG = xyes ]; then
  OPTIONS="${OPTIONS} -g -Ci -Co -CR -Cr -Ct"
fi
if [ x$MODE_PARANOID_SAFER = xyes ]; then
  DEFINE="${DEFINE} -dPATCH_GH_PARANOID_SAFER"
fi
if [ x$MODE_DEFINE_DEBUG = xyes ]; then
  DEFINE="${DEFINE} -dDEBUG"
fi
if [ x$MODE_OPTIMIZE = xyes ]; then
  OPTIONS="${OPTIONS} -O3 -Op2"
else
  OPTIONS="${OPTIONS}"
fi
if [ x$MODE_STATIC = xyes -a x$MODE_ASCII = xyes ]; then
  OPTIONS="${OPTIONS} -Xt"
fi
#
if [ x$PATH_TO_OBJECTS_ADD = x ]; then
  PATH_TO_OBJECTS="build.${MODE_STRING}.${OS_IDENT}_${PLATFORM_IDENT}"
else
  PATH_TO_OBJECTS="build.${MODE_STRING}.${OS_IDENT}_${PLATFORM_IDENT}.${PATH_TO_OBJECTS_ADD}"
fi
if [ ! -d ${PATH_TO_OBJECTS} ]; then
  if [ x$MODE_SHOW = x ]; then
    ${MKDIR} ${PATH_TO_OBJECTS}
  fi
fi
OPTIONS="${OPTIONS} -FU${PATH_TO_OBJECTS} -FE${PATH_TO_OBJECTS}"
#
PCFLAGS="${OPTIONS} ${DEFINE} ${INCLUDE} ${UNIT}"
SRC=${SRC:-"gearhead2.pas"}
#

#
if [ x$MODE_CLEAN = xyes ]; then
  if [ x$MODE_SHOW = x ]; then
    ${RM} *.o *.ppu
  else
    echo "${RM} *.o *.ppu"
  fi
fi
#
if [ x$MODE_BUILD = xyes ]; then
  if [ x$MODE_SHOW = x ]; then
    if [ x$PC_ENV = x ] ; then
      ${PC} ${PCMODE} ${PCFLAGS} ${SRC}
    else
      env ${PC_ENV} ${PC} ${PCMODE} ${PCFLAGS} ${SRC}
    fi
  else
    if [ x$PC_ENV = x ] ; then
      echo "${PC} ${PCMODE} ${PCFLAGS} ${SRC}"
    else
      echo "env ${PC_ENV} ${PC} ${PCMODE} ${PCFLAGS} ${SRC}"
    fi
  fi
fi
if [ x$MODE_STATIC = xyes -a x$USE_SDL = xyes ]; then
  if [ x$MODE_SHOW = x ]; then
    ${LD} ${LDFLAGS} -L. -o gearhead.static ${LD_RES}
  else
    echo "${LD} ${LDFLAGS} -L. -o gearhead.static ${LD_RES}"
  fi
fi
#

# [ End of File ]
