program gearhead2;
{
	GearHead2, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}

{$LONGSTRINGS ON}

{$IFNDEF DEBUG}
{$IFNDEF ASCII}
{$IFNDEF LINUX}
{$APPTYPE GUI}
{$ENDIF}
{$ENDIF}
{$ENDIF}

uses	dos,version,
{$IFDEF DEBUG}
	errmsg,
{$ENDIF DEBUG}
	texutil,gears_base,gears,utf8msg,navigate,randmaps,locale,arenaplay,ghchars,gearutil,gearparser,
	ability,chargen,backpack,ui4gh,gh2arena,menugear,
	playwright,
{$IFDEF ASCII}
	vidgfx,vidmap,vidmenus;
{$ELSE}
	sdlgfx,sdlmap,sdlmenus,cosplay2;
{$ENDIF}

Procedure RedrawOpening;
	{ The opening menu redraw procedure. }
begin
	SetupTitleScreenDisplay;
	CMessage( 'GearHead2: ' + Version_org + ', BIN:' + Version_UTF8 + ', MSG: ' + Version_txt , ZONE_Title_Screen_Version , StdWhite );
	if 0 < NumSAttList( Console_History ) then begin
		RedrawConsole;
	end;
end;


Procedure GenerateNewPC;
	{ Call the character creator, and save the resultant }
	{ character to disk. }
var
	PC: GearPtr;
begin
	PC := CharacterCreator( 0 );
	if PC <> Nil then begin
		{ Output DEBUG info. }
		SetSAttArray( PC^.SA , Version_Generate_TAG , Version_all );

		{ Write this character to disk. }
		SaveEgg( PC );

		{ Get rid of the PC gear. }
		DisposeGear( PC );
	end;
end;

Procedure StartRPGCampaign;
	{ Load & run the adventure. }
	Procedure DelinkMecha( var SRC: GearPtr; var DST: GearPtr );
	var
		Mek,M2: GearPtr;
	begin
		Mek := SRC;
		while ( NIL <> Mek ) do begin
			M2 := Mek^.Next;
			if ( GG_Mecha = Mek^.G ) then begin
				DelinkGear( SRC , Mek );
				AppendGear( DST , Mek );
			end;
			Mek := M2;
		end;
	end;
	Procedure StripMecha( PC: GearPtr; var Mek_Master: GearPtr );
	var
		Mek,M2: GearPtr;
		PC_Name, PC_Name_org: String;
		Pilot: String;
	begin
		PC_Name := UpCase( GearName( PC ) );
		PC_Name_org := UpCase( GearName_org( PC ) );
		Mek := Mek_Master;
		while ( NIL <> Mek ) do begin
			M2 := Mek^.Next;
			if GG_Mecha = Mek^.G then begin
				Pilot := UpCase( SAttArrayValue( Mek^.SA , 'pilot' ) );
				if ( PC_Name = Pilot ) or ( PC_Name_org = Pilot ) then begin
				end else begin
					RemoveGear( Mek_Master , Mek );
				end;
			end else begin
				RemoveGear( Mek_Master , Mek );
			end;
			Mek := M2;
		end;
	end;
const
	V_NewChar = -2;
var
	RPM: RPGMenuPtr;
	N: Integer;
	N_EGG: Integer;
	N_CHA: Integer;
	V: longint;
	uname: String;
	InFileName: String;
	OutFileName: String;
	PC: GearPtr;
	F: Text;
	CHA: GearPtr;
	Mek: GearPtr;
	tmp_FName: String;
	tmp_RPM: RPGMenuPtr;
	tmp_FName_count: Integer;
begin
	PC := Nil;

	{ Create a menu listing all the characters in the SaveGame directory. }
	RPM := CreateRPGMenu( MenuItem , MenuSelect , @ZONE_Title_Screen_Menu );
	N := BuildFileMenu( RPM , Save_Egg_Base + Default_Search_Pattern , True );
	N := BuildFileMenu( RPM , Save_Egg_Base + Archive_Search_Pattern , True , N );
	N_EGG := N;
	if CHEAT_Load_CHA then begin
		N := BuildFileMenu( RPM , Save_Character_Base + Default_Search_Pattern , True , N );
		N := BuildFileMenu( RPM , Save_Character_Base + Archive_Search_Pattern , True , N );
		N_CHA := N - N_EGG;
	end else begin
		N_CHA := 0;
	end;

	if RPM^.NumItem > 0 then begin
		RPMSortAlpha( RPM );
		AddRPGMenuItem( RPM , MsgString( 'STARTRPG_NewChar' ) , V_NewChar );
		DialogMsg( UTF8_MsgString('gearhead.pas', 'Select character file') );

		uname := SelectFile( RPM , @RedrawOpening );

		if ( '' <> uname ) then begin
			V := RPMLocateByPosition( RPM , RPM^.SelectItem )^.value;
			if V_NewChar = V then begin
				PC := CharacterCreator( 0 );

			end else begin
				InFileName := Save_Game_Directory + TextEncode( uname );
				if ( ( ( 3 + 1 + 4 + 3 ) <= Length(uname) ) and ( GZ_Archive_Suffix = Copy( uname , Length(uname) - Length(GZ_Archive_Suffix) + 1 , Length(GZ_Archive_Suffix) ) ) ) then begin
					OutFileName := Save_Game_Directory + TextEncode( Copy( uname , 1 , ( Pos( '.' , uname ) - 1 ) ) + Default_File_Ending );
					decompress( 'StartRPGCampaign', InFileName , OutFileName );
					InFileName := OutFileName;
				end;
				Assign(F, InFileName );
				reset(F);
				if ( V < N_EGG ) then begin
					PC := ReadCGears(F);
				end else begin
					PC := NewGear( NIL );
					SetSAttArray( PC^.SA , Version_LoadCHA_TAG , Version_all );
					CHA := ReadCGears(F);
					Mek := NIL;
					DelinkMecha( CHA , Mek );
					StripMecha( CHA , Mek );
					InsertSubCom( PC , CHA );
					InsertSubCom( PC , Mek );
				end;
				Close(F);
			end;
		end;

	end else begin
		{ The menu was empty... make a new PC! }
		PC := CharacterCreator( 0 );

	end;

	if ( NIL <> PC ) then begin
		tmp_FName := Save_Campaign_Base + TextEncode(GearName( PC^.SubCom )) + Default_File_Ending;
		tmp_RPM := CreateRPGMenu( MenuItem , MenuSelect , @ZONE_Title_Screen_Menu );
		tmp_FName_count := BuildFileMenu( tmp_RPM , tmp_FName , True , 0 );
		DisposeRPGMenu( tmp_RPM );
		if ( 0 < tmp_FName_count ) then begin
			DialogMSG( UTf8_MsgString('gearhead.pas','Do you overwrite?') );
			tmp_RPM := CreateRPGMenu( MenuItem , MenuSelect , @ZONE_Title_Screen_Menu );
			AddRPGMenuItem( tmp_RPM , UTF8_MsgString('gearhead.pas','Cancel') , 1 );
			AddRPGMenuItem( tmp_RPM , UTF8_MsgString('gearhead.pas','Overwrite') , 0 );
			tmp_FName_count := SelectMenu( tmp_RPM , @RedrawOpening );
			DisposeRPGMenu( tmp_RPM );
		end;
		if ( 0 < tmp_FName_count ) then begin
			DisposeGear( PC );
		end;
	end;

	if PC <> Nil then begin
		{ Output DEBUG info. }
		SetSAttArray( PC^.SA , Version_Start_TAG , Version_all );

		StartCampaign( PC );
	end;

	DisposeRPGMenu( RPM );
end;

Procedure DesignDirBrowser;
	{ Browse the mecha files on disk. }
	{ NOTE: This procedure must be called from the Arena opening menu, so that }
	{ the RedrawOpening procedure is properly initialized. }
var
	MekMenu: RPGMenuPtr;
	fname: String;
	part: GearPtr;
begin
	MekMenu := CreateRPGMenu( MenuItem , MenuSelect , @ZONE_Title_Screen_Menu );
	BuildFileMenu( MekMenu , Design_Directory + Default_Search_Pattern , False );
	RPMSortAlpha( MekMenu );
	AddRPGMenuItem( MekMenu , UTF8_MsgString( 'GEARHEAD.PAS_DesignDirBrowser', 'Exit' ) , SELECTMENU_Cancel );

	repeat
		fname := SelectFile( MekMenu , @RedrawOpening );

		if fname <> '' then begin
			part := LoadFile( fname , Design_Directory );
			if Part <> Nil then begin
				if Part^.Next = Nil then begin
					{ Only one mecha in this file. Just view it. }
					MechaPartBrowser( NIL , NIL , NIL , Part , @RedrawOpening );
				end else begin
					{ Multiple mecha in this file. Better write another }
					{ procedure... }
					BrowseDesignFile( NIL , Part , @RedrawOpening );
				end;
				DisposeGear( Part );
			end;
		end;
	until fname = '';
	DisposeRPGMenu( MekMenu );
end;


Procedure SeriesDirBrowser;
	{ Browse the series files on disk. }
	{ NOTE: This procedure must be called from the Arena opening menu, so that }
	{ the RedrawOpening procedure is properly initialized. }
var
	MekMenu: RPGMenuPtr;
	fname: String;
	part: GearPtr;
begin
	MekMenu := CreateRPGMenu( MenuItem , MenuSelect , @ZONE_Title_Screen_Menu );
	BuildFileMenu( MekMenu , Series_Directory + Default_Search_Pattern , False );
	RPMSortAlpha( MekMenu );
	AddRPGMenuItem( MekMenu , UTF8_MsgString( 'GEARHEAD.PAS_SeriesDirBrowser', 'Exit' ) , SELECTMENU_Cancel );

	repeat
		fname := SelectFile( MekMenu , @RedrawOpening );

		if fname <> '' then begin
			part := LoadFile( fname , Series_Directory );
			if Part <> Nil then begin
				if Part^.Next = Nil then begin
					{ Only one mecha in this file. Just view it. }
					MechaPartBrowser( NIL , NIL , NIL , Part , @RedrawOpening );
				end else begin
					{ Multiple mecha in this file. Better write another }
					{ procedure... }
					BrowseDesignFile( NIL , Part , @RedrawOpening );
				end;
				DisposeGear( Part );
			end;
		end;
	until fname = '';
	DisposeRPGMenu( MekMenu );
end;

Procedure GenNames;
var
	t: Integer;
	mylist: SAttListPtr;
begin
	mylist := CreateSAttList;
	for t := 1 to 10000 do begin
		StoreSAttList( mylist, RandomName );
	end;
	SaveStringList( 'names.txt', mylist );
	DisposeSAttList( mylist );
end;


var
	RPM: RPGMenuPtr;
	N: Integer;

begin
{$IFDEF DEBUG}
	ErrorMessage_fork( 'DEBUG: gearhead.pas(begin)' );
{$ENDIF DEBUG}

	{GenNames;}

	RPM := CreateRPGMenu( MenuItem , MenuSelect , @ZONE_Title_Screen_Menu );
{$IFNDEF ASCII}
	RPM^.mode := RPMNoCancel;
{$ENDIF}
	AddRPGMenuItem( RPM , UTF8_MsgString( 'gearhead.pas', 'Create Character' ) , 1 );
	AddRPGMenuItem( RPM , UTF8_MsgString( 'gearhead.pas', 'Load RPG Campaign' ) , 2 );
	AddRPGMenuItem( RPM , UTF8_MsgString( 'gearhead.pas', 'Start RPG Campaign' ) , 3 );

	AddRPGMenuItem( RPM , UTF8_MsgString( 'gearhead.pas', 'Load Arena Campaign' ) , 6 );
	AddRPGMenuItem( RPM , UTF8_MsgString( 'gearhead.pas', 'Start Arena Campaign' ) , 7 );

	AddRPGMenuItem( RPM , UTF8_MsgString( 'gearhead.pas', 'View Design Files' ) , 4 );

{$IFNDEF ASCII}
	AddRPGMenuItem( RPM , UTF8_MsgString( 'gearhead.pas', 'View Color Selector' ) , 8 );
{$ENDIF}

	if XXRan_Debug then begin
		AddRPGMenuItem( RPM , UTF8_MsgString( 'gearhead.pas', 'View Series Files' ) , 5 );
	end;

	AddRPGMenuItem( RPM , '(BIN: ' + Version_UTF8 + ')' , 0 );
	AddRPGMenuItem( RPM , '(MSG: ' + Version_txt + ')' , 0 );

	AddRPGMenuItem( RPM , UTF8_MsgString( 'gearhead.pas', 'Quit Game' ) , SELECTMENU_Cancel );

	repeat
{$IFDEF DEBUG}
		ErrorMessage_fork( rcsid );
		ErrorMessage_fork( '(MSG: ' + Version_txt + ')' );
{$ENDIF DEBUG}
		if not STARTUP_OK then begin
{$IFDEF DEBUG}
			ErrorMessage_fork( UTF8_MsgString('gearhead.pas', 'ERROR Main game directories not found') );
{$ENDIF DEBUG}
			DialogMsg( UTF8_MsgString('gearhead.pas', 'ERROR Main game directories not found') );
		end;

		N := SelectMenu( RPM , @RedrawOpening );

		case N of
			1:	GenerateNewPC;
			2:	RestoreCampaign( @RedrawOpening );
			3:	StartRPGCampaign;
			4:	DesignDirBrowser;
			5:	SeriesDirBrowser;
			6:	RestoreArenaCampaign( @RedrawOpening );
			7:	StartArenaCampaign;
{$IFNDEF ASCII}
			8:	Cosplay;
{$ENDIF}
		end;

		{ Get rid of the console history from previous games. }
		DisposeSAttList( Console_History );
		DisposeSAttList( Skill_Roll_History );
		Console_History := CreateSAttList;
		Skill_Roll_History := CreateSAttList;
		ProtectedMode_at_PlotDeadend := False;
		Purge_Check_DuplicateNames();
	until ( SELECTMENU_Cancel = N );

	{deallocate all dynamic resources.}
	DisposeRPGMenu( RPM );

{$IFDEF DEBUG}
	ErrorMessage_fork( 'DEBUG: gearhead.pas(end)' );
{$ENDIF DEBUG}
end.
