unit hash;
{
	Copyright(C)2018 G-HAL
}
{$LONGSTRINGS ON}

interface

Function hash_string( const s: String ): Longword;


implementation

{$IFDEF DEBUG}
uses	errmsg;
{$ENDIF DEBUG}

const
	crc_init_value: Longword = $FFFFFFFF;
	{ crc_table_value: Longword = $EDB88320;	{ CRC32-IEEE802.3 } }
	crc_table_value: Longword = $82F63B78;	{ CRC32C Castagnoli }
	{ crc_table_value: Longword = $EB31D82E;	{ CRC32K Koopman } }

var
	crc_table: Array [0..255] of Longword;


Function hash_string( const s: String ): Longword;
var
	l: Integer;
	p: Integer;
	c: Byte;
begin
	l := Length( s );

	hash_string := crc_init_value;
	for p := 1 to l do begin
		c := Byte(s[p]);
		hash_string := crc_table[(hash_string and $FF) xor c] xor (hash_string >> 8);
	end;
	hash_string := ( hash_string xor $FFFFFFFF );
end;


Procedure init_hashtable;
var
	n: Longword;
	c: Longword;
	k: Integer;
begin
	for n := 0 to 255 do begin
		c := n;
		for k := 0 to 7 do begin
			if ( 1 = ( 1 and c ) ) then begin
				c := crc_table_value xor ( c >> 1 );
			end else begin
				c := ( c >> 1 );
			end;
		end;
		crc_table[n] := c;
	end;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: hash.pp');
{$ENDIF DEBUG}
	init_hashtable;
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: hash.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
{ End of File }
