Program maped;
{
	GearHead2, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}
{$LONGSTRINGS ON}

{	This is the map editor for GH2. Note that this program must be compiled
	in ASCII mode.
}


uses gears_base,gears,locale,randmaps,ui4gh,texutil,
{$IFDEF ASCII}
  {$IFDEF ASCII_SDL}
	sdl,
  {$ELSE ASCII_SDL}
	video,
  {$ENDIF ASCII_SDL}
	vidgfx,vidmap,vidmenus;
{$ELSE ASCII}
	sdl,sdlgfx,sdlmap,sdlmenus;
{$ENDIF ASCII}

const
	METerrGfx: Array [1..NumTerr] of Char = (
		'.', '=', '#', '=', '%',
		'.', '.', '^', '^', '^',
		'.', '#', '#', '.', '+',
		'.', '=', '-', '.', '#',
		'.', '%', '-', '&', '&',
		'#', '&', '.', '.'
	);
{$IFDEF ASCII}
  {$IFDEF ASCII_SDL}
	METerrColor: Array [1..NumTerr] of PSDL_Color = (
		@SDLLightGreen, @SDLLightGreen, @SDLLightGreen, @SDLLightBlue, @SDLDarkGray,
		@SDLLightGray, @SDLLightCyan, @SDLDarkGray, @SDLLightGray, @SDLWhite,
		@SDLDarkGray, @SDLLightGray, @SDLWhite, @SDLDarkGray, @SDLDarkGray,
		@SDLLightBlue, @SDLLightBlue, @SDLLightBlue, @SDLBrown, @SDLYellow,
		@SDLLightBlue, @SDLBrown,@SDLDarkGray,@SDLLightGray,@SDLLightGray,
		@SDLLightCyan,@SDLLightGray,@SDLBrown,@SDLYellow
	);
  {$ELSE ASCII_SDL}
	METerrColor: Array [1..NumTerr] of Byte = (
		LightGreen, LightGreen, LightGreen, LightBlue, DarkGray,
		LightGray, LightCyan, DarkGray, LightGray, White,
		DarkGray, LightGray, White, DarkGray, DarkGray,
		LightBlue, LightBlue, LightBlue, Brown, Yellow,
		LightBlue, Brown,DarkGray,LightGray,LightGray,
		LightCyan,LightGray,Brown,Yellow
	);
  {$ENDIF ASCII_SDL}
{$ELSE ASCII}
	METerrColor: Array [1..NumTerr] of PSDL_Color = (
		@SDLLightGreen, @SDLLightGreen, @SDLLightGreen, @SDLLightBlue, @SDLDarkGray,
		@SDLLightGray, @SDLLightCyan, @SDLDarkGray, @SDLLightGray, @SDLWhite,
		@SDLDarkGray, @SDLLightGray, @SDLWhite, @SDLDarkGray, @SDLDarkGray,
		@SDLLightBlue, @SDLLightBlue, @SDLLightBlue, @SDLBrown, @SDLYellow,
		@SDLLightBlue, @SDLBrown,@SDLDarkGray,@SDLLightGray,@SDLLightGray,
		@SDLLightCyan,@SDLLightGray,@SDLBrown,@SDLYellow
	);
{$ENDIF ASCII}

Function CellOnTile( GB: GameBoardPtr; X,Y: Integer ): GearPtr;
	{ Look at tile X,Y and return the cell associated with it. }
var
	M,C: GearPtr;
	MX,MY: Integer;
begin
	M := GB^.Meks;
	C := Nil;
	while ( M <> Nil ) and ( C = Nil ) do begin
		MX := M^.Stat[ STAT_PDMC_X ];
		MY := M^.Stat[ STAT_PDMC_Y ];
		if ( MX <= X ) and (( MX + M^.Stat[ STAT_PDMC_W ]) > X ) and ( MY <= Y ) and (( MY + M^.Stat[ STAT_PDMC_H ]) > Y ) then begin
			C := M;
		end;
		M := M^.Next;
	end;
	CellOnTile := C;
end;

Procedure MEDisplayMap( GB: GameBoardPtr; Pen_X,Pen_Y: Integer );
	{ Display the map. Display all tiles and the locations of map cells. }
	{ The Pen_X , Pen_Y position should be centered on the screen. }
const
	{ These arrays tell where to put the direction indicator for a }
	{ map cell. Note that the bright spot points in the direction that }
	{ would be south in the minimap; this is the direction that's used }
	{ as the front of a store tile. }
	Sweet_X: Array [0..3] of byte = ( 2 , 0 , 2 , 4 );
	Sweet_Y: Array [0..3] of byte = ( 4 , 2 , 0 , 2 );
var
{$IFDEF ASCII}
	Map_Zone: VGFX_Rect;
{$ELSE ASCII}
{$ENDIF ASCII}
	Map_Zone_W: Integer;
	Map_Zone_H: Integer;
	TX,TY,MX,MY,T: Integer;
	M: GearPtr;
{$IFDEF ASCII}
  {$IFDEF ASCII_SDL}
	BGColor: TSDL_Color;
  {$ELSE ASCII_SDL}
	BGColor: Byte;
  {$ENDIF ASCII_SDL}
{$ELSE ASCII}
	BGColor: TSDL_Color;
{$ENDIF ASCII}
begin
	ClrScreen;
{$IFDEF ASCII}
	Map_Zone.X := 1;
	Map_Zone.Y := 1;
	Map_Zone.W := ScreenColumns - RightColumnWidth;
	Map_Zone.H := ScreenRows - 5;
	ClipZone( Map_Zone );
	Map_Zone_W := Map_Zone.W;
	Map_Zone_H := Map_Zone.H;
{$ELSE ASCII}
	Map_Zone_W := ScreenColumns - 25;
	Map_Zone_H := ScreenRows - 5;
{$ENDIF ASCII}

	for TX := 1 to Map_Zone_W do begin
		for TY := 1 to Map_Zone_H do begin
			MX := TX + Pen_X - Map_Zone_W div 2;
			MY := TY + Pen_Y - Map_Zone_H div 2;
			if OnTheMap( GB , MX , MY ) then begin
				M := CellOnTile( GB , MX , MY );
				if ( MX = Pen_X ) and ( MY = Pen_Y ) then begin
{$IFDEF ASCII}
  {$IFDEF ASCII_SDL}
					BGColor := SDLGreen;
  {$ELSE ASCII_SDL}
					BGColor := Green;
  {$ENDIF ASCII_SDL}
{$ELSE ASCII}
					BGColor := SDLGreen;
{$ENDIF ASCII}
				end else if M <> Nil then begin
					{ Depending on the direction of this cell, }
					{ color this tile either blue or cyan. }
					if (( MX - M^.Stat[ STAT_PDMC_X ] ) = Sweet_X[ M^.Stat[ STAT_PDMC_D ] ] ) and (( MY - M^.Stat[ STAT_PDMC_Y ] ) = Sweet_Y[ M^.Stat[ STAT_PDMC_D ] ] ) then begin
{$IFDEF ASCII}
  {$IFDEF ASCII_SDL}
						BGColor := SDLCyan;
  {$ELSE ASCII_SDL}
						BGColor := Cyan;
  {$ENDIF ASCII_SDL}
{$ELSE ASCII}
						BGColor := SDLCyan;
{$ENDIF ASCII}
					end else begin
{$IFDEF ASCII}
  {$IFDEF ASCII_SDL}
						BGColor := SDLBlue;
  {$ELSE ASCII_SDL}
						BGColor := Blue;
  {$ENDIF ASCII_SDL}
{$ELSE ASCII}
						BGColor := SDLBlue;
{$ENDIF ASCII}
					end;
				end else begin
{$IFDEF ASCII}
  {$IFDEF ASCII_SDL}
					BGColor := SDLBlack;
  {$ELSE ASCII_SDL}
					BGColor := Black;
  {$ENDIF ASCII_SDL}
{$ELSE ASCII}
					BGColor := SDLBlack;
{$ENDIF ASCII}
				end;
				T := TileTerrain( GB , MX , MY );
{$IFDEF ASCII}
  {$IFDEF ASCII_SDL}
				DrawGlyph( METerrGfx[ T ] , TX , TY , METerrColor[T]^ , BGColor );
  {$ELSE ASCII_SDL}
				DrawGlyph( METerrGfx[ T ] , TX , TY , METerrColor[T] , BGColor );
  {$ENDIF ASCII_SDL}
{$ELSE ASCII}
{$ENDIF ASCII}
			end;
		end;	{ For TY }
	end;	{ For TX }

	{ Restore the clip zone. }
{$IFDEF ASCII}
	MaxClipZone;
{$ELSE ASCII}
{$ENDIF ASCII}
end;

Procedure MapEditInfo( GB: GameBoardPtr; Pen , X , Y: Integer );
	{ Display some info about the pen, and print out some instructions while you're }
	{ at it. }
const
	Instructions = ' [ ] Change Pen' + #13 + ' S Save Map' + #13 + ' C Clear Map' + #13 + ' c Add/Rotate Cell' + #13 + ' d Delete Cell'  + #13 + ' Q Quit Editor';
{$IFDEF ASCII}
{$ELSE ASCII}
	TCEL_OpenGround = 0;
	TCEL_Void = 1;
	TCEL_Pavement = 2;
	TCEL_DarkGround = 3;
	TCEL_RoughGround = 4;

	TCEL_Wall = 5;
	TCEL_Carpet = 6;
	TCEL_WoodenFloor = 7;
	TCEL_WoodenWall = 8;
	TCEL_GlassWall = 9;

	TCEL_Floor = 10;
	TCEL_LightForest_A = 11;
	TCEL_HeavyForest_A = 12;
	TCEL_LightForest_B = 13;
	TCEL_HeavyForest_B = 14;

	TCEL_ShortWall = 15;
	TCEL_Door = 16;
	TCEL_Threshold = 17;
	TCEL_Elevator = 18;
	TCEL_ShortDoor = 19;

	TCEL_LowHill = 20;
	TCEL_MediumHill = 21;
	TCEL_HighHill = 22;

	TCEL_L1Water = 30;
	TCEL_L2Water = 31;
	TCEL_L3Water = 32;
	TCEL_Rubble = 40;
	TCEL_Wreckage = 41;
	TCEL_Dirt = 42;
	TCEL_Sand = 43;

	{ Extras cel constants. }
	ECEL_Unknown = 0;
	ECEL_Trapdoor = 1;
	ECEL_Indicator = 2;
	ECEL_Item = 3;
	ECEL_Dead_Thing = 4;

	ECEL_Wreckage = 5;
	ECEL_StairsUp = 6;
	ECEL_StairsDown = 7;

	ECEL_Sign = 8;
	ECEL_Nameplate_Short = 15;
	ECEL_Nameplate_Tall = 16;

	ECEL_Fire = 20;
	ECEL_Smoke = 21;
{$ENDIF ASCII}
var
	T: Integer;
begin
{$IFDEF ASCII}
  {$IFDEF ASCII_SDL}
	GameMsg( METerrGfx[ Pen ] + ' ' + MsgString( 'TerrNAME_' + BStr( Pen ) ) , ZONE_Info , METerrColor[ Pen ]^ );
  {$ELSE ASCII_SDL}
	GameMsg( METerrGfx[ Pen ] + ' ' + MsgString( 'TerrNAME_' + BStr( Pen ) ) , ZONE_Info , METerrColor[ Pen ] );
  {$ENDIF ASCII_SDL}
{$ELSE ASCII}
	case Pen of
	TERRAIN_OpenGround: 	DrawSprite( terrain_sprite , ZONE_Info , TCEL_OpenGround );
	TERRAIN_LightForest:	begin
				DrawSprite( terrain_sprite , ZONE_Info , TCEL_LightForest_A );
				DrawSprite( Terrain_Sprite , ZONE_Info , TCEL_LightForest_B );
				end;
	TERRAIN_HeavyForest:	begin
				DrawSprite( terrain_sprite , ZONE_Info , TCEL_HeavyForest_A );
				DrawSprite( Terrain_Sprite , ZONE_Info , TCEL_HeavyForest_B );
				end;

	TERRAIN_Rubble:		DrawSprite( terrain_sprite , ZONE_Info , TCEL_Rubble );

	TERRAIN_Pavement: 	DrawSprite( terrain_sprite , ZONE_Info , TCEL_Pavement );
	TERRAIN_Swamp: 		DrawSprite( terrain_sprite , ZONE_Info , TCEL_DarkGround );
	TERRAIN_L1_Hill:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_LowHill );
	TERRAIN_L2_Hill:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_MediumHill );
	TERRAIN_L3_Hill:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_HighHill );
	TERRAIN_RoughGround:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_RoughGround );
	TERRAIN_LowWall:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_Wall );
	TERRAIN_Wall:		DrawSprite( terrain_sprite , ZONE_Info , TCEL_Wall );
	TERRAIN_Floor:		DrawSprite( terrain_sprite , ZONE_Info , TCEL_Floor );
	TERRAIN_Threshold:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_Threshold );
	TERRAIN_Carpet:		DrawSprite( terrain_sprite , ZONE_Info , TCEL_Carpet );

	TERRAIN_WoodenFloor:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_WoodenFloor );
	TERRAIN_WoodenWall:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_WoodenWall );

	TERRAIN_TileFloor:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_Floor );

	TERRAIN_Space:		DrawSprite( Terrain_Sprite , ZONE_Info , TCEL_Void );
	TERRAIN_MediumBuilding:	DrawSprite( building_sprite , ZONE_Info , ( ( X * 17 ) + ( Y * 71 ) ) mod 4 + 1 );
	TERRAIN_HighBuilding:	DrawSprite( building_sprite , ZONE_Info , ( ( X * 17 ) + ( Y * 71 ) ) mod 4 + 5 );

	TERRAIN_GlassWall:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_GlassWall );
	TERRAIN_LowBuilding:	DrawSprite( building_sprite , ZONE_Info , ( ( X * 17 ) + ( Y * 71 ) ) mod 4 + 15 );

	TERRAIN_L1_Water:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_L1Water );
	TERRAIN_L2_Water:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_L2Water );
	TERRAIN_L3_Water:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_L3Water );
	TERRAIN_Wreckage:	DrawSprite( terrain_sprite , ZONE_Info , TCEL_Wreckage );
	TERRAIN_Dirt:		DrawSprite( terrain_sprite , ZONE_Info , TCEL_Dirt );
	TERRAIN_Sand:		DrawSprite( terrain_sprite , ZONE_Info , TCEL_Sand );
	else DrawSprite( terrain_sprite , ZONE_Info , TCEL_Void );
	end;
	GameMsg( METerrGfx[ Pen ] + ' ' + MsgString( 'TerrNAME_' + BStr( Pen ) ) , ZONE_Info , METerrColor[ Pen ]^ );
{$ENDIF ASCII}
	T := TileTerrain( GB , X , Y );
	GameMsg( BStr( X ) + ',' + BStr( Y ) + ';' + BStr( T ) + ':' + MsgString( 'TerrNAME_' + BStr( T ) ) + #13 + Instructions , ZONE_Menu , StdWhite );
	RedrawConsole;
end;


Procedure ClearMap( GB: GameBoardPtr; Pen: Integer );
	{ Clear the map using the requested pen terrain. }
var
	X,Y: Integer;
begin
	for X := 1 to GB^.Map_Width do begin
		for Y := 1 to GB^.Map_Height do begin
			SetTerrain( GB , X , Y , Pen );
		end;
	end;
end;

Procedure EditCell( GB: GameBoardPtr; X , Y: Integer );
	{ if there's no cell in this tile, add one. If there is a cell }
	{ in this tile, rotate it. }
var
	Cell: GearPtr;
begin
	Cell := CellOnTile( GB , X , Y );
	if Cell = Nil then begin
		{ No cell. Add one. }
		{ At the moment, no check is made to make sure that cells don't }
		{ overlap. This could result in some massive uglification. }
		Cell := NewGear( Nil );
		AppendGear( GB^.Meks , Cell );
		Cell^.Stat[ STAT_PDMC_X ] := X;
		Cell^.Stat[ STAT_PDMC_Y ] := Y;
		Cell^.Stat[ STAT_PDMC_W ] := 5;
		Cell^.Stat[ STAT_PDMC_H ] := 5;
		Cell^.Stat[ STAT_PDMC_D ] := 0;
	end else begin
		Cell^.Stat[ STAT_PDMC_D ] := ( Cell^.Stat[ STAT_PDMC_D ] + 1 ) mod 4;
	end;
end;

Procedure DeleteCell( GB: GameBoardPtr; X , Y: Integer );
	{ if there's a cell in this tile, delete it. }
var
	Cell: GearPtr;
begin
	Cell := CellOnTile( GB , X , Y );
	if Cell <> Nil then begin
		RemoveGear( GB^.Meks , Cell );
	end;
end;


Procedure EditMap( GB: GameBoardPtr; const FName: String );
	{ Edit the given map. Save it to disk if need be. }
var
	X,Y: Integer;

	Procedure RepositionCursor( D: Integer );
	begin
		D := KeyboardDirToMapDir( D );

		if OnTheMap( GB , X + AngDir[ D , 1 ] , Y + AngDir[ D , 2 ] ) then begin
			X := X + AngDir[ D , 1 ];
			Y := Y + AngDir[ D , 2 ];
		end;
	end;

var
	A: CHar;
	Pen: Integer;
{$IFDEF ASCII}
{$ELSE ASCII}
	flag_mouse: Boolean;
	MousePressed: Boolean;
{$ENDIF ASCII}
begin
	{ Initialize our tools. }
	Pen := 1;
	X := 1;
	Y := 1;
	DialogMsg( 'Editing ' + fname + '.' );
{$IFDEF ASCII}
{$ELSE ASCII}
	DEBUG_CanSeeAll := True;
	InitGraphicsForScene( GB );
	flag_mouse := False;
	MousePressed := False;
{$ENDIF ASCII}

	repeat
{$IFDEF ASCII}
		MEDisplayMap( GB , X , Y );
{$ELSE ASCII}
		if flag_mouse then begin
			show_mapmouse_cursor := True;
		end else begin
			show_mapmouse_cursor := False;
		end;
		ScrollMap( GB );

		IndicateTile( GB , X , Y , 0 );
		RenderMap( GB , True );
		if Display_Mini_Map then DisplayMiniMap( GB );
{$ENDIF ASCII}
		MapEditInfo( GB , Pen , X , Y );
		DoFlip;

		A := RPGKeyEvent;

		if (KBD_NONE = A) then begin
		end else if A = KeyMap[ KMC_North ].KCode then begin
			RepositionCursor( 6 );
{$IFNDEF ASCII}
			flag_mouse := False;
{$ENDIF ASCII}

		end else if A = KeyMap[ KMC_South ].KCode then begin
			RepositionCursor( 2 );
{$IFNDEF ASCII}
			flag_mouse := False;
{$ENDIF ASCII}

		end else if A = KeyMap[ KMC_West ].KCode then begin
			RepositionCursor( 4 );
{$IFNDEF ASCII}
			flag_mouse := False;
{$ENDIF ASCII}

		end else if A = KeyMap[ KMC_East ].KCode then begin
			RepositionCursor( 0 );
{$IFNDEF ASCII}
			flag_mouse := False;
{$ENDIF ASCII}

		end else if A = KeyMap[ KMC_NorthEast ].KCode then begin
			RepositionCursor( 7 );
{$IFNDEF ASCII}
			flag_mouse := False;
{$ENDIF ASCII}

		end else if A = KeyMap[ KMC_SouthWest ].KCode then begin
			RepositionCursor( 3 );
{$IFNDEF ASCII}
			flag_mouse := False;
{$ENDIF ASCII}

		end else if A = KeyMap[ KMC_NorthWest ].KCode then begin
			RepositionCursor( 5 );
{$IFNDEF ASCII}
			flag_mouse := False;
{$ENDIF ASCII}

		end else if A = KeyMap[ KMC_SouthEast ].KCode then begin
			RepositionCursor( 1 );
{$IFNDEF ASCII}
			flag_mouse := False;
{$ENDIF ASCII}

		end else if A = ']' then begin
			Pen := Pen + 1;
			if Pen > NumTerr then pen := 1;

		end else if A = '[' then begin
			Pen := Pen - 1;
			if Pen < 1 then pen := NumTerr;

		end else if A = ' ' then begin
			SetTerrain( GB , X , Y , Pen );

{$IFDEF ASCII}
{$ELSE ASCII}
		end else if ( A = RPK_MouseMotion ) and OnTheMap( GB , Tile_x , Tile_y ) then begin
			flag_mouse := True;
			if MousePressed then begin
				SetTerrain( GB , Tile_X , Tile_Y , Pen );
			end;

		end else if ( A = RPK_MouseButtonRelease ) then begin
			flag_mouse := False;
			MousePressed := False;

		end else if ( A = RPK_MouseButton ) and OnTheMap( GB , Tile_X , Tile_Y ) then begin
			flag_mouse := True;
			MousePressed := True;
			SetTerrain( GB , Tile_X , Tile_Y , Pen );

		end else if ( A = RPK_RightButton ) and OnTheMap( GB , Tile_X , Tile_Y ) then begin
			flag_mouse := True;
			X := Tile_X;
			Y := Tile_Y;

		end else if A = KeyMap[ KMC_WallToggle ].KCode then begin
			Use_Tall_Walls := not Use_Tall_Walls;
{$ENDIF ASCII}

		end else if A = 'c' then begin
			EditCell( GB , X , Y );

		end else if A = 'd' then begin
			DeleteCell( GB , X , Y );

		end else if A = 'S' then begin
			DialogMsg( 'Saving...' );
			SavePredrawnMap( GB , FName );
			DialogMsg( 'Saved map ' + fname + '.' );


		end else if A = 'C' then begin
			ClearMap( GB , Pen );

		end;

	until A = 'Q';

	{ Get rid of the map. }
	DisposeMap( GB );
end;

Procedure RedrawOpening_GSFU( dummy: GearPtr );
	{ The opening menu redraw procedure. }
begin
	ClrScreen;
	InfoBox( ZONE_Menu );
	RedrawConsole;
end;

Procedure RedrawOpening;
	{ The opening menu redraw procedure. }
begin
	ClrScreen;
	InfoBox( ZONE_Menu );
	RedrawConsole;
end;

Procedure CreateNewMap;
	{ Create a brand new map and pass it to the editor. }
var
	fname: String;
	RPM: RPGMenuPtr;
	W,H,T: Integer;
	GB: GameBoardPtr;
begin
	fname := GetStringFromUser( 'Enter filename for this map.' , '' , @RedrawOpening_GSFU , NIL );
	if fname <> '' then begin
		RPM := 	CreateRPGMenu( MenuItem , MenuSelect , @ZONE_Menu );
		for t := 1 to 20 do AddRPGMenuItem( RPM , BSTr( t * 5 ) + ' tiles' , T * 5 );
		DialogMsg( 'Enter width' );
		W := SelectMenu( RPM , @RedrawOpening );
		if ( SELECTMENU_Enable <= W ) then begin
			DialogMsg( 'Enter height' );
			H := SelectMenu( RPM , @RedrawOpening );
			if ( SELECTMENU_Enable <= H ) then begin
				GB := NewMap( W , H );
				EditMap( GB , fname );
			end;
		end;
		DisposeRPGMenu( RPM );
	end;
end;

Procedure EditOldMap;
	{ Load an old map from disk and pass it to the editor. }
var
	fname: String;
	RPM: RPGMenuPtr;
	GB: GameBoardPtr;
begin
	RPM := 	CreateRPGMenu( MenuItem , MenuSelect , @ZONE_Menu );
	BuildFileMenu( RPM , Series_Directory + 'MAP_*.txt' , False );
	if RPM^.NumItem > 0 then begin
		fname := SelectFile( RPM , @RedrawOpening );
		if fname <> '' then begin
			GB := LoadPredrawnMap( fname );
			EditMap( GB , fname );
		end;
	end;
	DisposeRPGMenu( RPM );
end;

var
	RPM: RPGMenuPtr;
	N: Integer;

begin
	RPM := 	CreateRPGMenu( MenuItem , MenuSelect , @ZONE_Menu );
	AddRPGMenuItem( RPM , 'Create New Map' , 1 );
	AddRPGMenuItem( RPM , 'Load Existing Map' , 2 );
	AddRPGMenuItem( RPM , 'Exit MapEd' , SELECTMENU_Cancel );

	repeat
		N := SelectMenu( RPM , @RedrawOpening );
		Case N of
			1:	CreateNewMap;
			2:	EditOldMap;
		end;
	until ( SELECTMENU_Cancel = N );

	DisposeRPGMenu( RPM );
end.
