unit rnd;
{
	Copyright(C)2014 G-HAL
}
{$LONGSTRINGS ON}

interface

Procedure set_rndx(seed: LongWord);
Procedure init_rndx;
Function rndx(range: Word): Word;


implementation

{$IFDEF DEBUG}
uses	errmsg, texutil;
{$ENDIF DEBUG}

var
	RndWork: LongWord;


Procedure set_rndx(seed: LongWord);
begin
	RndWork := seed;
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: set_rndx:' + BStr(seed) );
{$ENDIF DEBUG}
end;


Procedure init_rndx;
begin
	set_rndx($00001F71);
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: init_rndx:' + BStr($00001F71) );
{$ENDIF DEBUG}
end;


Function rndx(range: Word): Word;
{$IFDEF PATCH_GH_PARANOID_SAFER}
var
	tmp: Word;
{$ELSE PATCH_GH_PARANOID_SAFER}
{$ENDIF PATCH_GH_PARANOID_SAFER}
begin
{$IFDEF PATCH_GH_PARANOID_SAFER}
	repeat
		RndWork := ((Int64(RndWork) * Int64(5) + Int64($32113573)) mod Int64($100000000));
		tmp := (RndWork mod $10000) xor (RndWork div $10000);
	until (LongWord(tmp) < ((LongWord($10000) div LongWord(range)) * LongWord(range)));
	rndx := tmp mod range;
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: rndx:' + BStr(tmp) + ',' + BStr(range) + ',' + BStr(rndx) );
{$ENDIF DEBUG}
{$ELSE PATCH_GH_PARANOID_SAFER}
	rndx := Random( range );
{$ENDIF PATCH_GH_PARANOID_SAFER}
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: rnd.pp');
{$ENDIF DEBUG}
	init_rndx();
	Randomize;
	set_rndx( Random( Int64( $FFFFFFFF ) ) );
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: rnd.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
{ End of File }
