unit sdlgfx;
{
	GearHead2, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}
{
	This is a 2DSD interface for GH2, because acronyms rock.
}

{$MODE FPC}
{$LONGSTRINGS ON}

{$IFDEF ASCII}
Interrupt compilation now.
{$ENDIF}

interface

uses sysutils,sdl,sdl_ttf,sdl_image,sdl_mixer,gears_base,gears,texutil,dos,ui4gh,description;

Type
	SensibleSpritePtr = ^SensibleSprite;
	SensibleSprite = Record
		Name,Color: String;
		W,H: Integer;	{ Width and Height of each cell. }
		Img: PSDL_Surface;
		Next: SensibleSpritePtr;
	end;

	RedrawProcedureType = Procedure;
	RedrawProcedureType_with_GearPtr = Procedure( M: GearPtr );

	DynamicRect_param = Object
		dx,dy,w,h: Integer;
	end;
	DynamicRect = Object
		org: DynamicRect_param;
		dx,dy,w,h,anchor: Integer;
		function GetRect: TSDL_Rect;
	end;
	DynamicRectPtr = ^DynamicRect;


const
	{ TSDL_Color tables was moved to ui4gh.pp . }

	Default_ScreenWidth = 800;
	Default_ScreenHeight = 600;
	Default_FontSize = 12;
	Default_SmallFontSize = 9;
	Default_InfoFontSize = 9;

	ScreenWidth: Integer = Default_ScreenWidth;
	ScreenHeight: Integer = Default_ScreenHeight;
	FontSize: Integer = Default_FontSize;
	SmallFontSize: Integer = Default_SmallFontSize;
	InfoFontSize: Integer = Default_InfoFontSize;

	Right_Column_Width = 180;

	ANC_upperleft = 0;
	ANC_upper = 1;
	ANC_upperright = 2;
	ANC_left = 3;
	ANC_middle = 4;
	ANC_right = 5;
	ANC_lowerleft = 6;
	ANC_lower = 7;
	ANC_lowerright = 8;

	ZONE_TextInputPrompt: DynamicRect = ( dx:-210; dy:-70; w:420; h:52; anchor: ANC_middle );
	ZONE_TextInput: DynamicRect = ( dx:-210; dy:-12; w:420; h:16; anchor: ANC_middle );
	ZONE_TextInputBigBox: DynamicRect = ( dx:-220; dy:-73; w:440; h:80; anchor: ANC_middle );
	ZONE_PhoneInstructions: DynamicRect = ( dx:-200; dy:15; w:400; h:16; anchor: ANC_middle );

	Model_Status_Width =   250;
	Model_Status_Height =  120;

	Console_History_Length = 240;
	Dialog_Area_Height = Model_Status_Height;

	ZONE_Info: DynamicRect = ( dx:  -Right_Column_Width - 10 ; dy:10; w:Right_Column_Width; h:150; anchor: ANC_upperright );
	ZONE_Menu: DynamicRect = ( dx:  -Right_Column_Width - 10 ; dy:170; w:Right_Column_Width; h:Default_ScreenHeight - 220 - Dialog_Area_Height; anchor: ANC_upperright );
	ZONE_Menu1: DynamicRect = ( dx:  -Right_Column_Width - 10 ; dy:170; w:Right_Column_Width; h:130; anchor: ANC_upperright );
	ZONE_Menu2: DynamicRect = ( dx:  -Right_Column_Width - 10 ; dy:300; w:Right_Column_Width; h:Default_ScreenHeight - 350 - Dialog_Area_Height; anchor: ANC_upperright );

	ZONE_Dialog: DynamicRect = ( dx: Model_Status_Width - 375; dy: -Model_Status_Height-10; w: 750 - Model_Status_Width; h: Model_Status_Height; anchor: ANC_lower );
	ZONE_PCStatus: DynamicRect = ( dx: -380; dy: -Model_Status_Height - 10; w: Model_Status_Width; h: Model_Status_Height; anchor: ANC_lower );

	KEY_REPEAT_DELAY = 200;
	KEY_REPEAT_INTERVAL = 75;


	ZONE_MoreText: DynamicRect = ( dx:-350; dy:-270; w: 700 ; h: 385; anchor: ANC_middle );
	ZONE_MorePrompt: DynamicRect = ( dx:-300; dy: 130 ; w:600; h:30; anchor: ANC_middle );

	ZONE_CharGenChar: DynamicRect = ( dx:-368; dy:-210; w: 500 ; h: 400; anchor: ANC_middle );
	ZONE_CharGenMenu: DynamicRect = ( dx:148; dy:-50; w:220; h:230; anchor: ANC_middle );
	ZONE_CharGenCaption: DynamicRect = ( dx:148; dy:190; w:220; h:20; anchor: ANC_middle );
	ZONE_CharGenDesc: DynamicRect = ( dx:148; dy:-210; w:220; h:150; anchor: ANC_middle );
	ZONE_CharGenPrompt: DynamicRect = ( dx:-150; dy:-245; w:300; h:20; anchor: ANC_middle );
	ZONE_CharGenHint: DynamicRect = ( dx:-160; dy:225; w:320; h:20; anchor: ANC_middle );

	ZONE_CharViewChar: DynamicRect = ( dx:-368; dy:-260; w: 500 ; h: 400; anchor: ANC_middle );
	ZONE_CharViewMenu: DynamicRect = ( dx:148; dy:-100; w:220; h:230; anchor: ANC_middle );
	ZONE_CharViewCaption: DynamicRect = ( dx:148; dy:140; w:220; h:20; anchor: ANC_middle );
	ZONE_CharViewDesc: DynamicRect = ( dx:148; dy:-260; w:220; h:150; anchor: ANC_middle );


	ZONE_ShopNPCName: DynamicRect = ( dx:-330; dy: -230; w: 100; h: 32; anchor: ANC_middle );
	ZONE_ShopNPCPortrait: DynamicRect = ( dx:-330; dy: -210; w: 100; h: 150; anchor: ANC_middle );
	ZONE_ShopText: DynamicRect = ( dx:-225; dy: -230; w: 287; h: 170; anchor: ANC_middle );
	ZONE_ShopPCName: DynamicRect = ( dx:-330; dy: -30; w: 100; h: 32; anchor: ANC_middle );
	ZONE_ShopPCPortrait: DynamicRect = ( dx:-330; dy: -10; w: 100; h: 150; anchor: ANC_middle );
	ZONE_ShopMenu: DynamicRect = ( dx:-225; dy: -35; w: 287; h: 190; anchor: ANC_middle );

	ZONE_ShopInfo: DynamicRect = (dx:85; dY:-225; W: 250; H: 340; anchor: ANC_middle);
	ZONE_ShopCash: DynamicRect = ( dx:135; dy: 130; w: 150; h: 16; anchor: ANC_middle );
	ZONE_ShopTop: DynamicRect = ( dx:-335; dy: -235; w: 402; h: 180; anchor: ANC_middle );
	ZONE_ShopBottom: DynamicRect = ( dx:-335; dy: -40; w: 402; h: 200; anchor: ANC_middle );

	Concert_Zone_Width = 500;
	Concert_X0 = -(Concert_Zone_Width div 2);
	Concert_X1 = Concert_X0 + 110;
	Concert_Text_Width = Concert_Zone_Width - 110;
	Concert_Zone_Height = 300;
	Concert_y0 = -180;
	Concert_Audience_Height = 140;
	Concert_Y1 = Concert_Y0 + Concert_Audience_Height + 10;
	ZONE_ConcertTotal: DynamicRect = ( dx: Concert_X0 ; dy: Concert_Y0; w: Concert_Zone_Width; h: Concert_Zone_Height; anchor: ANC_middle );
	ZONE_ConcertAudience: DynamicRect =  ( dx: Concert_X0 ; dy: Concert_Y0; w: Concert_Zone_Width; h: Concert_Audience_Height; anchor: ANC_middle );
	ZONE_ConcertCaption: DynamicRect =  ( dx: Concert_X1 ; dy: Concert_Y1; w: Concert_Text_Width; h: 40; anchor: ANC_middle );
	ZONE_ConcertMenu: DynamicRect =  ( dx: Concert_X1 ; dy: Concert_Y1 + 45; w: Concert_Text_Width; h: 80; anchor: ANC_middle );
	ZONE_ConcertDesc: DynamicRect =  ( dx: Concert_X1 ; dy: Concert_Y1 + 130; w: Concert_Text_Width; h: 20; anchor: ANC_middle );
	ZONE_ConcertPhoto:  DynamicRect =  ( dx: Concert_X0 ; dy: Concert_Y1; w: 100; h: 150; anchor: ANC_middle );

	ZONE_InteractStatus: DynamicRect = ( dx:-250; dy: -210; w: 395; h: 40; anchor: ANC_middle );
	ZONE_InteractMsg: DynamicRect = ( dx: -250; dy:-120; w:395; h: 110; anchor: ANC_middle );
	ZONE_InteractMenu: DynamicRect = ( dx: -250; dy:-5; w:500; h: 120; anchor: ANC_middle );
	ZONE_InteractPhoto: DynamicRect = ( dx: 150; dy: -185; w: 100; h: 150; anchor: ANC_middle );
	ZONE_InteractInfo: DynamicRect = ( dx: -250; dy:-165; w:395; h:40; anchor: ANC_middle );
	ZONE_InteractTotal: DynamicRect = ( dx: -255; dy: -215; w: 510; h: 335; anchor: ANC_middle );

	ZONE_CenterMenu: DynamicRect = ( dx:-120; dy:-155; w:240; h:210; anchor: ANC_middle );

	{ The ITEMS ZONE is used for both the backpack and shopping interfaces. }
	ItemsLeftWidth = 345;
	ItemsRightWidth = 225;
	ItemsZoneLeftTab = ( Default_ScreenWidth - ItemsLeftWidth - ItemsRightWidth - 10 ) div 2;
	ItemsZoneRightTab = ItemsZoneLeftTab + ItemsLeftWidth + 10;

	ZONE_ItemsInfo: DynamicRect = (dx:30; dY:-210; W: 250; H: 340; anchor: ANC_middle);
	//ZONE_ItemsPCInfo: TSDL_Rect = ( x: ItemsZoneRightTab; y:Default_ScreenHeight Div 2 + 70; w: ItemsRightWidth; h: 30 );

	ZONE_FHQTitle: DynamicRect = ( dx:-165; dy:-255; w:300; h:20; anchor: ANC_middle ); 
	ZONE_FieldHQMenu: DynamicRect = ( dx:-280; dy:-210; w:292; h:340; anchor: ANC_middle );
	ZONE_FHQMenu1: DynamicRect = ( dx:-280; dy:-210; w:292; h:180; anchor: ANC_middle );
	ZONE_FHQMenu2: DynamicRect = ( dx:-280; dy: -15; w:292; h:145; anchor: ANC_middle );

	ZONE_BPTotal: DynamicRect = (dx:-285; dY:-215; W: 570; H: 350; anchor: ANC_middle);
	ZONE_BPHeader: DynamicRect = (dx:-280; dY:-210; W: 292; H: 40; anchor: ANC_middle);
	ZONE_EqpMenu: DynamicRect = ( dx:-280; dy:-165; w:292; h:100; anchor: ANC_middle );
	ZONE_InvMenu: DynamicRect = ( dx:-280; dy:-60; w:292; h:145; anchor: ANC_middle );
	ZONE_BackpackInstructions: DynamicRect = (dx:-280; dY:90; W: 292; H: 40; anchor: ANC_middle);
	ZONE_BPInfo: DynamicRect = (dx:30; dY:-210; W: 250; H: 340; anchor: ANC_middle);

	CaptionWidth = Model_Status_Width;
	ZONE_Caption: DynamicRect = ( dx: -( CaptionWidth div 2 ); dy: 20; w: CaptionWidth; h: Model_Status_Height; anchor: ANC_upper );
	Default_SubCaptionWidth = Default_FontSize * 20;
	SubCaptionWidth: Integer = Default_SubCaptionWidth;
	ZONE_SubCaption: DynamicRect = ( dx: -( Default_SubCaptionWidth div 2 ); dy: 35 + Model_Status_Height; w: Default_SubCaptionWidth; h: Default_FontSize + 2; anchor: ANC_upper );

//	ZONE_CharacterInfo: TSDL_Rect = ( x: Default_ScreenWidth div 2 - 275; y: Default_ScreenHeight Div 2 - 200; w: 450; h: 295 );

	Default_SideInfoWidth = Default_FontSize * 16;
	Default_SideInfoHeight = ( Default_FontSize + 2 ) * 6;
	SideInfoWidth: Integer = Default_SideInfoWidth;
	SideInfoHeight: Integer = Default_SideInfoHeight;
	ZONE_RightInfo: DynamicRect = ( dx: -Default_SideInfoWidth - 10; dy: 15; w: Default_SideInfoWidth; h: Default_SideInfoHeight; anchor: ANC_upperright );
	ZONE_LeftInfo: DynamicRect = ( dx: 10; dy: 15; w: Default_SideInfoWidth; h: Default_SideInfoHeight; anchor: ANC_upperleft );

	ZONE_GetItemMenu: DynamicRect = ( dx:-100; dy:-125; w:200; h:250; anchor: ANC_middle );

	//ZONE_UsagePrompt: TSDL_Rect = ( x:500; y:190; w:130; h:170 );
	//ZONE_UsageMenu: TSDL_Rect = ( x:50; y:155; w:380; h:245 );

	ZONE_MemoText: DynamicRect = ( dx:-175; dy:-150; w:350; h:200; anchor: ANC_middle );
	ZONE_MemoMenu: DynamicRect = ( dx:-175; dy:55; w:350; h:50; anchor: ANC_middle );
	ZONE_MemoTotal: DynamicRect = ( dx:-180; dy:-155; w:360; h:265; anchor: ANC_middle );

	{ The SelectArenaMission zones. }
	ZONE_SAMMenu: DynamicRect = ( dx:-200; dy:-190; w:400; h:200; anchor: ANC_middle );
	ZONE_SAMText: DynamicRect = ( dx:-200; dy:25; w:400; h:50; anchor: ANC_middle );
	ZONE_SAMTotal: DynamicRect = ( dx:-205; dy:-195; w:410; h:265; anchor: ANC_middle );

	ZONE_WorldMap_org: TSDL_Rect = ( x: Default_ScreenWidth div 2 - 160; y: Default_ScreenHeight div 2 - 160; W:320; H:320 );
	ZONE_WorldMap: TSDL_Rect = ( x: Default_ScreenWidth div 2 - 160; y: Default_ScreenHeight div 2 - 160; W:320; H:320 );

	ZONE_Clock: DynamicRect = ( dx: -150; dy: 30; w: 120; H:20; anchor: ANC_upperright );

	Monologue_Width = 400;
	Monologue_Height = 205;
	ZONE_MonologueTotal: DynamicRect = ( dx: -210; dy: -150; w: Monologue_Width + 20; h: Monologue_Height + 20; anchor: ANC_middle );
	ZONE_MonologueInfo: DynamicRect = ( dx: -200; dy: -150; w: Monologue_Width; h:30; anchor: ANC_middle );
	ZONE_MonologueText: DynamicRect = ( dx: -200; dy: -110; w: Monologue_Width - 110; h: Monologue_Height - 40; anchor: ANC_middle );
	ZONE_MonologuePortrait: DynamicRect = ( dx: 100; dy: -110; w: 100; h: 150; anchor: ANC_middle );

	Arena_List_Width = 240;
	Arena_List_Height = Default_ScreenHeight - ( Dialog_Area_Height + 40 );
	ZONE_ArenaPilotMenu: DynamicRect = ( dx: -390; dy: -290; w: Arena_List_Width; h: Arena_List_Height; anchor: ANC_middle );
	ZONE_ArenaMechaMenu: DynamicRect = ( dx: -110; dy: -290; w: Arena_List_Width; h: Arena_List_Height; anchor: ANC_middle );
	ZONE_ArenaInfo: DynamicRect = ( dx: 150; dy: -290; w: ItemsRightWidth; h: Arena_List_Height; anchor: ANC_middle );

	ZONE_Title_Screen_Version: DynamicRect = ( dx:-300; dy:-25; w:600; h:20; anchor: ANC_lower );
	ZONE_Title_Screen_Menu: DynamicRect = ( dx:-100; dy:50; w:200; h:115; anchor: ANC_middle );
	ZONE_TitleLogo:  DynamicRect =  ( dx: -312; dy: -161; w: 624; h: 162; anchor: ANC_Middle );

	Animation_Phase_Period = 6000;

	UTF8_Width_Of_One_Character: String = 'M';

	TAG_CUSTOMIZATION_EMBLEM = 'CUSTOMIZATION_EMBLEM';
	EMBLEM_PREFIX = 'emblem_';
	EMBLEM_DEFAULT = 'star.psc';
	EMBLEM_SUFFIX = '.png';

var
	Actual_Screen,Game_Screen: PSDL_Surface;
	Game_Font,Small_Font,Info_Font: PTTF_Font;
	Game_Sprites: SensibleSpritePtr;
	Last_Clock_Update: QWord;
	Animation_Phase: Integer;
	Mouse_X, Mouse_Y: LongInt;
	Cursor_Sprite: SensibleSpritePtr;
	Console_History: SAttListPtr;
	Title_Screen,Title_Stars,Title_Logo: SensibleSpritePtr;
	Ersatz_Mouse_Sprite: SensibleSpritePtr;

	RK_NumKeys:	PInt;
	RK_KeyState:	PUInt8;

Procedure DoFlip;

Function UTF8_TTF_RenderText(var font: PTTF_Font; const msg: String; var fg: TSDL_Color ): PSDL_Surface;
Procedure QuickText( msg: String; MyDest: TSDL_Rect; C: TSDL_Color; F: PTTF_Font );
Procedure QuickTextC( msg: String; MyDest: TSDL_Rect; C: TSDL_Color; F: PTTF_Font );
Procedure QuickTextCenter( msg: String; MyDest: TSDL_Rect; C: TSDL_Color; F: PTTF_Font );
Procedure QuickTextRJ( msg: String; MyDest: TSDL_Rect; C: TSDL_Color; F: PTTF_Font );

Procedure DisposeSpriteList(var LList: SensibleSpritePtr);
Procedure RemoveSprite(var LMember: SensibleSpritePtr);

procedure DrawSprite( Spr: SensibleSpritePtr; MyDest: TSDL_Rect; Frame: Integer );
procedure DrawSprite( Spr: SensibleSpritePtr; MyCanvas: PSDL_Surface; MyDest: TSDL_Rect; Frame: Integer );

function LocateSprite( const Name, Color: String; W,H: Integer ): SensibleSpritePtr;
function LocateSprite( const Name: String; W,H: Integer ): SensibleSpritePtr;

Procedure CleanSpriteList;

Procedure PlaySoundEffect_Direct( const Name: String );

function RPGKey: Char;
Function RPGKeyEvent: Char;


Procedure ClrZone( const Z: TSDL_Rect );
Procedure ClrScreen;
Procedure ClrScreen_wM( M: GearPtr );

Procedure GetNextLine( var TheLine , msg , NextWord: String; Width: Integer; MyFont: PTTF_Font );
Function PrettyPrint( msg: string; Width: Integer; var FG: TSDL_Color; DoCenter: Boolean; MyFont: PTTF_Font ): PSDL_Surface;
Function PrettyPrint( msg: string; Width: Integer; var FG: TSDL_Color; DoCenter: Boolean ): PSDL_Surface;
Procedure CMessage( msg: String; Z: TSDL_Rect; C: TSDL_Color; MyFont: PTTF_Font );
Procedure CMessage( msg: String; Z: TSDL_Rect; C: TSDL_Color );
Procedure CMessage( msg: String; DZ: DynamicRect; C: TSDL_Color );
Procedure GameMSG( msg: string; Z: TSDL_Rect; C: TSDL_Color; MyFont: PTTF_Font );
Procedure GameMSG( msg: string; Z: TSDL_Rect; C: TSDL_Color );
Procedure GameMSG( msg: string; DZ: DynamicRect; C: TSDL_Color );

Function IsMoreKey( A: Char ): Boolean;
Procedure MoreKey;
Function TextLength( F: PTTF_Font; msg: String ): LongInt;

Function GetStringFromUser( const Prompt: String; const DefaultSearchPattern: String; ReDrawer: RedrawProcedureType_with_GearPtr; M: GearPtr ): String;
Function GetStringFromUser( const Prompt: String; const DefaultSearchPattern: String; ReDrawer: RedrawProcedureType_with_GearPtr; M: GearPtr; var Cancelled: Boolean ): String;

Procedure MoreText( LList: SAttListPtr; FirstLine: Integer; ReDrawer: RedrawProcedureType );

Procedure RedrawConsole;
Procedure DialogMsg(msg: string);

Procedure ClearExtendedBorder( Dest: TSDL_Rect );

Procedure DrawBPBorder;
Procedure DrawGetItemBorder;
Procedure SetupInteractDisplay( TeamColor: TSDL_Color );
Procedure SetupServicesDisplay;
Procedure SetupFHQDisplay;
Procedure SetupMemoDisplay;
Procedure DrawMonologueBorder;

Procedure FillRectWithSprite( MyRect: TSDL_Rect; MySprite: SensibleSpritePtr; MyFrame,OffX,OffY: Integer );
Procedure FillRectWithSprite( MyRect: TSDL_Rect; MySprite: SensibleSpritePtr; MyFrame: Integer );

Procedure InfoBox( MyBox: TSDL_Rect );
Procedure InfoBox( MyBox: DynamicRect );

Procedure Idle_Display;

Procedure SetupArenaDisplay;
Procedure SetupArenaMissionMenu;
Procedure SetupConcertDisplay;
Procedure SetupTitleScreenDisplay;

implementation

uses
{$IFDEF Unix}
	xlib,
{$ENDIF Unix}
{$IFDEF Windows}
	windows,
{$ENDIF Windows}
	strings,math,errmsg,utf8msg,sdlmenus
{$IF DEFINED(Windows) AND DEFINED(WITHOUT_SDLIM)}
	,w32eb
{$ENDIF}
	;

type
	SensibleSoundEffectListPtr = ^SensibleSoundEffectList;
	SensibleSoundEffectList = Record
		Name: String;
		Chunk: PMix_Chunk;
		Next: SensibleSoundEffectListPtr;
	end;

const
	WindowName: PChar = 'GearHead II';
	IconName: PChar = 'GearHead II';

var
	SDL_VideoModeFlag: LongWord;
	Infobox_Border,Infobox_Backdrop: SensibleSpritePtr;
	MoreTextRedrawer: RedrawProcedureType;
	wmi: TSDL_SysWMinfo;
{$IFDEF Unix}
	gX11_Lock : procedure();
	gX11_Unlock : procedure();
{$ENDIF Unix}
{$IFDEF Windows}
	r: Windows.RECT;
{$ENDIF Windows}
	SoundEffectList: SensibleSoundEffectListPtr;


Function DynamicRect.GetRect: TSDL_Rect;
	{ Return the TSDL_Rect described by this DynamicRect, given the current }
	{ screen size. }
var
	MyRect: TSDL_Rect;
begin
	MyRect.W := Self.W;
	MyRect.H := Self.H;
	MyRect.X := Game_Screen^.W * (self.anchor mod 3) div 2 + Self.DX;
	MyRect.Y := Game_Screen^.H * (self.anchor div 3) div 2 + Self.DY;
	GetRect := MyRect;
end;


Procedure Reset_SIZE;
	Procedure Reset_DynamicRect( var Rect: DynamicRect );
	begin
		Rect.org.dx := Rect.dx;
		Rect.org.dy := Rect.dy;
		Rect.org.w := Rect.w;
		Rect.org.h := Rect.h;
	end;
begin
	FontSize := FontSize_Big;
	SmallFontSize := FontSize_Small;
	InfoFontSize := FontSize_Info;

	SubCaptionWidth := FontSize * 20;

	SideInfoWidth := FontSize * 16;
	SideInfoHeight := ( FontSize + 2 ) * 6;

	Reset_DynamicRect( ZONE_Clock );
	Reset_DynamicRect( ZONE_TextInputPrompt );
	Reset_DynamicRect( ZONE_TextInput );
	Reset_DynamicRect( ZONE_TextInputBigBox );
	Reset_DynamicRect( ZONE_PhoneInstructions );
	Reset_DynamicRect( ZONE_Info );
	Reset_DynamicRect( ZONE_Menu );
	Reset_DynamicRect( ZONE_Menu1 );
	Reset_DynamicRect( ZONE_Menu2 );
	Reset_DynamicRect( ZONE_Dialog );
	Reset_DynamicRect( ZONE_PCStatus );
	Reset_DynamicRect( ZONE_MoreText );
	Reset_DynamicRect( ZONE_MorePrompt );
	Reset_DynamicRect( ZONE_CharGenChar );
	Reset_DynamicRect( ZONE_CharGenMenu );
	Reset_DynamicRect( ZONE_CharGenCaption );
	Reset_DynamicRect( ZONE_CharGenDesc );
	Reset_DynamicRect( ZONE_CharGenPrompt );
	Reset_DynamicRect( ZONE_CharGenHint );
	Reset_DynamicRect( ZONE_CharViewChar );
	Reset_DynamicRect( ZONE_CharViewMenu );
	Reset_DynamicRect( ZONE_CharViewCaption );
	Reset_DynamicRect( ZONE_CharViewDesc );
	Reset_DynamicRect( ZONE_ShopNPCName );
	Reset_DynamicRect( ZONE_ShopNPCPortrait );
	Reset_DynamicRect( ZONE_ShopText );
	Reset_DynamicRect( ZONE_ShopPCName );
	Reset_DynamicRect( ZONE_ShopPCPortrait );
	Reset_DynamicRect( ZONE_ShopMenu );
	Reset_DynamicRect( ZONE_ShopInfo );
	Reset_DynamicRect( ZONE_ShopCash );
	Reset_DynamicRect( ZONE_ShopTop );
	Reset_DynamicRect( ZONE_ShopBottom );
	Reset_DynamicRect( ZONE_ConcertTotal );
	Reset_DynamicRect( ZONE_ConcertAudience );
	Reset_DynamicRect( ZONE_ConcertCaption );
	Reset_DynamicRect( ZONE_ConcertMenu );
	Reset_DynamicRect( ZONE_ConcertDesc );
	Reset_DynamicRect( ZONE_ConcertPhoto );
	Reset_DynamicRect( ZONE_InteractStatus );
	Reset_DynamicRect( ZONE_InteractMsg );
	Reset_DynamicRect( ZONE_InteractMenu );
	Reset_DynamicRect( ZONE_InteractPhoto );
	Reset_DynamicRect( ZONE_InteractInfo );
	Reset_DynamicRect( ZONE_InteractTotal );
	Reset_DynamicRect( ZONE_CenterMenu );
	Reset_DynamicRect( ZONE_ItemsInfo );
	Reset_DynamicRect( ZONE_FHQTitle );
	Reset_DynamicRect( ZONE_FieldHQMenu );
	Reset_DynamicRect( ZONE_FHQMenu1 );
	Reset_DynamicRect( ZONE_FHQMenu2 );
	Reset_DynamicRect( ZONE_BPTotal );
	Reset_DynamicRect( ZONE_BPHeader );
	Reset_DynamicRect( ZONE_EqpMenu );
	Reset_DynamicRect( ZONE_InvMenu );
	Reset_DynamicRect( ZONE_BackpackInstructions );
	Reset_DynamicRect( ZONE_BPInfo );
	Reset_DynamicRect( ZONE_Caption );
	Reset_DynamicRect( ZONE_SubCaption );
	Reset_DynamicRect( ZONE_RightInfo );
	Reset_DynamicRect( ZONE_LeftInfo );
	Reset_DynamicRect( ZONE_GetItemMenu );
	Reset_DynamicRect( ZONE_MemoText );
	Reset_DynamicRect( ZONE_MemoMenu );
	Reset_DynamicRect( ZONE_MemoTotal );
	Reset_DynamicRect( ZONE_SAMMenu );
	Reset_DynamicRect( ZONE_SAMText );
	Reset_DynamicRect( ZONE_SAMTotal );
	Reset_DynamicRect( ZONE_Clock );
	Reset_DynamicRect( ZONE_MonologueTotal );
	Reset_DynamicRect( ZONE_MonologueInfo );
	Reset_DynamicRect( ZONE_MonologueText );
	Reset_DynamicRect( ZONE_MonologuePortrait );
	Reset_DynamicRect( ZONE_ArenaPilotMenu );
	Reset_DynamicRect( ZONE_ArenaMechaMenu );
	Reset_DynamicRect( ZONE_ArenaInfo );
	Reset_DynamicRect( ZONE_Title_Screen_Version );
	Reset_DynamicRect( ZONE_Title_Screen_Menu );
	Reset_DynamicRect( ZONE_TitleLogo );
end;


Procedure Preset_ZONE_Clock;
var
	s: String;
	zone_width: Integer;
begin
	if ( NIL <> Game_Font ) then begin
		s := TimeString( ( ( 9999 * 24 + 23 ) * 60 + 59 ) * 60 + 59 );
		zone_width := TextLength( Game_Font , UTF8_Width_Of_One_Character + s + UTF8_Width_Of_One_Character );
		ZONE_Clock.dx := ZONE_Clock.dx - zone_width;
		ZONE_Clock.w := ZONE_Clock.w + zone_width;
	end;
end;

Procedure Preset_SIZE( width, height: Integer );
	Procedure Set_SDLrect( org: SDL_Rect; var Rect: SDL_Rect );
	begin
		if 0 < width then begin
			Rect.w := org.w * width div Default_ScreenWidth;
			Rect.x := org.x * width div Default_ScreenWidth;
		end;
		if 0 < height then begin
			Rect.h := org.h * height div Default_ScreenHeight;
			Rect.y := org.y * height div Default_ScreenHeight;
		end;
	end;
	Procedure Set_DynamicRect( var Rect: DynamicRect );
	begin
		if 0 < width then begin
			Rect.w := Rect.org.w * width div Default_ScreenWidth;
			Rect.dx := Rect.org.dx * width div Default_ScreenWidth;
		end;
		if 0 < height then begin
			Rect.h := Rect.org.h * height div Default_ScreenHeight;
			Rect.dy := Rect.org.dy * height div Default_ScreenHeight;
		end;
	end;
	Procedure Set_DynamicRect_portrait( var Rect: DynamicRect );
	var
		Rect_New: DynamicRect;
	begin
		if 0 < width then begin
			Rect_New.w := Rect.org.w * width div Default_ScreenWidth;
			Rect_New.dx := Rect.org.dx * width div Default_ScreenWidth;
			Rect.dx := Rect_New.dx + ( ( Rect_New.w - Rect.org.w ) * (Rect.anchor mod 3) div 2 );
		end;
		if 0 < height then begin
			Rect_New.h := Rect.org.h * height div Default_ScreenHeight;
			Rect_New.dy := Rect.org.dy * height div Default_ScreenHeight;
			Rect.dy := Rect_New.dy + ( ( Rect_New.h - Rect.org.h ) * (Rect.anchor mod 3) div 2 );
		end;
	end;
begin
	ZONE_SubCaption.dx := - ( SubCaptionWidth div 2 );
	ZONE_SubCaption.dy := 35 + Model_Status_Height;
	ZONE_SubCaption.w := SubCaptionWidth;
	ZONE_SubCaption.h := FontSize + 2;

	ZONE_RightInfo .dx :=  - SideInfoWidth - 10;
	ZONE_RightInfo .dy :=  15;
	ZONE_RightInfo .w :=  SideInfoWidth; ZONE_RightInfo .h :=  SideInfoHeight;
	ZONE_LeftInfo  .dx :=  10;
	ZONE_LeftInfo  .dy :=  15;
	ZONE_LeftInfo  .w :=  SideInfoWidth; ZONE_LeftInfo  .h :=  SideInfoHeight;

	if (0 < width) or (0 < height) then begin
		Set_DynamicRect( ZONE_TextInputPrompt );
		Set_DynamicRect( ZONE_TextInput );
		Set_DynamicRect( ZONE_TextInputBigBox );
		Set_DynamicRect( ZONE_PhoneInstructions );
		Set_DynamicRect( ZONE_Info );
		Set_DynamicRect( ZONE_Menu );
		Set_DynamicRect( ZONE_Menu1 );
		Set_DynamicRect( ZONE_Menu2 );
		Set_DynamicRect( ZONE_Dialog );
		Set_DynamicRect( ZONE_PCStatus );
		Set_DynamicRect( ZONE_MoreText );
		Set_DynamicRect( ZONE_MorePrompt );
		Set_DynamicRect( ZONE_CharGenChar );
		Set_DynamicRect( ZONE_CharGenMenu );
		Set_DynamicRect( ZONE_CharGenCaption );
		Set_DynamicRect( ZONE_CharGenDesc );
		Set_DynamicRect( ZONE_CharGenPrompt );
		Set_DynamicRect( ZONE_CharGenHint );
		Set_DynamicRect( ZONE_CharViewChar );
		Set_DynamicRect( ZONE_CharViewMenu );
		Set_DynamicRect( ZONE_CharViewCaption );
		Set_DynamicRect( ZONE_CharViewDesc );
		Set_DynamicRect( ZONE_ShopNPCName );
		Set_DynamicRect_portrait( ZONE_ShopNPCPortrait );
		Set_DynamicRect( ZONE_ShopText );
		Set_DynamicRect( ZONE_ShopPCName );
		Set_DynamicRect_portrait( ZONE_ShopPCPortrait );
		Set_DynamicRect( ZONE_ShopMenu );
		Set_DynamicRect( ZONE_ShopInfo );
		Set_DynamicRect( ZONE_ShopCash );
		Set_DynamicRect( ZONE_ShopTop );
		Set_DynamicRect( ZONE_ShopBottom );
		Set_DynamicRect( ZONE_ConcertTotal );
		Set_DynamicRect( ZONE_ConcertAudience );
		Set_DynamicRect( ZONE_ConcertCaption );
		Set_DynamicRect( ZONE_ConcertMenu );
		Set_DynamicRect( ZONE_ConcertDesc );
		Set_DynamicRect_portrait( ZONE_ConcertPhoto );
		Set_DynamicRect( ZONE_InteractStatus );
		Set_DynamicRect( ZONE_InteractMsg );
		Set_DynamicRect( ZONE_InteractMenu );
		Set_DynamicRect_portrait( ZONE_InteractPhoto );
		Set_DynamicRect( ZONE_InteractInfo );
		Set_DynamicRect( ZONE_InteractTotal );
		Set_DynamicRect( ZONE_CenterMenu );
		Set_DynamicRect( ZONE_ItemsInfo );
		Set_DynamicRect( ZONE_FHQTitle );
		Set_DynamicRect( ZONE_FieldHQMenu );
		Set_DynamicRect( ZONE_FHQMenu1 );
		Set_DynamicRect( ZONE_FHQMenu2 );
		Set_DynamicRect( ZONE_BPTotal );
		Set_DynamicRect( ZONE_BPHeader );
		Set_DynamicRect( ZONE_EqpMenu );
		Set_DynamicRect( ZONE_InvMenu );
		Set_DynamicRect( ZONE_BackpackInstructions );
		Set_DynamicRect( ZONE_BPInfo );
		Set_DynamicRect( ZONE_Caption );
		Set_DynamicRect( ZONE_SubCaption );
		Set_DynamicRect( ZONE_RightInfo );
		Set_DynamicRect( ZONE_LeftInfo );
		Set_DynamicRect( ZONE_GetItemMenu );
		Set_DynamicRect( ZONE_MemoText );
		Set_DynamicRect( ZONE_MemoMenu );
		Set_DynamicRect( ZONE_MemoTotal );
		Set_DynamicRect( ZONE_SAMMenu );
		Set_DynamicRect( ZONE_SAMText );
		Set_DynamicRect( ZONE_SAMTotal );
		Set_SDLrect( ZONE_WorldMap_org , ZONE_WorldMap );
		Set_DynamicRect( ZONE_Clock );
		Set_DynamicRect( ZONE_MonologueTotal );
		Set_DynamicRect( ZONE_MonologueInfo );
		Set_DynamicRect( ZONE_MonologueText );
		Set_DynamicRect_portrait( ZONE_MonologuePortrait );
		Set_DynamicRect( ZONE_ArenaPilotMenu );
		Set_DynamicRect( ZONE_ArenaMechaMenu );
		Set_DynamicRect( ZONE_ArenaInfo );
		Set_DynamicRect( ZONE_Title_Screen_Version );
		Set_DynamicRect( ZONE_Title_Screen_Menu );
		Set_DynamicRect( ZONE_TitleLogo );

		ScreenWidth  := width;
		ScreenHeight := height;

		Preset_ZONE_Clock;
	end;
end;



Procedure DoFlip;
	{ Flip out, man! This flips from the newly drawn screen to the physical screen. }
	{ Go look up Double Buffering on Wikipedia for more info. }
var
	MyDest: TSDL_Rect;
begin
	if Ersatz_Mouse then begin
		MyDest.X := Mouse_X;
		MyDest.Y := Mouse_Y;
		DrawSprite( Ersatz_Mouse_Sprite , MyDest , 0 );
	end;
	SDL_Flip( Game_Screen );
	Animation_Phase := ( Animation_Phase + 1 ) mod Animation_Phase_Period;
end;

Function UTF8_TTF_RenderText(var font: PTTF_Font; const msg: String; var fg: TSDL_Color ): PSDL_Surface;
var
	pline: PChar;
	bg: TSDL_Color;
begin
	pline := QuickPCopy( msg );
	if not(SDL_AAFont) and not(SDL_AAFont_Shaded) then begin
		UTF8_TTF_RenderText := TTF_RenderUTF8_Solid( font , pline , fg );
	end else if SDL_AAFont_Shaded then begin
		bg.r := 0;
		bg.b := 0;
		bg.g := 0;
		UTF8_TTF_RenderText := TTF_RenderUTF8_Shaded( font , pline , fg , bg );
	end else begin
		UTF8_TTF_RenderText := TTF_RenderUTF8_Blended( font , pline , fg );
	end;
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
	sysutils.StrDispose( pline );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
end;

Procedure QuickText( msg: String; MyDest: TSDL_Rect; C: TSDL_Color; F: PTTF_Font );
	{ Quickly draw some text to the screen, without worrying about }
	{ line-splitting or justification or anything. }
var
	MyText: PSDL_Surface;
begin
	MyText := UTF8_TTF_RenderText( F , msg , C );
	SDL_BlitSurface( MyText , Nil , Game_Screen , @MyDest );
	SDL_FreeSurface( MyText );
end;

Procedure QuickTextC( msg: String; MyDest: TSDL_Rect; C: TSDL_Color; F: PTTF_Font );
	{ Quickly draw some text to the screen, without worrying about }
	{ line-splitting or justification or anything. }
	{ The text will be centered in the given zone. }
var
	MyText: PSDL_Surface;
begin
	if msg = '' then Exit;
	MyText := UTF8_TTF_RenderText( F , msg , C );
	MyDest.X := MyDest.X + ( MyDest.W - MyText^.W ) div 2;
	SDL_BlitSurface( MyText , Nil , Game_Screen , @MyDest );
	SDL_FreeSurface( MyText );
end;

Procedure QuickTextCenter( msg: String; MyDest: TSDL_Rect; C: TSDL_Color; F: PTTF_Font );
	{ Quickly draw some text to the screen, without worrying about }
	{ line-splitting or justification or anything. }
	{ The text will be centered in the given zone. }
var
	MyText: PSDL_Surface;
begin
	if msg = '' then Exit;
	MyText := UTF8_TTF_RenderText( F , msg , C );
	MyDest.X := MyDest.X + ( MyDest.W - MyText^.W ) div 2;
	MyDest.Y := MyDest.Y + ( MyDest.H - MyText^.H ) div 2;
	SDL_BlitSurface( MyText , Nil , Game_Screen , @MyDest );
	SDL_FreeSurface( MyText );
end;

Procedure QuickTextRJ( msg: String; MyDest: TSDL_Rect; C: TSDL_Color; F: PTTF_Font );
	{ Quickly draw some text to the screen, without worrying about }
	{ line-splitting or justification or anything. }
	{ This variation on the procedure is right-justified. }
var
	MyText: PSDL_Surface;
begin
	MyText := UTF8_TTF_RenderText( F , msg , C );
	MyDest.X := MyDest.X - MyText^.W;
	SDL_BlitSurface( MyText , Nil , Game_Screen , @MyDest );
	SDL_FreeSurface( MyText );
end;

Procedure DrawAnimImage( Image,Canvas: PSDL_Surface; W,H,Frame: Integer; var MyDest: TSDL_Rect );
	{ This procedure is modeled after the command from Blitz Basic. }
var
	MySource: TSDL_Rect;
begin
	MySource.W := W;
	MySource.H := H;
	if W > Image^.W then W := Image^.W;
	MySource.X := ( Frame mod ( Image^.W div W ) ) * W;
	MySource.Y := ( Frame div ( Image^.W div W ) ) * H;

	SDL_BlitSurface( Image , @MySource , Canvas , @MyDest );
end;

Function ScaleColorValue( V , I: Integer ): Byte;
	{ Scale a color value. }
begin
	V := ( V * I ) div 200;
	if V > 255 then V := 255;
	ScaleColorValue := V;
end;


Function MakeSwapBitmap( MyImage: PSDL_Surface; RSwap,YSwap,GSwap: PSDL_Color ): PSDL_Surface;
	{ Given a bitmap, create an 8-bit copy with pure colors. }
	{         0 : Transparent (0,0,255) }
	{   1 -  63 : Grey Scale            }
	{  64 - 127 : Pure Red              }
	{ 128 - 191 : Pure Yellow           }
	{ 192 - 255 : Pure Green            }
	{ Then, swap those colors out for the requested colors. }
var
	MyPal: Array [0..255] of TSDL_Color;
	T: Integer;
	MyImage2: PSDL_Surface;
begin
	{ Initialize the palette. }
	for t := 1 to 64 do begin
		MyPal[ T - 1 ].r := ( t * 4 ) - 1;
		MyPal[ T - 1 ].g := ( t * 4 ) - 1;
		MyPal[ T - 1 ].b := ( t * 4 ) - 1;

		MyPal[ T + 63 ].r := ( t * 4 ) - 1;
		MyPal[ T + 63 ].g := 0;
		MyPal[ T + 63 ].b := 0;

		MyPal[ T + 127 ].r := ( t * 4 ) - 1;
		MyPal[ T + 127 ].g := ( t * 4 ) - 1;
		MyPal[ T + 127 ].b := 0;

		MyPal[ T + 191 ].r := 0;
		MyPal[ T + 191 ].g := ( t * 4 ) - 1;
		MyPal[ T + 191 ].b := 0;
	end;
	MyPal[ 0 ].r := SDLTransparentColor.R;
	MyPal[ 0 ].g := SDLTransparentColor.G;
	MyPal[ 0 ].b := SDLTransparentColor.B;

	{ Create replacement surface. }
	MyImage2 := SDL_CreateRGBSurface( SDL_SWSURFACE , MyImage^.W , MyImage^.H , 8 , 0 , 0 , 0 , 0 );
	SDL_SetPalette( MyImage2 , SDL_LOGPAL or SDL_PHYSPAL , MyPal , 0 , 256 );
	SDL_FillRect( MyImage2 , Nil , SDL_MapRGB( MyImage2^.Format , SDLTransparentColor.R , SDLTransparentColor.G , SDLTransparentColor.B ) );
	SDL_SetColorKey( MyImage2 , SDL_SRCCOLORKEY or SDL_RLEACCEL , SDL_MapRGB( MyImage2^.Format , SDLTransparentColor.R , SDLTransparentColor.G, SDLTransparentColor.B ) );

	{ Blit from the original to the copy. }
	SDL_BlitSurface( MyImage , Nil , MyImage2 , Nil );

	{ Redefine the palette. }
	for t := 1 to 64 do begin
		MyPal[ T + 63 ].r := ScaleColorValue( RSwap^.R , t * 4 );
		MyPal[ T + 63 ].g := ScaleColorValue( RSwap^.G , t * 4 );
		MyPal[ T + 63 ].b := ScaleColorValue( RSwap^.B , t * 4 );

		MyPal[ T + 127 ].r := ScaleColorValue( YSwap^.R , t * 4 );
		MyPal[ T + 127 ].g := ScaleColorValue( YSwap^.G , t * 4 );
		MyPal[ T + 127 ].b := ScaleColorValue( YSwap^.B , t * 4 );

		MyPal[ T + 191 ].r := ScaleColorValue( GSwap^.R , t * 4 );
		MyPal[ T + 191 ].g := ScaleColorValue( GSwap^.G , t * 4 );
		MyPal[ T + 191 ].b := ScaleColorValue( GSwap^.B , t * 4 );
	end;
	SDL_SetPalette( MyImage2 , SDL_LOGPAL or SDL_PHYSPAL , MyPal , 0 , 256 );

	MakeSwapBitmap := MyImage2;
end;

Function MakeSwapBitmapRYGA( MyImage: PSDL_Surface; RSwap,YSwap,GSwap: PSDL_Color ): PSDL_Surface;
	{ Swap those colors out for the requested colors. }
var
	MyImage2: PSDL_Surface;
	flags: UInt32;
	ret: Integer;
	bpp, w, h: Integer;
	pitch: Uint16;
	pixels: Pointer;
	x, y: Integer;
	p: PUint32;
	c: Uint32;
	rr, gg, bb, aa: Uint8;
	t: Integer;
begin
	{ Create replacement surface. }
	MyImage2 := SDL_CreateRGBSurface( ( SDL_SRCALPHA or SDL_SWSURFACE ) , MyImage^.W , MyImage^.H , 32 , $FF000000 , $00FF0000 , $0000FF00 , $000000FF );
	if ( NIL = MyImage2 ) then exit( NIL );

	{ Blit from the original to the copy. }
	flags := MyImage^.flags;
	SDL_SetAlpha( MyImage , ( MyImage^.flags and ( not SDL_SRCALPHA ) or SDL_RLEACCEL ) , SDL_ALPHA_OPAQUE );
	SDL_BlitSurface( MyImage , NIL , MyImage2 , NIL );
	SDL_SetAlpha( MyImage , flags , SDL_ALPHA_OPAQUE );
	SDL_SetAlpha( MyImage2 , ( MyImage2^.flags or SDL_RLEACCEL ) , SDL_ALPHA_OPAQUE );

	{ Swap colors }
	ret := SDL_LockSurface( MyImage2 );
	if ( 0 <> ret ) then begin
		ErrorMessage( 'Surface can not locked.' );
		exit( MyImage2 );
	end;
	bpp := MyImage2^.format^.BytesPerPixel;
	pixels := MyImage2^.pixels;
	pitch := MyImage2^.pitch;
	w := ( MyImage2^.W - 1 );
	h := ( MyImage2^.H - 1 );
	if ( 4 = bpp ) then begin
		for y := 0 to h do begin
			for x := 0 to w do begin
				p := pixels + y * pitch + x * bpp;
				c := p^;
				rr := ( ( c and $FF000000 ) shr 24 );
				gg := ( ( c and $00FF0000 ) shr 16 );
				bb := ( ( c and $0000FF00 ) shr  8 );
				aa := ( ( c and $000000FF ) shr  0 );

				if ( ( 0 = rr ) and ( 0 = gg ) and ( 0 = bb ) ) then begin
				end else if ( ( 0 = gg ) and ( 0 = bb ) ) then begin
					t := rr;
					rr := ScaleColorValue( RSwap^.R , t );
					gg := ScaleColorValue( RSwap^.G , t );
					bb := ScaleColorValue( RSwap^.B , t );
				end else if ( ( 0 = bb ) and ( rr = gg ) ) then begin
					t := rr;
					rr := ScaleColorValue( YSwap^.R , t );
					gg := ScaleColorValue( YSwap^.G , t );
					bb := ScaleColorValue( YSwap^.B , t );
				end else if ( ( 0 = rr ) and ( 0 = bb ) ) then begin
					t := gg;
					rr := ScaleColorValue( GSwap^.R , t );
					gg := ScaleColorValue( GSwap^.G , t );
					bb := ScaleColorValue( GSwap^.B , t );
				end;
				p^ := ( ( rr shl 24 ) or ( gg shl 16 ) or ( bb shl 8 ) or ( aa shl 0 ) );
			end;
		end;
	end else begin
		ErrorMessage( 'Surface is not 32bit RGB+alpha image.' );
	end;
	SDL_UnlockSurface( MyImage2 );

	MakeSwapBitmapRYGA := MyImage2;
end;

Function MakeSwapBitmapHSVA( MyImage: PSDL_Surface; RSwap,YSwap,GSwap: PSDL_Color ): PSDL_Surface;
	{ Swap those colors out for the requested colors. }
var
	MyImage2: PSDL_Surface;
	flags: UInt32;
	ret: Integer;
	bpp, w, h: Integer;
	pitch: Uint16;
	pixels: Pointer;
	x, y: Integer;
	p: PUint32;
	c: Uint32;
	rr, gg, bb, aa: Uint8;
	r, g, b: double;
	rgb_min: double;
	hsv_h, hsv_s, hsv_v: double;
	t: Integer;
begin
	{ Create replacement surface. }
	MyImage2 := SDL_CreateRGBSurface( ( SDL_SRCALPHA or SDL_SWSURFACE ) , MyImage^.W , MyImage^.H , 32 , $FF000000 , $00FF0000 , $0000FF00 , $000000FF );
	if ( NIL = MyImage2 ) then exit( NIL );

	{ Blit from the original to the copy. }
	flags := MyImage^.flags;
	SDL_SetAlpha( MyImage , ( MyImage^.flags and ( not SDL_SRCALPHA ) or SDL_RLEACCEL ) , SDL_ALPHA_OPAQUE );
	SDL_BlitSurface( MyImage , NIL , MyImage2 , NIL );
	SDL_SetAlpha( MyImage , flags , SDL_ALPHA_OPAQUE );
	SDL_SetAlpha( MyImage2 , ( MyImage2^.flags or SDL_RLEACCEL ) , SDL_ALPHA_OPAQUE );

	{ Swap colors }
	ret := SDL_LockSurface( MyImage2 );
	if ( 0 <> ret ) then begin
		ErrorMessage( 'Surface can not locked.' );
		exit( MyImage2 );
	end;
	bpp := MyImage2^.format^.BytesPerPixel;
	pixels := MyImage2^.pixels;
	pitch := MyImage2^.pitch;
	w := ( MyImage2^.W - 1 );
	h := ( MyImage2^.H - 1 );
	if ( 4 = bpp ) then begin
		for y := 0 to h do begin
			for x := 0 to w do begin
				p := pixels + y * pitch + x * bpp;
				c := p^;
				rr := ( ( c and $FF000000 ) shr 24 );
				gg := ( ( c and $00FF0000 ) shr 16 );
				bb := ( ( c and $0000FF00 ) shr  8 );
				aa := ( ( c and $000000FF ) shr  0 );

				r := ( float(rr) / 255.0 );
				g := ( float(gg) / 255.0 );
				b := ( float(bb) / 255.0 );
				hsv_v := Max( Max( r , g ) , b );
				rgb_min := Min( Min( r , g ) , b );
				hsv_h := ( hsv_v - rgb_min );
				hsv_s := hsv_h;
				if ( 0.0 < hsv_h ) then begin
					if ( hsv_v = r ) then begin
						hsv_h := ( g - b ) / hsv_h;
						if ( hsv_h < 0.0 ) then begin
							hsv_h := hsv_h + 6.0;
						end;
					end else if ( hsv_v = g ) then begin
						hsv_h := ( 2.0 + ( b - r ) / hsv_h );
					end else begin
						hsv_h := ( 4.0 + ( r - g ) / hsv_h );
					end;
				end;
				if ( 0.0 < hsv_v ) then begin
					hsv_s := ( hsv_s / hsv_v );
				end;

				t := trunc( hsv_v * 255.0 );
				if ( hsv_s < 0.5 ) then begin
					rr := t;
					gg := t;
					bb := t;
				end else if ( ( 0 = rr ) and ( 0 = gg ) ) then begin
					bb := 0;
					aa := 0;
				end else if ( ( 4.0 < hsv_h ) or ( hsv_h < 0.5 ) ) then begin
					rr := ScaleColorValue( RSwap^.R , t );
					gg := ScaleColorValue( RSwap^.G , t );
					bb := ScaleColorValue( RSwap^.B , t );
				end else if ( ( 0.5 <= hsv_h ) and ( hsv_h < 1.5 ) ) then begin
					rr := ScaleColorValue( YSwap^.R , t );
					gg := ScaleColorValue( YSwap^.G , t );
					bb := ScaleColorValue( YSwap^.B , t );
				end else begin
					rr := ScaleColorValue( GSwap^.R , t );
					gg := ScaleColorValue( GSwap^.G , t );
					bb := ScaleColorValue( GSwap^.B , t );
				end;
				p^ := ( ( rr shl 24 ) or ( gg shl 16 ) or ( bb shl 8 ) or ( aa shl 0 ) );
			end;
		end;
	end else begin
		ErrorMessage( 'Surface is not 32bit RGB+alpha image.' );
	end;
	SDL_UnlockSurface( MyImage2 );

	MakeSwapBitmapHSVA := MyImage2;
end;

Function MakeSwapBitmapBA( MyImage: PSDL_Surface ): PSDL_Surface;
	{ Swap those colors out for the requested colors. }
var
	MyImage2: PSDL_Surface;
	flags: UInt32;
	ret: Integer;
	bpp, w, h: Integer;
	pitch: Uint16;
	pixels: Pointer;
	x, y: Integer;
	p: PUint32;
	c: Uint32;
	rr, gg, bb, aa: Uint8;
begin
	{ Create replacement surface. }
	MyImage2 := SDL_CreateRGBSurface( ( SDL_SRCALPHA or SDL_SWSURFACE ) , MyImage^.W , MyImage^.H , 32 , $FF000000 , $00FF0000 , $0000FF00 , $000000FF );
	if ( NIL = MyImage2 ) then exit( NIL );

	{ Blit from the original to the copy. }
	flags := MyImage^.flags;
	SDL_SetAlpha( MyImage , ( MyImage^.flags and ( not SDL_SRCALPHA ) or SDL_RLEACCEL ) , SDL_ALPHA_OPAQUE );
	SDL_BlitSurface( MyImage , NIL , MyImage2 , NIL );
	SDL_SetAlpha( MyImage , flags , SDL_ALPHA_OPAQUE );
	SDL_SetAlpha( MyImage2 , ( MyImage2^.flags or SDL_RLEACCEL ) , SDL_ALPHA_OPAQUE );

	{ Swap colors }
	ret := SDL_LockSurface( MyImage2 );
	if ( 0 <> ret ) then begin
		ErrorMessage( 'Surface can not locked.' );
		exit( MyImage2 );
	end;
	bpp := MyImage2^.format^.BytesPerPixel;
	pixels := MyImage2^.pixels;
	pitch := MyImage2^.pitch;
	w := ( MyImage2^.W - 1 );
	h := ( MyImage2^.H - 1 );
	if ( 4 = bpp ) then begin
		for y := 0 to h do begin
			for x := 0 to w do begin
				p := pixels + y * pitch + x * bpp;
				c := p^;
				rr := ( ( c and $FF000000 ) shr 24 );
				gg := ( ( c and $00FF0000 ) shr 16 );
				bb := ( ( c and $0000FF00 ) shr  8 );
				aa := ( ( c and $000000FF ) shr  0 );

				if ( ( 0 = rr ) and ( 0 = gg ) ) then begin
					bb := 0;
					aa := 0;
				end else begin
				end;
				p^ := ( ( rr shl 24 ) or ( gg shl 16 ) or ( bb shl 8 ) or ( aa shl 0 ) );
			end;
		end;
	end else begin
		ErrorMessage( 'Surface is not 32bit RGB+alpha image.' );
	end;
	SDL_UnlockSurface( MyImage2 );

	MakeSwapBitmapBA := MyImage2;
end;

Procedure GenerateColor( var ColorString: String; var ColorStruct: TSDL_Color );
	{ Generate the color from the string. }
var
	n: Integer;
begin
	n := ExtractValue( ColorString );
	if n > 255 then n := 255;
	ColorStruct.R := n;
	n := ExtractValue( ColorString );
	if n > 255 then n := 255;
	ColorStruct.G := n;
	n := ExtractValue( ColorString );
	if n > 255 then n := 255;
	ColorStruct.B := n;
end;


Function LocateSpriteByNameColor( const name,color: String ): SensibleSpritePtr;
	{ Locate the sprite which matches the name provided. }
	{ If no such sprite exists, return Nil. }
var
	S: SensibleSpritePtr;
begin
	S := Game_Sprites;
	while ( S <> Nil ) and ( ( S^.Name <> name ) or ( S^.Color <> Color ) ) do begin
		S := S^.Next;
	end;
	LocateSpriteByNameColor := S;
end;

Function NewSprite: SensibleSpritePtr;
	{ Add an empty sprite description to the list. }
var
	it: SensibleSpritePtr;
begin
	New(it);
	if it = Nil then exit( Nil );
	{Initialize values.}
	it^.Next := Game_Sprites;
	Game_Sprites := it;
	NewSprite := it;
end;

Function AddSprite( name, color: String; W,H: Integer ): SensibleSpritePtr;
	{ Add a new element to the Sprite List. Load the image for this sprite }
	{ from disk, if possible. }
var
	fname: PChar;
	it: SensibleSpritePtr;
	tmp: PSDL_Surface;
	RSwap,YSwap,GSwap: TSDL_Color;
	org_name: String;
	ColorSwapMode: Boolean;
begin
	{Allocate memory for our new element.}
	it := NewSprite;
	if it = Nil then Exit( Nil );
	it^.Name := Name;
	it^.Color := Color;
	it^.W := W;
	it^.H := H;

	org_name := name;
	name := FSearch( name , Graphics_Directory );

	if name <> '' then begin
		fname := QuickPCopy( name );

		{ Attempt to load the image. }
		it^.Img := IMG_Load( fname );

		if it^.Img <> Nil then begin
			ColorSwapMode := False;
			if ( '' <> Color ) then begin
				ColorSwapMode := True;
				GenerateColor( Color , RSwap );
				GenerateColor( Color , YSwap );
				GenerateColor( Color , GSwap );
			end;
			if ( SDL_SRCALPHA = ( SDL_SRCALPHA and it^.Img^.flags ) ) then begin
				{ If a color swap has been specified, handle that here. }
				if ColorSwapMode then begin
					if ( 1 <= Pos( '.nsc.' , fname ) ) then begin
					end else if ( 1 <= Pos( '.psc.' , fname ) ) then begin
						tmp := MakeSwapBitmapRYGA( it^.Img , @RSwap , @YSwap , @GSwap );
						SDL_FreeSurface( it^.Img );
						it^.img := tmp;
					end else begin
						tmp := MakeSwapBitmapHSVA( it^.Img , @RSwap , @YSwap , @GSwap );
						SDL_FreeSurface( it^.Img );
						it^.img := tmp;
					end;
				end else begin
					if ( 1 <= Pos( '.nsc.' , fname ) ) then begin
					end else if ( 1 <= Pos( '.psc.' , fname ) ) then begin
						tmp := MakeSwapBitmapBA( it^.Img );
						SDL_FreeSurface( it^.Img );
						it^.img := tmp;
					end else begin
						tmp := MakeSwapBitmapBA( it^.Img );
						SDL_FreeSurface( it^.Img );
						it^.img := tmp;
					end;
				end;
			end else begin
				{ Set transparency color. }
				SDL_SetColorKey( it^.Img , SDL_SRCCOLORKEY or SDL_RLEACCEL , SDL_MapRGB( it^.Img^.Format , SDLTransparentColor.R , SDLTransparentColor.G , SDLTransparentColor.B ) );

				{ If a color swap has been specified, handle that here. }
				if ColorSwapMode then begin
					tmp := MakeSwapBitmap( it^.Img , @RSwap , @YSwap , @GSwap );
					SDL_FreeSurface( it^.Img );
					it^.img := tmp;
				end;

				{ Convert to the screen mode. }
				{ This will make blitting far quicker. }
				tmp := SDL_ConvertSurface( it^.Img , Game_Screen^.Format , SDL_SRCCOLORKEY );
				SDL_FreeSurface( it^.Img );
				it^.Img := TMP;
			end;
		end;

{$IFNDEF PATCH_GH_PARANOID_CHECKER}
		sysutils.StrDispose( fname );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
	end else begin
		it^.Img := Nil;

	end;

	if ( NIL = it^.Img ) and ( 0 < Length(org_name) ) then begin
		ErrorMessage_fork('Sprite data "' + org_name + '" is not found.');
	end;

	{Return a pointer to the new element.}
	AddSprite := it;
end;

Procedure DisposeSpriteList(var LList: SensibleSpritePtr);
	{Dispose of the list, freeing all associated system resources.}
var
	LTemp: SensibleSpritePtr;
begin
	while LList <> Nil do begin
		LTemp := LList^.Next;

		if LList^.Img <> Nil then SDL_FreeSurface( LList^.Img );

{$IFDEF PATCH_GH_PARANOID_SAFER}
		LList^.Name     := '@';
		LList^.Color    := '@';
		LList^.W        := -32767;
		LList^.H        := -32767;
		LList^.Img      := PSDL_Surface(-1);
		LList^.Next     := SensibleSpritePtr(-1);
{$ENDIF PATCH_GH_PARANOID_SAFER}
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
		Dispose(LList);
{$ENDIF PATCH_GH_PARANOID_CHECKER}
		LList := LTemp;
	end;
end;


Procedure RemoveSprite(var LMember: SensibleSpritePtr);
	{Locate and extract member LMember from list LList.}
	{Then, dispose of LMember.}
var
	a,b: SensibleSpritePtr;
begin
	{Initialize A and B}
	B := Game_Sprites;
	A := Nil;

	{Locate LMember in the list. A will thereafter be either Nil,}
	{if LMember if first in the list, or it will be equal to the}
	{element directly preceding LMember.}
	while (B <> LMember) and (B <> Nil) do begin
		A := B;
		B := B^.next;
	end;

	if B = Nil then begin
		{Major FUBAR. The member we were trying to remove can't}
		{be found in the list.}
		ErrorMessage('ERROR- RemoveLink asked to remove a link that doesnt exist.');
		end
	else if A = Nil then begin
		{There's no element before the one we want to remove,}
		{i.e. it's the first one in the list.}
		Game_Sprites := B^.Next;
		B^.Next := Nil;
		DisposeSpriteList(B);
		end
	else begin
		{We found the attribute we want to delete and have another}
		{one standing before it in line. Go to work.}
		A^.next := B^.next;
		B^.Next := Nil;
		DisposeSpriteList(B);
	end;

	LMember := Nil;
end;

procedure DrawSprite( Spr: SensibleSpritePtr; MyDest: TSDL_Rect; Frame: Integer );
	{ Draw a sensible sprite. }
begin
	{ First make sure that we have some valid sprite data... }
	if ( Spr <> Nil ) and ( Spr^.Img <> Nil ) then begin
		{ All the info checks out. Print it. }
		DrawAnimImage( Spr^.Img , Game_Screen , Spr^.W , Spr^.H , Frame , MyDest );
	end;
end;

procedure DrawSprite( Spr: SensibleSpritePtr; MyCanvas: PSDL_Surface; MyDest: TSDL_Rect; Frame: Integer );
	{ Draw a sensible sprite to an arbitrary canvas. }
begin
	{ First make sure that we have some valid sprite data... }
	if ( Spr <> Nil ) and ( Spr^.Img <> Nil ) then begin
		{ All the info checks out. Print it. }
		DrawAnimImage( Spr^.Img , MyCanvas , Spr^.W , Spr^.H , Frame , MyDest );
	end;
end;

function LocateSprite( const Name,Color: String; W,H: Integer ): SensibleSpritePtr;
	{ Try to locate the requested sprite in the requested color. If the sprite }
	{ is already loaded, then return its address. If not, load it and color it. }
var
	S: SensibleSpritePtr;
begin
	{ First, find the sprite. If by some strange chance it hasn't been }
	{ loaded yet, load it now. }
	S := LocateSpriteByNameColor( Name , Color );
	if S = Nil then S := AddSprite( Name , Color , W , H );

	{ Set the width and height fields. }
	S^.W := W;
	S^.H := H;

	LocateSprite := S;
end;

function LocateSprite( const Name: String; W,H: Integer ): SensibleSpritePtr;
	{ Find the requested sprite, either in memory or from disk. }
var
	S: SensibleSpritePtr;
begin
	{ First, find the sprite. If by some strange chance it hasn't been }
	{ loaded yet, load it now. }
	LocateSprite := LocateSprite( Name , '' , W , H );
end;

Procedure CleanSpriteList;
	{ Go through the sprite list and remove those sprites we aren't likely to }
	{ need immediately... i.e., erase those ones which have a COLOR string defined. }
var
	S,S2: SensibleSpritePtr;
begin
	S := Game_Sprites;
	while S <> Nil do begin
		S2 := S^.Next;

		if S^.Color <> '' then begin
			RemoveSprite( S );
		end;

		S := S2;
	end;
end;

function RawKey( var Unicode: Word ): Char;
var
	a: String;
	event : TSDL_Event;
	Procedure ProcessThatEvent;
	var
		width,height: Integer;
		e: TSDL_Event;
	begin
		if event.type_ = SDL_KEYDOWN then begin
			if ( 0 < event.key.keysym.unicode ) and ( event.key.keysym.unicode < $80 ) then begin
				a := Char( event.key.keysym.unicode );
			end else begin
				Unicode := event.key.keysym.unicode;
				a := KBD_UNICODE_FLAG;
			end;
		end else if ( event.type_ = SDL_MOUSEButtonDown ) then begin
			case event.button.button of
			SDL_BUTTON_LEFT:		a := RPK_MouseButton;
			SDL_BUTTON_RIGHT:		a := RPK_RightButton;
			end;
		end else if ( SDL_MOUSEButtonUp = event.type_ ) then begin
			if event.button.button = SDL_BUTTON_LEFT then begin
				a := RPK_MouseButtonRelease;
			end;
		end else if ( SDL_MOUSEMOTION = event.type_ ) then begin
			a := RPK_MouseMotion;

		end else if event.type_ = SDL_VIDEORESIZE then begin
			width := event.resize.w;
			if width < 800 then width := 800;
			height := event.resize.h;
			if height < 600 then height := 600;
			SDL_FreeSurface( Game_Screen );
			Game_Screen := SDL_SetVideoMode(width, height, 0, SDL_VideoModeFlag );
			SDL_SetColorKey( Game_Screen , SDL_SRCCOLORKEY or SDL_RLEACCEL , SDL_MapRGB( Game_Screen^.Format , SDLTransparentColor.R , SDLTransparentColor.G , SDLTransparentColor.B ) );
			Preset_SIZE( width , height );

		end else if ( SDL_ACTIVEEVENT = event.type_ ) then begin
			if ( ( 0 <> event.active.gain ) and ( SDL_APPMOUSEFOCUS <> event.active.state ) ) then begin
				e.type_ := SDL_VIDEORESIZE;
				e.resize.w := Game_Screen^.w;
				e.resize.h := Game_Screen^.h;
				SDL_PushEvent( @e );
			end;

		end;
	end;
var
	D: QWord;
	PResult: Integer;
	NeedRefresh: Boolean;
begin
	Unicode := 0;
	a := '';
	if Minimal_Screen_Refresh then begin
		NeedRefresh := False;
		repeat
			if SDL_PollEvent( @event ) = 1 then begin
				ProcessThatEvent;
				NeedRefresh := True;
			end else begin
				if NeedRefresh then begin
					break;
				end;
				if SDL_GetTicks < ( Last_Clock_Update + 20 ) then begin
					D := Last_Clock_Update + 30 - SDL_GetTicks;
					SDL_Delay( D );
				end;
				Last_Clock_Update := SDL_GetTicks + 30;
			end;
		until ( '' <> a );
	end else begin
		repeat
			PResult := SDL_PollEvent( @event );
			if PResult = 1 then begin
				ProcessThatEvent;
			end;
		until ( PResult <> 1 ) or ( '' <> a );

		if SDL_GetTicks < ( Last_Clock_Update + 20 ) then begin
			D := Last_Clock_Update + 30 - SDL_GetTicks;
			SDL_Delay( D );
		end;
		Last_Clock_Update := SDL_GetTicks + 30;
	end;

	RK_KeyState := SDL_GetKeyState( RK_NumKeys );
	SDL_GetMouseState( Mouse_X , Mouse_Y );

	if a <> '' then RawKey := a[1]
	else RawKey := KBD_NONE;
end;


Procedure Load_SoundEffect;
var
	SoundEffectFileList: SAttListPtr;
	P: SAttListElementPtr;
	S: SensibleSoundEffectListPtr;
	PText: PChar;
begin
	SoundEffectFileList := CreateFileList( Sound_Directory + '*.*' , False );
	SoundEffectList := NIL;

	P := SoundEffectFileList^.head;
	while ( NIL <> P ) do begin
		if ( ( 3 <= Length( P^.Info ) ) and ( '.txt' <> Copy( P^.Info , (Length(P^.Info) - 3) , 4 ) ) and ( '.bak' <> Copy( P^.Info , (Length(P^.Info) - 3) , 4 ) ) ) then begin
			New( S );
			if ( NIL = S ) then exit;

			S^.Name := P^.Info;
			PText := QuickPCopy( Sound_Directory + P^.Info );
			S^.Chunk := Mix_LoadWAV( PText );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
			sysutils.StrDispose( PText );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
			S^.Next := SoundEffectList;

			if ( NIL <> S^.Chunk ) then begin
				SoundEffectList := S;
			end else begin
				ErrorMessage( 'SDL_mixer error at Mix_LoadWAV(' + P^.Info + ') : ' + SDL_GetError );
{$IFDEF PATCH_GH_PARANOID_SAFER}
				S^.Name[1] := '@';
				S^.Chunk   := NIL;
				S^.Next    := SensibleSoundEffectListPtr(-1);
{$ENDIF PATCH_GH_PARANOID_SAFER}
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
				Dispose( S );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
			end;
		end;
		P := P^.Next;
	end;

	DisposeSAttList( SoundEffectFileList );
end;

Procedure Dispose_SoundEffect;
var
	S,S2: SensibleSoundEffectListPtr;
begin
	S := SoundEffectList;
	while ( NIL <> S ) do begin
		S2 := S^.Next;

		Mix_FreeChunk( S^.Chunk );
{$IFDEF PATCH_GH_PARANOID_SAFER}
		S^.Name[1] := '@';
		S^.Chunk   := NIL;
		S^.Next    := SensibleSoundEffectListPtr(-1);
{$ENDIF PATCH_GH_PARANOID_SAFER}
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
		Dispose( S );
{$ENDIF PATCH_GH_PARANOID_CHECKER}

		S := S2;
	end;
end;

Procedure PlaySoundEffect_Direct( const Name: String );
var
	S: SensibleSoundEffectListPtr;
begin
	if ( Length(Name) < 3 ) then exit;

	S := SoundEffectList;
	while ( NIL <> S ) do begin
		if ( Name = S^.Name ) then begin
			Mix_PlayChannel( -1 , S^.Chunk , 0 );
			exit;
		end;
		S := S^.Next;
	end;
	ErrorMessage_fork( 'A sound effect file "' + Name + '" was not found.' );
end;


function RPGKey: Char;
	{ Read a readable key from the keyboard and return its ASCII value. }
	{ This function will always return within a close approximation of 30ms }
	{ from the last time it was called. It will also update the array of }
	{ keypresses. }
var
	a: String;
	event : TSDL_Event;
	Procedure ProcessThatEvent;
		{ An event has been recieved. Process it. }
	var
		width,height: Integer;
		e: TSDL_Event;
	begin
		if event.type_ = SDL_KEYDOWN then begin
			{ Check to see if it was an ASCII character we recieved. }
			if ( 0 < event.key.keysym.unicode ) and ( event.key.keysym.unicode < $80 ) then begin
				a := Char( event.key.keysym.unicode );
			end else if (0 < event.key.keysym.unicode) then begin
				a := KBD_UNICODE_FLAG;
			end;
		end else if ( event.type_ = SDL_MOUSEButtonDown ) then begin
			{ Return a mousebutton event, and call DoFlip to set the mouse position }
			{ variables. }
			case event.button.button of
			SDL_BUTTON_LEFT:		a := RPK_MouseButton;
			SDL_BUTTON_MIDDLE:		a := KeyMap[ KMC_ButtonMiddle ].KCode;
			SDL_BUTTON_RIGHT:		a := RPK_RightButton;
			SDL_BUTTON_WHEELUP:		a := KeyMap[ KMC_ButtonWUp ].KCode;
			SDL_BUTTON_WHEELDOWN:		a := KeyMap[ KMC_ButtonWDown ].KCode;
			(SDL_BUTTON_WHEELDOWN+1):	a := KeyMap[ KMC_ButtonWLeft ].KCode; { SDL_BUTTON_X1: (WHEEL-LEFT) }
			(SDL_BUTTON_WHEELDOWN+2):	a := KeyMap[ KMC_ButtonWRight ].KCode; { SDL_BUTTON_X2: (WHEEL-RIGHT) }
			(SDL_BUTTON_WHEELDOWN+3):	a := KeyMap[ KMC_ButtonWBack ].KCode;
			(SDL_BUTTON_WHEELDOWN+4):	a := KeyMap[ KMC_ButtonWForward ].KCode;
			end;
		end else if ( SDL_MOUSEButtonUp = event.type_ ) then begin
			if event.button.button = SDL_BUTTON_LEFT then begin
				a := RPK_MouseButtonRelease;
			end;
		end else if ( SDL_MOUSEMOTION = event.type_ ) then begin
			a := RPK_MouseMotion;

		end else if event.type_ = SDL_VIDEORESIZE then begin
			width := event.resize.w;
			if width < 800 then width := 800;
			height := event.resize.h;
			if height < 600 then height := 600;
			SDL_FreeSurface( Game_Screen );
			Game_Screen := SDL_SetVideoMode(width, height, 0, SDL_VideoModeFlag );
			SDL_SetColorKey( Game_Screen , SDL_SRCCOLORKEY or SDL_RLEACCEL , SDL_MapRGB( Game_Screen^.Format , SDLTransparentColor.R , SDLTransparentColor.G , SDLTransparentColor.B ) );
			Preset_SIZE( width , height );

		end else if ( SDL_ACTIVEEVENT = event.type_ ) then begin
			if ( ( 0 <> event.active.gain ) and ( SDL_APPMOUSEFOCUS <> event.active.state ) ) then begin
				e.type_ := SDL_VIDEORESIZE;
				e.resize.w := Game_Screen^.w;
				e.resize.h := Game_Screen^.h;
				SDL_PushEvent( @e );
			end;

		end;
	end;
var
	D: QWord;
	PResult: Integer;
	NeedRefresh: Boolean;
begin
	a := '';
	if Minimal_Screen_Refresh then begin
		NeedRefresh := False;
		repeat
			if SDL_PollEvent( @event ) = 1 then begin
				ProcessThatEvent;
				NeedRefresh := True;
			end else begin
				if NeedRefresh then begin
					break;
				end;
				{ If necessary, do a delay. }
				if SDL_GetTicks < ( Last_Clock_Update + 20 ) then begin
					D := Last_Clock_Update + 30 - SDL_GetTicks;
					SDL_Delay( D );
				end;
				Last_Clock_Update := SDL_GetTicks + 30;
			end;
		until ( '' <> a );
	end else begin
		{ Go through the accumulated events looking for good ones. }
		repeat
			PResult := SDL_PollEvent( @event );
			if PResult = 1 then begin
				{ See if this event is a keyboard one... }
				ProcessThatEvent;
			end;
		until ( PResult <> 1 ) or ( '' <> a );

		{ If necessary, do a delay. }
		if SDL_GetTicks < ( Last_Clock_Update + 20 ) then begin
			D := Last_Clock_Update + 30 - SDL_GetTicks;
			SDL_Delay( D );
		end;
		Last_Clock_Update := SDL_GetTicks + 30;
	end;

	RK_KeyState := SDL_GetKeyState( RK_NumKeys );
	SDL_GetMouseState( Mouse_X , Mouse_Y );

	if a <> '' then RPGKey := a[1]
	else RPGKey := KBD_NONE;
end;

function RPGKeyEvent: Char;
var
	C: Char;
	event : TSDL_Event;
	Procedure ProcessThatEvent;
	var
		width,height: Integer;
		e: TSDL_Event;
	begin
		if event.type_ = SDL_KEYDOWN then begin
			case event.key.keysym.sym of
				SDLK_Backspace:	C := KBD_BS;
				SDLK_Tab:	C := KBD_TAB;
				SDLK_Return:	C := KBD_RET;
				SDLK_Escape:	C := KBD_ESC;
				SDLK_Delete:	C := KBD_Delete;
				SDLK_KP0:		C := KBD_Insert;
				SDLK_KP1:		C := KBD_End;
				SDLK_KP2:		C := KBD_Down;
				SDLK_KP3:		C := KBD_PgDn;
				SDLK_KP4:		C := KBD_Left;
				SDLK_KP5:		C := KBD_KP5;
				SDLK_KP6:		C := KBD_Right;
				SDLK_KP7:		C := KBD_Home;
				SDLK_KP8:		C := KBD_Up;
				SDLK_KP9:		C := KBD_PgUp;
				SDLK_KP_Period:		C := KBD_Delete;
				SDLK_KP_Divide:		C := '/';
				SDLK_KP_Multiply:	C := '*';
				SDLK_KP_Minus:		C := '-';
				SDLK_KP_Plus:		C := '+';
				SDLK_KP_Enter:		C := KBD_RET;
				SDLK_KP_Equals:		C := '=';
				SDLK_Up:	C := KBD_Up;
				SDLK_Down:	C := KBD_Down;
				SDLK_Right:	C := KBD_Right;
				SDLK_Left:	C := KBD_Left;
				SDLK_Insert:	C := KBD_Insert;
				SDLK_Home:	C := KBD_Home;
				SDLK_End:	C := KBD_End;
				SDLK_PageUp:	C := KBD_PgUp;
				SDLK_PageDown:	C := KBD_PgDn;
				SDLK_F1:	C := KBD_F1;
				SDLK_F2:	C := KBD_F2;
				SDLK_F3:	C := KBD_F3;
				SDLK_F4:	C := KBD_F4;
				SDLK_F5:	C := KBD_F5;
				SDLK_F6:	C := KBD_F6;
				SDLK_F7:	C := KBD_F7;
				SDLK_F8:	C := KBD_F8;
				SDLK_F9:	C := KBD_F9;
				SDLK_F10:	C := KBD_F10;
				SDLK_F11:	C := KBD_F11;
				SDLK_F12:	C := KBD_F12;
				SDLK_F13:	C := KBD_F13;
				SDLK_F14:	C := KBD_F14;
				SDLK_F15:	C := KBD_F15;
			else
				if ( 0 < event.key.keysym.unicode ) and ( event.key.keysym.unicode < $80 ) then begin
					C := Char(event.key.keysym.unicode);
				end else begin
					C := KBD_NONE;
				end;
			end;

		end else if ( event.type_ = SDL_MOUSEButtonDown ) then begin
			case event.button.button of
			SDL_BUTTON_LEFT:		C := RPK_MouseButton;
			SDL_BUTTON_MIDDLE:		C := KeyMap[ KMC_ButtonMiddle ].KCode;
			SDL_BUTTON_RIGHT:		C := RPK_RightButton;
			SDL_BUTTON_WHEELUP:		C := KeyMap[ KMC_ButtonWUp ].KCode;
			SDL_BUTTON_WHEELDOWN:		C := KeyMap[ KMC_ButtonWDown ].KCode;
			(SDL_BUTTON_WHEELDOWN+1):	C := KeyMap[ KMC_ButtonWLeft ].KCode; { SDL_BUTTON_X1: (WHEEL-LEFT) }
			(SDL_BUTTON_WHEELDOWN+2):	C := KeyMap[ KMC_ButtonWRight ].KCode; { SDL_BUTTON_X2: (WHEEL-RIGHT) }
			(SDL_BUTTON_WHEELDOWN+3):	C := KeyMap[ KMC_ButtonWBack ].KCode;
			(SDL_BUTTON_WHEELDOWN+4):	C := KeyMap[ KMC_ButtonWForward ].KCode;
			end;
		end else if ( SDL_MOUSEButtonUp = event.type_ ) then begin
			if event.button.button = SDL_BUTTON_LEFT then begin
				C := RPK_MouseButtonRelease;
			end;
		end else if ( SDL_MOUSEMOTION = event.type_ ) then begin
			C := RPK_MouseMotion;

		end else if event.type_ = SDL_VIDEORESIZE then begin
			width := event.resize.w;
			if width < 800 then width := 800;
			height := event.resize.h;
			if height < 600 then height := 600;
			SDL_FreeSurface( Game_Screen );
			Game_Screen := SDL_SetVideoMode(width, height, 0, SDL_VideoModeFlag );
			SDL_SetColorKey( Game_Screen , SDL_SRCCOLORKEY or SDL_RLEACCEL , SDL_MapRGB( Game_Screen^.Format , SDLTransparentColor.R , SDLTransparentColor.G , SDLTransparentColor.B ) );
			Preset_SIZE( width , height );

		end else if ( SDL_ACTIVEEVENT = event.type_ ) then begin
			if ( ( 0 <> event.active.gain ) and ( SDL_APPMOUSEFOCUS <> event.active.state ) ) then begin
				e.type_ := SDL_VIDEORESIZE;
				e.resize.w := Game_Screen^.w;
				e.resize.h := Game_Screen^.h;
				SDL_PushEvent( @e );
			end;

		end;
	end;
var
	D: QWord;
	PResult: Integer;
	NeedRefresh: Boolean;
	i: Integer;
begin
	C := RPK_TimeEvent;
	if Minimal_Screen_Refresh then begin
		NeedRefresh := False;
		repeat
			if SDL_PollEvent( @event ) = 1 then begin
				ProcessThatEvent;
				NeedRefresh := True;
			end else begin
				if NeedRefresh then begin
					break;
				end;
				if SDL_GetTicks < ( Last_Clock_Update + 20 ) then begin
					D := Last_Clock_Update + 30 - SDL_GetTicks;
					SDL_Delay( D );
				end;
				Last_Clock_Update := SDL_GetTicks + 30;
			end;
		until ( RPK_TimeEvent <> C ) and ( RPK_MouseMotion <> C );
	end else begin
		repeat
			PResult := SDL_PollEvent( @event );
			if PResult = 1 then begin
				ProcessThatEvent;
			end;
		until ( PResult <> 1 ) or ( RPK_TimeEvent <> C );
		if ( RPK_MouseMotion = C ) then begin
			repeat
				PResult := SDL_PollEvent( @event );
				if PResult = 1 then begin
					ProcessThatEvent;
				end;
			until ( PResult <> 1 ) or ( RPK_MouseMotion <> C );
		end;

		if SDL_GetTicks < ( Last_Clock_Update + 20 ) then begin
			D := Last_Clock_Update + 30 - SDL_GetTicks;
			SDL_Delay( D );
		end;
		Last_Clock_Update := SDL_GetTicks + 30;
	end;

	RK_KeyState := SDL_GetKeyState( RK_NumKeys );
	SDL_GetMouseState( Mouse_X , Mouse_Y );

	i := 1;
	while ( KBD_ERROR <> KCodeAlias[i].KCode_from ) do begin
		if ( KCodeAlias[i].KCode_from = C ) then begin
			C := KCodeAlias[i].KCode_to;
			break;
		end;
		Inc( i );
	end;

	RPGKeyEvent := C;
end;

Procedure ClrZone( const Z: TSDL_Rect );
	{ Clear the specified screen zone. }
begin
	SDL_FillRect( game_screen , @Z , SDL_MapRGB( Game_Screen^.Format , SDLClearColor.R , SDLClearColor.G , SDLClearColor.B ) );
end;

Procedure ClrScreen;
	{ Clear the specified screen zone. }
begin
	SDL_FillRect( game_screen , Nil , SDL_MapRGBA( Game_Screen^.Format , SDLBackgroundColor.R , SDLBackgroundColor.G , SDLBackgroundColor.B , SDL_ALPHA_TRANSPARENT ) );
end;

Procedure ClrScreen_wM( M: GearPtr );
	{ Clear the specified screen zone. }
begin
	SDL_FillRect( game_screen , Nil , SDL_MapRGBA( Game_Screen^.Format , SDLBackgroundColor.R , SDLBackgroundColor.G , SDLBackgroundColor.B , SDL_ALPHA_TRANSPARENT ) );
end;

Function TextLength( F: PTTF_Font; msg: String ): LongInt;
	{ Determine how long "msg" will be using the default "game_font". }
var
	pmsg: PChar;	{ Gotta convert to pchar, pain in the ass... }
	W,Y: LongInt;	{ W means width I guess... Y is anyone's guess. Height? }
begin
	{ Convert the string to a pchar. }
	pmsg := QuickPCopy( msg );

	{ Call the alleged size calculation function. }
	TTF_SizeUTF8( F , pmsg , W , Y );

	{ get rid of the PChar, since it's served its usefulness. }
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
	sysutils.StrDispose( pmsg );
{$ENDIF PATCH_GH_PARANOID_CHECKER}

	TextLength := W;
end;

Procedure GetNextLine( var TheLine , msg , NextWord: String; Width: Integer; MyFont: PTTF_Font );
	{ Get a line of text of maximum width "Width". }
var
	LC: Boolean;	{ Loop Condition. So I wasn't very creative when I named it, so what? }
	CW_UTF8: Boolean;	{Is the current word UTF-8 ?}
	DItS: Boolean;		{Do insert the space, or not.}
	BW: String;
begin
	{ Loop condition starts out as TRUE. }
	LC := True;
	if TheLine = ' ' then TheLine := '';

	{ Start building the line. }
	repeat
		NextWord := ExtractWordForPrint( Msg, DItS, CW_UTF8 );

		if '' <> NextWord then begin
			if False = CW_UTF8 then begin
				if TextLength( MyFont , TheLine + ' ' + NextWord + UTF8_Width_Of_One_Character + ' ') < Width then begin
					if DItS then TheLine := TheLine + ' ' + NextWord
					else TheLine := TheLine + NextWord
				end else begin
					LC := False;
				end;
			end else begin
				if TextLength( MyFont , TheLine + ' ' + NextWord + UTF8_Width_Of_One_Character + ' ') < Width then begin
					if DItS then TheLine := TheLine + ' ' + NextWord
					else TheLine := TheLine + NextWord
				end else begin
					LC := False;

					if Pos(NextWord, ProhibitationHead) > 0 then begin
						TheLine := TheLine + NextWord + #13;
					end else begin
						BW := TailUTF8Char(TheLine);
						if (0 < Length(BW)) and (0 < Pos(BW, ProhibitationTrail)) then begin
							TheLine := Copy(TheLine,1,Length(TheLine)-Length(BW));
							NextWord := BW + NextWord;
						end;
					end;
				end;
			end;
		end;
	until (not LC) or (NextWord = '') or ( (0 < Length(TheLine)) and (TheLine[Length(TheLine)] = #13) );

	{ If the line ended due to a line break, deal with it. }
	if ( (0 < Length(TheLine)) and (TheLine[Length(TheLine)] = #13) ) then begin
		{ Display the line break as a space. }
		TheLine[Length(TheLine)] := ' ';
		NextWord := ExtractWordForPrint( Msg, DItS, CW_UTF8 );
	end;

end;

Function PrettyPrint( msg: string; Width: Integer; var FG: TSDL_Color; DoCenter: Boolean; MyFont: PTTF_Font ): PSDL_Surface;
	{ Create a SDL_Surface containing all the text within "msg" formatted }
	{ in lines of no longer than "width" pixels. Sound simple? Mostly just }
	{ tedious, I'm afraid. }
var
	SList: SAttListPtr;
	SA: SAttListElementPtr;
	S_Total,S_Temp: PSDL_Surface;
	MyDest: SDL_Rect;
	rmask, gmask, bmask, amask: UInt32;
	NextWord: String;
	THELine: String;	{The line under construction.}
begin
	{ CLean up the message a bit. }
	DeleteWhiteSpace( msg );
	if msg = '' then Exit( Nil );

	{THELine = The first word in this iteration}
	THELine := ' ';
	NextWord := '';
	SList := CreateSAttList;

	{Start the main processing loop.}
	while TheLine <> '' do begin
		GetNextLine( TheLine , msg , NextWord , Width, MyFont );

		{ Output the line. }
		{ Next append it to whatever has already been created. }
		StoreSAttList( SList , TheLine );

		{ Prepare for the next iteration. }
		TheLine := NextWord;
	end; { while TheLine <> '' }

	{ Create a bitmap for the message. }
	if 0 < NumSAttList( SList ) then begin
		{ Create a big bitmap to hold everything. }
		rmask := $00FF0000;
		gmask := $0000FF00;
		bmask := $000000FF;
		amask := $FF000000;
		if not(SDL_AAFont) and not(SDL_AAFont_Shaded) then begin
			S_Total := SDL_CreateRGBSurface( SDL_SWSURFACE , width , TTF_FontLineSkip( MyFont ) * NumSAttList( SList ) , 32 , rmask, gmask, bmask, amask );
		end else if SDL_AAFont_Shaded then begin
			S_Total := SDL_CreateRGBSurface( SDL_SWSURFACE , width , TTF_FontLineSkip( MyFont ) * NumSAttList( SList ) , 32 , rmask, gmask, bmask, amask );
		end else begin
			S_Total := SDL_CreateRGBSurface( ( SDL_SRCALPHA or SDL_SWSURFACE ) , width , TTF_FontLineSkip( MyFont ) * NumSAttList( SList ) , 32 , rmask, gmask, bmask, amask );
		end;
		MyDest.X := 0;
		MyDest.Y := 0;

		{ Add each stored string to the bitmap. }
		SA := SList^.head;
		while SA <> Nil do begin
			S_Temp := UTF8_TTF_RenderText( MyFont , SA^.Info , fg );
			if not(SDL_AAFont) and not(SDL_AAFont_Shaded) then begin
			end else if SDL_AAFont_Shaded then begin
			end else begin
				if ( NIL <> S_Temp ) then begin
					SDL_SetAlpha( S_Temp , 0 , SDL_ALPHA_OPAQUE );
				end;
			end;

			{ We may or may not be required to do centering of the text. }
			if DoCenter then begin
				MyDest.X := ( Width - TextLength( MyFont , SA^.Info ) ) div 2;
			end else begin
				MyDest.X := 0;
			end;

			SDL_BlitSurface( S_Temp , Nil , S_Total , @MyDest );
			SDL_FreeSurface( S_Temp );
			MyDest.Y := MyDest.Y + TTF_FontLineSkip( MyFont );
			SA := SA^.Next;
		end;

	end else begin
		S_Total := Nil;
	end;
	DisposeSAttList( SList );


	PrettyPrint := S_Total;
end;

Function PrettyPrint( msg: string; Width: Integer; var FG: TSDL_Color; DoCenter: Boolean ): PSDL_Surface;
	{ Overloaded version of above, using default font. }
begin
	PrettyPrint := PrettyPrint( msg, width, FG, DoCenter, Game_Font );
end;


Procedure CMessage( msg: String; Z: TSDL_Rect; C: TSDL_Color; MyFont: PTTF_Font );
	{ Print a message to the screen, centered in the requested rect. }
	{ Clear the specified zone before doing so. }
var
	MyText: PSDL_Surface;
	MyDest: TSDL_Rect;
begin
	MyText := PrettyPrint( msg , Z.W , C , True, MyFont );
	if MyText <> Nil then begin
		MyDest := Z;
		MyDest.Y := MyDest.Y + ( Z.H - MyText^.H ) div 2;
		SDL_SetClipRect( Game_Screen , @Z );
		SDL_BlitSurface( MyText , Nil , Game_Screen , @MyDest );
		SDL_FreeSurface( MyText );
		SDL_SetClipRect( Game_Screen , Nil );
	end;
end;

Procedure CMessage( msg: String; Z: TSDL_Rect; C: TSDL_Color );
	{ Use the default font. }
begin
	CMessage( msg, Z, C, Game_Font );
end;

Procedure CMessage( msg: String; DZ: DynamicRect; C: TSDL_Color );
	{ Print a message centered in a DynamicRect. }
begin
	CMessage( msg, DZ.GetRect(), C );
end;

Procedure GameMSG( msg: string; Z: TSDL_Rect; C: TSDL_Color; MyFont: PTTF_Font );
	{ Print a game message. }
var
	MyText: PSDL_Surface;
begin
	MyText := PrettyPrint( msg , Z.W , C , True, MyFont );
	if MyText <> Nil then begin
		SDL_SetClipRect( Game_Screen , @Z );
		SDL_BlitSurface( MyText , Nil , Game_Screen , @Z );
		SDL_FreeSurface( MyText );
		SDL_SetClipRect( Game_Screen , Nil );
	end;
end;

Procedure GameMSG( msg: string; Z: TSDL_Rect; C: TSDL_Color );
	{ Overloaded version using default font. }
begin
	GameMsg( msg, Z, C, Game_Font );
end;

Procedure GameMSG( msg: string; DZ: DynamicRect; C: TSDL_Color );
	{ As above, but no pageflip. }
begin
	GameMsg( msg, DZ.GetRect(), C );
end;

Function IsMoreKey( A: Char ): Boolean;
	{ Return TRUE if A is a "more" key, that should skip to the next message in a list. }
begin
	IsMoreKey := ( A = ' ' ) or ( KBD_ESC = A ) or ( RPK_MouseButton = A );
end;

Procedure MoreKey;
	{ Wait for the user to press either the space bar or the ESC key. }
var
	A: Char;
begin
	{ Keep reading keypresses until either a space or an ESC is found. }
	repeat
		A := RPGKey;
	until IsMoreKey( A );
end;

Procedure ClearExtendedBorder( Dest: TSDL_Rect );
	{ Draw the inner box for border displays. }
begin
	Dest.X := Dest.X - 1;
	Dest.Y := Dest.Y - 1;
	Dest.W := Dest.W + 2;
	Dest.H := Dest.H + 2;
	SDL_FillRect( game_screen , @Dest , SDL_MapRGB( Game_Screen^.Format , SDLClearColor.R , SDLClearColor.G , SDLClearColor.B ) );
end;

Function GetStringFromUser( const Prompt: String; const DefaultSearchPattern: String; ReDrawer: RedrawProcedureType_with_GearPtr; M: GearPtr ): String;
var
	Dummy: Boolean;
begin
	GetStringFromUser := GetStringFromUser( Prompt , DefaultSearchPattern , ReDrawer , M , Dummy );
end;

Function GetStringFromUser( const Prompt: String; const DefaultSearchPattern: String; ReDrawer: RedrawProcedureType_with_GearPtr; M: GearPtr; var Cancelled: Boolean ): String;
	{ Does what it says. }
const
	MaxInputWidth = 80;
	WCLen = 16;
var
	A: Char;
	it: String;
	MyBigBox,MyInputBox,MyDest: TSDL_Rect;
	Unicode: Word;
	work_dst: Array[0..WCLen] of Char;
	work_pdst: PChar;
	state: ShortInt = 0;
	mbchar_work: String = '';
begin
	{ Initialize string. }
	it := DefaultSearchPattern;
	Cancelled := False;
{$IF NOT (DEFINED(Windows) AND DEFINED(WITHOUT_SDLIM))}

	repeat
		MyBigBox := ZONE_TextInputBigBox.GetRect();
		MyInputBox := ZONE_TextInput.GetRect();

		{ Set up the display. }
		if ReDrawer <> Nil then ReDrawer( M );
		InfoBox( MyBigBox );
		{SDL_FillRect( game_screen , @MyBigBox , SDL_MapRGB( Game_Screen^.Format , SDLBorderBlue.R , SDLBorderBlue.G , SDLBorderBlue.B ) );}
		SDL_FillRect( game_screen , @MyInputBox , SDL_MapRGB( Game_Screen^.Format , StdBlack.R , StdBlack.G , StdBlack.B ) );

		GameMSG( Prompt , ZONE_TextInputPrompt.GetRect() , StdWhite );
		CMessage( it , MyInputBox , InfoGreen );
		MyDest.Y := MyInputBox.Y + 2;
		MyDest.X := MyInputBox.X + ( MyInputBox.W div 2 ) + ( TextLength( Game_Font , it ) div 2 );
		DrawSprite( Cursor_Sprite , MyDest , ( Animation_Phase div 2 ) mod 4 );

		DoFlip;
		A := RawKey( Unicode );

		if (0 < Unicode) then begin
			work_pdst := work_dst;
			UnicodeToUtf8( work_dst, WCLen, @Unicode, 2 );
			A := EditUTF8CharStr( it, 127, MaxInputWidth, #0, work_pdst, state, mbchar_work );
		end else if ( RPK_TimeEvent <> A ) and ( RPK_MouseMotion <> A ) then begin
			A := EditUTF8CharStr( it, 127, MaxInputWidth, A, NIL, state, mbchar_work );
		end;
	until ( KBD_LF = A ) or ( KBD_RET = A ) or ( KBD_ESC = A );

	if ( KBD_ESC = A ) then begin
		Cancelled := True;
	end;
{$ELSE}
	if ( NIL <> ReDrawer ) then begin
		ReDrawer( M );
	end;
	MyBigBox := ZONE_TextInputBigBox.GetRect();
	it := w32eb.EditBox( MyBigBox.X , MyBigBox.Y , MyBigBox.W , MyBigBox.H , Prompt , it , Cancelled );
{$ENDIF}
	GetStringFromUser := it;
end;

Procedure MoreTextRedraw;
var
	MyPromptZone,MyTextZone: TSDL_Rect;
begin
	MyTextZone := ZONE_MoreText.GetRect();
	MyPromptZone := ZONE_MorePrompt.GetRect();
	if ( NIL <> MoreTextRedrawer ) then MoreTextRedrawer();
	InfoBox( MyTextZone );
	InfoBox( MyPromptZone );
	CMessage( MsgString( 'MORETEXT_Prompt' ) , MyPromptZone , InfoGreen );
end;

Function MoreHighFirstLine( LList: SAttListPtr ): Integer;
	{ Determine the highest possible FirstLine value. }
var
	it: Integer;
begin
	it := NumSAttList( LList ) - ( ZONE_MoreText.H  div  TTF_FontLineSkip( game_font ) ) + 1;
	if it < 1 then it := 1;
	MoreHighFirstLine := it;
end;

Procedure MoreText( LList: SAttListPtr; FirstLine: Integer; ReDrawer: RedrawProcedureType );
	{ Browse this text file across the majority of the screen. }
	{ Clear the screen upon exiting, though restoration of the }
	{ previous display is someone else's responsibility. }
var
	MT_tmp: SAttListPtr;

	Procedure DisplayTextHere( const MyZone: TSDL_Rect );
	var
		T: Integer;
		MyDest: TSDL_Rect;
		MyImage: PSDL_Surface;
		CLine: SAttListElementPtr;	{ Current Line }
	begin
		{ Set the clip area. }
		SDL_SetClipRect( Game_Screen , @MyZone );
		MyDest := MyZone;

		{ Error check. }
		if ( -1 = FirstLine ) then begin
			FirstLine := NumSAttList( MT_tmp ) - ( ZONE_MoreText.H  div  TTF_FontLineSkip( game_font ) ) + 1;
		end;
		if ( FirstLine < 1 ) then begin
			FirstLine := 1
		end else if ( NumSAttList( MT_tmp ) < FirstLine ) then begin
			FirstLine := NumSAttList( MT_tmp );
		end;

		CLine := RetrieveSAttList( MT_tmp , FirstLine );
		for t := 1 to ( MyZone.H  div  TTF_FontLineSkip( game_font ) ) do begin
			if CLine <> Nil then begin
				MyImage := UTF8_TTF_RenderText( game_font , CLine^.Info , SDLNeutralGrey );
				SDL_BlitSurface( MyImage , Nil , Game_Screen , @MyDest );
				SDL_FreeSurface( MyImage );
				MyDest.Y := MyDest.Y + TTF_FontLineSkip( game_font );
				CLine := CLine^.Next;
			end;
		end;

		if (Animation_Phase div 10 mod 2) = 1 then begin
			if FirstLine > 1 then begin
				MyDest.X := MyZone.X + MyZone.W - 16;
				MyDest.Y := MyZone.Y;
				QuickText('+', MyDest, MenuSelect, Game_Font );
			end;
			if CLine <> Nil then begin
				MyDest.X := MyZone.X + MyZone.W - 16;
				MyDest.Y := MyZone.Y + MyZone.H - TTF_FontLineSkip( game_font );
				QuickText('+', MyDest, MenuSelect, Game_Font );
			end;
		end;

		{ Restore the clip area. }
		SDL_SetClipRect( Game_Screen , Nil );
		DoFlip;
	end;
var
	A: Char;
	msg: String;
	NextWord: String;
	TheLine: String;
	cont: Boolean;
	stored: Boolean;
	RPM: RPGMenuPtr;
	t, t_max: Integer;
	CLine: SAttListElementPtr;	{ Current Line }
	MyPromptZone,MyTextZone: TSDL_Rect;
begin
	if SDL_Show_MenuScrollbar then begin
		RPM := CreateRPGMenu( SDLNeutralGrey , MenuSelect , @ZONE_MoreText );
		CLine := RetrieveSAttList( LList , 1 );
		t_max := NumSAttList( LList );
		for t := 1 to t_max do begin
			msg := CLine^.Info;
			TheLine := '';
			NextWord := '';
			cont := false;
			stored := false;
			repeat
				GetNextLine( TheLine , msg , NextWord , ZONE_MoreText.W , game_font );
				if ('' <> TheLine) then begin
					if cont then begin
						AddRPGMenuItem( RPM , #$0 + TheLine , SELECTMENU_Cancel );
					end else begin
						AddRPGMenuItem( RPM , TheLine , SELECTMENU_Cancel );
						cont := true;
					end;
					stored := true;
				end;
				TheLine := NextWord;
			until ('' = TheLine);
			if not stored then begin
				AddRPGMenuItem( RPM , '' , SELECTMENU_Cancel );
			end;
			CLine := CLine^.Next;
		end;
		if ( -1 = FirstLine ) then begin
			FirstLine := RPM^.NumItem - ( ZONE_MoreText.H  div  TTF_FontLineSkip( game_font ) ) + 1;
		end;
		if ( FirstLine < 1 ) then begin
			FirstLine := 1
		end else if ( RPM^.NumItem < FirstLine ) then begin
			FirstLine := RPM^.NumItem;
		end;
		RPM^.TopItem := FirstLine;
		SetItemByPosition( RPM, FirstLine );
		MoreTextRedrawer := Redrawer;
		MoreTextRedraw();
		SelectMenu( RPM , @MoreTextRedraw );
		DisposeRPGMenu( RPM );

		SDL_SetClipRect( Game_Screen , NIL );
	end else begin
		MT_tmp := CreateSAttList;
		CLine := LList^.head;
		while ( NIL <> CLine ) do begin
			msg := CLine^.Info;
			TheLine := '';
			NextWord := '';
			stored := false;
			repeat
				GetNextLine( TheLine , msg , NextWord , ZONE_Dialog.W , game_font );
				if ( '' <> TheLine ) then begin
					StoreSAttList( MT_tmp , TheLine );
					stored := true;
				end;
				TheLine := NextWord;
			until ( '' = TheLine );
			if not stored then begin
				StoreSAttList( MT_tmp , '' );
			end;
			CLine := CLine^.Next;
		end;

		repeat
			{ Get input from user. }
			A := RPGKeyEvent;

			{ Possibly process this input. }
			if (KBD_NONE = A) then begin
			end else if (A = KeyMap[ KMC_MenuDown ].KCode) or (A = KeyMap[ KMC_ButtonWDown ].KCode) then begin
				Inc( FirstLine );
			end else if (A = KeyMap[ KMC_MenuUp ].KCode) or (A = KeyMap[ KMC_ButtonWUp ].KCode) then begin
				Dec( FirstLine );
			end else if A = RPK_TimeEvent then begin
				MyTextZone := ZONE_MoreText.GetRect();
				MyPromptZone := ZONE_MorePrompt.GetRect();
				if Redrawer <> Nil then Redrawer();
				InfoBox( MyTextZone );
				InfoBox( MyPromptZone );
				CMessage( MsgString( 'MORETEXT_Prompt' ) , MyPromptZone , InfoGreen );

				{ Display the screen. }
				DisplayTextHere( MyTextZone );
			end;

		until ( KBD_ESC = A ) or ( 'Q' = A );

		DisposeSAttList( MT_tmp );
	end;
end;

Procedure RedrawConsole;
	{ Redraw the console. Yay! }
var
	CH_tmp: SAttListPtr;
	SL: SAttListElementPtr;
	MyZone,MyDest: TSDL_Rect;
	NumLines,LineNum: Integer;
	msg: String;
	NextWord: String;
	TheLine: String;
begin
	{Clear the message area, and set clipping bounds.}
	MyZone := ZONE_Dialog.GetRect();
	InfoBox( MyZone );
	SDL_SetClipRect( Game_Screen , @MyZone );

	MyDest := MyZone;
	NumLines := ( MyZone.H div TTF_FontLineSkip( game_font ) ) + 1;

	CH_tmp := CreateSAttList;

	SL := RetrieveSAttList( Console_History , NumSAttList( Console_History ) - NumLines + 1 );
	if ( NIL = SL ) then begin
		SL := Console_History^.head;
	end;
	while ( NIL <> SL ) do begin
		msg := SL^.Info;
		TheLine := '';
		NextWord := '';
		repeat
			GetNextLine( TheLine , msg , NextWord , ZONE_Dialog.W , game_font );
			if ( '' <> TheLine ) then begin
				StoreSAttList( CH_tmp , TheLine );
			end;
			TheLine := NextWord;
		until ( '' = TheLine );
		SL := SL^.Next;
	end;

	LineNum := NumLines;
	SL := RetrieveSAttList( CH_tmp , NumSAttList( CH_tmp ) - NumLines + 1 );
	if ( NIL = SL ) then begin
		SL := CH_tmp^.head;
		LineNum := NumSAttList( CH_tmp );
	end;
	while ( NIL <> SL ) do begin
		msg := SL^.Info;

		{ Set the coords for this line. }
		MyDest.X := MyZone.X;
		MyDest.Y := MyZone.Y + MyZone.H - LineNum * TTF_FontLineSkip( game_font );

		{ Output the line. }
		QuickText( SL^.Info , MyDest , InfoGreen , Game_font );

		Dec( LineNum );
		SL := SL^.Next;
	end;

	DisposeSAttList( CH_tmp );

	{ Restore the clip zone to the full screen. }
	SDL_SetClipRect( Game_Screen , Nil );
end;

Procedure DialogMsg( msg: string );
	{ Print a message in the scrolling dialog box, }
	{ then store the line in Console_History. }
	{ Don't worry about screen output since the console will be redrawn the next time }
	{ the screen updates. }
begin
	{ CLean up the message a bit. }
	DeleteWhiteSpace( msg );
	if msg = '' then Exit;
	msg := '> ' + Msg;

	if ( Console_History_Length <= NumSAttList( Console_History ) ) then begin
		RemoveSAttList( Console_History , Console_History^.head );
	end;
	StoreSAttList( Console_History , msg );
end;

Procedure DrawBPBorder;
	{ Draw borders for the backpack display. }
var
	MyRect: TSDL_Rect;
begin
	MyRect := ZONE_BPTotal.GetRect();
	ClearExtendedBorder( MyRect );
	SDL_FillRect( game_screen , @MyRect , SDL_MapRGB( Game_Screen^.Format , SDLBorderBlue.R , SDLBorderBlue.G , SDLBorderBlue.B ) );
	ClearExtendedBorder( ZONE_EqpMenu.GetRect() );
	ClearExtendedBorder( ZONE_InvMenu.GetRect() );
	ClearExtendedBorder( ZONE_BPHeader.GetRect() );
	ClearExtendedBorder( ZONE_BackpackInstructions.GetRect() );
	ClearExtendedBorder( ZONE_BPInfo.GetRect() );
	FillRectWithSprite( ZONE_BPInfo.GetRect(), Infobox_Backdrop, 0 );
end;



Procedure DrawGetItemBorder;
	{ Draw borders for the get item display. }
begin
	InfoBox( ZONE_GetItemMenu );
end;


Procedure SetupInteractDisplay( TeamColor: TSDL_Color );
	{ Draw the display for the interaction interface. }
var
	MyDest: TSDL_Rect;
begin
	MyDest := ZONE_InteractTotal.GetRect();
	ClearExtendedBorder( MyDest );
	SDL_FillRect( game_screen , @MyDest , SDL_MapRGB( Game_Screen^.Format , TeamColor.R , TeamColor.G , TeamColor.B ) );
	ClearExtendedBorder( ZONE_InteractStatus.GetRect() );
	ClearExtendedBorder( ZONE_InteractMsg.GetRect() );
	ClearExtendedBorder( ZONE_InteractMenu.GetRect() );
	ClearExtendedBorder( ZONE_InteractPhoto.GetRect() );
	ClearExtendedBorder( ZONE_InteractInfo.GetRect() );
end;

Procedure SetupServicesDisplay;
	{ Draw the display for the services interface. }
begin
	InfoBox( ZONE_ShopTop.GetRect() );
	InfoBox( ZONE_ShopBottom.GetRect() );
	InfoBox( ZONE_ShopInfo.GetRect() );
	InfoBox( ZONE_ShopCash.GetRect() );
end;

Procedure SetupFHQDisplay;
	{ Draw the display for the services interface. }
begin
	InfoBox( ZONE_FieldHQMenu.GetRect() );
	InfoBox( ZONE_ItemsInfo.GetRect() );
end;

Procedure SetupMemoDisplay;
	{ Set up the memo display. }
begin
	InfoBox( ZONE_MemoTotal );
end;

Procedure DrawMonologueBorder;
	{ Draw the border for the monologue. }
begin
	InfoBox( ZONE_MonologueTotal.getRect() );
end;

Function GrowRect( MyRect: TSDL_Rect; GrowX,GrowY: Integer ): TSDL_Rect;
	{ Expand this rect by the requested amount, remaining centered on the }
	{ original rect. }
begin
	MyRect.x := MyRect.x - GrowX;
	MyRect.y := MyRect.y - GrowY;
	MyRect.w := MyRect.w + 2 * GrowX;
	MyRect.h := MyRect.h + 2 * GrowY;
	GrowRect := MyRect;
end;

Procedure FillRectWithSprite( MyRect: TSDL_Rect; MySprite: SensibleSpritePtr; MyFrame,OffX,OffY: Integer );
	{ Fill this area of the screen perfectly with the provided sprite. }
var
	MyDest: TSDL_Rect;
	X,Y,GridW,GridH: Integer;
begin
	GridW := MyRect.W div MySprite^.W + 1;
	GridH := MyRect.H div MySprite^.H + 1;
	SDL_SetClipRect( Game_Screen , @MyRect );

	MyRect.X := MyRect.X + (OffX mod MySprite^.W) - MySprite^.W;
	MyRect.Y := MyRect.Y + (OffY mod MySprite^.H) - MySprite^.H;

	{ Draw the backdrop. }
	for X := 0 to GridW do begin
		MyDest.X := MyRect.X + X * MySprite^.W;
		for Y := 0 to GridH do begin
			MyDest.Y := MyRect.Y + Y * MySprite^.H;
			DrawSprite( MySprite , MyDest , MyFrame );
		end;
	end;

	SDL_SetClipRect( Game_Screen , Nil );
end;

Procedure FillRectWithSprite( MyRect: TSDL_Rect; MySprite: SensibleSpritePtr; MyFrame: Integer );
	{ Do a FillRect with offset 0,0. }
begin
	FillRectWithSprite( MyRect, MySprite, MyFrame, 0, 0 );
end;

Procedure InfoBox( MyBox: TSDL_Rect );
	{ Do a box for drawing something else inside of. }
const
	tex_width = 16;
	border_width = tex_width div 2;
	half_dat = border_width div 2;
var
	MyFill,Dest: TSDL_Rect;
	X0,Y0,W32,H32,X,Y: Integer;
begin
	{ Fill the middle of the box with the backdrop. }
	MyFill := GrowRect( MyBox, 4, 4 );
	FillRectWithSprite( MyFill, Infobox_Backdrop, 0 );

	{ Expand the rect to its full dimensions, and draw the outline. }
	MyFill := GrowRect( MyBox, 8, 8 );
	DrawSprite( Infobox_Border , MyFill , 0 );

	Dest.X := MyFill.X;
	Dest.Y := MyFill.Y + MyFill.H - 8;
	DrawSprite( Infobox_Border , Dest , 4 );

	Dest.X := MyFill.X + MyFill.W - 8;
	Dest.Y := MyFill.Y;
	DrawSprite( Infobox_Border , Dest , 3 );

	Dest.X := MyFill.X + MyFill.W - 8;
	Dest.Y := MyFill.Y + MyFill.H - 8;
	DrawSprite( Infobox_Border , Dest , 5 );

	MyFill := GrowRect( MyBox, 0, 8 );
	SDL_SetClipRect( Game_Screen , @MyFill );
	for X := 0 to ( MyFill.W div 8 + 1 ) do begin
		Dest.X := MyFill.X + X * 8;
		Dest.Y := MyFill.Y;
		DrawSprite( Infobox_Border , Dest , 1 );
		Dest.Y := MyFill.Y + MyFill.H - 8;
		DrawSprite( Infobox_Border , Dest , 1 );
	end;
	MyFill := GrowRect( MyBox, 8, 0 );
	SDL_SetClipRect( Game_Screen , @MyFill );
	for Y := 0 to ( MyFill.H div 8 + 1 ) do begin
		Dest.Y := MyFill.Y + Y * 8;
		Dest.X := MyFill.X;
		DrawSprite( Infobox_Border , Dest , 2 );
		Dest.X := MyFill.X + MyFill.W - 8;
		DrawSprite( Infobox_Border , Dest , 2 );
	end;
	SDL_SetClipRect( Game_Screen , Nil );
end;

Procedure InfoBox( MyBox: DynamicRect );
	{ Do a box for drawing something else inside of. }
begin
	InfoBox( MyBox.GetRect() );
end;

Procedure Idle_Display;
	{ Something is happening that's likely to take a long time. Load an idle }
	{ image from disk and show it to the user. }
var
	FList: SAttListPtr;
	PFName: PChar;
	MyImage: PSDL_Surface;
	MyDest: TSDL_Rect;
begin
	{ Create a list of all the images in the idle_pics drawer. }
	FList := CreateFileList( Graphics_Directory + 'poster_*.*' , False );
	if 0 < NumSAttList( FList ) then begin
		{ Load one at random, and display it. }
		PFName := QuickPCopy( Graphics_Directory + SelectRandomSAttList( FList )^.Info );
		MyImage := IMG_Load( PFName );
		SDL_BlitSurface( MyImage , Nil , Game_Screen , Nil );
		DoFlip;
		SDL_FreeSurface( MyImage );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
		sysutils.StrDispose( PFName );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
	end;
	DisposeSAttList( FList );
end;

Procedure SetupArenaDisplay;
	{ Draw the borders for all the arena-mode menus. }
begin
	SDL_FillRect( game_screen , Nil , SDL_MapRGBA( Game_Screen^.Format , SDLBorderBlue.R , SDLBorderBlue.G , SDLBorderBlue.B , SDL_ALPHA_OPAQUE ) );
	InfoBox( ZONE_ArenaInfo );
	InfoBox( ZONE_ArenaPilotMenu );
	InfoBox( ZONE_ArenaMechaMenu );
	InfoBox( ZONE_PCStatus );
	RedrawConsole;
end;

Procedure SetupArenaMissionMenu;
	{ Set up the menu from which the mission will be selected in arena mode. }
begin
	InfoBox( ZONE_SAMTotal );
{	ClearExtendedBorder( ZONE_SAMText );
	ClearExtendedBorder( ZONE_SAMMenu );}
end;

Procedure SetupConcertDisplay;
	{ Set up the concert display. }
begin
	InfoBox( ZONE_ConcertTotal );
{	ClearExtendedBorder( ZONE_ConcertAudience );
	ClearExtendedBorder( ZONE_ConcertCaption );
	ClearExtendedBorder( ZONE_ConcertMenu );
	ClearExtendedBorder( ZONE_ConcertDesc );
	ClearExtendedBorder( ZONE_ConcertPhoto );}
end;

Procedure SetupTitleScreenDisplay;
	{ Draw the title screen. }
var
	MyRect: TSDL_Rect;
begin
	SDL_FillRect( Game_Screen , Nil , SDL_MapRGB( Game_Screen^.Format , SDLClearColor.R , SDLClearColor.G , SDLClearColor.B ) );
	MyRect.X := 0;
	MyRect.Y := 0;
	MyRect.W := Game_Screen^.W;
	MyRect.H := Game_Screen^.H;
	FillRectWithSprite(MyRect,Title_Stars,0,Animation_Phase,Animation_Phase div 2);
	DrawSprite( Title_Logo, ZONE_TitleLogo.GetRect(), 0 );
	InfoBox( ZONE_Title_Screen_Menu );
	{SDL_BlitSurface( Title_Screen^.Img , Nil , Game_Screen , Nil );}

end;


Function SearchAndOpenFont( const FontInfo: PFontSearchNameDesc; arg_ptsize: integer ): PTTF_Font;
const
	TmpLen = 255;
var
	i, j: Integer;
	FontFile: String;
	tmp: array[0..TmpLen] of Char;
	ptsize: Integer;
begin
	SearchAndOpenFont := NIL;
	for j := 0 to (MaxFontSearchNameNum-1) do begin
		for i := 1 to MaxFontSearchDirNum do begin
			if 0 < Length(FontSearchDir[i]) then begin
				FontFile := FontSearchDir[i] + OS_Dir_Separator + FontInfo[j].FontFile;
			end else begin
				FontFile := FontInfo[j].FontFile;
			end;
			ptsize := arg_ptsize;
			if ptsize <= 0 then begin
				ptsize := FontInfo[j].FontSize;
			end;
			if 0 < Length(FontInfo[j].FontFile) then begin
				StrPCopy( tmp, FontFile );
{$IFDEF DEBUG}
				ErrorMessage_fork( '[Name:' + BStr(j) + ';Dir:' + BStr(i) + ']=' + FontFile );
{$ENDIF DEBUG}
				SearchAndOpenFont := TTF_OpenFontIndex( @tmp, ptsize, FontInfo[j].FontFace );
				if (NIL <> SearchAndOpenFont) then
					break;
			end;
		end;
		if (NIL <> SearchAndOpenFont) then
			break;
	end;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: sdlgfx.pp');
{$ENDIF DEBUG}
	UTF8_Width_Of_One_Character := UTF8_Settings('SDLGFX_UTF8_WIDTH_OF_ONE_CHARACTER','M');

	Game_Font := NIL;
	Reset_SIZE;
	Preset_SIZE( SDL_ScreenWidth , SDL_ScreenHeight );

	SDL_Init( SDL_INIT_VIDEO or SDL_INIT_TIMER or SDL_INIT_AUDIO );

	SDL_VideoModeFlag := 0;
	if DoFullScreen then begin
		SDL_VideoModeFlag := ( SDL_DOUBLEBUF or SDL_FULLSCREEN );
		Game_Screen := SDL_SetVideoMode(ScreenWidth, ScreenHeight, 32, SDL_VideoModeFlag );
	end else begin
		SDL_VideoModeFlag := ( SDL_HWSURFACE or SDL_DoubleBuf or SDL_RESIZABLE );
{		Game_Screen := SDL_SetVideoMode(ScreenWidth, ScreenHeight, 0, SDL_DOUBLEBUF or SDL_HWSURFACE );}
		Game_Screen := SDL_SetVideoMode(ScreenWidth, ScreenHeight, 0, SDL_VideoModeFlag );
		if ( ( -1 <> SDL_ScreenPosX ) and ( -1 <> SDL_ScreenPosY ) ) then begin
			SDL_VERSION( wmi.version );
			if ( 1 = SDL_GetWMInfo( @wmi ) ) then begin
{$IFDEF Unix}
				Pointer(gX11_Lock) := wmi.x11.lock_func;
				Pointer(gX11_Unlock) := wmi.x11.unlock_func;
				gX11_Lock;
				xlib.XMoveWindow( wmi.x11.display , wmi.x11.wmwindow , SDL_ScreenPosX , SDL_ScreenPosY );
				gX11_Unlock;
{$ENDIF Unix}
{$IFDEF Windows}
				Windows.GetWindowRect( wmi.window , @r );
				Windows.MoveWindow( wmi.window , SDL_ScreenPosX , SDL_ScreenPosY , ( r.right - r.left ) , ( r.bottom - r.top ) , FALSE );
{$ENDIF Windows}
			end;
		end;
	end;

	if Ersatz_Mouse then SDL_ShowCursor( SDL_Disable );

	ClrScreen;
	SDL_SetColorKey( Game_Screen , SDL_SRCCOLORKEY or SDL_RLEACCEL , SDL_MapRGB( Game_Screen^.Format , SDLTransparentColor.R , SDLTransparentColor.G , SDLTransparentColor.B ) );

        SDL_EnableUNICODE( 1 );
	SDL_EnableKeyRepeat( KEY_REPEAT_DELAY , KEY_REPEAT_INTERVAL );

	TTF_Init;

	Game_Font := SearchAndOpenFont( @FontSearchName_Big , FontSize );
	Small_Font := SearchAndOpenFont( @FontSearchName_Small , SmallFontSize );
	Info_Font := SearchAndOpenFont( @FontSearchName_Info , InfoFontSize );

	Preset_ZONE_Clock;

	Game_Sprites := Nil;

	Cursor_Sprite := LocateSprite( 'cursor.png' , 8 , 16 );
	Title_Screen := LocateSprite( 'title_screen.png' , 800 , 600 );
	Title_Stars := LocateSprite( 'sys_titlescreenbackground.png' , 512 , 512 );
	Title_Logo := LocateSprite( 'sys_logo.png' , 623 , 161 );
	Ersatz_Mouse_Sprite := LocateSprite( 'ersatz_mouse.png' , 16 , 16 );

	Console_History := CreateSAttList;

	Last_Clock_Update := 0;

	if Splash_Screen_At_Start then begin
{$IFDEF PATCH_GH_PARANOID_SAFER}
{$ELSE PATCH_GH_PARANOID_SAFER}
		Randomize();
{$ENDIF PATCH_GH_PARANOID_SAFER}
		Idle_Display;
	end;

	SDL_WM_SetCaption( WindowName , IconName );

	Infobox_Border := LocateSprite( 'sys_boxborder.png' , 8 , 8 );
	Infobox_Backdrop := LocateSprite( 'sys_boxbackdrop.png' , 16 , 16 );

	if Transparent_Interface then SDL_SetAlpha( Infobox_Backdrop^.Img , SDL_SRCAlpha , 224 );

	Mix_OpenAudio( MIX_DEFAULT_FREQUENCY , MIX_DEFAULT_FORMAT , 2 , 4096 );
	Mix_AllocateChannels( 16 );
	Load_SoundEffect;
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: sdlgfx.pp(finalization)');
{$ENDIF DEBUG}
	Dispose_SoundEffect;
	Mix_CloseAudio;
	DisposeSAttList( Console_History );
	DisposeSpriteList( Game_Sprites );
	TTF_CloseFont( Game_Font );
	TTF_CloseFont( Small_Font );
	TTF_CloseFont( Info_Font );
	TTF_Quit;

	SDL_FreeSurface( Game_Screen );
	SDL_Quit;
end;

end.
