unit se;
{$LONGSTRINGS ON}

interface

uses gears;

const
	SoundEffect_Type_Fire = 'Fire';
	SoundEffect_Type_Destroyed = 'Destroyed';
	SoundEffect_Type_AmmoExplosion = 'AmmoExplosion';
	SoundEffect_Type_CriticalEngineFailure = 'CriticalEngineFailure';

Function GetName_SoundEffect( const SE_Type: String; const Part: GearPtr ): String;



implementation

uses
{$IFDEF DEBUG}
	errmsg,
{$ENDIF DEBUG}
	gears_base,
	ghmodule,ghweapon;

const
	SoundEffect_Header = 'SoundEffect_';
	SoundEffect_DefaultSE_Header = 'DefaultSE_';

var
	Sound_Settings_SAtt: SAttArrayPtr;

Function GetName_SoundEffect( const SE_Type: String; const Part: GearPtr ): String;
var
	SE_Name: String;
	SE_GG, SE_GS: String;
	Search_Name: String;
begin
	SE_Name := SAttArrayValue( Part^.SA , SoundEffect_Header + SE_Type );

	if ( '' = SE_Name ) then begin
		SE_GG := '';
		SE_GS := '';
		case Part^.G of
			GG_Mecha: SE_GG := 'Mecha';
			GG_Module: begin
					SE_GG := 'Module';
					Case Part^.S of
						GS_Body: SE_GS := 'Body';
						GS_Head: SE_GS := 'Head';
						GS_Arm: SE_GS := 'Arm';
						GS_Leg: SE_GS := 'Leg';
						GS_Wing: SE_GS := 'Wing';
						GS_Tail: SE_GS := 'Tail';
						GS_Turret: SE_GS := 'Turret';
						GS_Storage: SE_GS := 'Storage';
					end;
				end;
			GG_Character: SE_GG := 'Char';
			GG_Cockpit: SE_GG := 'Cockpit';
			GG_Weapon: begin
					SE_GG := 'Weapon';
					Case Part^.S of
						GS_Melee: SE_GS := 'Melee';
						GS_EMelee: SE_GS := 'EMelee';
						GS_Ballistic: SE_GS := 'Ballistic';
						GS_BeamGun: SE_GS := 'BeamGun';
						GS_Missile: SE_GS := 'Missile';
						GS_Grenade: SE_GS := 'Grenade';
					end;
				end;
			GG_Ammo: begin
					SE_GG := 'Ammo';
					Case Part^.S of
						GS_Melee: SE_GS := 'Melee';
						GS_EMelee: SE_GS := 'EMelee';
						GS_Ballistic: SE_GS := 'Ballistic';
						GS_BeamGun: SE_GS := 'BeamGun';
						GS_Missile: SE_GS := 'Missile';
						GS_Grenade: SE_GS := 'Grenade';
					end;
				end;
			GG_MoveSys: SE_GG := 'MoveSys';
			GG_Holder: SE_GG := 'Holder';
			GG_Sensor: SE_GG := 'Sensor';
			GG_Support: SE_GG := 'Support';
			GG_Shield: SE_GG := 'Shield';
			GG_ExArmor: SE_GG := 'ExArmor';
			GG_Treasure: SE_GG := 'Treasure';
			GG_Prop: SE_GG := 'Prop';
			GG_MetaTerrain: ;
			GG_Tool: SE_GG := 'Tool';
			GG_RepairFuel: SE_GG := 'RepairFuel';
			GG_Consumable: SE_GG := 'Consumable';
			GG_Modifier: SE_GG := 'Modifier';
			GG_WeaponAddOn: SE_GG := 'WeaponAddOn';
			GG_PowerSource: SE_GG := 'PowerSource';
			GG_Computer: SE_GG := 'Computer';
			GG_Software: SE_GG := 'Software';
			GG_Harness: SE_GG := 'Harness';
			GG_Usable: SE_GG := 'Usable';
		end;
		if ( '' = SE_GG ) then begin
			Search_Name := SoundEffect_DefaultSE_Header + SE_Type;
		end else if ( '' = SE_GS ) then begin
			Search_Name := SoundEffect_DefaultSE_Header + SE_Type + '_' + SE_GG;
		end else begin
			Search_Name := SoundEffect_DefaultSE_Header + SE_Type + '_' + SE_GG + '_' + SE_GS;
		end;
		SE_Name := SAttArrayValue( Sound_Settings_SAtt , Search_Name );
{$IFDEF DEBUG}
		if ( '' = SE_Name ) then begin
			ErrorMessage_fork( 'PlaySoundEffect() Label Not Found : ' + Search_Name );
		end;
{$ENDIF DEBUG}
	end;

	GetName_SoundEffect := SE_Name;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: se.pp');
{$ENDIF DEBUG}
	Sound_Settings_SAtt := LoadStringArray( Sound_Settings_File );
end;


finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: se.pp(finalization)');
{$ENDIF DEBUG}
	DisposeSAttArray( Sound_Settings_SAtt );
end;

end.
