unit ui4gh;
	{ User Interface for GearHead. }
	{ This unit exists to keep me from copying changes back and forth between }
	{ the SDL mode units and the CRT mode units... }
{
	GearHead2, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}
{$LONGSTRINGS ON}


interface

uses gears_base,gears,texutil,dos,sdl;

type
	KeyMapDesc = Record
		CmdName,CmdDesc: String;
		isacommand: Boolean;		{ Return TRUE if this key is a command. }
		KCode: Char;
	end;

	KeyMapAliasDesc = Record
		CmdAlias: String;
		CmdName: String;
	end;

	T_KCodeAlias = Record
		KCode_from: Char;
		KCode_to: Char;
	end;

	FontSearchNameDesc = Record
		FontFile: String;
		FontFace: Integer;
		FontSize: Integer;
	end;
	PFontSearchNameDesc = ^FontSearchNameDesc;

const
	KBD_F1  = #$A0;
	KBD_F2  = #$A1;
	KBD_F3  = #$A2;
	KBD_F4  = #$A3;
	KBD_F5  = #$A4;
	KBD_F6  = #$A5;
	KBD_F7  = #$A6;
	KBD_F8  = #$A7;
	KBD_F9  = #$A8;
	KBD_F10 = #$A9;
	KBD_F11 = #$AA;
	KBD_F12 = #$AB;
	KBD_F13 = #$AC;
	KBD_F14 = #$AD;
	KBD_F15 = #$AE;
	KBD_F16 = #$AF;
	KBD_F17 = #$B0;
	KBD_F18 = #$B1;
	KBD_F19 = #$B2;
	KBD_F20 = #$B3;
	KBD_LWin   = #$C0;
	KBD_RWin   = #$C1;
	KBD_Apps   = #$C2;
	KBD_Home   = #$C3;
	KBD_Up     = #$C4;
	KBD_PgUp   = #$C5;
	KBD_Left   = #$C6;
	KBD_KP5    = #$C7;
	KBD_Right  = #$C8;
	KBD_End    = #$C9;
	KBD_Down   = #$CA;
	KBD_PgDn   = #$CB;
	KBD_Insert = #$CC;
	KBD_Delete = #$CD;
	KBD_BS  = #$08;
	KBD_TAB = #$09;
	KBD_RET = #$0D;
	KBD_LF  = #$0A;
	KBD_ESC = #$1B;
	KBD_CTRL_A = #$01;
	KBD_CTRL_B = #$02;
	KBD_CTRL_C = #$03;
	KBD_CTRL_D = #$04;
	KBD_CTRL_E = #$05;
	KBD_CTRL_F = #$06;
	KBD_CTRL_G = #$07;
	KBD_CTRL_H = #$08;
	KBD_CTRL_I = #$09;
	KBD_CTRL_J = #$0A;
	KBD_CTRL_K = #$0B;
	KBD_CTRL_L = #$0C;
	KBD_CTRL_M = #$0D;
	KBD_CTRL_N = #$0E;
	KBD_CTRL_O = #$0F;
	KBD_CTRL_P = #$10;
	KBD_CTRL_Q = #$11;
	KBD_CTRL_R = #$12;
	KBD_CTRL_S = #$13;
	KBD_CTRL_T = #$14;
	KBD_CTRL_U = #$15;
	KBD_CTRL_V = #$16;
	KBD_CTRL_W = #$17;
	KBD_CTRL_X = #$18;
	KBD_CTRL_Y = #$19;
	KBD_CTRL_Z = #$1A;
	KBD_UNICODE_FLAG = #$80;
	KBD_NONE   = #$00;
	KBD_ERROR  = #$FF;

	RPK_UpRight = '9';
	RPK_Up = '8';
	RPK_UpLeft = '7';
	RPK_Left = '4';
	RPK_Right = '6';
	RPK_DownRight = '3';
	RPK_Down = '2';
	RPK_DownLeft = '1';
	RPK_Center = '5';
	RPK_MouseButton = #$90;
	RPK_RightButton = #$91;
	RPK_MouseButtonRelease = #$92;
	RPK_MouseMotion = #$93;
	RPK_TimeEvent = #$94;

	FrameDelay: Integer = 30;

	MenuBasedInput = 0;
	RLBasedInput = 1;
	ControlMethod: Byte = RLBasedInput;
	CharacterMethod: Byte = RLBasedInput;
	WorldMapMethod: Byte = RLBasedInput;
	ControlTypeName: Array [0..1] of string = ('Menu','Roguelike');

	DoFullScreen: Boolean = False;
	Mouse_Active: Boolean = True;

	Always_Save_Character: Boolean = False;
	No_Combat_Taunts: Boolean = False;
	Pillage_On: Boolean = True;

	RPG_Use_Tactics: Boolean = False;
	Arena_Use_Tactics: Boolean = True;

	TacticsRoundLength: Integer = 60;
	Tactics_Turn_In_Progess: Boolean = False;

	XXRan_Wizard: Boolean = False;
	ArenaMode_Wizard: Boolean = False;

	PC_SHOULD_RUN: Boolean = False;

	Names_Above_Heads: Boolean = False;

	Cycle_All_Weapons: Boolean = False;

	Splash_Screen_At_Start: Boolean = True;

	Transparent_Interface: Boolean = True;

	BV_Off = 1;
	BV_Quarter = 2;
	BV_Half = 3;
	BV_Max = 4;
	DefMissileBV: Byte = BV_Quarter;
	DefBallisticBV: Byte = BV_Max;
	DefBeamgunBV: Byte = BV_Max;
	BVTypeName: Array [1..4] of string = ('Off','1/4','1/2','Max');

	DoAutoSave: Boolean = True;

	Load_Plots_At_Start: Boolean = False;

	Reload_All_Weapons: Boolean = False;

	Display_Mini_Map: Boolean = FaLSE;
	Display_Mini_Map_with_All_Gears: Boolean = False;

	{ *** SCREEN DIMENSIONS *** }
{$IFDEF WIN32}
	Default_ScreenRows = 25;
	ScreenRows: Byte = 25;
{$ELSE WIN32}
  {$IFDEF ASCII_SDL}
	Default_ScreenRows = 25;
	ScreenRows: Byte = 25;
  {$ELSE ASCII_SDL}
	Default_ScreenRows = 24;
	ScreenRows: Byte = 24;
  {$ENDIF ASCII_SDL}
{$ENDIF WIN32}
	Default_ScreenColumns = 80;
	ScreenColumns: Byte = 80;

	SDL_ScreenPosX: Integer = -1;
	SDL_ScreenPosY: Integer = -1;
{$IFDEF MINI}
	SDL_ScreenWidth: Integer = 640;
	SDL_ScreenHeight: Integer = 480;
	FontSize_Big: Integer = 9;
	FontSize_Small: Integer = 8;
	FontSize_Info: Integer = 11;
{$ELSE}
	SDL_ScreenWidth: Integer = 800;
	SDL_ScreenHeight: Integer = 600;
	FontSize_Big: Integer = 12;
	FontSize_Small: Integer = 9;
	FontSize_Info: Integer = 11;
{$ENDIF}
	SDL_Show_MenuScrollbar: Boolean = False;
	SDL_Scrollbar_Size: Integer = 10;

	ASCII_Show_MenuScrollbar: Boolean = False;

	DEBUG_Print_TimeString : Boolean = False;
	DEBUG_Autosave_Trace : Boolean = False;
	DEBUG_Disable_ProtectedMode_at_PlotDeadend : Boolean = False;
	DEBUG_CanSeeAll : Boolean = False;

	EXTEND_CallShot : Boolean = False;
	EXTEND_LookInfo : Boolean = False;

	SHOW_EqpMenu_SubItem : Boolean = False;
	SHOW_EqpMenu_SubItem_FullGearName : Boolean = False;
	SHOW_EquipItem_ParentItem : Boolean = False;
	SHOW_EquipItem_InvStr : Boolean = False;
	SHOW_EquipItem_SubItem : Boolean = False;
	SHOW_InvMenu_SubItem : Boolean = False;
	SHOW_InstallMisc_ParentItem : Boolean = False;
	SHOW_InstallMisc_InvStr : Boolean = False;
	SHOW_InstallMisc_Hit : Boolean = False;
	SHOW_Install_SubItem : Boolean = False;
	SHOW_InstallAmmo_SubItem : Boolean = False;
	SHOW_InstallCyberware_SubItem : Boolean = False;
	SHOW_SellStuff_SubItem : Boolean = False;
	SHOW_BuyStuff_SubItem : Boolean = False;
	SHOW_Phone_AddressList : Boolean = False;
	SHOW_EqpMenu_MassMeter : Boolean = False;
	SHOW_AmmoExplosion : Boolean = False;
	SHOW_CriticalEngineFailure : Boolean = False;
	SHOW_AttemptDefenses : Boolean = False;
	SHOW_NPCStatus_FieldHQ : Boolean = False;
	SHOW_Pillage : Boolean = False;
	SHOW_EnvironmentIdents : Boolean = False;
	SHOW_ComponentMass : Boolean = False;

	ENABLE_NumKeyMenu : Boolean = False;
	DISABLE_SInfo_CharaDex : Boolean = False;

	ENABLE_MouseClick_OutsideTheMenuArea : Boolean = False;

	CHEAT_Load_CHA : Boolean = False;
	CHEAT_Display_Class : Boolean = False;
	CHEAT_Display_PV : Boolean = False;
	CHEAT_No_CockpitBarrier : Boolean = False;
	CHEAT_No_CockpitBarrier_Hand : Boolean = False;
	CHEAT_No_NeedStamina_MekFullSpeed : Boolean = False;
	CHEAT_DoNotRunWhenMouseClicked : Boolean = False;
	CHEAT_AmmoDiscount : Boolean = False;
	CHEAT_Multiplex_SelectEquipmentForNPC : Boolean = False;
	CHEAT_Forcibly_Pillage : Boolean = False;
	CHEAT_NPC_Edit : Boolean = False;
	CHEAT_Unlimited_Sprite : Boolean = False;
	CHEAT_Unlimited_Portrait : Boolean = False;
	CHEAT_Allow_Nameson_When_Unknown : Boolean = False;
	CHEAT_No_CheckPhonelist_Memo : Boolean = False;
	CHEAT_No_CheckPhonelist_Telephone_Gameboard : Boolean = False;
	CHEAT_No_CheckPhonelist_Telephone_RootScene : Boolean = False;
	CHEAT_No_CheckPhonelist_Telephone_Keyword : Boolean = False;
	CHEAT_Show_RollHistory : Boolean = False;
	CHEAT_ShowRep : Boolean = False;
	CHEAT_ShowSF : Boolean = False;
	CHEAT_AppearToTheSpace : Boolean = False;
	CHEAT_MechaCustomize_FreeSupport : Boolean = False;
	CHEAT_MechaCustomize_FreeCockpit : Boolean = False;
	CHEAT_MechaCustomize_FreeScale : Boolean = False;
	CHEAT_MechaCustomize_FreeModifier : Boolean = False;
	CHEAT_MechaCustomize_FreeBodyModule : Boolean = False;
	CHEAT_NPC_AvoidAttackToNeutrality : Boolean = False;
	CHEAT_NPC_UseGrenade : Boolean = False;
	CHEAT_DoNotRoundUp_ARP : Boolean = False;
	CHEAT_ReloadAllMecha : Boolean = False;
	CHEAT_DoNotConsider_LancemateTacticsPersona_in_SayAnything : Boolean = False;
	CHEAT_Shops_Customize_Mecha : Boolean = False;
	CHEAT_QuickFire_Attacks_Indiscriminately : Boolean = False;
	CHEAT_DoTraining_RegardlessOfPet : Boolean = False;
	CHEAT_Can_Disassemble_HomeMadeRobot : Boolean = False;
	CHEAT_Show_WeaponRecharge : Boolean = False;
	CHEAT_Range_Colored : Boolean = False;
	CHEAT_Range_with_Altitude : Boolean = False;
	CHEAT_Fix_SolveLine : Boolean = False;
	CHEAT_Show_RangeCover : Boolean = False;
	CHEAT_SelectSprite : Boolean = False;

	ADJUST_ComponentComplexity_with_Scale : Boolean = False;

	EDIT_MenuOrder : Boolean = False;
	BrowseMemo_NoReturn_after_PhoneCall : Boolean = False;

	ProhibitationHead  : String = '! ) , . > ? ] }';
	ProhibitationTrail : String = '( < [ {';

	Revert_Slower_Safer: Boolean = False;

	XXRan_Debug: Boolean = False;
	StdPlot_Debug: Boolean = False;
	DEBUG_ON_arenaplay: Boolean = False;
	DEBUG_ON_arenascript: Boolean = False;


	NumMappedKeys = 92;
	KeyMap: Array [1..NumMappedKeys] of KeyMapDesc = (
	(	CmdName: 'NormSpeed';
		CmdDesc: 'Travel foreword at normal speed.';
		IsACommand: True;
		KCode: '=';	),
	(	CmdName: 'FullSpeed';
		CmdDesc: 'Travel foreword at maximum speed';
		IsACommand: True;
		KCode: '+';	),
	(	CmdName: 'TurnLeft';
		CmdDesc: 'Turn to the left.';
		IsACommand: True;
		KCode: '[';	),
	(	CmdName: 'TurnRight';
		CmdDesc: 'Turn to the right.';
		IsACommand: True;
		KCode: ']';	),
	(	CmdName: 'Stop';
		CmdDesc: 'Stop moving, wait in place.';
		IsACommand: True;
		KCode: '5';	),

	(	CmdName: 'Dir-SouthWest';
		CmdDesc: 'Move southwest.';
		IsACommand: True;
		KCode: RPK_DownLeft;	),
	(	CmdName: 'Dir-South';
		CmdDesc: 'Move south.';
		IsACommand: True;
		KCode: RPK_Down;	),
	(	CmdName: 'Dir-SouthEast';
		CmdDesc: 'Move southeast.';
		IsACommand: True;
		KCode: RPK_DownRight;	),
	(	CmdName: 'Dir-West';
		CmdDesc: 'Move west.';
		IsACommand: True;
		KCode: RPK_Left;	),
	(	CmdName: 'Dir-East';
		CmdDesc: 'Move east.';
		IsACommand: True;
		KCode: RPK_Right;	),

	(	CmdName: 'Dir-NorthWest';
		CmdDesc: 'Move northwest.';
		IsACommand: True;
		KCode: RPK_UpLeft;	),
	(	CmdName: 'Dir-North';
		CmdDesc: 'Move north.';
		IsACommand: True;
		KCode: RPK_Up;	),
	(	CmdName: 'Dir-NorthEast';
		CmdDesc: 'Move northeast.';
		IsACommand: True;
		KCode: RPK_UpRight;	),
	(	CmdName: 'ShiftGears';
		CmdDesc: 'Change movement mode.';
		IsACommand: True;
		KCode: '.';	),
	(	CmdName: 'Look';
		CmdDesc: 'Look around the map.';
		IsACommand: True;
		KCode: 'l';	),

	(	CmdName: 'AttackMenu';
		CmdDesc: 'Access the attack menu.';
		IsACommand: True;
		KCode: 'A';	),
	(	CmdName: 'QuitGame';
		CmdDesc: 'Exit the game.';
		IsACommand: True;
		KCode: 'Q';	),
	(	CmdName: 'Talk';
		CmdDesc: 'Initiate conversation with a NPC.';
		IsACommand: True;
		KCode: 't';	),
	(	CmdName: 'Help';
		CmdDesc: 'View these helpful messages.';
		IsACommand: True;
		KCode: 'h';	),
	(	CmdName: 'SwitchWeapon';
		CmdDesc: 'Change the active weapon while selecting a target.';
		IsACommand: True;
		KCode: '.';	),

	(	CmdName: 'CalledShot';
		CmdDesc: 'Toggle the Called Shot option while selecting a target.';
		IsACommand: False;
		KCode: '/';	),
	(	CmdName: 'Get';
		CmdDesc: 'Pick up an item lying on the ground.';
		IsACommand: True;
		KCode: ',';	),
	(	CmdName: 'Inventory';
		CmdDesc: 'Access all carried items.';
		IsACommand: True;
		KCode: 'i';	),
	(	CmdName: 'Equipment';
		CmdDesc: 'Access all equipped items.';
		IsACommand: True;
		KCode: 'e';	),
	(	CmdName: 'Enter';
		CmdDesc: 'Use a stairway or portal.';
		IsACommand: True;
		KCode: '>';	),

	{ Commands 26 - 30 }
	(	CmdName: 'PartBrowser';
		CmdDesc: 'Examine the individual components of your PC.';
		IsACommand: True;
		KCode: 'B';	),
	(	CmdName: 'LearnSkills';
		CmdDesc: 'Spend accumulated experience points.';
		IsACommand: True;
		KCode: 'L';	),
	(	CmdName: 'Attack';
		CmdDesc: 'Perform an attack.';
		IsACommand: True;
		KCode: 'a';	),
	(	CmdName: 'SelectMecha';
		CmdDesc: 'Choose the mecha that will be used by this PC in combat.';
		IsACommand: True;
		KCode: 'M';	),
	(	CmdName: 'UseScenery';
		CmdDesc: 'Activate a stationary item, such as a door or a computer.';
		IsACommand: True;
		KCode: 'u';	),

	{ Commands 31 - 35 }
	(	CmdName: 'Messages';
		CmdDesc: 'Review all current adventure memos, email, and news.';
		IsACommand: True;
		KCode: 'm';	),
	(	CmdName: 'SaveGame';
		CmdDesc: 'Write the game data to disk, so you can come back and waste time later.';
		IsACommand: True;
		KCode: 'X';	),
	(	CmdName: 'Enter2';
		CmdDesc: 'Use a stairway or portal.';
		IsACommand: True;
		KCode: '<';	),
	(	CmdName: 'CharInfo';
		CmdDesc: 'View detailed information about your character, access option menus.';
		IsACommand: True;
		KCode: 'C';	),
	(	CmdName: 'ApplySkill';
		CmdDesc: 'Select and use a skill that the PC knows.';
		IsACommand: True;
		KCode: 's';	),

	{ Commands 36 - 40 }
	(	CmdName: 'Eject';
		CmdDesc: 'Eject from your mecha and abandon it on the field.';
		IsACommand: True;
		KCode: 'E';	),
	(	CmdName: 'Rest';
		CmdDesc: 'Take a break for one hour of game time.';
		IsACommand: True;
		KCode: 'Z';	),
	(	CmdName: 'History';
		CmdDesc: 'Display past messages.';
		IsACommand: True;
		KCode: 'V';	),
	(	CmdName: 'FieldHQ';
		CmdDesc: 'Examine and edit your personal wargear.';
		IsACommand: True;
		KCode: 'H';	),
	(	CmdName: 'Search';
		CmdDesc: 'Check the area for enemies and secrets.';
		IsACommand: True;
		KCode: 'S';	),

	{ Commands 41 - 45 }
	(	CmdName: 'Telephone';
		CmdDesc: 'Place a telephone call to a local NPC.';
		IsACommand: True;
		KCode: 'T';	),
	(	CmdName: 'SwitchBV';
		CmdDesc: 'Switch the Burst Fire option while selecting a target.';
		IsACommand: False;
		KCode: '>';	),
	(	CmdName: 'Reverse';
		CmdDesc: 'Travel backward at normal speed.';
		IsACommand: True;
		KCode: '-';	),
	(	CmdName: 'SwitchTarget';
		CmdDesc: 'Switch to next visible enemy when selecting a target.';
		IsACommand: False;
		KCode: ';';	),
	(	CmdName: 'RunToggle';
		CmdDesc: 'Toggle running on or off.';
		IsACommand: True;
		KCode: 'r';	),

	{ Commands 46 - 50 }
	(	CmdName: 'WallToggle';
		CmdDesc: 'Toggle short walls in graphical mode.';
		IsACommand: True;
		KCode: 'W';	),
	(	CmdName: 'QuickFire';
		CmdDesc: 'Single-key automatic targeting attack.';
		IsACommand: True;
		KCode: 'f'; ),
	(	CmdName: 'RollHistory';
		CmdDesc: 'View the skill roll history.';
		IsACommand: True;
		KCode: 'R'; ),
	(	CmdName: 'ExamineTarget';
		CmdDesc: 'Examine a target closely.';
		IsACommand: False;
		KCode: '?'; ),
	(	CmdName: 'PartyMode';
		CmdDesc: 'Toggle between clock mode and tactics mode.';
		IsACommand: True;
		KCode: 'P'; ),

	{ Commands 51 - 55 }
	(	CmdName: 'UseSystem';
		CmdDesc: 'Use one of the special systems in a mecha.';
		IsACommand: True;
		KCode: 'U'; ),
	(	CmdName: 'CanSeeAll';
		CmdDesc: 'DEBUG Can See All';
		IsACommand: True;
		KCode: '|'; ),
	(	CmdName: 'MenuOrder_Edit';
		CmdDesc: 'Edit MenuOrder';
		IsACommand: False;
		KCode: '\'; ),
	(	CmdName: 'MenuOrder_SortAlpha';
		CmdDesc: 'Sort MenuOrder by Alpha';
		IsACommand: False;
		KCode: '{'; ),
	(	CmdName: 'MenuOrder_SortValue';
		CmdDesc: 'Sort MenuOrder by Value';
		IsACommand: False;
		KCode: '}'; ),

	{ Commands 56 - 60 }
	(	CmdName: 'WheelClick';
		CmdDesc: 'Do the key event when a mouse wheel is clicked.';
		IsACommand: True;
		KCode:	'5'; ),
	(	CmdName: 'WheelUp';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to up.';
		IsACommand: True;
		KCode:	'['; ),
	(	CmdName: 'WheelDown';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to down.';
		IsACommand: True;
		KCode:	']'; ),
	(	CmdName: 'WheelLeft';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to left.';
		IsACommand: True;
		KCode:	'-'; ),
	(	CmdName: 'WheelRight';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to right.';
		IsACommand: True;
		KCode:	'='; ),

	{ Commands 61 - 65 }
	(	CmdName: 'WheelBack';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to back.';
		IsACommand: True;
		KCode:	'-'; ),
	(	CmdName: 'WheelForward';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to forward.';
		IsACommand: True;
		KCode:	'='; ),
	(	CmdName: 'ChatMessage2DialogMSG';
		CmdDesc: 'CHEAT Chat Message to Dialog Message';
		IsACommand: False;
		KCode:	'.'; ),
	(	CmdName: 'SelectPortrait';
		CmdDesc: 'CHEAT Select Portrait';
		IsACommand: False;
		KCode:	'/'; ),
	(	CmdName: 'RenameMecha';
		CmdDesc: 'CHEAT Rename Mecha';
		IsACommand: False;
		KCode:	'@'; ),

	{ Commands 66 - 70 }
	(	CmdName: 'SwitchMenu';
		CmdDesc: 'Switch Menu to Menu';
		IsACommand: False;
		KCode:	'/'; ),
	(	CmdName: 'AttackCalledShot';
		CmdDesc: 'Switch Called Shot';
		IsACommand: False;
		KCode:	'/'; ),
	(	CmdName: 'AttackRecharge';
		CmdDesc: 'Recharge Weapons';
		IsACommand: False;
		KCode:	'.'; ),
	(	CmdName: 'AttackOptions';
		CmdDesc: 'Options for Attack';
		IsACommand: False;
		KCode:	'?'; ),
	(	CmdName: 'Menu-Up';
		CmdDesc: 'Move Up.';
		IsACommand: False;
		KCode: RPK_Up;	),

	{ Commands 71 - 75 }
	(	CmdName: 'Menu-Down';
		CmdDesc: 'Move Down.';
		IsACommand: False;
		KCode: RPK_Down;	),
	(	CmdName: 'Menu-Left';
		CmdDesc: 'Move Left.';
		IsACommand: False;
		KCode: RPK_Left;	),
	(	CmdName: 'Menu-Right';
		CmdDesc: 'Move Right.';
		IsACommand: False;
		KCode: RPK_Right;	),
	(	CmdName: 'Menu-PageUp';
		CmdDesc: 'Page Up.';
		IsACommand: False;
		KCode: RPK_UpRight;	),
	(	CmdName: 'Menu-PageDown';
		CmdDesc: 'Page Down.';
		IsACommand: False;
		KCode: RPK_DownRight;	),

	{ Commands 76 - 80 }
	(	CmdName: 'Menu-ScrollUp';
		CmdDesc: 'Scroll Up.';
		IsACommand: False;
		KCode: RPK_UpLeft;	),
	(	CmdName: 'Menu-ScrollDown';
		CmdDesc: 'Scroll Down.';
		IsACommand: False;
		KCode: RPK_DownLeft;	),
	(	CmdName: 'SearchParent';
		CmdDesc: 'Search Parent';
		IsACommand: False;
		KCode:	'@'; ),
	(	CmdName: 'SearchForward';
		CmdDesc: 'Search Forward';
		IsACommand: False;
		KCode:	KBD_CTRL_F; ),
	(	CmdName: 'SearchBackward';
		CmdDesc: 'Search Backward';
		IsACommand: False;
		KCode:	KBD_CTRL_B; ),

	{ Commands 81 - 85 }
	(	CmdName: 'DEBUG_ForcePlot';
		CmdDesc: 'DEBUG_ForcePlot';
		IsACommand: False;
		KCode: '}'; ),
	(	CmdName: 'DEBUG_BrowseDesignFile_InvCom';
		CmdDesc: 'DEBUG_BrowseDesignFile_InvCom';
		IsACommand: False;
		KCode: '!'; ),
	(	CmdName: 'DEBUG_BrowseDesignFile_SubCom';
		CmdDesc: 'DEBUG_BrowseDesignFile_SubCom';
		IsACommand: False;
		KCode: '$'; ),
	(	CmdName: 'DEBUG_SpitContents';
		CmdDesc: 'DEBUG_SpitContents';
		IsACommand: False;
		KCode: '^'; ),
	(	CmdName: 'DEBUG_BrowseDesignFile_Meks';
		CmdDesc: 'DEBUG_BrowseDesignFile_Meks';
		IsACommand: False;
		KCode: '*'; ),

	{ Commands 86 - 90 }
	(	CmdName: 'DEBUG_ShowRep';
		CmdDesc: 'DEBUG_ShowRep';
		IsACommand: False;
		KCode: '@'; ),
	(	CmdName: 'DEBUG_ShowSkillXP';
		CmdDesc: 'DEBUG_ShowSkillXP';
		IsACommand: False;
		KCode: '~'; ),
	(	CmdName: 'DEBUG_DirectScript';
		CmdDesc: 'DEBUG_DirectScript';
		IsACommand: False;
		KCode: '#'; ),
	(	CmdName: 'DEBUG_SkillRollHistory';
		CmdDesc: 'DEBUG_SkillRollHistory';
		IsACommand: False;
		KCode: '%'; ),
	(	CmdName: 'DEBUG_GodMode';
		CmdDesc: 'DEBUG_GodMode';
		IsACommand: False;
		KCode: '|'; ),

	{ Commands 91 - }
	(	CmdName: 'DEBUG_CheckMissionGivers';
		CmdDesc: 'DEBUG_CheckMissionGivers';
		IsACommand: False;
		KCode: '`'; ),
	(	CmdName: 'ToggleSkipAnim';
		CmdDesc: 'Toggle skip animation.';
		IsACommand: True;
		KCode: KBD_F9;	)

	);

	KeyMapAliasMax = 9;

	KeyMapAlias: Array [1..KeyMapAliasMax] of KeyMapAliasDesc = (
	(	CmdAlias: 'Dir-UpLeft';		CmdName:  'Dir-NorthWest'; ),
	(	CmdAlias: 'Dir-Up';		CmdName:  'Dir-North'; ),
	(	CmdAlias: 'Dir-UpRight';	CmdName:  'Dir-NorthEast'; ),
	(	CmdAlias: 'Dir-Left';		CmdName:  'Dir-West'; ),
	(	CmdAlias: 'Dir-Right';		CmdName:  'Dir-East'; ),
	(	CmdAlias: 'Dir-DownLeft';	CmdName:  'Dir-SouthWest'; ),
	(	CmdAlias: 'Dir-Down';		CmdName:  'Dir-South'; ),
	(	CmdAlias: 'Dir-DownRight';	CmdName:  'Dir-SouthEast'; ),
	( CmdAlias: ''; CmdName:  ''; )
	);

	KCodeAliasMax = 128;
	KCodeAlias: Array [1..(KCodeAliasMax+1)] of T_KCodeAlias = (
		( KCode_from: KBD_PgUp ; KCode_to: '9'      ; ),
		( KCode_from: KBD_Up   ; KCode_to: '8'      ; ),
		( KCode_from: KBD_Home ; KCode_to: '7'      ; ),
		( KCode_from: KBD_Left ; KCode_to: '4'      ; ),
		( KCode_from: KBD_Right; KCode_to: '6'      ; ),
		( KCode_from: KBD_PgDn ; KCode_to: '3'      ; ),
		( KCode_from: KBD_Down ; KCode_to: '2'      ; ),
		( KCode_from: KBD_End  ; KCode_to: '1'      ; ),
		( KCode_from: KBD_KP5  ; KCode_to: '5'      ; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; ),
		( KCode_from: KBD_ERROR; KCode_to: KBD_ERROR; )
	);

	{ *** KEYMAP COMMAND NUMBERS *** }
	KMC_NormSpeed = 1;
	KMC_FullSpeed = 2;
	KMC_TurnLeft = 3;
	KMC_TurnRight = 4;
	KMC_Stop = 5;
	KMC_SouthWest = 6;
	KMC_South = 7;
	KMC_SouthEast = 8;
	KMC_West = 9;
	KMC_East = 10;
	KMC_NorthWest = 11;
	KMC_North = 12;
	KMC_NorthEast = 13;
	KMC_ShiftGears = 14;
	KMC_ExamineMap = 15;
	KMC_AttackMenu = 16;
	KMC_QuitGame = 17;
	KMC_Talk = 18;
	KMC_Help = 19;
	KMC_SwitchWeapon = 20;
	KMC_CalledShot = 21;
	KMC_Get = 22;
	KMC_Inventory = 23;
	KMC_Equipment = 24;
	KMC_Enter = 25;
	KMC_PartBrowser = 26;
	KMC_LearnSkills = 27;
	KMC_Attack = 28;
	KMC_SelectMecha = 29;
	KMC_UseProp = 30;
	KMC_ViewMemo = 31;
	KMC_SaveGame = 32;
	KMC_Enter2 = 33;
	KMC_CharInfo = 34;
	KMC_ApplySkill = 35;
	KMC_Eject = 36;
	KMC_Rest = 37;
	KMC_History = 38;
	KMC_FieldHQ = 39;
	KMC_Search = 40;
	KMC_Telephone = 41;
	KMC_SwitchBV = 42;
	KMC_Reverse = 43;
	KMC_SwitchTarget = 44;
	KMC_RunToggle = 45;
	KMC_WallToggle = 46;
	KMC_QuickFire = 47;
	KMC_RollHistory = 48;
	KMC_ExamineTarget = 49;
	KMC_PartyMode = 50;
	KMC_UseSystem = 51;
	KMC_CanSeeAll = 52;
	KMC_MenuOrder_Edit      = 53;
	KMC_MenuOrder_SortAlpha = 54;
	KMC_MenuOrder_SortValue = 55;
	KMC_ButtonMiddle   = 56;
	KMC_ButtonWUp      = 57;
	KMC_ButtonWDown    = 58;
	KMC_ButtonWLeft    = 59;
	KMC_ButtonWRight   = 60;
	KMC_ButtonWBack    = 61;
	KMC_ButtonWForward = 62;
	KMC_ChatMessage_to_DialogMSG = 63;
	KMC_SelectPortrait = 64;
	KMC_RenameMecha = 65;
	KMC_SwitchMenu = 66;
	KMC_AttackCalledShot = 67;
	KMC_AttackRecharge = 68;
	KMC_AttackOptions = 69;
	KMC_MenuUP = 70;
	KMC_MenuDown = 71;
	KMC_MenuLeft = 72;
	KMC_MenuRight = 73;
	KMC_PageUp = 74;
	KMC_PageDown = 75;
	KMC_ScrollUp = 76;
	KMC_ScrollDown = 77;
	KMC_SearchParent = 78;
	KMC_SearchForward = 79;
	KMC_SearchBackward = 80;
	KMC_DEBUG_ForcePlot = 81;
	KMC_DEBUG_BrowseDesignFile_InvCom = 82;
	KMC_DEBUG_BrowseDesignFile_SubCom = 83;
	KMC_DEBUG_SpitContents = 84;
	KMC_DEBUG_BrowseDesignFile_Meks = 85;
	KMC_DEBUG_ShowRep = 86;
	KMC_DEBUG_ShowSkillXP = 87;
	KMC_DEBUG_DirectScript = 88;
	KMC_DEBUG_SkillRollHistory = 89;
	KMC_DEBUG_GodMode = 90;
	KMC_DEBUG_CheckMissionGivers = 91;
	KMC_ToggleSkipAnim = 92;
	{ Meta keymap }
	KMC_UpLeft = 11;
	KMC_Up = 12;
	KMC_UpRight = 13;
	KMC_Left = 9;
	KMC_Right = 10;
	KMC_DownLeft = 6;
	KMC_Down = 7;
	KMC_DownRight = 8;

{$IF DEFINED(UNIX)}
	MaxFontSearchDirNum = 11;
	FontSearchDir: Array [1..MaxFontSearchDirNum] of String = (
		'',						{ Read from gearhead.cfg }
		'image',					{ default directory }
		'',						{ current directory }
		'/usr/local/share/fonts/gnu-unifont-ttf',	{ Failback Directory, FreeBSD 9.x and later }
		'/usr/local/share/fonts/OTF',			{ Failback Directory, FreeBSD 9.x and later }
		'/usr/local/share/fonts/TTF',			{ Failback Directory, FreeBSD 9.x and later }
		'/usr/local/lib/X11/fonts/TrueType',		{ Failback Directory, FreeBSD 6.3 and later }
		'/usr/X11R6/lib/X11/fonts/TrueType',		{ Failback Directory, FreeBSD 6.2 and before, some Distribution of GNU/Linux }
		'/usr/share/fonts/truetype/unifont',		{ Failback Directory, Debian GNU/Linux }
		'/usr/share/fonts/truetype/sazanami',		{ Failback Directory, Debian GNU/Linux }
		'/usr/share/fonts/opentype/ipafont-gothic'	{ Failback Directory, Debian GNU/Linux }
	);
	MaxFontSearchNameNum = 15;
	FontSearchName_Big: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from gearhead.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 1 }
			FontFile: 'unifont.ttf';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 2 }
			FontFile: 'fonts-japanese-gothic.ttf';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 3 }
			FontFile: 'fonts-japanese-mincho.ttf';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 4 }
			FontFile: 'ipag.otf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 5 }
			FontFile: 'ipam.otf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 6 }
			FontFile: 'ipag.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 7 }
			FontFile: 'ipam.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 8 }
			FontFile: 'sazanami-gothic.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 9 }
			FontFile: 'sazanami-mincho.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 10 }
			FontFile: 'kochi-gothic-subst.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 11 }
			FontFile: 'kochi-mincho-subst.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 12 }
			FontFile: 'kochi-gothic.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 13 }
			FontFile: 'kochi-mincho.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, Default }
			FontFile: 'VeraBd.ttf';
			FontFace: 0;
			FontSize: 11;
		)
	);
	FontSearchName_Small: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from gearhead.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 9;
		), (	{ Failback Font, 1 }
			FontFile: 'unifont.ttf';
			FontFace: 0;
			FontSize: 9;
		), (	{ Failback Font, 2 }
			FontFile: 'fonts-japanese-gothic.ttf';
			FontFace: 0;
			FontSize: 9;
		), (	{ Failback Font, 3 }
			FontFile: 'fonts-japanese-mincho.ttf';
			FontFace: 0;
			FontSize: 9;
		), (	{ Failback Font, 4 }
			FontFile: 'ipag.otf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 5 }
			FontFile: 'ipam.otf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 6 }
			FontFile: 'ipag.ttf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 7 }
			FontFile: 'ipam.ttf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 8 }
			FontFile: 'sazanami-gothic.ttf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 9 }
			FontFile: 'sazanami-mincho.ttf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 10 }
			FontFile: 'kochi-gothic-subst.ttf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 11 }
			FontFile: 'kochi-mincho-subst.ttf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 12 }
			FontFile: 'kochi-gothic.ttf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 13 }
			FontFile: 'kochi-mincho.ttf';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, Default }
			FontFile: 'VeraBd.ttf';
			FontFace: 0;
			FontSize: 9;
		)
	);
	FontSearchName_Info: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from gearhead.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 1 }
			FontFile: 'unifont.ttf';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 2 }
			FontFile: 'fonts-japanese-gothic.ttf';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 3 }
			FontFile: 'fonts-japanese-mincho.ttf';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 4 }
			FontFile: 'ipag.otf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 5 }
			FontFile: 'ipam.otf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 6 }
			FontFile: 'ipag.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 7 }
			FontFile: 'ipam.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 8 }
			FontFile: 'sazanami-gothic.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 9 }
			FontFile: 'sazanami-mincho.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 10 }
			FontFile: 'kochi-gothic-subst.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 11 }
			FontFile: 'kochi-mincho-subst.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 12 }
			FontFile: 'kochi-gothic.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 13 }
			FontFile: 'kochi-mincho.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, Default }
			FontFile: 'VeraMoBd.ttf';
			FontFace: 0;
			FontSize: 11;
		)
	);
{$ELSEIF DEFINED(WINDOWS)}
	MaxFontSearchDirNum = 7;
	FontSearchDir: Array [1..MaxFontSearchDirNum] of String = (
		'',			{ Read from gearhead.cfg }
		'image',		{ default directory }
		'',			{ current directory }
		'',			{ Failback Directory, Read environment %windir% or %SystemRoot% }
		'C:\Windows\Fonts',	{ Failback Directory, MS-Windows 7 / 8 / 8.1 / Wine }
		'C:\WINDOWS\Fonts',	{ Failback Directory, MS-Windows XP }
		'C:\WINNT\Fonts'	{ Failback Directory, MS-Windows 2000 }
	);
	MaxFontSearchNameNum = 5;
	FontSearchName_Big: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from gearhead.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 1 }
			FontFile: 'msgothic.ttc';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 2 }
			FontFile: 'msmincho.ttc';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 3 }
			FontFile: 'meiryo.ttc';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, Default }
			FontFile: 'VeraBd.ttf';
			FontFace: 0;
			FontSize: 11;
		)
	);
	FontSearchName_Small: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from gearhead.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 9;
		), (	{ Failback Font, 1 }
			FontFile: 'msgothic.ttc';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 2 }
			FontFile: 'msmincho.ttc';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, 3 }
			FontFile: 'meiryo.ttc';
			FontFace: 0;
			FontSize: 10;
		), (	{ Failback Font, Default }
			FontFile: 'VeraBd.ttf';
			FontFace: 0;
			FontSize: 9;
		)
	);
	FontSearchName_Info: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from gearhead.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 11;
		), (	{ Failback Font, 1 }
			FontFile: 'msgothic.ttc';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 2 }
			FontFile: 'msmincho.ttc';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, 3 }
			FontFile: 'meiryo.ttc';
			FontFace: 0;
			FontSize: 12;
		), (	{ Failback Font, Default }
			FontFile: 'VeraMoBd.ttf';
			FontFace: 0;
			FontSize: 11;
		)
	);
{$ELSE}
	MaxFontSearchDirNum = 3;
	FontSearchDir: Array [1..MaxFontSearchDirNum] of String = (
		'',			{ Read from gearhead.cfg }
		'image',		{ default directory }
		''			{ current directory }
	);
	MaxFontSearchNameNum = 2;
	FontSearchName_Big: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from gearhead.cfg }
			FontFile: '';
			FontFace: 0;
		), (	{ Failback Font, Default }
			FontFile: 'VeraBd.ttf';
			FontFace: 0;
		)
	);
	FontSearchName_Small: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from gearhead.cfg }
			FontFile: '';
			FontFace: 0;
		), (	{ Failback Font, Default }
			FontFile: 'VeraBd.ttf';
			FontFace: 0;
		)
	);
	FontSearchName_Info: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from gearhead.cfg }
			FontFile: '';
			FontFace: 0;
		), (	{ Failback Font, Default }
			FontFile: 'VeraMoBd.ttf';
			FontFace: 0;
		)
	);
{$ENDIF}
	SDL_AAFont        : Boolean = False;
	SDL_AAFont_Shaded : Boolean = False;

	{ sdlgfx.pp }
{$IFDEF ASCII}
	SDLStdBlack: TSDL_Color =		( r:  5; g:  5; b:  5 );
	SDLStdWhite: TSDL_Color =		( r:255; g:255; b:255 );
	SDLMenuItem: TSDL_Color =		( r: 88; g:161; b:159 );
	SDLMenuSelect: TSDL_Color =		( r:125; g:250; b:125 );
	SDLPlayerBlue: TSDL_Color =		( r:  0; g:141; b:211 );
	SDLEnemyRed: TSDL_Color =		( r:230; g:  0; b:  0 );
	SDLInfoGreen: TSDL_Color =		( r:  0; g:240; b:  0 );
	SDLInfoHiLight: TSDL_Color =		( r: 70; g:255; b: 70 );
	SDLMelodyYellow: TSDL_Color =		( r:250; g:200; b: 0  );
{$ELSE ASCII}
	StdBlack: TSDL_Color =			( r:  5; g:  5; b:  5 );
	StdWhite: TSDL_Color =			( r:255; g:255; b:255 );
	MenuItem: TSDL_Color =			( r: 88; g:161; b:159 );
	MenuSelect: TSDL_Color =		( r:125; g:250; b:125 );
	PlayerBlue: TSDL_Color =		( r:  0; g:141; b:211 );
	EnemyRed: TSDL_Color =			( r:230; g:  0; b:  0 );
	InfoGreen: TSDL_Color =			( r:  0; g:240; b:  0 );
	InfoHiLight: TSDL_Color =		( r: 70; g:255; b: 70 );
	MelodyYellow: TSDL_Color =		( r:250; g:200; b: 0  );
{$ENDIF ASCII}
	SDLAvocado: TSDL_Color =		( r:136; g:141; b:101 );
	SDLBacardi: TSDL_Color =		( r:121; g:105; b:137 );
	SDLJade: TSDL_Color =			( r: 66; g:121; b:119 );
	SDLBrightJade: TSDL_Color =		( r:100; g:200; b:180 );
	SDLClearColor: TSDL_Color =		( r:  0; g:  0; b:  0 );
	SDLBackgroundColor: TSDL_Color =	( r:  0; g:  0; b:255 );
	SDLInfoBoxColor: TSDL_Color =		( r: 10; g:  0; b: 70 );
	SDLTerrainGreen: TSDL_Color =		( r:100; g:210; b:  0 );
	SDLAllyPurple: TSDL_Color =		( r:236; g:  0; b:211 );
	SDLNeutralGrey: TSDL_Color =		( r:150; g:150; b:150 );
	SDLDarkGrey: TSDL_Color =		( r:100; g:100; b:100 );
	SDLTextboxGrey: TSDL_Color =		( r:130; g:120; b:125 );
	SDLNeutralBrown: TSDL_Color =		( r:230; g:191; b: 81 );
	SDLBorderBlue: TSDL_Color =		( r:  0; g:101; b:151 );
	SDLCyan: TSDL_Color =			( r:  0; g:255; b:155 );
	SDLBorderColor: TSDL_Color =		( r:200; g: 50; b:  0 );
	SDLTransparentColor: TSDL_Color =	( r:  0; g:  0; b:255 );
	{ sdlinfo.pp }
	SDLStatusPerfect: TSDL_Color =		( r:  0; g:255; b: 65 );
	SDLStatusOK: TSDL_Color =		( r: 30; g:190; b: 10 );
	SDLStatusFair: TSDL_Color =		( r:220; g:190; b:  0 );
	SDLStatusBad: TSDL_Color =		( r:220; g: 50; b:  0 );
	SDLStatusCritical: TSDL_Color =		( r:150; g:  0; b:  0 );
	SDLStatusKO: TSDL_Color =		( r: 75; g: 75; b: 75 );
	{ sdlmap.pp }
	SDLWallBrown: TSDL_Color =		( R: 76; G: 64; B: 51 );
	SDLDoorBlue: TSDL_Color =		( R:  0; G:128; B:128 );
	SDLWallGray: TSDL_Color =		( R: 70; G: 70; B: 55 );	{ For the low wall. }
	SDLSmokeGray: TSDL_Color =		( R:155; G:150; B:150 );
	SDLToxicGreen: TSDL_Color =		( R: 50; G:170; B: 15 );
	{ maped.pas }
	SDLBlack: TSDL_Color =			( R:  0; G:  0; B:  0 );
	SDLBlue: TSDL_Color =			( R:  0; G:  0; B:192 );
	SDLGreen: TSDL_Color =			( R:  0; G:128; B:  0 );
	{SDLCyan: TSDL_Color =			( R:  0; G:128; B:128 );}
	SDLRed: TSDL_Color =			( R:192; G:  0; B:  0 );
	SDLMagenta: TSDL_Color =		( R:128; G:  0; B:128 );
	SDLBrown: TSDL_Color =			( R:128; G: 96; B:  0 );
	SDLLightGray: TSDL_Color =		( R:192; G:192; B:192 );
	SDLDarkGray: TSDL_Color =		( R:128; G:128; B:128 );
	SDLLightBlue: TSDL_Color =		( R:  0; G:  0; B:255 );
	SDLLightGreen: TSDL_Color =		( R:  0; G:255; B:  0 );
	SDLLightCyan: TSDL_Color =		( R:  0; G:255; B:255 );
	SDLLightRed: TSDL_Color =		( R:255; G:  0; B:  0 );
	SDLLightMagenta: TSDL_Color =		( R:255; G:  0; B:255 );
	SDLYellow: TSDL_Color =			( R:255; G:255; B:  0 );
	SDLWhite: TSDL_Color =			( R:255; G:255; B:255 );

	Direct_Skill_Learning: Boolean = False;

	Thorough_Redraw: Boolean = False;
	Use_Tall_Walls: Boolean = True;

	Iso_Dir_Offset: Integer = 0;
	Ersatz_Mouse: Boolean = False;

	SkipAnim : Boolean = False;
	Minimal_Screen_Refresh: Boolean = False;
	Use_Software_Surface: Boolean = False;
	Use_Paper_Dolls: Boolean = False;
	Mesh_On: Boolean = False;


	Full_RPGWorld_Info: Boolean = False;

var
	Text_Messages: SAttArrayPtr;


Function MsgString( const MsgLabel: String ): String;

Function UTF8_Help_Keymap_Name_String( const MsgLabel: String ): String;
Function UTF8_Help_Keymap_Desc_String( const MsgLabel: String ): String;
Function KeyMapEncode( const header: String; const src: Char ): String;


implementation

uses errmsg, sysutils,utf8msg;

type
	T_KCodeName = Record
		KCodeName: String;
		KCode: Char;
	end;

	T_SDLColorTable = Record
		Name: String;
		DataPtr: PSDL_Color;
	end;

const
	KCodeName: Array [1..68] of T_KCodeName = (
		( KCodeName: 'F1';	KCode: KBD_F1; ),
		( KCodeName: 'F2';	KCode: KBD_F2; ),
		( KCodeName: 'F3';	KCode: KBD_F3; ),
		( KCodeName: 'F4';	KCode: KBD_F4; ),
		( KCodeName: 'F5';	KCode: KBD_F5; ),
		( KCodeName: 'F6';	KCode: KBD_F6; ),
		( KCodeName: 'F7';	KCode: KBD_F7; ),
		( KCodeName: 'F8';	KCode: KBD_F8; ),
		( KCodeName: 'F9';	KCode: KBD_F9; ),
		( KCodeName: 'F10';	KCode: KBD_F10; ),
		( KCodeName: 'F11';	KCode: KBD_F11; ),
		( KCodeName: 'F12';	KCode: KBD_F12; ),
		( KCodeName: 'F13';	KCode: KBD_F13; ),
		( KCodeName: 'F14';	KCode: KBD_F14; ),
		( KCodeName: 'F15';	KCode: KBD_F15; ),
		( KCodeName: 'F16';	KCode: KBD_F16; ),
		( KCodeName: 'F17';	KCode: KBD_F17; ),
		( KCodeName: 'F18';	KCode: KBD_F18; ),
		( KCodeName: 'F19';	KCode: KBD_F19; ),
		( KCodeName: 'F20';	KCode: KBD_F20; ),
		( KCodeName: 'LWin';	KCode: KBD_LWin; ),
		( KCodeName: 'RWin';	KCode: KBD_RWin; ),
		( KCodeName: 'Apps';	KCode: KBD_Apps; ),
		( KCodeName: 'Home';	KCode: KBD_Home; ),
		( KCodeName: 'Up';	KCode: KBD_Up; ),
		( KCodeName: 'PgUp';	KCode: KBD_PgUp; ),
		( KCodeName: 'Left';	KCode: KBD_Left; ),
		( KCodeName: 'Middle';	KCode: KBD_KP5; ),
		( KCodeName: 'Right';	KCode: KBD_Right; ),
		( KCodeName: 'End';	KCode: KBD_End; ),
		( KCodeName: 'Down';	KCode: KBD_Down; ),
		( KCodeName: 'PgDn';	KCode: KBD_PgDn; ),
		( KCodeName: 'Insert';	KCode: KBD_Insert; ),
		( KCodeName: 'Delete';	KCode: KBD_Delete; ),
		( KCodeName: 'Backspace';	KCode: KBD_BS; ),
		( KCodeName: 'Tab';		KCode: KBD_TAB; ),
		( KCodeName: 'Return';		KCode: KBD_RET; ),
		( KCodeName: 'ESC';		KCode: KBD_ESC; ),
		( KCodeName: 'Space';	KCode: ' '; ),
		( KCodeName: 'Ctrl_a';	KCode: KBD_CTRL_A; ),
		( KCodeName: 'Ctrl_b';	KCode: KBD_CTRL_B; ),
		( KCodeName: 'Ctrl_c';	KCode: KBD_CTRL_C; ),
		( KCodeName: 'Ctrl_d';	KCode: KBD_CTRL_D; ),
		( KCodeName: 'Ctrl_e';	KCode: KBD_CTRL_E; ),
		( KCodeName: 'Ctrl_f';	KCode: KBD_CTRL_F; ),
		( KCodeName: 'Ctrl_g';	KCode: KBD_CTRL_G; ),
		( KCodeName: 'Ctrl_h';	KCode: KBD_CTRL_H; ),
		( KCodeName: 'Ctrl_i';	KCode: KBD_CTRL_I; ),
		( KCodeName: 'Ctrl_j';	KCode: KBD_CTRL_J; ),
		( KCodeName: 'Ctrl_k';	KCode: KBD_CTRL_K; ),
		( KCodeName: 'Ctrl_l';	KCode: KBD_CTRL_L; ),
		( KCodeName: 'Ctrl_m';	KCode: KBD_CTRL_M; ),
		( KCodeName: 'Ctrl_n';	KCode: KBD_CTRL_N; ),
		( KCodeName: 'Ctrl_o';	KCode: KBD_CTRL_O; ),
		( KCodeName: 'Ctrl_p';	KCode: KBD_CTRL_P; ),
		( KCodeName: 'Ctrl_q';	KCode: KBD_CTRL_Q; ),
		( KCodeName: 'Ctrl_r';	KCode: KBD_CTRL_R; ),
		( KCodeName: 'Ctrl_s';	KCode: KBD_CTRL_S; ),
		( KCodeName: 'Ctrl_t';	KCode: KBD_CTRL_T; ),
		( KCodeName: 'Ctrl_u';	KCode: KBD_CTRL_U; ),
		( KCodeName: 'Ctrl_v';	KCode: KBD_CTRL_V; ),
		( KCodeName: 'Ctrl_w';	KCode: KBD_CTRL_W; ),
		( KCodeName: 'Ctrl_x';	KCode: KBD_CTRL_X; ),
		( KCodeName: 'Ctrl_y';	KCode: KBD_CTRL_Y; ),
		( KCodeName: 'Ctrl_z';	KCode: KBD_CTRL_Z; ),
		( KCodeName: 'none';	KCode: KBD_NONE; ),
		( KCodeName: 'error';	KCode: KBD_ERROR; ),
		( KCodeName: '';	KCode: KBD_ERROR; )
	);

	SDLColorTable_Num = 37;
	SDLColorTable: Array [1..SDLColorTable_Num] of T_SDLColorTable = (
{$IFDEF ASCII}
	(	Name:'StdBlack';		DataPtr: @SDLStdBlack;		),
	(	Name:'StdWhite';		DataPtr: @SDLStdWhite;		),
	(	Name:'MenuItem';		DataPtr: @SDLMenuItem;		),
	(	Name:'MenuSelect';		DataPtr: @SDLMenuSelect;	),
	(	Name:'PlayerBlue';		DataPtr: @SDLPlayerBlue;	),
	(	Name:'EnemyRed';		DataPtr: @SDLEnemyRed;		),
	(	Name:'InfoGreen';		DataPtr: @SDLInfoGreen;		),
	(	Name:'InfoHiLight';		DataPtr: @SDLInfoHiLight;	),
	(	Name:'MelodyYellow';		DataPtr: @SDLMelodyYellow;	),
{$ELSE ASCII}
	(	Name:'StdBlack';		DataPtr: @StdBlack;		),
	(	Name:'StdWhite';		DataPtr: @StdWhite;		),
	(	Name:'MenuItem';		DataPtr: @MenuItem;		),
	(	Name:'MenuSelect';		DataPtr: @MenuSelect;		),
	(	Name:'PlayerBlue';		DataPtr: @PlayerBlue;		),
	(	Name:'EnemyRed';		DataPtr: @EnemyRed;		),
	(	Name:'InfoGreen';		DataPtr: @InfoGreen;		),
	(	Name:'InfoHiLight';		DataPtr: @InfoHiLight;		),
	(	Name:'MelodyYellow';		DataPtr: @MelodyYellow;		),
{$ENDIF ASCII}
	(	Name:'Avocado';			DataPtr: @SDLAvocado;		),
	(	Name:'Bacardi';			DataPtr: @SDLBacardi;		),
	(	Name:'Jade';			DataPtr: @SDLJade;		),
	(	Name:'BrightJade';		DataPtr: @SDLBrightJade;	),
	(	Name:'ClearColor';		DataPtr: @SDLClearColor;	),
	(	Name:'BackgroundColor';		DataPtr: @SDLBackgroundColor;	),
	(	Name:'InfoBoxColor';		DataPtr: @SDLInfoBoxColor;	),
	(	Name:'TerrainGreen';		DataPtr: @SDLTerrainGreen;	),
	(	Name:'AllyPurple';		DataPtr: @SDLAllyPurple;	),
	(	Name:'NeutralGrey';		DataPtr: @SDLNeutralGrey;	),
	(	Name:'DarkGrey';		DataPtr: @SDLDarkGrey;		),
	(	Name:'TextboxGrey';		DataPtr: @SDLTextboxGrey;	),
	(	Name:'NeutralBrown';		DataPtr: @SDLNeutralBrown;	),
	(	Name:'BorderBlue';		DataPtr: @SDLBorderBlue;	),
	(	Name:'Cyan';			DataPtr: @SDLCyan;		),
	(	Name:'BorderColor';		DataPtr: @SDLBorderColor;	),
	(	Name:'TransparentColor';	DataPtr: @SDLTransparentColor;	),
	(	Name:'StatusPerfect';		DataPtr: @SDLStatusPerfect;	),
	(	Name:'StatusOK';		DataPtr: @SDLStatusOK;		),
	(	Name:'StatusFair';		DataPtr: @SDLStatusFair;	),
	(	Name:'StatusBad';		DataPtr: @SDLStatusBad;		),
	(	Name:'StatusCritical';		DataPtr: @SDLStatusCritical;	),
	(	Name:'StatusKO';		DataPtr: @SDLStatusKO;		),
	(	Name:'WallBrown';		DataPtr: @SDLWallBrown;		),
	(	Name:'DoorBlue';		DataPtr: @SDLDoorBlue;		),
	(	Name:'WallGray';		DataPtr: @SDLWallGray;		),
	(	Name:'SmokeGray';		DataPtr: @SDLSmokeGray;		),
	(	Name:'ToxicGreen';		DataPtr: @SDLToxicGreen;	)
	);

var
	UTF8_Help_Keymap_Name: SAttArrayPtr;
	UTF8_Help_Keymap_Desc: SAttArrayPtr;
	Use_KeyMapAlias: Boolean = true;

Function UTF8_Help_Keymap_Name_String( const MsgLabel: String ): String;
begin
	UTF8_Help_Keymap_Name_String := SAttArrayValue( UTF8_Help_Keymap_Name, MsgLabel );
end;

Function UTF8_Help_Keymap_Desc_String( const MsgLabel: String ): String;
begin
	UTF8_Help_Keymap_Desc_String := SAttArrayValue( UTF8_Help_Keymap_Desc, MsgLabel );
end;

Function KeyMapEncode( const header: String; const src: Char ): String;
const
	AllowableCharacters = '!"#$%&()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~';
var
	c: Char;
	i: Integer;
begin
	c := KBD_ERROR;
	if (KBD_NONE < src) and (src < KBD_UNICODE_FLAG) then begin
		c := src;
	end;
	if (0 < Pos(c, AllowableCharacters)) then begin
		KeyMapEncode := c;
	end else begin
		KeyMapEncode := '#' + BStr( Ord(src) );
		i := 1;
		while ( 0 < Length(KCodeName[i].KCodeName) ) do begin
			if ( KCodeName[i].KCode = src ) then begin
				KeyMapEncode := header + KCodeName[i].KCodeName;
				break;
			end;
			Inc( i );
		end;
	end;
end;

Procedure LoadConfig;
	{ Open the configuration file and set the variables }
	{ as needed. }
	Function KeyMapDecode( const src: String ): Char;
	var
		i: Integer;
		s: String;
		ret: Boolean;
	begin
		KeyMapDecode := KBD_ERROR;
		if (Length(src) < 1) then begin
			ErrorMessage_fork('ERROR: KeyName not found.');
		end else if (1 = Length(src)) then begin
			KeyMapDecode := src[1];
		end else if ('#' = src[1]) and (2 <= Length(src)) then begin
			ret := False;
			s := Copy(src,2,Length(src)-1);
			i := 1;
			while ( 0 < Length(KCodeName[i].KCodeName) ) do begin
				if ( UpCase(KCodeName[i].KCodeName) = UpCase(s) ) then begin
					KeyMapDecode := KCodeName[i].KCode;
					ret := True;
				end;
				Inc( i );
			end;
			if not ret then begin
				ErrorMessage_fork('ERROR: Unknown KeyName : ' + src);
			end;
		end else begin
			ErrorMessage_fork('ERROR: Unknown KeyName : ' + src);
		end;
	end;
var
	F: Text;
	S,CMD,C: String;
	T: Integer;
	Done: Boolean;
	KCode_from_tmp: Char;
	KCode_to_tmp: Char;
{$IFDEF Windows}
	WinDir: String;
{$ENDIF Windows}
	ColorNum: Integer;
	KCodeAlias_ptr: Integer;
begin
	KCodeAlias_ptr := 1;
{$IFDEF Windows}
	WinDir := '';
	if '' = WinDir then begin
		WinDir := GetEnvironmentVariable('SystemRoot');
	end;
	if '' = WinDir then begin
		WinDir := GetEnvironmentVariable('windir');
	end;
	if '' <> WinDir then begin
		FontSearchDir[4] := WinDir + DirectorySeparator + 'Fonts';
	end;
{$ENDIF Windows}

	{See whether or not there's a configuration file.}
	S := FSearch(Config_File,'.');
	if S <> '' then begin
		{ If we've found a configuration file, }
		{ open it up and start reading. }
		Assign(F,S);
		Reset(F);
		KCodeAlias[KCodeAlias_ptr].KCode_from := KBD_ERROR;

		while not Eof(F) do begin
			ReadLn(F,S);
			cmd := ExtractWord(S);
			if (cmd <> '') then begin
				Done := False;

				{Check to see if CMD is one of the standard keys.}
				cmd := UpCase(cmd);

				for t := 1 to KeyMapAliasMax do begin
					if (UpCase(KeyMapAlias[t].CmdName) = cmd) then begin
						Use_KeyMapAlias := false;
						break;
					end;
				end;
				for t := 1 to KeyMapAliasMax do begin
					if (UpCase(KeyMapAlias[t].CmdAlias) = cmd) then begin
						Done := true;
						Use_KeyMapAlias := true;
						cmd := UpCase(KeyMapAlias[t].CmdName);
						break;
					end;
				end;

				for t := 1 to NumMappedKeys do begin
					if UpCase(KeyMap[t].CmdName) = cmd then begin
						Done := true;
						C := ExtractWord(S);
						KCode_from_tmp := KeyMapDecode(C);
						if (KBD_ERROR <> KCode_from_tmp) then begin
							KeyMap[t].KCode := KCode_from_tmp;
						end;
					end;
				end;
				if ( 'KCODEALIAS' = cmd ) and ( KCodeAlias_ptr < KCodeAliasMax) then begin
					Done := true;
					C := ExtractWord(S);
					KCode_from_tmp := KeyMapDecode(C);
					if (KBD_ERROR <> KCode_from_tmp) then begin
						C := ExtractWord(S);
						KCode_to_tmp := KeyMapDecode(C);
						if (KBD_ERROR <> KCode_to_tmp) then begin
							KCodeAlias[KCodeAlias_ptr].KCode_from := KCode_from_tmp;
							KCodeAlias[KCodeAlias_ptr].KCode_to := KCode_to_tmp;
							Inc( KCodeAlias_ptr );
							KCodeAlias[KCodeAlias_ptr].KCode_from := KBD_ERROR;
						end;
					end;
				end;

				{ Check to see if CMD is the animation speed throttle. }
				if cmd = 'ANIMSPEED' then begin
					T := ExtractValue( S );
					if T < 0 then T := 0;
					FrameDelay := T;
				end else if cmd = 'MECHACONTROL' then begin
					C := UpCase( ExtractWord( S ) );
					case C[1] of
						'M': ControlMethod := MenuBasedInput;
						'R': ControlMethod := RLBasedInput;
					end;
				end else if cmd = 'CHARACONTROL' then begin
					C := UpCase( ExtractWord( S ) );
					case C[1] of
						'M': CharacterMethod := MenuBasedInput;
						'R': CharacterMethod := RLBasedInput;
					end;
				end else if cmd = 'WORLDCONTROL' then begin
					C := UpCase( ExtractWord( S ) );
					case C[1] of
						'M': WorldMapMethod := MenuBasedInput;
						'R': WorldMapMethod := RLBasedInput;
					end;

				end else if cmd = 'MISSILEBV' then begin
					C := UpCase( ExtractWord( S ) );
					for t := 1 to 4 do begin
						if UpCase(BVTypeName[t]) = C then begin
							DefMissileBV := T;
						end;
					end;

				end else if cmd = 'BALLISTICBV' then begin
					C := UpCase( ExtractWord( S ) );
					for t := 1 to 4 do begin
						if UpCase(BVTypeName[t]) = C then begin
							DefBallisticBV := T;
						end;
					end;

				end else if cmd = 'BEAMGUNBV' then begin
					C := UpCase( ExtractWord( S ) );
					for t := 1 to 4 do begin
						if UpCase(BVTypeName[t]) = C then begin
							DefBeamGunBV := T;
						end;
					end;
				end else if cmd = 'DIRECTSKILLOK' then begin
					Direct_Skill_Learning := True;

				end else if cmd = 'NOAUTOSAVE' then begin
					DoAutoSave := False;

				end else if cmd = 'ALWAYSSAVECHARACTER' then begin
					ALWAYS_SAVE_CHARACTER := True;
				end else if cmd = 'NOCOMBATTAUNTS' then begin
					No_Combat_Taunts := True;

				end else if cmd = 'LOADPLOTSATSTART' then begin
					Load_Plots_At_Start := True;

				end else if cmd = 'MINIMAPON' then begin
					Display_Mini_Map := True;
				end else if cmd = 'MINIMAP_WITH_ALLGEARS' then begin
					Display_Mini_Map_with_All_Gears := True;

				end else if cmd = 'SCREENHEIGHT' then begin
					T := ExtractValue( S );
					if T > 255 then T := 255
					else if T < 24 then T := 24;
					ScreenRows := T;

				end else if cmd = 'SCREENWIDTH' then begin
					T := ExtractValue( S );
					if T > 255 then T := 255
					else if T < 80 then T := 80;
					ScreenColumns := T;

				end else if cmd = 'SDL_SCREENPOSX' then begin
					T := ExtractValue( S );
					SDL_ScreenPosX := T;
				end else if cmd = 'SDL_SCREENPOSY' then begin
					T := ExtractValue( S );
					SDL_ScreenPosY := T;

				end else if cmd = 'SDL_SCREENWIDTH' then begin
					T := ExtractValue( S );
					SDL_ScreenWidth := T;

				end else if cmd = 'SDL_SCREENHEIGHT' then begin
					T := ExtractValue( S );
					SDL_ScreenHeight := T;

				end else if cmd = 'SDL_FONTFILEBIG' then begin
					FontSearchName_Big[1].FontFile   := ExtractWord( S );
					FontSearchName_Big[1].FontFace   := ExtractValue( S );
					if FontSearchName_Big[1].FontFace < 0 then begin FontSearchName_Big[1].FontFace := 0; end;

				end else if cmd = 'SDL_FONTFILESMALL' then begin
					FontSearchName_Small[1].FontFile := ExtractWord( S );
					FontSearchName_Small[1].FontFace := ExtractValue( S );
					if FontSearchName_Small[1].FontFace < 0 then begin FontSearchName_Small[1].FontFace := 0; end;

				end else if cmd = 'SDL_FONTFILEINFO' then begin
					FontSearchName_Info[1].FontFile := ExtractWord( S );
					FontSearchName_Info[1].FontFace := ExtractValue( S );
					if FontSearchName_Info[1].FontFace < 0 then begin FontSearchName_Info[1].FontFace := 0; end;

				end else if cmd = 'SDL_AAFONT' then begin
					SDL_AAFont := True;

				end else if cmd = 'SDL_AAFONT_SHADED' then begin
					SDL_AAFont_Shaded := True;

				end else if cmd = 'SDL_FONTSIZEBIG' then begin
					T := ExtractValue( S );
					FontSize_Big := T;

				end else if cmd = 'SDL_FONTSIZESMALL' then begin
					T := ExtractValue( S );
					FontSize_Small := T;

				end else if cmd = 'SDL_FONTSIZEINFO' then begin
					T := ExtractValue( S );
					FontSize_Info := T;

				end else if cmd = 'SDL_SHOW_MENUSCROLLBAR' then begin
					SDL_Show_MenuScrollbar := True;

				end else if cmd = 'SDLCOLOR' then begin
					C := ExtractWord( S );
					for ColorNum := 1 to SDLColorTable_Num do begin
						if ( UpCase(SDLColorTable[ColorNum].Name) = UpCase(C) ) then begin
							SDLColorTable[ColorNum].DataPtr^.r := ExtractValue( S );
							SDLColorTable[ColorNum].DataPtr^.g := ExtractValue( S );
							SDLColorTable[ColorNum].DataPtr^.b := ExtractValue( S );
							if ( SDLColorTable[ColorNum].DataPtr^.r < 0 ) then begin SDLColorTable[ColorNum].DataPtr^.r := 0; end;
							if ( SDLColorTable[ColorNum].DataPtr^.g < 0 ) then begin SDLColorTable[ColorNum].DataPtr^.g := 0; end;
							if ( SDLColorTable[ColorNum].DataPtr^.b < 0 ) then begin SDLColorTable[ColorNum].DataPtr^.b := 0; end;
							if ( 255 < SDLColorTable[ColorNum].DataPtr^.r ) then begin SDLColorTable[ColorNum].DataPtr^.r := 255; end;
							if ( 255 < SDLColorTable[ColorNum].DataPtr^.g ) then begin SDLColorTable[ColorNum].DataPtr^.g := 255; end;
							if ( 255 < SDLColorTable[ColorNum].DataPtr^.b ) then begin SDLColorTable[ColorNum].DataPtr^.b := 255; end;
						end;
					end;

				end else if cmd = 'ASCII_SHOW_MENUSCROLLBAR' then begin
					ASCII_Show_MenuScrollbar := True;

				end else if cmd = 'DEBUG_PRINT_TIMESTRING' then begin
					DEBUG_Print_TimeString := True;
				end else if cmd = 'DEBUG_AUTOSAVE_TRACE' then begin
					DEBUG_Autosave_Trace := True;
				end else if cmd = 'DEBUG_DISABLE_PROTECTEDMODE_AT_PLOTDEADEND' then begin
					DEBUG_Disable_ProtectedMode_at_PlotDeadend := True;

				end else if cmd = 'EXTEND_CALLSHOT' then begin
					EXTEND_CallShot := True;
				end else if cmd = 'EXTEND_LOOKINFO' then begin
					EXTEND_LookInfo := True;

				end else if cmd = 'SHOW_EQPMENU_SUBITEM' then begin
					SHOW_EqpMenu_SubItem := True;
				end else if cmd = 'SHOW_EQPMENU_SUBITEM_FULLGEARNAME' then begin
					SHOW_EqpMenu_SubItem_FullGearName := True;
				end else if cmd = 'SHOW_EQUIPITEM_PARENTITEM' then begin
					SHOW_EquipItem_ParentItem := True;
				end else if cmd = 'SHOW_EQUIPITEM_INVSTR' then begin
					SHOW_EquipItem_InvStr := True;
				end else if cmd = 'SHOW_EQUIPITEM_SUBITEM' then begin
					SHOW_EquipItem_SubItem := True;
				end else if cmd = 'SHOW_INVMENU_SUBITEM' then begin
					SHOW_InvMenu_SubItem := True;
				end else if cmd = 'SHOW_INSTALLMISC_PARENTITEM' then begin
					SHOW_InstallMisc_ParentItem := True;
				end else if cmd = 'SHOW_INSTALLMISC_INVSTR' then begin
					SHOW_InstallMisc_InvStr := True;
				end else if cmd = 'SHOW_INSTALLMISC_HIT' then begin
					SHOW_InstallMisc_Hit := True;
				end else if cmd = 'SHOW_INSTALL_SUBITEM' then begin
					SHOW_Install_SubItem := True;
				end else if cmd = 'SHOW_INSTALLAMMO_SUBITEM' then begin
					SHOW_InstallAmmo_SubItem := True;
				end else if cmd = 'SHOW_INSTALLCYBERWARE_SUBITEM' then begin
					SHOW_InstallCyberware_SubItem := True;
				end else if cmd = 'SHOW_SELLSTUFF_SUBITEM' then begin
					SHOW_SellStuff_SubItem := True;
				end else if cmd = 'SHOW_BUYSTUFF_SUBITEM' then begin
					SHOW_BuyStuff_SubItem := True;
				end else if cmd = 'SHOW_PHONE_ADDRESSLIST' then begin
					SHOW_Phone_AddressList := True;
				end else if cmd = 'SHOW_EQPMENU_MASSMETER' then begin
					SHOW_EqpMenu_MassMeter := True;
				end else if cmd = 'SHOW_AMMOEXPLOSION' then begin
					SHOW_AmmoExplosion := True;
				end else if cmd = 'SHOW_CRITICALENGINEFAILURE' then begin
					SHOW_CriticalEngineFailure := True;
				end else if cmd = 'SHOW_ATTEMPTDEFENSES' then begin
					SHOW_AttemptDefenses := True;
				end else if cmd = 'SHOW_NPCSTATUS_FIELDHQ' then begin
					SHOW_NPCStatus_FieldHQ := True;
				end else if cmd = 'SHOW_PILLAGE' then begin
					SHOW_Pillage := True;
				end else if cmd = 'SHOW_ENVIRONMENTIDENTS' then begin
					SHOW_EnvironmentIdents := True;
				end else if cmd = 'SHOW_COMPONENTMASS' then begin
					SHOW_ComponentMass := True;

				end else if cmd = 'ENABLE_NUMKEYMENU' then begin
					ENABLE_NumKeyMenu := True;

				end else if cmd = 'DISABLE_SINFO_CHARADEX' then begin
					DISABLE_SInfo_CharaDex := True;

				end else if cmd = 'ENABLE_MOUSECLICK_OUTSIDETHEMENUAREA' then begin
					ENABLE_MouseClick_OutsideTheMenuArea := True;

				end else if cmd = 'CHEAT_LOAD_CHA' then begin
					CHEAT_Load_CHA := True;
				end else if cmd = 'CHEAT_DISPLAY_CLASS' then begin
					CHEAT_Display_Class := True;
				end else if cmd = 'CHEAT_DISPLAY_PV' then begin
					CHEAT_Display_PV := True;
				end else if cmd = 'CHEAT_NO_COCKPITBARRIER' then begin
					CHEAT_No_CockpitBarrier := True;
				end else if cmd = 'CHEAT_NO_COCKPITBARRIER_HAND' then begin
					CHEAT_No_CockpitBarrier_Hand := True;
				end else if cmd = 'CHEAT_NO_NEEDSTAMINA_MEKFULLSPEED' then begin
					CHEAT_No_NeedStamina_MekFullSpeed := True;
				end else if cmd = 'CHEAT_DONOTRUNWHENMOUSECLICKED' then begin
					CHEAT_DoNotRunWhenMouseClicked := True;
				end else if cmd = 'CHEAT_AMMODISCOUNT' then begin
					CHEAT_AmmoDiscount := True;
				end else if cmd = 'CHEAT_MULTIPLEX_SELECTEQUIPMENTFORNPC' then begin
					CHEAT_Multiplex_SelectEquipmentForNPC := True;
				end else if cmd = 'CHEAT_FORCIBLY_PILLAGE' then begin
					CHEAT_Forcibly_Pillage := True;
				end else if cmd = 'CHEAT_NPC_EDIT' then begin
					CHEAT_NPC_Edit := True;
				end else if cmd = 'CHEAT_UNLIMITED_SPRITE' then begin
					CHEAT_Unlimited_Sprite := True;
				end else if cmd = 'CHEAT_UNLIMITED_PORTRAIT' then begin
					CHEAT_Unlimited_Portrait := True;
				end else if cmd = 'CHEAT_ALLOW_NAMESON_WHEN_UNKNOWN' then begin
					CHEAT_Allow_Nameson_When_Unknown := True;
				end else if cmd = 'CHEAT_NO_CHECKPHONELIST_MEMO' then begin
					CHEAT_No_CheckPhonelist_Memo := True;
				end else if cmd = 'CHEAT_NO_CHECKPHONELIST_TELEPHONE_GAMEBOARD' then begin
					CHEAT_No_CheckPhonelist_Telephone_Gameboard := True;
				end else if cmd = 'CHEAT_NO_CHECKPHONELIST_TELEPHONE_ROOTSCENE' then begin
					CHEAT_No_CheckPhonelist_Telephone_RootScene := True;
				end else if cmd = 'CHEAT_NO_CHECKPHONELIST_TELEPHONE_KEYWORD' then begin
					CHEAT_No_CheckPhonelist_Telephone_Keyword := True;
				end else if cmd = 'CHEAT_SHOW_ROLLHISTORY' then begin
					CHEAT_Show_RollHistory := True;
				end else if cmd = 'CHEAT_SHOWREP' then begin
					CHEAT_ShowRep := True;
				end else if cmd = 'CHEAT_SHOWSF' then begin
					CHEAT_ShowSF := True;
				end else if cmd = 'CHEAT_APPEARTOTHESPACE' then begin
					CHEAT_AppearToTheSpace := True;
				end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREESUPPORT' then begin
					CHEAT_MechaCustomize_FreeSupport := True;
				end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREECOCKPIT' then begin
					CHEAT_MechaCustomize_FreeCockpit := True;
				end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREESCALE' then begin
					CHEAT_MechaCustomize_FreeScale := True;
				end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREEMODIFIER' then begin
					CHEAT_MechaCustomize_FreeModifier := True;
				end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREEBODYMODULE' then begin
					CHEAT_MechaCustomize_FreeBodyModule := True;
				end else if cmd = 'CHEAT_NPC_AVOIDATTACKTONEUTRALITY' then begin
					CHEAT_NPC_AvoidAttackToNeutrality := True;
				end else if cmd = 'CHEAT_NPC_USEGRENADE' then begin
					CHEAT_NPC_UseGrenade := True;
				end else if cmd = 'CHEAT_DONOTROUNDUP_ARP' then begin
					CHEAT_DoNotRoundUp_ARP := True;
				end else if cmd = 'CHEAT_RELOADALLMECHA' then begin
					CHEAT_ReloadAllMecha := True;
				end else if cmd = 'CHEAT_DONOTCONSIDER_LANCEMATETACTICSPERSONA_IN_SAYANYTHING' then begin
					CHEAT_DoNotConsider_LancemateTacticsPersona_in_SayAnything := True;
				end else if cmd = 'CHEAT_SHOPS_CUSTOMIZE_MECHA' then begin
					CHEAT_Shops_Customize_Mecha := True;
				end else if cmd = 'CHEAT_QUICKFIRE_ATTACKS_INDISCRIMINATELY' then begin
					CHEAT_QuickFire_Attacks_Indiscriminately := True;
				end else if cmd = 'CHEAT_DOTRAINING_REGARDLESSOFPET' then begin
					CHEAT_DoTraining_RegardlessOfPet := True;
				end else if cmd = 'CHEAT_CAN_DISASSEMBLE_HOMEMADEROBOT' then begin
					CHEAT_Can_Disassemble_HomeMadeRobot := True;
				end else if cmd = 'CHEAT_SHOW_WEAPONRECHARGE' then begin
					CHEAT_Show_WeaponRecharge := True;
				end else if cmd = 'CHEAT_RANGE_COLORED' then begin
					CHEAT_Range_Colored := True;
				end else if cmd = 'CHEAT_RANGE_WITH_ALTITUDE' then begin
					CHEAT_Range_with_Altitude := True;
				end else if cmd = 'CHEAT_FIX_SOLVELINE' then begin
					CHEAT_Fix_SolveLine := True;
				end else if cmd = 'CHEAT_SHOW_RANGECOVER' then begin
					CHEAT_Show_RangeCover := True;
				end else if cmd = 'CHEAT_SELECTSPRITE' then begin
					CHEAT_SelectSprite := True;

				end else if cmd = 'ADJUST_COMPONENTCOMPLEXITY_WITH_SCALE' then begin
					ADJUST_ComponentComplexity_with_Scale := True;

				end else if cmd = 'EDIT_MENUORDER' then begin
					EDIT_MenuOrder := True;
				end else if cmd = 'BROWSEMEMO_NORETURN_AFTER_PHONECALL' then begin
					BrowseMemo_NoReturn_after_PhoneCall := True;

				end else if cmd = 'PROHIBITATIONTRAIL' then begin
					ProhibitationTrail := S;
				end else if cmd = 'PROHIBITATIONHEAD' then begin
					ProhibitationHead := S;

				end else if cmd = 'RPGMODE' then begin
					C := UpCase( ExtractWord( S ) );
					RPG_Use_Tactics := C = 'TACTICS';
				end else if cmd = 'ARENAMODE' then begin
					C := UpCase( ExtractWord( S ) );
					Arena_Use_Tactics := C = 'TACTICS';

				end else if cmd = 'WINDOW' then begin
					DoFullScreen := False;
				end else if cmd = 'FULLSCREEN' then begin
					DoFullScreen := True;

				end else if cmd = 'NOMOUSE' then begin
					Mouse_Active := False;


				end else if cmd = 'NOPILLAGE' then begin
					Pillage_On := False;

				end else if cmd = 'THOROUGHREDRAW' then begin
					Thorough_Redraw := True;

				end else if cmd = 'SHORTWALLS' then begin
					Use_Tall_Walls := False;

				end else if cmd = 'RELOAD_UNEQUIPPED_WEAPONS_AT_SHOP' then begin
					Reload_All_Weapons := True;

				end else if cmd = 'LAPTOP_ISO_KEYS' then begin
					 Iso_Dir_Offset := 1;

				end else if cmd = 'CYCLE_ALL_WEAPONS' then begin
					Cycle_All_Weapons := True;

				end else if cmd = 'SKIPANIM' then begin
					SkipAnim := True;
				end else if cmd = 'MINIMAL_SCREEN_REFRESH' then begin
					Minimal_Screen_Refresh := True;
				end else if cmd = 'USE_SOFTWARE_SURFACE' then begin
					Use_Software_Surface := True;
				end else if cmd = 'NO_SPLASH_SCREEN_AT_START' then begin
					Splash_Screen_At_Start := False;

				end else if cmd = 'REVERT_SLOWER_SAFER' then begin
					Revert_Slower_Safer := True;

				end else if cmd = 'NAMESON' then begin
					Names_Above_Heads := True;

				end else if cmd = 'PAPERDOLLS' then begin
					Use_Paper_Dolls := True;
				end else if cmd = 'USEMESH' then begin
					Mesh_On := True;
				end else if cmd = 'ERSATZ_MOUSE' then begin
					Ersatz_Mouse := True;

				end else if cmd = 'NO_TRANSPARENT_INTERFACE' then begin
					Transparent_Interface := False;


				end else if cmd = 'GIMMEGIMMECHOICE' then begin
					XXRan_Wizard := True;
				end else if cmd = 'XXRANDEBUG' then begin
					XXRan_Debug := True;
				end else if cmd = 'YOUARE#6' then begin
					StdPlot_Debug := True;
				end else if cmd = 'DEBUG_ON_ARENAPLAY' then begin
					DEBUG_ON_arenaplay := True;
				end else if cmd = 'DEBUG_ON_ARENASCRIPT' then begin
					DEBUG_ON_arenascript := True;
				end else if cmd = 'GARYGYGAX' then begin
					ArenaMode_Wizard := True;
				end else if cmd = 'DEMIURGE' then begin
					Full_RPGWorld_Info := True;

				end else if cmd[1] = '#' then begin
					S := '';

				end else if (False = Done) then begin
					ErrorMessage_fork('ERROR: Unknown option : ' + cmd);
				end;
			end;
		end;

		{ Once the EOF has been reached, close the file. }
		Close(F);
	end;

end;

Procedure SaveConfig;
	{ Open the configuration file and record the variables }
	{ as needed. }
var
	F: Text;
	Procedure AddBoolean( const OpTag: String; IsOn: Boolean );
		{ Add one of the boolean options to the file. }
	begin
		if IsOn then begin
			writeln( F , OpTag );
		end else begin
			writeln( F , '#' + OpTag );
		end;
	end;
var
	t: Integer;
	i: Integer;
	KCmdName_tmp: String;
	KCode_tmp: String;
	ColorNum: Integer;
begin
	{ If we've found a configuration file, }
	{ open it up and start reading. }
	Assign( F , Config_File );
	SetTextLineEnding( F , #13#10 );
	Rewrite( F );

	writeln( F , '#' );
	writeln( F , '# ATTENTION:' );
	writeln( F , '#   Only edit the config file if GearHead is not running.' );
	writeln( F , '#   Configuration overwritten at game exit.' );
	writeln( F , '#' );

	for t := 1 to NumMappedKeys do begin
		KCmdName_tmp := KeyMap[t].CmdName;
		if Use_KeyMapAlias then begin
			for i := 1 to KeyMapAliasMax do begin
				if (UpCase(KeyMapAlias[i].CmdName) = UpCase(KCmdName_tmp)) then begin
					KCmdName_tmp := KeyMapAlias[i].CmdAlias;
					break;
				end;
			end;
		end;
		KCode_tmp := KeyMapEncode( '#' , KeyMap[t].KCode );
		WriteLn( F, KCmdName_tmp + ' ' + KCode_tmp );
	end;

	i := 1;
	while ( KBD_ERROR <> KCodeAlias[i].KCode_from ) do begin
		WriteLn( F, 'KCodeAlias ' + KeyMapEncode( '#' , KCodeAlias[i].KCode_from ) + ' ' + KeyMapEncode( '#' , KCodeAlias[i].KCode_to ) );
		Inc( i );
	end;

	writeln( F, 'ANIMSPEED ' + BStr( FrameDelay ) );

	writeln( F, 'MECHACONTROL ' + ControlTypeName[ ControlMethod ] );
	writeln( F, 'CHARACONTROL ' + ControlTypeName[ CharacterMethod ] );
	writeln( F, 'WORLDCONTROL ' + ControlTypeName[ WorldMapMethod ] );

	writeln( F, 'MISSILEBV ' + BVTypeName[ DefMissileBV ] );
	writeln( F, 'BALLISTICBV ' + BVTypeName[ DefBallisticBV ] );
	writeln( F, 'BEAMGUNBV ' + BVTypeName[ DefBeamGunBV ] );

	if RPG_Use_Tactics then writeln( F , 'RPGMode Tactics' )
	else writeln( F , 'RPGMode Clock' );

	if Arena_Use_Tactics then writeln( F , 'ArenaMode Tactics' )
	else writeln( F , 'ArenaMode Clock' );

	AddBoolean( 'DIRECTSKILLOK' , Direct_Skill_Learning );
	AddBoolean( 'NOAUTOSAVE' , not DoAutoSave );
	AddBoolean( 'ALWAYSSAVECHARACTER' , Always_Save_Character );
	AddBoolean( 'NOCOMBATTAUNTS' , No_Combat_Taunts );

	AddBoolean( 'RELOAD_UNEQUIPPED_WEAPONS_AT_SHOP' , Reload_All_Weapons );

	AddBoolean( 'LOADPLOTSATSTART' , Load_Plots_At_Start );
	AddBoolean( 'MINIMAPON' , Display_Mini_Map );
	AddBoolean( 'MINIMAP_WITH_ALLGEARS' , Display_Mini_Map_with_All_Gears );

	writeln( F , 'SCREENHEIGHT ' + BStr( ScreenRows ) );
	writeln( F , 'SCREENWIDTH ' + BStr( ScreenColumns ) );

	writeln( F , 'SDL_SCREENPOSX ' + BStr( SDL_ScreenPosX ) );
	writeln( F , 'SDL_SCREENPOSY ' + BStr( SDL_ScreenPosY ) );
	writeln( F , 'SDL_SCREENWIDTH ' + BStr( SDL_ScreenWidth ) );
	writeln( F , 'SDL_SCREENHEIGHT ' + BStr( SDL_ScreenHeight ) );
	writeln( F , 'SDL_FONTFILEBIG ' + FontSearchName_Big[1].FontFile + ' ' + BStr( FontSearchName_Big[1].FontFace ) );
	writeln( F , 'SDL_FONTFILESMALL ' + FontSearchName_Small[1].FontFile + ' ' + BStr( FontSearchName_Small[1].FontFace ) );
	writeln( F , 'SDL_FONTFILEINFO ' + FontSearchName_Info[1].FontFile + ' ' + BStr( FontSearchName_Info[1].FontFace ) );
	AddBoolean( 'SDL_AAFONT' , SDL_AAFont );
	AddBoolean( 'SDL_AAFONT_SHADED' , SDL_AAFont_Shaded );
	writeln( F , 'SDL_FONTSIZEBIG ' + BStr( FontSize_Big ) );
	writeln( F , 'SDL_FONTSIZESMALL ' + BStr( FontSize_Small ) );
	writeln( F , 'SDL_FONTSIZEINFO ' + BStr( FontSize_Info ) );
	AddBoolean( 'SDL_SHOW_MENUSCROLLBAR' , SDL_Show_MenuScrollbar );
	for ColorNum := 1 to SDLColorTable_Num do begin
		writeln( F , 'SDLCOLOR ' + SDLColorTable[ColorNum].Name + ' ' + BStr( SDLColorTable[ColorNum].DataPtr^.r ) + ' ' + BStr( SDLColorTable[ColorNum].DataPtr^.g ) + ' ' + BStr( SDLColorTable[ColorNum].DataPtr^.b ) );
	end;

	AddBoolean( 'ASCII_SHOW_MENUSCROLLBAR' , ASCII_Show_MenuScrollbar );

	AddBoolean( 'DEBUG_PRINT_TIMESTRING' , DEBUG_Print_TimeString );
	AddBoolean( 'DEBUG_AUTOSAVE_TRACE' , DEBUG_Autosave_Trace );
	AddBoolean( 'DEBUG_DISABLE_PROTECTEDMODE_AT_PLOTDEADEND' , DEBUG_Disable_ProtectedMode_at_PlotDeadend );

	AddBoolean( 'EXTEND_CALLSHOT' , EXTEND_CallShot );
	AddBoolean( 'EXTEND_LOOKINFO' , EXTEND_LookInfo );

	AddBoolean( 'SHOW_EQPMENU_SUBITEM' , SHOW_EqpMenu_SubItem );
	AddBoolean( 'SHOW_EQPMENU_SUBITEM_FULLGEARNAME' , SHOW_EqpMenu_SubItem_FullGearName );
	AddBoolean( 'SHOW_EQUIPITEM_PARENTITEM' , SHOW_EquipItem_ParentItem );
	AddBoolean( 'SHOW_EQUIPITEM_INVSTR' , SHOW_EquipItem_InvStr );
	AddBoolean( 'SHOW_EQUIPITEM_SUBITEM' , SHOW_EquipItem_SubItem );
	AddBoolean( 'SHOW_INVMENU_SUBITEM' , SHOW_InvMenu_SubItem );
	AddBoolean( 'SHOW_INSTALLMISC_PARENTITEM' , SHOW_InstallMisc_ParentItem );
	AddBoolean( 'SHOW_INSTALLMISC_INVSTR' , SHOW_InstallMisc_InvStr );
	AddBoolean( 'SHOW_INSTALLMISC_HIT' , SHOW_InstallMisc_Hit );
	AddBoolean( 'SHOW_INSTALL_SUBITEM' , SHOW_Install_SubItem );
	AddBoolean( 'SHOW_INSTALLAMMO_SUBITEM' , SHOW_InstallAmmo_SubItem );
	AddBoolean( 'SHOW_INSTALLCYBERWARE_SUBITEM' , SHOW_InstallCyberware_SubItem );
	AddBoolean( 'SHOW_SELLSTUFF_SUBITEM' , SHOW_SellStuff_SubItem );
	AddBoolean( 'SHOW_BUYSTUFF_SUBITEM' , SHOW_BuyStuff_SubItem );
	AddBoolean( 'SHOW_PHONE_ADDRESSLIST' , SHOW_Phone_AddressList );
	AddBoolean( 'SHOW_EQPMENU_MASSMETER' , SHOW_EqpMenu_MassMeter );
	AddBoolean( 'SHOW_AMMOEXPLOSION' , SHOW_AmmoExplosion );
	AddBoolean( 'SHOW_CRITICALENGINEFAILURE' , SHOW_CriticalEngineFailure );
	AddBoolean( 'SHOW_ATTEMPTDEFENSES' , SHOW_AttemptDefenses );
	AddBoolean( 'SHOW_NPCSTATUS_FIELDHQ' , SHOW_NPCStatus_FieldHQ );
	AddBoolean( 'SHOW_PILLAGE' , SHOW_Pillage );
	AddBoolean( 'SHOW_ENVIRONMENTIDENTS' , SHOW_EnvironmentIdents );
	AddBoolean( 'SHOW_COMPONENTMASS' , SHOW_ComponentMass );

	if ENABLE_NumKeyMenu then writeln( F , 'ENABLE_NUMKEYMENU' );

	AddBoolean( 'DISABLE_SINFO_CHARADEX' , DISABLE_SInfo_CharaDex );

	AddBoolean( 'ENABLE_MOUSECLICK_OUTSIDETHEMENUAREA' , ENABLE_MouseClick_OutsideTheMenuArea );

	AddBoolean( 'CHEAT_LOAD_CHA' , CHEAT_Load_CHA );
	AddBoolean( 'CHEAT_DISPLAY_CLASS' , CHEAT_Display_Class );
	AddBoolean( 'CHEAT_DISPLAY_PV' , CHEAT_Display_PV );
	AddBoolean( 'CHEAT_NO_COCKPITBARRIER' , CHEAT_No_CockpitBarrier );
	AddBoolean( 'CHEAT_NO_COCKPITBARRIER_HAND' , CHEAT_No_CockpitBarrier_Hand );
	AddBoolean( 'CHEAT_NO_NEEDSTAMINA_MEKFULLSPEED' , CHEAT_No_NeedStamina_MekFullSpeed );
	AddBoolean( 'CHEAT_DONOTRUNWHENMOUSECLICKED' , CHEAT_DoNotRunWhenMouseClicked );
	AddBoolean( 'CHEAT_AMMODISCOUNT' , CHEAT_AmmoDiscount );
	AddBoolean( 'CHEAT_MULTIPLEX_SELECTEQUIPMENTFORNPC' , CHEAT_Multiplex_SelectEquipmentForNPC );
	AddBoolean( 'CHEAT_FORCIBLY_PILLAGE' , CHEAT_Forcibly_Pillage );
	AddBoolean( 'CHEAT_NPC_EDIT' , CHEAT_NPC_Edit );
	AddBoolean( 'CHEAT_UNLIMITED_SPRITE' , CHEAT_Unlimited_Sprite );
	AddBoolean( 'CHEAT_UNLIMITED_PORTRAIT' , CHEAT_Unlimited_Portrait );
	AddBoolean( 'CHEAT_ALLOW_NAMESON_WHEN_UNKNOWN' , CHEAT_Allow_Nameson_When_Unknown );
	AddBoolean( 'CHEAT_NO_CHECKPHONELIST_MEMO' , CHEAT_No_CheckPhonelist_Memo );
	AddBoolean( 'CHEAT_NO_CHECKPHONELIST_TELEPHONE_GAMEBOARD' , CHEAT_No_CheckPhonelist_Telephone_Gameboard );
	AddBoolean( 'CHEAT_NO_CHECKPHONELIST_TELEPHONE_ROOTSCENE' , CHEAT_No_CheckPhonelist_Telephone_RootScene );
	AddBoolean( 'CHEAT_NO_CHECKPHONELIST_TELEPHONE_KEYWORD' , CHEAT_No_CheckPhonelist_Telephone_Keyword );
	AddBoolean( 'CHEAT_SHOW_ROLLHISTORY' , CHEAT_Show_RollHistory );
	AddBoolean( 'CHEAT_SHOWREP' , CHEAT_ShowRep );
	AddBoolean( 'CHEAT_SHOWSF' , CHEAT_ShowSF );
	AddBoolean( 'CHEAT_APPEARTOTHESPACE' , CHEAT_AppearToTheSpace );
	AddBoolean( 'CHEAT_MECHACUSTOMIZE_FREESUPPORT' , CHEAT_MechaCustomize_FreeSupport );
	AddBoolean( 'CHEAT_MECHACUSTOMIZE_FREECOCKPIT' , CHEAT_MechaCustomize_FreeCockpit );
	AddBoolean( 'CHEAT_MECHACUSTOMIZE_FREESCALE' , CHEAT_MechaCustomize_FreeScale );
	AddBoolean( 'CHEAT_MECHACUSTOMIZE_FREEMODIFIER' , CHEAT_MechaCustomize_FreeModifier );
	AddBoolean( 'CHEAT_MECHACUSTOMIZE_FREEBODYMODULE' , CHEAT_MechaCustomize_FreeBodyModule );
	AddBoolean( 'CHEAT_NPC_AVOIDATTACKTONEUTRALITY' , CHEAT_NPC_AvoidAttackToNeutrality );
	AddBoolean( 'CHEAT_NPC_USEGRENADE' , CHEAT_NPC_UseGrenade );
	AddBoolean( 'CHEAT_DONOTROUNDUP_ARP' , CHEAT_DoNotRoundUp_ARP );
	AddBoolean( 'CHEAT_RELOADALLMECHA' , CHEAT_ReloadAllMecha );
	AddBoolean( 'CHEAT_DONOTCONSIDER_LANCEMATETACTICSPERSONA_IN_SAYANYTHING' , CHEAT_DoNotConsider_LancemateTacticsPersona_in_SayAnything );
	AddBoolean( 'CHEAT_SHOPS_CUSTOMIZE_MECHA' , CHEAT_Shops_Customize_Mecha );
	AddBoolean( 'CHEAT_QUICKFIRE_ATTACKS_INDISCRIMINATELY' , CHEAT_QuickFire_Attacks_Indiscriminately );
	AddBoolean( 'CHEAT_DOTRAINING_REGARDLESSOFPET' , CHEAT_DoTraining_RegardlessOfPet );
	AddBoolean( 'CHEAT_CAN_DISASSEMBLE_HOMEMADEROBOT' , CHEAT_Can_Disassemble_HomeMadeRobot );
	AddBoolean( 'CHEAT_SHOW_WEAPONRECHARGE' , CHEAT_Show_WeaponRecharge );
	AddBoolean( 'CHEAT_RANGE_COLORED' , CHEAT_Range_Colored );
	AddBoolean( 'CHEAT_RANGE_WITH_ALTITUDE' , CHEAT_Range_with_Altitude );
	AddBoolean( 'CHEAT_FIX_SOLVELINE' , CHEAT_Fix_SolveLine );
	AddBoolean( 'CHEAT_SHOW_RANGECOVER' , CHEAT_Show_RangeCover );
	AddBoolean( 'CHEAT_SELECTSPRITE' , CHEAT_SelectSprite );

	AddBoolean( 'ADJUST_COMPONENTCOMPLEXITY_WITH_SCALE' , ADJUST_ComponentComplexity_with_Scale );

	AddBoolean( 'EDIT_MENUORDER' , EDIT_MenuOrder );
	AddBoolean( 'BROWSEMEMO_NORETURN_AFTER_PHONECALL' , BrowseMemo_NoReturn_after_PhoneCall );

	AddBoolean( 'WINDOW' , not DoFullScreen );
	AddBoolean( 'FULLSCREEN' , DoFullScreen );
	AddBoolean( 'NOMOUSE' , not Mouse_Active );
	AddBoolean( 'NOPILLAGE' , not Pillage_On );
	AddBoolean( 'THOROUGHREDRAW' , Thorough_Redraw );
	AddBoolean( 'SHORTWALLS' , not Use_Tall_Walls );

	AddBoolean( 'LAPTOP_ISO_KEYS' ,  Iso_Dir_Offset <> 0 );
	AddBoolean( 'CYCLE_ALL_WEAPONS' , Cycle_All_Weapons );
	AddBoolean( 'SKIPANIM' , SkipAnim );
	AddBoolean( 'MINIMAL_SCREEN_REFRESH' , Minimal_Screen_Refresh );
	AddBoolean( 'USE_SOFTWARE_SURFACE' , Use_Software_Surface );
	AddBoolean( 'NO_SPLASH_SCREEN_AT_START' , not Splash_Screen_At_Start );
	AddBoolean( 'REVERT_SLOWER_SAFER' , Revert_Slower_Safer );
	AddBoolean( 'NAMESON' , Names_Above_Heads );
	AddBoolean( 'PAPERDOLLS' , Use_Paper_Dolls );
	AddBoolean( 'USEMESH' , Mesh_On );
	AddBoolean( 'ERSATZ_MOUSE' , Ersatz_Mouse );
	AddBoolean( 'NO_TRANSPARENT_INTERFACE' , not Transparent_Interface );

	{ The "secret options" come at the end. These tokens only get }
	{ included if they're already set. }
	if XXRAN_Wizard then writeln( F , 'GIMMEGIMMECHOICE' );
	if ArenaMode_Wizard then writeln( F , 'GARYGYGAX' );
	if XXRAN_Debug then writeln( F , 'XXRANDEBUG' );
	if StdPlot_Debug then writeln( F , 'YOUARE#6' );
	AddBoolean( 'DEBUG_ON_ARENAPLAY' , DEBUG_ON_arenaplay );
	AddBoolean( 'DEBUG_ON_ARENASCRIPT' , DEBUG_ON_arenascript );
	if Full_RPGWorld_Info then writeln( F , 'DEMIURGE' );

	Close(F);
end;


Function MsgString( const MsgLabel: String ): String;
	{ Return the standard message string which has the requested }
	{ label. }
var
	tmp: String;
begin
	tmp := MsgLabel;
	DeleteWhiteSpace( tmp );
	MsgString := SAttArrayValue( Text_Messages , tmp );
	if (0 = Length(MsgString)) then begin
		ErrorMessage_fork( 'MsgString: "' + tmp + '" not found.' );
		MsgString := tmp;
	end;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: ui4gh.pp');
{$ENDIF DEBUG}
	UTF8_Help_Keymap_Name := LoadStringArray( UTF8_Help_Keymap_Name_File );
	UTF8_Help_Keymap_Desc := LoadStringArray( UTF8_Help_Keymap_Desc_File );
	ProhibitationHead  := UTF8_Settings( 'ProhibitationHead', ProhibitationHead );
	ProhibitationTrail := UTF8_Settings( 'ProhibitationTrail', ProhibitationTrail );

	Text_Messages := LoadStringArray( Standard_Message_File );
	LoadConfig;
end;

finalization
begin
	SaveConfig;
	DisposeSAttArray( Text_Messages );
	DisposeSAttArray( UTF8_Help_Keymap_Desc );
	DisposeSAttArray( UTF8_Help_Keymap_Name );
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: ui4gh.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
