unit utf8msg;
{$LONGSTRINGS ON}

interface

var
	UTF8_UseOriginalName: Boolean = False;


{ Return the standard message string which has the requested label. }
Function UTF8_Settings( const MsgLabel: String; const DefaultMsg: String ): String;
Function UTF8_Name( const CategoryLabel, MsgLabel: String; const UTF8: Boolean ): String;
Function UTF8_Name( const CategoryLabel, MsgLabel: String ): String;
Function UTF8_Name_withDefault( const MsgLabel, DefaultMsg: String ): String;
Function UTF8_Name_NoFailback( const CategoryLabel, MsgLabel: String ): String;
Function UTF8_Name( const MsgLabel: String ): String;
Function UTF8_MsgString( const CategoryLabel, MsgLabel: String; const UTF8: Boolean ): String;
Function UTF8_MsgString( const CategoryLabel, MsgLabel: String ): String;
Function UTF8_MsgString( const MsgLabel: String ): String;



implementation

uses errmsg,gears_base;


var
	UTF8_Settings_SAtt: SAttArrayPtr;
	UTF8_Name_SAtt:     SAttArrayPtr;
	UTF8_Messages_SAtt: SAttArrayPtr;



Function ConcatenateLabel( const CategoryLabel, MsgLabel: String ): String;
var
	P: Integer;
begin
	ConcatenateLabel := CategoryLabel + '_' + MsgLabel;
	P := Pos( ' ', ConcatenateLabel );
	while (0 < P) do begin
		ConcatenateLabel[P] := '_';
		P := Pos( ' ', ConcatenateLabel );
	end;
end;


Function DeconcatenateLabel( MsgLabel: String ): String;
var
	P: Integer;
begin
	DeconcatenateLabel := MsgLabel;
	P := Pos( '_', DeconcatenateLabel );
	while (0 < P) do begin
		DeconcatenateLabel[P] := ' ';
		P := Pos( '_', DeconcatenateLabel );
	end;
end;



Function UTF8_Settings( const MsgLabel: String; const DefaultMsg: String ): String;
begin
	UTF8_Settings := SAttArrayValue( UTF8_Settings_SAtt, MsgLabel );
	if (0 = Length(UTF8_Settings)) then begin
		ErrorMessage_fork( 'UTF8_Settings: "' + MsgLabel + '" not found.' );
		UTF8_Settings := DefaultMsg;
	end;
end;



Function UTF8_Name( const CategoryLabel, MsgLabel: String; const UTF8: Boolean ): String;
begin
	if UTF8 and not(UTF8_UseOriginalName) then begin
		UTF8_Name := SAttArrayValue( UTF8_Name_SAtt, ConcatenateLabel( CategoryLabel, MsgLabel) );
		if (0 = Length(UTF8_Name)) then begin
			ErrorMessage_fork( 'UTF8_Name: "' + CategoryLabel + ':' + MsgLabel + '" not found.' );
			UTF8_Name := MsgLabel;
		end;
	end else begin
		UTF8_Name := MsgLabel;
	end;
end;


Function UTF8_Name( const CategoryLabel, MsgLabel: String ): String;
begin
	if UTF8_UseOriginalName then begin
		UTF8_Name := MsgLabel;
	end else begin
		UTF8_Name := SAttArrayValue( UTF8_Name_SAtt, ConcatenateLabel( CategoryLabel, MsgLabel) );
		if (0 = Length(UTF8_Name)) then begin
			ErrorMessage_fork( 'UTF8_Name: "' + CategoryLabel + ':' + MsgLabel + '" not found.' );
			UTF8_Name := MsgLabel;
		end;
	end;
end;


Function UTF8_Name_withDefault( const MsgLabel, DefaultMsg: String ): String;
var
	lbl: String;
begin
	lbl := ConcatenateLabel( '', MsgLabel );
	if UTF8_UseOriginalName then begin
		UTF8_Name_withDefault := DefaultMsg;
	end else begin
		UTF8_Name_withDefault := SAttArrayValue( UTF8_Name_SAtt, lbl );
		if (0 = Length(UTF8_Name_withDefault)) then begin
			UTF8_Name_withDefault := DefaultMsg;
		end;
	end;
end;


Function UTF8_Name_NoFailback( const CategoryLabel, MsgLabel: String ): String;
begin
	if UTF8_UseOriginalName then begin
		UTF8_Name_NoFailback := '';
	end else begin
		UTF8_Name_NoFailback := SAttArrayValue( UTF8_Name_SAtt, ConcatenateLabel( CategoryLabel, MsgLabel) );
	end;
end;


Function UTF8_Name( const MsgLabel: String ): String;
var
	lbl: String;
begin
	lbl := ConcatenateLabel( '', MsgLabel );
	if UTF8_UseOriginalName then begin
		UTF8_Name := DeconcatenateLabel( lbl );
	end else begin
		UTF8_Name := SAttArrayValue( UTF8_Name_SAtt, lbl );
		if (0 = Length(UTF8_Name)) then begin
			ErrorMessage_fork( 'UTF8_Name: "' + lbl + '" not found.' );
			UTF8_Name := DeconcatenateLabel( lbl );
		end;
	end;
end;



Function UTF8_MsgString( const CategoryLabel, MsgLabel: String; const UTF8: Boolean ): String;
begin
	if UTF8 then begin
		UTF8_MsgString := SAttArrayValue( UTF8_Messages_SAtt, ConcatenateLabel( CategoryLabel, MsgLabel) );
		if (0 = Length(UTF8_MsgString)) then begin
			ErrorMessage_fork( 'UTF8_MsgString: "' + CategoryLabel + ':' + MsgLabel + '" not found.' );
			UTF8_MsgString := MsgLabel;
		end;
	end else begin
		UTF8_MsgString := MsgLabel;
	end;
end;


Function UTF8_MsgString( const CategoryLabel, MsgLabel: String ): String;
begin
	UTF8_MsgString := SAttArrayValue( UTF8_Messages_SAtt, ConcatenateLabel( CategoryLabel, MsgLabel) );
	if (0 = Length(UTF8_MsgString)) then begin
		ErrorMessage_fork( 'UTF8_MsgString: "' + CategoryLabel + ':' + MsgLabel + '" not found.' );
		UTF8_MsgString := MsgLabel;
	end;
end;


Function UTF8_MsgString( const MsgLabel: String ): String;
begin
	UTF8_MsgString := SAttArrayValue( UTF8_Messages_SAtt, MsgLabel );
	if (0 = Length(UTF8_MsgString)) then begin
		ErrorMessage_fork( 'UTF8_MsgString: "' + MsgLabel + '" not found.' );
		UTF8_MsgString := MsgLabel;
	end;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: utf8msg.pp');
{$ENDIF DEBUG}
	UTF8_Settings_SAtt := LoadStringArray( UTF8_Settings_File );
	UTF8_Name_SAtt     := LoadStringArray( UTF8_Name_File );
	UTF8_Messages_SAtt := LoadStringArray( UTF8_Messages_File );
end;

finalization
begin
	DisposeSAttArray( UTF8_Messages_SAtt );
	DisposeSAttArray( UTF8_Name_SAtt );
	DisposeSAttArray( UTF8_Settings_SAtt );
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: utf8msg.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
