unit vidgfx;
{
	GearHead2, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}
{$LONGSTRINGS ON}


interface

uses
	sysutils,
{$IF DEFINED(ASCII_SDL)}
	sdl,sdl_ttf,sdl_mixer,
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
	w32crt,
{$ELSE}
	crt,video,
{$ENDIF}
	ui4gh,texutil,gears_base,gears;

Type
	vgfx_rect = Record
		X,Y,W,H: Byte;
	end;

	vgfx_zone = Object
		X_Anchor,X_Justify,W_Default: Integer;
		Y_Anchor,Y_Justify,H_Default: Integer;
		X,Y,W,H: Byte;
		function GetRect: VGFX_Rect;
	end;
	vgfx_zoneptr = ^vgfx_zone;


	RedrawProcedureType = Procedure;
	RedrawProcedureType_with_GearPtr = Procedure( M: GearPtr );


Const
	vg_Pen: Byte = 0;	{ Will be initialied to proper value below. }

	Console_History_Length = 240;
{$IFDEF ASCII_SDL}
{$ELSE ASCII_SDL}
  {$IFDEF ASCII_MSWINGUI}
  {$ELSE ASCII_MSWINGUI}
	NormMode: TVideoMode = ( Col: 80; Row: 25; Color: True );
  {$ENDIF ASCII_MSWINGUI}
{$ENDIF ASCII_SDL}

	RightColumnWidth = 25;

	ANC_Low = 0;
	ANC_Mid = 1;
	ANC_High = 2;

	ZONE_Console: vgfx_zone = (
		X_Anchor: ANC_Low; X_Justify: 0; W_Default: 80;
		Y_Anchor: ANC_High; Y_Justify: - ( Default_ScreenRows - 21 ); H_Default: ( Default_ScreenRows - 20 );
	);

	ZONE_Map: vgfx_zone = (
		X_Anchor: ANC_Low; X_Justify: 0; W_Default: ( 80 - RightColumnWidth - 1 );
		Y_Anchor: ANC_Low; Y_Justify: 0; H_Default: 20;
	);

	ZONE_CharGenMenu: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -25; W_Default: 24;
		Y_Anchor: ANC_Mid; Y_Justify: -3; H_Default: 10;
	);
	ZONE_CharGenPrompt: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -25; W_Default: 24;
		Y_Anchor: ANC_Mid; Y_Justify: -10; H_Default: 6;
	);
	ZONE_CharGenCaption: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -25; W_Default: 24;
		Y_Anchor: ANC_Mid; Y_Justify: 9; H_Default: 2;
	);
	ZONE_CharGenDesc: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -37; W_Default: 74;
		Y_Anchor: ANC_High; Y_Justify: -3; H_Default: 3;
	);
	ZONE_CharGenChar: vgfx_zone = (
		X_Anchor: ANC_Low; X_Justify: 1; W_Default: 52;
		Y_Anchor: ANC_Low; Y_Justify: 1; H_Default: 19;
	);


	ZONE_Caption: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -8; W_Default: 16;
		Y_Anchor: ANC_Low; Y_Justify: 3; H_Default: 3;
	);

	ZONE_Info: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -RightColumnWidth + 1; W_Default: RightColumnWidth - 2;
		Y_Anchor: ANC_Mid; Y_Justify: -10; H_Default: 7;
	);
	ZONE_Menu: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -RightColumnWidth + 1; W_Default: RightColumnWidth - 2;
		Y_Anchor: ANC_Mid; Y_Justify: -2; H_Default: 10;
	);
	ZONE_Menu1: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -RightColumnWidth + 1; W_Default: RightColumnWidth - 2;
		Y_Anchor: ANC_Mid; Y_Justify: -2; H_Default: 5;
	);
	ZONE_Menu2: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -RightColumnWidth + 1; W_Default: RightColumnWidth - 2;
		Y_Anchor: ANC_Mid; Y_Justify: 4; H_Default: 4;
	);
	ZONE_SubCaption: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -RightColumnWidth + 1; W_Default: RightColumnWidth - 2;
		Y_Anchor: ANC_Mid; Y_Justify: 7; H_Default: 1;
	);
	ZONE_Clock: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -RightColumnWidth + 2; W_Default: RightColumnWidth - 5;
		Y_Anchor: ANC_Mid; Y_Justify: 8; H_Default: 1;
	);

	ZONE_CharViewChar: vgfx_zone = (
		X_Anchor: ANC_Low; X_Justify: 1; W_Default: 52;
		Y_Anchor: ANC_Low; Y_Justify: 1; H_Default: 19;
	);
	ZONE_CharViewMenu: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -RightColumnWidth + 1; W_Default: RightColumnWidth - 2;
		Y_Anchor: ANC_Mid; Y_Justify: -2; H_Default: 10;
	);
	ZONE_CharViewDesc: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -RightColumnWidth + 1; W_Default: RightColumnWidth - 2;
		Y_Anchor: ANC_Mid; Y_Justify: -10; H_Default: 7;
	);

	ZONE_GetItemMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -16; W_Default: 32;
		Y_Anchor: ANC_Mid; Y_Justify: - 4; H_Default: 8;
	);

	ZONE_ShopCaption: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -37; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify: - 9; H_Default: 2;
	);
	ZONE_ShopMsg: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -37; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify: - 6; H_Default:  6;
	);
	ZONE_ShopMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -37; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify:   1; H_Default:  7;
	);
	ZONE_ShopInfo: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify:  5; W_Default: 33;
		Y_Anchor: ANC_Mid; Y_Justify: -9; H_Default: 14;
	);

	ZONE_ItemsInfo: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify:  5; W_Default: 33;
		Y_Anchor: ANC_Mid; Y_Justify: -9; H_Default: 14;
	);
	ZONE_ItemsPCInfo: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify:  5; W_Default: 33;
		Y_Anchor: ANC_Mid; Y_Justify:  6; H_Default: 2;
	);

	ZONE_EqpMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -37; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify: - 6; H_Default:  6;
	);
	ZONE_InvMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -37; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify:   1; H_Default:  5;
	);
	ZONE_BackpackInstructions: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -37; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify: - 9; H_Default: 2;
	);

	ZONE_FieldHQMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -37; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify: - 9; H_Default: 15;
	);

	ZONE_MoreText: vgfx_zone = (
		X_Anchor: ANC_Low; X_Justify: 0; W_Default: 80;
		Y_Anchor: ANC_Low; Y_Justify: 0; H_Default: 25;
	);


	InteractAreaWidth = 75;
	Interact_X_Justify = -37;
	Interact_Y_Justify = -9;

	{ The name zone includes the JobAgeGender description. }
	ZONE_InteractName: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: Interact_X_Justify; W_Default: InteractAreaWidth;
		Y_Anchor: ANC_Mid; Y_Justify: Interact_Y_Justify; H_Default: 2;
	);
	ZONE_InteractStatus: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: Interact_X_Justify; W_Default: InteractAreaWidth;
		Y_Anchor: ANC_Mid; Y_Justify: Interact_Y_Justify + 2; H_Default: 1;
	);
	ZONE_InteractMsg: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: Interact_X_Justify; W_Default: InteractAreaWidth;
		Y_Anchor: ANC_Mid; Y_Justify: Interact_Y_Justify + 3; H_Default: 5;
	);
	ZONE_InteractMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: Interact_X_Justify; W_Default: InteractAreaWidth;
		Y_Anchor: ANC_Mid; Y_Justify: Interact_Y_Justify + 8; H_Default:  7;
	);

	{ *** INTERNAL USE ONLY *** }
	ZONE_InteractTotal: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: Interact_X_Justify; W_Default: InteractAreaWidth;
		Y_Anchor: ANC_Mid; Y_Justify: Interact_Y_Justify; H_Default: 15;
	);
	{ *** INTERNAL USE ONLY *** }

	ZONE_MemoText: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -20; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify: - 6; H_Default: 8;
	);
	ZONE_MemoMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -20; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify:   3; H_Default:  3;
	);

	{ The SelectArenaMission display zones: }
	ZONE_SAMText: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -20; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify:   0; H_Default:  5;
	);
	ZONE_SAMMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -20; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify:  -6; H_Default:  5;
	);

	ZONE_UsagePrompt: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -20; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify: - 8; H_Default: 10;
	);
	ZONE_UsageMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -20; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify:   3; H_Default:  7;
	);

	{ Note that in ASCII mode, RightInfo and LeftInfo aren't to the right and left, }
	{ but instead occupy the Menu1 and Menu2 zones. }
	ZONE_RightInfo: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: 1; W_Default: 20;
		Y_Anchor: ANC_Low; Y_Justify:   3; H_Default:  7;
	);
	ZONE_LeftInfo: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify: -21; W_Default: 20;
		Y_Anchor: ANC_Low; Y_Justify:   3; H_Default:  7;
	);

	ZONE_WorldMap: vgfx_zone = (
	{	X_Anchor: ANC_Mid; X_Justify: -13; W_Default: 25; }
	{	Y_Anchor: ANC_Mid; Y_Justify: - 8; H_Default: 15; }
		X_Anchor: ANC_Mid; X_Justify: -13; W_Default: 15;
		Y_Anchor: ANC_Mid; Y_Justify: - 8; H_Default: 15;
	);

	ZONE_MonologueInfo: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -20; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify: -8; H_Default: 1
	);
	ZONE_MonologueText: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -20; W_Default: 40;
		Y_Anchor: ANC_Mid; Y_Justify: -6; H_Default: 10
	);

	ZONE_ArenaPilotMenu: vgfx_zone = (
		X_Anchor: ANC_Low; X_Justify: 2; W_Default: 20;
		Y_Anchor: ANC_Low; Y_Justify: 1; H_Default: 15
	);
	ZONE_ArenaMechaMenu: vgfx_zone = (
		X_Anchor: ANC_Low; X_Justify: 23; W_Default: 20;
		Y_Anchor: ANC_Low; Y_Justify: 1; H_Default: 15
	);
	ZONE_ArenaInfo: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify:  -34; W_Default: 33;
		Y_Anchor: ANC_Low; Y_Justify: 1; H_Default: 10;
	);
	ZONE_PCStatus: vgfx_zone = (
		X_Anchor: ANC_High; X_Justify:  -34; W_Default: 33;
		Y_Anchor: ANC_Low; Y_Justify: 12; H_Default: 4;
	);

	ZONE_Dialog: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify:  -39; W_Default: 80;
		Y_Anchor: ANC_Low; Y_Justify: 12; H_Default: 3;
	);


	ZONE_ConcertAudience: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -30; W_Default: 60;
		Y_Anchor: ANC_Mid; Y_Justify: -7; H_Default: 2;
	);
	ZONE_ConcertCaption: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -30; W_Default: 60;
		Y_Anchor: ANC_Mid; Y_Justify: -4; H_Default: 4;
	);
	ZONE_ConcertMenu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -30; W_Default: 60;
		Y_Anchor: ANC_Mid; Y_Justify: 1; H_Default: 4;
	);
	ZONE_ConcertDesc: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -30; W_Default: 60;
		Y_Anchor: ANC_Mid; Y_Justify: 6; H_Default: 1;
	);

	ZONE_Title_Screen_Top: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -15; W_Default: 30;
		Y_Anchor: ANC_Mid; Y_Justify: -10; H_Default: 2;
	);
	ZONE_Title_Screen_Title: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -15; W_Default: 30;
		Y_Anchor: ANC_Mid; Y_Justify: -10; H_Default: 1;
	);
	ZONE_Title_Screen_Version: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -15; W_Default: 30;
		Y_Anchor: ANC_Mid; Y_Justify: -9; H_Default: 1;
	);
	ZONE_Title_Screen_Menu: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -15; W_Default: 30;
		Y_Anchor: ANC_Mid; Y_Justify: -7; H_Default: 15;
	);


	ZONE_TextInputFull: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -30; W_Default: 60;
		Y_Anchor: ANC_Mid; Y_Justify:  -3; H_Default: 4;
	);
	ZONE_TextInputPrompt: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -30; W_Default: 60;
		Y_Anchor: ANC_Mid; Y_Justify:  -3; H_Default: 3;
	);
	ZONE_TextInput: vgfx_zone = (
		X_Anchor: ANC_Mid; X_Justify: -30; W_Default: 60;
		Y_Anchor: ANC_Mid; Y_Justify:   0; H_Default: 1;
	);


{ *** STANDARD COLORS *** }
{$IFDEF ASCII_SDL}
	StdBlack: TSDL_Color =		( r:  0; g:  0; b:  0 );	{ Black }
	StdWhite: TSDL_Color =		( r:255; g:255; b:255 );	{ White }
	MenuItem: TSDL_Color =		( r:  0; g:128; b:128 );	{ Cyan }
	MenuSelect: TSDL_Color =	( r:  0; g:255; b:255 );	{ LightCyan }
	TerrainGreen: TSDL_Color =	( r:  0; g:128; b:  0 );	{ Green }
	PlayerBlue: TSDL_Color =	( r:  0; g:  0; b:255 );	{ LightBlue }
	AllyPurple: TSDL_Color =	( r:255; g:  0; b:255 );	{ LightMagenta }
	EnemyRed: TSDL_Color =		( r:192; g:  0; b:  0 );	{ Red }
	NeutralGrey: TSDL_Color =	( r:192; g:192; b:192 );	{ LightGray }
	InfoGreen: TSDL_Color =		( r:  0; g:128; b:  0 );	{ Green }
	InfoHiLight: TSDL_Color =	( r:  0; g:255; b:  0 );	{ LightGreen }
	TextboxGrey: TSDL_Color =	( r:128; g:128; b:128 );	{ DarkGray }
	AttackColor: TSDL_Color =	( r:255; g:  0; b:  0 );	{ LightRed }
	NeutralBrown: TSDL_Color =	( r:255; g:255; b:  0 );	{ Yellow }
	BorderBlue: TSDL_Color =	( r:  0; g:  0; b:192 );	{ Blue }
	MelodyYellow: TSDL_Color =	( r:255; g:255; b:  0 );	{ Yellow }

	Black: TSDL_Color =		( r:  0; g:  0; b:  0 );
	Blue: TSDL_Color =		( r:  0; g:  0; b:192 );
	Green: TSDL_Color =		( r:  0; g:128; b:  0 );
	Cyan: TSDL_Color =		( r:  0; g:128; b:128 );
	Red: TSDL_Color =		( r:192; g:  0; b:  0 );
	Magenta: TSDL_Color =		( r:128; g:  0; b:128 );
	Brown: TSDL_Color =		( r:128; g: 96; b:  0 );
	LightGray: TSDL_Color =		( r:192; g:192; b:192 );
	DarkGray: TSDL_Color =		( r:128; g:128; b:128 );
	LightBlue: TSDL_Color =		( r:  0; g:  0; b:255 );
	LightGreen: TSDL_Color =	( r:  0; g:255; b:  0 );
	LightCyan: TSDL_Color =		( r:  0; g:255; b:255 );
	LightRed: TSDL_Color =		( r:255; g:  0; b:  0 );
	LightMagenta: TSDL_Color =	( r:255; g:  0; b:255 );
	Yellow: TSDL_Color =		( r:255; g:255; b:  0 );
	White: TSDL_Color =		( r:255; g:255; b:255 );
{$ELSE ASCII_SDL}
	StdBlack: Byte = Black;
	StdWhite: Byte = White;
	MenuItem: Byte = Cyan;
	MenuSelect: Byte = LightCyan;
	TerrainGreen: Byte = Green;
	PlayerBlue: Byte = LightBlue;
	AllyPurple: Byte = LightMagenta;
	EnemyRed: Byte = Red;
	NeutralGrey: Byte = LightGray;
	InfoGreen: Byte = Green;
	InfoHiLight: Byte = LightGreen;
	TextboxGrey: Byte = DarkGray;
	AttackColor: Byte = LightRed;
	NeutralBrown: Byte = Yellow;
	BorderBlue: Byte = Blue;
	MelodyYellow: Byte = Yellow;
{$ENDIF ASCII_SDL}

{ STATE VARIABLES - USE WITH CAUTION }
{ External setting of these vars is not supported, but reading should }
{ be okay most of the time. }
{$IFDEF ASCII_SDL}
	VG_FGColor: TSDL_Color		= ( r:192; g:192; b:192 );	{ LightGray }
	VG_BGColor: TSDL_Color		= ( r:  0; g:  0; b:  0 );	{ Black }
{$ELSE ASCII_SDL}
	vg_FGColor: Byte = LightGray;
	vg_BGColor: Byte = Black;
{$ENDIF ASCII_SDL}
	vg_X: Byte = 1;	{ Cursor Position. }
	vg_Y: Byte = 1;	{ Cursor Position. }
	vg_Window: vgfx_rect = ( x:1 ; y:1 ; w:80 ; h:25 );

{$IFDEF ASCII_SDL}
	Game_FontSize: Integer = 12;
	Game_Font: PTTF_Font = NIL;
	ASCII_Width_Of_One_Character: String = 'M';
	UTF8_Width_Of_One_Character: String = 'M';
	CharWidth:  LongInt = 8;
	CharHeight: LongInt = 8;
	ScreenWidth:  Integer = 80;
	ScreenHeight: Integer = 25;
	KEY_REPEAT_DELAY = 200;
	KEY_REPEAT_INTERVAL = 75;
{$ELSE ASCII_SDL}
{$ENDIF ASCII_SDL}

	TAG_CUSTOMIZATION_EMBLEM = 'CUSTOMIZATION_EMBLEM';
	EMBLEM_PREFIX = 'emblem_';
	EMBLEM_DEFAULT = 'star.psc';
	EMBLEM_SUFFIX = '.png';

Var
	Console_History: SAttListPtr;
{$IFDEF ASCII_SDL}
	Game_Screen: PSDL_Surface;
{$ELSE ASCII_SDL}
{$ENDIF ASCII_SDL}


Procedure PlaySoundEffect_Direct( const Name: String );

Procedure DoFlip;

Function RPGKey: Char;
Function RPGKeyEvent: Char;
Function IsMoreKey( A: Char ): Boolean;
Procedure MoreKey;


Procedure ClrZone( const Z: vgfx_Rect );
Procedure ClrScreen;

{$IFDEF ASCII_SDL}
Procedure TextColor( C: TSDL_Color );
Procedure TextBackground( C: TSDL_Color );
{$ELSE ASCII_SDL}
Procedure TextColor( C: Byte );
Procedure TextBackground( C: Byte );
{$ENDIF ASCII_SDL}
Procedure TextOut(X,Y : Word;Const S : String);
Procedure ClipZone( Z: vgfx_rect );
Procedure MaxClipZone;
{$IFDEF ASCII_SDL}
Procedure DrawGlyph( img: Char; X,Y: Byte; FG,BG: TSDL_Color );
{$ELSE ASCII_SDL}
Procedure DrawGlyph( img: Char; X,Y,FG,BG: Byte );
{$ENDIF ASCII_SDL}

{$IFDEF ASCII_SDL}
Procedure GameMSG( msg: string; Z: vgfx_rect; C: TSDL_Color );
Procedure GameMSG( msg: string; Z: vgfx_zone; C: TSDL_Color );
Procedure CMessage( const msg: String; Z: VGFX_Rect; C: TSDL_Color );
Procedure CMessage( const msg: String; Z: VGFX_Zone; C: TSDL_Color );
{$ELSE ASCII_SDL}
Procedure GameMSG( msg: string; Z: vgfx_rect; C: Byte );
Procedure GameMSG( msg: string; Z: vgfx_zone; C: Byte );
Procedure CMessage( const msg: String; Z: VGFX_Rect; C: Byte );
Procedure CMessage( const msg: String; Z: VGFX_Zone; C: Byte );
{$ENDIF ASCII_SDL}

Procedure RedrawConsole;
Procedure DialogMsg(msg: string);

Procedure MoreText( LList: SAttListPtr; FirstLine: Integer );

Function GetStringFromUser( const Prompt: String; const DefaultSearchPattern: String; ReDrawer: RedrawProcedureType_with_GearPtr; M: GearPtr ): String;
Function GetStringFromUser( const Prompt: String; const DefaultSearchPattern: String; ReDrawer: RedrawProcedureType_with_GearPtr; M: GearPtr; var Cancelled: Boolean ): String;

Procedure SetupMemoDisplay;
Procedure DrawBPBorder;
Procedure SetupFHQDisplay;
Procedure DrawGetItemBorder;
{$IFDEF ASCII_SDL}
Procedure SetupInteractDisplay( C: TSDL_Color );
{$ELSE ASCII_SDL}
Procedure SetupInteractDisplay( C: Byte );
{$ENDIF ASCII_SDL}
Procedure SetupServicesDisplay;


Procedure InfoBox( MyDest: VGFX_Rect );
Procedure InfoBox( Z: VGFX_Zone );
Procedure ClockBorder;

Procedure SetupArenaDisplay;
Procedure SetupArenaMissionMenu;
Procedure SetupConcertDisplay;
Procedure SetupTitleScreenDisplay;


implementation
uses
	errmsg,
	vidmenus
{$IF DEFINED(ASCII_SDL)}
	, strings, utf8msg
{$ELSEIF DEFINED(ASCII_UTF8)}
	,utf8video
{$ENDIF}
{$IF DEFINED(ASCII_SDL)}
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
{$ELSE}
	,keyboard
{$ENDIF}
	;

{$IFDEF ASCII_SDL}
type
	SensibleSoundEffectListPtr = ^SensibleSoundEffectList;
	SensibleSoundEffectList = Record
		Name: String;
		Chunk: PMix_Chunk;
		Next: SensibleSoundEffectListPtr;
	end;

var
	SoundEffectList: SensibleSoundEffectListPtr;
{$ENDIF ASCII_SDL}


{$IFDEF ASCII_SDL}
Procedure Load_SoundEffect;
var
	SoundEffectFileList: SAttListPtr;
	P: SAttListElementPtr;
	S: SensibleSoundEffectListPtr;
	PText: PChar;
begin
	SoundEffectFileList := CreateFileList( Sound_Directory + '*.*' , False );
	SoundEffectList := NIL;

	P := SoundEffectFileList^.head;
	while ( NIL <> P ) do begin
		if ( ( 3 <= Length( P^.Info ) ) and ( '.txt' <> Copy( P^.Info , (Length(P^.Info) - 3) , 4 ) ) and ( '.bak' <> Copy( P^.Info , (Length(P^.Info) - 3) , 4 ) ) ) then begin
			New( S );
			if ( NIL = S ) then exit;

			S^.Name := P^.Info;
			PText := QuickPCopy( Sound_Directory + P^.Info );
			S^.Chunk := Mix_LoadWAV( PText );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
			sysutils.StrDispose( PText );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
			S^.Next := SoundEffectList;

			if ( NIL <> S^.Chunk ) then begin
				SoundEffectList := S;
			end else begin
				ErrorMessage( 'SDL_mixer error at Mix_LoadWAV(' + P^.Info + ') : ' + SDL_GetError );
{$IFDEF PATCH_GH_PARANOID_SAFER}
				S^.Name[1] := '@';
				S^.Chunk   := NIL;
				S^.Next    := SensibleSoundEffectListPtr(-1);
{$ENDIF PATCH_GH_PARANOID_SAFER}
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
				Dispose( S );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
			end;
		end;
		P := P^.Next;
	end;

	DisposeSAttList( SoundEffectFileList );
end;

Procedure Dispose_SoundEffect;
var
	S,S2: SensibleSoundEffectListPtr;
begin
	S := SoundEffectList;
	while ( NIL <> S ) do begin
		S2 := S^.Next;

		Mix_FreeChunk( S^.Chunk );
{$IFDEF PATCH_GH_PARANOID_SAFER}
		S^.Name[1] := '@';
		S^.Chunk   := NIL;
		S^.Next    := SensibleSoundEffectListPtr(-1);
{$ENDIF PATCH_GH_PARANOID_SAFER}
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
		Dispose( S );
{$ENDIF PATCH_GH_PARANOID_CHECKER}

		S := S2;
	end;
end;

Procedure PlaySoundEffect_Direct( const Name: String );
var
	S: SensibleSoundEffectListPtr;
begin
	if ( Length(Name) < 3 ) then exit;

	S := SoundEffectList;
	while ( NIL <> S ) do begin
		if ( Name = S^.Name ) then begin
			Mix_PlayChannel( -1 , S^.Chunk , 0 );
			exit;
		end;
		S := S^.Next;
	end;
{$IFDEF DEBUG}
	ErrorMessage_fork( 'A sound effect file "' + Name + '" was not found.' );
{$ENDIF DEBUG}
end;
{$ELSE ASCII_SDL}
Procedure PlaySoundEffect_Direct( const Name: String );
begin
end;
{$ENDIF ASCII_SDL}


Function VGFX_Zone.GetRect(): VGFX_Rect;
	{ Convert the provided zone to a rect. }
var
	it: VGFX_Rect;
begin
	it.W := Self.W;
	it.H := Self.H;
	it.X := Self.X;
	it.Y := Self.Y;
	GetRect := it;
end;


Procedure DoFlip;
	{ Update the screen. }
begin
{$IF DEFINED(ASCII_SDL)}
	SDL_Flip( Game_Screen );
{$ELSEIF DEFINED(ASCII_NOVIDEOBUF)}
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
	w32crt.RedrawScreen;
{$ELSEIF DEFINED(ASCII_UTF8)}
	utf8video.RedrawScreen;
{$ELSE}
	UpdateScreen( False );
{$ENDIF}
end;

{$IF DEFINED(ASCII_SDL)}
function RawKey( var Unicode: Word ): Char;
var
	a: String;
	event : TSDL_Event;
	Procedure ProcessThatEvent;
	begin
		if event.type_ = SDL_KEYDOWN then begin
			if ( 0 < event.key.keysym.unicode ) and ( event.key.keysym.unicode < $80 ) then begin
				a := Char( event.key.keysym.unicode );
			end else begin
				Unicode := event.key.keysym.unicode;
				a := KBD_UNICODE_FLAG;
			end;
		end;
	end;
var
	PResult: Integer;
begin
	Unicode := 0;
	a := '';
	repeat
		PResult := SDL_WaitEvent( @event );
		if ( 1 = PResult ) then begin
			ProcessThatEvent;
		end;
	until ( '' <> a );

	RawKey := a[1];
end;
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
{$ELSE}
Function RawKey( var Unicode: Word ): Char;
	{Read a keypress from the keyboard. Convert it into a form}
	{that my other procedures would be willing to call useful.}
var
	getit: Char;
	TK: TKeyEvent;
begin
	Unicode := 0;
	TK := TranslateKeyEvent( GetKeyEvent );

	case GetKeyEventFlags( TK ) of
	kbASCII: getit := GetKeyEventChar(TK);
	kbUniCode: begin getit := KBD_UNICODE_FLAG; Unicode := GetKeyEventUniCode( TK ); end;
	kbFnKey: getit := KBD_NONE;
	kbPhys: getit := ' ';
	end;

	RawKey := getit;
end;
{$ENDIF}

{$IF DEFINED(ASCII_SDL)}
function RPGKey: Char;
	{ Read a readable key from the keyboard and return its ASCII value. }
	{ This function will always return within a close approximation of 30ms }
	{ from the last time it was called. It will also update the array of }
	{ keypresses. }
var
	a: String;
	event : TSDL_Event;
	Procedure ProcessThatEvent;
		{ An event has been recieved. Process it. }
	begin
		if event.type_ = SDL_KEYDOWN then begin
			{ Check to see if it was an ASCII character we recieved. }
			if ( 0 < event.key.keysym.unicode ) and ( event.key.keysym.unicode < $80 ) then begin
				a := Char( event.key.keysym.unicode );
			end else begin
				a := KBD_UNICODE_FLAG;
			end;
		end;
	end;
var
	PResult: Integer;
begin
	{ Go through the accumulated events looking for good ones. }
	a := '';
	repeat
		PResult := SDL_WaitEvent( @event );
		if PResult = 1 then begin
			{ See if this event is a keyboard one... }
			ProcessThatEvent;
		end;
	until ( a <> '' );

	RPGKey := a[1];
end;
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
function RPGKey: Char;
begin
	RPGKey := w32crt.ReadKey;
end;
{$ELSE}
function RPGKey: Char;
begin
	RPGKey := ReadKey;
end;
{$ENDIF}

function RPGKeyEvent: Char;
var
	C: Char;
{$IF DEFINED(ASCII_SDL)}
	event : TSDL_Event;
	Procedure ProcessThatEvent;
	begin
		if event.type_ = SDL_KEYDOWN then begin
			case event.key.keysym.sym of
				SDLK_Backspace:	C := KBD_BS;
				SDLK_Tab:	C := KBD_TAB;
				SDLK_Return:	C := KBD_RET;
				SDLK_Escape:	C := KBD_ESC;
				SDLK_Delete:	C := KBD_Delete;
				SDLK_KP0:		C := KBD_Insert;
				SDLK_KP1:		C := KBD_End;
				SDLK_KP2:		C := KBD_Down;
				SDLK_KP3:		C := KBD_PgDn;
				SDLK_KP4:		C := KBD_Left;
				SDLK_KP5:		C := KBD_KP5;
				SDLK_KP6:		C := KBD_Right;
				SDLK_KP7:		C := KBD_Home;
				SDLK_KP8:		C := KBD_Up;
				SDLK_KP9:		C := KBD_PgUp;
				SDLK_KP_Period:		C := KBD_Delete;
				SDLK_KP_Divide:		C := '/';
				SDLK_KP_Multiply:	C := '*';
				SDLK_KP_Minus:		C := '-';
				SDLK_KP_Plus:		C := '+';
				SDLK_KP_Enter:		C := KBD_RET;
				SDLK_KP_Equals:		C := '=';
				SDLK_Up:	C := KBD_Up;
				SDLK_Down:	C := KBD_Down;
				SDLK_Right:	C := KBD_Right;
				SDLK_Left:	C := KBD_Left;
				SDLK_Insert:	C := KBD_Insert;
				SDLK_Home:	C := KBD_Home;
				SDLK_End:	C := KBD_End;
				SDLK_PageUp:	C := KBD_PgUp;
				SDLK_PageDown:	C := KBD_PgDn;
				SDLK_F1:	C := KBD_F1;
				SDLK_F2:	C := KBD_F2;
				SDLK_F3:	C := KBD_F3;
				SDLK_F4:	C := KBD_F4;
				SDLK_F5:	C := KBD_F5;
				SDLK_F6:	C := KBD_F6;
				SDLK_F7:	C := KBD_F7;
				SDLK_F8:	C := KBD_F8;
				SDLK_F9:	C := KBD_F9;
				SDLK_F10:	C := KBD_F10;
				SDLK_F11:	C := KBD_F11;
				SDLK_F12:	C := KBD_F12;
				SDLK_F13:	C := KBD_F13;
				SDLK_F14:	C := KBD_F14;
				SDLK_F15:	C := KBD_F15;
			else
				if ( 0 < event.key.keysym.unicode ) and ( event.key.keysym.unicode < $80 ) then begin
					C := Char(event.key.keysym.unicode);
				end else begin
					C := KBD_NONE;
				end;
			end;
		end;
	end;
{$ENDIF DEFINED(ASCII_SDL)}
var
	i: Integer;
{$IF DEFINED(ASCII_SDL)}
	PResult: Integer;
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
{$ELSEIF DEFINED(ASCII_UTF8)}
	RK: Char;
{$ELSE}
	TK: TKeyEvent;
{$ENDIF}
begin
	C := KBD_NONE;
{$IF DEFINED(ASCII_SDL)}
	repeat
		PResult := SDL_WaitEvent( @event );
		if PResult = 1 then begin
			{ See if this event is a keyboard one... }
			ProcessThatEvent;
		end;
	until ( KBD_NONE <> C );
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
	C := w32crt.GetKeyEvent();
{$ELSEIF DEFINED(ASCII_UTF8)}
	RK := ReadKey;
	Case RK of
		{ 45 5B 1B: 5 in TenKey on Unix-Console }
		#$00: begin	{We have a two-part special key.}
			{Obtain the scan code.}
			RK := ReadKey;
			case RK of
				#$52: C := KBD_Insert;	{ 0 in TenKey }
				#$53: C := KBD_Delete;	{ . in TenKey on X-Window/MS-Windows }
				#$5A: C := KBD_End;	{ End Cursor Key on X-Window }
				#$4F: C := KBD_End;	{ End Cursor Key on Unix-Console, MS-Windows }
				#$50: C := KBD_Down;	{ Down Cursor Key }
				#$51: C := KBD_PgDn;	{ PageDown Cursor Key }
				#$4B: C := KBD_Left;	{ Left Cursor Key }
				#$5F: C := KBD_KP5;	{ 5 in TenKey on X-Window }
				#$4C: C := KBD_KP5;	{ 5 in TenKey on MS-Windows }
				#$4D: C := KBD_Right;	{ Right Cursor Key }
				#$5B: begin
						RK := ReadKey;
						case RK of
							#$1B: C := KBD_Home;	{ Home Cursor Key on X-Window }
							else C := KBD_NONE;
						end;
					end;
				#$47: C := KBD_Home;	{ Home Cursor Key on Unix-Console, MS-Windows }
				#$48: C := KBD_Up;	{ Up Cursor Key }
				#$49: C := KBD_PgUp;	{ PageUp Cursor Key }
				#$35: C := '/';		{ Slash in TenKey on MS-Windows }
				#$1C: C := KBD_REt;	{ Enter in TenKey on MS-Windows => Altanative-RET }
				#$3B: C := KBD_F1; { F1  on Unix-Console, MS-Windows }
				#$3C: C := KBD_F2; { F2  on Unix-Console, MS-Windows }
				#$3D: C := KBD_F3; { F3  on Unix-Console, MS-Windows }
				#$3E: C := KBD_F4; { F4  on Unix-Console, MS-Windows }
				#$3F: C := KBD_F5; { F5  on Unix-Console, MS-Windows }
				#$40: C := KBD_F6; { F6  }
				#$41: C := KBD_F7; { F7  }
				#$42: C := KBD_F8; { F8  }
				#$43: C := KBD_F9; { F9  }
				#$44: C := KBD_F10; { F10 }
				#$85: C := KBD_F11; { F11 }
				#$86: C := KBD_F12; { F12 }
				#$29: C := KBD_ESC; { JP109key-Hankaku/Zenkaku on MS-Windows => ESC }
				else C := KBD_NONE;
			end;
		end;

		#$08: C := KBD_BS;	{ Backspace, DEL in TenKey on Unix-Console => ESC }

		#$0A: C := KBD_LF;
		#$0D: C := KBD_RET;	{ Enter, Enter in TenKey on Unix-Console/X-Window }
	else
		C := RK;
	end;
{$ELSE}
	TK := TranslateKeyEvent( GetKeyEvent() );
	case GetKeyEventFlags( TK ) of
	kbASCII: C := GetKeyEventChar(TK);
	kbUniCode: C := KBD_NONE;
	kbFnKey: begin
			case TKeyEvent( GetKeyEventCode(TK) ) of
			kbdF1  : C := KBD_F1  ;
			kbdF2  : C := KBD_F2  ;
			kbdF3  : C := KBD_F3  ;
			kbdF4  : C := KBD_F4  ;
			kbdF5  : C := KBD_F5  ;
			kbdF6  : C := KBD_F6  ;
			kbdF7  : C := KBD_F7  ;
			kbdF8  : C := KBD_F8  ;
			kbdF9  : C := KBD_F9  ;
			kbdF10 : C := KBD_F10 ;
			kbdF11 : C := KBD_F11 ;
			kbdF12 : C := KBD_F12 ;
			kbdF13 : C := KBD_F13 ;
			kbdF14 : C := KBD_F14 ;
			kbdF15 : C := KBD_F15 ;
			kbdF16 : C := KBD_F16 ;
			kbdF17 : C := KBD_F17 ;
			kbdF18 : C := KBD_F18 ;
			kbdF19 : C := KBD_F19 ;
			kbdF20 : C := KBD_F20 ;
			kbdLWin   : C := KBD_LWin   ;
			kbdRWin   : C := KBD_RWin   ;
			kbdApps   : C := KBD_Apps   ;
			kbdHome   : C := KBD_Home   ;
			kbdUp     : C := KBD_Up     ;
			kbdPgUp   : C := KBD_PgUp   ;
			kbdLeft   : C := KBD_Left   ;
			kbdKP5    : C := KBD_KP5    ;
			kbdRight  : C := KBD_Right  ;
			kbdEnd    : C := KBD_End    ;
			kbdDown   : C := KBD_Down   ;
			kbdPgDn   : C := KBD_PgDn   ;
			kbdInsert : C := KBD_Insert ;
			kbdDelete : C := KBD_Delete ;
			kbdBS  : C := KBD_BS  ;
			kbdTAB : C := KBD_TAB ;
			kbdRET : C := KBD_RET ;
			kbdLF  : C := KBD_LF  ;
			kbdESC : C := KBD_ESC ;
			else
				C := KBD_NONE;
			end;
		end;
	kbPhys: C := KBD_NONE;
	end;
{$ENDIF}

	i := 1;
	while ( KBD_ERROR <> KCodeAlias[i].KCode_from ) do begin
		if ( KCodeAlias[i].KCode_from = C ) then begin
			C := KCodeAlias[i].KCode_to;
			break;
		end;
		Inc( i );
	end;

	RPGKeyEvent := C;
end;


Function IsMoreKey( A: Char ): Boolean;
	{ Return TRUE if A is a "more" key, that should skip to the next message in a list. }
begin
	IsMoreKey := ( A = ' ' ) or ( A = #27 );
end;

Procedure MoreKey;
	{ Wait for the user to press either the space bar or the ESC key. }
var
	A: Char;
begin
	{ Keep reading keypresses until either a space or an ESC is found. }
	repeat
		A := RPGKey;
	until IsMoreKey( A );
end;

{$IF DEFINED(ASCII_SDL)}
Procedure ClrZone( const Z: vgfx_Rect );
	{ Clear the specified screen zone. }
var
	SZ: TSDL_Rect;
begin
	SZ.X := (LongInt(Z.X) - 1) * CharWidth;
	SZ.Y := (LongInt(Z.Y) - 1) * CharHeight;
	SZ.W := LongInt(Z.W) * CharWidth;
	SZ.H := LongInt(Z.H) * CharHeight;
	SDL_FillRect( Game_Screen , @SZ , SDL_MapRGB( Game_Screen^.Format , 0 , 0 , 0 ) );
end;

Procedure ClrScreen;
	{ Clear the specified screen zone. }
begin
	SDL_FillRect( Game_Screen , NIL , SDL_MapRGBA( Game_Screen^.Format , 0 , 0 , 0 , 0 ) );
end;
{$ELSEIF DEFINED(ASCII_NOVIDEOBUF)}
Procedure ClrZone( const Z: vgfx_Rect );
	{ Clear the specified zone. }
var
	S: String;
	X, Y: Integer;
begin
	S := '';
	for X := Z.X to ( Z.X + Z.W - 1 ) do begin
		S := S + ' ';
	end;
	for Y := Z.Y to ( Z.Y + Z.H - 1 ) do begin
		crt.GotoXY( Z.X, Y );
		system.Write( S );
	end;
end;

Procedure ClrScreen;
	{ Clear the entire screen. Yay! }
begin
	crt.ClrScr;
end;
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
Procedure ClrZone( const Z: vgfx_Rect );
	{ Clear the specified zone. }
begin
	w32crt.Window( Z.X, Z.Y , (Z.X + Z.W - 1), (Z.Y + Z.H - 1) );
	w32crt.ClrScr;
	w32crt.Window( 1, 1, ScreenColumns, ScreenRows );
end;

Procedure ClrScreen;
	{ Clear the entire screen. Yay! }
begin
	w32crt.Window( 1, 1, ScreenColumns, ScreenRows );
	w32crt.ClrScr;
end;
{$ELSEIF DEFINED(ASCII_UTF8)}
Procedure ClrZone( const Z: vgfx_Rect );
	{ Clear the specified zone. }
begin
	utf8video.Window( Z.X, Z.Y , (Z.X + Z.W - 1), (Z.Y + Z.H - 1) );
	utf8video.ClrScr;
	utf8video.Window( 1, 1, ScreenColumns, ScreenRows );
end;

Procedure ClrScreen;
	{ Clear the entire screen. Yay! }
begin
	utf8video.Window( 1, 1, ScreenColumns, ScreenRows );
	utf8video.ClrScr;
end;
{$ELSE}
Function BufferPos( X,Y: Integer ): Integer;
	{ Translate screen coordinates X,Y into a video buffer index. }
begin
	BufferPos := (X-1)+(Y-1)*ScreenWidth;
end;

Procedure ClrZone( const Z: vgfx_Rect );
	{ Clear the specified zone. }
const
	ClrChar: TVideoCell = Ord(' ')+($07 shl 8);
var
	X,Y,P: Integer;
begin
	for X := Z.X to ( Z.X + Z.W - 1 ) do begin
		for Y := Z.Y to ( Z.Y + Z.H - 1 ) do begin
			P := BufferPos( X , Y );
			if ( P >= 0 ) and ( P < ( ScreenWidth * ScreenHeight ) ) then VideoBuf^[ BufferPos( X , Y ) ] := ClrChar;
		end;
	end;
end;

Procedure ClrScreen;
	{ Clear the entire screen. Yay! }
var
	sz: vgfx_rect;
begin
	sz.X := 1;
	sz.Y := 1;
	sz.H := screenheight;
	sz.W := screenwidth;
	ClrZone( sz );
end;
{$ENDIF}

Procedure VClrEOL;
	{ Clear from the current write position to the end of the current line. }
var
	sz: vgfx_rect;
begin
	sz.X := VG_X;
	sz.Y := VG_Y;
	sz.H := 1;
{$IFDEF ASCII_MSWINGUI}
	sz.W := ScreenColumns - VG_X;
{$ELSE ASCII_MSWINGUI}
	sz.W := screenwidth - VG_X;
{$ENDIF ASCII_MSWINGUI}
	if sz.W > ( vg_window.X + vg_window.W - 1 ) then sz.W := ( vg_window.X + vg_window.W - VG_X );
	ClrZone( sz );
end;

{$IFDEF ASCII_SDL}
Procedure TextColor( C: TSDL_Color );
	{ Set the foreground color. }
begin
	VG_FGColor := C;
end;

Procedure TextBackground( C: TSDL_Color );
	{ Set the background color. }
begin
	VG_BGColor := C;
end;

Procedure TextColorBackground( FG,BG: TSDL_Color );
	{ Set the foreground color. }
begin
	VG_FGColor := FG;
	VG_BGColor := BG;
end;
{$ELSE ASCII_SDL}
Procedure CalcPen;
	{ Calculate the color bit value, based on the requested FGPen and BGPen. }
begin
	VG_Pen := VG_FGColor + ( VG_BGColor shl 4 );
end;

Procedure TextColor( C: Byte );
	{ Set the foreground color. }
begin
	VG_FGColor := C;
	CalcPen;
end;

Procedure TextBackground( C: Byte );
	{ Set the background color. }
begin
	VG_BGColor := C;
	CalcPen;
end;

Procedure TextColorBackground( FG,BG: Byte );
	{ Set the foreground color. }
begin
	VG_FGColor := FG;
	VG_BGColor := BG;
	CalcPen;
end;
{$ENDIF ASCII_SDL}

Function InWindow( X , Y: Byte ): Boolean;
	{ Return TRUE if X,Y is in the window, or FALSE otherwise. }
begin
	InWindow := ( X >= vg_window.X ) and ( Y >= vg_window.Y ) and ( X < ( vg_window.X + vg_window.w ) ) and ( Y < ( vg_window.y + vg_window.h ) );
end;

{$IF DEFINED(ASCII_SDL)}
Function UTF8_TTF_RenderText(var font: PTTF_Font; const msg: String; var fg: TSDL_Color ): PSDL_Surface;
var
	pline: PChar;
	bg: TSDL_Color;
begin
	pline := QuickPCopy( msg );
	if not(SDL_AAFont) and not(SDL_AAFont_Shaded) then begin
		UTF8_TTF_RenderText := TTF_RenderUTF8_Solid( font , pline , fg );
	end else if SDL_AAFont_Shaded then begin
		bg.r := 0;
		bg.b := 0;
		bg.g := 0;
		UTF8_TTF_RenderText := TTF_RenderUTF8_Shaded( font , pline , fg , bg );
	end else begin
		UTF8_TTF_RenderText := TTF_RenderUTF8_Blended( font , pline , fg );
	end;
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
	sysutils.StrDispose( pline );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
end;

Procedure TextOut(X,Y : Word;Const S : String);
	{ Write text to the screen at the listed coordinates. This procedure }
	{ was ripped more or less exactly from the FPC documentation. }
Var
	MyText: PSDL_Surface;
	MyDest: TSDL_Rect;
begin
	MyText := UTF8_TTF_RenderText( Game_Font , S , VG_FGColor );

	MyDest.X := (LongInt(X) - 1) * CharWidth;
	MyDest.Y := (LongInt(Y) - 1) * CharHeight;
	MyDest.W := (UTF8StrWidth(S)) * CharWidth;
	MyDest.H := CharHeight;
	SDL_FillRect( Game_Screen , @MyDest , SDL_MapRGB( Game_Screen^.Format , VG_BGColor.r , VG_BGColor.g , VG_BGColor.b ) );
	SDL_BlitSurface( MyText , NIL , Game_Screen , @MyDest );

	SDL_FreeSurface( MyText );
end;
{$ELSEIF DEFINED(ASCII_NOVIDEOBUF)}
Procedure WriteUTF8Str( const arg_msg: String );
	{ NOTE: In CJK, there are many charctors, one charactor have double size for one ANK charactor and data length is 3 or 4 bytes. }
	{ NOTE: But, a function Write() clipped by data length. }
	{ NOTE: FPC's unicode functions is not stable, is its? }
var
	msg: String;
	MaxLen: Integer;
	P, lastP: Integer;
	X, Y: Integer;
	Len: Integer;

begin
	msg := arg_msg;

	MaxLen := Length(msg);
	P := 1;	lastP := 1;
	X := WhereX;	Y := WhereY;

	while (P <= MaxLen) do begin
		Len := LengthUTF8Char( msg[P] );
		if 0 < Len then begin
			if Len <= 2 then begin
				{ BUG: Display width is mistook if use JISx0201-KANA. }
				P := P + Len;
				X := X + Len;
			end else begin
				Write(Copy(msg,lastP,P-lastP+len));
				P := P + Len;
				lastP := P;
				X := X + 2;
				GotoXY(X,Y+1);
				if (Y+1) <> WhereY then begin
					GotoXY(X,Y-1);
					if (Y-1) <> WhereY then begin
						GotoXY(X+2,Y);
					end;
				end;
				GotoXY(X,Y);
			end;
		end else begin
			Inc(P);
			Inc(X);
		end;
	end;
	if lastP < P then Write(Copy(msg,lastP,MaxLen-lastP+1));
end;

Procedure TextOut(X,Y : Word;Const S : String);
	{ Write text to the screen at the listed coordinates. This procedure }
	{ was ripped more or less exactly from the FPC documentation. }
begin
	crt.GotoXY( X, Y );
	crt.TextColor( VG_FGColor );
	crt.TextBackground( VG_BGColor );
	WriteUTF8Str( S );
end;
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
Procedure TextOut(X,Y : Word;Const S : String);
	{ Write text to the screen at the listed coordinates. This procedure }
	{ was ripped more or less exactly from the FPC documentation. }
begin
	w32crt.GotoXY( X, Y );
	w32crt.TextColor( VG_FGColor );
	w32crt.TextBackground( VG_BGColor );
	w32crt.Write( S );
end;
{$ELSEIF DEFINED(ASCII_UTF8)}
Procedure TextOut(X,Y : Word;Const S : String);
	{ Write text to the screen at the listed coordinates. This procedure }
	{ was ripped more or less exactly from the FPC documentation. }
begin
	utf8video.GotoXY( X, Y );
	utf8video.TextColor( VG_FGColor );
	utf8video.TextBackground( VG_BGColor );
	utf8video.Write( S );
end;
{$ELSE}
Procedure TextOut(X,Y : Word;Const S : String);
	{ Write text to the screen at the listed coordinates. This procedure }
	{ was ripped more or less exactly from the FPC documentation. }
Var
	P,I,M : Word;
begin
	P:=((X-1)+(Y-1) * ScreenWidth);
	M:=UTF8StrWidth(S);
	If ( P + M ) > ScreenWidth*ScreenHeight then M:=ScreenWidth*ScreenHeight-P;
	For I:=1 to M do if InWindow( X + I - 1 , Y ) then VideoBuf^[P+I-1]:=Ord(S[i])+( VG_Pen shl 8 );
end;
{$ENDIF}

Procedure ClipZone( Z: vgfx_rect );
	{ Set the clipping bounds to this defined zone. }
begin
	vg_window := Z;
	vg_x := Z.X;
	vg_y := Z.Y;
end;

Procedure VGotoXY( X,Y: Integer );
	{ Set the write position to the requested coordinates. }
begin
	vg_x := X;
	vg_y := Y;
end;

Procedure MaxClipZone;
	{ Restore the clip area to the maximum possible area. }
begin
	vg_window.X := 1;
	vg_window.Y := 1;
	vg_window.W := ScreenColumns;
	vg_Window.H := ScreenRows;
end;

{$IF DEFINED(ASCII_SDL)}
Procedure DrawGlyph( img: Char; X,Y: Byte; FG,BG: TSDL_Color );
	{ Draw a character at the requested location with the given foreground and }
	{ background colors. }
var
	MyText: PSDL_Surface;
	MyDest: TSDL_Rect;
begin
	if InWindow( X,Y )  then begin
		MyText := UTF8_TTF_RenderText( Game_Font , img , FG );

		MyDest.X := (LongInt(X) - 1) * CharWidth;
		MyDest.Y := (LongInt(Y) - 1) * CharHeight;
		MyDest.W := CharWidth;
		MyDest.H := CharHeight;
		SDL_FillRect( Game_Screen , @MyDest , SDL_MapRGB( Game_Screen^.Format , BG.r , BG.g , BG.b ) );
		SDL_BlitSurface( MyText , NIL , Game_Screen , @MyDest );

		SDL_FreeSurface( MyText );
	end;
end;

Procedure VWrite( Const S: String );
	{ Write to the screen using Video. }
var
	MyText: PSDL_Surface;
	MyDest: TSDL_Rect;
begin
	if InWindow( VG_X,VG_Y )  then begin
		MyText := UTF8_TTF_RenderText( Game_Font , S , VG_FGColor );

		MyDest.X := (LongInt(VG_X) - 1) * CharWidth;
		MyDest.Y := (LongInt(VG_Y) - 1) * CharHeight;
		MyDest.W := (UTF8StrWidth(S)) * CharWidth;
		MyDest.H := CharHeight;
		SDL_FillRect( Game_Screen , @MyDest , SDL_MapRGB( Game_Screen^.Format , VG_BGColor.r , VG_BGColor.g , VG_BGColor.b ) );
		SDL_BlitSurface( MyText , NIL , Game_Screen , @MyDest );

		SDL_FreeSurface( MyText );
	end;
	VG_X := VG_X + UTF8StrWidth( S );
end;

Procedure VWriteln( Const S: String );
	{ Write to the screen using Video. Move to the next line afterwards. }
begin
	VWrite( S );
	VG_X := vg_window.X;
	Inc( VG_Y );
end;
{$ELSEIF DEFINED(ASCII_NOVIDEOBUF)}
Procedure DrawGlyph( img: Char; X,Y,FG,BG: Byte );
	{ Draw a character at the requested location with the given foreground and }
	{ background colors. }
begin
	if InWindow( X,Y ) then begin
		crt.GotoXY( X, Y );
		crt.TextColor( FG );
		crt.TextBackground( BG );
		system.Write( img );
	end;
end;

Procedure VWrite( Const S: String );
	{ Write to the screen using Video. }
begin
	crt.GotoXY( VG_X, VG_Y );
	crt.TextColor( VG_FGColor );
	crt.TextBackground( VG_BGColor );
	WriteUTF8Str( S );
	VG_X := VG_X + UTF8StrWidth( S );
end;

Procedure VWriteln( Const S: String );
	{ Write to the screen using Video. Move to the next line afterwards. }
begin
	crt.GotoXY( VG_X, VG_Y );
	crt.TextColor( VG_FGColor );
	crt.TextBackground( VG_BGColor );
	WriteUTF8Str( S );
	VG_X := vg_window.X;
	InC( VG_Y );
end;
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
Procedure DrawGlyph( img: Char; X,Y,FG,BG: Byte );
	{ Draw a character at the requested location with the given foreground and }
	{ background colors. }
begin
	if InWindow( X,Y ) then begin
		w32crt.GotoXY( X, Y );
		w32crt.TextColor( FG );
		w32crt.TextBackground( BG );
		w32crt.WriteChar( img );
	end;
end;

Procedure VWrite( Const S: String );
	{ Write to the screen using Video. }
begin
	if InWindow( VG_X,VG_Y ) then begin
		w32crt.GotoXY( VG_X, VG_Y );
		w32crt.TextColor( VG_FGColor );
		w32crt.TextBackground( VG_BGColor );
		w32crt.Write( S );
		VG_X := VG_X + UTF8StrWidth( S );
	end;
end;

Procedure VWriteln( Const S: String );
	{ Write to the screen using Video. Move to the next line afterwards. }
begin
	if InWindow( VG_X,VG_Y ) then begin
		w32crt.GotoXY( VG_X, VG_Y );
		w32crt.TextColor( VG_FGColor );
		w32crt.TextBackground( VG_BGColor );
		w32crt.Write( S );
		VG_X := vg_window.X;
		Inc( VG_Y );
	end;
end;
{$ELSEIF DEFINED(ASCII_UTF8)}
Procedure DrawGlyph( img: Char; X,Y,FG,BG: Byte );
	{ Draw a character at the requested location with the given foreground and }
	{ background colors. }
begin
	if InWindow( X,Y ) then begin
		utf8video.GotoXY( X, Y );
		utf8video.TextColor( FG );
		utf8video.TextBackground( BG );
		utf8video.WriteChar( img );
	end;
end;

Procedure VWrite( Const S: String );
	{ Write to the screen using Video. }
begin
	if InWindow( VG_X,VG_Y ) then begin
		utf8video.GotoXY( VG_X, VG_Y );
		utf8video.TextColor( VG_FGColor );
		utf8video.TextBackground( VG_BGColor );
		utf8video.Write( S );
		VG_X := VG_X + UTF8StrWidth( S );
	end;
end;

Procedure VWriteln( Const S: String );
	{ Write to the screen using Video. Move to the next line afterwards. }
begin
	if InWindow( VG_X,VG_Y ) then begin
		utf8video.GotoXY( VG_X, VG_Y );
		utf8video.TextColor( VG_FGColor );
		utf8video.TextBackground( VG_BGColor );
		utf8video.Write( S );
		VG_X := vg_window.X;
		Inc( VG_Y );
	end;
end;
{$ELSE}
Procedure DrawGlyph( img: Char; X,Y,FG,BG: Byte );
	{ Draw a character at the requested location with the given foreground and }
	{ background colors. }
var
	I: Integer;
begin
	I := ( Y-1 ) * ScreenWidth + X - 1;
	if InWindow( X,Y ) and ( I < VideoBufSize ) then begin
		TextColorBackground( FG , BG );
		VideoBuf^[ I ] := Ord( img )+( VG_Pen shl 8 );
	end;
end;

Procedure VWrite( Const S: String );
	{ Write to the screen using Video. }
Var
	P,I,M : Word;
begin
	P:=((VG_X-1)+(VG_Y-1) * ScreenWidth);
	M:=UTF8StrWidth(S);
	If ( P + M ) > ScreenWidth*ScreenHeight then M:=ScreenWidth*ScreenHeight-P;
	For I:=1 to M do begin
		if InWindow( vg_x , vg_y ) then begin
			VideoBuf^[P+I-1]:=( Ord(S[i]) )+( VG_Pen shl 8 );
		end;
		Inc( vg_X );
	end;
end;

Procedure VWriteln( Const S: String );
	{ Write to the screen using Video. Move to the next line afterwards. }
Var
	P,I,M : Word;
begin
	P:=((VG_X-1)+(VG_Y-1) * ScreenWidth);
	M:=UTF8StrWidth(S);
	If ( P + M ) > ScreenWidth*ScreenHeight then M:=ScreenWidth*ScreenHeight-P;
	For I:=1 to M do begin
		if InWindow( vg_x , vg_y ) then begin
			VideoBuf^[P+I-1]:=Ord(S[i])+( VG_Pen shl 8 );
		end;
		Inc( vg_X );
	end;
	vg_X := vg_window.X;
	InC( vg_y );
end;
{$ENDIF}

Procedure GetNextLine( var TheLine , msg , NextWord: String; Width: Integer );
	{ Get a line of text of maximum width "Width". }
var
	LC: Boolean;	{ Loop Condition. So I wasn't very creative when I named it, so what? }
	CW_UTF8: Boolean;	{Is the current word UTF-8 ?}
	DItS: Boolean;		{Do insert the space, or not.}
	BW: String;
begin
	{ Loop condition starts out as TRUE. }
	LC := True;
	if ( ' ' = TheLine ) then TheLine := '';

	{ Start building the line. }
	repeat
		NextWord := ExtractWordForPrint( Msg, DItS, CW_UTF8 );

		if ( '' <> NextWord ) then begin
			if ( False = CW_UTF8 ) then begin
				if ( UTF8StrWidth( TheLine + ' ' + NextWord) < Width ) then
					if DItS then TheLine := TheLine + ' ' + NextWord
					else TheLine := TheLine + NextWord
				else
					LC := False;
			end else begin
				if ( UTF8StrWidth( TheLine + NextWord + ' ' + ' ') < Width ) then
					if DItS then TheLine := TheLine + ' ' + NextWord
					else TheLine := TheLine + NextWord
				else begin
					LC := False;

					if ( 0 < Pos(NextWord, ProhibitationHead) ) then begin
						TheLine := TheLine + NextWord + #13;
					end else begin
						BW := TailUTF8Char(TheLine);
						if (0 < Length(BW)) and (0 < Pos(BW, ProhibitationTrail)) then begin
							TheLine := Copy(TheLine,1,Length(TheLine)-Length(BW));
							NextWord := BW + NextWord;
						end;
					end;
				end;
			end;
		end;
	until (not LC) or (NextWord = '') or ( (0 < Length(TheLine)) and (TheLine[Length(TheLine)] = #13) );

	{ If the line ended due to a line break, deal with it. }
	if ( (0 < Length(TheLine)) and (TheLine[Length(TheLine)] = #13) ) then begin
		{ Display the line break as a space. }
		TheLine[Length(TheLine)] := ' ';
		NextWord := ExtractWordForPrint( Msg, DItS, CW_UTF8 );
	end;
end;

{$IFDEF ASCII_SDL}
Procedure GameMSG( msg: string; Z: vgfx_rect; C: TSDL_Color );
{$ELSE ASCII_SDL}
Procedure GameMSG( msg: string; Z: vgfx_rect; C: Byte );
{$ENDIF ASCII_SDL}
	{Prettyprint the string MSG with color C in screen zone Z.}
var
	NextWord: String;
	THELine: String;	{The line under construction.}
	LC: Boolean;		{Loop Condition.}
	CW_UTF8: Boolean;	{Is the current word UTF-8 ?}
	DItS: Boolean;		{Do insert the space, or not.}
	BW: String;
begin
	{ CLean up the message a bit. }
	DeleteWhiteSpace( msg );
	TextColorBackground( C , Black );
	THELine := '';

	{Clear the message area, and set clipping bounds.}
	ClrZone( Z );
	ClipZone( Z );

	{Start the main processing loop.}
	repeat
		{Set the LoopCondition to True.}
		LC := True;

		{ Start building the line. }
		repeat
			NextWord := ExtractWordForPrint( Msg, DItS, CW_UTF8 );

			if '' <> NextWord then begin
				if False = CW_UTF8 then begin
					if UTF8StrWidth(THEline + ' ' + NextWord) < Z.W then
						if DItS then TheLine := TheLine + ' ' + NextWord
						else TheLine := TheLine + NextWord
					else
						LC := False;
				end else begin
					if UTF8StrWidth(THEline + NextWord + ' ') < Z.W then
						if DItS then TheLine := TheLine + ' ' + NextWord
						else TheLine := TheLine + NextWord
					else begin
						LC := False;

						if Pos(NextWord, ProhibitationHead) > 0 then begin
							TheLine := TheLine + NextWord + #13;
						end else begin
							BW := TailUTF8Char(TheLine);
							if (0 < Length(BW)) and (0 < Pos(BW, ProhibitationTrail)) then begin
								TheLine := Copy(TheLine,1,Length(TheLine)-Length(BW));
								NextWord := BW + NextWord;
							end;
						end;
					end;
				end;
			end;

		until (not LC) or (NextWord = '') or ( (0 < Length(TheLine)) and (TheLine[Length(TheLine)] = #13) );

		{ If the line ended due to a line break, deal with it. }
		if ( (0 < Length(TheLine)) and (TheLine[Length(TheLine)] = #13) ) then begin
			{ Display the line break as a space. }
			TheLine[Length(TheLine)] := ' ';
			NextWord := ExtractWordForPrint( msg, DItS, CW_UTF8 );
		end;

		{ Output the line. }
		if NextWord = '' then begin
			VWrite(THELine);
		end else begin
			VWriteLn(THELine);
		end;

		{ Prepare for the next iteration. }
		TheLine := NextWord;
	until ('' = TheLine);

	{Restore the clip window to its maximum size.}
	MaxClipZone;
end;

{$IFDEF ASCII_SDL}
Procedure GameMSG( msg: string; Z: vgfx_zone; C: TSDL_Color );
{$ELSE ASCII_SDL}
Procedure GameMSG( msg: string; Z: vgfx_zone; C: Byte );
{$ENDIF ASCII_SDL}
	{ Convert the zone to a rect and send it to the above procedure. }
begin
	GameMsg( msg , Z.GetRect() , C );
end;

{$IFDEF ASCII_SDL}
Procedure CMessage( const msg: String; Z: VGFX_Rect; C: TSDL_Color );
	{ Display MSG centered in zone Z. }
var
	X,Y: Integer;
begin
	{ Figure out the coordinates for centered display. }
	X := Z.X + ( Z.W div 2 ) - ( UTF8StrWidth( msg ) div 2 );
	Y := Z.Y + Z.H div 2;

	{ Actually do the output. }
	ClrZone( Z );
	ClipZone( Z );
	if X < 1 then X := 1;
	if Y < 1 then Y := 1;
	VGotoXY( X , Y );
	TextColor( C );
	VWrite(msg);
	MaxClipZone;
end;
{$ELSE ASCII_SDL}
Procedure CMessage( const msg: String; Z: VGFX_Rect; C: Byte );
	{ Display MSG centered in zone Z. }
var
	X,Y: Integer;
begin
	{ Figure out the coordinates for centered display. }
	X := Z.X + ( Z.W div 2 ) - ( UTF8StrWidth( msg ) div 2 );
	Y := Z.Y + Z.H div 2;

	{ Actually do the output. }
	ClrZone( Z );
	ClipZone( Z );
	if X < 1 then X := 1;
	if Y < 1 then Y := 1;
	VGotoXY( X , Y );
	TextColor( C );
	VWrite(msg);
	MaxClipZone;
end;
{$ENDIF ASCII_SDL}

{$IFDEF ASCII_SDL}
Procedure CMessage( const msg: String; Z: VGFX_Zone; C: TSDL_Color );
{$ELSE ASCII_SDL}
Procedure CMessage( const msg: String; Z: VGFX_Zone; C: Byte );
{$ENDIF ASCII_SDL}
	{ Convert the zone to a rect, and print the message. }
begin
	CMessage( msg , Z.GetRect() , C );
end;

Procedure RedrawConsole;
	{ Draw the console to the screen. }
var
	CH_tmp: SAttListPtr;
	SL: SAttListElementPtr;
	msg: String;
	NextWord: String;
	TheLine: String;
	T: Integer;
	N: Integer;
begin
	TextColorBackground( Green , Black );
	ClipZone( ZONE_Console.GetRect() );

	CH_tmp := CreateSAttList;

	SL := RetrieveSAttList( Console_History , NumSAttList( Console_History ) - ZONE_Console.H + 1 );
	if ( NIL = SL ) then begin
		SL := Console_History^.head;
	end;
	while ( NIL <> SL ) do begin
		msg := SL^.Info;
		TheLine := '';
		NextWord := '';
		repeat
			GetNextLine( TheLine , msg , NextWord , ZONE_Console.W );
			if ( '' <> TheLine ) then begin
				StoreSAttList( CH_tmp , TheLine );
			end;
			TheLine := NextWord;
		until ( '' = TheLine );
		SL := SL^.Next;
	end;

	N := NumSAttList( CH_tmp );
	for t := 1 to ZONE_Console.H do begin
		if ( t + N - ZONE_Console.H ) > 0 then begin
			VWriteLn( RetrieveSAttList( CH_tmp , ( t + N - ZONE_Console.H ) )^.Info );
		end else begin
			VWriteLn( ' ' );
		end;
	end;

	DisposeSAttList( CH_tmp );

	MaxClipZone;
end;

Procedure DialogMsg(msg: string); {not const-able}
	{ Print a message in the scrolling dialog box. }
begin
	{ CLean up the message a bit. }
	DeleteWhiteSpace( msg );
	msg := '> ' + msg;

	if ( Console_History_Length <= NumSAttList( Console_History ) ) then begin
		RemoveSAttList( Console_History , Console_History^.head );
	end;
	StoreSAttList( Console_History , msg );

	{ Redraw the dialog area. }
	RedrawConsole;
end;

Procedure MoreTextRedraw;
begin
end;
Procedure MoreText( LList: SAttListPtr; FirstLine: Integer );
	{ Browse this text file across the majority of the screen. }
	{ Clear the screen upon exiting, though restoration of the }
	{ previous display is someone else's responsibility. }
var
	MT_tmp: SAttListPtr;

	Procedure DisplayTextHere;
	var
		CLine: SAttListElementPtr;	{ Current Line }
		trimedlength_limit: integer;
		trimedlength: integer;
	begin
		{ Error check. }
		if ( -1 = FirstLine ) then begin
			FirstLine := NumSAttList( MT_tmp ) - ZONE_MoreText.H + 2;
		end;
		if ( FirstLine < 1 ) then begin
			FirstLine := 1
		end else if ( NumSAttList( MT_tmp ) < FirstLine ) then begin
			FirstLine := NumSAttList( MT_tmp );
		end;

		VGotoXY( 1 , 1 );

		CLine := RetrieveSAttList( MT_tmp , FirstLine );
{$IFDEF ASCII_MSWINGUI}
		while ( VG_Y < ( ScreenRows - 1 ) ) do begin
{$ELSE ASCII_MSWINGUI}
		while ( VG_Y < ( ScreenHeight - 1 ) ) do begin
{$ENDIF ASCII_MSWINGUI}
			VClrEOL;
			if CLine <> Nil then begin
{$IFDEF ASCII_MSWINGUI}
				trimedlength_limit := ScreenColumns - 1;
{$ELSE ASCII_MSWINGUI}
				trimedlength_limit := ScreenWidth - 1;
{$ENDIF ASCII_MSWINGUI}
				trimedlength := MBCharTrimedLength( CLine^.Info , trimedlength_limit );
				if (0 < trimedlength) then begin
					VWriteln( Copy( CLine^.Info , 1 , trimedlength ) );
				end;
				CLine := CLine^.Next;
			end else begin
				vwriteln( '' );
			end;
		end;
		DoFlip;
	end;
var
	A: Char;
	msg: String;
	NextWord: String;
	TheLine: String;
	cont: Boolean;
	stored: Boolean;
	RPM: RPGMenuPtr;
	t, t_max: Integer;
	CLine: SAttListElementPtr;	{ Current Line }
begin
	ClrScreen;
{$IFDEF ASCII_MSWINGUI}
	VGotoXY( 1 , ScreenRows );
{$ELSE ASCII_MSWINGUI}
	VGotoXY( 1 , ScreenHeight );
{$ENDIF ASCII_MSWINGUI}
	TextColorBackground( LightGreen , Black );
	VWrite( MsgString( 'MORETEXT_Prompt' ) );

	if ASCII_Show_MenuScrollbar then begin
		RPM := CreateRPGMenu( LightGray , MenuSelect , @ZONE_MoreText );
		CLine := RetrieveSAttList( LList , 1 );
		t_max := NumSAttList( LList );
		for t := 1 to t_max do begin
			msg := CLine^.Info;
			TheLine := '';
			NextWord := '';
			cont := false;
			stored := false;
			repeat
				GetNextLine( TheLine , msg , NextWord , ZONE_MoreText.W );
				if ('' <> TheLine) then begin
					if cont then begin
						AddRPGMenuItem( RPM , #$0 + TheLine , SELECTMENU_Cancel );
					end else begin
						AddRPGMenuItem( RPM , TheLine , SELECTMENU_Cancel );
						cont := true;
					end;
					stored := true;
				end;
				TheLine := NextWord;
			until ('' = TheLine);
			if not stored then begin
				AddRPGMenuItem( RPM , '' , SELECTMENU_Cancel );
			end;
			CLine := CLine^.Next;
		end;
		if ( -1 = FirstLine ) then begin
			FirstLine := RPM^.NumItem - ZONE_MoreText.H + 1;
		end;
		if ( FirstLine < 1 ) then begin
			FirstLine := 1
		end else if ( RPM^.NumItem < FirstLine ) then begin
			FirstLine := RPM^.NumItem;
		end;
		RPM^.TopItem := FirstLine;
		SetItemByPosition( RPM, FirstLine );
		SelectMenu( RPM , @MoreTextRedraw );
		DisposeRPGMenu( RPM );
	end else begin
		MT_tmp := CreateSAttList;
		CLine := LList^.head;
		while ( NIL <> CLine ) do begin
			msg := CLine^.Info;
			TheLine := '';
			NextWord := '';
			stored := false;
			repeat
				GetNextLine( TheLine , msg , NextWord , ZONE_MoreText.W );
				if ( '' <> TheLine ) then begin
					StoreSAttList( MT_tmp , TheLine );
					stored := true;
				end;
				TheLine := NextWord;
			until ( '' = TheLine );
			if not stored then begin
				StoreSAttList( MT_tmp , '' );
			end;
			CLine := CLine^.Next;
		end;

		{ Display the screen. }
		TextColor( LightGray );
		DisplayTextHere;

		repeat
			{ Get input from user. }
			A := RPGKeyEvent;

			{ Possibly process this input. }
			if (KBD_NONE = A) then begin
			end else if (A = KeyMap[ KMC_MenuDown ].KCode) then begin
				Inc( FirstLine );
				DisplayTextHere;
			end else if (A = KeyMap[ KMC_MenuUp ].KCode) then begin
				Dec( FirstLine );
				DisplayTextHere;
			end;

		until ( KBD_ESC = A ) or ( 'Q' = A );

		DisposeSAttList( MT_tmp );
	end;

	{ CLear the display area. }
	ClrScreen;
end;

Function GetStringFromUser( const Prompt: String; const DefaultSearchPattern: String; ReDrawer: RedrawProcedureType_with_GearPtr; M: GearPtr ): String;
var
	Dummy: Boolean;
begin
	GetStringFromUser := GetStringFromUser( Prompt , DefaultSearchPattern , ReDrawer , M , Dummy );
end;

Function GetStringFromUser( const Prompt: String; const DefaultSearchPattern: String; ReDrawer: RedrawProcedureType_with_GearPtr; M: GearPtr; var Cancelled: Boolean ): String;
	{ Does what it says. }
const
	MaxInputWidth = 39;
	WCLen = 16;
var
	A: Char;
	it: String;
{$IF DEFINED(ASCII_SDL)}
	SZ: TSDL_Rect;
{$ELSE DEFINED(ASCII_SDL)}
{$ENDIF DEFINED(ASCII_SDL)}
	Unicode: Word;
	work_dst: Array[0..WCLen] of Char;
	work_pdst: PChar;
	state: ShortInt = 0;
	mbchar_work: String = '';
begin
	{ Initialize string. }
	it := DefaultSearchPattern;
	Cancelled := False;

	if ( NIL <> ReDrawer ) then ReDrawer( M );
	InfoBox( ZONE_TextInputFull );

{$IF DEFINED(ASCII_SDL)}
	repeat
		{ Set up the display. }
		GameMSG( Prompt , ZONE_TextInputPrompt , White );
		CMessage( it , ZONE_TextInput , Green );
		TextColor( LightGreen );

		SZ.X := (LongInt(VG_X) - 1) * CharWidth;
		SZ.Y := (LongInt(VG_Y) - 1) * CharHeight;
		SZ.W := CharWidth;
		SZ.H := CharHeight;
		SDL_FillRect( Game_Screen , @SZ , SDL_MapRGB( Game_Screen^.Format , 255 , 255 , 255 ) );

		DoFlip;
		A := RawKey( Unicode );

		if (0 < Unicode) then begin
			work_pdst := work_dst;
			UnicodeToUtf8( work_dst, WCLen, @Unicode, 2 );
			A := EditUTF8CharStr( it, 127, MaxInputWidth, #0, work_pdst, state, mbchar_work );
		end else begin
			A := EditUTF8CharStr( it, 127, MaxInputWidth, A, NIL, state, mbchar_work );
		end;
	until ( A = #10 ) or ( A = #13 ) or ( A = #27 );

	if ( #27 = A ) then begin
		Cancelled := True;
	end;
{$ELSEIF DEFINED(ASCII_NOVIDEOBUF)}
	{ Give us a nice blinky cursor, please. }
	// SetCursorType( crBlock );

	repeat
		{ Set up the display. }
		GameMSG( Prompt , ZONE_TextInputPrompt , White );
		CMessage( it , ZONE_TextInput , Green );
		TextColor( LightGreen );

		SetCursorPos( VG_X - 1 , VG_Y - 1 );

		DoFlip;

		GotoXY( VG_X, VG_Y );
		CursorOn;
		A := RawKey( Unicode );

		if (0 < Unicode) then begin
			work_pdst := work_dst;
			UnicodeToUtf8( work_dst, WCLen, @Unicode, 2 );
			A := EditUTF8CharStr( it, 127, MaxInputWidth, #0, work_pdst, state, mbchar_work );
		end else begin
			A := EditUTF8CharStr( it, 127, MaxInputWidth, A, NIL, state, mbchar_work );
		end;
	until ( A = #10 ) or ( A = #13 ) or ( A = #27 );

	{ Get rid of the cursor, again. }
	SetCursorType( crHidden );

	if ( #27 = A ) then begin
		Cancelled := True;
	end;
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
	{ Set up the display. }
	GameMSG( Prompt , ZONE_TextInputPrompt , White );

	w32crt.CursorOn;
	w32crt.TextColor( LightGreen );
	w32crt.GotoXY( ZONE_TextInput.X, ZONE_TextInput.Y );

	w32crt.RedrawScreen;

	w32crt.Window( ZONE_TextInput.X, ZONE_TextInput.Y , (ZONE_TextInput.X + ZONE_TextInput.W - 1), (ZONE_TextInput.Y + ZONE_TextInput.H - 1) );
	it := w32crt.GetLine( it , Cancelled );
	w32crt.Window( 1, 1, ScreenColumns, ScreenRows );

	w32crt.CursorOff;
{$ELSE}
	{ Give us a nice blinky cursor, please. }
	SetCursorType( crBlock );

	repeat
		{ Set up the display. }
		GameMSG( Prompt , ZONE_TextInputPrompt , White );
		CMessage( it , ZONE_TextInput , Green );
		TextColor( LightGreen );

		SetCursorPos( VG_X - 1 , VG_Y - 1 );

		DoFlip;
      {$IFDEF ASCII_UTF8}
		utf8video.GotoXY( VG_X, VG_Y );
		A := RawKey( Unicode );
      {$ELSE ASCII_UTF8}
		A := RawKey( Unicode );
      {$ENDIF ASCII_UTF8}

		if (0 < Unicode) then begin
			work_pdst := work_dst;
			UnicodeToUtf8( work_dst, WCLen, @Unicode, 2 );
			A := EditUTF8CharStr( it, 127, MaxInputWidth, #0, work_pdst, state, mbchar_work );
		end else begin
			A := EditUTF8CharStr( it, 127, MaxInputWidth, A, NIL, state, mbchar_work );
		end;
	until ( A = #10 ) or ( A = #13 ) or ( A = #27 );

	{ Get rid of the cursor, again. }
	SetCursorType( crHidden );

	if ( #27 = A ) then begin
		Cancelled := True;
	end;
{$ENDIF}
	GetStringFromUser := it;
end;

Procedure SetupMemoDisplay;
	{ Draw a border for the memo browser. }
begin
	InfoBox( ZONE_MemoText );
	InfoBox( ZONE_MemoMenu );
end;

Procedure DrawBPBorder;
	{ Draw the backpack border. }
begin
	InfoBox( ZONE_EqpMenu );
	InfoBox( ZONE_InvMenu );
	InfoBox( ZONE_BackpackInstructions );
	InfoBox( ZONE_ItemsInfo );
	InfoBox( ZONE_ItemsPCInfo );
end;

Procedure SetupFHQDisplay;
	{ Draw the backpack border. }
begin
	InfoBox( ZONE_FieldHQMenu );
	InfoBox( ZONE_BackpackInstructions );
	InfoBox( ZONE_ItemsInfo );
	InfoBox( ZONE_ItemsPCInfo );
end;


Procedure DrawGetItemBorder;
	{ Draw the get items border. }
begin
	InfoBox( ZONE_GetItemMenu );
end;

{$IFDEF ASCII_SDL}
Procedure SetupInteractDisplay( C: TSDL_Color );
{$ELSE ASCII_SDL}
Procedure SetupInteractDisplay( C: Byte );
{$ENDIF ASCII_SDL}
	{ Draw the backpack border. }
begin
	ClrZone( ZONE_InteractTotal.GetRect() );
	InfoBox( ZONE_InteractTotal );
end;

Procedure SetupServicesDisplay;
	{ Draw the display for the services interface. }
begin
	InfoBox( ZONE_ShopCaption );
	InfoBox( ZONE_ShopMsg );
	InfoBox( ZONE_ShopMenu );
	InfoBox( ZONE_ItemsInfo );
	InfoBox( ZONE_ItemsPCInfo );
end;

Procedure InfoBox( MyDest: VGFX_Rect );
	{ Draw a box around the specified location. }
var
	X,Y: Integer;
begin
	ClrZone( MyDest );

	if MyDest.X > 0 then Dec( MyDest.X );
	if MyDest.Y > 0 then Dec( MyDest.Y );
	MyDest.W := MyDest.W + 2;
	MyDest.H := MyDest.H + 2;
	for X := ( MyDest.X + 1 ) to ( MyDest.X + MyDest.W - 2 ) do begin
		DrawGlyph( '-' , X , MyDest.Y , BorderBlue , StdBlack );
		DrawGlyph( '-' , X , MyDest.Y + MyDest.H - 1 , BorderBlue , StdBlack );
	end;
	for y := ( MyDest.Y + 1 ) to ( MyDest.Y + MyDest.H - 2 ) do begin
		DrawGlyph( '|' , MyDest.X , Y , BorderBlue , StdBlack );
		DrawGlyph( '|' , MyDest.X + MyDest.W - 1 , Y , BorderBlue , StdBlack );
	end;
	DrawGlyph( '+' , MyDest.X , MyDest.Y , BorderBlue , StdBlack );
	DrawGlyph( '+' , MyDest.X + MyDest.W - 1 , MyDest.Y , BorderBlue , StdBlack );
	DrawGlyph( '+' , MyDest.X + MyDest.W - 1 , MyDest.Y + MyDest.H - 1 , BorderBlue , StdBlack );
	DrawGlyph( '+' , MyDest.X , MyDest.Y + MyDest.H - 1 , BorderBlue , StdBlack );
end;

Procedure InfoBox( Z: VGFX_Zone );
	{ Draw a box around the specified location. }
var
	MyDest: VGFX_Rect;
begin
	MyDest := Z.GetRect();
	InfoBox( MyDest );
end;

Procedure ClockBorder;
	{ Draw the setup for the clock. }
var
	MyDest: VGFX_Rect;
begin
	MyDest := ZONE_Clock.GetRect();
	DrawGlyph( '[' , MyDest.X - 1 , MyDest.Y , BorderBlue , Black );
	DrawGlyph( ']' , MyDest.X + MyDest.W , MyDest.Y , BorderBlue , Black );
end;

Procedure SetupArenaDisplay;
	{ Setup the borders for the menus. }
begin
	ClrScreen;
	InfoBox( ZONE_ArenaInfo );
	InfoBox( ZONE_ArenaPilotMenu );
	InfoBox( ZONE_ArenaMechaMenu );
	InfoBox( ZONE_PCStatus );
	RedrawConsole;
end;

Procedure SetupArenaMissionMenu;
	{ This sets up the select arena mission menu. }
begin
	InfoBox( ZONE_SAMText );
	InfoBox( ZONE_SAMMenu );
end;

Procedure SetupConcertDisplay;
	{ Set up the concert display. }
begin
	InfoBox( ZONE_ConcertAudience );
	InfoBox( ZONE_ConcertCaption );
	InfoBox( ZONE_ConcertMenu );
	InfoBox( ZONE_ConcertDesc );
end;

Procedure SetupTitleScreenDisplay;
	{ Set up the concert display. }
begin
	ClrScreen;
	InfoBox( ZONE_Title_Screen_Top );
	InfoBox( ZONE_Title_Screen_Menu );
	CMessage( 'GearHead II' , ZONE_Title_Screen_Title , StdWhite );
end;


{$IFDEF ASCII_SDL}
Function SearchAndOpenFont( const FontInfo: PFontSearchNameDesc; arg_ptsize: integer ): PTTF_Font;
const
	TmpLen = 255;
var
	i, j: Integer;
	FontFile: String;
	tmp: array[0..TmpLen] of Char;
	ptsize: Integer;
begin
	SearchAndOpenFont := NIL;
	for j := 0 to (MaxFontSearchNameNum-1) do begin
		for i := 1 to MaxFontSearchDirNum do begin
			if 0 < Length(FontSearchDir[i]) then begin
				FontFile := FontSearchDir[i] + OS_Dir_Separator + FontInfo[j].FontFile;
			end else begin
				FontFile := FontInfo[j].FontFile;
			end;
			ptsize := arg_ptsize;
			if ptsize <= 0 then begin
				ptsize := FontInfo[j].FontSize;
			end;
			if 0 < Length(FontInfo[j].FontFile) then begin
				StrPCopy( tmp, FontFile );
{$IFDEF DEBUG}
				ErrorMessage_fork( '[Name:' + BStr(j) + ';Dir:' + BStr(i) + ']=' + FontFile );
{$ENDIF DEBUG}
				SearchAndOpenFont := TTF_OpenFontIndex( @tmp, ptsize, FontInfo[j].FontFace );
				if (NIL <> SearchAndOpenFont) then
					break;
			end;
		end;
		if (NIL <> SearchAndOpenFont) then
			break;
	end;
end;

Procedure InitVideoEmu;
var
	pmsg: PChar;	{ Gotta convert to pchar, pain in the ass... }
	W: LongInt;
begin
	ASCII_Width_Of_One_Character := UTF8_Settings('SDLGFX_ASCII_WIDTH_OF_ONE_CHARACTER','M');
	UTF8_Width_Of_One_Character := UTF8_Settings('SDLGFX_UTF8_WIDTH_OF_ONE_CHARACTER','M');
	ScreenWidth  := ScreenColumns;
	ScreenHeight := ScreenRows;
	Game_FontSize := FontSize_Big;

	SDL_Init( SDL_INIT_VIDEO or SDL_INIT_TIMER or SDL_INIT_AUDIO );

        SDL_EnableUNICODE( 1 );
	SDL_EnableKeyRepeat( KEY_REPEAT_DELAY , KEY_REPEAT_INTERVAL );

	TTF_Init;

	Game_Font := SearchAndOpenFont( @FontSearchName_Big , Game_FontSize );

	Mix_OpenAudio( MIX_DEFAULT_FREQUENCY , MIX_DEFAULT_FORMAT , 2 , 4096 );
	Mix_AllocateChannels( 16 );
	Load_SoundEffect;

	pmsg := QuickPCopy( ASCII_Width_Of_One_Character );
	TTF_SizeUTF8( Game_Font , pmsg , CharWidth , CharHeight );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
	sysutils.StrDispose( pmsg );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
	CharWidth := ( CharWidth div UTF8StrWidth( ASCII_Width_Of_One_Character ) );

	pmsg := QuickPCopy( UTF8_Width_Of_One_Character );
	TTF_SizeUTF8( Game_Font , pmsg , W , CharHeight );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
	sysutils.StrDispose( pmsg );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
	W := ( W div UTF8StrWidth( UTF8_Width_Of_One_Character ) );
	if ( CharWidth < W ) then begin
		CharWidth := W;
	end;

	Game_Screen := SDL_SetVideoMode( ScreenWidth * CharWidth, ScreenHeight * CharHeight, 0, SDL_DOUBLEBUF );

	ClrScreen;
end;
{$ELSE ASCII_SDL}
{$ENDIF ASCII_SDL}


Procedure Preset_SIZE;
	Procedure Default_ZoneToRect( var Z: VGFX_Zone );
	begin
		Z.W := Z.W_Default;
		Z.H := Z.H_Default;
		case Z.X_Anchor of
			ANC_Low:	Z.X := 0;
			ANC_Mid:	Z.X := ( Default_ScreenColumns - 1 ) div 2;
			ANC_High:	Z.X := ( Default_ScreenColumns - 1 );
		end;
		Z.X := Z.X + Z.X_Justify;
		case Z.Y_Anchor of
			ANC_Low:	Z.Y := 0;
			ANC_Mid:	Z.Y := ( Default_ScreenRows - 1 ) div 2;
			ANC_High:	Z.Y := ( Default_ScreenRows - 1 );
		end;
		Z.Y := Z.Y + Z.Y_Justify;
	end;

	Procedure Set_VIDrect( var Z: vgfx_zone );
	begin
		Default_ZoneToRect( Z );
		Z.X := Z.X * ScreenColumns div Default_ScreenColumns + 1;
		Z.W := Z.W * ScreenColumns div Default_ScreenColumns;
		Z.Y := Z.Y * ScreenRows    div Default_ScreenRows + 1;
		Z.H := Z.H * ScreenRows    div Default_ScreenRows;
	end;
begin
	Set_VIDrect( ZONE_Console );
	Set_VIDrect( ZONE_Map );
	Set_VIDrect( ZONE_CharGenMenu );
	Set_VIDrect( ZONE_CharGenPrompt );
	Set_VIDrect( ZONE_CharGenCaption );
	Set_VIDrect( ZONE_CharGenDesc );
	Set_VIDrect( ZONE_CharGenChar );
	Set_VIDrect( ZONE_Caption );
	Set_VIDrect( ZONE_Info );
	Set_VIDrect( ZONE_Menu );
	Set_VIDrect( ZONE_Menu1 );
	Set_VIDrect( ZONE_Menu2 );
	Set_VIDrect( ZONE_SubCaption );
	Set_VIDrect( ZONE_Clock );
	Set_VIDrect( ZONE_CharViewChar );
	Set_VIDrect( ZONE_CharViewMenu );
	Set_VIDrect( ZONE_CharViewDesc );
	Set_VIDrect( ZONE_GetItemMenu );
	Set_VIDrect( ZONE_ShopCaption );
	Set_VIDrect( ZONE_ShopMsg );
	Set_VIDrect( ZONE_ShopMenu );
	Set_VIDrect( ZONE_ShopInfo );
	Set_VIDrect( ZONE_ItemsInfo );
	Set_VIDrect( ZONE_ItemsPCInfo );
	Set_VIDrect( ZONE_EqpMenu );
	Set_VIDrect( ZONE_InvMenu );
	Set_VIDrect( ZONE_BackpackInstructions );
	Set_VIDrect( ZONE_FieldHQMenu );
	Set_VIDrect( ZONE_MoreText );
	Set_VIDrect( ZONE_InteractName );
	Set_VIDrect( ZONE_InteractStatus );
	Set_VIDrect( ZONE_InteractMsg );
	Set_VIDrect( ZONE_InteractMenu );
	Set_VIDrect( ZONE_InteractTotal );
	Set_VIDrect( ZONE_MemoText );
	Set_VIDrect( ZONE_MemoMenu );
	Set_VIDrect( ZONE_SAMText );
	Set_VIDrect( ZONE_SAMMenu );
	Set_VIDrect( ZONE_UsagePrompt );
	Set_VIDrect( ZONE_UsageMenu );
	Set_VIDrect( ZONE_RightInfo );
	Set_VIDrect( ZONE_LeftInfo );
	{ Set_VIDrect( ZONE_WorldMap ); } Default_ZoneToRect( ZONE_WorldMap );
	Set_VIDrect( ZONE_MonologueInfo );
	Set_VIDrect( ZONE_MonologueText );
	Set_VIDrect( ZONE_ArenaPilotMenu );
	Set_VIDrect( ZONE_ArenaMechaMenu );
	Set_VIDrect( ZONE_ArenaInfo );
	Set_VIDrect( ZONE_PCStatus );
	Set_VIDrect( ZONE_Dialog );
	Set_VIDrect( ZONE_ConcertAudience );
	Set_VIDrect( ZONE_ConcertCaption );
	Set_VIDrect( ZONE_ConcertMenu );
	Set_VIDrect( ZONE_ConcertDesc );
	Set_VIDrect( ZONE_Title_Screen_Top );
	Set_VIDrect( ZONE_Title_Screen_Title );
	Set_VIDrect( ZONE_Title_Screen_Version );
	Set_VIDrect( ZONE_Title_Screen_Menu );
	Set_VIDrect( ZONE_TextInputFull );
	Set_VIDrect( ZONE_TextInputPrompt );
	Set_VIDrect( ZONE_TextInput );
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: vidgfx.pp');
{$ENDIF DEBUG}
	Preset_SIZE;
{$IF DEFINED(ASCII_SDL)}
	InitVideoEmu;
{$ELSEIF DEFINED(ASCII_NOVIDEOBUF)}
	CalcPen;
	SetCursorType( crHidden );
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
	CalcPen;
	w32crt.CrtInit( ScreenColumns, ScreenRows );
	w32crt.CursorOff;
	w32crt.ClrScr;
{$ELSEIF DEFINED(ASCII_UTF8)}
	InitVideo;
	InitKeyboard;
	CalcPen;
	NormMode.Col := ScreenColumns;
	NormMode.Row := ScreenRows;
	SetVideoMode( NormMode );
	SetCursorType( crHidden );
	utf8video.CrtInit( ScreenColumns, ScreenRows );
	utf8video.NormVideo;
	crt.CursorOff;
	utf8video.ClrScr;
{$ELSE}
	InitVideo;
	InitKeyboard;
	CalcPen;
	NormMode.Col := ScreenColumns;
	NormMode.Row := ScreenRows;
	SetVideoMode( NormMode );
	SetCursorType( crHidden );
{$ENDIF}

	Console_History := CreateSAttList;


	ZONE_Console.W := ScreenColumns;

	ZONE_MoreText.W := ScreenColumns;
	ZONE_MoreText.H := ScreenRows - 1;

	ZONE_RightInfo := ZONE_Menu1;
	ZONE_LeftInfo := ZONE_Menu2;
	ZONE_Caption := ZONE_Info;
	ZONE_SubCaption := ZONE_Clock;
	ZONE_Dialog := ZONE_PCStatus;

	ZONE_CharGenMenu := ZONE_Menu1;
	ZONE_CharGenCaption := ZONE_Menu2;
	ZONE_CharGenPrompt := ZONE_Info;
end;

finalization
begin
{$IFNDEF ASCII}
	ClrScreen;
	DoFlip;
{$ENDIF}
{$IF DEFINED(ASCII_SDL)}
	TTF_CloseFont( Game_Font );
	TTF_Quit;
	SDL_FreeSurface( Game_Screen );
	Dispose_SoundEffect;
	Mix_CloseAudio;
	SDL_Quit;
{$ELSEIF DEFINED(ASCII_NOVIDEOBUF)}
	DoneVideo;
	DoneKeyboard;
	crt.NormVideo;
	crt.ClrScr;
	crt.CursorOn;
{$ELSEIF DEFINED(ASCII_MSWINGUI)}
	w32crt.NormVideo;
	w32crt.ClrScr;
	w32crt.CursorOn;
	w32crt.DisposeWindow;
{$ELSEIF DEFINED(ASCII_UTF8)}
	utf8video.NormVideo;
	utf8video.ClrScr;
	crt.CursorOn;
	utf8video.DisposeWindow;
	DoneVideo;
	DoneKeyboard;
{$ELSE}
	DoneVideo;
	DoneKeyboard;
{$ENDIF}

	DisposeSAttList( Console_History );
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: vidgfx.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
