{$IF DEFINED(WINDOWS)}
unit w32eb;
{GearHead W32 EditBox}
{$LONGSTRINGS ON}


interface

uses sysutils,windows;

Function EditBox( const X, Y, W, H: LongInt; const title, Init_text: String; var canceled: Boolean ): String;

implementation

uses strings,
	errmsg,
	texutil,
	imm,w32;

const
	mywcname = 'GHEditDialog'#0;
	MaxTextBuf = 255;

var
	myhwSDL: Windows.HWND;
	myhinst: Windows.HINST;
	mydlg: Windows.HWND;
	dlgTitle: Windows.HWND;
	dlgEdit: Windows.HWND;
	Org_edit: Windows.WNDPROC;
	myfont: Windows.HFONT;
	eb_textbuf: array[0..MaxTextBuf] of Char;
	eb_canceled: Boolean;
	bIMEMode: Boolean = False;
	dw : LongInt = 440;
	dh : LongInt = 56;
	bw : LongInt = 10;
	th : LongInt = 30;
	hbBorderBlue: Windows.HBRUSH;


Function myTextHeight( hw: Windows.HWND ): LongInt;
var
	hd: Windows.HDC;
	sz: Windows.SIZE;
begin
	hd := Windows.GetDC( hw );
	Windows.GetTextExtentPoint32( hd, 'My'#0, 2, sz );
	Windows.ReleaseDC( hw, hd );
	myTextHeight := sz.cy;
end;

Function myWndPos( myhwnd: Windows.HWND ): Windows.RECT;
var
	wp: Windows.WINDOWPLACEMENT;
	msg: String;
	pmsg: PChar;
begin
	wp.length := sizeof(wp);
	if Windows.GetWindowPlacement( myhwnd, wp ) = False then begin
		msg := 'Windows.GetWindowPlacement() failed.';
		pmsg := QuickPCopy(msg);
		Windows.MessageBox( 0, pmsg, 'Sorry'#0, MB_OK );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
		sysutils.StrDispose( pmsg );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
	end;
	myWndPos := wp.rcNormalPosition;
end;

Function EditProc( myhwnd: Windows.HWND; msg: UINT; wp: Windows.WPARAM; lp: Windows.LPARAM ): Windows.LRESULT; StdCall;
var
	c: Char;
	i,j: Integer;
	state: Integer;
	buf: String;
begin
	Case msg of
	    Windows.WM_CHAR:
		begin
			c := Chr( wp );
			if #$15 = c then begin
				Windows.SetWindowText( dlgEdit, ''#0 );
				exit(0);
			end else if (c <= #$1F) or (#$7F <= c) then begin
			end else if not TextISO646_AllowableCheck(c) then begin
				exit(0);
			end;
		end;

	    Windows.WM_KEYDOWN:
		begin
			if (wp = Windows.VK_ESCAPE) then begin
				eb_textbuf[0] := #0;
				eb_canceled := True;

				Windows.EnableWindow( myhwSDL, True );
				Windows.BringWindowToTop( myhwSDL );
				Windows.DestroyWindow( mydlg );
				mydlg := 0;
				exit(0);
			end;

			if (wp = Windows.VK_RETURN) or (wp = Windows.VK_SEPARATOR) then begin
				Windows.GetWindowText( dlgEdit, eb_textbuf, MaxTextBuf);

				eb_textbuf[MaxTextBuf] := #0;
				buf := AnsiToUTF8( eb_textbuf );
				eb_textbuf := buf;
				i := 0;
				while i < MaxTextBuf do begin
					if #0 = eb_textbuf[i] then begin
						break;
					end else if TextISO646_AllowableCheck(eb_textbuf[i]) then begin
						Inc( i );
					end else if IsUTF8CharLeadByte(eb_textbuf[i]) then begin
						state := LengthUTF8Char( eb_textbuf[i] );
						i := i + state;
					end else begin
						for j := i + 1 to MaxTextBuf do begin
							eb_textbuf[j - 1] := eb_textbuf[j];
						end;
					end;
				end;

				Windows.EnableWindow( myhwSDL, True );
				Windows.BringWindowToTop( myhwSDL );
				Windows.DestroyWindow( mydlg );
				mydlg := 0;
				exit(0);
			end;
		end;
	end;
	EditProc := Windows.CallWindowProc( Org_edit, myhwnd, msg, wp, lp );
end;

Procedure PrepareDlgProc( myhwnd: Windows.HWND );
var
	lf: Windows.LOGFONT;
	myhimc: imm.HIMC;
begin
	Windows.ZeroMemory( @lf, sizeof(Windows.LOGFONT) );
	With lf do
	begin
		lfHeight		:= MSWINGUI_FontSize;
		lfOutPrecision		:= Windows.OUT_DEFAULT_PRECIS;
		lfClipPrecision		:= Windows.CLIP_DEFAULT_PRECIS;
		lfQuality		:= Windows.DEFAULT_QUALITY;
		lfWeight		:= MSWINGUI_FontWeight;
		lfPitchAndFamily	:= Windows.FIXED_PITCH or Windows.FF_DONTCARE;
		lfFaceName		:= MSWINGUI_FontName + #0;
		lfCharSet		:= Windows.DEFAULT_CHARSET;
	end;
	myfont := Windows.CreateFontIndirect( @lf );

	dlgTitle := Windows.CreateWindow(
		'STATIC'#0, Nil,
		Windows.WS_CHILD or Windows.WS_VISIBLE or Windows.SS_CENTER,
		bw, bw, dw-bw*2, (dh - th),
		myhwnd, Windows.HMENU(1), myhInst, NIL );
	dlgEdit := Windows.CreateWindow(
		'EDIT'#0, NIL,
		Windows.WS_CHILD or Windows.WS_VISIBLE or Windows.ES_CENTER,
		bw, (dh - th - 8), dw-bw*2, th,
		myhwnd, Windows.HMENU(2), myhInst, NIL );
	Org_edit := Windows.WNDPROC( Windows.GetWindowLongPtr(dlgEdit, Windows.GWL_WNDPROC) );
{$IFDEF WIN32}
	Windows.SetWindowLong( dlgEdit, Windows.GWL_WNDPROC, LongInt(@EditProc) );
{$ELSE WIN32}
	Windows.SetWindowLongPtr( dlgEdit, Windows.GWL_WNDPROC, Int64(@EditProc) );
{$ENDIF WIN32}

	myhimc := imm.ImmGetContext( myhwnd );
	imm.ImmSetOpenStatus( myhimc, bIMEMode );
	imm.ImmReleaseContext( myhwnd, myhimc );
end;

Procedure DestroyDlgProc( myhwnd: Windows.HWND );
var
	myhimc: imm.HIMC;
begin
	if ( not Windows.DeleteObject(myfont) ) then begin
		ErrorMessage( 'failed to delete font. ' );
	end;
	myfont := 0;

	myhimc := imm.ImmGetContext( myhwnd );
	bIMEMode := imm.ImmGetOpenStatus( myhimc );
	imm.ImmSetOpenStatus( myhimc, False );
	imm.ImmReleaseContext( myhwnd, myhimc );
end;

Function DlgProc( myhwnd: Windows.HWND; msg: UINT; wp: Windows.WPARAM; lp: Windows.LPARAM ): Windows.LRESULT; StdCall;
var
	hd: Windows.HDC;
begin
	Case msg of
	    Windows.WM_CREATE:
		begin
			PrepareDlgProc( myhwnd );
		end;

	    Windows.WM_DESTROY:
		begin
			DestroyDlgProc( myhwnd );
		end;

	    Windows.WM_SETFOCUS:
		begin
			Windows.SetFocus( dlgEdit );
		end;

	    Windows.WM_CTLCOLORSTATIC:
		begin
			hd := Windows.HDC(wp);
			if (dlgTitle = Windows.HWND(lp)) then begin
				Windows.SelectObject( hd, myfont );
				Windows.SetBkMode( hd, Windows.TRANSPARENT );
				Windows.SetTextColor( hd, Windows.RGB(255,255,255) );
				Windows.SetBkColor( hd, Windows.RGB(0,101,151) );
				exit(Windows.LRESULT(hbBorderBlue));
			end;
		end;

	    Windows.WM_CTLCOLOREDIT:
		begin
			hd := Windows.HDC(wp);
			if (dlgEdit = Windows.HWND(lp)) then begin
				Windows.SelectObject( hd, myfont );
				Windows.SetTextColor( hd, Windows.RGB(0,141,0) );
				Windows.SetBkColor( hd, Windows.RGB(0,0,0) );
				exit(Windows.LRESULT( Windows.GetStockObject(Windows.BLACK_BRUSH) ));
			end;
		end;
	end;
	DlgProc := Windows.DefWindowProc( myhwnd, msg, wp, lp );
end;


Function EditBox( const X, Y, W, H: LongInt; const title, Init_text: String; var canceled: Boolean ): String;
var
	mymsg: Windows.MSG;
	rc: Windows.RECT;
	wp: Windows.WINDOWPLACEMENT;
	pt: PChar;
	msg: String;
	pmsg: PChar;
begin
	canceled := False;
	eb_canceled := False;

	myhwSDL := GetSDLHWND;
	dw := W;
	dh := H;
	th := myTextHeight(myhwSDL) + 1;
	rc := myWndPos(myhwSDL);

	mydlg := Windows.CreateWindow(
		mywcname, NIL,
		DWORD(Windows.WS_POPUP) or Windows.WS_BORDER,	{<-Cast: error Range Check...}
		Windows.CW_USEDEFAULT, Windows.CW_USEDEFAULT, Windows.CW_USEDEFAULT, Windows.CW_USEDEFAULT,
		myhwSDL, 0, myhInst, NIL );

	if mydlg = 0 then begin
		msg := 'Windows.CreateWindow() failed.';
		pmsg := QuickPCopy(msg);
		Windows.MessageBox( 0, pmsg, 'Sorry'#0, MB_OK );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
		sysutils.StrDispose( pmsg );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
	end;

	wp.length := sizeof(wp);
	wp.flags := 0;
	wp.showCmd := Windows.SW_SHOW;
	wp.rcNormalPosition.left := rc.left + X;
	wp.rcNormalPosition.top := rc.top + Y;
	wp.rcNormalPosition.right := wp.rcNormalPosition.left + W;
	wp.rcNormalPosition.bottom := wp.rcNormalPosition.top + H;
	Windows.SetWindowPlacement( mydlg, @wp );

	pt := QuickPCopy( UTF8ToAnsi( title ) );
	Windows.SetWindowText( dlgTitle, pt );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
	sysutils.StrDispose(pt);
{$ENDIF PATCH_GH_PARANOID_CHECKER}
	pt := QuickPCopy( UTF8ToAnsi( Init_text ) );
	Windows.SetWindowText( dlgEdit, pt );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
	sysutils.StrDispose(pt);
{$ENDIF PATCH_GH_PARANOID_CHECKER}

	Windows.SetFocus( dlgEdit );
	Windows.SendMessage( dlgEdit, Windows.EM_SETSEL, 0, -1 );
	Windows.ShowWindow( mydlg, SW_SHOW );
	Windows.EnableWindow( myhwSDL, FALSE );

	while( mydlg <> 0 ) do begin
		Windows.GetMessage( @mymsg, 0, 0, 0 );
		Windows.TranslateMessage( @mymsg );
		Windows.DispatchMessage( @mymsg );
	end;

	pmsg := eb_textbuf;
	canceled := eb_canceled;
	EditBox := StrPas(pmsg);
end;

Procedure InitEditBox;
var
	mywc: Windows.WNDCLASSEX;
	msg: String;
	pmsg: PChar;
begin
	myhinst := Windows.GetModuleHandle( NIL );

	With mywc do
	begin
		cbSize        := sizeof(mywc);
		style         := Windows.CS_HREDRAW or Windows.CS_VREDRAW;
		lpfnWndProc   := @DlgProc;
		cbClsExtra    := 0;
		cbWndExtra    := 0;
		hInstance     := myhinst;
		hIcon         := 0;
		hCursor       := Windows.LoadCursor( 0, Windows.IDC_ARROW );
		hbrBackground := hbBorderBlue;
		lpszMenuName  := NIL;
		lpszClassName := mywcname;
		hIconSm       := 0;
	end;

	if (Windows.RegisterClassEX( @mywc ) = 0) then begin
		msg := 'Windows.RegisterClassEX() failed.';
		pmsg := QuickPCopy(msg);
		Windows.MessageBox( 0, pmsg, 'Sorry'#0, MB_OK );
{$IFNDEF PATCH_GH_PARANOID_CHECKER}
		sysutils.StrDispose( pmsg );
{$ENDIF PATCH_GH_PARANOID_CHECKER}
	end;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: w32eb.pp');
{$ENDIF DEBUG}
	hbBorderBlue := Windows.CreateSolidBrush( Windows.RGB(0,101,151) );
	InitEditBox;
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: w32eb.pp(finalization)');
{$ENDIF DEBUG}
	Windows.DeleteObject( hbBorderBlue );
end;

end.
{$ENDIF}
