<?php

###############################################################################
# norwegian.php, based on
# english.php
# This is the norwegian language page for GeekLog!
#
# Translator   : Torfinn Ingolfsen <tingo@start.no>
# Date started : 2003-03-10
# Last updated : 2004-08-04
# Date finished: 2004-08-04
# History:
# 2004-08-04	Update for Geeklog 1.3.8-1sr5 started and completed.
# 2003-06-08	Corrected LANG22[15], capitalize first word
# 2003-04-02	Corrected capitalization of MESSAGE[48].
# 2003-03-30	Translated the last (and final) part
# 2003-03-23	Translated down to and including LANG23 (link.php)
# 2003-03-18	First half of the file translated
# 2003-03-10	Translation started
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten@securitygeeks.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'UTF-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Gitt av:',
    2 => 'les mer',
    3 => 'kommentarer',
    4 => 'Rediger',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Admin Funksjoner:',
    10 => 'Innlegg',
    11 => 'Artikler',
    12 => 'Blokker',
    13 => 'Emner',
    14 => '',
    15 => '',
    16 => '',
    17 => 'Brukere',
    18 => 'SQL Spørring',
    19 => 'Logg Ut',
    20 => 'Brukerinformasjon:',
    21 => 'Brukernavn',
    22 => 'Bruker ID',
    23 => 'Sikkerhetsnivå',
    24 => 'Anonym',
    25 => 'Svar',
    26 => 'De følgende kommentarer eies av den som skrev dem. Dette nettstedet er ikke ansvarlig for innholdet.',
    27 => 'Nyeste Innlegg',
    28 => 'Slett',
    29 => 'ingen kommentarer.',
    30 => 'Eldre Artikler',
    31 => 'Lovlige HTML tagger:',
    32 => 'Feil, ugyldig brukernavn',
    33 => 'Feil, kunne ikke skrive til loggfilen',
    34 => 'Feil',
    35 => 'Logg ut',
    36 => 'på',
    37 => 'Ingen artikler fra brukere',
    38 => 'Content Syndication',
    39 => 'Gjenoppfrisk',
    40 => 'You have <tt>register_globals = Off</tt> in your <tt>php.ini</tt>. However, Geeklog requires <tt>register_globals</tt> to be <strong>on</strong>. Before you continue, please set it to <strong>on</strong> and restart your web server.',
    41 => 'Gjestebrukere',
    42 => 'Skrevet av:',
    43 => 'Svar på denne',
    44 => 'Opphav',
    45 => 'MySQL Feil Nummer',
    46 => 'MySQL Feilmelding',
    47 => 'Brukerfunksjoner',
    48 => 'Kontoinformasjon',
    49 => 'Visningsvalg',
    50 => 'Feil i SQL setning',
    51 => 'hjelp',
    52 => 'Ny',
    53 => 'Admin Hovedside',
    54 => 'Kunne ikke åpne filen.',
    55 => 'Feil på',
    56 => 'stem',
    57 => 'Passord',
    58 => 'Logg inn',
    59 => "Er du ikke bruker ennå? Registrer deg som en <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">Ny bruker</a>",
    60 => 'Skriv en kommentar',
    61 => 'Opprett Ny Konto',
    62 => 'ord',
    63 => 'Kommentarvalg',
    64 => 'Email Artikkelen Til en Venn',
    65 => 'Utskriftsvennlig Versjon',
    66 => '',
    67 => 'Velkommen til ',
    68 => 'hjem',
    69 => 'kontakt',
    70 => 'søk',
    71 => 'bidra',
    72 => 'lenker',
    73 => '',
    74 => '',
    75 => 'avansert søk',
    76 => 'nettsted statistikk',
    77 => 'Plugins',
    78 => '',
    79 => 'Nytt',
    80 => 'artikler de siste',
    81 => 'artikkel de siste',
    82 => 'timer',
    83 => 'KOMMENTARER',
    84 => '',
    85 => 'siste 48 timer',
    86 => 'ingen nye kommentarer',
    87 => 'siste 2 uker',
    88 => '',
    89 => '',
    90 => 'Hjem',
    91 => 'Side generert på',
    92 => 'sekunder',
    93 => 'Opphavsrett',
    94 => 'Alle varemerker og opphavsrett på denne siden tilhører de respektive eiere.',
    95 => 'Drevet Av',
    96 => 'Grupper',
    97 => 'Ordliste',
    98 => 'Plug-ins',
    99 => 'ARTIKLER',
    100 => 'ingen nye artikler',
    101 => '',
    102 => '',
    103 => 'DB Backups',
    104 => 'av',
    105 => 'Email brukere',
    106 => 'Visninger',
    107 => 'GL Version Test',
    108 => 'Tøm Cache',
    109 => 'Report abuse',
    110 => 'Report this post to the site admin',
    111 => '',
    112 => 'Registered Users',
    113 => 'Documentation',
    114 => 'TRACKBACKS',
    115 => 'No new trackback comments',
    116 => 'Trackback',
    117 => 'Directory',
    118 => 'Please continue reading on the next page:',
    119 => "Lost your <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">password</a>?",
    120 => 'Permanent link to this comment',
    121 => 'Comments (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'All HTML is allowed',
    124 => 'Click to delete all checked items',
    125 => 'Are you sure you want to Delete all checked items?',
    126 => 'Select or de-select all items',
    127 => 'Permalink',
    128 => 'Login with OpenID:',
    129 => 'Configuration',
    130 => 'Webservices'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Skriv en Kommentar',
    2 => 'Skrivemodus',
    3 => 'Logg ut',
    4 => 'Lag ny Konto',
    5 => 'Brukernavn',
    6 => 'Dette nettstedet krever at du er logget inn for å kunne skrive kommentarer, vennligst logg inn. Hvis du ikke er registrert fra før, bruk skjemaet under for å registrere deg som ny bruker.',
    7 => 'Din siste kommentar var ',
    8 => " sekunder siden. Dette nettstedet krever minst {$_CONF['commentspeedlimit']} sekunder mellom kommentarer",
    9 => 'kommentar',
    10 => 'Send Report',
    11 => 'Post kommentar',
    12 => 'vennligst fyll ut Tittel- og Kommentarfeltene, de er obligatoriske for å poste en kommentar.',
    13 => 'Din Informasjon',
    14 => 'Forhåndsvisning',
    15 => 'Report this post',
    16 => 'Overskrift',
    17 => 'Feil',
    18 => 'Viktig',
    19 => 'Forsøk å holde deg til emnet når du skriver kommentarer.',
    20 => 'Svar på andres kommentarer istedet for å opprette nye diskusjonstråder.',
    21 => 'Les øvrige kommentarer før du poster din egen, for å unngå gjentakelse av det som allerede er blitt sagt.',
    22 => 'Bruk en tydelig overskrift som forteller hva kommentaren din handler om.',
    23 => 'Emailadressen din blir IKKE offentliggjort.',
    24 => 'Anonym Bruker',
    25 => 'Are you sure you want to report this post to the site admin?',
    26 => '%s reported the following abusive comment post:',
    27 => 'Abuse report',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Brukerprofil for',
    2 => 'Brukernavn',
    3 => 'Fullt Navn',
    4 => 'Passord',
    5 => 'Email',
    6 => 'Hjemmeside',
    7 => 'Biografi',
    8 => 'PGP nøkkel',
    9 => 'Lagre Informasjon',
    10 => 'Siste 10 kommentarer av bruker',
    11 => 'Brukeren har ikke skrevet noen kommentarer',
    12 => 'Brukervalg for',
    13 => 'Email Nattlig Sammendrag',
    14 => 'Dette er et tilfeldig generert passord. Du anbefales å endre passordet omgående. For å endre passordet, logg inn og velg Kontoinformasjon fra Brukermenyen.',
    15 => "Din {$_CONF['site_name']} er opprettet. For å bruke den må du logge inn med nedenstående opplysninger. Vennligst ta vare på denne mailen for fremtidig referanse.",
    16 => 'din Kontoinformasjon',
    17 => 'Kontoen eksisterer ikke',
    18 => 'Oppgitt emailadresse synes å være ugyldig',
    19 => 'Oppgitt brukernavn eller emailadresse finnes fra før',
    20 => 'Oppgitt emailadresse synes å være ugyldig',
    21 => 'Feil',
    22 => "Opprett konto på {$_CONF['site_name']}!",
    23 => "Ved å opprette en konto på {$_CONF['site_name']} vil du få mulighet til å skrive artikler og kommentarer i ditt eget navn. Hvis du ikke har en konto, vil du kun delta som anonym. Emailadressen du oppgir vil <b><i>aldri</i></b> bli offentlig vist på dette nettstedet.",
    24 => 'Passordet ditt blir sendt til den emailadressen du oppgir.',
    25 => 'Har du glemt passordet ditt?',
    26 => 'Skriv inn <em>enten</em> brukernavnet ditt eller emailadressen du brukte når du registrerte deg og trykk på Email Passord. Opllysing om hvordan du lager et nytt passord blir sendt til mailadressen som er registrert i databasen.',
    27 => 'Opprett Konto Nå!',
    28 => 'Email Passord',
    29 => 'logget ut fra',
    30 => 'logged inn fra',
    31 => 'Denne funksjonen krever at du er logget inn',
    32 => 'Signatur',
    33 => 'Blir aldri vist offentlig',
    34 => 'Ditt egentlige navn',
    35 => 'Skriv inn passord for å endre det',
    36 => 'Begynner med http://',
    37 => 'Legges til dine kommentarer',
    38 => 'Alt om deg! Alle kan lese dette',
    39 => 'Din offentlige PGP nøkkel',
    40 => 'Ingen Emneikoner',
    41 => 'Villig til å være Moderator',
    42 => 'Datoformat',
    43 => 'Maksimum Antall Artikler',
    44 => 'Ingen Rammer',
    45 => 'Visningsvalg for',
    46 => 'Ekskluderte Emner og Forfattere for',
    47 => 'Konfigurasjon av nyhetsbokser for',
    48 => 'Emner',
    49 => 'ingen ikoner i artikler',
    50 => 'fjern avkryssing hvis du ikke er interessert',
    51 => 'Kun nyheter og artikler',
    52 => 'Standardverdien er',
    53 => 'Motta dagens artikler hver natt',
    54 => 'Kryss av for de emner og forfattere du ikke ønsker å se.',
    55 => 'Dersom ingen er avkrysset, så får du standardvalget. Hvis du begynner å krysse av bokser, husk å krysse av for alle du ønsker å se, fordi standardvalget blir ignorert. Standardvalg vises med <b>uthevet</b> skrift.',
    56 => 'Forfattere',
    57 => 'Visningsmodus',
    58 => 'Rekkefølge for sortering',
    59 => 'Kommentarbegrensning',
    60 => 'Hvordan vil du ha kommentarene vist?',
    61 => 'Nyeste eller eldste først?',
    62 => 'Standardverdi er 100',
    63 => "Passordet ditt er sendt, og vil snart dukke opp i mailboksen din. Vennligst følg instruksjonen i meldingen du mottar. Vi takker for at du bruker {$_CONF['site_name']}",
    64 => 'Kommentarvalg for',
    65 => 'Forsøk å logge inn på nytt',
    66 => "Du har kanskje skrevet brukernavn eller passord feil. Forsøk å logge inn igjewn under. er du en <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">ny bruker</a>?",
    67 => 'Medlem Siden',
    68 => 'Husk meg i',
    69 => 'Hvor lenge skal vi huske deg etter at du er logget inn?',
    70 => "Tilpass utseendet og innholdet på {$_CONF['site_name']}",
    71 => "En av mulighetene på {$_CONF['site_name']} er at du kan tilpasse innhold, utseeende og layout slik at det passer deg. for å kunne bruke disse funksjonene må du først registrere deg som  <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">bruker</a> på {$_CONF['site_name']}. Er du allerede registrert? Da bruker du loginskjemaet til venstre for å logge inn!",
    72 => 'Tema',
    73 => 'Språk',
    74 => 'Endre utseendet på dette nettstedet!',
    75 => 'Emailede Emner for',
    76 => 'Hvis du velger et eller flere emner fra listen under, så vil du motta alle nye artikler for det enkelte emne ved dagens slutt. Velg kun emner som interesserer deg!',
    77 => 'Foto',
    78 => 'Legg inn et bilde av deg selv!',
    79 => 'Kryss av her for å slette dette bildet',
    80 => 'Loginn',
    81 => 'Send Email',
    82 => 'Siste 10 artikler av bruker',
    83 => 'Skrivestatistikk for bruker',
    84 => 'Totalt antall artikler:',
    85 => 'Totalt antall kommentarer:',
    86 => 'Finn alt skrevet av',
    87 => 'Ditt login-navn',
    88 => "Noen (kanskje du) har bedt om et nytt passord for din konto \"%s\" på {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nHvis du virkelig ønsker å utføre dette, vennligst trykk på lenken under:\n\n",
    89 => "Hvis du ikke ønsker å utføre dette, bare ignorer denne meldingen (passordet ditt vil ikke bli endret).\n\n",
    90 => 'du kan skrive inn et nytt passord for kontoen din under. Vennligst merk at ditt gmle passord vil være gyldig helt til du bekrefter dette skjemaet.',
    91 => 'Sett Nytt Passord',
    92 => 'Skriv inn Nytt Passord',
    93 => 'din siste forespørsel om nytt passord var %d for sekunder siden. Dette nettstedet krever minst %d sekunder mellom passord endringer.',
    94 => 'Slett Konto "%s"',
    95 => 'Trykk på  "slett konto" knappen under for å fjerne kontoen din fra vår database. Vennligst legg merke til at artikler og kommentarer du har skrevet med denne kontoen <strong>ikke</strong> vil bli slettet, men vil vises som skrevet av "Anonym".',
    96 => 'slett konto',
    97 => 'Bekreft Sletting av Konto',
    98 => 'er du sikker på at du ønsker å slettekontoen din? Hvis du sletter kontoen din vil du ikke kunne logge inn på dette nettstedet igjen (dersom du ikke lager en ny konto). Hvis du er sikker, trykk "slett konto" igjen på skjemaet under.',
    99 => 'Privacy Options for',
    100 => 'Email fra Admin',
    101 => 'Tillat email fra Administratorer',
    102 => 'Email fra Brukere',
    103 => 'Tillat email fra andre brukere',
    104 => 'Vis Online Status',
    105 => 'Vises i Online nå blokk',
    106 => 'Location',
    107 => 'Shown in your public profile',
    108 => 'Confirm new password',
    109 => 'Enter the New password again here',
    110 => 'Current Password',
    111 => 'Please enter your Current password',
    112 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    113 => 'Login Attempt Failed',
    114 => 'Account Disabled',
    115 => 'Your account has been disabled, you may not login. Please contact an Administrator.',
    116 => 'Account Awaiting Activation',
    117 => 'Your account is currently awaiting activation by an administrator. You will not be able to login until your account has been approved.',
    118 => "Your {$_CONF['site_name']} account has now been activated by an administrator. You may now login to the site at the url below using your username (<username>) and password as previously emailed to you.",
    119 => 'If you have forgotten your password, you may request a new one at this url:',
    120 => 'Account Activated',
    121 => 'Service',
    122 => 'Sorry, new user registration is disabled',
    123 => "Are you a <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">new user</a>?",
    124 => 'Confirm Email',
    125 => 'You have to enter the same email address in both fields!',
    126 => 'Please repeat for confirmation',
    127 => 'To change any of these settings, you will have to enter your current password.',
    128 => 'Your Name',
    129 => 'Password &amp; Email',
    130 => 'About You',
    131 => 'Daily Digest Options',
    132 => 'Daily Digest Feature',
    133 => 'Comment Display',
    134 => 'Comment Options',
    135 => '<li>Default mode for how comments will be displayed</li><li>Default order to display comments</li><li>Set maximum number of comments to show - default is 100</li>',
    136 => 'Exclude Topics and Authors',
    137 => 'Filter Story Content',
    138 => 'Misc Settings',
    139 => 'Layout and Language',
    140 => '<li>No Topic Icons if checked will not display the story topic icons</li><li>No boxes if checked will only show the Admin Menu, User Menu and Topics<li>Set the maximum number of stories to show per page</li><li>Set your theme and perferred date format</li>',
    141 => 'Privacy Settings',
    142 => 'The default setting is to allow users & admins to email fellow site members and show your status as online. Un-check these options to protect your privacy.',
    143 => 'Filter Block Content',
    144 => 'Show & hide boxes',
    145 => 'Your Public Profile',
    146 => 'Password and email',
    147 => 'Edit your account password, email and autologin feature. You will need to enter the same password or email address twice as a confirmation.',
    148 => 'User Information',
    149 => 'Modify your user information that will be shown to other users.<li>The signature will be added to any comments or forum posts you made</li><li>The BIO is a brief summary of yourself to share</li><li>Share your PGP Key</li>',
    150 => 'Warning: Javascript recommended for enhanced functionality',
    156 => 'Delete Account',
    157 => 'Delete Option',
    158 => 'Time Zone',
    159 => 'This email was generated automatically. Please do not reply to this email.',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Preview',
    'pe_namepass' => 'Username &amp; Password',
    'pe_userinfo' => 'About You',
    'pe_layout' => 'Layout &amp; Language',
    'pe_content' => 'Content',
    'pe_privacy' => 'Privacy'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Det er ingen nyheter å vise',
    2 => 'Det er ingen artikler å vise. Enten er det ingen nyheter for dette emne, eller så er dine brukervalg for restriktive',
    3 => ' for emne %s',
    4 => 'Dagens Hovedoppslag',
    5 => 'Neste',
    6 => 'Forrige',
    7 => 'First',
    8 => 'Last'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'det oppsto en feil under utsendelse av din melding. Vennligst forsøk på nytt.',
    2 => 'Meldingen ble sendt.',
    3 => 'Vennligst sjekk at du bruker en gyldig emailadressei Svar Til feltet.',
    4 => 'Vennligst fyll ut feltene Ditt Navn, Svar Til, Emne og  Melding',
    5 => 'Feil: Bruker finnes ikke.',
    6 => 'En feil oppsto.',
    7 => 'Brukerprofil for',
    8 => 'Brukernavn',
    9 => 'Bruker URL',
    10 => 'Send email til',
    11 => 'Ditt navn:',
    12 => 'Svar Til:',
    13 => 'Emne:',
    14 => 'Melding:',
    15 => 'HTML blir ikke oversatt.',
    16 => 'Send Melding',
    17 => 'Email denne artikkelen til en venn',
    18 => 'Til Navn',
    19 => 'Til Emailadresse',
    20 => 'Fra Navn',
    21 => 'Fra Emailadresse',
    22 => 'Alle felter må fylles ut',
    23 => "Denne emailen er sendt til deg av %s (%s) fordi vedkommende mener at du kunne være interessert i denne artikkelen fra {$_CONF['site_url']}. Dette er ikke SPAM (søppelpost) og mailadressene som ble brukt i denne transaksjonen er ikke lagret for senere bruk.",
    24 => 'Kommenter denne artikkelen på',
    25 => 'Du må være logget inn for å bruke denne funksjonen. Kravet om innlogging hjelper til med å hindre misbruk av systemet',
    26 => 'Dette skjemaet lar deg sende en email til valgt bruker. Alle felter må fylles ut.',
    27 => 'Kort melding',
    28 => '%s skrev: ',
    29 => "Dette er det daglige sammendraget fra {$_CONF['site_name']} for ",
    30 => ' Daglig Nyhetsbrev for ',
    31 => 'Overskrift',
    32 => 'Dato',
    33 => 'les hele artikkelen på',
    34 => 'Slutt på Melding',
    35 => 'Beklager, denne brukeren ønsker ikke å motta noen emailer.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Avansert Søk',
    2 => 'Nøkkelord',
    3 => 'Emne',
    4 => 'Alle',
    5 => 'Type',
    6 => 'Artikler',
    7 => 'Kommentarer',
    8 => 'Forfattere',
    9 => 'Alle',
    10 => 'Søk',
    11 => 'Søkeresultater',
    12 => 'resultater',
    13 => 'Søkeresultat: Ingen samsvar',
    14 => 'Det var ingen resultater som svarte til ditt søk etter',
    15 => 'Prøv igjen.',
    16 => 'emne',
    17 => 'Dato',
    18 => 'Forfatter',
    19 => "Søk i hele {$_CONF['site_name']} databasen av nåværende og gamle artikler",
    20 => 'Dato',
    21 => 'til',
    22 => '(Datoformat YYYY-MM-DD)',
    23 => 'Treff',
    24 => 'Fant %d treff',
    25 => 'søkte etter',
    26 => 'treff ',
    27 => 'sekunder',
    28 => 'Ingen treff i artikler eller kommentarer for ditt søk',
    29 => 'Resultater fra Artikler og Kommentarer',
    30 => '',
    31 => 'Denne plug-in returnerte ingen treff',
    32 => '',
    33 => 'URL',
    34 => 'Sted',
    35 => 'Hele dagen',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Søkestrengen din må inneholde minst 3 tegn.',
    42 => 'Datoer må angis på formatet YYYY-MM-DD (år-måned-dag).',
    43 => 'eksakt frase',
    44 => 'alle ordene',
    45 => 'et eller flere ord',
    46 => 'Neste',
    47 => 'Forrige',
    48 => 'Forfatter',
    49 => 'Dato',
    50 => 'Treff',
    51 => '',
    52 => 'Sted',
    53 => 'Resultater fra Artikler',
    54 => 'Resultater fra Kommentarer',
    55 => 'frase',
    56 => 'AND',
    57 => 'OR',
    58 => 'More results &gt;&gt;',
    59 => 'Results',
    60 => 'per page',
    61 => 'Refine search',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Story',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Statistikk for nettstedet',
    2 => 'Totalt antall treff i systemet',
    3 => 'Artikler(kommentarer) i systemet',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Topp Ti Viste Artikler',
    8 => 'Overskrift',
    9 => 'Vist',
    10 => 'Det virker som om det ikke er noen artikler på dette nettstedet, eller at ingen har lest dem.',
    11 => 'Topp Ti kommenterte Artikler',
    12 => 'Kommentarer',
    13 => 'Det virker som om det ikke er noen artikler på dette nettstedet, eller at ingen har kommentert dem.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Topp Ti Artikler sendt via Email',
    23 => 'Emails',
    24 => 'Det virker som om ingen har emailet en artikkel på dette nettstedet',
    25 => 'Top Ten Trackback Commented Stories',
    26 => 'No trackback comments found.',
    27 => 'Number of active users',
    28 => '',
    29 => '',
    30 => 'Hits',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Relatert',
    2 => 'Send  artikkelen til en venn',
    3 => 'utskriftsvennlig format',
    4 => 'Valg',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Du må være logget inn for å poste en %s.',
    2 => 'Logg inn',
    3 => 'Ny bruker',
    4 => '',
    5 => '',
    6 => 'Post en artikkel',
    7 => 'Innlogging kreves',
    8 => 'Post',
    9 => 'Når du poster informasjon på dette nettstedet ber vi om at du følger disse retningslinjene...<ul><li>Alle feltene må fylles ut<li>Gi nøyaktige og komplette opplysninger<li>Dobbeltsjekk URLer</ul>',
    10 => 'Overskrift',
    11 => '',
    12 => 'Start Dato',
    13 => 'Slutt Dato',
    14 => 'Sted',
    15 => 'Beskrivelse',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Les først',
    20 => '',
    21 => '',
    22 => 'Feil: felt mangler',
    23 => 'Vennligst fyll inn alle feltene.  Alle felt er påkrevd.',
    24 => 'Posting lagret',
    25 => 'Din posting av en %s er lagret.',
    26 => 'Fartsgrense',
    27 => 'Brukernavn',
    28 => 'Emne',
    29 => 'Artikkel',
    30 => 'din siste posting var ',
    31 => " sekunder siden.  Dette nettstedet krever minst {$_CONF['speedlimit']} sekunder mellom postinger",
    32 => 'Forhåndsvisning',
    33 => 'Forhåndsvis Artikkel',
    34 => 'Logg ut',
    35 => 'HTML tagger er ulovlig',
    36 => 'Posting Modus',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Adresselinje 1',
    45 => 'Adresselinje 2',
    46 => 'By/Sted',
    47 => 'Stat',
    48 => 'Postnummer',
    49 => '',
    50 => '',
    51 => 'Sted',
    52 => 'Slett',
    53 => 'Lag Konto',
    54 => 'Story Introduction',
    55 => 'Story Body'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Autentisering kreves',
    2 => 'Avvist! Ugyldig brukernavn eller passord',
    3 => 'Ugyldig passord for bruker',
    4 => 'Brukernavn:',
    5 => 'Passord:',
    6 => 'All tilgang til administrative deler av nettstedet blir logget og gransket.<br' . XHTML . '>Denne siden er kun autorisert personell.',
    7 => 'logg inn'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Utilstrekkelige Admin Rettigheter',
    2 => 'Du har ikke nødvendige rettigheter for å redigere denne blokken.',
    3 => 'Blokk Editor',
    4 => 'There was a problem reading this feed (see error.log for details).',
    5 => '',
    6 => '',
    7 => 'Alle',
    8 => 'Blokk Sikkerhetsnivå',
    9 => 'Blokk Rekkefølge',
    10 => '',
    11 => 'Portal Blokk',
    12 => 'Normal Blokk',
    13 => 'Portal Blokk Opsjoner',
    14 => 'RDF URL',
    15 => 'Siste RDF Oppdatering',
    16 => 'Normal Blokk Opsjoner',
    17 => 'Blokk Innhold',
    18 => 'Vennligst fyll ut feltene Overskrift, Sikkerhetsnivå og innhold ',
    19 => 'Blokk Bestyrer',
    20 => '',
    21 => 'Blokk Sikkerhetsnivå',
    22 => '',
    23 => 'Blokk Rekkefølge',
    24 => '',
    25 => 'For å endre eller slette en blokk, klikk på blokkoverskriften under.  For å lage en ny blokk klikk på "Ny Blokk" ovenfor.',
    26 => 'Layout Blokk',
    27 => 'PHP Blokk',
    28 => 'PHP Blokk Opsjoner',
    29 => 'Blokk Funksjon',
    30 => 'Hvis du vil bruke PHP kode i en blokk, skriv inn navnet på funksjonen over.  Navnet på funksjonen må starte med prefikset "phpblock_" (feks. phpblock_getweather).  Dersom navnet ikke har dette prefikset, så vil funksjonen IKKE bli kalt.  Vi gjør dette for å forhindre hackere fra å bruke vilkårlige funksjoner (som kan skade systemet), dersom de skulle klare å gjøre innbrudd i Geeklog installasjonen din. forsikre deg om at det ikke er tomme paranteser "()" etter navnet på funksjonen. Til slutt anbefaler vi at du legger all kode til PHP Blokker i /path/to/geeklog/system/lib-custom.php.  Da unngår du at koden blir overskrevet ved oppgraderinger av Geeklog.',
    31 => 'Feil i PHP Blokk. Funksjonen %s eksisterer ikke.',
    32 => 'Feil Felt(er) mangler',
    33 => 'Du må skrive inn URLen til .rdf filen for portal blokker',
    34 => 'Du må skrive inn overskrift og funksjon for PHP blokker',
    35 => 'Du må skrive inn overskrift og innhold for normale blokker',
    36 => 'Du må skrive inn the content for layout blocks',
    37 => 'Ulovlig funksjonsnavn på PHP blokk',
    38 => 'Funksjoner for PHP Blokker må ha prefikset \'phpblock_\' (feks. phpblock_getweather). Prefikset \'phpblock_\' kreves av sikkerhetsmesige årsaker for å forhindre kjøring av vilkårlig kode..',
    39 => 'Side',
    40 => 'Venstre',
    41 => 'Høyre',
    42 => 'du må skrive inn rekkefølge og sikkerhetsnivå for Geeklog standard blokker',
    43 => 'Kun hjemmeside',
    44 => '',
    45 => "Du forsøker å få tilgang til en blokk som du ikke har rettigheter til. Forsøket er logget. Vennligst <a href=\"{$_CONF['site_admin_url']}/block.php\">gå tilbake til administrasjonsiden for blokker</a>.",
    46 => 'Ny Blokk',
    47 => '',
    48 => 'Blokk Navn',
    49 => ' (uten mellomrom og må være unikt)',
    50 => '',
    51 => 'ta med http://',
    52 => 'hvis du lar denne være tom, så vises ikke hjelpeikonet for denne blokken',
    53 => 'Aktivisert',
    54 => 'lagre',
    55 => 'avbryt',
    56 => 'slett',
    57 => 'Move Block Down',
    58 => 'Move Block Up',
    59 => 'Move block to the right side',
    60 => 'Move block to the left side',
    61 => 'No Title',
    62 => 'Article Limit',
    63 => 'Bad Block Title',
    64 => 'Your Title must not be empty and cannot contain HTML!',
    65 => 'Order',
    66 => 'Autotags',
    67 => 'Check to allow autotags',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Forrige artikler',
    2 => 'Neste artikler',
    3 => 'Modus',
    4 => 'Posting Modus',
    5 => 'Artikkel Editor',
    6 => 'Det er ingen artikler i systemet',
    7 => 'Forfatter',
    8 => 'lagre',
    9 => 'forhåndsvis',
    10 => 'avbryt',
    11 => 'slett',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Dato',
    16 => 'Introduksjonstekst',
    17 => 'Hovedtekst',
    18 => 'Treff',
    19 => 'Kommentarer',
    20 => 'Ping',
    21 => 'Send Ping',
    22 => 'Artikkel Liste',
    23 => 'For å redigere eller slette en artikkel, klikk på artikkelnummeret under. For å se en artikkel, klikk på tittelen til artikkelen du ønsker å se. For å lage en ny artikkel klikk på Ny Artikkel over.',
    24 => 'The ID you chose for this story is already in use. Please use another ID.',
    25 => 'Error when saving story',
    26 => 'Artikkel forhåndsvisning',
    27 => 'If you use [unscaledX] instead of [imageX], the image will be inserted at its original dimensions.',
    28 => '<p><b>PREVIEWING</b>: Previewing a story with images attached is best done by saving the article as a draft INSTEAD OF hitting the preview button.  Use the preview button only when images are not attached.',
    29 => 'Trackbacks',
    30 => 'Feil ved opplasting av fil',
    31 => 'Vennligst fyll ut feltene Forfatter, Tittel og introduksjonstekst',
    32 => 'Hovedoppslag',
    33 => 'Det kan kun være ett hovedoppslag',
    34 => 'Kladd',
    35 => 'Ja',
    36 => 'Nei',
    37 => 'Mer av',
    38 => 'Mer fra',
    39 => 'Emails',
    40 => '',
    41 => "Du forsøker å redigere en artikkel du ikke har adgang til. Forsøket er logget. Du kan lese artikkelen under. Vennligst <a href=\"{$_CONF['site_admin_url']}/story.php\">gå tilbake til artikkeladministrasjon</a> når du er ferdig.",
    42 => "Du forsøker å se en artikkel du ikke har adgang til. Forsøket er logget. Vennligst <a href=\"{$_CONF['site_admin_url']}/story.php\">gå tilbake til artikkeladministrasjon</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>MERK:</b> hvis du endrer datoen til å være i fremtiden, så vil artikkelen ikke bli publisert før datoen intreffer. Det betyr også at artikkelen ikke blir inkludert i RDF oversikten din, og at den blir ignorert av søke- og statistikksidene.',
    47 => 'Bilder',
    48 => 'image',
    49 => 'right',
    50 => 'left',
    51 => 'For å bruke et av bildene du har lagt ved denne artikkelen må du sette inn en bestemt kode i artikkelen.  Koden er  [imageX], [imageX_right] (høyre) eller [imageX_left] (venstre) og X nummeret på bildet du har lagt ved. MERK: Du <b>må</b> bruke alle bildene du legger ved. Hvis ikke får du ikke lagret artikkelen.<BR><P><B>Forhåndsvisning</B>: Forhåndsvisning av e artikkel med bilder gjøres best ved å lagre artikkelen som en kladd, IKKE ved bruk av knappen for forhåndsvisning. Bruk knappen for forhåndsvisning kun på artikler uten bilder.',
    52 => '',
    53 => 'ble ikke brukt. Du må bruke dette bildet i introduksjonen eller i hovedteksten før du kan lagre endringer.',
    54 => 'Vedlagte bilder ikke brukt',
    55 => 'følgende feil oppsto under forsøk på å lagre artikkelen din. Vennligst rett opp disse feilene før du lagrer',
    56 => 'Vis Emneikon',
    57 => 'Vis bilde i original størrelse',
    58 => 'Story Management',
    59 => 'Option',
    60 => '',
    61 => 'Auto Archive',
    62 => 'Auto Delete',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Expand the Content Edit Area size',
    68 => 'Reduce the Content Edit Area size',
    69 => 'Publish Story Date',
    70 => 'Toolbar Selection',
    71 => 'Basic Toolbar',
    72 => 'Common Toolbar',
    73 => 'Advanced Toolbar',
    74 => 'Advanced II Toolbar',
    75 => 'Full Featured',
    76 => 'Publish Options',
    77 => 'Javascript needs to be enabled for Advanced Editor. Option can be disabled in the main site config.php',
    78 => 'Click <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">here</a> to use default editor',
    79 => 'Preview',
    80 => 'Editor',
    81 => 'Publish Options',
    82 => 'Images',
    83 => 'Archive Options',
    84 => 'Permissions',
    85 => 'Show All',
    86 => 'Advanced Editor',
    87 => 'Story Stats',
    88 => 'Wiki-style format'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Emne Editor',
    2 => 'Emne ID',
    3 => 'Emne Navn',
    4 => 'Emne Bilde',
    5 => '(ikke bruk mellomrom)',
    6 => 'Sletting av et emne vil også slette alle artikler og blokker som hører til emnet',
    7 => 'Vennligst fyll ut feltene Emne ID og Emne Navn',
    8 => 'Emne Administrasjon',
    9 => 'For å redigere eller slette et emne, klikk på emnet. For å lage et nytt emne klikk på knappen Nytt Emne til venstre. Adgangsnivået ditt for hvert emne står i parantes',
    10 => 'Sorteringsrekkefølge',
    11 => 'Artikler/Side',
    12 => 'Adgang Nektet',
    13 => "Du forsøker å nå et emne du ikke har rettigheter til. Forsøket er logget. Vennligst <a href=\"{$_CONF['site_admin_url']}/topic.php\">gå tilbake til emneadministrasjon</a>.",
    14 => 'Sorteringsmåte',
    15 => 'alfabetisk',
    16 => 'standard er',
    17 => 'Nytt Emne',
    18 => 'Admin Hovedside',
    19 => 'lagre',
    20 => 'avbryt',
    21 => 'slett',
    22 => 'Standard',
    23 => 'Gjør dette til standard emne for nye artikler',
    24 => '(*)',
    25 => 'Archive Topic',
    26 => 'make this the default topic for archived stories. Only one topic allowed.',
    27 => 'Or Upload Topic Icon',
    28 => 'Maximum',
    29 => 'File Upload Errors'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Bruker Editor',
    2 => 'Bruker ID',
    3 => 'Brukernavn',
    4 => 'Fullt Navn',
    5 => 'Passord',
    6 => 'Sikkerhetsnivå',
    7 => 'Email Adresse',
    8 => 'Hjemmeside',
    9 => '(ikke bruk mellomrom)',
    10 => 'Vennligst fyll ut feltene Brukernavn, Fullt Navn, Sikkerhetsnivå og Email Adresse',
    11 => 'Bruker Administrasjon',
    12 => 'For å endre eller slette en bruker, klikk på brukeren under. For å lage en ny  bruker klikk på Ny Bruker til venstre. Du kan foreta enkle søk ved å skrive inn deler av brukernavn, email adresse eller fullt navn (feks.*sen* or *.no) i søkefeltet under.',
    13 => 'SecLev',
    14 => 'Reg. Dato',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'lagre',
    21 => 'Brukernavnet du forsøke å lagre finnes allerede.',
    22 => 'Feil',
    23 => 'Masseimport',
    24 => 'Masseimportering av brukere',
    25 => 'Du kan importere en liste med brukere inn i Geeklog. Importfilen må være en tekstfil med felter adskilt med tab-tegn. Feltene må være i følgende rekkefølge: fullt navn, brukernavn, email adresse. Det må være kun en bruker per linje. Hver bruker du importerer vil få tilsendt en email med et tilfeldig passord. Dersom du ikke følger disse reglene vil det oppstå problemer som kan kreve manuelt arbeid, så det lønner seg å dobbeltsjekke importfilen!',
    26 => '',
    27 => '',
    28 => 'Kryss av her for å slette dette bildet',
    29 => 'Sti',
    30 => 'Importer',
    31 => 'Nye Brukere',
    32 => 'Prosessering ferdig. Importerte %d og %d feil oppsto',
    33 => 'start',
    34 => 'Feil: Du må angi en importfil.',
    35 => 'Sist innlogget',
    36 => '(aldri)',
    37 => 'UID',
    38 => 'Group Listing',
    39 => 'Password (again)',
    40 => 'Registration Date',
    41 => 'Last login Date',
    42 => 'Banned',
    43 => 'Awaiting Activation',
    44 => 'Awaiting Authorization',
    45 => 'Active',
    46 => 'User Status',
    47 => 'Edit',
    48 => 'Show Admin Groups',
    49 => 'Admin Group',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Note: "Online Days" is the number of days between the first registration and the last login.',
    53 => 'registered',
    54 => 'Batch Delete',
    55 => 'This only works if you have <code>$_CONF[\'lastlogin\'] = true;</code> in your config.php',
    56 => 'Please choose the type of user you want to delete and press "Update List". Then, uncheck those from the list you do not want to delete and press "Delete". Please note that you will only delete those that are currently visible in case the list spans over several pages.',
    57 => 'Phantom users',
    58 => 'Short-Time Users',
    59 => 'Old Users',
    60 => 'Users that registered more than ',
    61 => ' months ago, but never logged in.',
    62 => 'Users that registered more than ',
    63 => ' months ago, then logged in within 24 hours, but since then never came back to your site.',
    64 => 'Normal users, who simply did not visit your site since ',
    65 => ' months.',
    66 => 'Update List',
    67 => 'Months since registration',
    68 => 'Online Hours',
    69 => 'Offline Months',
    70 => 'could not be deleted',
    71 => 'sucessfully deleted',
    72 => 'No User selected for deletion',
    73 => 'Are You sure you want to permanently delete ALL selected users?',
    74 => 'Recent Users',
    75 => 'Users that registered in the last ',
    76 => ' months',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s',
    86 => 'Include',
    87 => 'Reminders'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Godkjenn',
    2 => 'Slett',
    3 => 'Rediger',
    4 => 'Profil',
    10 => 'Tittel',
    11 => 'Start Dato',
    12 => 'URL',
    13 => 'Kategori',
    14 => 'Dato',
    15 => 'Emne',
    16 => 'Brukernavn',
    17 => 'Fullt navn',
    18 => 'Email',
    34 => 'Kommando og Kontroll',
    35 => 'Artikkel innlegg',
    36 => 'Parent or Comment',
    37 => '',
    38 => 'Send inn',
    39 => 'Det er ingen innlegg å vurdere nå',
    40 => 'Bruker innlegg',
    41 => 'Comment Submissions',
    42 => 'User Name',
    43 => 'Auto-publish Comments?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} Mail verktøy",
    2 => 'Fra',
    3 => 'Svar-til',
    4 => 'Emne',
    5 => 'Innhold',
    6 => 'Send til:',
    7 => 'Alle brukere',
    8 => 'Admin',
    9 => 'Opsjoner',
    10 => 'HTML',
    11 => 'Viktig melding!',
    12 => 'Send',
    13 => 'Reset',
    14 => 'Ignorer brukerinstillinger',
    15 => 'Feil ved sending til: ',
    16 => 'Meldinger ble sendt til: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>Send en melding til</a>",
    18 => 'Til',
    19 => 'MERK: hvis du vil sende en melding til alle medlemmene, velg gruppen innloggede brukere (LOGGEDIN) fra nedtrekksmenyen.',
    20 => "<successcount> meldinger ble sendt og <failcount> meldinger feilet.  Detaljene for meldingene som feilet er nedenfor hvis du trenger dem. i motsatt fall kan du  <a href=\"{$_CONF['site_admin_url']}/mail.php\">sende en melding til</a> eller <a href=\"{$_CONF['site_admin_url']}/moderation.php\">gå tilbake til administrasjonssiden</a>.",
    21 => 'Feil',
    22 => 'Vellykkede',
    23 => 'Ingen feil',
    24 => 'Ingen vellykkede',
    25 => '-- Velg Gruppe --',
    26 => 'Vennligst fyll ut alle feltene i skjemaet og  velg en gruppe brukere fra nedtrekksmenyen.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Installasjon av plugins medfører en mulighet for skade påGeeklog installasjonen din og, muligens også systemet ditt. Det er viktig at du kun installerer plugins hentet fra <a href="http://www.geeklog.net" target="_blank">Geeklogs nettsted</a>. Vi tester alle plugins vi mottar grundig på mange forskjellige operativsystemer. Viktig: installasjon av en plugin krever utførelse av noen få systemkommandoer som kan medføre sikkerhetsproblemer særlig hvis du bruker plugins fra andre nettsteder. NB! Denne advarselen medfører ingen garanti for at installasjonen av en plugin vil gå smertefritt, ei heller tar vi ansvar for eventuell skade som følge av en installasjon. Med andre ord, installer på egen risiko. For den forsiktige så følger det instruksjoner for manuell installasjon med hver plugin.',
    2 => 'Advarsel for Plug-in Installasjon',
    3 => 'Plug-in Installasjonsskjema',
    4 => 'Plug-in Fil',
    5 => 'Plug-in Liste',
    6 => 'Advarsel: Plug-in er allerede installert!',
    7 => 'Den plug-in du forsøker å installere finnes allerede. Vennligst slett plug-in før du reinstallerer den',
    8 => 'Plugin kompatibilitetssjekk feilet',
    9 => 'Denne plug-in krever en nyere versjon av Geeklog. Du må enten oppgradere <a href="http://www.geeklog.net">Geeklog</a> eller bruke en nyere versjon av denne plug-in.',
    10 => '<br' . XHTML . '><b>Ingen plug-in er installert.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'For å redigere eller slette en plug-in, klikk på tallet til plug-in under. For å lære mer om en plug-in, klikk på plug-in navnet og du går til websiden til den plug-in. For å installere eller oppgradere en plug-in vennligst les dokumentasjonen for den aktuelle plug-in.',
    12 => 'plugineditor() kalt uten et plugin navn',
    13 => 'Plugin Editor',
    14 => 'Ny Plug-in',
    15 => 'Admin Hovedside',
    16 => 'Plug-in Navn',
    17 => 'Plug-in Versjon',
    18 => 'Geeklog Versjon',
    19 => 'Aktivisert',
    20 => 'Ja',
    21 => 'Nei',
    22 => 'Installer',
    23 => 'Lagre',
    24 => 'Avbryt',
    25 => 'Slett',
    26 => 'Plug-in Navn',
    27 => 'Plug-in Hjemmeside',
    28 => 'Plug-in Versjon',
    29 => 'Geeklog Versjon',
    30 => 'Slett Plug-in?',
    31 => 'Er du sikker på at du vil slette denne plug-in? Alle data og datastrukturer som brukes av denne plug-in vil også bli slettet. hvis du er sikker, klikk slett igjen nedenfor.',
    32 => '<p><b>Error AutoLink tag not correct format</b></p>',
    33 => 'Code Version',
    34 => 'Update',
    35 => 'Edit',
    36 => 'Code',
    37 => 'Data',
    38 => 'Update!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    99 => 'An unknown error occured',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'create feed',
    2 => 'save',
    3 => 'delete',
    4 => 'cancel',
    10 => 'Content Syndication',
    11 => 'New Feed',
    12 => 'Admin Home',
    13 => 'To modify or delete a feed, click on the feed\'s title below. To create a new feed, click on New Feed above.',
    14 => 'Title',
    15 => 'Type',
    16 => 'Filename',
    17 => 'Format',
    18 => 'last updated',
    19 => 'Enabled',
    20 => 'Yes',
    21 => 'No',
    22 => '<i>(no feeds)</i>',
    23 => 'all Stories',
    24 => 'Feed Editor',
    25 => 'Feed Title',
    26 => 'Limit',
    27 => 'Length of entries',
    28 => '(0 = no text, 1 = full text, other = limit to that number of chars.)',
    29 => 'Description',
    30 => 'Last Update',
    31 => 'Character Set',
    32 => 'Language',
    33 => 'Contents',
    34 => 'Entries',
    35 => 'Hours',
    36 => 'Select type of feed',
    37 => '',
    38 => 'Error: Missing Fields',
    39 => 'Please fill in the Feed Title, Description, and Filename.',
    40 => 'Please enter a  number of entries or number of hours.',
    41 => 'Links',
    42 => '',
    43 => 'All',
    44 => 'None',
    45 => 'Header-link in topic',
    46 => 'Limit Results',
    47 => 'Search',
    48 => 'Edit',
    49 => 'Feed Logo',
    50 => "Relative to site url ({$_CONF['site_url']})",
    51 => 'The filename you have chosen is already used by another feed. Please choose a different one.',
    52 => 'Error: existing Filename',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Passordet ditt er sendt på mail og du vil motta det hvert øyeblikk. Vennligst følg instruksjonene i meldingen. Takk for at du bruker {$_CONF['site_name']}",
    2 => "Takk for at du sendte inn artikkelen din til {$_CONF['site_name']}. Den er oversendt til vår stab for godkjenning. Hvis artikkelen din blir godkjent såp vil den bli publisert på nettstedet vårt slik at andre kan lese den.",
    3 => '',
    4 => '',
    5 => 'Kontoinformasjonen din ble lagret.',
    6 => 'Dine visningsvalg ble lagret.',
    7 => 'Dine kommentarvalg ble lagret.',
    8 => 'Du er logget ut.',
    9 => 'Din artikkel ble lagret.',
    10 => 'Artikkelen ble slettet.',
    11 => 'Blokken din ble lagret.',
    12 => 'Blokken ble slettet.',
    13 => 'Ditt emne ble lagret.',
    14 => 'Emnet og alle tilhørende artikler og blokker ble slettet.',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Den nye brukeren ble lagret.',
    22 => 'Brukeren ble slettet',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Meldingen ble sendt.',
    28 => 'Plug-in ble lagret',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => 'Adgang Nektet',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Systemmelding',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Plug-in installert!',
    45 => 'Plug-in slettet.',
    46 => '',
    47 => 'Denne funksjonen virker kun under *nix. Hvis operativsystemet du kjører på er *nix så er din cache tømt. Hvis du kjører på windows må du søke etter filer som heter adodb_*.php og slette dem manuelt.',
    48 => "Takk for din søknad om medlemsskap hos {$_CONF['site_name']}. Teamet vårt vil vurdere søknaden din. Hvis søknaden din blir godkjent, blir passordet ditt sendt til mailadressen du nettopp oppga.",
    49 => 'Gruppen ble lagret.',
    50 => 'Gruppen ble slettet.',
    51 => 'Dette brukernavnet er allerede i bruk. Vennligst velg et annet brukernavn.',
    52 => 'emailadressen du har gitt ser ut til å være en ugyldig email adresse.',
    53 => 'Ditt nye passord er akseptert. Vennligst logg inn med det nye passordet under nå.',
    54 => 'Din forespørsel om et nytt passord er for gammel. Vennligst prøv på nytt under.',
    55 => 'En enail er sendt til deg og burde dukke opp i innboksen din hvert øyeblikk. vennligst følg instruksjonene i meldingen for å endre passordet på kontoen din.',
    56 => 'Den angitte emailadressen er allerede i bruk for en annen konto.',
    57 => 'kontoen din er slettet.',
    58 => 'Your feed has been successfully saved.',
    59 => 'The feed has been successfully deleted.',
    60 => 'The plugin was successfully updated',
    61 => 'Plugin %s: Unknown message placeholder',
    62 => 'The trackback comment has been deleted.',
    63 => 'An error occurred when deleting the trackback comment.',
    64 => 'Your trackback comment has been successfully sent.',
    65 => 'Weblog directory service successfully saved.',
    66 => 'The weblog directory service has been deleted.',
    67 => 'The new password does not match the confirmation password!',
    68 => 'You have to enter the correct current password.',
    69 => 'Your account has been blocked!',
    70 => 'Your account is awaiting administrator approval.',
    71 => 'Your account has now been confirmed and is awaiting administrator approval.',
    72 => 'An error occured while attempting to install the plugin. See error.log for details.',
    73 => 'An error occured while attempting to uninstall the plugin. See error.log for details.',
    74 => 'The pingback has been successfully sent.',
    75 => 'Trackbacks must be sent using a POST request.',
    76 => 'Do you really want to delete this item?',
    77 => 'WARNING:<br' . XHTML . '>You have set your default encoding to UTF-8. However, your server does not support multibyte encodings. Please install mbstring functions for PHP or choose a different character set/language.',
    78 => 'Please make sure that the email address and the confirmation email address are the same.',
    79 => 'The page you have been trying to open refers to a function that no longer exists on this site.',
    80 => 'The plugin that created this feed is currently disabled. You will not be able to edit this feed until you re-enable the parent plugin.',
    81 => 'You may have mistyped your login credentials.  Please try logging in again below.',
    82 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    83 => 'To change your password, email address, or for how long to remember you, please enter your current password.',
    84 => 'To delete your account, please enter your current password.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit stories.',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Adgang',
    'ownerroot' => 'Eier/Root',
    'group' => 'Gruppe',
    'readonly' => 'Kun-lese',
    'accessrights' => 'Adgangsrettigheter',
    'owner' => 'eier',
    'grantgrouplabel' => 'Gi ovenstående gruppe redigeringsrettigheter',
    'permmsg' => 'MERK: medlemmer er alle innloggede medlemmer av nettstedet og anonyme er alle brukere på nettstedet som ikke er logget inn.',
    'securitygroups' => 'Sikkerhetsgrupper',
    'editrootmsg' => "Selv om du er en Brukeradministrator, så kan du ikke redigere en root bruker uten at du selv er en root bruker. Du kan redigere alle andre brukere unntatt root brukere. Vennligst legg merke til at alle forsøk på ulovlig redigering av root brukere blir logget. Vennligst gå tilbake til <a href=\"{$_CONF['site_admin_url']}/user.php\">Bruker administrasjon</a>.",
    'securitygroupsmsg' => 'Kryss av for gruppene du vil at brukeren skal tilhøre.',
    'groupeditor' => 'Gruppe Editor',
    'description' => 'Beskrivelse',
    'name' => 'Navn',
    'rights' => 'Rettigheter',
    'missingfields' => 'Manglende felter',
    'missingfieldsmsg' => 'Du må angi et navn og en beskrivelse for en gruppe',
    'groupmanager' => 'Gruppe Administrasjon',
    'newgroupmsg' => 'For å endre eller slette en gruppe, klikk på gruppen under. For å lage en ny gruppe klikk på ny gruppe ovenfor. Legg merke til at core grupper ikke kan slettes fordi de brukes av systemet.',
    'groupname' => 'Gruppenavn',
    'coregroup' => 'Core gruppe',
    'yes' => 'Ja',
    'no' => 'Nei',
    'corerightsdescr' => "Dette er en core (innebygd) {$_CONF['site_name']} gruppe. Rettighetene for denne gruppen kan ikke redigeres. Nedenfor er en liste over de rettigheter denne gruppen har.",
    'groupmsg' => 'Sikkerhetsgrupper på dette nettstedet er hierarkiske.  Hvis du legger denne gruppen til en av gruppene under gir du denne gruppen samme rettigheter som de gruppene har. Det anbefales at du bruker gruppene under for å gi rettigheter til en gruppe så langt det er mulig. dersom denne gruppen trenger mer spesifikke rettigheter så kan du velge disse fra \'Rettigheter\' nedenfor. For å legge denne gruppen til en av de andre gruppene under, kryss av for de gruppene du ønsker.',
    'coregroupmsg' => "Dette er en core {$_CONF['site_name']} gruppe. Gruppene som denne gruppen hører til kan ikke redigeres. Under er en liste over grupper som denne gruppen hører til.",
    'rightsdescr' => 'En rettighet kan gis direkte til gruppen, ELLER til en annen gruppe som denne gruppen er medlem av. Rettighetene under som ikke er avkrysset er de som denne gruppen har fått som medlem av en annen gruppe. Rettighetene som er avkryyset er rettigheter som er gitt direkte til denne gruppen.',
    'lock' => 'Lås',
    'members' => 'Medlemmer',
    'anonymous' => 'Anonym',
    'permissions' => 'Rettigheter',
    'permissionskey' => 'R = lese, E = rediger, redigeringsrettighet medfører leserettighet',
    'edit' => 'Rediger',
    'none' => 'Ingen',
    'accessdenied' => 'Adgang Nektet',
    'storydenialmsg' => "Du har ikke adgang til å se denne artikkelen. Dette kan skyldes at du ikke er medlem av {$_CONF['site_name']}. Vennligst <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\"> bli medlem</a> av {$_CONF['site_name']} for å oppnå full tilgang!",
    'nogroupsforcoregroup' => 'Denne gruppen hører ikke til noen av de andre gruppene',
    'grouphasnorights' => 'Denne gruppen har ikke tilgang til administrative funksjoner på dette nettstedet',
    'newgroup' => 'Ny Gruppe',
    'adminhome' => 'Admin Hovedside',
    'save' => 'lagre',
    'cancel' => 'avbryt',
    'delete' => 'slett',
    'canteditroot' => 'Du har forsøkt å redigere Root gruppen uten selv å være medlem av Root gruppen, tilgangen er derfor nektet. Vennligst kontakt administratoren til nettstedet hvis du mener dette er en feil',
    'listusers' => 'Liste Brukere',
    'listthem' => 'list',
    'usersingroup' => 'Brukere i gruppe %s',
    'usergroupadmin' => 'User Group Administration',
    'add' => 'Add',
    'remove' => 'Remove',
    'availmembers' => 'Available Members',
    'groupmembers' => 'Group Members',
    'canteditgroup' => 'To edit this group, you have to be a member of the group. Please contact the system administrator if you feel this is an error.',
    'cantlistgroup' => 'To see the members of this group, you have to be a member yourself. Please contact the system administrator if you feel this is an error.',
    'editgroupmsg' => 'To modify the group membership, click on the member names(s) and use the add or remove buttons. If the member is a member of the group, their name will appear on the right side only. Once you are complete - press <b>Save</b> to update the group and return to the main group admin page.',
    'listgroupmsg' => 'Listing of all current members in the group: <b>%s</b>',
    'search' => 'Search',
    'submit' => 'Submit',
    'limitresults' => 'Limit Results',
    'group_id' => 'Group ID',
    'plugin_access_denied_msg' => 'You are illegally trying access a plugin administration page.  Please note that all attempts to illegally access this page are logged.',
    'groupexists' => 'Group name already exists',
    'groupexistsmsg' => 'There is already a group with this name. Group names must be unique.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'Siste 10 Backups',
    'do_backup' => 'Ta Backup',
    'backup_successful' => 'Backup av databasen var vellykket.',
    'db_explanation' => 'For å ta en backup av ditt Geeklog system, klikk knappen nedenfor',
    'not_found' => "Feil sti eller mysqldump er ikke kjørbar.<br" . XHTML . ">Sjekk <strong>\$_DB_mysqldump_path</strong> definisjonen i config.php.<br" . XHTML . ">Variabelen er nå satt til: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Backup feilet: størrelsen på backupfilen var 0 bytes',
    'path_not_found' => "{$_CONF['backup_path']} finnes ikke eller er ikke en katalog",
    'no_access' => "FEIL: Katalogen {$_CONF['backup_path']} er ikke tilgjengelig.",
    'backup_file' => 'Backup fil',
    'size' => 'Størrelse',
    'bytes' => 'Bytes',
    'total_number' => 'Totalt antall backups: %d',
    'download' => 'Click to download this file'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Hjem',
    2 => 'Kontakt',
    3 => 'Bli Publisert',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Nettsted statistikk',
    8 => 'Personaliser',
    9 => 'Søk',
    10 => 'avansert søk',
    11 => 'Directory'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Error',
    2 => 'Jøss, jeg har sett overalt men kan ikke finne <b>%s</b>.',
    3 => "<p>vi beklager, men filen du har bedt om finnes ikke. Sjekk gjerne <a href=\"{$_CONF['site_url']}\">hovedsiden</a> eller <a href=\"{$_CONF['site_url']}/search.php\">søkesiden</a> for å se om du finner det du har mistet."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Innlogging påkrevd',
    2 => 'Beklager, du må være innlogget for å få adgang til dette området.',
    3 => 'Logg inn',
    4 => 'Ny Bruker'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'from',
    'tracked_on' => 'Tracked on',
    'read_more' => '[read more]',
    'intro_text' => 'Here\'s what others have to say about \'%s\':',
    'no_comments' => 'No trackback comments for this entry.',
    'this_trackback_url' => 'Trackback URL for this entry:',
    'num_comments' => '%d trackback comments',
    'send_trackback' => 'Send Pings',
    'preview' => 'Preview',
    'editor_title' => 'Send trackback comment',
    'trackback_url' => 'Trackback URL',
    'entry_url' => 'Entry URL',
    'entry_title' => 'Entry Title',
    'blog_name' => 'Site Name',
    'excerpt' => 'Excerpt',
    'truncate_warning' => 'Note: The receiving site may truncate your excerpt',
    'button_send' => 'Send',
    'button_preview' => 'Preview',
    'send_error' => 'Error',
    'send_error_details' => 'Error when sending trackback comment:',
    'url_missing' => 'No Entry URL',
    'url_required' => 'Please enter at least a URL for the entry.',
    'target_missing' => 'No Trackback URL',
    'target_required' => 'Please enter a trackback URL',
    'error_socket' => 'Could not open socket.',
    'error_response' => 'Response not understood.',
    'error_unspecified' => 'Unspecified error.',
    'select_url' => 'Select Trackback URL',
    'not_found' => 'Trackback URL not found',
    'autodetect_failed' => 'Geeklog could not detect the Trackback URL for the post you want to send your comment to. Please enter it manually below.',
    'trackback_explain' => 'From the links below, please select the URL you want to send your Trackback comment to. Geeklog will then try to determine the correct Trackback URL for that post. Or you can <a href="%s">enter it manually</a> if you know it already.',
    'no_links_trackback' => 'No links found. You can not send a Trackback comment for this entry.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback results',
    'send_pings' => 'Send Pings',
    'send_pings_for' => 'Send Pings for "%s"',
    'no_links_pingback' => 'No links found. No Pingbacks were sent for this entry.',
    'pingback_success' => 'Pingback sent.',
    'no_pingback_url' => 'No pingback URL found.',
    'resend' => 'Resend',
    'ping_all_explain' => 'You can now notify the sites you linked to (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), advertise that your site has been updated by pinging weblog directory services, or send a <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> comment in case you wrote about a post on someone else\'s site.',
    'pingback_button' => 'Send Pingback',
    'pingback_short' => 'Send Pingbacks to all sites linked from this entry.',
    'pingback_disabled' => '(Pingback disabled)',
    'ping_button' => 'Send Ping',
    'ping_short' => 'Ping weblog directory services.',
    'ping_disabled' => '(Ping disabled)',
    'trackback_button' => 'Send Trackback',
    'trackback_short' => 'Send a Trackback comment.',
    'trackback_disabled' => '(Trackback disabled)',
    'may_take_a_while' => 'Please note that sending Pingbacks and Pings may take a while.',
    'ping_results' => 'Ping results',
    'unknown_method' => 'Unknown ping method',
    'ping_success' => 'Ping sent.',
    'error_site_name' => 'Please enter the site\'s name.',
    'error_site_url' => 'Please enter the site\'s URL.',
    'error_ping_url' => 'Please enter a valid Ping URL.',
    'no_services' => 'No weblog directory services configured.',
    'services_headline' => 'Weblog Directory Services',
    'service_explain' => 'To modify or delete a weblog directory service, click on the edit icon of that service below. To add a new weblog directory service, click on "Create New" above.',
    'service' => 'Service',
    'ping_method' => 'Ping method',
    'service_website' => 'Website',
    'service_ping_url' => 'URL to ping',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Extended Ping',
    'ping_unknown' => '(unknown method)',
    'edit_service' => 'Edit Weblog Directory Service',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Prepare your trackback comment for <a href="%s">%s</a>.',
    'editor_intro_none' => 'Prepare your trackback comment.',
    'trackback_note' => 'To send a trackback comment for a story, go to the list of stories and click on "Send Ping" for the story. To send a trackback that is not related to a story, <a href="%s">click here</a>.',
    'pingback_explain' => 'Enter a URL to send the Pingback to. The pingback will point to your site\'s homepage.',
    'pingback_url' => 'Pingback URL',
    'site_url' => 'This site\'s URL',
    'pingback_note' => 'To send a pingback for a story, go to the list of stories and click on "Send Ping" for the story. To send a pingback that is not related to a story, <a href="%s">click here</a>.',
    'pbtarget_missing' => 'No Pingback URL',
    'pbtarget_required' => 'Please enter a pingback URL',
    'pb_error_details' => 'Error when sending the pingback:',
    'delete_trackback' => 'To delete this Trackback click: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Article Directory',
    'title_year' => 'Article Directory for %d',
    'title_month_year' => 'Article Directory for %s %d',
    'nav_top' => 'Back to Article Directory',
    'no_articles' => 'No articles.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_bak' => 'Failed to create a temporary file in your data directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n new %i in the last %t %s',
    'new_last' => 'last %t %s',
    'minutes' => 'minutes',
    'hours' => 'hours',
    'days' => 'days',
    'weeks' => 'weeks',
    'months' => 'months',
    'minute' => 'minute',
    'hour' => 'hour',
    'day' => 'day',
    'week' => 'week',
    'month' => 'month'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Januar',
    2 => 'Februar',
    3 => 'Mars',
    4 => 'April',
    5 => 'Mai',
    6 => 'Juni',
    7 => 'Juli',
    8 => 'August',
    9 => 'September',
    10 => 'Oktober',
    11 => 'November',
    12 => 'Desember'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Søndag',
    2 => 'Mandag',
    3 => 'Tirsdag',
    4 => 'Onsdag',
    5 => 'Torsdag',
    6 => 'Fredag',
    7 => 'Lørdag'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Search',
    'limit_results' => 'Limit Results',
    'submit' => 'Submit',
    'edit' => 'Edit',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Admin Home',
    'create_new' => 'Create New',
    'create_new_adv' => 'Create New (Adv.)',
    'enabled' => 'Enabled',
    'title' => 'Title',
    'type' => 'Type',
    'topic' => 'Topic',
    'help_url' => 'Help File URL',
    'save' => 'Save',
    'cancel' => 'Cancel',
    'delete' => 'Delete',
    'delete_sel' => 'Delete selected',
    'copy' => 'Copy',
    'no_results' => '- No entries found -',
    'data_error' => 'There was an error processing the subscription data. Please check the data source.',
    'preview' => 'Preview',
    'records_found' => 'Records found',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'na' => 'N/A'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Comments Enabled',
    -1 => 'Comments Disabled',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => 'Flat',
    'nested' => 'Nested',
    'threaded' => 'Threaded',
    'nocomment' => 'No Comments'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 Hour',
    7200 => '2 Hours',
    10800 => '3 Hours',
    28800 => '8 Hours',
    86400 => '1 Day',
    604800 => '1 Week',
    2678400 => '1 Month'
);

$LANG_dateformats = array(
    0 => 'System Default'
);

$LANG_featurecodes = array(
    0 => 'Not Featured',
    1 => 'Featured'
);

$LANG_frontpagecodes = array(
    0 => 'Show Only in Topic',
    1 => 'Show on Front Page'
);

$LANG_postmodes = array(
    'plaintext' => 'Plain Old Text',
    'html' => 'HTML Formatted'
);

$LANG_sortcodes = array(
    'ASC' => 'Oldest First',
    'DESC' => 'Newest First'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback Enabled',
    -1 => 'Trackback Disabled'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Save Changes',
    'reset_form' => 'Reset Form',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Configuration Manager',
    'disable' => 'Click to disable this option',
    'enable' => 'Enable'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Configuration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Path',
    'site_url' => 'Site URL',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'site_name' => 'Site Name',
    'site_slogan' => 'Slogan',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Log',
    'path_language' => 'Language',
    'backup_path' => 'Backup',
    'path_data' => 'Data',
    'path_images' => 'Images',
    'path_pear' => 'Path Pear',
    'have_pear' => 'Have Pear?',
    'mail_settings' => 'Mail Settings',
    'allow_mysqldump' => 'Allow MySQL Dump',
    'mysqldump_path' => 'Path of Executable',
    'mysqldump_options' => 'MySQL Dump Options',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Menu Elements',
    'path_themes' => 'Themes Path',
    'disable_new_user_registration' => 'Disable New Registrations',
    'allow_user_themes' => 'Allow User Themes',
    'allow_user_language' => 'Allow User Language',
    'allow_user_photo' => 'Allow User Photo',
    'allow_username_change' => 'Allow Username Changes',
    'allow_account_delete' => 'Allow Account Deletion',
    'hide_author_exclusion' => 'Allow Hide Author',
    'show_fullname' => 'Show Fullname',
    'show_servicename' => 'Show Service Name',
    'custom_registration' => 'Enable Custom Registration',
    'user_login_method' => 'User Login Method',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Sort Links',
    'language' => 'Language',
    'locale' => 'Locale',
    'date' => 'Date Format',
    'daytime' => 'Daytime Format',
    'shortdate' => 'Short Date Format',
    'dateonly' => 'Date Only Format',
    'timeonly' => 'Time Only Format',
    'week_start' => 'Week Start',
    'hour_mode' => 'Hour Mode',
    'thousand_separator' => 'Thousands Separator',
    'decimal_separator' => 'Decimal Separator',
    'decimal_count' => 'Decimal Count',
    'language_files' => 'Language Files',
    'languages' => 'Languages',
    'timezone' => 'Timezone',
    'site_disabled_msg' => 'Site Disabled Message or URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Timezone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Cookies embed IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Record Last Login?',
    'num_search_results' => 'Number of Search Results',
    'loginrequired' => 'Login Required?',
    'submitloginrequired' => 'Submit Login Required?',
    'commentsloginrequired' => 'Comment Login Required?',
    'statsloginrequired' => 'Stats Login Required?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Story Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Story Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Stories?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'wikitext_editor' => 'Wikitext Editor?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Story Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Stories',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Stories Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Stories',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Max Images per Article',
    'limitnews' => 'Stories per Page',
    'minnews' => 'Min. Stories per Page',
    'contributedbyline' => 'Show "Contributed By"?"',
    'hideviewscount' => 'Hide Views Count?',
    'hideemailicon' => 'Hide E-Mail Icon?',
    'hideprintericon' => 'Hide Print Icon?',
    'allow_page_breaks' => 'Allow Page Breaks?',
    'page_break_comments' => 'Comments on Multi-Page Articles',
    'article_image_align' => 'Topic Icon Alignment',
    'show_topic_icon' => 'Show Topic Icon?',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'After Saving Story',
    'aftersave_user' => 'After Saving User',
    'show_right_blocks' => 'Always Show Right Blocks?',
    'showfirstasfeatured' => 'Show First Story as Featured?',
    'backend' => 'Enable Feeds?',
    'rdf_file' => 'Syndication Output Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Length of Stories in Feed',
    'rdf_language' => 'Feed Language',
    'syndication_max_headlines' => 'Max. Number of Headlines (portal blocks)',
    'copyrightyear' => 'Copyright Year',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating Allowed',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_code' => 'Comment Default',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autolinks?',
    'clickable_links' => 'Make URLs clickable?',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Enable URL Rewrite',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Story Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Stories in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent stories enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Stories and Trackback',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Users and Submissions',
    'sg_images' => 'Images',
    'sg_locale' => 'Languages and Locale',
    'sg_misc' => 'Miscellaneous'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Paths',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Users',
    'fs_misc' => 'Miscellaneous',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Language',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Login Settings',
    'fs_search' => 'Search',
    'fs_user_submission' => 'User Submission',
    'fs_submission' => 'Submission Settings',
    'fs_topics_block' => 'Topics Block',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'What\'s New Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Story',
    'fs_theme_advanced' => 'Advanced Settings',
    'fs_syndication' => 'Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images in Articles',
    'fs_topicicon' => 'Topic Icons',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Comments',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Story Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => '')
);

?>