<?php

###############################################################################
# ukrainian.php
# This is the ukrainian language page for GeekLog!
#
#
# Ukrainian language is so rich and versatile! 
# Please, email me your comments and suggestions
#
#
# Copyright (C) 2006 Vitaliy Biliyenko
# v.lokki@gmail.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'UTF-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Надіслав(ла):',
    2 => 'читати далі',
    3 => 'коментарі',
    4 => 'Редагувати',
    5 => 'Голосувати',
    6 => 'Результати',
    7 => '',
    8 => 'голос(и,ів)',
    9 => 'Функції адміністратора:',
    10 => 'Редактор сайту',
    11 => 'Статті',
    12 => 'Блоки',
    13 => 'Теми',
    14 => '',
    15 => '',
    16 => '',
    17 => 'Користувачі',
    18 => 'Запит SQL',
    19 => 'Завершити сеанс',
    20 => 'Інформація про користувача:',
    21 => 'Ім\'я користувача',
    22 => 'ID користувача',
    23 => 'Рівень захисту',
    24 => 'Анонім',
    25 => 'Відповісти',
    26 => 'Думки адміністрації сайту можуть не співпадати із думками коментаторів. Сайт не несе відповідальності за зміст коментарів.',
    27 => 'Найсвіжіші повідомлення',
    28 => 'Вилучити',
    29 => 'Немає коментарів.',
    30 => 'Попередні статті',
    31 => 'Дозволені теги HTML:',
    32 => 'Помилка: неправильне ім\'я користувача',
    33 => 'Помилка: неможливий запис до журнального файлу',
    34 => 'Помилка',
    35 => 'Вийти з системи',
    36 => 'увімкнено',
    37 => 'Немає статей користувачів',
    38 => 'Експорт контенту',
    39 => 'Оновити',
    40 => 'У вашому <tt>php.ini</tt> встановлено <tt>register_globals = Off</tt>. Проте Geeklog потребує встановлення <tt>register_globals</tt> в <strong>on</strong>. Перш ніж продовжувати, будь-ласка, встановіть цю директиву в <strong>on</strong> і перезапустіть ваш вебсервер.',
    41 => 'Гості',
    42 => 'Автор:',
    43 => 'Відповісти',
    44 => 'Вгору',
    45 => 'Номер помилки MySQL',
    46 => 'Повідомлення про помилку MySQL',
    47 => 'Функцiї користувача',
    48 => 'Мій обліковий запис',
    49 => 'Налаштування',
    50 => 'Помилка у виразі SQL',
    51 => 'довідка',
    52 => 'Створити',
    53 => 'Адміністрування',
    54 => 'Неможливо відкрити файл.',
    55 => 'Помилка у',
    56 => 'Проголосувати',
    57 => 'Пароль',
    58 => 'Логін',
    59 => "Ви ще не зареєструвалися? Зробіть це як <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">новий користувач</a>",
    60 => 'Надіслати коментар',
    61 => 'Створити новий обліковий запис',
    62 => 'слова',
    63 => 'Налаштування коментарів',
    64 => 'Відіслати статтю другу поштою',
    65 => 'Перегляд версії для друку',
    66 => '',
    67 => 'Ласкаво просимо до ',
    68 => 'Додому',
    69 => 'Контакт',
    70 => 'Пошук',
    71 => 'Публікація',
    72 => 'Веб ресурси',
    73 => '',
    74 => '',
    75 => 'Розширений пошук',
    76 => 'Статистика сайту',
    77 => 'Модулі',
    78 => '',
    79 => 'Що нового',
    80 => 'статей за останні',
    81 => 'стаття за останні',
    82 => 'годин(и)',
    83 => 'Коментарi',
    84 => '',
    85 => 'за останні 48 годин',
    86 => 'Немає нових коментарів',
    87 => 'за останні 2 тижні',
    88 => '',
    89 => '',
    90 => 'Головна',
    91 => 'Сторінку створено за',
    92 => 'секунд',
    93 => 'Авторське право',
    94 => 'Всі торгові марки і авторські права на цій сторінці належать відповідним власникам.',
    95 => 'Створений за допомогою',
    96 => 'Групи',
    97 => 'Список слів',
    98 => 'Модулі',
    99 => 'Статті',
    100 => 'Немає нових статтей',
    101 => '',
    102 => '',
    103 => 'Копії бази даних',
    104 => 'від',
    105 => 'Надіслати пошту',
    106 => 'Переглянуто',
    107 => 'Тест версії Geeklog',
    108 => 'Очистити кеш',
    109 => 'Доповісти про образу',
    110 => 'Доповісти про цей пост адміністратору',
    111 => 'Переглянути PDF-версію',
    112 => 'Зареєстровані користувачі',
    113 => 'Документація',
    114 => 'Трекбеки',
    115 => 'Нема нових трекбек-коментарів',
    116 => 'Трекбек',
    117 => 'Архів',
    118 => 'Будь-ласка, продовжуйте читати на наступній сторінці:',
    119 => "Забули <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">пароль</a>?",
    120 => 'Постійне посилання на цей коментар',
    121 => 'Коментарі (%d)',
    122 => 'Трекбеки (%d)',
    123 => 'Весь HTML дозволено',
    124 => 'Натисніть щоб вилучити всі відмічені елементи',
    125 => 'Ви впевнені, що хочете вилучити всі відмічені елементи?',
    126 => 'Виділити/зняти виділення з усіх елементів',
    127 => 'Permalink',
    128 => 'Login with OpenID:',
    129 => 'Configuration',
    130 => 'Webservices'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Надіслати коментар',
    2 => 'Режим публікації',
    3 => 'Вийти',
    4 => 'Створити обліковий запис',
    5 => 'Ім\'я користувача',
    6 => 'Перш ніж надіслати коментар, слід увійти до системи.  Створіть новий обліковий запис, якщо ви ще не зареєстровані.',
    7 => 'Ваш останній коментар був ',
    8 => " секунд тому. Перепрошуємо, але між коментарями має минути щонаймеше  {$_CONF['commentspeedlimit']} секунд",
    9 => 'Коментар',
    10 => 'Відіслати звіт',
    11 => 'Надіслати коментар',
    12 => 'Будь-ласка, заповніть поля Заголовок та Коментар, це є необхідним для публікації вашого коментаря.',
    13 => 'Ваша інформація',
    14 => 'Попередній перегляд',
    15 => 'Доповісти про цей пост',
    16 => 'Заголовок',
    17 => 'Помилка',
    18 => 'Важливий матеріал',
    19 => 'Будь-ласка, дотримуйтесь теми повідомлення.',
    20 => 'Намагайтеся відповідати на коментарі інших людей замість створення нового обговорення.',
    21 => 'Для уникнення повторень, прочитайте повідомлення інших людей перед тим, як відправляти власне.',
    22 => 'Використовуйте заголовок, який би точно передав зміст повідомлення.',
    23 => 'Ваша поштова адреса НЕ буде опублікована.',
    24 => 'Анонімний користувач',
    25 => 'Ви впевнені, що хочете доповісти про цей пост адміністратору?',
    26 => '%s доповів про наступний образливий коментар:',
    27 => 'Доповідь про образу'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Профіль користувача для',
    2 => 'Ім\'я користувача',
    3 => 'Повне ім\'я',
    4 => 'Новий пароль',
    5 => 'Електронна адреса',
    6 => 'Домашня сторінка',
    7 => 'Біографія',
    8 => 'Ключ PGP',
    9 => 'Зберегти інформацію',
    10 => 'Останні 10 коментарів користувача',
    11 => 'Немає коментарів користувача',
    12 => 'Налаштування користувача',
    13 => 'Надсилати щоденний дайджест поштою',
    14 => 'Згенеровано випадковий пароль. Рекомендовано змінити його негайно. Увійдіть до системи і оберіть пункт "Мій обліковий запис" з Функцій користувача.',
    15 => "Ваш обліковий запис на {$_CONF['site_name']} успішно створено. Для його використання увійдіть до системи використовуючи вказані ім'я та пароль. Будь-ласка, збережіть повідомлення з паролем, щоб скористатися ним у разі необхідності.",
    16 => 'Ваш обліковий запис',
    17 => 'Облікового запису не існує',
    18 => 'Вказано неправильну електронну адресу',
    19 => 'Вказана електронна адреса чи ім\'я користувача вже існують',
    20 => 'Вказано неправильну електронну адресу',
    21 => 'Помилка',
    22 => "Зареєструватися на {$_CONF['site_name']}!",
    23 => "Реєстрація в нашій системі надасть вам всі переваги членства на {$_CONF['site_name']} і дозволить відправляти коментарі та публіковувати статті під своїм ім'ям. Якщо Ви не зареєструєтесь, всі Ваші публікації будуть анонімними. Зауважте, що ваша електронну адресу <b><i>ніколи</i></b> не буде публічно відображено на цьому сайті.",
    24 => 'Пароль буде відправлено за вказаною адресою.',
    25 => 'Забули пароль?',
    26 => 'Введіть <em>або</em> ваш логін, <em>або</em> електронну адресу, використану вами для реєстрації і натисніть Надіслати пароль. Інструкції зі встановлення нового пароля буде надіслано на електронну адресу.',
    27 => 'Зареєструватися зараз!',
    28 => 'Надіслати пароль',
    29 => 'вийшли з',
    30 => 'ввійшли з',
    31 => 'Перш ніж скористатися цією функцією, увійдіть в систему',
    32 => 'Підпис',
    33 => 'Ніколи публічно не відображається',
    34 => 'Це Ваше справжнє ім\'я',
    35 => 'Введіть новий пароль, якщо бажаєте його змінити',
    36 => 'Повинна починатися з http://',
    37 => 'Застосовується до коментарів',
    38 => 'Інформація про вас, доступна всім користувачам',
    39 => 'Публічний ключ PGP для розповсюдження',
    40 => 'Без малюнків тем',
    41 => 'Бажаєте модерувати',
    42 => 'Формат дати',
    43 => 'Максимальна кількість статтей',
    44 => 'Без блоків',
    45 => 'Налаштування відображення для',
    46 => 'Ігноровані елементи для',
    47 => 'Конфігурація блоку новин для',
    48 => 'Теми',
    49 => 'Не відображати іконки в статтях',
    50 => 'Зніміть виділення, якщо вам це не потрібно',
    51 => 'Відображати лише новини',
    52 => 'За замовчуванням',
    53 => 'Отримувати щовечора статті за день',
    54 => 'Відмітьте теми і авторів, яких ви не хочете бачити.',
    55 => 'Якщо ви нічого не відмітили, це означає, що ви обрали вибір за замовчуванням. Якщо ви відмітили деякі пункти, то не забудьте обрати все, що ви хочете, оскільки вибір за замовчуванням буде проігноровано. Вибір за замовчуванням виділено напівжирним шрифтом.',
    56 => 'Автори',
    57 => 'Режим відображення',
    58 => 'Порядок сортування',
    59 => 'Обмеження коментарів',
    60 => 'Як ви хочете відображати свої коментарі?',
    61 => 'Від нових до старіших чи навпаки?',
    62 => 'За замовчуванням 100',
    63 => "Пароль було відправлено вам на електронну пошту. Будь-ласка, виконуйте вказівки у повідомленні. Дякуємо вам за використання {$_CONF['site_name']}",
    64 => 'Налаштування коментарів для',
    65 => 'Спробуйте ще раз увійти до системи',
    66 => 'Можливо ви неправильно ввели свої дані. Будь-ласка, спробуйте ще раз.',
    67 => 'Зареєстровано',
    68 => 'Запам\'ятати мене на',
    69 => 'Як довго ми повинні пам\'ятати вас після вашого входу в систему?',
    70 => "Налаштуйте під себе вигляд і зміст {$_CONF['site_name']}",
    71 => "На нашому сайті Ви можете налаштувати зміст інформації, яку Ви отримуєте, а також вигляд цієї інформації. Щоб скористатися цими можливостями, Ви повинні спочатку <a href=\"{$_CONF['site_url']}/users.phpіmode=new\" rel=\"nofollow\">зареєструватися</a> на {$_CONF['site_name']}.  Ви зареєстровані?  Тоді використовуйте форму ліворуч для входу в систему!",
    72 => 'Тема дизайну',
    73 => 'Мова',
    74 => 'Змініть вигляд сайту!',
    75 => 'Отримувані поштою теми для',
    76 => 'Якщо ви вибирете тему із списку, то зможете отримувати статті, які відсилаються до цієї теми в кінці кожного дня. Виберіть тільки ті теми, які вас цікавлять!',
    77 => 'Фото',
    78 => 'Додати свою фотокартку!',
    79 => 'Щоб вилучити малюнок, клацніть тут',
    80 => 'Увійти',
    81 => 'Надіслати пошту',
    82 => 'Останні 10 статтей для користувача',
    83 => 'Статистика активності для користувача',
    84 => 'Кількість статтей:',
    85 => 'Кількість коментарів:',
    86 => 'Знайти всi надходження вiд',
    87 => 'Ваш логін',
    88 => "Хтось (можливо ви) замовив новий пароль для вашого облікового запису \"%s\" на {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nЯкщо ви справді хочете цього, будь-ласка, натисніть наступне посилання:\n\n",
    89 => "Якщо Ви не бажаєте цього, проігноруйте це повідомлення і запит буде відхилено (ваш пароль залишиться незміненим). \n\n",
    90 => 'Ви можете ввести новий пароль нижче. Будь-ласка, зверніть увагу на те, що ваш старий пароль залишиться дійсним до відправлення цієї форми.',
    91 => 'Встановити новий пароль',
    92 => 'Ввести новий пароль',
    93 => 'Ваш останній запит про новий пароль був %d секунд тому. Система потребує принаймні %d секунд між запитами про новий пароль.',
    94 => 'Вилучити обліковий запис "%s"',
    95 => 'Оберіть "Вилучити обліковий запис", щоб вилучити вас із нашої бази даних. Зауважте, що усі коментарі, надіслані вами під цим логіном <strong>не</strong> буде вилучено, а підписано іменем "Анонім".',
    96 => 'вилучити обліковий запис',
    97 => 'Підтвердіть вилучення користувача',
    98 => 'Ви впевнені, що бажаєте вилучити облікови запис? Зробивши це, ви не зможете увійти на сайт знову (якщо не зареєструєтесь ще раз). Якщо ви впевнені, натисніть "вилучити користувача" знову.',
    99 => 'Налаштування приватності для',
    100 => 'Пошта від адміністрації',
    101 => 'Дозволяти пошту від адміністрації сайту',
    102 => 'Пошта від користувачів',
    103 => 'Дозволяти пошту від інших користувачів',
    104 => 'Відображати онлайн-статус',
    105 => 'Відображати в блоці "Хто онлайн"',
    106 => 'Місце перебування',
    107 => 'Відображається в загальнодоступній інформації',
    108 => 'Підтвердити новий пароль',
    109 => 'Введіть тут новий пароль знову',
    110 => 'Поточний пароль',
    111 => 'Будь-ласка, введіть ваш поточний пароль',
    112 => 'Ви перевищили дозволену кількість спроб входу. Будь-ласка, спробуйте ще раз пізніше.',
    113 => 'Спроба входу невдала',
    114 => 'Обліковий запис заблоковано',
    115 => 'Ваш обліковий запис заблоковано, ви не можете увійти. Будь-ласка, зверніться до адміністратора.',
    116 => 'Обліковий запис очікує на активацію',
    117 => 'Зараз ваш обліковий запис очікує на активацію адміністратором. Ви не зможете увійти, поки його не буде активовано.',
    118 => "Ваш обліковий запис на {$_CONF['site_name']} активовано адміністратором. Ви можете увійти на сайт за адресою, вказаною нижче, використовуючи ваш логін (<username>) і попередньо надісланий вам пароль.",
    119 => 'Якщо ви забули пароль, ви можете замовити новий за цією адресою:',
    120 => 'Обліковий запис активовано',
    121 => 'Служба',
    122 => 'Вибачте, реєстрацію нових користувачів заборонено',
    123 => "Ви <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">новий користувач</a>?",
    124 => 'Підтвердити електронну адресу',
    125 => 'Ви повинні ввести однакову електронну адресу в обидва поля!',
    126 => 'Будь-ласка, повторіть для підтвердження',
    127 => 'Щоб змінити ці налаштування, потрібно ввести ваш поточний пароль.',
    128 => 'Ваше ім\'я',
    129 => 'Пароль та електронна пошта',
    130 => 'Про вас',
    131 => 'Опції щоденного дайджесту',
    132 => 'Щоденний дайджест',
    133 => 'Відображення коментарів',
    134 => 'Опції коментарів',
    135 => '<li>Режим відображення коментарів за замовчуванням</li><li>Порядок відображення коментарів за замовчуванням</li><li>Встановити максимальну кількість коментарів для виводу, за замовчуванням - 100</li>',
    136 => 'Ігнорувати теми та авторів',
    137 => 'Фільтрувати вміст статті',
    138 => 'Інші налаштування',
    139 => 'Зовнішній вигляд та мова',
    140 => '<li>Без іконок тем - не показувати малюночки тем біля статей</li><li>Без блоків - виводити лише меню адміністратора, користувача та теми новин<li>Встановити максимальну кількість статей на сторінку</li><li>Встановити тему дизайну та формат дати</li>',
    141 => 'Налаштування приватності',
    142 => 'За замовчуванням користувачі та адміністратори можуть надсилати пошту іншим користувачам і бачити їх онлайн-статус. Відмініть ці опції, якщо бажаєте посилити свою приватність.',
    143 => 'Фільтрувати вміст блоку',
    144 => 'Показати/сховати блоки',
    145 => 'Ваш загальнодоступний профіль',
    146 => 'Пароль та електронна пошта',
    147 => 'Редагувати ваш пароль, електронну адресу та опцію автовходу. Вам необхідно повторити пароль чи електронну адресу двічі для підтвердження.',
    148 => 'Інформація про користувача',
    149 => 'Змінити інформацію про вас, що буде доступна іншим користувачам.<li>Підпис буде додано до ваших коментарів та постів у форумі</li><li>Біографія - це ваш короткий життєпис, яким ви хочете поділитись з іншими</li><li>Додати ваш ключ PGP</li>',
    150 => 'Попередження: для розширеної функціональності необхідна підтримка Javascript',
    156 => 'Вилучити обліковий запис',
    157 => 'Опція вилучення',
    158 => 'Time Zone',
    159 => 'This email was generated automatically. Please do not reply to this email.'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Preview',
    'pe_namepass' => 'Username &amp; Password',
    'pe_userinfo' => 'About You',
    'pe_layout' => 'Layout &amp; Language',
    'pe_content' => 'Content',
    'pe_privacy' => 'Privacy'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Новин для перегляду немає',
    2 => 'Нових статтей для перегляду немає. Можливо немає новин на дану тему або ваші налаштування фільтрації занадто жорсткі',
    3 => ' для теми %s',
    4 => 'Сьогоднішня головна стаття',
    5 => 'Наступна',
    6 => 'Попередня',
    7 => 'Перша',
    8 => 'Остання'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Під час відправлення повідомлення виникла помилка. Спробуйте ще раз.',
    2 => 'Повідомлення успішно відправлено.',
    3 => 'Перевірте правильність адреси в полі Відповісти.',
    4 => 'Заповніть поля: Ім\'я, Відповісти, Тема, Повідомлення',
    5 => 'Помилка: вказаного користувача немає.',
    6 => 'Виникла помилка.',
    7 => 'Профіль користувача',
    8 => 'Ім\'я користувача',
    9 => 'URL користувача',
    10 => 'Надістати пошту для',
    11 => 'Ваше ім\'я:',
    12 => 'Відповісти:',
    13 => 'Тема:',
    14 => 'Повідомлення:',
    15 => 'HTML не буде інтерпретовано.',
    16 => 'Надіслати повідомлення',
    17 => 'Надіслати статтю другу',
    18 => 'Відправник',
    19 => 'Зворотня адреса',
    20 => 'Одержувач',
    21 => 'Адреса одержувача',
    22 => 'Всі поля обов\'язкові',
    23 => "Цей лист надіслано вам %s з %s тому що він(вона) вважалв(ла), що вас зацікавить ця стаття з {$_CONF['site_url']}. Це не СПАМ і електронні адреси, залучені в цю дію, не збережено для подальшого використання.",
    24 => 'Коментар на цю тему на',
    25 => 'Щоб використати цю функцію, ви повинні увійти до системи. Ваша реєстрація допоможе нам запобігти неправильному використанню системи',
    26 => 'Ця форма дозволить вам надіслати електронне повідомлення обраному користувачу. Всі поля обов\'язкові.',
    27 => 'Коротке повідомлення',
    28 => '%s написав(ла): ',
    29 => "Це щоденний дайджест з {$_CONF['site_name']} для ",
    30 => ' Щоденний бюлетень новин для ',
    31 => 'Заголовок',
    32 => 'Дата',
    33 => 'Прочитати статтю повністю на',
    34 => 'Кінець повідомлення',
    35 => 'Вибачте, але цей користувач не бажає отримувати пошту.'
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Розширений пошук',
    2 => 'Ключовi слова',
    3 => 'Тема',
    4 => 'Все',
    5 => 'Тип',
    6 => 'Статтi',
    7 => 'Коментарi',
    8 => 'Автори',
    9 => 'Все',
    10 => 'Пошук',
    11 => 'Результат пошуку',
    12 => 'збiг(и,ів)',
    13 => 'Результат пошуку: збiгiв немає',
    14 => 'Не знайдено жодного збiгу за вашим запитом',
    15 => 'Будь-ласка, спробуйте ще раз.',
    16 => 'Заголовок',
    17 => 'Дата',
    18 => 'Автор',
    19 => "Пошук по всiй базi поточних i архiвних статей {$_CONF['site_name']}",
    20 => 'Дата',
    21 => 'по',
    22 => '(Формат дати РРРР-MM-ДД)',
    23 => 'Переглядiв',
    24 => 'Знайдено %d об\'єкти(ів):',
    25 => 'Пошук',
    26 => 'пунктiв за',
    27 => 'секунд',
    28 => 'Жодної статтi або коментаря за вашим запитом не знайдено',
    29 => 'Результати серед статей та коментарiв',
    30 => '',
    31 => 'В цьому модулі не знайдено збігів',
    32 => '',
    33 => 'URL',
    34 => 'Розташування',
    35 => 'Весь день',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Ваш запит повинен мiстити принаймнi 3 символи.',
    42 => 'Використовуйте такий формат дати - РРРР-MM-ДД (рiк-мiсяць-день).',
    43 => 'точна фраза',
    44 => 'з усiма словами',
    45 => 'з будь-яким зi слiв',
    46 => 'Наступний',
    47 => 'Попереднiй',
    48 => 'Автор',
    49 => 'Дата',
    50 => 'Переглядiв',
    51 => '',
    52 => 'Розташування',
    53 => 'Результати серед статей',
    54 => 'Результати серед коментарів',
    55 => 'фразу',
    56 => 'AND',
    57 => 'OR',
    58 => 'Ще результати &gt;&gt;',
    59 => 'Результати',
    60 => 'на сторінку',
    61 => 'Очистити пошук'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Статистика сайту',
    2 => 'Загальна кількість відвідувань системи',
    3 => 'Статей (коментарів) у системі',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Десять найпопулярніших статей',
    8 => 'Назва статті',
    9 => 'Перегляди',
    10 => 'На сайті відсутні статті або ніхто їх не переглядав.',
    11 => 'Десять найбільш коментованих статей',
    12 => 'Коментарі',
    13 => 'На сайті відсутні статті або ніхто не коментував їх.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Десять статей, які найчастіше надсилаються',
    23 => 'Поштові повідомлення',
    24 => 'Схоже, що ніхто не пересилав статтю на цьому сайті поштою',
    25 => '10 найбільш трекбек-коментованих статей',
    26 => 'Не знайдено трекбек-коментарів.',
    27 => 'Кількість активних користувачів',
    28 => '',
    29 => '',
    30 => 'Хіти',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Cпорiднене',
    2 => 'Відіслати статтю ',
    3 => 'Форма статті для друку',
    4 => 'Параметри',
    5 => 'Формат статті PDF',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Для публікації Ви повинні зареєструватися як користувач.',
    2 => 'Увійти',
    3 => 'Новий користувач',
    4 => '',
    5 => '',
    6 => 'Публікація статті',
    7 => 'Реєстрація в системі обов\'язкова',
    8 => 'Опублікувати',
    9 => 'При публікації інформації на цьому сайті для подальшого її використання, рекомендується дотримуватись таких вказівок...<ul><li> Обов\'язково заповніть всі поля<li> Забезпечте повну і достовірну інформацію<li> Двічі перевірте URL, який використовуєте</li></ul>',
    10 => 'Заголовок',
    11 => '',
    12 => 'Дата початку',
    13 => 'Дата кінця',
    14 => 'Місце проведення',
    15 => 'Опис',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Прочитайте в першу чергу',
    20 => '',
    21 => '',
    22 => 'Помилка: незаповнені поля',
    23 => 'Будь-ласка, заповніть всі поля форми. Всі поля є обов\'язковими.',
    24 => 'Публікація збережена',
    25 => 'Вашу публікацію успішно збережено.',
    26 => 'Обмеження швидкості',
    27 => 'Ім\'я користувача',
    28 => 'Тема',
    29 => 'Стаття',
    30 => 'Ваша остання публікація була ',
    31 => " секунд тому. Система потребує принаймні {$_CONF['speedlimit']} секунд між публікаціями",
    32 => 'Попередній перегляд',
    33 => 'Попередній перегляд статті',
    34 => 'Вихід з системи',
    35 => 'Використання HTML тегів заборонено',
    36 => 'Режим публікації',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Адреса, рядок 1',
    45 => 'Адреса, рядок 2',
    46 => 'Місто/Село',
    47 => 'Область',
    48 => 'Індекс',
    49 => '',
    50 => '',
    51 => 'Розташування',
    52 => 'Вилучити',
    53 => 'Створити обліковий запис',
    54 => 'Story Introduction',
    55 => 'Story Body'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Необхідна аутентифікація',
    2 => 'Відмовлено! Невірна реєстраційна інформація',
    3 => 'Неправильний пароль користувача',
    4 => 'Ім\'я користувача:',
    5 => 'Пароль:',
    6 => 'Доступ до адміністративних функцій цього сайта записується і переглядається. <br' . XHTML . '>Ця сторінка лише для авторизованого персоналу сайту.',
    7 => 'увійти'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Недостатньо адміністративних прав',
    2 => 'У вас немає прав для зміни цього блоку.',
    3 => 'Редактор блоків',
    4 => 'Виникла помилка під час читання стрічки. Перегляньте error.log, щоб дізнатись більше.',
    5 => '',
    6 => '',
    7 => 'Все',
    8 => 'Рівень безпеки',
    9 => 'Порядок блоку',
    10 => '',
    11 => 'Портальний блок',
    12 => 'Звичайний блок',
    13 => 'Параметри портального блоку',
    14 => 'RSS URL',
    15 => 'Останнє оновлення RSS',
    16 => 'Параметри звичайного блоку',
    17 => 'Вміст блоку',
    18 => 'Заповніть поля: Заголовок блоку і Вміст блоку',
    19 => 'Менеджер блоків',
    20 => '',
    21 => 'Рівень безпеки блоку',
    22 => '',
    23 => 'Порядок блоку',
    24 => '',
    25 => 'Щоб змінити або вилучити блок, натисніть його іконку редагування нижче.  Щоб створити новий блок, натисніть "Створити нове" вгорі. Щоб перемістити блок, натискайте стрілки чи кнопки [R] та [L].',
    26 => 'Блок розміщення',
    27 => 'Блок PHP',
    28 => 'Параметри блоку PHP',
    29 => 'Функція блоку',
    30 => 'Якщо Ви бажаєте, щоб один із блоків використовував PHP код, введіть ім\'я функції. Ваша функція повинна починатися з префікса "phpblock_" (наприклад, phpblock_getweather). Якщо вона не має вказаного префікса, то її не буде викликано. Це зроблено для того, щоб не дозволити людям, які можуть зламати ваш Geeklog, викликати функції,що є небезпечними для вашої системи. Не розміщуйте порожні дужки "()" після назви Вашої функції. Ми рекомендуємо розміщувати код функцій в /path/to/geeklog/system/lib-custom.php. Це дозволить Вам зберегти код у разі переходу до нової версії Geeklog.',
    31 => 'Помилка в блоці PHP. Функція %s не існує.',
    32 => 'Помилка незаповнене(і) поле(я)',
    33 => 'Введіть URL RSS файлу для портального блоку',
    34 => 'Введіть заголовок і функцію для PHP блоку',
    35 => 'Введіть заголовок і вміст для звичайного блоку',
    36 => 'Введіть вміст для структурного блоку',
    37 => 'Неправильне ім\'я для функції блоку PHP',
    38 => 'Функція для блоку PHP повинна мати префікс \'phpblock_\' (наприклад, phpblock_getweather). Префікс \'phpblock_\' необхідний з міркувань безпеки для запобігання використанню небажаного коду.',
    39 => 'Сторона',
    40 => 'Ліворуч',
    41 => 'Праворуч',
    42 => 'Необхідно ввести заголовок блоку та порядок блоків',
    43 => 'Лише головна сторінка',
    44 => '',
    45 => "Ви спробували отримати доступ до блоку, для якого у вас немає прав. Цю спробу було записано. Будь-ласка, <a href=\"{$_CONF['site_admin_url']}/block.php\"> поверніться на сторінку адміністрування блоків</a>.",
    46 => 'Пересунути',
    47 => '',
    48 => 'Назва блоку',
    49 => ' (без проміжків і повинна бути унікальною)',
    50 => '',
    51 => 'включаючи http://',
    52 => 'Якщо ви залишите це поле порожнім, то позначку для блоку не буде показано',
    53 => 'Дозволений',
    54 => 'зберегти',
    55 => 'скасувати',
    56 => 'вилучити',
    57 => 'Перемістити блок вниз',
    58 => 'Перемістити блок вгору',
    59 => 'Перемістити блок праворуч',
    60 => 'Перемістити блок ліворуч',
    61 => 'Немає заголовку',
    62 => 'Обмеження статей',
    63 => 'Неправильний заголовок',
    64 => 'Ваш заголовок повинен бути непорожнім і не містити HTML!',
    65 => 'Порядок',
    66 => 'Автотеги',
    67 => 'Відмітьте, щоб дозволити використання автотегів',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Попередні статті',
    2 => 'Наступні статті',
    3 => 'Режим',
    4 => 'Режим публікації',
    5 => 'Редактор статті',
    6 => 'В системі немає жодної статті',
    7 => 'Автор',
    8 => 'зберегти',
    9 => 'попередній перегляд',
    10 => 'скасувати',
    11 => 'вилучити',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Дата',
    16 => 'Вступ',
    17 => 'Основний текст',
    18 => 'Перегляд(и,iв)',
    19 => 'Коментар(і,ів)',
    20 => 'Пінг',
    21 => 'Надіслати пінг',
    22 => 'Список статей',
    23 => 'Щоб змінити чи вилучити статтю, натисніть її іконку редагування нижче. Щоб переглянути статтю, натисніть її заголовок. Щоб створити нову статтю, оберіть "Створити нове" вгорі.',
    24 => 'ID, що ви обрали для цієї статті, вже використано. Будь-ласка, оберіть інший ID.',
    25 => 'Помилка під час зберігання статті',
    26 => 'Попередній перегляд статті',
    27 => 'Якщо ви використаєте [unscaledX] замість [imageX], малюнок буде вставлено з оригінальними розмірами.',
    28 => '<p><b>ПОПЕРЕДНІЙ ПЕРЕГЛЯД</b>: Переглядати статтю з малюнками найкраще, зберігаючи статтю як чорновик, замість натискати кнопку перегляду.  Використовуйте цю кнопку лише коли малюнків немає.',
    29 => 'Трекбеки',
    30 => 'Помилки завантаження файлів',
    31 => 'Будь-ласка, заповніть поля Заголовок та Вступ',
    32 => 'Головна',
    33 => 'Може існувати лише одна головна стаття',
    34 => 'Чернетка',
    35 => 'Так',
    36 => 'Ні',
    37 => 'Ще від',
    38 => 'Ще із',
    39 => 'Пересилання',
    40 => '',
    41 => "Ви намагалися отримати доступ до статті, до якої в Вас немає прав. Ця спроба була записана. Ви можете лише прочитати статтю. Будь-ласка, <a href=\"{$_CONF['site_admin_url']}/story.php\"> поверніться на сторінку адміністрування  статтей </a> коли закінчите.",
    42 => "Ви намагалися отримати доступ до статті, до якої в Вас немає прав. Ця спроба була записана. Будь-ласка, <a href=\"{$_CONF['site_admin_url']}/story.php\">поверніться на сторінку адміністрування статтей</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>Зауваження:</b> якщо ви зміните цю дату на дату в майбутньому, ця стаття не буде опублікована до вказаної вами дати. Це також означає, що стаття не буде вказана в вашій стрічці RSS і буде ігноруватися при пошуку та в статистиці сайту.',
    47 => 'Малюнки',
    48 => 'малюнок',
    49 => 'праворуч',
    50 => 'ліворуч',
    51 => 'Для того щоб додати один з малюнків під\'єднаних до цієї статті, ви повинні вставити спеціально відформатований текст. Цей спеціально відформатований текст це [imageX], [imageX_right] або [imageX_left], де X  це порядковий номер малюнка, який ви під\'єднали. Зауваження: ви повинні використати малюнки, які ви під\'єднали. Інакше ви не зможете зберегти вашу статтю.<BR>',
    52 => '',
    53 => 'не було використано. Ви повинні включити цей малюнок у вступу або основний текс, перш ніж зможете зберегти зміни',
    54 => 'Під\'єднані малюнки не використано',
    55 => 'При збереженні статті виникли наступні помилки.  Будь-ласка, виправте їх перед збереженням',
    56 => 'Показувати малюнок теми',
    57 => 'Перегляд малюнка в повний розмір',
    58 => 'Опції архівування',
    59 => 'Опції',
    60 => '',
    61 => 'Автоматично архівувати',
    62 => 'Автоматично вилучити',
    63 => '',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Збільшити розмір поля змісту',
    68 => 'Зменшити розмір поля змісту',
    69 => 'Публікувати дату статті',
    70 => 'Вибір панелі інструментів',
    71 => 'Базова панель',
    72 => 'Звичайна панель',
    73 => 'Розширена панель',
    74 => 'Розширена панель II',
    75 => 'Всі можливості',
    76 => 'Опції публікації',
    77 => 'Для роботи Розширеного Редактора потрібно дозволити виконання Javascript. Цю опцію можна відключити у файлі config.php',
    78 => 'Натисніть <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">тут</a>, щоб використовувати звичайний редактор',
    79 => 'Перегляд',
    80 => 'Редактор',
    81 => 'Опції публікації',
    82 => 'Зображення',
    83 => 'Опції архівування',
    84 => 'Права доступу',
    85 => 'Показати все',
    86 => 'Розширений редактор',
    87 => 'Статистика статті',
    88 => 'Wiki-style format'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Редактор тем',
    2 => 'ID теми',
    3 => 'Назва теми',
    4 => 'Малюнок теми',
    5 => '(не використовувати проміжки)',
    6 => 'Вилучення теми призведе до вилучення всіх пов\'язаних з нею статей і блоків',
    7 => 'Будь-ласка, заповніть поля ID теми і Назва теми',
    8 => 'Менеджер тем',
    9 => 'Щоб змінити або вилучити тему, натисніть її.  Щоб створити нову, оберіть "Створити нове" вгорі. В дужках записано ваш рівень доступу до кожної теми. Зірочка (*) відмічає тему за замовчуванням.',
    10 => 'Порядок сортування',
    11 => 'Статей на сторінку',
    12 => 'Відмовлено у доступі',
    13 => "Ви намагалися отримати доступ до теми, до якої у вас немає прав. Ця спроба була записана. Будь-ласка, <a href=\"{$_CONF['site_admin_url']}/topic.php\"> поверніться на сторінку адміністрування тем </a>.",
    14 => 'Метод сортування',
    15 => 'алфавітний',
    16 => 'за замовчуванням',
    17 => 'Нова тема',
    18 => 'Адміністрування',
    19 => 'зберегти',
    20 => 'скасувати',
    21 => 'вилучити',
    22 => 'За замовчуванням',
    23 => 'зробити це темою за замовчуванням для нових статтей',
    24 => '(*)',
    25 => 'Архівна тема',
    26 => 'зробити це темою за замовчуванням для архівних статей. Може існувати лише одна така тема.',
    27 => 'Або завантажити малюнок',
    28 => 'Максимум',
    29 => 'Помилки завантаження файлів'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Редактор користувачів',
    2 => 'ID користувача',
    3 => 'Ім\'я користувача',
    4 => 'Повне ім\'я',
    5 => 'Пароль',
    6 => 'Рівень безпеки',
    7 => 'Електронна адреса',
    8 => 'Домашня сторінка',
    9 => '(не використовувати проміжки)',
    10 => 'Будь-ласка, заповніть поля Ім\'я користувача та Електронна адреса',
    11 => 'Менеджер користувачів',
    12 => 'Щоб змінити чи вилучити користувача, натисніть його іконку редагування нижче. Щоб переглянути інформацію про користувача, оберіть його логін зі списку. Щоб створити нового, натисніть "Створити нове" вгорі. Ви можете виконувати простий пошук, вводячи лише частину імені, адреси чи логіна (наприклад *son* чи *.edu) у формі нижче.',
    13 => 'Рівень захисту',
    14 => 'Дата реєстрації',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'зберегти',
    21 => 'Таке ім\'я вже існує.',
    22 => 'Помилка',
    23 => 'Додати групу',
    24 => 'Груповий імпорт користувачів',
    25 => 'Ви можете імпортувати групу користувачів у Geeklog. Імпортований файл повинен бути текстовим файлом із таб-розміткою і повинен мати поля в такому порядку: повне ім\'я, ім\'я користувача, адреса електронної пошти. Кожому користувачеві, доданому вами, буде надіслано випадковий пароль. Ви повинні мати в одному рядку одного користувача. Недотримання цих вимог призведе до помилок і потреби ручної роботи, отже двічі перевірте введені дані!',
    26 => '',
    27 => '',
    28 => 'Відмітьте для вилучення малюнку',
    29 => 'Шлях',
    30 => 'Імпорт',
    31 => 'Нові користувачі',
    32 => 'Обробку завершено. Імпортовано %d записів, виникло %d помилок',
    33 => 'надіслати',
    34 => 'Помилка: ви повинні вказати файл для завантаження.',
    35 => 'Останній вхід до системи',
    36 => '(ніколи)',
    37 => 'UID',
    38 => 'Список груп',
    39 => 'Пароль (ще раз)',
    40 => 'Дата реєстрації',
    41 => 'Дата останнього входу',
    42 => 'Забанений',
    43 => 'Очікує на активацію',
    44 => 'Очікує на авторизацію',
    45 => 'Активний',
    46 => 'Статус користувача',
    47 => 'Редагувати',
    48 => 'Показувати адміністративні групи',
    49 => 'Адміністративна група',
    50 => 'Відмітьте, щоб фільтрувати цю групу як адміністративну',
    51 => 'Днів онлайн',
    52 => '<br' . XHTML . '>Зауважте: "Днів онлайн" - це кількість днів між першою реєстрацією та останнім входом до системи.',
    53 => 'зареєстровано',
    54 => 'Масове вилучення',
    55 => 'Це працбє лише у випадку, коли ви встановили <code>$_CONF[\'lastlogin\'] = true;</code> у вашому файлі config.php',
    56 => 'Будь-ласка, оберіть тип користувача, що ви хочете вилучити і натисніть "Оновити список". Тоді зніміть виділення з тих, кого не хочете вилучати, і натисніть "Вилучити". Зауважте, що таким чином ви вилучите лише тих, хто на поточній сторінці, якщо список займає кілька сторінок.',
    57 => 'Неактивні користувачі',
    58 => 'Короткострокові користувачі',
    59 => 'Давні користувачі',
    60 => 'Користувачі, що зареєструвались більше ',
    61 => ' місяця(ів) тому, але жодного разу не входили до системи.',
    62 => 'Користувачі, що зареєструвались більше ',
    63 => ' місяця(ів) тому, увійшли до системи за наступні 24 години, і відтоді не заходили в систему.',
    64 => 'Звичайні користувачі, які просто не відвідували ваш сайт за останні ',
    65 => ' місяць(і).',
    66 => 'Оновити список',
    67 => 'Місяців від реєстрації',
    68 => 'Годин онлайн',
    69 => 'Місяців офлайн',
    70 => 'вилучити не вдалося',
    71 => 'успішно вилучено',
    72 => 'Не обрано для вилучення жодного користувача',
    73 => 'Ви впевнені, що хочете остаточно вилучити ВСІХ обраних користувачів?',
    74 => 'Недавні користувачі',
    75 => 'Користувачі, що зареєструвались за останні ',
    76 => ' місяць(і)',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Схвалити',
    2 => 'Вилучити',
    3 => 'Змінити',
    4 => 'Профіль',
    10 => 'Заголовок',
    11 => 'Дата початку',
    12 => 'URL',
    13 => 'Для ухвалення',
    14 => 'Дата',
    15 => 'Тема',
    16 => 'Ім\'я користувача',
    17 => 'Повне ім\'я',
    18 => 'Електронна адреса',
    34 => 'Управління',
    35 => 'Статті для ухвалення',
    36 => '',
    37 => '',
    38 => 'Виконати',
    39 => 'На даний момент модерувати нічого',
    40 => 'Користувачі для ухвалення'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "Пошта {$_CONF['site_name']}",
    2 => 'Вiд',
    3 => 'Вiдповiдати:',
    4 => 'Тема',
    5 => 'Текст',
    6 => 'Кому:',
    7 => 'Всi користувачi',
    8 => 'Адмiнiстратор',
    9 => 'Параметри',
    10 => 'HTML',
    11 => 'Термiнове повiдомлення!',
    12 => 'Надіслати',
    13 => 'Очистити',
    14 => 'Iгнорувати установки користувача',
    15 => 'Помилка при вiдправленнi на: ',
    16 => 'Повiдомлення успiшно вiдправлено на: ',
    17 => "<a href=\"{$_CONF['site_admin_url']}/mail.php\">Надіслати ще повідомлення</a>",
    18 => 'До',
    19 => 'Зауваження: якщо ви бажаєте надіслати повідомлення усім користувачам, оберіть групу Зареєстровані користувачі зі списку.',
    20 => "Успішно відправлено <successcount> повідомлень і безуспішно - <failcount>.  Якщо потрібно, подробиці щодо кожного повідомлення нижче.  Також ви можете <a href=\"{$_CONF['site_admin_url']}/mail.php\">Відіслати ще повідомлення</a> або <a href=\"{$_CONF['site_admin_url']}/moderation.php\">повернутись назад на сторінку адміністрування</a>.",
    21 => 'Відмов(и)',
    22 => 'Успiшно',
    23 => 'Без помилок',
    24 => 'Без успіхів',
    25 => '-- Оберіть групу --',
    26 => 'Заповніть всі поля форми і оберіть групу користувачів зі списку.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Встановлення модуля може пошкодити Geeklog або навіть вашій системі. Важливо, щоб ви встановлювали лише модулі, завантажені з <a href="http://www.geeklog.net" target="_blank">Домашньої сторінки Geeklog</a>, оскільки ми тестуємо всі модулі, що нам присилають, на різних операційних системах. Важливо, щоб ви розуміли, що встановлення модулів вимагає виконання деяких системних команд, які можуть викликати проблеми з безпекою, особливо це стосується модулів, завантажених не з нашого сайту. Якщо навіть після цього попередження ви все ж продовжите, ми не можемо гарантувати успішність інсталяції і не несемо відповідальності за проблеми, викликані встановленням модуля Geeklog. Інакше кажучи, ви встановлюєте модуль на свій ризик. Керівництво з ручного встановлення модуля включено в кожний інсталяційний пакет.',
    2 => 'Попередження про встановлення модулів',
    3 => 'Форма встановлення модулів',
    4 => 'Файл модуля',
    5 => 'Список модулів',
    6 => 'Попередження: Модуль вже встановлено!',
    7 => 'Модуль, який Ви намагаєтесь встановити, вже існує. Перед тим, як перевстановити модуль, вилучіть старий',
    8 => 'Модуль не пройшов перевірку сумісності версії',
    9 => 'Модуль потребує більш нової версії Geeklog. Оновіть Вашу копію <a href="http://www.geeklog.net">Geeklog</a> або спробуйте знайти іншу версію модуля.',
    10 => '<br' . XHTML . '><b>В системі немає встановлених модулів.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Щоб змінити чи вилучити модуль, натисніть його іконку редагування нижче. Буде виведено деталі про модуль, включаючи домашню сторінку автора. Виводиться як інстальована версія, так і версія з коду модуля. Це дасть вам знати, коли варто оновлювати модуль. Щоб встановити чи оновити модуль, будь-ласка, зверніться до його документації.',
    12 => 'ім\'я модуля не передано в plugineditor()',
    13 => 'Редактор модулів',
    14 => 'Новий модуль',
    15 => 'Адміністрування',
    16 => 'Назва модуля',
    17 => 'Версія модуля',
    18 => 'Версія Geeklog',
    19 => 'Дозволено',
    20 => 'Так',
    21 => 'Ні',
    22 => 'Встановити',
    23 => 'Зберегти',
    24 => 'Скасувати',
    25 => 'Вилучити',
    26 => 'Назва модуля',
    27 => 'Домашня сторінка',
    28 => 'Версія модуля',
    29 => 'Версія Geeklog',
    30 => 'Вилучити модуль?',
    31 => 'Ви впевнені, що бажаєте вилучити цей модуль? Продовживши, ви вилучите всі файли і дані, які даний модуль використовував. Якщо ви впевнені, натисніть "Вилучити".',
    32 => '<p><b>Помилка - некоректний формат тега AutoLink</b></p>',
    33 => 'Версія коду',
    34 => 'Оновити',
    35 => 'Редагувати',
    36 => 'Код',
    37 => 'Дані',
    38 => 'Оновити!'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'створити стрічку',
    2 => 'зберегти',
    3 => 'вилучити',
    4 => 'скасувати',
    10 => 'Експорт контенту',
    11 => 'Нова стрічка',
    12 => 'Адміністрування',
    13 => 'Щоб змінити чи вилучити стрічку, натисніть її іконку редагування нижче. Щоб створити нову, оберіть "Створити нове" вгорі.',
    14 => 'Заголовок',
    15 => 'Тип',
    16 => 'Ім\'я файла',
    17 => 'Формат',
    18 => 'останнє оновлення',
    19 => 'Дозволена',
    20 => 'Так',
    21 => 'Ні',
    22 => '<i>(немає стрічок)</i>',
    23 => 'всі статті',
    24 => 'Редактор стрічок новин',
    25 => 'Заголовок стрічки',
    26 => 'Обмеження',
    27 => 'Довжина записів',
    28 => '(0 = без тексту, 1 = повний текст, інше число = обмежити до такої кількості знаків.)',
    29 => 'Опис',
    30 => 'Останнє поновлення',
    31 => 'Кодування',
    32 => 'Мова',
    33 => 'Зміст',
    34 => 'Записи',
    35 => 'Годин',
    36 => 'Оберіть тип стрічки',
    37 => '',
    38 => 'Помилка: незаповнені поля',
    39 => 'Будь-ласка, заповніть Заголовок стрічки, Опис та Ім\'я файла.',
    40 => 'Будь-ласка, введіть кількість записів або кількість годин.',
    41 => 'Надіслати',
    42 => '',
    43 => 'Всі',
    44 => 'Жодної',
    45 => 'Посилання в темі',
    46 => 'Обмежити результати',
    47 => 'Пошук',
    48 => 'Редагувати',
    49 => 'Логотип стрічки',
    50 => "Відносно до URL сайту ({$_CONF['site_url']})",
    51 => 'Ім\'я файла яке ви обрали, вже використано для іншої стрічки. Будь-ласка, оберіть інше.',
    52 => 'Помилка: ім\'я файла вже існує',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Ваш пароль відправлено на електронну пошту. Будь-ласка, дотримуйтесь вказівок в отриманому повідомленні. Дякуємо за використання {$_CONF['site_name']}",
    2 => "Дякуємо за додання статті на {$_CONF['site_name']}.  Вона прийнята до розгляду. Якщо дозвіл буде отримано, вашу статтю зможуть читати інші користувачі нашого сайту.",
    3 => '',
    4 => '',
    5 => 'Інформацію про Ваш обліковий запис успішно збережено.',
    6 => 'Ваші налаштування зображення успішно збережено.',
    7 => 'Ваші параметри коментарів успішно збережено.',
    8 => 'Ви успішно вийшли з системи.',
    9 => 'Вашу статтю успішно збережено.',
    10 => 'Статтю успішно вилучено.',
    11 => 'Ваш блок успішно збережено.',
    12 => 'Блок успішно вилучено.',
    13 => 'Тему успішно збережено.',
    14 => 'Тему, всі блоки і статті, які відносяться до неї, успішно вилучено.',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Дані користувача успішно збережено.',
    22 => 'Користувача успішно вилучено.',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Повідомлення успішно відправлено.',
    28 => 'Модуль успішно збережено.',
    29 => '',
    30 => 'Відмовлено у доступі',
    31 => 'Вибачте, у Вас немає доступу до адміністрування статей. Просимо врахувати, що всі спроби доступу до заборонених функцій записуються',
    32 => 'Вибачте, у Вас немає доступу до адміністрування тем. Просимо врахувати, що всі спроби доступу до заборонених функцій записуються',
    33 => 'Вибачте, у Вас немає доступу до адміністрування блоків. Просимо врахувати, що всі спроби доступу до заборонених функцій записуються',
    34 => '',
    35 => '',
    36 => '',
    37 => 'Вибачте, у Вас немає доступу до адміністрування користувачів. Просимо врахувати, що всі спроби доступу до заборонених функцій записуються',
    38 => 'Вибачте, у Вас немає доступу до адміністрування модулів. Просимо врахувати, що всі спроби доступу до заборонених функцій записуються',
    39 => 'Вибачте, у Вас немає доступу до адміністрування пошти. Просимо врахувати, що всі спроби доступу до заборонених функцій записуються',
    40 => 'Системне повідомлення',
    41 => 'Вибачте, у Вас немає доступу до адміністрування слів-замін. Просимо врахувати, що всі спроби доступу до заборонених функцій записуються',
    42 => 'Слово успішно збережено.',
    43 => 'Слово успішно вилучено.',
    44 => 'Модуль успішно встановлено!',
    45 => 'Модуль успішно вилучено.',
    46 => 'Вибачте, у Вас немає доступу до створення резервних копій. Просимо врахувати, що всі спроби доступу до заборонених функцій записуються',
    47 => 'Ці функціональні можливості працюють лише в Unix-системах. Якщо ви використовуєте Unix, то ваша операційна система успішно очистить кеш. Якщо ви працюєте з Windows, вам буде потрібно розшукати файли adodb_*.php і вилучити їх вручну.',
    48 => "Дякуємо за реєстрацію на порталі {$_CONF['site_name']}. Наша команда перегляне ваше подання. У разі його схвалення ваш пароль буде надіслано вам на електронну адресу.",
    49 => 'Вашу групу успішно збережено.',
    50 => 'Групу було успішно вилучено.',
    51 => 'Таке ім\'я користувача вже існує. Будь-ласка, оберіть інше.',
    52 => 'Наведена електронна адреса є недійсною.',
    53 => 'Ваш новий пароль прийнято. Будь-ласка, скористайтесь ним зараз для входу до системи.',
    54 => 'Ваш запит про новий пароль застарілий. Будь-ласка, спробуйте знову нижче.',
    55 => 'На вашу електронну адресу надіслано листа, що повинен прибути негайно. Будь-ласка, виконайте вказівки з повідомлення, щоб встановити новий пароль для вашого облікового запису.',
    56 => 'Введена адреса вже використовується для іншого облікового запису.',
    57 => 'Ваш обліковий запис успішно вилучено.',
    58 => 'Вашу стрічку новин успішно збережено.',
    59 => 'Стрічку новин успішно вилучено.',
    60 => 'Модуль успішно оновлено',
    61 => 'Модуль %s: Невідомий замісник повідомлення',
    62 => 'Трекбек-коментар вилучено.',
    63 => 'Під час вилучення трекбек-коментаря сталася помилка.',
    64 => 'Ваш трекбек-коментар успішно відправлено.',
    65 => 'Службу Веблог успішно збережено.',
    66 => 'Службу Веблог успішно вилучено.',
    67 => 'Новий пароль та його підтвердження не співпадають!',
    68 => 'Ви повинні ввести правильний поточний пароль.',
    69 => 'Ваш обліковий запис заблоковано!',
    70 => 'Ваш обліковий запис очікує на схвалення адміністратора.',
    71 => 'Ваш обліковий запис підтверджено і зараз він очікує на схвалення адміністратора.',
    72 => 'Під час інсталяції модуля сталася помилка. За деталями зверніться до файла error.log.',
    73 => 'Під час деінсталяції модуля сталася помилка. За деталями зверніться до файла error.log.',
    74 => 'Пінгбек успішно відправлено.',
    75 => 'Трекбеки повинні відправлятись через POST запит.',
    76 => 'Ви впевнені, що хочете вилучити цей елемент?',
    77 => 'ПОПЕРЕДЖЕННЯ:<br' . XHTML . '>Ваше кодування символів за замовчуванням - UTF-8. Проте ваш сервер не підтримує багатобайтові кодування. Будь-ласка, встановіть функції mbstring для PHP або оберіть інше кодування/мову.',
    78 => 'Будь-ласка, переконайтеся, що електронна адреса та її підтвердження співпадають.',
    79 => 'Сторінка, яку ви намагалися відкрити, посилається на функцію, якою вже немає на цьому сайті.',
    80 => 'Модуль, що створив цю стрічку, наразі вимкнено. Ви не зможете редагувати цю стрічку, поки не увімкнете відповідний батьківський модуль.',
    81 => 'Можливо, ви помилилися при наборі ваших даних.  Будь-ласка, спробуйте ще раз.',
    82 => 'Ви перевищили кількість дозволених спроб входу.  Будь-ласка, спробуйте ще раз пізніше.',
    83 => 'Щоб змінити ваш пароль, електронну адресу чи час, на який сайт вас запам\'ятовує, введіть ваш поточний пароль.',
    84 => 'Щоб вилучити ваш обліковий запис, введіть свій поточний пароль.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => 'Sorry, you do not have access to the configuration administration page.  Please note that all attempts to access unauthorized features are logged.',
    97 => 'Not all required fields have been passed validation - default custom membership message'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Доступ',
    'ownerroot' => 'Власник/Root',
    'group' => 'Група',
    'readonly' => 'Тільки читання',
    'accessrights' => 'Права доступу',
    'owner' => 'Власник',
    'grantgrouplabel' => 'Дати права редагування згаданій групі',
    'permmsg' => 'Зауваження: користувачі - всі які увійшли до системи і зареєстровані, анонімні користувачі -  всі відвідувачі сайту, які не увійшли до системи.',
    'securitygroups' => 'Групи безпеки',
    'editrootmsg' => "Хоча ви і є Адміністратором Користувачів, але ви не можете редагувати кореневого користувача, не будучи при цьому самі кореневим користувачем.  Ви можете редагувати всіх користувачів, крім кореневих. Майте на увазі, що всі спроби незаконно редагувати користувачів записуються.  Будь-ласка, поверніться на <a href=\"{$_CONF['site_admin_url']}/user.php\">сторінку адміністрування користувачів</a>.",
    'securitygroupsmsg' => 'Оберіть групи до яких повинен належати користувач.',
    'groupeditor' => 'Редактор груп',
    'description' => 'Опис',
    'name' => 'Ім\'я',
    'rights' => 'Права',
    'missingfields' => 'Пропущені поля',
    'missingfieldsmsg' => 'Ви повинні надати назву і опис групи',
    'groupmanager' => 'Менеджер груп',
    'newgroupmsg' => 'Щоб змінити чи вилучити групу, натисніть її іконку редагування нижче. Щоб створити нову, оберіть "Створити нове" вгорі. Зазначте, що деякі базові групи не можна вилучити, оскільки вони використовуються системою.',
    'groupname' => 'Ім\'я групи',
    'coregroup' => 'Базова група',
    'yes' => 'Так',
    'no' => 'Ні',
    'corerightsdescr' => "Ця група є базовою на {$_CONF['site_name']}. Тому права для цієї групи не редагуються. Нижче перелічені права, які має ця група.",
    'groupmsg' => 'Структура груп гезпеки ієрархічна. Включаючи дану групу в іншу, ви даєте даній групі ті ж права, що має та група. Радимо вам використати групи, які перераховано нижче, для призначення прав вашій групі. Якщо Ви бажаєте призначити цій групі довільні права, то можете обрати права до окремих функцій сайту в розділі "Права" нижче. Щоб додати групі будь-які права з перерахованих нижче, просто поставте відмітки навпроти потрібних прав.',
    'coregroupmsg' => "Ця група є базовою для {$_CONF['site_name']}. Тому групи, до яких ця група належить не підлягають редагуванню. Нижче перелічені групи до яких належить ця група.",
    'rightsdescr' => 'Групові права можуть призначатися напряму групі АБО іншій групі, до якої належить дана. Ті права, які не мають чекбоксів поруч, є правами, що дісталися групі у спадок від груп, до яких вона належить. Права з чекбоксами поруч можуть призначатися цій групі напряму.',
    'lock' => 'Блокування',
    'members' => 'Користувачі',
    'anonymous' => 'Аноніми',
    'permissions' => 'Права',
    'permissionskey' => 'R = читати, E = редагувати, право редагувати припускає і право читати',
    'edit' => 'Редагувати',
    'none' => 'Жодних',
    'accessdenied' => 'Відмовлено у доступі',
    'storydenialmsg' => "У вас не має прав на перегляд цієї статті. Можливо, ви просто не  зареєстровані на {$_CONF['site_name']}. Будь ласка, <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">зареєструйтесь</a> на {$_CONF['site_name']} для отримання користувацького доступу!",
    'nogroupsforcoregroup' => 'Ця група не належить до жодної з інших груп',
    'grouphasnorights' => 'Ця група не має права доступу до жодної з адміністративної функції сайту',
    'newgroup' => 'Нова група',
    'adminhome' => 'Адміністрування',
    'save' => 'зберегти',
    'cancel' => 'скасувати',
    'delete' => 'вилучити',
    'canteditroot' => 'Ви намагаєтесь редагувати Кореневу групу, але при цьому ви не є її членом, тому доступ до неї закрито. Будь ласка, зверніться до адміністратора, якщо вважаєте це помилкою.',
    'listusers' => 'Користувачі',
    'listthem' => 'список',
    'usersingroup' => 'Користувачів групи "%s"',
    'usergroupadmin' => 'Адміністрування груп користувачів',
    'add' => 'Додати',
    'remove' => 'Вилучити',
    'availmembers' => 'Доступні користувачі',
    'groupmembers' => 'Користувачі групи',
    'canteditgroup' => 'Щоб редагувати цю групу, ви маєте бути її членом. Будь-ласка, зверніться до адміністратора, якщо вважаєте це помилкою.',
    'cantlistgroup' => 'Щоб побачити членів цієї групи, ви самі повинні бути її членом. Будь-ласка, зверніться до адміністратора, якщо вважаєте це помилкою.',
    'editgroupmsg' => 'Щоб змінити членство в групах, оберіть логін(и) користувачів і використовуйте кнопки додавання та вилучення. Якщо користувач є членом групи, його логін буде лише з правого боку. Як тільки завершите - натисніть <b>Зберегти</b>, щоб оновити групу і повернутись до головної сторінки адміністрування груп.',
    'listgroupmsg' => 'Список поточних членів групи: <b>%s</b>',
    'search' => 'Пошук',
    'submit' => 'Відправити',
    'limitresults' => 'Обмежити результати',
    'group_id' => 'ID групи',
    'plugin_access_denied_msg' => 'Ви намагаєтесь незаконно отримати доступ до адміністрування модулів.  Зазначте, що всі подібні спроби записуються.',
    'groupexists' => 'Таке ім\'я групи вже існує',
    'groupexistsmsg' => 'Уже існує група з таким ім\'ям. Імена груп повинні бути унікальними.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'Останні 10 резервних копій',
    'do_backup' => 'Створити резервну копію',
    'backup_successful' => 'Резервне копіювання бази даних вдало завершено.',
    'db_explanation' => 'Щоб створити нову резервну копію бази даних вашого сайту, клацніть нижче',
    'not_found' => "Неправильний шлях або утиліта mysqldump не виконується.<br" . XHTML . ">Перевірте змінну <strong>\$_DB_mysqldump_path</strong> у файлі config.php.<br" . XHTML . ">Її теперішнє значення: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Помилка резервного копіювання: Розмір файла 0 байт',
    'path_not_found' => "{$_CONF['backup_path']} не існує або не є каталогом",
    'no_access' => "Помилка: каталог {$_CONF['backup_path']} недоступний.",
    'backup_file' => 'Файл резервної копії',
    'size' => 'Розмір',
    'bytes' => 'Байт',
    'total_number' => 'Всього резервних копій: %d',
    'download' => 'Click to download this file'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Додому',
    2 => 'Контакт',
    3 => 'Опублікувати',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Статистика',
    8 => 'Вигляд',
    9 => 'Пошук',
    10 => 'розширений пошук',
    11 => 'Архів'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Помилка 404',
    2 => 'Вибачте, я дивився скрізь, але не можу знайти <b>%s</b>.',
    3 => "<p>Нам шкода, але файл, який вам потрібен, не існує. Будь-ласка, перевірте <a href=\"{$_CONF['site_url']}\">головну сторінку</a> або <a href=\"{$_CONF['site_url']}/search.php\">сторінку пошуку</a> щоб спробувати знайти потрібну інформацію."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Вхід обов\'язковий',
    2 => 'Вибачте, щоб мати доступ до цієї області, вам потрібно зареєструватися.',
    3 => 'Увійти',
    4 => 'Новий користувач'
);

###############################################################################
# pdfgenerator.php

$LANG_PDF = array(
    1 => 'Функцію PDF відключено',
    2 => 'Рендерінг документу не відбувся. Документ було отримано, але обробка не завершилась.  Будь-ласка, надсилайте документи лише у форматі html, написані за стандартом xHTML. Майте на увазі, що дуже складні документи можуть обробитись з помилками або взагалі не обробитись. Документ із вашої спроби мав 0 байтів у довжину, тому його було знищено. Якщо ви впевнені, що ваш документ повинен обробитись правильно, будь-ласка перешліть його.',
    3 => 'Невідома помилка під час генерації PDF',
    4 => 'Не надано даних про сторінку, можливо ви хочете використати ad-hoc PDF.  Якщо ви вважаєте, що отримали це повідомлення помилково, зверніться до адміністратора сайту.  В іншому разі ви можете скористатися формою внизу для генерації PDF в режимі ad-hoc.',
    5 => 'Завантажую ваш документ.',
    6 => 'Будь-ласка, зачекайте доки ваш документ завантажиться.',
    7 => 'Ви можете натиснути правою кнопкою мишки внизу і обрати \'зберегти посилання...\', щоб зберегти копію вашого документу.',
    8 => 'Шлях до програми HTMLDoc, вказаний в конфігураційному файлі, неправильний або ця система не в змозі її запустити.  Будь-ласка, зверніться до адміністратора сайту.',
    9 => 'Генератор PDF',
    10 => 'Це інструмент для генерування Ad-hoc PDF. Він спробує перетворити URL, який ви вкажете,на PDF файл.  Майте на увазі, що деякі веб-сторінки можуть бути оьроьлені з помилками.  Це обмеження програми HTMLDoc, і про такі помилки не потрібно доповідати адміністраторам сайту',
    11 => 'URL',
    12 => 'Згенерувати PDF!',
    13 => 'Конвігурація PHP на цьому сервері не дозволяє використання URL-ів через команду fopen().  Адміністратор системи повинен відредагувати файл php.ini і встановити allow_url_fopen в значення On',
    14 => 'PDF, який вам потрібен або не існує, або ви намагалися незаконно отримати доступ до файлу.'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Трекбек',
    'from' => 'від',
    'tracked_on' => 'Простежено на',
    'read_more' => '[читати далі]',
    'intro_text' => 'Ось що інші мають сказати про \'%s\':',
    'no_comments' => 'Немає трекбек-коментарів для цього запису.',
    'this_trackback_url' => 'Трекбек-URL для цього запису:',
    'num_comments' => '%d трекбек-коментарів',
    'send_trackback' => 'Надіслати пінг',
    'preview' => 'Перегляд',
    'editor_title' => 'Надіслати трекбек-коментар',
    'trackback_url' => 'Трекбек-URL',
    'entry_url' => 'URL запису',
    'entry_title' => 'Заголовок запису',
    'blog_name' => 'Назва сайту',
    'excerpt' => 'Витяг',
    'truncate_warning' => 'Увага: Сайт-отримувач може скоротити ваш витяг',
    'button_send' => 'Надіслати',
    'button_preview' => 'Перегляд',
    'send_error' => 'Помилка',
    'send_error_details' => 'Помилка під час відправлення трекбек-коментаря:',
    'url_missing' => 'Немає URL запису',
    'url_required' => 'Будь-ласка, введіть хоча б URL для запису.',
    'target_missing' => 'Немає трекбек-URL',
    'target_required' => 'Будь-ласка, введіть трекбек-URL',
    'error_socket' => 'Не вийшло відкрити сокет.',
    'error_response' => 'Відповідь незрозуміла.',
    'error_unspecified' => 'Невизначена помилка.',
    'select_url' => 'Обрати трекбек-URL',
    'not_found' => 'трекбек-URL не знайдено',
    'autodetect_failed' => 'Geeklog не зміг визначити трекбек-URL для поста, до якого ви хочете надіслати коментар. Будь-ласка, введіть його вручну нижче.',
    'trackback_explain' => 'З посилань нижче, оберіть URL на який ви хочете відіслати ваш трекбек-коментар. Geeklog спробує визначити правильний трекбек-URL для цього поста. Або ви можете <a href="%s">ввести його вручну,</a> якщо уже знаєте його.',
    'no_links_trackback' => 'Посилань не знайдено. Ви не можете відправляти трекбек-коментар для цього запису.',
    'pingback' => 'Пінгбек',
    'pingback_results' => 'Результати пінгбеку',
    'send_pings' => 'Надіслати пінги',
    'send_pings_for' => 'Надіслати пінги для "%s"',
    'no_links_pingback' => 'Посилань не знайдено. Для цього запису не було відправлено пінгбеків.',
    'pingback_success' => 'Пінгбек відправлено.',
    'no_pingback_url' => 'Не знайдено пінгбек-URL.',
    'resend' => 'Переслати',
    'ping_all_explain' => 'Ви тепер можете повідомляти сайти, на які посилались (<a href="http://en.wikipedia.org/wiki/Pingback">Пінгбек</a>), що вас сайт оновився пінгуючи служби веблогів, або надсилати <a href="http://en.wikipedia.org/wiki/Trackback">Трекбек</a>-коментар, якщо ви написали про пост на іншому сайті.',
    'pingback_button' => 'Надіслати пінгбек',
    'pingback_short' => 'Надіслати пінгбеки на всі сайти, на які посилається цей запис.',
    'pingback_disabled' => '(Пінгбек вимкнено)',
    'ping_button' => 'Надіслати пінг',
    'ping_short' => 'Пінг служб веблогів.',
    'ping_disabled' => '(Пінг вимкнено)',
    'trackback_button' => 'Надіслати трекбек',
    'trackback_short' => 'Надіслати трекбек-коментар.',
    'trackback_disabled' => '(Трекбек вимкнено)',
    'may_take_a_while' => 'Зауважте, що надсилання пінгів та пінгбеків займає певний час.',
    'ping_results' => 'Результати пінгу',
    'unknown_method' => 'Невідомий метод пінгу',
    'ping_success' => 'Пінг надіслано.',
    'error_site_name' => 'Будь-ласка, введіть назву сайту.',
    'error_site_url' => 'Будь-ласка, введіть URL сайту.',
    'error_ping_url' => 'Будь-ласка, введіть правильний пінг-URL.',
    'no_services' => 'Не сконфігуровано жодних служб веблогів.',
    'services_headline' => 'Служби веблогів',
    'service_explain' => 'Щоб змінити чи вилучити службу, натисніть її іконку нижче. Щоб додати нову службу, натисніть "Створити нове" вгорі.',
    'service' => 'Служба',
    'ping_method' => 'Метод пнгу',
    'service_website' => 'Вебсайт',
    'service_ping_url' => 'Пінгувати URL',
    'ping_standard' => 'Стандартний пінг',
    'ping_extended' => 'Розширений пінг',
    'ping_unknown' => '(невідомий метод)',
    'edit_service' => 'Редагувати службу веблогів',
    'trackbacks' => 'Трекбеки',
    'editor_intro' => 'Підготувати ваш трекбек-коментар для <a href="%s">%s</a>.',
    'editor_intro_none' => 'Підготувати ваш трекбек-коментар.',
    'trackback_note' => 'Щоб надіслати трекбек-коментар для статті, перейдіть до списку статей і натисніть "Надіслати пінг" біля статті. Щоб відправити трекбек, не пов\'язаний зі статтею, натисніть <a href="%s">тут</a>.',
    'pingback_explain' => 'Введіть URL, на який потрібно надіслати пінгбек. Пінгбек буде вказувати на головну сторінку вашого сайту.',
    'pingback_url' => 'Пінгбек-URL',
    'site_url' => 'URL цього сайту',
    'pingback_note' => 'Щоб надіслати пінгбек для статті, перейдіть до списку статей і натисніть "Надіслати пінг" біля статті. Щоб відправити пінгбек, не пов\'язаний зі статтею, натисніть <a href="%s">тут</a>.',
    'pbtarget_missing' => 'Немає пінгбек-URL',
    'pbtarget_required' => 'Будь-ласка, введіть пінгбек-URL',
    'pb_error_details' => 'Помилка під час відправлення пінгбека:',
    'delete_trackback' => 'Щоб вилучити цей трекбек, натисніть: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Архів статей',
    'title_year' => 'Архів статей за %d',
    'title_month_year' => 'Архів статей за %s %d',
    'nav_top' => 'Назад до Архіву статей',
    'no_articles' => 'Немає статей.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n нових %i за останні %t %s',
    'new_last' => 'останні %t %s',
    'minutes' => 'хвилин',
    'hours' => 'годин',
    'days' => 'днів',
    'weeks' => 'тижнів',
    'months' => 'місяців',
    'minute' => 'хвилина',
    'hour' => 'година',
    'day' => 'день',
    'week' => 'тиждень',
    'month' => 'місяць'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Січень',
    2 => 'Лютий',
    3 => 'Березень',
    4 => 'Квітень',
    5 => 'Травень',
    6 => 'Червень',
    7 => 'Липень',
    8 => 'Серпень',
    9 => 'Вересень',
    10 => 'Жовтень',
    11 => 'Листопад',
    12 => 'Грудень'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Неділя',
    2 => 'Понеділок',
    3 => 'Вівторок',
    4 => 'Середа',
    5 => 'Четвер',
    6 => 'П\'ятниця',
    7 => 'Субота'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Пошук',
    'limit_results' => 'Обмежити результати',
    'submit' => 'Надіслати',
    'edit' => 'Редагувати',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Адміністрування',
    'create_new' => 'Створити нове',
    'create_new_adv' => 'Create New (Adv.)',
    'enabled' => 'Дозволено',
    'title' => 'Заголовок',
    'type' => 'Тип',
    'topic' => 'Тема',
    'help_url' => 'URL файла довідки',
    'save' => 'Зберегти',
    'cancel' => 'Скасувати',
    'delete' => 'Вилучити',
    'delete_sel' => 'Delete selected',
    'copy' => 'Копіювати',
    'no_results' => '- Не знайдено записів -',
    'data_error' => 'Під час обробки даних сталася помилка. Будь-ласка, перевірте ваші дані.',
    'preview' => 'Попередній перегляд',
    'records_found' => 'Знайдено записи',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Коментарі дозволено',
    -1 => 'Коментарі заборонено',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => 'Звичайний',
    'nested' => 'Ієрархічний',
    'threaded' => 'Нитковидний',
    'nocomment' => 'Без коментарів'
);

$LANG_cookiecodes = array(
    0 => '(не треба)',
    3600 => '1 година',
    7200 => '2 години',
    10800 => '3 години',
    28800 => '8 годин',
    86400 => '1 день',
    604800 => '1 тиждень',
    2678400 => '1 місяць'
);

$LANG_dateformats = array(
    0 => 'Системний'
);

$LANG_featurecodes = array(
    0 => 'Звичайна',
    1 => 'Головна'
);

$LANG_frontpagecodes = array(
    0 => 'Показувати лише в темі',
    1 => 'Показувати на головній'
);

$LANG_postmodes = array(
    'plaintext' => 'Простий текст',
    'html' => 'Форматування HTML'
);

$LANG_sortcodes = array(
    'ASC' => 'Спочатку старші',
    'DESC' => 'Спочатку новіші'
);

$LANG_trackbackcodes = array(
    0 => 'Трекбек увімкнено',
    -1 => 'Трекбек вимкнено'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Save Changes',
    'reset_form' => 'Reset Form',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Configuration Manager',
    'disable' => 'Click to disable this option'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Configuration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Path',
    'site_url' => 'Site URL',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'site_name' => 'Site Name',
    'site_slogan' => 'Slogan',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Log',
    'path_language' => 'Language',
    'backup_path' => 'Backup',
    'path_data' => 'Data',
    'path_images' => 'Images',
    'path_pear' => 'Path Pear',
    'have_pear' => 'Have Pear?',
    'mail_settings' => 'Mail Settings',
    'allow_mysqldump' => 'Allow MySQL Dump',
    'mysqldump_path' => 'Path of Executable',
    'mysqldump_options' => 'MySQL Dump Options',
    'theme' => 'Theme',
    'menu_elements' => 'Menu Elements',
    'path_themes' => 'Themes Path',
    'disable_new_user_registration' => 'Disable New Registrations',
    'allow_user_themes' => 'Allow User Themes',
    'allow_user_language' => 'Allow User Language',
    'allow_user_photo' => 'Allow User Photo',
    'allow_username_change' => 'Allow Username Changes',
    'allow_account_delete' => 'Allow Account Deletion',
    'hide_author_exclusion' => 'Allow Hide Author',
    'show_fullname' => 'Show Fullname',
    'show_servicename' => 'Show Service Name',
    'custom_registration' => 'Enable Custom Registration',
    'user_login_method' => 'User Login Method',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Sort Links',
    'language' => 'Language',
    'locale' => 'Locale',
    'date' => 'Date Format',
    'daytime' => 'Daytime Format',
    'shortdate' => 'Short Date Format',
    'dateonly' => 'Date Only Format',
    'timeonly' => 'Time Only Format',
    'week_start' => 'Week Start',
    'hour_mode' => 'Hour Mode',
    'thousand_separator' => 'Thousands Separator',
    'decimal_separator' => 'Decimal Separator',
    'decimal_count' => 'Decimal Count',
    'language_files' => 'Language Files',
    'languages' => 'Languages',
    'timezone' => 'Timezone',
    'site_disabled_msg' => 'Site Disabled Message or URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Timezone Cookie Name',
    'cookie_ip' => 'Cookies embed IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Record Last Login?',
    'pdf_enabled' => 'PDF Enabled?',
    'num_search_results' => 'Number of Search Results',
    'loginrequired' => 'Login Required?',
    'submitloginrequired' => 'Submit Login Required?',
    'commentsloginrequired' => 'Comment Login Required?',
    'statsloginrequired' => 'Stats Login Required?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Story Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Story Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Stories?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'wikitext_editor' => 'Wikitext Editor?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Story Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Stories',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Stories Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Stories',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Max Images per Article',
    'limitnews' => 'Stories per Page',
    'minnews' => 'Min. Stories per Page',
    'contributedbyline' => 'Show "Contributed By"?"',
    'hideviewscount' => 'Hide Views Count?',
    'hideemailicon' => 'Hide E-Mail Icon?',
    'hideprintericon' => 'Hide Print Icon?',
    'allow_page_breaks' => 'Allow Page Breaks?',
    'page_break_comments' => 'Comments on Multi-Page Articles',
    'article_image_align' => 'Topic Icon Alignment',
    'show_topic_icon' => 'Show Topic Icon?',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'After Saving Story',
    'aftersave_user' => 'After Saving User',
    'show_right_blocks' => 'Always Show Right Blocks?',
    'showfirstasfeatured' => 'Show First Story as Featured?',
    'backend' => 'Enable Feeds?',
    'rdf_file' => 'Syndication Output Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Length of Stories in Feed',
    'rdf_language' => 'Feed Language',
    'syndication_max_headlines' => 'Max. Number of Headlines (portal blocks)',
    'copyrightyear' => 'Copyright Year',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating Allowed',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_code' => 'Comment Default',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autolinks?',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Enable URL Rewrite',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Story Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Stories in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Stories and Trackback',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Users and Submissions',
    'sg_images' => 'Images',
    'sg_locale' => 'Languages and Locale',
    'sg_misc' => 'Miscellaneous'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Paths',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Users',
    'fs_misc' => 'Miscellaneous',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Language',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Login Settings',
    'fs_search' => 'Search',
    'fs_user_submission' => 'User Submission',
    'fs_submission' => 'Submission Settings',
    'fs_topics_block' => 'Topics Block',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'What\'s New Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Story',
    'fs_theme_advanced' => 'Advanced Settings',
    'fs_syndication' => 'Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images in Articles',
    'fs_topicicon' => 'Topic Icons',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Comments',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Story Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3)
);

?>