<?php

###############################################################################
# serbian_utf-8.php
# This is the Serbian (latin) utf-8 language file for Geeklog!
# Special thanks to GOSC which motivated me to contribute to Geeklog project.
#
# By: Aleksandar Scepanovic 2009
# Contact email: ascepanovic@gmail.com
# WEB: http://www.scepanovic.info
#
# NAPOMENA: Prosto je nemoguce uskladiti prevod da svi korisnici budu zadovoljni
# ako imate bilo koji predlog za izmenu prevoda ili ste uocili gresku molim
# da me kontaktirate kako bi ista bila ispravljena
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'UTF-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Autor:',
    2 => 'detaljnije',
    3 => 'komentar(a)',
    4 => 'Izmeni',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Za Administratora:',
    10 => 'Zahtevi',
    11 => 'Tekst(a)',
    12 => 'Blokovi',
    13 => 'Kategorije',
    14 => '',
    15 => '',
    16 => '',
    17 => 'Korisnici',
    18 => 'SQL upit',
    19 => 'Odjava',
    20 => 'Korisničke postavke:',
    21 => 'Korisničko ime',
    22 => 'Korisnički ID',
    23 => 'Sigurnosni nivo',
    24 => 'Anonimni korisnik',
    25 => 'Odgovori',
    26 => 'Prikazani komentari su vlasništvo autora istih. Mi nismo odgovorni za njihov sadržaj',
    27 => 'Najnoviji tekst',
    28 => 'Obriši',
    29 => 'Nema korisničkih komentara.',
    30 => 'Stariji tekstovi',
    31 => 'Dozvoljeni HTML kodovi:',
    32 => 'Greška, korisničko ime nije ispravno',
    33 => 'Greška, ne mogu pisati u log fajlove',
    34 => 'Greška',
    35 => 'Odjavi se',
    36 => 'on',
    37 => 'Nema korisničkih tekstova',
    38 => 'RSS',
    39 => 'Osveži',
    40 => '',
    41 => 'Gosti',
    42 => 'Autor:',
    43 => 'Odgovori na ovo',
    44 => 'Roditelj',
    45 => 'MySQL greška broj',
    46 => 'MySQL poruka greške',
    47 => 'Korisnici',
    48 => 'Korisničke postavke',
    49 => 'Moj nalog',
    50 => 'Greška u SQL naredbi',
    51 => 'pomoć',
    52 => 'Novi',
    53 => 'Administracija',
    54 => 'Ne mogu otvoriti log fajl.',
    55 => 'Greška u',
    56 => 'Glasaj',
    57 => 'Lozinka',
    58 => 'Prijava',
    59 => "Nemate korisnički nalog? Kreirajte ga besplatno <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">Ovde</a>",
    60 => 'Pošaljite komentar',
    61 => 'Kreiraj Novi Nalog',
    62 => 'reči',
    63 => 'Postavke komentara',
    64 => 'Pošalji tekst prijatelju',
    65 => 'Pogledaj verziju za štampu',
    66 => '',
    67 => 'Dobrodošli na ',
    68 => 'Početna',
    69 => 'Kontakt',
    70 => 'Pretraga',
    71 => 'Doprinesi',
    72 => 'Web izvori',
    73 => '',
    74 => '',
    75 => 'Napredna pretraga',
    76 => 'Statistika web stranice',
    77 => 'Pluginovi',
    78 => '',
    79 => 'Šta je novo',
    80 => 'tekst(ovi) u poslednjih',
    81 => 'tekst(ova) u zadnjih',
    82 => 'sati',
    83 => 'Komentari',
    84 => '',
    85 => 'poslednjih 48 sati',
    86 => 'Nema novih komentara',
    87 => 'poslednje 2 sedmice',
    88 => '',
    89 => '',
    90 => 'Početna stranica',
    91 => 'Stranica generisana za',
    92 => 'sekundi',
    93 => 'Copyright',
    94 => 'Svi zaštitni znakovi i autorska prava pripadaju vlasnicima istih',
    95 => 'Sajt pokreće',
    96 => 'Korisničke grupe',
    97 => 'Lista reči',
    98 => 'Pluginovi',
    99 => 'Tekstovi',
    100 => 'Nema novih tekstova',
    101 => '',
    102 => '',
    103 => 'Sigurnosne Kopije',
    104 => 'od',
    105 => 'Pošalji emali korisnicima',
    106 => 'Ukupno pregleda:',
    107 => 'Provera Geeklog verzije',
    108 => 'Obriši Cache',
    109 => 'Prijavi zloupotrebu',
    110 => 'Prijavi ovaj tekst administratoru',
    111 => '',
    112 => 'Registrovani Korisnici',
    113 => 'Dokumentacija',
    114 => 'TRACKBACKS',
    115 => 'Nema novih trackback komentara',
    116 => 'Trackback',
    117 => 'Katalog',
    118 => 'Nastavi sa čitanjem na sledećoj strani:',
    119 => "Zaboravili ste <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">lozinku</a>?",
    120 => 'Direktan link za komentar',
    121 => 'Komentari (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'Kompletan HTML je dozvoljen',
    124 => 'Klik za brisanje svih čekiranih stavki',
    125 => 'Da li ste sigurni da želite da obrišete čekirane stavke?',
    126 => 'Selektuj de-selektuj sve stavke',
    127 => 'Direktan link',
    128 => 'Prijavi se sa OpenID:',
    129 => 'Podešavanja',
    130 => 'Web Servisi'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Pošalji komentar',
    2 => 'Postavke slanja',
    3 => 'Odjava',
    4 => 'Kreirajte korisnički nalog',
    5 => 'Korisničko ime',
    6 => 'Da bi poslali komentar, morate biti prijavljeni. Molimo prijavite se. Ako nemate korisnički nalog možete ga besplatno kreirati.',
    7 => 'Vaš poslednji komentar je bio pre ',
    8 => " sekundi.  Stranica zahteva da prođe najmanje {$_CONF['commentspeedlimit']} sekundi između komentara",
    9 => 'Komentar',
    10 => 'Pošalji Izveštaj',
    11 => 'Pošalji Komentar',
    12 => 'Molim popunite polje Naslov i Komentar!',
    13 => 'Vaše informacije',
    14 => 'Pregled',
    15 => 'Prijavi komentar',
    16 => 'Naslov',
    17 => 'Greška',
    18 => 'Važno',
    19 => 'Molimo Vas da se pridržavate teme.',
    20 => 'Molimo Vas da odgovarate na već objavljene komentare umesto da započinjete nove teme.',
    21 => 'Pre nego pošaljete komentar, molimo pročitajte komentare ostalih korisnika kako bi izbegli ponavljanje.',
    22 => 'Budite jasni kako bi ostalima bilo jasno šta ste želeli da kažete.',
    23 => 'Vaša email adresa nije javno dostupna.',
    24 => 'Anonimni korisnik',
    25 => 'Sigurno želite da prijavite ovaj komentar administratoru?',
    26 => '%s prijavljena zloupotreba u sledećem komentaru:',
    27 => 'Prijavi zloupotrebu',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications',
    44 => 'Your Name'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Profil korisnika',
    2 => 'Korisničko ime',
    3 => 'Puno ime',
    4 => 'Lozinka',
    5 => 'Email adresa',
    6 => 'Web stranica',
    7 => 'Biografija',
    8 => 'PGP ključ',
    9 => 'Sačuvaj informacije',
    10 => 'Poslednjih 10 komentara od korisnika',
    11 => 'Nema korisničkih komentara',
    12 => 'Korisnička podešavanja za',
    13 => 'Email beleške',
    14 => 'Ova lozinka je kreirana slučajnim izborom. Preporučujemo da što pre promenite istu. Da biste promenili lozinku, prijavite se i uđite u Korisničke postavke',
    15 => "Vaš {$_CONF['site_name']} nalog je uspešno kreiran. Da biste ga koristili, morate se prijaviti koristeći vaše informacije. Molimo sačuvajte ovu poruku.",
    16 => 'Informacije o vašem nalogu',
    17 => 'Korisnički nalog nije definisan',
    18 => 'Upisana email adresa nije validna.',
    19 => 'Korisničko ime ili email adresa koju ste uneli već postoji u bazi.',
    20 => 'Email adresu koju ste uneli ne mozemo prihvatiti jer nije validna',
    21 => 'Greška',
    22 => "Registracija na {$_CONF['site_name']}!",
    23 => "Kreiranjem korisničkog naloga imate samo prednosti na {$_CONF['site_name']} i možete koristiti neke funkcije koje obični korisnici nemogu. Ako nemate nalog, sve što radite beleži se za anonimnog korisnika. Molimo zapamtitie da vaš email <b><i>nikada</i></b> neće biti javno prikazan na ovom sajtu.",
    24 => 'Lozinka će biti poslata na email adresu koju ste uneli.',
    25 => 'Zaboravili ste lozinku?',
    26 => 'Ukucajte <em>vaše</em> korisničko ime <em>ili</em> email addresu koju ste koristili prilikom registracije i kliknite na Pošalji Lozinku. Instrukcije za postavljanje vaše nove lozinke šaljemo na vaš email.',
    27 => 'Registruj se ',
    28 => 'Pošalji Lozniku',
    29 => 'forma za odjavu',
    30 => 'forma za prijavu',
    31 => 'Izabrane funkcije zahtevaju da budete prijavljeni',
    32 => 'Potpis',
    33 => 'Nikada ne prikazuj javno',
    34 => 'Ovo je vaše pravo ime',
    35 => 'Unesite novu lozinku za promenu',
    36 => 'Počinje sa http://',
    37 => 'Prikazuje se u vašim komentarima',
    38 => 'Sve o vama! Svi to mogu čitati',
    39 => 'Vaš javni PGP kljuc',
    40 => 'Kategorija nema ikonu',
    41 => 'Želite biti moderator',
    42 => 'Format datuma',
    43 => 'Maksimalno tekstova',
    44 => 'Nema blokova',
    45 => 'Postavke prikazivanja za',
    46 => 'Delovi za izvršavanje za',
    47 => 'Konfiguracija tekstova za',
    48 => 'Kategorije',
    49 => 'Nema ikone u tekstu',
    50 => 'Deselektuje ovo ako niste zainteresovani',
    51 => 'Samo novi tekstovi',
    52 => 'Podrazumevani',
    53 => 'Primi nove vesti svaku noć',
    54 => 'Označi blokove za naslove i autore koje ne zeliš da vidiš.',
    55 => 'Ako ovo ostavite kako jeste, to znači da hoćete obične selekcije blokova. Ako počnete birati blokove, zapamtite da postavite sve one koje želite jer će obična postavka biti zanemarena. Obične postavke su boldirane.',
    56 => 'Autori',
    57 => 'Način prikazivanja',
    58 => 'Sortiraj po',
    59 => 'Maksimalno komentara',
    60 => 'Kako želite da se vaši komentari prikazuju?',
    61 => 'Noviji ili najstariji prvo?',
    62 => 'Podrazumevano je 100',
    63 => "Vaša lozinka vam je poslata putem emaila i trebali biste je primiti svakog trenutka. Molimo pratite instrukcije koje ste dobili u poruci i zahvaljujemo vam za prijavu na {$_CONF['site_name']}",
    64 => 'Postavke komentara za',
    65 => 'Pokušajte ponoviti prijavu',
    66 => "Verovatno ste pogrešno uneli korisničko ime ili lozinku. Pokušajte se ponovo prijaviti. Jeste li <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">novi korisnik</a>?",
    67 => 'Član od',
    68 => 'Pamti me',
    69 => 'Koliko dugo želite biti prijavljeni?',
    70 => "Postavi izgled sajta {$_CONF['site_name']}",
    71 => "Jedna od velikih prednosti {$_CONF['site_name']} je ta što možete promeniti izgled sajta po vašoj volji. Da biste to mogli učiniti morate se prvo <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">registrovati</a> na {$_CONF['site_name']}. Ako ste već član, koristite vaše podatke i prijavite se!",
    72 => 'Kategorija',
    73 => 'Jezik',
    74 => 'Promeni izgled sajta!',
    75 => 'Email-ovani tekstovi za',
    76 => 'Ako selektujete kategoriju iz liste ispod, primit ćete svaki novi tekst vezan za tu kategoriju na kraju svakog dana. Izaberi jedino onu kategoriju koja te zaista zanima!',
    77 => 'Fotografija',
    78 => 'Dodaj vlastitu fotografiju!',
    79 => 'Označi ovde za brisanje fotografije',
    80 => 'Prijava',
    81 => 'Šalji email',
    82 => 'Poslednjih 10 tekstova od korisnika',
    83 => 'Statistika slanja tekstova i komentara za korisnika',
    84 => 'Ukupan broj tekstova:',
    85 => 'Ukupan broj komentara:',
    86 => 'Pronađi sve tekstove od',
    87 => 'Vaše korisničko ime',
    88 => "Neko (verovatno vi) je zatražio novu lozinku za vas korisnički nalog \"%s\" na {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nAko ste to zaista hteli molimo kliknite na ovaj link za potvrdu:\n\n",
    89 => "Ako ne želite to napraviti, jednostavno ignorišite poruku (lozinka će ostati nepromenjena).\n\n",
    90 => 'Možete ukucati novu lozinku za vaš nalog ispod. Molimo zabeležite da ja vaša stara lozinka i dalje validna dok neprimite novu.',
    91 => 'Postavi novu lozinku',
    92 => 'Unesi novu lozinku',
    93 => 'Vaš poslednji zahtev za novom lozinkom je bio pre %d sekundi. Ovaj sajt zahteva barem %d sekundi izmedđu zahteva za slanje lozinke.',
    94 => 'Obriši korisnički nalog "%s"',
    95 => 'Pritisni "Obriši korisnički nalog" dugme ispod da biste obrisali vaš nalog iz naše baze podataka. Molimo zapamtite da bilo koja vest ili komentar poslat sa vaše strane pod ovim korisničkim računom <strong>neće</strong> biti izbrisan, već će se prikazivati kao vlasništvo korisnika "Anonimus".',
    96 => 'Obriši korisnički nalog',
    97 => 'Potvrdi brisanje korisničkog naloga',
    98 => 'Da li ste sigurni da želite obrisati nalog? Ako to želite nećete više moći koristiti ovaj sajt kako ste pre mogli (ukoliko ne kreirate novi nalog). Ako ste sigurni da to želite uraditi pritisnite "Obriši korisnički nalog".',
    99 => 'Opcije privatnosti za ',
    100 => 'Email od administratora',
    101 => 'Dozvoli mailove od webmastera',
    102 => 'Email od korisnika',
    103 => 'Dozvoli primanje emailova od korisnika',
    104 => 'Prikaži online status',
    105 => 'Prikaži ko je online u bloku',
    106 => 'Lokacija',
    107 => 'Prikaži u javnom profilu',
    108 => 'Potvrdi novu lozinku',
    109 => 'Unesi novu lozinu ponovo',
    110 => 'Trenutna lozinka',
    111 => 'Molimo unesite trenutnu lozinku',
    112 => 'Prekoračli ste dozvoljen broj pokušaja za prijavu. Molimo pokušajte kasnije.',
    113 => 'Pokušaj prijave neuspešan',
    114 => 'Nalog Blokiran',
    115 => 'Vaš nalog je blokiran, niste u mogućnosti da se prijavite. Molimo kontaktirajte Administratora.',
    116 => 'Nalog je u procesu aktivacije',
    117 => 'Vaš nalog je trenutno u aktivacionom procesu i čeka odobrenje od strane Administratora. Nećete biti u mogućnosti da se prijavite sve dok vaš nalog nebude odobren.',
    118 => "Vaš {$_CONF['site_name']} nalog je aktiviran od strane administratora. Sada se možete prijaviti na sajt korišćenjem vašeg korisničkog imena (<username>) i lozinke koju smo vam ranije poslali.",
    119 => 'Ako ste zaboravili lozinku, možete zatražiti novu na ovoj adresi:',
    120 => 'Nalog aktiviran',
    121 => 'Opcije',
    122 => 'Proces registracije novih korisnika je trenutno blokiran',
    123 => "Da li ste <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">novi korisnik</a>?",
    124 => 'Potvrdi Email',
    125 => 'Morate uneti identičnu email adresu u oba polja!',
    126 => 'Molimo ponovite zbog potvrde',
    127 => 'Kako bi promenili bilo koje od ovih podešavanja, morate uneti vašu trenutnu lozinku.',
    128 => 'Vaše Ime',
    129 => 'Lozinka i Email',
    130 => 'O Vama',
    131 => 'Daily Digest Options',
    132 => 'Daily Digest Feature',
    133 => 'Prikaz Komentara',
    134 => 'Opcije Komentara',
    135 => '<li>Podrazumevani mod za komentare će sada biti prikazan</li><li>Podrazumevani način za sortiranje komentara</li><li>Postavite maksimalan broj komentara za prikaz - podrazumeva se 100</li>',
    136 => 'Zanemari Tekstove i Autore',
    137 => 'Filtriraj Sadržaj Teksta',
    138 => 'Ostala podešavanja',
    139 => 'Izgled i Jezik',
    140 => '<li>Ako je čekirano Kategorija nema ikonu, ikonica neće biti prikazivana kod pregleda kategorija.</li><li>Ako je čekirana opcija Nema blokova biće prikazan samo Administratorski, Korisnički Meni i Kategorije<li>Postavi maksimalan broj tekstova za prikaz po strani</li><li>Postavi svoju temu i želejni format datuma</li>',
    141 => 'Podešavanje Privatnosti',
    142 => 'Podrazumevano podešavanje je da korisnici i administratori mogu da pošalju email članovima sajta i da mogu da prikažu vaš online status. De-čekirajte ove opcije kako bi zaštitili vašu privatnost.',
    143 => 'Filtriraj Blok Sadržaj',
    144 => 'Prikaži i sakrij blokove',
    145 => 'Vaš Javni Profil',
    146 => 'Lozinka i email',
    147 => 'Izmeniti vašu lozinku, email, autologin opciju. Morate uneti identičnu lozinku ili email dva puta zbog potvrde.',
    148 => 'Korisničke Informacije',
    149 => 'Izmenite vaše korisničke informacije koje će biti prikazane drugim korisnicima.<li>Potpis će biti dodat na svaki komentar ili post na forumu koji objavite</li><li>Biografija predstavlja kratke informacije o Vama koje želite da podelite</li><li>Podelite Vaš PGP Ključ</li>',
    150 => 'Upozorenje: Javascript se preporučuje zbog poboljšanih performansi.',
    156 => 'Obriši Nalog',
    157 => 'Obirši Opciju',
    158 => 'Vremenska Zona',
    159 => 'Ovaj email je automatski generisan. Molimo nemojte odgovarati na njega.',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Pregled',
    'pe_namepass' => 'Korisničko Ime i Lozinka',
    'pe_userinfo' => 'O Vama',
    'pe_layout' => 'Prikaz i Jezik',
    'pe_content' => 'Sadržaj',
    'pe_privacy' => 'Privatnost'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Nema tekstova za prikaz.',
    2 => 'Nema novih tekstova za prikaz. Možda nema tekstova',
    3 => ' u kategoriji %s',
    4 => 'Današnji bitni tekstovi',
    5 => 'Sledeći',
    6 => 'Prethodni',
    7 => 'Prvi',
    8 => 'Poslednji'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Prilikom slanja dogodila se greška. Molimo pokušajte ponovo.',
    2 => 'Poruka je uspešno poslata.',
    3 => 'Molimo koristite validnu email adresu u Primalac polju.',
    4 => 'Molimo popunite polja: Vaše ime, Primalac, Naziv maila i Poruku',
    5 => 'Greška: Korisnik ne postoji.',
    6 => 'Došlo je do greške.',
    7 => 'Korisnički profil za',
    8 => 'Korisničko ime',
    9 => 'Korisnički URL',
    10 => 'Šalji email',
    11 => 'Vaše ime:',
    12 => 'Primalac:',
    13 => 'Naziv maila:',
    14 => 'Poruka:',
    15 => 'HTML kod neće biti prikazan.',
    16 => 'Pošalji poruku',
    17 => 'Pošalji tekst e-mailom',
    18 => 'Šaljete (kome)',
    19 => 'Na email adresu',
    20 => 'Od',
    21 => 'Vaš email',
    22 => 'Potrebno je sve popuniti',
    23 => "Ovaj email vam je poslat od %s sa %s zato jer korisnik misli da će vas zanimati tekst sa web stranice {$_CONF['site_url']}.  Ovo NIJE SPAM, i vaše email adrese nisu sačuvane i neće se koristiti za dalju upotrebu.",
    24 => 'Komentar za ovaj tekst na',
    25 => 'Morate biti prijavljeni da bi mogli koristiti ovu postavku.',
    26 => 'Ovaj formular vam dozvoljava slanje emailova određenim korisnicima. Potrebno je popuniti sve podatke.',
    27 => 'Kratka poruka',
    28 => '%s piše: ',
    29 => "Ovo su dnevni tekstovi sa {$_CONF['site_name']} za ",
    30 => ' Dnevni tekstovi za ',
    31 => 'Naziv',
    32 => 'Datum',
    33 => 'Pročitaj kompletan tekst na',
    34 => 'Kraj poruke',
    35 => 'Žao mi je, korisnik ne dozvoljava prijem poruka.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Napredna pretraga',
    2 => 'Ključne reči',
    3 => 'Kategorija',
    4 => 'Sve',
    5 => 'Vrsta',
    6 => 'Tekstovi',
    7 => 'Komentari',
    8 => 'Autori',
    9 => 'Svi',
    10 => 'Pretraživanje',
    11 => 'Rezultati pretraživanja',
    12 => 'pogodaka',
    13 => 'Rezultati pretraživanja: Nema rezultata',
    14 => 'Nema rezultata koji odgovaraju vašem upitu',
    15 => 'Molimo pokušajte ponovo.',
    16 => 'Naslov',
    17 => 'Datum',
    18 => 'Autor',
    19 => "Pretražite bazu podataka web stranice {$_CONF['site_name']} naše trenutne i arhivirane tekstove",
    20 => 'Datum',
    21 => 'do',
    22 => '(Format datuma GGGG-MM-DD)',
    23 => 'Pregleda',
    24 => 'Pronađeno %d rezultata',
    25 => 'Traženo za',
    26 => 'upita ',
    27 => 'sekundi',
    28 => 'Nema odgovarajućih tekstova ili komentara za upit koji ste zadali',
    29 => 'Rezultati tekstova i komentara',
    30 => '',
    31 => 'Ovaj plug-in nije ništa pronašao',
    32 => '',
    33 => 'URL',
    34 => 'Lokacija',
    35 => 'Celi dan',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Vaš upit mora sadržati više od 3 znaka.',
    42 => 'Molimo koristite format datuma GGGG-MM-DD (godina-mesec-dan).',
    43 => 'tačan izraz',
    44 => 'sve reči',
    45 => 'bilo koja od ovih reči',
    46 => 'Sledeći',
    47 => 'Prethodni',
    48 => 'Autor',
    49 => 'Datum',
    50 => 'Pregleda',
    51 => '',
    52 => 'Lokacija',
    53 => 'Rezultati za tekstove',
    54 => 'Rezultati za komentare',
    55 => 'izraz(e)',
    56 => 'I',
    57 => 'ILI',
    58 => 'Još rezultata &gt;&gt;',
    59 => 'Rezultati',
    60 => 'po strani',
    61 => 'Napredna pretraga',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Story',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Statistika web stranice',
    2 => 'Ukupno poseta na sve strane',
    3 => 'Tekstova(Komentara) na stranama',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Najčitaniji tekstovi',
    8 => 'Naslov teksta',
    9 => 'Pregleda',
    10 => 'Na stranama nema niti jednog teksta ili ni jedan tekst nije pročitan.',
    11 => 'Tekstovi sa najvećim brojem komentara',
    12 => 'Komentari',
    13 => 'Na stranicama nema niti jednog poslatog teksta ili teksta na kojem ima komentara.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Tekstovi koji su najčešce slani emailom',
    23 => 'Emailovi',
    24 => 'Niko nije poslao tekst emailom sa ovih stranica.',
    25 => 'Prvih 10 Trackback Komentarisanih Tekstova',
    26 => 'Trackback komentari nisu pronađeni.',
    27 => 'Broj aktivnih korisnika',
    28 => '',
    29 => '',
    30 => 'Pregleda',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Linkovi u tekstu',
    2 => 'Pošalji tekst emailom',
    3 => 'Vezija za štampu',
    4 => 'Opcije teksta',
    5 => '',
    6 => 'Prijavi se za \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Da pošaljete tekst %s morate biti ulogovani.',
    2 => 'Prijava',
    3 => 'Novi korisnik',
    4 => '',
    5 => '',
    6 => 'Pošaljite tekst',
    7 => 'Prijava je neophodna',
    8 => 'Potvrdi',
    9 => 'Kada šaljete informacije za korišćenje na ovom sajtu molimo vas da pratite sledeće savete...<ul><li>Morate popuniti sva polja<li>Pošaljite kompletne i tačne informacije<li>Dva puta proverite ove URL-ove</li></ul>',
    10 => 'Naziv',
    11 => '',
    12 => 'Počinje dana',
    13 => 'Završava dana',
    14 => 'Lokacija',
    15 => 'Opis',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Molimo pročitajte tekst koji sledi',
    20 => '',
    21 => '',
    22 => 'Greška: Polja nisu popunjena',
    23 => 'Molimo popunite sva polja. Sva polja su obavezna.',
    24 => 'Tekst sačuvan',
    25 => 'Vaš %s tekst je uspešno sačuvan',
    26 => 'Spam Zaštita',
    27 => 'Korisničko ime',
    28 => 'Kategorija',
    29 => 'Tekst',
    30 => 'Poslali ste tekst pre',
    31 => " sekundi. Ovaj sajt zahteva barem {$_CONF['speedlimit']} sekundi razmaka između slanja tekstova",
    32 => 'Pogledaj',
    33 => 'Pogledaj kako tekst izgleda',
    34 => 'Odjava',
    35 => 'HTML kodovi nisu dozvoljeni',
    36 => 'Način slanja',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Adresa 1',
    45 => 'Adresa 2',
    46 => 'Grad',
    47 => 'Država',
    48 => 'Zip kod',
    49 => '',
    50 => '',
    51 => 'Lokacija',
    52 => 'Obriši',
    53 => 'Kreiraj nalog',
    54 => 'Uvodni Tekst',
    55 => 'Kompletan Tekst'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Autorizacija neophodna',
    2 => 'Pristup Zabranjen! Netačne informacije u prijavi',
    3 => 'Neispravna korisnička lozinka',
    4 => 'Korisničko ime:',
    5 => 'Lozinka:',
    6 => 'Svaki pokušaj pristupa administratorskim delovima se loguje i proverava.<br' . XHTML . '>Ova stranica je isključivo namenjena određenim autorizovanim članovima.',
    7 => 'prijava'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Neispravna Administratorska prava',
    2 => 'Nemate potrebna prava za izmenu Bloka.',
    3 => 'Blok Editor',
    4 => 'Došlo je do problema prilikom čitanja ovog feed-a (pogledaj error.log za više detalja).',
    5 => '',
    6 => '',
    7 => 'Svi',
    8 => 'Sigurnosni nivo Bloka',
    9 => 'Redosled Bloka',
    10 => '',
    11 => 'Portal Blok',
    12 => 'Normalni Blok',
    13 => 'Opcije Portal Bloka',
    14 => 'RSS URL',
    15 => 'Poslednji RSS Update',
    16 => 'Opcije Normalnog Bloka',
    17 => 'Sadržaj Bloka',
    18 => 'Molimo popunite Naziv Bloka i polja sa sadržajem',
    19 => 'Blok Menadžer',
    20 => '',
    21 => 'Specijalni nivo Bloka',
    22 => '',
    23 => 'Zadatak Bloka',
    24 => '',
    25 => 'Da biste modifikovali Blok ili ga izbrisali, kliknite dole na željeni link. Da biste napravili novi Blok, kliknite na "Kreiraj Novi" iznad.',
    26 => 'Izgled Bloka',
    27 => 'PHP Blok',
    28 => 'Opcije PHP Bloka',
    29 => 'Funkcije Bloka',
    30 => 'Ako želite da imate jedan svoj Blok koristite PHP kod, upišite ime funkcije iznad. Ime vaše funkcije mora početi sa prefiksom "phpblock_" (npr. phpblock_getweather). Ako nemate ovaj prefiks, vaša funkcija NEĆE biti pozvana. Ovo radimo zbog toga da bismo zadržali ljude koji su možda uspeli upasti u vaš proces instalacije menjajući neke funkcije i pozivajući se na njih i koje mogu biti kritične za vaš sistem. Budite sigurni da negde ne ostavite prazne zagrade "()" posle vašeg imena funkcije. Na kraju, preporučljivo je da smestite sve svoje PHP kodove Blokova u /path/to/geeklog/system/lib-custom.php. To će omogućiti kodu da ostane sa vama i na svom mestu čak i kada nadogradite verziju Geeklog-a.',
    31 => 'Greška u PHP Bloku. Funkcija, %s, ne postoji.',
    32 => 'Greška, nedostaje/u polje/a',
    33 => 'Morate navesti URL za pristup RSS fajlu za portal blok',
    34 => 'Morate navesti naziv i funkciju za PHP blokove',
    35 => 'Morate upisati naziv i sadržaj za normalne blokove',
    36 => 'Morate upisati sadržaj za izgled blokova',
    37 => 'Loše ime funkcije PHP bloka',
    38 => 'Funkcije za PHP Blokove moraju imati prefiks \'phpblock_\' (npr. phpblock_getweather). Prefiks \'phpblock_\' je potreban iz sigurnosnih razloga da bi se zaštitio deo koda za izvršavanje.',
    39 => 'Strana',
    40 => 'Levo',
    41 => 'Desno',
    42 => 'Morate navesti Ime Bloka i Namenu Bloka za obične Geeklog blokove.',
    43 => 'Jedino na početnoj strani(Home/index)',
    44 => '',
    45 => "Pokušavate pristupati bloku za koji nemate prava pristupa. Ovaj pokušaj pristupa je zabeležen. Molimo <a href=\"{$_CONF['site_admin_url']}/block.php\">vratite se nazad</a>.",
    46 => 'Novi Blok',
    47 => '',
    48 => 'Naziv Bloka',
    49 => ' (nema razmaka i mora biti jedinstven)',
    50 => 'The Block Name can not be empty',
    51 => 'uključujući http://',
    52 => 'Ako ostavite ovo prazno help ikona za ovaj blok se neće prikazati',
    53 => 'Omogući',
    54 => 'sačuvaj',
    55 => 'odustani',
    56 => 'obriši',
    57 => 'Pomeri Blok dole',
    58 => 'Pomeri Blok gore',
    59 => 'Prebaci Blok na desnu stranu',
    60 => 'Prebaci Blok na levu stranu',
    61 => 'Nema Naziva',
    62 => 'Limit Tekstova',
    63 => 'Loš Naziv',
    64 => 'Vaš Naziv nesme biti prazan i nesme sadržati HTML!',
    65 => 'Redosled',
    66 => 'Autotagovi',
    67 => 'Klikni da omogućiš autotagove',
    68 => 'Feed za portal blog je previše dugačak za prikaz. Molimo podesite maximalan broj tekstova za import u samoj blok konfiguraciji ili u globalnim Geeklog Podešavanjima.'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Prethodni tekst',
    2 => 'Sledeći tekst',
    3 => 'Režim',
    4 => 'Postavke slanja',
    5 => 'Izmena teksta',
    6 => 'Nema teksta u sistemu.',
    7 => 'Autor',
    8 => 'sačuvaj',
    9 => 'pregled',
    10 => 'otkaži',
    11 => 'obriši',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Datum',
    16 => 'Uvodni tekst',
    17 => 'Kompletan tekst',
    18 => 'Pregleda',
    19 => 'Komentari',
    20 => 'Ping',
    21 => 'Pošalji Ping',
    22 => 'Pregled tekstova',
    23 => 'Da biste izmenili ili obrisali neki tekst, kliknite na ikonicu u "Izmeni" polju. Da biste pregledali tekst, kliknite na naziv teksta koji želite pregledati. Ako želite da napišete novi tekst izaberite opciju "Kreiraj novi" koja se nalazi iznad.',
    24 => 'ID koji ste izabrali za ovaj tekst već je iskorišćen. Molimo promenite ID.',
    25 => 'Greška prilikom čuvanja teksta',
    26 => 'Pregled teksta',
    27 => 'Ako koristite [unscaledX] umesto [imageX], slika će biti dodata sa njenim orginalnim dimenzijama.',
    28 => '<p><b>PREGLED</b>: Pregled teksta sa slikama je najbolji u slučaju kada tekst sačuvate korišćenjem draft opcije, mnogo bolji nego ako koristite samo dugme za pregled.  Predlažemo da dugme za pregled koristite samo kada tekst ne sadrži slike.',
    29 => 'Trackbacks',
    30 => 'Greške prilikom dodavanja fajla',
    31 => 'Molimo popunite polja Naziv i Uvodni tekst',
    32 => 'Uobliči',
    33 => 'Može biti samo jedan uobličeni tekst',
    34 => 'Draft',
    35 => 'Da',
    36 => 'Ne',
    37 => 'Više od',
    38 => 'Više iz',
    39 => 'Emailovi',
    40 => '',
    41 => "Pokušavate pristupati tekstu za koji nemate prava pristupa. Ovaj pokušaj pristupa je zabeležen. Možete pogledati tekst u delu samo čitanje ispod. Molimo <a href=\"{$_CONF['site_admin_url']}/story.php\">vratite se nazad</a> kada završite.",
    42 => "Pokušavate pristupiti tekstu za koji nemate prava pristupa. Ovaj pokušaj pristupa je zabeležen. Molimo <a href=\"{$_CONF['site_admin_url']}/story.php\">vratite se nazad</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>NAPOMENA:</b> ako podesite ovaj datum da se prikaže u budućnosti, ovaj tekst neće biti objavljen sve do tog datuma. To takođe znači da ovaj tekst neće biti uključen u vaš RSS headline feed i isti će biti ignorisan na statičkim i stranama pretrage.',
    47 => 'Slike',
    48 => 'slika',
    49 => 'desno',
    50 => 'levo',
    51 => '<p>Da biste dodali jednu od vaših slika određenom tekstu morate ubaciti specijalno formirani tekst. Taj tekst izgleda ovako [imageX], [imageX_right] ili [imageX_left] gde je X broj slike koju ste ubacili. NAPOMENA: Morate koristiti sliku koju ste već odabrali za taj tekst. Ako to ne učinite nećete moći sačuvati tekst.<BR><P><B>PREGLED</B>: Pregled teksta sa slikama je najbolji u slučaju kada tekst sačuvate korišćsenjem draft opcije, mnogo bolji nego ako koristite samo dugme za pregled.  Predlažemo da dugme za pregled koristite samo kada tekst ne sadrži slike.</p>',
    52 => '',
    53 => 'nije korišćena. Morate uključiti ovu sliku u uvodni ili kompletan tekst pre nego sačuvate izmene',
    54 => 'Uključene slike nisu korišćene',
    55 => 'Sledeće greške su se pojavile prilikom pokušaja čuvanja teksta.  Molimo ispravite ove greške pre čuvanja',
    56 => 'Prikaži ikonu kategorije',
    57 => 'Pogledaj ne-skaliranu sliku',
    58 => 'Tekst Menadžer',
    59 => 'Opcija',
    60 => '',
    61 => 'Automatsko Arhiviranje',
    62 => 'Automatsko Brisanje',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Proširi Polje Za Izmenu',
    68 => 'Smanji Polje Za Izmenu',
    69 => 'Datum Objavljivanja Teksta',
    70 => 'Izbor Toolbar-a',
    71 => 'Osnovni Toolbar',
    72 => 'Jednostavan Toolbar',
    73 => 'Napredni Toolbar',
    74 => 'Napredni II Toolbar',
    75 => 'Full Uoblicen',
    76 => 'Opcije Objavljivanja',
    77 => 'Javascript mora biti omogućen za korišćenje Naprednog Editora. Opcija može biti onemogućena u config.php fajlu',
    78 => 'Klikni <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">ovde</a> za korišćenje podrazumevanog editora',
    79 => 'Pregled',
    80 => 'Editor',
    81 => 'Opcije Objavljivanja',
    82 => 'Slike',
    83 => 'Opcije Arhiviranja',
    84 => 'Dozvole',
    85 => 'Prikaži Sve',
    86 => 'Napredni Editor',
    87 => 'Tekst Statistka',
    88 => 'Wiki-stil format',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Menadžer Kategorija',
    2 => 'Kategorija ID',
    3 => 'Naziv Kategorije',
    4 => 'Slika Kategorije',
    5 => '(bez razmaka)',
    6 => 'Brisanje kategorije sa sobom povlači i brisanje svih tekstova koji se nalaze u njoj!',
    7 => 'Molimo popunite polja Kategorija ID i Naziv Kategorije',
    8 => 'Menadžer Kategorija',
    9 => 'Da izmenite ili obrišete kategoriju kliknite na istu. Da kreirate novu kategoriju kliknite na "Kreiraj Novi" dugme iznad. Možete podesiti i prava pristupa za svaku kategoriju ponaosob. Znak(*) označava podrazumevanu kategoriju.',
    10 => 'Sortirano po',
    11 => 'Tekstova po strani',
    12 => 'Pristup odbijen.',
    13 => "Pokušavate da pristupite kategorij za koju nemate prava pristupa. Ovaj pokušaj je zabeležen. Molimo<a href=\"{$_CONF['site_admin_url']}/topic.php\">vratite se nazad na administraciju</a>.",
    14 => 'Metode sortiranja',
    15 => 'leksikografski',
    16 => 'podrazumevano je',
    17 => 'Nova kategorija',
    18 => 'Admin Home',
    19 => 'sačuvaj',
    20 => 'otkaži',
    21 => 'obriši',
    22 => 'Podrazumevano',
    23 => 'neka ova kategorija bude podrazumevana kategorija za tekstove koje šalju korisnici',
    24 => '(*)',
    25 => 'Arhiviraj Kategoriju',
    26 => 'neka ova kategorija bude podrazumevana za arhiviranje tekstova. Samo jedna kategorija je dozvoljena za ovo.',
    27 => 'Ili Uploaduj Ikonu Kategorije',
    28 => 'Makismalna veličina',
    29 => 'Greška Prilkom Uplod-a',
    30 => 'Stories in Topic'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Korisničko uređivanje',
    2 => 'Korisnički ID',
    3 => 'Korisničko Ime',
    4 => 'Ime i Prezime',
    5 => 'Lozinka',
    6 => 'Sigurnosni Nivo',
    7 => 'Email Adresa',
    8 => 'Web Stranica',
    9 => '(ne koristite razmake)',
    10 => 'Molimo popunite polja Korisničko ime i Email adresa',
    11 => 'Uređivanje korisnika',
    12 => 'Da izmenite ili obrišete korisnika, kliknite na odgovarajuću ikonicu u "Izmeni" polju. Da kreirate novog korisnika kliknite na dugme "Kreiraj Novi" iznad. Možete i koristiti jednostavnu pretragu po delovima korisničkog imena, email adrese ili punog imena korisnika.',
    13 => 'Sigurnosni nivo',
    14 => 'Datum registracije',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'sačuvaj',
    21 => 'Korisničko ime koje pokušavate da sačuvate već postoji.',
    22 => 'Greška',
    23 => 'Masovno Dodavanje',
    24 => 'Masovno Dodavanje Korisnika',
    25 => 'Geeklog Vam omogućava masovno dodavanje korisnika. Fajl koji importujete mora koristiti tab-delimited tekstualni fajl i mora imati sledeća polja baš u redu koji je naveden: Ime i prezime, Korisničko ime, email adresa. Svaki korisnik kojeg dodate na email adresu će dobiti slučajno generisanu lozinku. U tekstualnom fajlu mora biti jedan korisnik u jednoj liniji teksta. U koliko nebudete pratili instrukcije koje su prethodno navedene doći će do problema i vrlo verovatno da će biti potrebna manualna ispravka. Zato dobro proverite podatke!',
    26 => '',
    27 => '',
    28 => 'Označite ovde da bi obrisali sliku.',
    29 => 'Putanja',
    30 => 'Importuj',
    31 => 'Novi korisnici',
    32 => 'Procesiranje završeno. Ukupno %d dodato i ukupno %d grešaka',
    33 => 'pošalji',
    34 => 'Greška: Morate izabrati fajl za upload.',
    35 => 'Poslednji put prijavljen',
    36 => '(nikada)',
    37 => 'UID',
    38 => 'Menadžer Korisničkih Grupa',
    39 => 'Lozinka (ponovo)',
    40 => 'Datum Registracije',
    41 => 'Poslednje Prijavljivanje',
    42 => 'Banovan',
    43 => 'Čeka Aktivaciju',
    44 => 'Čeka Autorizaciju',
    45 => 'Aktivan',
    46 => 'Korisnički Status',
    47 => 'Izmeni',
    48 => 'Prikaži Admin Grupe',
    49 => 'Admin Grupa',
    50 => 'Čekiraj da dozvoliš filtriranje ove grupe kao Admin Grupe Korišćenja',
    51 => 'Online Dana',
    52 => '<br' . XHTML . '>Napomena: "Online Dana" je broj dana između prve registracije i poslednje prijave.',
    53 => 'registrovan',
    54 => 'Masovno Brisanje',
    55 => 'Ovo jedino radi ako je <code>$_CONF[\'lastlogin\'] = true;</code> u vašem config.php fajlu',
    56 => 'Molimo izaberite tip korisnika koji želite da obrišete i onda pritisnite dugme "Ažuriraj Listu". Onda, dečekirajte one koje ne želite da obrišete iz te liste i kliknite na "Brisanje". Zapamtite da ćete obirsati samo one korisnike koje vidite u slučaju da se lista prostire na više strana.',
    57 => 'Phantom korisnici',
    58 => 'Kratkoročni korisnici',
    59 => 'Stari Korisnici',
    60 => 'Korisnici koji su registrovani pre više od ',
    61 => ' meseci ali se nikad nisu prijavili na sajt.',
    62 => 'Korisnici koji su registrovani pre više od ',
    63 => ' meseci, onda se ulogovali u roku od 24 sat, ali nakon toga nikada nisu pristupili sajtu',
    64 => 'Normalni korisnici, koji jednostavno ne posećuju vaš sajt već ',
    65 => ' meseci.',
    66 => 'Ažuriraj Listu',
    67 => 'Meseci od registracije',
    68 => 'Online Sati',
    69 => 'Offline Meseci',
    70 => 'nemože biti obrisan',
    71 => 'uspešno obrisan',
    72 => 'Nema korisnika slektovanih za brisanje',
    73 => 'Da li ste sigurni da želite da obrišete SVE selektovane korisnike?',
    74 => 'Poslednji korsicnici',
    75 => 'Korisnici koji su se registrovali u poslednjih ',
    76 => ' meseci',
    77 => 'Pošalji Email za prijavu na sajt selektovanim korisnicima',
    78 => 'Pošalji podsetnik',
    79 => 'Nema selektovanih korisnika za podsetnik',
    80 => 'Podsetnici uspešno poslati',
    81 => 'Podsetnik za verifikaciju naloga na %s',
    82 => "Vaš nalog na {$_CONF['site_name']} nije doživeo pristup još od %s i biće obrisan ako se preko njega ne pristupi u roku od 30 dana.",
    83 => "Vaš nalog na {$_CONF['site_name']} nije korišćen od dana kada je kreiran i biće obrisan uskoro ako se preko njega ne pristupi.",
    84 => "Vaše korisničko ime je: %s  za naš sajt: {$_CONF['site_url']}",
    85 => 'Ako ste zaboravili lozinku korsitite sledeći link: %s',
    86 => 'Podsetnici',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Prihvati',
    2 => 'Obriši',
    3 => 'Ažuriraj',
    4 => 'Profil',
    10 => 'Naziv',
    11 => 'Poćinje dana',
    12 => 'URL',
    13 => 'Kategorija',
    14 => 'Datum',
    15 => 'Kategorija',
    16 => 'Korisničko Ime',
    17 => 'Ime I Prezime',
    18 => 'Email',
    34 => 'Komande i Kontrola',
    35 => 'Zahtev za postavljanje teksta',
    36 => 'Parent or Comment',
    37 => '',
    38 => 'Potvrdi',
    39 => 'Trenutno nema tekstova (korisničkih doprinosa) za administraciju',
    40 => 'Korisnički Tekstovi (Poslati Materijali)',
    41 => 'Comment Submissions',
    42 => 'Username',
    43 => 'Auto-publish Comments?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} Mail Menadžer",
    2 => 'Od',
    3 => 'Vrati odgovor na',
    4 => 'Naslov',
    5 => 'Tekst Prouke',
    6 => 'Šalji:',
    7 => 'Svi korisnici',
    8 => 'Admin',
    9 => 'Opcije',
    10 => 'HTML',
    11 => 'Hitna poruka!',
    12 => 'Pošalji',
    13 => 'Poništi',
    14 => 'Ignoriši postavke korisnika',
    15 => 'Greška pri slanju: ',
    16 => 'Uspešno poslate poruke za: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>Pošalji novu poruku</a>",
    18 => 'Za',
    19 => 'NAPOMENA: ako želite da pošaljete poruku svim članovima sajta, selektujte Logged-in korisničku grupu iz liste ispod.',
    20 => "Uspešno poslato <successcount> poruka i bezuspešno poslato <failcount> poruka.  Ako su Vam potrebni, detalji za svaki pokušaj su ovde.  U suprotnom možete <a href=\"{$_CONF['site_admin_url']}/mail.php\">poslati novu poruku</a> ili se <a href=\"{$_CONF['site_admin_url']}/moderation.php\">vratiti na dministraciju</a>.",
    21 => 'Greške',
    22 => 'Uspešnost',
    23 => 'Nema grešaka',
    24 => 'Nema uspešnosti',
    25 => '-- Odaberite grupu --',
    26 => 'Molimo popunite sva polja u formi i izaberite korisničku grupu iz liste.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Instaliranje pluginova može izazvati oštećena kod vaše Geeklog instalacije i teoretski kod vašeg sistema. Važno je napomenuti da treba da instalirate samo one pluginove koje ste preuzeli sa <a href="http://www.geeklog.net">Geeklog Zvanične Strane</a> zato što mi detaljno testiramo sve poslate pluginove na gotovo svim operativnim sistemima. Treba da znate da će proces instalacije plugina tražiti izvršenje nekoliko komandi fajlsistema što može dovesti do sigurnosnih problema ako koristite pluginove sa nekih drugih sajtova.  Čak i sa ovim upozorenjem koje ste dobili, mi nemožemo garantovati uspeh niti jedne instalacije niti smo odgovorni za eventualnu štetu koja je prouzrokovana instalacijom Geeklog plugina.  Drugim rečima, instalirate na sopstvenu odgovornost.  Radi opreza, uputstva kako da manuelno instalirate plugin nalaze se u samom plugin paketu.',
    2 => 'Plugin Instalacioni Disclaimer',
    3 => 'Plugin Instalaciona Forma',
    4 => 'Plugin Fajl',
    5 => 'Plugin Menadžer',
    6 => 'Upozorenje: Plugin Je Već Instaliran!',
    7 => 'Plug-in koji pokušavate da instalirate već postoji.  Molimo obrišite plugin pre nego ga re-instalirate',
    8 => 'Test Kompatibilnosti Plugina Nije Prošao',
    9 => 'Ovaj plugin zahteva noviju verziju Geeklog-a. Ili ažurirajte vašu kopiju <a href="http://www.geeklog.net">Geeklog-a</a> ili nabavite odgovarajuću verziju plugina.',
    10 => '<br' . XHTML . '><b>Trenutno nema instaliranih plugina.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Da izmenite ili obrišete plugin, kliknite na pluginovu ikonicu izmeni prikazanu ispod. Za detaljne informacije o pluginu, kliknite na ime plugina i bićete preusmereni na njegovu web prezentaciju. Da instalirate ili ažurirate plugin pročitajte njegovu dokumentaciju.',
    12 => 'ime plugina nije poslano za plugineditor()',
    13 => 'Plugin Editor',
    14 => 'Novi plugin',
    15 => 'Administracija',
    16 => 'Plug-in Naziv',
    17 => 'Plug-in Verzija',
    18 => 'Geeklog Verzija',
    19 => 'Omogući',
    20 => 'Da',
    21 => 'Ne',
    22 => 'Instaliraj',
    23 => 'Sačuvaj',
    24 => 'Otkaži',
    25 => 'Obriši',
    26 => 'Ime plugina',
    27 => 'Web stranica plugina',
    28 => 'Verzija plugina',
    29 => 'Geeklog Verzija',
    30 => 'Obrisati plugin?',
    31 => 'Da li ste sigurni da želite da obrišete ovaj plugin?  Ovom operacijom uklonićete sve podatke i strukture podataka koje ovaj plugin koristi.  Ako ste sigurni, kliknite na dugme Obriši prikazno ispod.',
    32 => '<p><b>Greška AutoLink tag nekorektan format</b></p>',
    33 => 'Verzija Kod-a',
    34 => 'Ažuriraj',
    35 => 'Izmeni',
    36 => 'Kod',
    37 => 'Podaci',
    38 => 'Ažuriraj!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    99 => 'An unknown error occured',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'kreiraj feed',
    2 => 'sačuvaj',
    3 => 'obriši',
    4 => 'otkaži',
    10 => 'RSS',
    11 => 'Novi Feed',
    12 => 'Administracija',
    13 => 'Da izmenite ili obrišete feed, klikinte na ikonicu izmeni prikaznu ispod. Da kreirate novi feed, kliknite na "Kreiraj Novi" dugme iznad.',
    14 => 'Naslov',
    15 => 'Vrsta',
    16 => 'Ime datoteke',
    17 => 'Format',
    18 => 'Poslednja Obnova',
    19 => 'Omogući',
    20 => 'Da',
    21 => 'Ne',
    22 => '<i>(nema feedova)</i>',
    23 => 'svi tekstovi',
    24 => 'Feed Editor',
    25 => 'Feed Naslov',
    26 => 'Ograničenje',
    27 => 'Dužina zapisa',
    28 => '(0 = nema teksta, 1 = kompletan tekst, ostalo = ograničen broj znakova.)',
    29 => 'Opis',
    30 => 'Poslednja Obnova',
    31 => 'Set Karaktera',
    32 => 'Jezik',
    33 => 'Sadržaji',
    34 => 'Zapis(a)',
    35 => 'Sat(i)',
    36 => 'Selektuj tip za feed',
    37 => '',
    38 => 'Greška: Nepotpun unos',
    39 => 'Molimo popunite polja Feed Naslov, Opis i Ime Datoteke.',
    40 => 'Molimo unesite broj zapisa ili broj sati.',
    41 => 'Linkovi',
    42 => '',
    43 => 'Sve',
    44 => 'Ništa',
    45 => 'Header-link',
    46 => 'Ograniči Rezulate',
    47 => 'Pretraga',
    48 => 'Izmena',
    49 => 'Feed Logo',
    50 => "Relativan u odnosu na url sajta ({$_CONF['site_url']})",
    51 => 'Ime koje ste izabrali je već u upotrebi od strane drugog feed-a. Molimo izaberite neko drugo.',
    52 => 'Greška: fajl sa ovim imenom već postoji',
    53 => 'Svi tekstovi sa naslovne strane',
    54 => 'Molimo selektujte tip za feed koji keirate.',
    55 => 'Tekstovi'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Vaša lozinka je poslata na vašu email adresu. Molimo pratite uputstvo u tekstu poruke i zahvaljujemo Vam što koristite {$_CONF['site_name']}",
    2 => "Hvala što ste poslali tekst na {$_CONF['site_name']}. Tekst će prvo biti pročitan od strane admina. Ako tekst bude prihvaćen uskoro će biti javno dostupan na našim stranicama.",
    3 => '',
    4 => '',
    5 => 'Informacije u vašem profilu su uspešno sačuvane.',
    6 => 'Vaše karakteristike su uspešno sačuvane.',
    7 => 'Vaše karakteristike za komentare su uspešno sačuvane.',
    8 => 'Uspešno ste odjavljeni.',
    9 => 'Vaš tekst je uspešno sačuvan.',
    10 => 'Tekst je uspešno obrisan.',
    11 => 'Vaš blok je uspešno sačuvan.',
    12 => 'Blok je uspešno obrisan.',
    13 => 'Vaša kategorija tekstova je uspešno sačuvana.',
    14 => 'Kategorija i svi tekstovi u njoj su uspešno obrisani.',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Korisnik dodat u bazu podataka.',
    22 => 'Korisnik obrisan.',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Poruka je uspešno poslata.',
    28 => 'Plugin je uspešno sačuvan',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => 'Pristup zabranjen',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Sistemska Poruka',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Plugin uspešno instaliran!',
    45 => 'Plugin uspešno ozbrisan.',
    46 => '',
    47 => '',
    48 => "Zahvaljujemo Vam što ste postali član {$_CONF['site_name']}. Naš tim će pregledati i oceniti vaš zahtev. Ako bude prihvaćen vaša lozinka će Vam biti poslata na email.",
    49 => 'Vaša grupa je uspešno sačuvana.',
    50 => 'Grupa je uspešno obrisana.',
    51 => 'Ovo korisničko ime je već u upotrebi. Molimo izaberite drugo.',
    52 => 'Izgleda da email adresa koju ste uneli nije validna.',
    53 => 'Vaša nova lozinka je prihvaćena. Molimo koristite vašu novu lozinku da bi se prijavili ispod.',
    54 => 'Vaš zahtev za novu lozinku je istekao. Pokušajte ponovo ispod.',
    55 => 'Email Vam je poslat i trebao bi da stigne momentalno. Molimo pratite uputstva u poruci koju ste dobili kako bi postavili novu lozinku za vas korisnički nalog.',
    56 => 'Ovaj email je već u upotrebi za drugi nalog.',
    57 => 'Vaš nalog je uspešno obrisan.',
    58 => 'Vaš feed je uspešno sačuvan.',
    59 => 'Feed je uspešno obrisan.',
    60 => 'Plugin je uspešno ažuriran',
    61 => 'Plugin %s: nepoznata placeholder poruka',
    62 => 'Trackback komentar je obrisan.',
    63 => 'Došlo je do greške prilikom brisanja trackback komentara.',
    64 => 'Vaš trackback komentar je uspešno poslat.',
    65 => 'Weblog katalog servis uspešno sačuvan.',
    66 => 'Weblog katalog servis je obrisan.',
    67 => 'Nova lozinka se ne podudara sa potvrdnom lozinkom!',
    68 => 'Morate uneti tačnu trenutnu lozinku.',
    69 => 'Vaš nalog je blokiran!',
    70 => 'Vaš nalog čeka administratorsko odobrenje.',
    71 => 'Vaš nalog je sada potvrđen i čeka administratorsko odobrenje.',
    72 => 'Došlo je do greške prilikom instalacije plugina. Pogledajte error.log za više detalja.',
    73 => 'Došlo je do greške prilikom deinstalacije plugina. Pogledajte error.log za više detalja.',
    74 => 'Pingback je uspešno poslat.',
    75 => 'Trackback-ovi moraju biti poslati korišćenjem POST request-a.',
    76 => 'Da li stavrno želite da obrište ovaj članak?',
    77 => 'UPOZORENJE:<br' . XHTML . '>Postavili ste UTF-8 kao podrazumevani encoding. Ipak, vaš server ne podrzava multibyte encoding. Molimo instalirajte mbstring funkcije za PHP ili izaberite drugi character set/jezik.',
    78 => 'Molimo da proverite da su email adresa i konfirmaciona email adresa identične.',
    79 => 'Strana koju pokušavate da otvorite se oslanja na funkciju koja više nije dostupna na ovom sajtu.',
    80 => 'Plugin koji je kreirao ovaj feed je trenutno onemogućen. Niste u mogućnosti da izmenite ovaj feed sve dok ne omogućite korišćenje tog plugina.',
    81 => 'Očito ste pogrešili u unosu vaših korisničkih podataka.  Molimo pokušajte ponovo.',
    82 => 'Premašili ste broj dozvoljenih pokušaja za prijavu.  Molimo pokušajte kasnije.',
    83 => 'Da promenite lozinku, email adresu, ili podatke o tome koliko želite biti prijavljeni, molimo unesite vašu trenutnu lozinku.',
    84 => 'Da obrišete vaš nalog, molimo unesite vašu trenutnu lozinku.',
    85 => 'Došlo je do problema prilikom slanja emaila.',
    86 => 'OpenID server je odbio vaš pokušaj prijave.',
    87 => 'OpenID prijavna operacija je prekinuta od strane korisnika.',
    88 => 'OpenID server je vratio grešku.',
    89 => 'Nisam u mogućnosti da pronađem OpenID server sa datim identity URL-om.',
    90 => 'OpenID identifikacija prekinuta.',
    91 => 'Dostavili ste neispravan identity URL.',
    92 => "Molimo <a href=\"{$_CONF['site_admin_url']}/sectest.php\">proverite sigurnost vašeg sajta</a> pre nego počnete njegovo korišćenje!",
    93 => 'Backup baze je uspešan!.',
    94 => 'Backup Nije Uspeo: Veličina fajla je manja od 1kb',
    95 => 'Pojavila se Greška.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit stories.',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Pristup',
    'ownerroot' => 'Vlasnik/Root',
    'group' => 'Grupa',
    'readonly' => 'Samo Čitanje',
    'accessrights' => 'Prava Pristupa',
    'owner' => 'Vlasnik',
    'grantgrouplabel' => 'Omogući Grupi Pravo Na Izmene',
    'permmsg' => 'NAPOMENA: članovi su svi ulogovani članovi na sajtu a anonimus je bilo koji korisnik koji gleda sajt a nije prijavljen.',
    'securitygroups' => 'Sigurnosne grupe',
    'editrootmsg' => "Iako ste Vi Administrator, nemožete izmeniti root korisnika ukoliko sami niste root korisnik. Možete menjati sve druge korisnike osim root korisnika. Molimo zapamtite da se svi pokušaji za nedozvoljenu izmenu root korisnika beleže.  Molimo vratite se nazad na <a href=\"{$_CONF['site_admin_url']}/user.php\">stranu za administriranje korisnika</a>.",
    'securitygroupsmsg' => 'Selektuj checkboxove za grupe kojima želiš da ovaj korisnik pripada.',
    'groupeditor' => 'Editor Grupa',
    'description' => 'Opis',
    'name' => 'Ime',
    'rights' => 'Prava',
    'missingfields' => 'Polja koja nedostaju',
    'missingfieldsmsg' => 'Morate uneti ime i opis grupe',
    'groupmanager' => 'Menadžer Korisničkih Grupa',
    'newgroupmsg' => 'Da izmenite ili obrišete grupu, kliknite na ikonicu u "Izmeni" polju. Da kreirate novu grupu kliknite na "Kreiraj Novi" iznad. Molimo zapamtite da glavne/core grupe nije moguće obrisati jer sistem koristi iste.',
    'groupname' => 'Ime grupe',
    'coregroup' => 'Sistemska grupa',
    'yes' => 'Da',
    'no' => 'Ne',
    'corerightsdescr' => "Ova grupa je core {$_CONF['site_name']} Grupa.  Zato prava za ovu grupu nije moguće menjati.  Ispod je lista Samo Čitanje za sva prava kojima ova grupa ima pristup.",
    'groupmsg' => 'Sigurnosne Grupe na ovom sajtu su hijerarhijski organizovane.  Dodavanjem ove grupe u bilo koju od grupa ispod omogućićete joj identična prava koja imaju ove grupe.  U koliko je to moguće preporučuje se da se koriste baš ove grupe kako bi se novoj grupi dala prava.  Ako Vam je neophodno da ova grupa ima specifična prava, onda možete slektovati ista za različite opcije sajta u sekciji "Prava" koja je prikazana ispod.  Da dodate grupu u bilo koju od ovih prikazanih ispod, jednostavno čekirajte box od same grupe koju želite.',
    'coregroupmsg' => "Ova grupa je core {$_CONF['site_name']} Grupa.  Zato prava za ovu grupu nije moguće menjati.  Ispod je lista Samo Čitanje za sva prava kojima ova grupa ima pristup.",
    'rightsdescr' => 'Samoj grupi je moguće dodeliti direktna određena prava prikazana ispod ILI drugoj grupi ako je ova grupa njen član.  Stavke koje vidite ispod bez checkboxa su prava koja su grupi dodeljena zato što ona pripada drugoj grupi koja ima ta prava.  Prava koja imaju checkboxove pored sebe su prava koja možete omogućiti za grupu koju kreirate.',
    'lock' => 'Zaključaj',
    'members' => 'Članovi',
    'anonymous' => 'Anonimus',
    'permissions' => 'Prava',
    'permissionskey' => 'R = čita, E = Menja, pravo menjanja uključuje i pravo čitanja',
    'edit' => 'Izmeni',
    'none' => 'Ništa',
    'accessdenied' => 'Pristup Zabranjen',
    'storydenialmsg' => "Nemate prava za pregled ovog teksta.  Moguće je da niste član {$_CONF['site_name']}.  Molimo <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">postanite član</a> of {$_CONF['site_name']} kako bi imali sve članske privilegije!",
    'nogroupsforcoregroup' => 'Ova grupa ne pridapda nijednoj od ostalih grupa',
    'grouphasnorights' => 'Ova grupa nema pristup nijednoj od administratorskih mogućnosti na ovom sajtu',
    'newgroup' => 'Nova Grupa',
    'adminhome' => 'Admin Home',
    'save' => 'sačuvaj',
    'cancel' => 'otkaži',
    'delete' => 'obriši',
    'canteditroot' => 'Pokušali ste da izmenite Root grupu ali sami ne pripdate Root grupi, zato Vam je zapranjen pristup.  Molimo kontaktirajte administratora ako ovo smatrate greškom!',
    'listusers' => 'Lista Korisnika',
    'listthem' => 'lista',
    'usersingroup' => 'Korisnici u grupi "%s"',
    'usergroupadmin' => 'Administrator Korisničke Grupe',
    'add' => 'Dodaj',
    'remove' => 'Ukloni',
    'availmembers' => 'Dostupni članovi',
    'groupmembers' => 'Članovi grupe',
    'canteditgroup' => 'Da izmenite ovu grupu, morate biti njen član. Molimo kontaktirajte administratora ako ovo smatrate greškom!',
    'cantlistgroup' => 'Da vidite članove ove grupe, sami morate biti član iste. Molimo kontaktirajte administratora ako ovo smatrate greškom!',
    'editgroupmsg' => 'Da izmenite pripadnost grupi, kliknite na ime člana(ova) i koristite dodaj ili ukloni dugmad. Ako je korisnik član grupe, njegovo ime će se prikazati samo sa desne strane. Kada završite pritisnite <b>Sačuvaj</b> da ažurirate grupu i vratite se na glavnu admin stranu za grupe.',
    'listgroupmsg' => 'Prikaz svih članova u grupi: <b>%s</b>',
    'search' => 'Pretraga',
    'submit' => 'Pošalji',
    'limitresults' => 'Ograniči Rezultate',
    'group_id' => 'Grupa ID',
    'plugin_access_denied_msg' => 'Pokušavate nedozvoljeno da pristupite plugin administratorskoj strani.  Molimo zapamtite da se svi pokušaji nelegalnih pristupa ovoj strani beleže.',
    'groupexists' => 'Grupa sa ovim imenom već postoji',
    'groupexistsmsg' => 'Grupa sa ovim imenom je već definisana. Imena grupa moraju biti jedinstvena.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'Sigurnosne kopije baze podataka.',
    'do_backup' => 'Napravi sigurnosnu kopiju',
    'backup_successful' => 'Sigurnosna kopija baze podataka je uspešno napravljena.',
    'db_explanation' => 'Da bi napravili sigurnosu kopiju vase baze (BACKUP) kliknite na duge "Kreiraj Novi" iznad. Kliknite na ime fajla kako bi ga preuzeli',
    'not_found' => "Putanja nije korektna ili nije moguće pokrenuti mysqldump alatku.<br" . XHTML . ">Proverite <strong>\$_DB_mysqldump_path</strong> varijablu u vasem config.php.<br" . XHTML . ">Varijabla je trenutno definisana kao: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Kreiranje sigurnosne kopije nije uspelo: Veličina fajla je 0 bytes',
    'path_not_found' => "{$_CONF['backup_path']} nepostoji ili nije direktorijum",
    'no_access' => "GREŠKA: Direktorijum {$_CONF['backup_path']} nije dostupan.",
    'backup_file' => 'Fajl sigurnosne kopije',
    'size' => 'Veličina',
    'bytes' => 'Bytes',
    'total_number' => 'Ukupan broj sigurnosnih kopija: %d',
    'download' => 'Klikni da preuzmeš fajl',
    'new_backup' => 'New Backup',
    'delete_failure' => 'One or more backup files could not be deleted.',
    'delete_success' => 'Backup file(s) successfully deleted.',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_button' => 'Convert',
    'sorry_no_innodb' => 'Sorry, your version of MySQL does not support InnoDB tables.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_patience' => 'Note: Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Početna Strana',
    2 => 'Kontakt',
    3 => 'Posaljite Tekst',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Statistike Sajta',
    8 => 'Personalizacija',
    9 => 'Pretraga',
    10 => 'napredna pretraga',
    11 => 'Katalog'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Error',
    2 => 'Tražio sam svuda ali nisam uspeo da pronađem <b>%s</b>.',
    3 => "<p>Žao nam je, ali fajl koji ste tražili ne postoji. Možda da odete na <a href=\"{$_CONF['site_url']}\">naslovnu stranu</a> ili da probate <a href=\"{$_CONF['site_url']}/search.php\">da pronađete</a> to što ste tražili."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Potrebna prijava',
    2 => 'Žao nam je, Da bi pristupili ovom delu morate biti prijavljeni...',
    3 => 'Prijava',
    4 => 'Novi korisnik'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'od',
    'tracked_on' => 'Track uključen',
    'read_more' => '[detaljnije]',
    'intro_text' => 'Evo šta drugi imaju da kažu o \'%s\':',
    'no_comments' => 'Nema trackback komentara za ovaj zapis.',
    'this_trackback_url' => 'Trackback URL za ovaj zapis:',
    'num_comments' => '%d trackback komentari',
    'send_trackback' => 'Pošalji Pingove',
    'preview' => 'Pregled',
    'editor_title' => 'Pošalji trackback komentar',
    'trackback_url' => 'Trackback URL',
    'entry_url' => 'URL Zapisa',
    'entry_title' => 'Naslov Zapisa',
    'blog_name' => 'Ime Sajta',
    'excerpt' => 'Odlomak',
    'truncate_warning' => 'Napomena: Sajt primalac može odbaciti vaš odlomak',
    'button_send' => 'Posalji',
    'button_preview' => 'Pregled',
    'send_error' => 'Greška',
    'send_error_details' => 'Greška pri slanju trackback komentara:',
    'url_missing' => 'URL Zapisa Nije Nađen',
    'url_required' => 'Molimo unesite najmanje 1 URL za zapis.',
    'target_missing' => 'Nema Trackback URL-a',
    'target_required' => 'Molimo unesite trackback URL',
    'error_socket' => 'Ne mogu da otvorim socket.',
    'error_response' => 'Odgovor nije razumljiv.',
    'error_unspecified' => 'Nepoznata greška.',
    'select_url' => 'Izaberi Trackback URL',
    'not_found' => 'Trackback URL nije pronađen',
    'autodetect_failed' => 'Geeklog nije u stanju da detektuje Trackback URL za tekst koji želite da komentarišete. Molimo unesite ga manuelno ispod.',
    'trackback_explain' => 'Od linkova ispod, molimo izaberite URL na koji želite da pošaljete vaš Trackback komentar. Geeklog će onda pokušati da pronađe tačan Trackback URL za taj tekst. Ili ga možete zadati <a href="%s">manuelno</a> ako ga već znate.',
    'no_links_trackback' => 'Linkovi nisu pronađeni. Nemožete poslati Trackback komentar za ovaj zapis.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback rezulati',
    'send_pings' => 'Pošalji Pingove',
    'send_pings_for' => 'Pošalji Pingove za "%s"',
    'no_links_pingback' => 'Linkovi nisu pronađeni. Pingbackovi nisu poslati za ovaj zapis.',
    'pingback_success' => 'Pingback poslat.',
    'no_pingback_url' => 'Pingback URL nije pronađen.',
    'resend' => 'Ponovo Posalji',
    'ping_all_explain' => 'Možete obavestiti sajtove koje linkujete sa (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), oglasite da je vaš sajt ažuriran pingovanjem weblog katalog servisa, ili pošaljite <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> komentar u slučaju da ste pisali o tekstu sa nekog drugog sajta.',
    'pingback_button' => 'Pošalji Pingback',
    'pingback_short' => 'Pošalji Pingbackove svim sajtovima koji su linkovani u ovom zapisu.',
    'pingback_disabled' => '(Pingback onemogucen)',
    'ping_button' => 'Pošalji Ping',
    'ping_short' => 'Ping weblog katalog servisa.',
    'ping_disabled' => '(Ping onemogućen)',
    'trackback_button' => 'Pošalji Trackback',
    'trackback_short' => 'Pošalji Trackback komentar.',
    'trackback_disabled' => '(Trackback onemogućen)',
    'may_take_a_while' => 'Molimo zapamtite da  slanje Pingback-ova i Ping-ova može potrajati.',
    'ping_results' => 'Ping rezulati',
    'unknown_method' => 'Nepoznat ping method',
    'ping_success' => 'Ping poslat.',
    'error_site_name' => 'Molimo unesite ime sajta.',
    'error_site_url' => 'Molimo unesite URL sajta.',
    'error_ping_url' => 'Molimo unesite validan Ping URL.',
    'no_services' => 'Weblog katalog servisi nisu konfigurisani.',
    'services_headline' => 'Weblog Katalog servisi',
    'service_explain' => 'Da izmenite ili obrišete weblog katalog servis, kliknite na ikonicu u "Izmeni" polju ispod. Da dodate novi weblog katalog servis kliknite na "Kreiraj Novi" iznad.',
    'service' => 'Servis',
    'ping_method' => 'Ping Metod',
    'service_website' => 'Web Sajt',
    'service_ping_url' => 'Url Za Ping',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Extended Ping',
    'ping_unknown' => '(nepoznat metod)',
    'edit_service' => 'Izmeni Weblog Katalog Servis',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Pripremite vaš trackback komentar za <a href="%s">%s</a>.',
    'editor_intro_none' => 'Pripremite vaš trackback komentar.',
    'trackback_note' => 'Da pošaljete trackback komentar za tekst, idite na listu tekstova i kliknite na "Pošalji Ping" za tekst. Da pošaljte trackback koji nije povezan sa tekstom, <a href="%s">kliknite ovde</a>.',
    'pingback_explain' => 'Unesite URL kojem šaljete Pingback. Pingback će "udarati" na vašu naslovnu stranu.',
    'pingback_url' => 'Pingback URL',
    'site_url' => 'URL Ovoga Sajta',
    'pingback_note' => 'Da pošaljete pingback komentar za tekst, idite na listu tekstova i kliknite na "Pošalji Ping" za tekst. Da pošaljte pingback koji nije povezan sa tekstom, <a href="%s">kliknite ovde</a>.',
    'pbtarget_missing' => 'Nema Pingback URL-a',
    'pbtarget_required' => 'Molimo unesite pingback URL',
    'pb_error_details' => 'Greška prilikom slanja pingback-a:',
    'delete_trackback' => 'Da obrišete ovaj Trackback kliknite: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Katalog Tekstova',
    'title_year' => 'Katalog Tekstova %d',
    'title_month_year' => 'Katalog Tekstova za %s %d',
    'nav_top' => 'Nazad na Katalog Tekstova',
    'no_articles' => 'Nema tekstova.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n novi(a) %i u poslednjih %t %s',
    'new_last' => 'u poslednjih %t %s',
    'minutes' => 'minuta',
    'hours' => 'sata',
    'days' => 'dana',
    'weeks' => 'nedelje(a)',
    'months' => 'meseci',
    'years' => 'years',
    'minute' => 'minuta',
    'hour' => 'sat',
    'day' => 'dan',
    'week' => 'nedelja',
    'month' => 'mesec',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Januar',
    2 => 'Februar',
    3 => 'Mart',
    4 => 'April',
    5 => 'Maj',
    6 => 'Jun',
    7 => 'Jul',
    8 => 'Avgust',
    9 => 'Septembar',
    10 => 'Oktobar',
    11 => 'Novembar',
    12 => 'Decembar'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Nedelja',
    2 => 'Ponedeljak',
    3 => 'Utorak',
    4 => 'Sreda',
    5 => 'Četvrtak',
    6 => 'Petak',
    7 => 'Subota'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Pretraga',
    'limit_results' => 'Ograniči Rezultate',
    'submit' => 'Pošalji',
    'edit' => 'Izmeni',
    'edit_adv' => 'Izmeni (Nap.)',
    'admin_home' => 'Admin Home',
    'create_new' => 'Kreiraj Novi',
    'create_new_adv' => 'Kreiraj Novi (Nap.)',
    'enabled' => 'Omogući',
    'title' => 'Naslov',
    'page_title' => 'Page Title',
    'type' => 'Tip',
    'topic' => 'Kategorija',
    'help_url' => 'URL Do Help Fajla',
    'save' => 'Sačuvaj',
    'cancel' => 'Otkaži',
    'delete' => 'Obriši',
    'delete_sel' => 'Obriši selektovano',
    'copy' => 'Kopiraj',
    'no_results' => '- Zapisi nisu pronadjeni -',
    'data_error' => 'Došlo je do greške prilikom procesriranja subscription podataka. Molimo proverite izvor podataka.',
    'preview' => 'Pregled',
    'records_found' => 'Pranađenih rezultata',
    'addchild' => 'Dodaj dete',
    'list' => 'prikaži',
    'list_all' => 'Prikazi sve',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'authenticate' => 'Authenticate'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Komentari Omogućeni',
    -1 => 'Komentari Blokirani',
    1 => 'Komentari Zatvoreni'
);

$LANG_commentmodes = array(
    'flat' => 'Paušalan',
    'nested' => 'Uklopljen',
    'threaded' => 'Sa navojem',
    'nocomment' => 'Nema Komentara'
);

$LANG_cookiecodes = array(
    0 => '(nemoj)',
    3600 => '1 Sat',
    7200 => '2 Sata',
    10800 => '3 Sata',
    28800 => '8 Sati',
    86400 => '1 Dan',
    604800 => '1 Nedelja',
    2678400 => '1 Mesec'
);

$LANG_dateformats = array(
    0 => 'System Default'
);

$LANG_featurecodes = array(
    0 => 'Nije Uobličen',
    1 => 'Uobličen'
);

$LANG_frontpagecodes = array(
    0 => 'Prikaži samo u Kategoriji',
    1 => 'Prikaži na Naslovnoj Strani'
);

$LANG_postmodes = array(
    'plaintext' => 'Običan tekst',
    'html' => 'HTML Format'
);

$LANG_sortcodes = array(
    'ASC' => 'Prvo Najstarije',
    'DESC' => 'Prvo Najnovije'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback Omogućen',
    -1 => 'Trackback Onemogućen'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Administracija Sajta',
    'sections' => 'Konfiguracijske Sekcije',
    'restore' => 'Restore',
    'add_element' => 'Dodaj Element',
    'save_changes' => 'Sačuvaj Promene',
    'reset_form' => 'Resetuj Formu',
    'changes_made' => 'Promene su uspešne za',
    'title' => 'Konfiguracioni Menadžer',
    'disable' => 'Klikni da onemogućiš ovu opciju',
    'enable' => 'Enable'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Konfiguracija'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Putanja',
    'site_url' => 'URL Sajta',
    'site_admin_url' => 'Administratorski URL',
    'site_mail' => 'E-Mail Sajta',
    'noreply_mail' => 'No-Reply E-Mail',
    'site_name' => 'Ime Sajta',
    'site_slogan' => 'Slogan',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Logovi',
    'path_language' => 'Jezici',
    'backup_path' => 'Backup',
    'path_data' => 'Podaci',
    'path_images' => 'Slike',
    'path_pear' => 'Pear Biblioteka',
    'have_pear' => 'Imate Pear Biblioteku?',
    'mail_settings' => 'Mail Podešavanja',
    'allow_mysqldump' => 'Dozvoli MySQL Dump',
    'mysqldump_path' => 'Putanja Do Izvršnog Fajla',
    'mysqldump_options' => 'MySQL Dump Opcije',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => 'Tema',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Elementi Menija',
    'path_themes' => 'Putanja Za Teme',
    'disable_new_user_registration' => 'Onemogući Nove Registracije',
    'allow_user_themes' => 'Dozvoli Korisničke Teme',
    'allow_user_language' => 'Dozvoli Korisničke Jezike',
    'allow_user_photo' => 'Dozvoli Korisničke Fotografije',
    'allow_username_change' => 'Dozvoli Promenu Korisničkog Imena',
    'allow_account_delete' => 'Dozvoli Brisanje Naloga',
    'hide_author_exclusion' => 'Dozvoli Sakrivanje Autora',
    'show_fullname' => 'Prikaži Puno Ime',
    'show_servicename' => 'Prikaži Ime Servisa',
    'custom_registration' => 'Omogući Prilagođenu/Custom Registraciju',
    'user_login_method' => 'Metod Korisničke Prijave',
    'spamx' => 'Spam-X Akcije',
    'sort_admin' => 'Sortiraj Linkove',
    'language' => 'Jezik',
    'locale' => 'Lokalizacija',
    'date' => 'Format Datuma',
    'daytime' => 'Format Vremena',
    'shortdate' => 'Kratki Datum Format',
    'dateonly' => 'Samo Datum Format',
    'timeonly' => 'Samo Vremenski Format',
    'week_start' => 'Nedelja Počinje Od',
    'hour_mode' => 'Satni Režim',
    'thousand_separator' => 'Hiljaditi Separator',
    'decimal_separator' => 'Decimalni Separator',
    'decimal_count' => 'Decimalni Brojac',
    'language_files' => 'Jezički Fajlovi',
    'languages' => 'Jezici',
    'timezone' => 'Vremenska Zona',
    'site_disabled_msg' => 'Poruka ili URL kada Sajt nije Dostupan',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Naziv',
    'cookie_name' => 'Naziv Permanentnog Kolačića',
    'cookie_password' => 'Naziv Kolačića Lozinke',
    'cookie_theme' => 'Naziv Kolačića teme',
    'cookie_language' => 'Naziv Jecickog Kolačića',
    'cookie_tzid' => 'Naiv Kolačića Vremenske Zone',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Kolačići Sadrže IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Timeout Sesije',
    'cookie_path' => 'Putanja Kolačića',
    'cookiedomain' => 'Domen Kolačića',
    'cookiesecure' => 'Bezbednost Kolačića',
    'lastlogin' => 'Pamti Poslednju Prijavu?',
    'num_search_results' => 'Broj Rezultata U Pretrazi',
    'loginrequired' => 'Prijava Obavezna?',
    'submitloginrequired' => 'Doprinosi - Prijava Obavezna?',
    'commentsloginrequired' => 'Komentari - Prjava Obavezna?',
    'statsloginrequired' => 'Statistika - Prijava Obavezna?',
    'searchloginrequired' => 'Pretraga - Prijava Obavezna?',
    'profileloginrequired' => 'Profil - Prijava Obavezna?',
    'emailuserloginrequired' => 'E-Mail Ka Korisniku - Prijava Obavezna?',
    'emailstoryloginrequired' => 'E-Mail Teksta - Prijava Obavezna?',
    'directoryloginrequired' => 'Katalog - Prijava Obavezna?',
    'storysubmission' => 'Red Tekstovnih Doprinosa?',
    'usersubmission' => 'Red Korisničkih Doprinosa?',
    'listdraftstories' => 'Prikaži Draft-ovane Tekstove?',
    'notification' => 'Obaveštenja',
    'postmode' => 'Podrazumevani Tekst Režim',
    'speedlimit' => 'Ograničenje Brzine Tekstova',
    'skip_preview' => 'Preskoči Pregled u Tekstovima',
    'advanced_editor' => 'Napredni Editor?',
    'wikitext_editor' => 'Wikitext Editor?',
    'cron_schedule_interval' => 'Cron Dispečer Interval',
    'sortmethod' => 'Sortiraj Kategorije',
    'showstorycount' => 'Prikaži Brojač Tekstova?',
    'showsubmissioncount' => 'Prikaži Brojač Doprinosa?',
    'hide_home_link' => 'Sakrij Home Link?',
    'whosonline_threshold' => 'Threshold Sesija',
    'whosonline_anonymous' => 'Sakrij Imena Od Gostiju?',
    'emailstories' => 'Dnevni Digest Omogucen?',
    'emailstorieslength' => 'Duzina Tekstova',
    'emailstoriesperdefault' => 'Omogući za Nove Korisnike?',
    'allow_domains' => 'Dozvoli Domain Automatizaciju',
    'disallow_domains' => 'Automatski Zabrani Domene',
    'newstoriesinterval' => 'Interval Novih Tekstova',
    'newcommentsinterval' => 'Interval Novih Komentara',
    'newtrackbackinterval' => 'Interval Novih Trackbacks',
    'hidenewstories' => 'Sakrij Nove Tekstove',
    'hidenewcomments' => 'Sakrij Nove Komentare',
    'hidenewtrackbacks' => 'Sakrij Nove Trackbacks',
    'hidenewplugins' => 'Sakrij Nove Plugin Zapise',
    'title_trim_length' => 'Dužina Isečka Naslova',
    'trackback_enabled' => 'Trackback Omogućen?',
    'pingback_enabled' => 'Pingback Omogućen?',
    'ping_enabled' => 'Ping Omogužen?',
    'trackback_code' => 'Trackback Podrazumevan',
    'multiple_trackbacks' => 'Višestruki Trackbacks',
    'trackbackspeedlimit' => 'Trackback Ograničenje Brzine',
    'check_trackback_link' => 'Proveri Trackbacks',
    'pingback_self' => 'Pingback Ka Sebi?',
    'pingback_excerpt' => 'Kreiraj Pingback Izvod?',
    'link_documentation' => 'Link ka Dokumentaciji?',
    'link_versionchecker' => 'Link ka Version Checker-u?',
    'maximagesperarticle' => 'Max Slika po Tekstu',
    'limitnews' => 'Tekstova Po Strani',
    'minnews' => 'Min. Tekstova Po Strani',
    'contributedbyline' => 'Prikaži Autora?',
    'hideviewscount' => 'Sakrij Brojač Pregleda?',
    'hideemailicon' => 'Sakrij E-Mail Ikonu?',
    'hideprintericon' => 'Sakrij Print Ikonu?',
    'allow_page_breaks' => 'Omogući Prelamanje Strane?',
    'page_break_comments' => 'Komentari Na Višestranim Tekstovima',
    'article_image_align' => 'Poravnanje Ikone Kategorije',
    'show_topic_icon' => 'Prikaži Ikonu Kategorije?',
    'draft_flag' => 'Draft Zastava Podrazumevana',
    'frontpage' => 'Naslovna Podrazumevana',
    'hide_no_news_msg' => 'Sakrij "Nema Tx" Poruka?',
    'hide_main_page_navigation' => 'Sakrij Navigaciju Glavne Strane?',
    'onlyrootfeatures' => 'Samo za Root-a',
    'aftersave_story' => 'Nakon Dodavanja Teksta',
    'aftersave_user' => 'Nakon Dodavanja Korisnika',
    'show_right_blocks' => 'Uvek Prikaži Desne Blokove?',
    'showfirstasfeatured' => 'Uobliči Prvu Priču?',
    'backend' => 'Omogući Feedove?',
    'rdf_file' => 'Izlazni RSS Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Dužina Tekstova U Feed-u',
    'rdf_language' => 'Feed Jezik',
    'syndication_max_headlines' => 'Max. Broj Naslova (portal blokova)',
    'copyrightyear' => 'Copyright Godina',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Putanja za Mogrify',
    'path_to_netpbm' => 'Putanja za Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Zadrži Orginalnu Sliku?',
    'allow_user_scaling' => 'Omogući Korisničko Skaliranje?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Širina Slike?',
    'max_image_height' => 'Max Visina Slike?',
    'max_image_size' => 'Max Veličina Slike?',
    'max_topicicon_width' => 'Max Širina Ikone Za Kategoriju?',
    'max_topicicon_height' => 'Max Visina Ikone Za Kategoriju?',
    'max_topicicon_size' => 'Max Veličina Ikone Za Kategoriju?',
    'max_photo_width' => 'Max Širina Fotografije?',
    'max_photo_height' => 'Max Visina Fotografije?',
    'max_photo_size' => 'Max Veličina Fotografije?',
    'use_gravatar' => 'Koristi Gravatar?',
    'gravatar_rating' => 'Rejting Gravatar-a Dozvoljen',
    'force_photo_width' => 'Prisili Širinu Slike',
    'default_photo' => 'Podrazumevana Fotografija',
    'commentspeedlimit' => 'Ograničenje Brzine Komentara',
    'comment_limit' => 'Ograničenje Komentara',
    'comment_mode' => 'Režim Komentara',
    'comment_code' => 'Komentari Podrazumevano',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'passwordspeedlimit' => 'Ograničenje Brzine Lozinke',
    'login_attempts' => 'Max. Broj Pokušaja Prijave',
    'login_speedlimit' => 'Ograničenje Brzine Prijave',
    'user_html' => 'Korisnički HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Izostavi HTML Filter za Root-a?',
    'allowed_protocols' => 'Dozvoljeni Protokoli',
    'disable_autolinks' => 'Onemogući Autolikove?',
    'clickable_links' => 'Make URLs clickable?',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'censormode' => 'Režim Cenzure?',
    'censorreplace' => 'Cenzurisana Zamena Teksta',
    'censorlist' => 'Cenzurisana Lista',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Omogući URL Rewrite',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => 'Blok Podrazumevane Dozvole',
    'default_permissions_story' => 'Tekst Podrazumevane Dozvole',
    'default_permissions_topic' => 'Kategorija Podrazumevane Dozvole',
    'atom_max_stories' => 'Max. Tekstova u Webservis Feed-u',
    'disable_webservices' => 'Onemogući Webservise?',
    'restrict_webservices' => 'Zabrani Webservise?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent stories enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Sajt',
    'sg_stories' => 'Tekstovi i Trackback',
    'sg_theme' => 'Teme',
    'sg_blocks' => 'Blokovi',
    'sg_users' => 'Korisnici i Doprinosi',
    'sg_images' => 'Slike',
    'sg_locale' => 'Jezici i Lokalizacija',
    'sg_misc' => 'Razno'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Sajt',
    'fs_paths' => 'Putanje',
    'fs_theme' => 'Teme',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear Biblioteka',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Korisnici',
    'fs_misc' => 'Razno',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Blok',
    'fs_locale' => 'Lokalizacija',
    'fs_language' => 'Jezik',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Kolačići',
    'fs_login' => 'Podešavanje Prijava',
    'fs_search' => 'Pretraga',
    'fs_user_submission' => 'Korisnički Doprinosi',
    'fs_submission' => 'Podešavnja Doprisnosa (Submissions)',
    'fs_topics_block' => 'Blok Kategorija',
    'fs_whosonline_block' => 'Ko Je Online Blok',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'Šta Je Novo Blok?',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Tekst',
    'fs_theme_advanced' => 'Napredna Podešavaja',
    'fs_syndication' => 'RSS',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Slike u Tekstovima',
    'fs_topicicon' => 'Ikone Kategorija',
    'fs_userphoto' => 'Fotografija',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Komentari',
    'fs_htmlfilter' => 'HTML Filtriranje',
    'fs_censoring' => 'Cenzurisanje',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Tekst Podrazumevane Dozvole',
    'fs_perm_topic' => 'Kategorija Podrazumevane Dozvole',
    'fs_perm_block' => 'Blok Podrazumevane Dozvole',
    'fs_webservices' => 'Web Servisi'
);

$LANG_configselects['Core'] = array(
    0 => array('DA' => 1, 'NE' => 0),
    1 => array('DA' => true, 'NE' => false),
    2 => array('Odbaci' => 0, 'Zadrži Samo Poslednje' => 1, 'Dozvoli Višestruke Tekstove' => 2),
    3 => array('Trackback Omogućen' => 0, 'Trackback Onemogućen' => -1),
    4 => array('Ne Proveravaj Ništa' => 0, 'Proveri suprotni Sajt URL' => 1, 'Proveri kompletan URL' => 2, 'Proveri suprotni i kompletan URL' => 3, 'Porveri IP suprotnog Sajta' => 4, 'Proveri IP i Sajt URL' => 5, 'Proveri IP kompletan URL' => 6, 'Proveri IP, Kompletan URL, I Sajt URL' => 7),
    5 => array('Običan tekst' => 'plaintext', 'HTML Format' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'poslednja', 'First Page' => 'prva', 'Every Page' => 'sve'),
    8 => array('Desno' => 'right', 'Levo' => 'left'),
    9 => array('Prebaci na stranicu' => 'item', 'Prikaži Listu' => 'list', 'Prikaži Naslovnu' => 'home', 'Prikaži Administraciju' => 'admin'),
    10 => array('Nijedna' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Paušalan' => 'flat', 'Uklopljen' => 'nested', 'Sa navojem' => 'threaded', 'Nema Komentara' => 'nocomment'),
    12 => array('Nema pristup' => 0, 'Samo Čitanje' => 2, 'Čitanje-Pisanje' => 3),
    13 => array('Preskoči' => 0, 'Omogući, sa ograničenjem brzine' => 1, 'Omogući, bez ograničenja brzine' => 2),
    14 => array('Nedelje' => 'Sun', 'Ponedeljka' => 'Mon'),
    15 => array('Po Rednom Broju' => 'sortnum', 'Leksikografski' => 'alpha'),
    16 => array('Prijava Nije Obavezna' => 0, 'Samo Napredna Pretraga' => 1, 'Jednostavna + Napredna Pretraga' => 2),
    17 => array('Komentari Omogućeni' => 0, 'Komentari Onemogućeni' => -1),
    18 => array('Onemogući' => 0, 'Omogući (Identično)' => 1, 'Omogući (Početak Reči)' => 2, 'Omogući (Deo Reči)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Stories' => 'story', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc')
);

?>
