<?php

// Reminder: always indent with 4 spaces (no tabs).
// +---------------------------------------------------------------------------+
// | CustomMenu Editor Plugin for Geeklog                                      |
// +---------------------------------------------------------------------------+
// | public_html/custommenu/index.php                                          |
// +---------------------------------------------------------------------------+
// | Copyright (C) 2008-2011 dengen - taharaxp AT gmail DOT com                |
// |                                                                           |
// | Constructed with the Universal Plugin                                     |
// | Copyright (C) 2002 by the following authors:                              |
// | Tom Willett               -    twillett AT users DOT sourceforge DOT net  |
// | Blaine Lang               -    langmail AT sympatico DOT ca               |
// | The Universal Plugin is based on prior work by:                           |
// | Tony Bibbs                -    tony AT tonybibbs DOT com                  |
// | Modified by:                                                              |
// | mystral-kk                -    geeklog AT mystral-kk DOT net              |
// | dengen                    -    taharaxp AT gmail DOT com                  |
// +---------------------------------------------------------------------------+
// |                                                                           |
// | This program is free software; you can redistribute it and/or             |
// | modify it under the terms of the GNU General Public License               |
// | as published by the Free Software Foundation; either version 2            |
// | of the License, or (at your option) any later version.                    |
// |                                                                           |
// | This program is distributed in the hope that it will be useful,           |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of            |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
// | GNU General Public License for more details.                              |
// |                                                                           |
// | You should have received a copy of the GNU General Public License         |
// | along with this program; if not, write to the Free Software Foundation,   |
// | Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           |
// |                                                                           |
// +---------------------------------------------------------------------------+

require_once '../lib-common.php';

// Check user has rights to access this page
if (!SEC_hasRights('custommenu.edit,custommenu.view,custommenu.admin','OR')) {
    // Someone is trying to illegally access this page
    COM_errorLog("Someone has tried to illegally access the custommenu page.  "
               . "User id: {$_USER['uid']}, Username: {$_USER['username']}, IP: $REMOTE_ADDR", 1);
    $display  = COM_siteHeader();
    $display .= COM_startBlock($LANG_MCONF['access_denied']);
    $display .= $LANG_MCONF['access_denied_msg'];
    $display .= COM_endBlock();
    $display .= COM_siteFooter(true);
    echo $display;
    exit;
}

/* 
* Main Function
*/

$display = COM_siteHeader();
$T = new Template($_CMED_CONF['path_layout']);
$T->set_file('page', 'index.thtml');
$T->set_var('header', $LANG_MCONF['plugin']);
$T->set_var('site_url', $_CONF['site_url']);
$T->set_var('icon_url', $_CONF['site_url'] . '/custommenu/images/custommenu.gif');
$T->set_var('plugin', 'custommenu');

// your code goes here


$T->parse('output', 'page');
$display .= $T->finish($T->get_var('output'));
$display .= COM_siteFooter();

echo $display;

?>