<?php

###############################################################################
# german.php
#
# This is the German language file for Geeklog, addressing the user as "Du"
# (informal German). See german_formal.php for a language file addressing the
# user with the formal "Sie".
#
# Authors: Dirk Haun <dirk AT haun-online DOT de>
#          Markus Wollschlger
#
# Based on the original english.php, started by Jason Whittenburg.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'iso-8859-15';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Beitrag von:',
    2 => '(mehr)',
    3 => 'Kommentar(e)',
    4 => 'ndern',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Admin-Funktionen:',
    10 => 'Beitrge',
    11 => 'Artikel',
    12 => 'Blcke',
    13 => 'Kategorien',
    14 => '',
    15 => '',
    16 => '',
    17 => 'User',
    18 => 'SQL-Query',
    19 => 'Abmelden',
    20 => 'User-Information:',
    21 => 'Username',
    22 => 'User-ID',
    23 => 'Security Level',
    24 => 'Gast',
    25 => 'Antwort',
    26 => 'Die folgenden Kommentare geben Meinungen von Lesern wieder und entsprechen nicht notwendigerweise der Meinung der Betreiber dieser Site. Die Betreiber behalten sich die Lschung von Kommentaren vor.',
    27 => 'Letzter Beitrag',
    28 => 'Lschen',
    29 => 'Keine Kommentare.',
    30 => 'ltere Artikel',
    31 => 'Erlaubte HTML-Tags: ',
    32 => 'Fehler: Ungltiger Username',
    33 => 'Fehler: Konnte nicht ins Logfile schreiben',
    34 => 'Fehler',
    35 => 'Abmelden',
    36 => 'am',
    37 => 'Keine Artikel.',
    38 => 'Newsfeed',
    39 => 'Neuladen',
    40 => '',
    41 => 'Gste',
    42 => 'Autor:',
    43 => 'Antwort schreiben',
    44 => 'vorherige',
    45 => 'MySQL Fehlernummer',
    46 => 'MySQL Fehlermeldung',
    47 => 'Anmelden',
    48 => 'Mein Profil',
    49 => 'Einstellungen',
    50 => 'Fehler im SQL-Befehl',
    51 => 'Hilfe',
    52 => 'Neu',
    53 => 'Schaltzentrale',
    54 => 'Konnte die Datei nicht ffnen:',
    55 => 'Fehler in',
    56 => 'Abstimmen',
    57 => 'Passwort',
    58 => 'Anmelden',
    59 => "Noch nicht registriert? Melde Dich jetzt als <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">neuer User</a> an",
    60 => 'Kommentar schreiben',
    61 => 'Neuen Account anlegen',
    62 => 'Wrter',
    63 => 'Kommentar-Einstellungen',
    64 => 'Artikel an einen Freund schicken',
    65 => 'Druckfhige Version anzeigen',
    66 => '',
    67 => 'Willkommen bei ',
    68 => 'Home',
    69 => 'Kontakt',
    70 => 'Suchen',
    71 => 'Beitrag',
    72 => 'Links',
    73 => '',
    74 => '',
    75 => 'Erweiterte Suche',
    76 => 'Statistik',
    77 => 'Plugins',
    78 => '',
    79 => 'Was ist neu',
    80 => 'Artikel in den letzten',
    81 => 'Artikel in den letzten',
    82 => 'Stunden',
    83 => 'KOMMENTARE',
    84 => '',
    85 => 'der letzten 48 Stunden',
    86 => 'Keine neuen Kommentare',
    87 => 'der letzten 2 Wochen',
    88 => '',
    89 => '',
    90 => 'Home',
    91 => 'Seite erzeugt in',
    92 => 'Sekunden',
    93 => 'Copyright',
    94 => 'All trademarks and copyrights on this page are owned by their respective owners.',
    95 => 'Powered by',
    96 => 'Gruppen',
    97 => 'Wortliste',
    98 => 'Plugins',
    99 => 'ARTIKEL',
    100 => 'Keine neuen Artikel',
    101 => '',
    102 => '',
    103 => 'DB Backups',
    104 => 'von',
    105 => 'Mail an User',
    106 => 'Angezeigt',
    107 => 'Update verfgbar?',
    108 => 'Cache lschen',
    109 => 'Beitrag melden',
    110 => 'Site-Admin auf diesen Beitrag hinweisen',
    111 => '',
    112 => 'Registrierte User',
    113 => 'Dokumentation',
    114 => 'TRACKBACKS',
    115 => 'Keine neuen Trackback-Kommentare',
    116 => 'Trackback',
    117 => 'Verzeichnis',
    118 => 'Fortsetzung auf der nchsten Seite:',
    119 => "<a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">Passwort vergessen?</a>",
    120 => 'Permalink',
    121 => 'Kommentare (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'Alle HTML-Tags sind erlaubt',
    124 => 'Alle angekreuzten Eintrge lschen',
    125 => 'Sollen alle angekreuzten Eintrge wirklich gelscht werden?',
    126 => 'Alle Eintrge ankreuzen oder deselektieren',
    127 => 'Permalink',
    128 => 'Anmelden mit OpenID:',
    129 => 'Konfiguration',
    130 => 'Webservices',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage",
    'facebook' => 'Login with Facebook',
    'twitter' => 'Login with Twitter',
    'linkedin' => 'Login with LinkedIn'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Kommentar schreiben',
    2 => 'Format',
    3 => 'Abmelden',
    4 => 'Account anlegen',
    5 => 'Username',
    6 => 'Um einen Kommentar abgeben zu knnen, musst Du angemeldet sein. Wenn Du noch keinen Account hast, benutze bitte das Formular um einen anzulegen.',
    7 => 'Dein letzter Kommentar war vor ',
    8 => " Sekunden. Zwischen zwei Kommentaren mssen aber mindestens {$_CONF['commentspeedlimit']} Sekunden vergangen sein.",
    9 => 'Kommentar',
    10 => 'Beitrag melden',
    11 => 'Kommentar abschicken',
    12 => 'Bitte die Felder Betreff <em>und</em> Kommentar ausfllen, um einen Kommentar zu diesem Artikel abzugeben.',
    13 => 'Deine Information',
    14 => 'Vorschau',
    15 => 'Diesen Beitrag melden',
    16 => 'Betreff',
    17 => 'Fehler',
    18 => 'Wichtige Hinweise:',
    19 => 'Bitte nur Kommentare abgeben, die zum Thema gehren.',
    20 => 'Beziehe Dich mglichst auf Kommentare anderer Personen statt einen neuen Thread zu erffnen.',
    21 => 'Lies bitte die vorhandenen Kommentare bevor Du Deinen eigenen abgibst, um nicht noch einmal zu schreiben, was schon gesagt wurde.',
    22 => 'Benutze eine eindeutige Betreffzeile, die den Inhalt Deines Kommentars zusammenfasst.',
    23 => 'Deine E-Mail-Adresse wird NICHT verffentlicht.',
    24 => 'Gast',
    25 => 'Soll dieser Beitrag wirklich als mglicher Missbrauch gemeldet werden?',
    26 => '%s meldete den folgenden Beitrag als mglichen Missbrauch:',
    27 => 'Hinweis auf Missbrauch',
    28 => 'Vorschau der nderungen',
    29 => 'nderungen speichern',
    30 => 'Editiert am',
    31 => 'von',
    32 => 'Kommentar editieren',
    33 => 'Eingereichten Kommentar editieren',
    34 => 'Kommentar-Vorschau',
    35 => 'nderungen abspeichern',
    36 => 'Mich bei Antworten benachrichtigen',
    37 => 'Neue Antwort auf Kommentar',
    38 => 'Eine Antwort ist eingegangen auf den Kommentar \'%s\'.',
    39 => 'Den Kommentar-Thread kann man an folgender Adresse sehen:',
    40 => 'Wenn keine weiteren Benachrichtigungen gewnscht sind, dann bitte folgenden Link besuchen:',
    41 => 'Hallo %s,',
    42 => 'Abmelden',
    43 => 'Abmelden von Benachrichtigungen auf Kommentare',
    44 => 'Dein Name',
    45 => "Thank you for your comment. You must wait {$_CONF['commentspeedlimit']} seconds to post a new comment."
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Userprofil fr',
    2 => 'Username',
    3 => 'Name',
    4 => 'Neues Passwort',
    5 => 'E-Mail',
    6 => 'Homepage',
    7 => 'Biographie',
    8 => 'PGP-Key',
    9 => 'Speichern',
    10 => 'Die letzten 10 Kommentare von',
    11 => 'Keine Kommentare',
    12 => 'User-Einstellungen fr',
    13 => 'E-Mail Nightly Digest',
    14 => 'Dieses Passwort wurde mit einem Zufallsgenerator erzeugt. Es wird empfohlen, das Passwort nach dem Anmelden sofort zu ndern. Um Dein Passwort zu ndern, melde Dich bitte an und whle dann den Punkt Mein Profil im Block Einstellungen.',
    15 => "Dein Account fr {$_CONF['site_name']} wurde erfolgreich angelegt. Um ihn benutzen zu knnen, melde Dich bitte mit den folgenden Informationen an. Diese E-Mail bitte aufheben.",
    16 => 'Deine Zugangsdaten',
    17 => 'Account existiert nicht',
    18 => 'Die angegebene E-Mail-Adresse scheint keine gltige E-Mail-Adresse zu sein',
    19 => 'Dieser Username oder diese E-Mail-Adresse existieren bereits.',
    20 => 'Die angegebene E-Mail-Adresse scheint keine gltige E-Mail-Adresse zu sein',
    21 => 'Fehler',
    22 => "Anmelden bei {$_CONF['site_name']}!",
    23 => "Indem Du Dich bei {$_CONF['site_name']} anmeldest, kannst Du Artikel und Kommentare unter Deinem eigenen Namen verffentlichen (andernfalls geht das nur anonym). brigens wird Deine E-Mail-Adresse <strong><em>niemals</em></strong> auf dieser Website angezeigt werden.",
    24 => 'Dein Passwort wird Dir an die angegebene E-Mail-Adresse geschickt.',
    25 => 'Passwort vergessen?',
    26 => 'Gib <em>entweder</em> Deinen Usernamen <em>oder</em> die E-Mail-Adresse ein, mit der Du Dich angemeldet hast, und klicke auf Passwort schicken. Eine E-Mail mit einer Anleitung, wie Du ein neues Passwort eingeben kannst, wird dann an die gespeicherte E-Mail-Adresse geschickt.',
    27 => 'Jetzt anmelden!',
    28 => 'Passwort schicken',
    29 => 'ausgeloggt von',
    30 => 'eingeloggt von',
    31 => 'Um diese Funktion nutzen zu knnen, musst Du angemeldet sein',
    32 => 'Signatur',
    33 => 'Auf der Site nicht sichtbar!',
    34 => 'Dein richtiger Name',
    35 => 'Passwort eingeben, um es zu ndern',
    36 => '(mit http://)',
    37 => 'Wird an Deine Kommentare angefgt',
    38 => 'Alles ber Dich - fr alle sichtbar',
    39 => 'Dein PGP-Key, so vorhanden',
    40 => 'Kategorien ohne Icons',
    41 => 'Bereit zu Moderieren',
    42 => 'Datumsformat',
    43 => 'Artikel pro Seite',
    44 => 'Keine Blcke',
    45 => 'Anzeige-Einstellungen fr',
    46 => 'Nicht anzeigen fr',
    47 => 'Block-Einstellungen fr',
    48 => 'Kategorien',
    49 => 'Keine Icons in Artikeln',
    50 => 'Hkchen entfernen, wenn es Dich nicht interessiert',
    51 => 'Nur die Artikel',
    52 => 'Grundeinstellung:',
    53 => 'Artikel jede Nacht empfangen',
    54 => 'Kategorien und Autoren auswhlen, die Du NICHT sehen willst.',
    55 => 'Wenn Du hier nichts ankreuzt, wird die Default-Auswahl an Blcken angezeigt. Sobald Du anfngst, Blcke anzukreuzen, werden auch nur noch diejenigen angezeigt, die angekreuzt sind! Die Default-Blcke sind <b>fett</b> markiert.',
    56 => 'Autoren',
    57 => 'Anzeigemodus',
    58 => 'Sortierreihenfolge',
    59 => 'Kommentarlimit',
    60 => 'Wie sollen Kommentare angezeigt werden?',
    61 => 'Neueste oder lteste zuerst?',
    62 => 'Defaultwert: 100',
    63 => "Dein Passwort sollte in Krze per E-Mail eintreffen. Bitte beachte die Hinweise in der E-Mail und Danke fr Dein Interesse an {$_CONF['site_name']}",
    64 => 'Kommentar-Einstellungen fr',
    65 => 'Bitte noch einmal versuchen, Dich anzumelden',
    66 => 'Hast Du Dich vertippt? Bitte versuch noch einmal, Dich hier anzumelden.',
    67 => 'Mitglied seit',
    68 => 'Angemeldet fr',
    69 => 'Wie lange soll das System Dich nach dem Anmelden erkennen?',
    70 => "Aussehen und Inhalt von {$_CONF['site_name']} konfigurieren",
    71 => "Zu den Features von {$_CONF['site_name']} gehrt, dass Du selbst festlegen kannst, welche Artikel Du angezeigt bekommst. Darber hinaus kannst Du auch das Aussehen der Website verndern. Um in den Genuss dieser Features zu kommen, musst Du Dich jedoch zuerst bei {$_CONF['site_name']} <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">anmelden</a>. Oder bist Du schon angemeldet? Dann benutze bitte das Anmeldeformular auf der linken Seite.",
    72 => 'Erscheinungsbild',
    73 => 'Sprache',
    74 => 'ndere das Aussehen dieser Site',
    75 => 'Artikel per E-Mail fr',
    76 => 'Whle Kategorien aus der folgenden Liste und Du bekommst einmal pro Tag eine E-Mail mit einer bersicht aller neuen Artikel in den ausgewhlten Kategorien. Du brauchst nur die Kategorien anzukreuzen, die Dich interessieren.',
    77 => 'Foto',
    78 => 'Ein Bild von Dir',
    79 => 'Ankreuzen, um dieses Bild zu lschen:',
    80 => 'Anmelden',
    81 => 'E-Mail schreiben',
    82 => 'Die letzten 10 Artikel von',
    83 => 'Statistik fr',
    84 => 'Gesamtanzahl Artikel:',
    85 => 'Gesamtanzahl Kommentare',
    86 => 'Alle Artikel und Kommentare von',
    87 => 'Dein Username',
    88 => "Jemand (mglicherweise Du selbst) hat ein neues Passwort fr Deinen Account \"%s\" auf {$_CONF['site_name']} <{$_CONF['site_url']}> angefordert.\n\nWenn Du tatschlich ein neues Passwort bentigst, klicke bitte auf den folgenden Link:\n\n",
    89 => "Mchtest Du Dein Passwort nicht ndern, so kannst Du diese E-Mail einfach ignorieren (Dein bisheriges Passwort bleibt dann unverndert gltig).\n\n",
    90 => 'Du kannst hier jetzt ein neues Passwort fr Deinen Account eingeben. Dein altes Passwort bleibt noch solange gltig, bis Du dieses Formular abschickst.',
    91 => 'Neues Passwort',
    92 => 'Neues Passwort eingeben',
    93 => 'Du hast zuletzt vor %d Sekunden ein neues Passwort angefordert. Zwischen zwei Passwort-Anforderungen mssen aber mindestens %d Sekunden vergangen sein.',
    94 => 'Lsche Account "%s"',
    95 => 'Du kannst Deinen Account lschen, indem Du auf den "Account Lschen"-Button klickst. Artikel und Kommentare, die Du unter diesem Account geschrieben hast, werden <strong>nicht</strong> gelscht, werden aber fortan als vom User "Gast" geschrieben erscheinen.',
    96 => 'Account lschen',
    97 => 'Account lschen besttigen',
    98 => 'Bist Du sicher, dass Du Deinen Account lschen willst? Du wirst Dich danach nicht mehr einloggen knnen (es sei denn, Du legst einen neuen Account an). Wenn Du Dir sicher bist, klicke bitte noch einmal auf "Account Lschen".',
    99 => 'Privatsphre-Einstellungen fr',
    100 => 'E-Mail von Admin',
    101 => 'E-Mails von Site-Admins erlauben',
    102 => 'E-Mail von Usern',
    103 => 'E-Mails von anderen Usern erlauben',
    104 => 'Online-Status zeigen',
    105 => 'Unter "Wer ist online?"',
    106 => 'Wohnort',
    107 => 'Erscheint im ffentlichen Profil',
    108 => 'Neues Passwort besttigen',
    109 => 'Hier bitte das neue Passwort noch einmal eingeben',
    110 => 'Aktuelles Passwort',
    111 => 'Gib Dein aktuelles Passwort ein',
    112 => 'Du hast die erlaubte Anzahl von Anmeldeversuchen berschritten. Bitte versuche es spter noch einmal.',
    113 => 'Anmeldeversuch fehlgeschlagen',
    114 => 'Account gesperrt',
    115 => 'Dein Account wurde gesperrt. Du kannst Dich nicht einloggen. Bitte wende Dich an einen Administrator.',
    116 => 'Account noch nicht freigegeben',
    117 => 'Dein Account muss erst noch von einem Administrator freigegeben werden. Du kannst Dich erst einloggen, wenn Dein Account freigegeben wurde.',
    118 => "Dein Account fr {$_CONF['site_name']} wurde jetzt freigeschaltet. Du kannst Dich jetzt auf der Website unter der unten angegebenen URL anmelden. Benutze dazu Deinen Usernamen (<username>) und das Passwort, das Du bereits per E-Mail erhalten hast.",
    119 => 'Wenn Du Dein Passwort vergessen hast, kannst Du unter der folgenden URL ein neues anfordern:',
    120 => 'Account aktiviert',
    121 => 'Dienst',
    122 => 'Sorry, derzeit knnen sich keine neuen User anmelden.',
    123 => "Bist Du ein <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">neuer User</a>?",
    124 => 'E-Mail besttigen',
    125 => 'Die E-Mail-Adressen stimmen nicht berein. Bitte in beiden Feldern die gleiche E-Mail-Adresse eintragen!',
    126 => 'Bitte die gleiche Adresse noch einmal eingeben',
    127 => 'Um diese Angaben zu ndern musst Du Dein aktuelles Passwort eingeben.',
    128 => 'Dein Name',
    129 => 'Passwort &amp; E-Mail',
    130 => 'ber Dich',
    131 => 'Daily Digest Optionen',
    132 => 'Daily Digest-Funktion',
    133 => 'Kommentaranzeige',
    134 => 'Kommentaranzeige',
    135 => '<li>Anzeigemodus: Wie Kommentare angezeigt werden</li><li>Sortierreihenfolge: Wie Kommentare sortiert werden</li><li>Kommentarlimit: Maximale Anzahl Kommentare, die angezeigt werden (Default: 100)</li>',
    136 => 'Kategorien und Autoren ausblenden',
    137 => 'Artikel ausfiltern',
    138 => 'Darstellung und Sprache',
    139 => 'Darstellung und Sprache',
    140 => '<li>Kategorien ohne Icons: Wenn angekreuzt werden in Artikeln keine Icons mehr angezeigt.</li><li>Keine Blcke: Wenn angekreuzt werden nur noch die Blcke Einstellungen, Kategorien und der Admin-Block angezeigt.<li>Einstellung fr die maximale Anzahl von Artikeln pro Seite.</li><li>Whle das Erscheinungsbild der Website, Deine Zeitzone und das bevorzugte Datumsformat.</li>',
    141 => 'Privatsphre',
    142 => 'Per Grundeinstellung ist es Admins und anderen Usern der Site erlaubt, Dir E-Mails zu schicken sowie Deinen Status unter "Wer Ist Online?" zu sehen. Hier kannst Du diese Einstellungen ndern.',
    143 => 'Blcke anzeigen',
    144 => 'Blcke anzeigen',
    145 => 'Vorschau: So sieht Dein Profil aus',
    146 => 'Passwort &amp; E-Mail',
    147 => 'Hier kannst Du Dein Passwort und Deine E-Mai-Adresse ndern sowie bestimmen, wie lange Du eingeloggt bleiben willst. Passwort und E-Mail mssen zum ndern zweimal eingegeben werden.',
    148 => 'ber Dich',
    149 => 'Hier kannst Du eingeben, was andere User ber Dich sehen knnen:<ul><li>Die Signatur wird an Kommentare angefgt</li><li>In der Biographie kannst Du etwas ber Dich erzhlen</li><li>Du kannst Deinen PGP-Key hinterlegen</li></ul>',
    150 => '',
    156 => 'Account lschen',
    157 => 'Lschen',
    158 => 'Zeitzone',
    159 => 'Diese E-Mail wurde automatisch generiert. Bitte nicht auf diese E-Mail antworten.',
    160 => '(max. %d x %d Pixel, %d Bytes; %s)',
    161 => 'wird ggfs. skaliert',
    162 => 'wird nicht skaliert',
    163 => 'Die Wiederauthetifizierung klappte nicht',
    164 => 'Die maximale Anzahl fr Wiederauthentifizierungsversuche wurde berschritten. Der Vorgang wurde abgebrochen und die letzten nderungen gingen verloren, sorry.',
    165 => 'WYSIWYG-Editor',
    166 => 'Re-synch Remote Account',
    167 => 'Remote login',
    168 => 'You may also login with one on of the below remote authentication services'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Vorschau',
    'pe_namepass' => 'Username &amp; Passwort',
    'pe_userinfo' => 'ber Dich',
    'pe_layout' => 'Darstellung &amp; Sprache',
    'pe_content' => 'Inhalt',
    'pe_privacy' => 'Privatsphre'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Keine Artikel',
    2 => 'Es gibt keine Artikel, die angezeigt werden knnten. Entweder gibt es fr diese Kategorie keine Artikel oder die persnlichen Einstellungen sind zu restriktiv.',
    3 => ' fr die Kategorie %s.',
    4 => 'Hauptartikel',
    5 => 'weiter',
    6 => 'zurck',
    7 => 'Anfang',
    8 => 'Ende'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Es gab einen Fehler beim Versenden der Nachricht. Bitte noch einmal versuchen.',
    2 => 'Nachricht wurde verschickt.',
    3 => 'Bitte sicherstellen, dass Du eine gltige E-Mail-Adresse eingetragen hast.',
    4 => 'Bitte alle Felder ausfllen: Dein Name, Deine E-Mail, Betreff und Nachricht',
    5 => 'Fehler: Username nicht bekannt.',
    6 => 'Es ist ein Fehler aufgetreten.',
    7 => 'Userprofil fr',
    8 => 'Username',
    9 => 'User URL',
    10 => 'Eine Mail schicken an',
    11 => 'Dein Name:',
    12 => 'Deine E-Mail:',
    13 => 'Betreff:',
    14 => 'Nachricht:',
    15 => 'HTML wird nicht interpretiert.',
    16 => 'Nachricht abschicken',
    17 => 'Artikel an einen Freund schicken',
    18 => 'An (Name)',
    19 => 'An (E-Mail)',
    20 => 'Von (Name)',
    21 => 'Von (E-Mail)',
    22 => 'Alle Felder mssen ausgefllt werden.',
    23 => "Diese Nachricht wurde Dir von %s <%s> geschickt, da er/sie der Meinung war, Du wrdest Dich vielleicht fr diesen Artikel auf <{$_CONF['site_url']}> interessieren. Dies ist kein Spam und die beteiligten E-Mail-Adressen (Deine und die des Absenders) wurden nicht gespeichert.",
    24 => 'Schreibe einen Kommentar zu diesem Artikel:',
    25 => 'Du musst Dich anmelden, um diese Funktion benutzen zu knnen. Dies ist leider ntig, um den Missbrauch des Systems zu verhindern',
    26 => 'Mit diesem Formular kannst Du eine E-Mail an diesen User schicken. Alle Felder mssen ausgefllt werden.',
    27 => 'Kurze Nachricht',
    28 => '%s schrieb: ',
    29 => "Dies sind die neuen Artikel auf {$_CONF['site_name']} vom ",
    30 => ' - Neue Artikel vom ',
    31 => 'Titel',
    32 => 'Datum',
    33 => 'Kompletter Artikel unter',
    34 => 'Ende dieser Nachricht',
    35 => 'Sorry, dieser User mchte keine E-Mails bekommen.',
    36 => 'Kopie:',
    37 => 'Ich mchte eine Kopie der E-Mail bekommen',
    38 => "Dies ist eine Kopie der E-Mail, die Du von <{$_CONF['site_url']}> an %s geschickt hast:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Erweiterte Suche',
    2 => 'Suchbegriffe',
    3 => 'Kategorie',
    4 => 'Alle',
    5 => 'Art',
    6 => 'Artikel',
    7 => 'Kommentare',
    8 => 'Autoren',
    9 => 'Alle',
    10 => 'Suchen',
    11 => 'Suchergebnisse',
    12 => 'Treffer',
    13 => 'Erweiterte Suche: Keine Treffer',
    14 => 'Es gab keine Treffer fr die Suche nach',
    15 => 'Bitte noch einmal versuchen.',
    16 => 'Titel',
    17 => 'Datum',
    18 => 'Autor',
    19 => "Durchsuche die komplette Datenbank von {$_CONF['site_name']} ...",
    20 => 'Datum',
    21 => 'bis',
    22 => '(Datumsformat: JJJJ-MM-TT)',
    23 => 'Angezeigt',
    24 => '%d Eintrge gefunden',
    25 => 'Gesucht wurde nach',
    26 => 'Beitrgen in',
    27 => 'Sekunden.',
    28 => 'Keine Treffer unter den Artikeln und Kommentaren.',
    29 => 'Gefundene Artikel und Kommentare',
    30 => '',
    31 => 'Dieses Plugin lieferte keine Treffer',
    32 => '',
    33 => 'URL',
    34 => 'Ort',
    35 => 'Ganztgig',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Der Suchbegriff sollte mindestens 3 Zeichen lang sein.',
    42 => 'Das Datum muss im Format JJJJ-MM-TT (Jahr-Monat-Tag) eingegeben werden.',
    43 => 'genaue Wortgruppe',
    44 => 'alle Wrter',
    45 => 'irgendeines der Wrter',
    46 => 'weiter',
    47 => 'zurck',
    48 => 'Autor',
    49 => 'Datum',
    50 => 'Angezeigt',
    51 => '',
    52 => 'Wohnort',
    53 => 'Gefundene Artikel',
    54 => 'Gefundene Kommentare',
    55 => 'der Wortgruppe',
    56 => '<em>und</em>',
    57 => '<em>oder</em>',
    58 => 'Weitere Ergebnisse &gt;&gt;',
    59 => 'Ergebnisse',
    60 => 'pro Seite',
    61 => 'Suche korrigieren',
    62 => '#',
    63 => 'Beschreibung',
    64 => 'Gezeigt werden %1$d - %2$d von %3$d Ergebnissen',
    65 => 'Artikel',
    66 => 'Kommentar',
    67 => 'Zeige %d Suchergebnisse',
    68 => 'Sortieren nach',
    69 => 'Nur Titel durchsuchen',
    70 => 'Nicht verfgbar ...',
    71 => 'aufsteigend',
    72 => 'absteigend'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Site-Statistik',
    2 => 'Gesamtzahl der Seitenabrufe',
    3 => 'Anzahl Artikel (Kommentare)',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Top Ten der Artikel',
    8 => 'Artikelberschrift',
    9 => 'Angezeigt',
    10 => 'Es gibt keine Artikel oder sie wurden von niemandem gelesen.',
    11 => 'Top Ten der meistkommentierten Artikel',
    12 => 'Kommentare',
    13 => 'Es gibt keine Artikel oder es wurden keine Kommentare dazu abgegeben.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Top Ten der verschickten Artikel',
    23 => 'E-Mails',
    24 => 'Es wurden keine Artikel per E-Mail verschickt.',
    25 => 'Top Ten der Artikel mit Trackback-Kommentaren',
    26 => 'Keine Trackback-Kommentare gefunden.',
    27 => 'Anzahl aktiver User',
    28 => '',
    29 => '',
    30 => 'Angezeigt',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Weiterfhrende Links',
    2 => 'An einen Freund schicken',
    3 => 'Druckfhige Version',
    4 => 'Optionen',
    5 => '',
    6 => 'Newsfeed \'%s\' abonnieren'
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'To submit a %s you are required to be logged in as a user.',
    2 => 'Anmelden',
    3 => 'Neuer User',
    4 => '',
    5 => '',
    6 => 'Einen Artikel einreichen',
    7 => 'Anmeldung erforderlich',
    8 => 'Abschicken',
    9 => 'Wenn Du Informationen einreichen mchtest, die auf dieser Site verffentlicht werden sollen, dann bitten wir Dich, folgende Punkte zu beachten:<ul><li>Bitte alle Felder ausfllen, sie werden bentigt<li>Bitte nur vollstndige und exakte Informationen einreichen<li>URLs vor dem Abschicken unbedingt noch einmal kontrollieren</ul>',
    10 => 'Titel',
    11 => '',
    12 => 'Startdatum',
    13 => 'Enddatum',
    14 => 'Ort',
    15 => 'Beschreibung',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Bitte lesen',
    20 => '',
    21 => '',
    22 => 'Fehler: Nicht alle Felder ausgefllt',
    23 => 'Bitte alle Felder des Formulars ausfllen. Alle Felder werden bentigt.',
    24 => 'Beitrag gespeichert',
    25 => 'Der %s-Beitrag wurde gespeichert.',
    26 => 'Speed Limit',
    27 => 'Username',
    28 => 'Kategorie',
    29 => 'Artikel',
    30 => 'Dein letzter Beitrag war vor ',
    31 => " Sekunden. Zwischen zwei Beitrgen mssen aber mindestens {$_CONF['speedlimit']} Sekunden vergangen sein.",
    32 => 'Vorschau',
    33 => 'Artikelvorschau',
    34 => 'Abmelden',
    35 => 'HTML-Tags sind nicht erlaubt',
    36 => 'Format',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Addresse, Zeile 1',
    45 => 'Addresse, Zeile 2',
    46 => 'Stadt',
    47 => 'Bundesland',
    48 => 'Postleitzahl',
    49 => '',
    50 => '',
    51 => 'Ort',
    52 => 'Lschen',
    53 => 'Account anlegen',
    54 => 'Einleitung Artikel',
    55 => 'Hauptteil Artikel'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Bitte authentifizieren!',
    2 => 'Zugriff verweigert! Anmeldeinformation ungltig',
    3 => 'Ungltiges Passwort fr User',
    4 => 'Username:',
    5 => 'Passwort:',
    6 => 'Zugriffe auf die Administrationsseiten dieser Website werden aufgezeichnet und kontrolliert.<br' . XHTML . '>Diese Seiten sind nur fr befugte Personen zugnglich.',
    7 => 'einloggen'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Ungengende Rechte',
    2 => 'Du hast nicht die ntigen Rechte, um diesen Block ndern zu knnen.',
    3 => 'Block-Editor',
    4 => 'Beim Lesen dieses Newsfeeds trat ein Fehler auf (die Datei error.log enthlt nhere Informationen).',
    5 => 'Ja',
    6 => 'Nein',
    7 => 'Alle',
    8 => 'Block-Sicherheitsstufe',
    9 => 'Reihenfolge',
    10 => '',
    11 => 'Portal-Block',
    12 => 'Normaler Block',
    13 => 'Portal-Block: Optionen',
    14 => 'RSS-URL',
    15 => 'Letztes Update',
    16 => 'Normaler Block: Optionen',
    17 => 'Inhalt',
    18 => 'Bitte ausfllen: Block-Titel, Sicherheitsstufe und Inhalt',
    19 => 'Block-Manager',
    20 => 'Regulre Blcke',
    21 => 'Block-Sichh.',
    22 => 'Dynamische Blcke',
    23 => 'Reihenfolge',
    24 => 'Dynamisch',
    25 => 'Um einen Block zu ndern oder zu lschen, auf das ndern-Symbol (s.u.) klicken. Um einen neuen Block anzulegen, auf Neu anlegen (s.o.) klicken.',
    26 => 'Layout-Block',
    27 => 'PHP-Block',
    28 => 'PHP-Block: Optionen',
    29 => 'Block-Funktion',
    30 => 'Wenn einer Deiner Blcke PHP-Code verwenden soll, gib hier bitte den Namen der Funktion ein. Der Funktionsname muss mit "phpblock_" (z.B. phpblock_getweather) beginnen. Wenn sie diese Namenskonvention nicht einhlt, wird die Funktion NICHT aufgerufen. Das soll verhindern, dass Hacker evtl. gefhrlichen Code einschleusen knnen. Den Funktionsnamen NICHT mit einem Klammerpaar "()" abschliessen. Ferner wird empfohlen, all Deinen Code fr PHP-Blcke in der Datei /pfad/zu/geeklog/system/lib-custom.php abzulegen. Dort kann der Code auch dann unverndert bleiben, wenn Du auf eine neuere Geeklog-Version umsteigst.',
    31 => 'Fehler in PHP-Block: Funktion %s existiert nicht.',
    32 => 'Fehler: Nicht alle Felder ausgefllt',
    33 => 'Fr Portal-Blcke muss ein Titel und eine URL zur RSS-Datei angegeben werden.',
    34 => 'Fr PHP-Blcke muss ein Titel und der Funktionsname eingegeben werden.',
    35 => 'Fr normale Blcke muss ein Titel und der Inhalt eingegeben werden.',
    36 => 'Fr Layout-Blcke muss der Inhalt eingegeben werden.',
    37 => 'Ungltiger Funktionsname fr einen PHP-Block',
    38 => 'Funktionen fr PHP-Blcke mssen mit \'phpblock_\' beginnen (z.B. phpblock_getweather). Der \'phpblock_\'-Teil wird aus Sicherheitsgrnden vorausgesetzt, um das Ausfhren von beliebigem Code zu verhindern.',
    39 => 'Seite',
    40 => 'links',
    41 => 'rechts',
    42 => 'Fr Geeklog-Default-Blcke muss ein Block-Titel und die Block-Reihenfolge angegeben werden.',
    43 => 'Nur auf der Startseite',
    44 => 'Multiple',
    45 => "Du hast keine Zugriffsrechte fr diesen Block. Dieser Zugriffsversuch wurde protokolliert. <a href=\"{$_CONF['site_admin_url']}/block.php\">Zurck zum Administrator-Men</a>.",
    46 => 'Bewegen',
    47 => 'None',
    48 => 'Block-Name',
    49 => ' (keine Leerzeichen, muss eindeutig sein)',
    50 => 'Der Block-Name kann nicht leer sein',
    51 => '(mit http://)',
    52 => 'Wenn das Feld leer ist, wird kein Hilfesymbol zu diesem Block angezeigt.',
    53 => 'Aktiv',
    54 => 'Speichern',
    55 => 'Abbruch',
    56 => 'Lschen',
    57 => 'Block nach unten',
    58 => 'Block nach oben',
    59 => 'Block auf die rechte Seite',
    60 => 'Block auf die linke Seite',
    61 => 'Ohne Titel',
    62 => 'Artikellimit',
    63 => 'Block-Titel nicht erlaubt',
    64 => 'Der Titel kann nicht leer sein und darf kein HTML enthalten!',
    65 => 'Reihenfolge',
    66 => 'Autotags',
    67 => 'Ankreuzen, um Autotags zu interpretieren',
    68 => 'Der Newsfeed fr diesen Portalblock ist zu lang, um angezeigt zu werden. Bitte eine maximale Anzahl Artikel angeben, die fr den Block importiert werden soll. Dieses entweder im Blockeditor einstellen oder in der allgemeinen Voreinstelung in der Geeklog Konfiguration.',
    69 => 'Plugin-Name'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Vorherige Artikel',
    2 => 'Nchste Artikel',
    3 => 'Modus',
    4 => 'Format',
    5 => 'Artikel-Editor',
    6 => 'Es sind keine Artikel vorhanden.',
    7 => 'Autor',
    8 => 'Speichern',
    9 => 'Vorschau',
    10 => 'Abbruch',
    11 => 'Lschen',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Datum',
    16 => 'Einleitung',
    17 => 'Haupttext',
    18 => 'Angezeigt',
    19 => 'Kommentare',
    20 => 'Ping',
    21 => 'Senden',
    22 => 'Artikelliste',
    23 => 'Auf das ndern-Symbol klicken, um einen Artikel zu ndern oder zu lschen. Um einen Artikel anzusehen, auf dessen Titel klicken. Auf Neu anlegen (s.o.) klicken, um einen neuen Artikel zu schreiben.',
    24 => 'Diese ID wird bereits fr einen anderen Artikel benutzt. Bitte eine andere ID whlen.',
    25 => 'Fehler beim Speichern des Artikels',
    26 => 'Artikelvorschau',
    27 => '<p>Wenn Du [unscaledX] statt [imageX] verwendest, wird das Bild in Originalgre eingebunden.',
    28 => '<p><strong>VORSCHAU:</strong> Der Vorschau-Button sollte nur verwendet werden, wenn der Artikel keine Bilder enthlt. Bei Artikeln mit Bildern empfiehlt es sich, den Artikel als Entwurf zu markieren, zu speichern und dann von der Liste der Artikel aus zu betrachten.</p>',
    29 => 'Trackbacks',
    30 => 'Fehler beim Datei-Upload',
    31 => 'Bitte mindestens die Felder Titel und Einleitung ausfllen',
    32 => 'Hauptartikel',
    33 => 'Es kann nur einen Hauptartikel geben',
    34 => 'Entwurf',
    35 => 'Ja',
    36 => 'Nein',
    37 => 'Mehr von',
    38 => 'Mehr aus',
    39 => 'E-Mails',
    40 => '',
    41 => "Du hast keine Zugriffsrechte fr diesen Artikel. Dieser Zugriffsversuch wurde protokolliert. Du kannst Dir den Artikel aber ansehen (s.u., ndern nicht mglich). <a href=\"{$_CONF['site_admin_url']}/story.php\">Zurck zum Administrator-Men</a>.",
    42 => "Du hast keine Zugriffsrechte fr diesen Artikel. Dieser Zugriffsversuch wurde protokolliert. <a href=\"{$_CONF['site_admin_url']}/story.php\">Zurck zum Administrator-Men</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>HINWEIS:</b> Wenn Du hier ein Datum in der Zukunft einstellst, wird der Artikel erst verffentlicht, wenn dieser Zeitpunkt erreicht ist. Bis dahin wird der Artikel auch nicht in der RSS-Datei, der Suche und der Statistik erscheinen.',
    47 => 'Bilder',
    48 => 'image',
    49 => 'right',
    50 => 'left',
    51 => '<p>Die oben ausgewhlten Bilder knnen im Artikel verwendet werden, indem dafr spezielle Platzhalter in den Text eingefgt werden. Diese Platzhalter sind [imageX], [imageX_right] und [imageX_left], wobei statt des X jeweils die Nummer des Bildes eingetragen werden muss.<br' . XHTML . '>HINWEIS: Es mssen alle ausgewhlten Bilder verwendet werden. Andernfalls kann der Artikel nicht gespeichert werden.<br' . XHTML . '>',
    52 => '',
    53 => 'wurde nicht verwendet. Du musst dieses Bild im Text des Artikels verwenden oder es lschen bevor Du Deine nderungen sichern kannst.',
    54 => 'Nicht verwendete Bilder',
    55 => 'Folgende Fehler traten beim Versuch, den Artikel zu speichern, auf. Bitte diese Fehler beheben und den Artikel noch einmal speichern.',
    56 => 'mit Symbol',
    57 => 'Bild in Originalgre',
    58 => 'Archivieren',
    59 => 'Option',
    60 => '',
    61 => 'automatisch archivieren',
    62 => 'automatisch lschen',
    63 => 'Kommentare abschalten',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Editierbereich vergrern',
    68 => 'Editierbereich verkleinern',
    69 => 'Verffentlichungsdatum',
    70 => 'Auswahl der Symbolleiste',
    71 => 'Einfache Symbolleiste',
    72 => 'Normale Symbolleiste',
    73 => 'Extra Symbolleiste',
    74 => 'Extra II Symbolleiste',
    75 => 'Alle Symbole',
    76 => 'Verffentlichung',
    77 => 'JavaScript mu fr den WYSIWYG-Editor an sein. Der WYSIWYG-Editor kann in der Geeklog Konfiguration ausgeschaltet werden.',
    78 => 'Klick <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">hier</a>, um den Standard-Editor zu verwenden',
    79 => 'Vorschau',
    80 => 'Editor',
    81 => 'Verffentlichung',
    82 => 'Bilder',
    83 => 'Archivierung',
    84 => 'Rechte',
    85 => 'Alles anzeigen',
    86 => 'WYSIWYG-Editor',
    87 => 'Artikel-Statistik',
    88 => 'Format im Wiki-Stil',
    89 => 'Metatag Description',
    90 => 'Metatag Keywords',
    91 => 'Du kannst aber jederzeit auf "Vorschau" klicken, um diese Zeit zu verlngern.',
    'autotag_desc_story' => '[story: id alternate title] - Displays a link to a Story using the Story Title as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Kategorie-Editor',
    2 => 'Kategorie-ID',
    3 => 'Kategorie-Name',
    4 => 'Kategorie-Bild',
    5 => '(keine Leerzeichen!)',
    6 => 'Lschen einer Kategorie lscht auch alle dazu gehrenden Artikel und Blcke',
    7 => 'Bitte die Felder Kategorie-ID und Kategorie-Name ausfllen',
    8 => 'Kategorie-Manager',
    9 => 'Auf eine Kategorie klicken, um sie zu ndern oder zu lschen. Auf Neu anlegen (s.o.) klicken, um eine neue Kategorie anzulegen. Die ntige Zugriffsberechtigung wird in Klammern hinter der Kategorie angegeben. Das Sternchen(*) markiert die Default-Kategorie.',
    10 => 'Sortierreihenfolge',
    11 => 'Artikel/Seite',
    12 => 'Zugriff verweigert',
    13 => "Du hast keine Zugriffsrechte fr diese Kategorie. Dieser Zugriffsversuch wurde protokolliert. <a href=\"{$_CONF['site_admin_url']}/topic.php\">Zurck zum Administrator-Men</a>.",
    14 => 'Sortiermethode',
    15 => 'alphabetisch',
    16 => 'Grundeinstellung:',
    17 => 'Neue Kategorie',
    18 => 'Schaltzentrale',
    19 => 'Speichern',
    20 => 'Abbruch',
    21 => 'Lschen',
    22 => 'Grundeinstellung',
    23 => 'Zur voreingestellten Kategorie fr neue Artikel machen',
    24 => '(*)',
    25 => 'Archiv-Kategorie',
    26 => 'Zur Archiv-Kategorie machen (nur fr eine Kategorie mglich)',
    27 => 'oder ein Symbol hochladen',
    28 => 'maximal',
    29 => 'Fehler beim Datei-Upload',
    30 => 'Artikel i.d. Kategorie',
    31 => 'You have used a restricted Topic ID. Please choose another one.',
    32 => 'bergeordnete Kategorie',
    33 => 'Erben',
    34 => 'Artikel von Unterkategorien erben',
    35 => 'Versteckt',
    36 => 'Kategorie wird versteckt und kann nicht eingesehen werden, nur vererbt',
    37 => 'Root',
    38 => 'Alle',
    39 => 'Nur auf der Startseite',
    40 => 'Assign one or more topics. ',
    41 => 'Wenn "Alle" ausgewhlt ist, wird das Objekt fr alle Kategorien angezeigt. Wenn "Nur auf der Startseite" ausgewhlt ist, wird das Objekt nur auf der Startseite angezeigt. Andernfalls muss mindestens eine Kategorie ausgewhlt werden.',
    42 => 'Inherit contains the list of assigned topics. If the topic is selected then the item will be inherited by the parent topic. You must save your item first before anything is listed in the inherit box. ',
    43 => 'Default contains the list of assigned topics. This is the default topic that will be used when displaying the item if the actual topic the user is in is not found. ',
    44 => 'Erben',
    45 => 'Default',
    46 => 'Your parent topic cannot be the Archive topic. Please choose a different Parent Topic.',
    47 => 'An Archive Topic cannot have any child topics. Please remove any child topics before making a topic the Archive Topic.',
    48 => 'Parent Topic Id not found.',
    49 => 'This Topic ID is already being used. Please choose another one.',
    50 => 'Ja',
    51 => 'Nein',
    52 => 'Artikel',
    53 => 'Bild',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'Home'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'User-Editor',
    2 => 'User-ID',
    3 => 'Username',
    4 => 'Name',
    5 => 'Passwort',
    6 => 'Security Level',
    7 => 'E-Mail-Adresse',
    8 => 'Homepage',
    9 => '(keine Leerzeichen!)',
    10 => 'Bitte die Felder Username und E-Mail-Adresse ausfllen.',
    11 => 'User-Manager',
    12 => 'Auf das ndern-Symbol klicken, um einen User zu ndern oder zu lschen. Ein neuer User kann mit Neu anlegen (s.o.) angelegt werden.',
    13 => 'SecLev',
    14 => 'Reg. Datum',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'Speichern',
    21 => 'Dieser Username existiert bereits.',
    22 => 'Fehler',
    23 => 'Import',
    24 => 'Mehrfach-Import von Usern',
    25 => 'Hier knnen Userdaten aus einer Datei in Geeklog importiert werden. Die Import-Datei muss ein Textfile sein, bei dem die Datenstze durch Tabs getrennt sind. Zudem mssen die Felder in der Reihenfolge Richtiger Name - Username - E-Mail-Adresse vorliegen. Jeder so importierte User bekommt eine E-Mail mit einem Zufallspasswort zugeschickt. Pro Zeile darf nur ein User stehen. Wenn sich die Importdatei nicht an dieses Format hlt, kann es zu Problemen kommen, die nur in mhseliger Handarbeit behoben werden knnen. Also die Eintrge lieber zweimal berprfen ...',
    26 => '',
    27 => '',
    28 => 'Ankreuzen, um dieses Bild zu lschen:',
    29 => 'Pfad',
    30 => 'Importieren',
    31 => 'Neue User',
    32 => 'Datei bearbeitet. %d User wurden importiert, dabei traten %d Fehler auf.',
    33 => 'Abschicken',
    34 => 'Fehler: Keine Datei zum Upload angegeben.',
    35 => 'Letzte Anmeldung',
    36 => '(noch nie)',
    37 => 'UID',
    38 => 'Gruppenliste',
    39 => 'Passwort (nochmal)',
    40 => 'Registriert',
    41 => 'Letzte Anmeldung',
    42 => 'Gesperrt',
    43 => 'Erwartet Aktivierung',
    44 => 'Erwartet Freigabe',
    45 => 'Aktiv',
    46 => 'User-Status',
    47 => 'ndern',
    48 => 'Admin-Gruppen anzeigen',
    49 => 'Admin-Gruppe',
    50 => 'Ankreuzen, um diese Gruppe als "Admin-Gruppe" ausfiltern zu knnen',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Hinweis: "Online Days" ist die Anzahl der Tage zwischen der ersten Anmeldung und der letzten.',
    53 => 'registriert',
    54 => 'User lschen',
    55 => 'Dies funktioniert nur, wenn die Funktion \'Letzte Anmeldung aufzeichnen\' in der Konfiguration aktiviert wurde.',
    56 => 'Bitte den Typ User whlen, der gelscht werden soll und "Liste aktualisieren" drcken. Dann die aus der Liste abhaken, die nicht gelscht werden sollen und "Delete" drcken. Es werden nur die gelscht, die gegenwrtig sichtbar sind. Dieser Hinweis fr den Fall, dass die Liste sich ber mehrere Seiten erstreckt.',
    57 => 'Phantom-User',
    58 => 'Einmal-User',
    59 => 'Alte User',
    60 => 'User, angemeldet vor mehr als ',
    61 => ' Monaten, aber nie eingeloggt.',
    62 => 'User, angemeldet vor mehr als  ',
    63 => ' Monaten, dann nur einmalig innerhalb 24 h eingeloggt.',
    64 => 'Normale User, die einfach die Site seit ',
    65 => ' Monaten nicht mehr besucht haben.',
    66 => 'Liste aktualisieren',
    67 => 'Monate seit Anmeldung',
    68 => 'Online Stunden',
    69 => 'Offline Monate',
    70 => 'konnte nicht gelscht werden',
    71 => 'erfolgreich gelscht',
    72 => 'Kein User zum Lschen vorgemerkt',
    73 => 'Alle ausgewhlten User dauerhaft lschen?',
    74 => 'Aktuelle User',
    75 => 'User, angemeldet in den letzten ',
    76 => ' Monaten.',
    77 => 'Erinnerung zum Einloggen an die ausgewhlten User schicken',
    78 => 'Erinnerung schicken',
    79 => 'Keine User ausgewhlt fr Erinnerung',
    80 => 'Erinnerung erfolgreich verschickt',
    81 => 'Erinnerung, um den Account zu verifizieren fr %s',
    82 => "Dein Account auf der Seite {$_CONF['site_name']} wurde nicht benutzt seit %s und wird deaktiviert, wenn Du nicht innerhalb 30 Tagen einloggst.",
    83 => "Dein Account auf der Seite {$_CONF['site_name']} wurde seit der Einrichtung nicht benutzt und wird gelscht, wenn Du nicht in Krze einloggst.",
    84 => "Dein Einlogname ist: %s  auf der Site: {$_CONF['site_url']}",
    85 => 'Wenn Du das Passwort vergessen hast, benutze folgenden Link: %s',
    86 => 'Enthalten',
    87 => 'Erinnerungen',
    88 => 'Voreingestellte Gruppe',
    89 => 'Anklicken, um diese Gruppe zur voreingestellten Gruppe zu machen fr neue User',
    90 => '"Voreingestellte Gruppe" anwenden, um dies auch bei existierenden Usern zu ndern.',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Akzeptieren',
    2 => 'Lschen',
    3 => 'Editieren',
    4 => 'Profil',
    10 => 'Titel',
    11 => 'Startdatum',
    12 => 'URL',
    13 => 'Kategorie',
    14 => 'Datum',
    15 => 'Kategorie',
    16 => 'Username',
    17 => 'Name',
    18 => 'E-Mail',
    34 => 'Schaltzentrale',
    35 => 'Beitrge: Artikel',
    36 => 'Bezug oder Kommentar',
    37 => '',
    38 => 'Abschicken',
    39 => 'Derzeit gibt es keine Beitrge zu moderieren.',
    40 => 'Neue User',
    41 => 'Beitrge: Kommentare',
    42 => 'Username',
    43 => 'Moderation aufheben?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} Mail Utility",
    2 => 'Von (Name)',
    3 => 'Von (E-Mail)',
    4 => 'Betreff',
    5 => 'Nachricht',
    6 => 'Senden',
    7 => 'Alle User',
    8 => 'Admin',
    9 => 'Optionen',
    10 => 'HTML',
    11 => 'Wichtige Nachricht!',
    12 => 'Abschicken',
    13 => 'Reset',
    14 => 'User-Einstellungen ignorieren',
    15 => 'Fehler beim Senden an: ',
    16 => 'E-Mail erfolgreich gesendet an: ',
    17 => "<a href=\"{$_CONF['site_admin_url']}/mail.php\">Noch eine Nachricht schreiben</a>",
    18 => 'An',
    19 => 'HINWEIS: Wenn Du eine Nachricht an alle eingetragenen Benutzer schicken willst, musst Du die Gruppe Logged-in Users auswhlen.',
    20 => "<successcount> Nachricht(en) erfolgreich verschickt, bei <failcount> Nachricht(en) traten Fehler auf. Details knnen der folgenden Liste entnommen werden. Du kannst jetzt <a href=\"{$_CONF['site_admin_url']}/mail.php\">noch eine Nachricht schicken</a> oder <a href=\"{$_CONF['site_admin_url']}/moderation.php\">zurck zum Admin-Men gehen</a>.",
    21 => 'Fehler',
    22 => 'Erfolgreich',
    23 => 'Keine Fehler',
    24 => 'Keine erfolgreich',
    25 => '-- Gruppe whlen --',
    26 => 'Um eine E-Mail verschicken zu knnen, mssen alle Felder ausgefllt und eine Gruppe von Benutzern aus dem Drop-Down-Men ausgewhlt werden.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Installing plugins could possibly cause damage to your Geeklog installation and, possibly, to your system.  It is important that you only install plugins downloaded from the <a href="http://www.geeklog.net">Geeklog Homepage</a> as we thoroughly test all plugins submitted to our site on a variety of operating systems.  It is important that you understand that the plugin installation process will require the execution of a few filesystem commands which could lead to security problems particularly if you use plugins from third party sites.  Even with this warning you are getting, we do not gaurantee the success of any installation nor are we liable for damage caused by installing a Geeklog plugin.  In other words, install at your own risk.  For the wary, directions on how to manually install a plugin is included with each plugin package.',
    2 => 'Plugin-Installation -- Disclaimer',
    3 => 'Plugin-Installationsformular',
    4 => 'Plugin-Datei',
    5 => 'Plugin-Liste',
    6 => 'Warnung: Plugin schon installiert!',
    7 => 'Das Plugin, das Du installieren willst, ist schon vorhanden. Bitte lsche es, bevor Du noch einmal versuchst, es zu installieren',
    8 => 'Plugin-Kompatibilittstest fehlgeschlagen',
    9 => 'Dieses Plugin bentigt eine neuere Version von Geeklog. Abhilfe schafft ein Update von <a href="http://www.geeklog.net/">Geeklog</a>.',
    10 => '<br' . XHTML . '><b>Es sind derzeit keine Plugins installiert.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Um ein Plugin zu ndern oder zu lschen, auf das ndern-Symbol klicken. Es werden dann auch weitere Details, inkl. der Homepage des Plugins, angezeigt. Wenn in der Liste (s.u.) zwei Versionsnummern fr ein Plugin angezeigt werden, bedeutet das, dass fr das Plugin noch ein Update durchgefhrt werden muss. Um ein Plugin zu installieren oder aktualisieren bitte auch immer dessen Dokumentation lesen.',
    12 => '(kein Name angegeben)',
    13 => 'Plugin-Editor',
    14 => 'Neues Plugin',
    15 => 'Schaltzentrale',
    16 => 'Name des Plugins',
    17 => 'Plugin-Version',
    18 => 'Geeklog-Version',
    19 => 'Aktiv',
    20 => 'Ja',
    21 => 'Nein',
    22 => 'Installieren',
    23 => 'Speichern',
    24 => 'Abbruch',
    25 => 'Lschen',
    26 => 'Name des Plugins',
    27 => 'Plugin-Homepage',
    28 => 'Plugin-Version',
    29 => 'Geeklog-Version',
    30 => 'Plugin lschen?',
    31 => 'Soll das Plugin wirklich gelscht werden? Dies wird alle Daten und Datenstrukturen lschen, die dieses Plugin benutzt. Wenn ja, dann jetzt bitte noch einmal auf Lschen klicken.',
    32 => '<p><b>Fehler: Ungltiges Format fr Autolink.</b></p>',
    33 => 'Code-Version',
    34 => 'Aktualisieren',
    35 => 'ndern',
    36 => 'Code',
    37 => 'Aktuell',
    38 => 'Bitte aktualisieren!',
    39 => 'Ein Plugin hochladen',
    40 => 'Ein Plugin-Archiv (.tar.gz, .tgz, .zip) kann hier direkt hochgeladen werden:',
    41 => 'Hochladen',
    42 => 'Fr Update klicken',
    43 => 'Reihenfolge',
    44 => 'Plugin frher laden',
    45 => 'Plugin spter laden',
    46 => 'Plugin lschen',
    47 => 'Das %s-Plugin wirklich lschen?',
    48 => 'Plugin inaktiv. Zum Aktivieren klicken.',
    49 => 'Plugin aktiv. Zum Deaktivieren klicken.',
    50 => 'Abhngigkeiten',
    51 => 'OK',
    52 => 'Nicht gelst',
    53 => 'Deaktiviert',
    54 => 'Nicht verfgbar',
    55 => 'Deinstalliert',
    56 => 'Falsche Version',
    57 => 'Die Lade-Reihenfolge von einem oder mehrere Plugins wurde gendert, um Abhngigkeiten aufzulsen.',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Schlieen',
    61 => 'Status',
    62 => 'Plugin installieren',
    63 => 'Dieses Plugin kann nicht installiert werden',
    64 => 'Dieses Plugin kann nicht aktiviert werden',
    65 => 'Die Funktion zum Hochladen eine Plugins wurde deaktiviert. Grund:',
    66 => 'Hochladen von Dateien ist in Deiner PHP-Konfiguration deaktiviert.',
    67 => 'Das Verzeichnis "%s" ist nicht beschreibbar.',
    68 => 'Du hast nicht die ntigen Rechte, um Plugins installieren zu knnen.',
    69 => 'Du hast nicht die ntigen Rechte, um Plugins hochladen zu knnen.',
    99 => 'Ein unbekannter Fehler ist aufgetreten',
    100 => 'Ok.',
    101 => 'Die Datei zum Hochladen ist grer als die Einstellung upload_max_filesize auf dem Webspace erlaubt.',
    102 => 'Die Datei zum Hochladen ist grer als die Einstellung MAX_FILE_SIZE, die im HTML-Formular angegeben wurde.',
    103 => 'Die Datei wurde nur teilweise hochgeladen.',
    104 => 'Es ist keine Datei hochgeladen worden.',
    105 => '(undefinierter Fehler)',
    106 => 'Es fehlt ein temporres Unterverzeichnis.',
    107 => 'Datei konnte nicht geschrieben werden.',
    108 => 'Hochladen wurde wegen der Dateiendung gestoppt.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'Newsfeed anlegen',
    2 => 'Speichern',
    3 => 'Lschen',
    4 => 'Abbruch',
    10 => 'Newsfeed',
    11 => 'Neuer Newsfeed',
    12 => 'Schaltzentrale',
    13 => 'Um einen Newsfeed zu ndern oder zu lschen, auf das ndern-Symbol (s.u.) klicken. Um einen neuen Newsfeed anzulegen, auf Neu anlegen (s.o.) klicken.',
    14 => 'Titel',
    15 => 'Art',
    16 => 'Dateiname',
    17 => 'Format',
    18 => 'letztes Update',
    19 => 'Aktiv',
    20 => 'Ja',
    21 => 'Nein',
    22 => '<i>(keine Newsfeeds)</i>',
    23 => 'Alle Artikel',
    24 => 'Newsfeed-Editor',
    25 => 'Newsfeed-Titel',
    26 => 'Limit',
    27 => 'Lnge d. Eintrge',
    28 => '(0 = ohne Text, 1 = kompletter Text, anderer Wert = nur so viele Zeichen)',
    29 => 'Beschreibung',
    30 => 'Letztes Update',
    31 => 'Zeichensatz',
    32 => 'Sprache',
    33 => 'Inhalt',
    34 => 'Eintrge',
    35 => 'Stunden',
    36 => 'Art des Newsfeeds festlegen',
    37 => '',
    38 => 'Fehler: Nicht alle Felder ausgefllt',
    39 => 'Bitte die Felder Newsfeeds-Titel, Beschreibung und Dateiname ausfllen.',
    40 => 'Bitte ein Limit (Anzahl Eintrge oder Anzahl Stunden) eingeben.',
    41 => 'Links',
    42 => '',
    43 => 'Alle',
    44 => 'Keine',
    45 => 'Newsfeed-Link fr Kategorie',
    46 => 'Limit Results',
    47 => 'Suchen',
    48 => 'ndern',
    49 => 'Newsfeed-Logo',
    50 => "Relativ zur URL dieser Site ({$_CONF['site_url']})",
    51 => 'Der gewhlte Dateiname wird bereits von einem anderen Newsfeed verwendet. Bitte einen anderen Namen whlen.',
    52 => 'Fehler: Dateiname existiert schon',
    53 => 'Alle auf der Startseite',
    54 => 'Bitte die Art des Newsfeeds auswhlen.',
    55 => 'Artikel'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Dein Passwort sollte in Krze per E-Mail bei Dir eintreffen. Bitte beachte die Hinweise in der E-Mail. Danke, dass Du Dich bei {$_CONF['site_name']} angemeldet hast.",
    2 => "Danke fr Deinen Beitrag zu {$_CONF['site_name']}. Der Artikel wurde an unser Team weitergeleitet. Wenn er akzeptiert wird, wird er bald auf dieser Website fr alle Besucher zu lesen sein.",
    3 => '',
    4 => '',
    5 => 'Userprofil wurde gespeichert.',
    6 => 'Einstellungen wurden gespeichert.',
    7 => 'Kommentar-Einstellungen wurden gespeichert.',
    8 => 'Abmeldung erfolgt. Du bist jetzt nicht mehr angemeldet.',
    9 => 'Artikel wurde gespeichert.',
    10 => 'Artikel wurde gelscht.',
    11 => 'Block wurde gespeichert.',
    12 => 'Der Block wurde gelscht.',
    13 => 'Kategorie wurde gespeichert.',
    14 => 'Die Kategorie und alle zugehrigen Artikel wurden gelscht.',
    15 => 'Der Kommentar wurde gespeichert, muss aber noch von einem Moderator freigegeben werden.',
    16 => 'Abonnement wurde gelscht. Du wirst nicht lnger ber Antworten benachrichtigt.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Der User wurde gespeichert.',
    22 => 'Der User wurde gelscht.',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Nachricht wurde verschickt.',
    28 => 'Das Plugin wurde gespeichert.',
    29 => 'Du hast keinen Zugriff auf diese Administrationsseite. Alle Versuche, auf Bereiche ohne entsprechende Berechtigung zuzugreifen, werden protokolliert.',
    30 => 'Zugriff verweigert',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'System-Nachricht',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Das Plugin wurde erfolgreich installiert.',
    45 => 'Das Plugin wurde gelscht.',
    46 => '',
    47 => '',
    48 => "Danke, dass Du dich bei {$_CONF['site_name']} angemeldet hast. Dein Aufnahmeantrag wird von unserem Team geprft. Sobald er akzeptiert wird, wirst Du Dein Passwort per E-Mail erhalten.",
    49 => 'Die Gruppe wurde gespeichert.',
    50 => 'Die Gruppe wurde gelscht.',
    51 => 'Dieser Username ist schon vergeben. Bitte whle einen anderen.',
    52 => 'Die angegebene E-Mail-Adresse scheint nicht gltig zu sein.',
    53 => 'Dein neues Passwort wurde gespeichert. Bitte melde Dich nun mit dem neuen Passwort an.',
    54 => 'Diese Anfrage fr ein neues Passwort ist nicht mehr gltig. Bitte fordere erneut ein neues Passwort an.',
    55 => 'Du solltest in Krze eine E-Mail erhalten, in der beschrieben wird, wie Du ein neues Passwort fr Deinen Account eingeben kannst.',
    56 => 'Die angegebene E-Mail-Adresse wird schon fr einen anderen Account verwendet.',
    57 => 'Dein Account wurde gelscht.',
    58 => 'Der Newsfeed wurde gespeichert.',
    59 => 'Der Newsfeed wurde gelscht.',
    60 => 'Das Plugin wurde erfolgreich aktualisiert.',
    61 => 'Plugin %s: Unbekannter Text-Platzhalter',
    62 => 'Der Trackback-Kommentar wurde gelscht.',
    63 => 'Beim Lschen des Trackback-Kommentars trat ein Fehler auf.',
    64 => 'Trackback-Kommentar wurde erfolgreich verschickt.',
    65 => 'Das Weblog-Verzeichnis wurde gespeichert.',
    66 => 'Das Weblog-Verzeichnis wurde gelscht.',
    67 => 'Das neue Passwort stimmt nicht mit dem Besttigungs-Passwort berein!',
    68 => 'Gib bitte Dein korrektes aktuelles Passwort ein.',
    69 => 'Dein Account wurde gesperrt!',
    70 => 'Dein Account wurde noch nicht freigeschaltet.',
    71 => 'Dein Account wurde besttigt, muss aber noch freigeschaltet werden.',
    72 => 'Bei der Installation des Plugins trat ein Fehler auf. Siehe error.log fr weitere Informationen.',
    73 => 'Bei der Deinstallation des Plugins trat ein Fehler aus. Siehe error.log fr weitere Informationen.',
    74 => 'Der Pingback wurde erfolgreich verschickt.',
    75 => 'Trackbacks mssen als POST-Request verschickt werden.',
    76 => 'Willst Du diesen Eintrag wirklich lschen?',
    77 => 'HINWEIS:<br' . XHTML . '>Du hast UTF-8 als Standard-Zeichensatz angegeben. Dein Webserver untersttzt jedoch kein "multibyte encoding". Installiere bitte die mbstring-Erweiterungen fr PHP oder benutze einen anderen Zeichensatz bzw. eine andere Sprache.',
    78 => 'Bitte sicherstellen, dass die angegebene E-Mail-Adresse in beiden Fllen die gleiche ist.',
    79 => 'Diese Funktion ist nicht mehr unter dieser URL verfgbar.',
    80 => 'Das Plugin, das diesen Newsfeed angelegt hat, ist derzeit nicht aktiviert. Dieser Newsfeed kann nicht bearbeitet werden, solange das Plugin deaktiviert ist.',
    81 => 'Hast Du Dich vertippt? Bitte versuche es noch einmal, Dich hier anzumelden.',
    82 => 'Du hast die erlaubte Anzahl von Anmeldeversuchen berschritten. Bitte versuche es spter noch einmal.',
    83 => 'Um das Passwort, die E-Mail-Adresse oder die "Angemeldet fr"-Zeit zu ndern msst Du das aktuelle Passwort eingeben.',
    84 => 'Um den Account zu lschen, bitte aktuelles Passwort eingeben.',
    85 => 'Es gab ein Problem, die E-Mail zu senden.',
    86 => 'Der OpenID-Server erklrte Deinen Einlogversuch fr ungltig.',
    87 => 'OpenID-Login wurde vom User abgebrochen.',
    88 => 'Der OpenID-Server gab einen Fehler zurck.',
    89 => 'Kann OpenID-Server zu der angegebenen Identity-URL nicht finden.',
    90 => 'OpenID-Identifizierung abgebrochen.',
    91 => 'You specified an invalid identity URL.',
    92 => "Bitte <a href=\"{$_CONF['site_admin_url']}/sectest.php\">die Sicherheit Deiner Site berprfen</a> bevor Du sie benutzt!",
    93 => 'Database back up war erfolgreich.',
    94 => 'Backup Failed: Dateigre unter 1kb',
    95 => 'Es gab einen Fehler.',
    96 => '',
    97 => '',
    98 => 'Das Plugin wurde erfolgreich hochgeladen.',
    99 => 'Das Plugin existiert schon.',
    100 => 'Die hochgeladene Plugindatei ist kein GZip oder Zip-Archiv.',
    101 => 'Es gibt keine Kategorien (auf die Du Zugriff hast). Es bedarf mindestens einer Kategorie, um Beitrge zu schreiben.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    400 => 'Nicht alle erforderlichen Felder konnten besttigt werden',
    401 => 'Bitte den echten Namen eingeben'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Zugriff',
    'ownerroot' => 'Eigentmer/Root',
    'group' => 'Gruppe',
    'readonly' => 'Nur Lesen',
    'accessrights' => 'Zugriffsrechte',
    'owner' => 'Eigentmer',
    'grantgrouplabel' => 'Obige Gruppenrechte zum Editieren gewhren',
    'permmsg' => 'Hinweis: Mitglieder bedeutet alle eingeloggten Mitglieder und Gast steht fr alle nicht eingeloggten Besucher.',
    'securitygroups' => 'Security-Gruppen',
    'editrootmsg' => "Obwohl Du ein User-Administrator bist, kannst Du die Informationen von Usern in der Root-Gruppe nicht ndern, ohne selbst Mitglied der Root-Gruppe zu sein. Du kannst die Informationen aller anderen User bearbeiten, nur nicht die der Mitglieder der Root-Gruppe. Beachte bitte, dass alle derartigen Versuche protokolliert werden. <a href=\"{$_CONF['site_admin_url']}/user.php\">Zurck zur User-Admin-Seite</a>.",
    'securitygroupsmsg' => 'Mit den Anklickkstchen kann man festlegen, zu welchen Gruppen dieser User gehrt.',
    'groupeditor' => 'Gruppen-Editor',
    'description' => 'Beschreibung',
    'name' => 'Name',
    'rights' => 'Rechte',
    'missingfields' => 'Fehlende Angaben',
    'missingfieldsmsg' => ' Bite einen Namen und eine Beschreibung fr die Gruppe angeben.',
    'groupmanager' => 'Gruppen-Manager',
    'newgroupmsg' => 'Um eine Gruppe zu ndern oder zu lschen, auf das ndern-Symbol klicken. Neu anlegen (s.o.) legt eine neue Gruppe an. Hinweis: Core-Gruppen knnen nicht gelscht werden, da sie vom System bentigt werden.',
    'groupname' => 'Gruppen-Name',
    'coregroup' => 'Core-Gruppe',
    'yes' => 'Ja',
    'no' => 'Nein',
    'corerightsdescr' => "Diese Gruppe ist eine Core-Gruppe auf {$_CONF['site_name']}. Die Rechte dieser Gruppe knnen daher nicht gendert werden. Das Folgende ist eine (nicht vernderbare) Liste der Rechte dieser Gruppe.",
    'groupmsg' => 'Security-Gruppen auf dieser Site sind hierarchisch organisiert. Wenn Du diese Gruppe zu einer der folgenden Gruppen hinzufgst, bekommt diese Gruppe die gleichen Rechte wie die unten ausgewhlte(n). Wenn mglich, sollten Gruppenrechte durch Auswahl von Gruppen aus dieser Liste vergeben werden. Werden nur einzelne Rechte bentigt, knnen diese auch aus der Liste der Rechte weiter unten ausgewhlt werden. Um diese Gruppe zu einer der folgenden hinzuzufgen, kannst Du die gewnschte(n) Gruppe(n) einfach anklicken.',
    'coregroupmsg' => "Diese Gruppe ist eine Core-Gruppe auf {$_CONF['site_name']}. Die Rechte dieser Gruppe knnen daher nicht gendert werden. Das Folgende ist eine (nicht vernderbare) Liste der Gruppen, zu der diese Gruppe gehrt.",
    'rightsdescr' => 'Die folgenden Rechte knnen an eine Gruppe entweder direkt (durch Auswhlen) oder indirekt vergeben werden (wenn die Gruppe zu einer anderen Gruppe gehrt, die diese Rechte hat). Die im Folgenden aufgefhrten Rechte ohne Checkbox sind indirekte Rechte, die von einer anderen Gruppe geerbt wurden, zu der die aktuelle Gruppe gehrt. Alle anderen Rechte knnen hier direkt vergeben werden.',
    'lock' => 'Lock',
    'members' => 'Mitglieder',
    'anonymous' => 'Gast',
    'permissions' => 'Rechte',
    'permissionskey' => 'R = lesen, E = editieren, Editier-Rechte setzen Lese-Rechte voraus',
    'edit' => 'Edit',
    'none' => 'None',
    'accessdenied' => 'Zugriff verweigert',
    'storydenialmsg' => "Du hast nicht die ntigen Rechte, um diesen Artikel zu lesen. Mglicherweise bist Du kein registrierter User von {$_CONF['site_name']}. Bitte melde Dich als <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">neuer User</a> von {$_CONF['site_name']} an um vollen Zugriff auf alle Bereiche zu bekommen.",
    'nogroupsforcoregroup' => 'Diese Gruppe gehrt zu keiner anderen Gruppe.',
    'grouphasnorights' => 'Diese Gruppe hat keine Rechte fr die Administration der Website.',
    'newgroup' => 'Neue Gruppe',
    'adminhome' => 'Schaltzentrale',
    'save' => 'Speichern',
    'cancel' => 'Abbruch',
    'delete' => 'Lschen',
    'canteditroot' => 'Du hast versucht die Gruppe Root zu ndern, obwohl Du selbst nicht Mitglied dieser Gruppe bist. Der Zugriff wurde daher verweigert. Wende Dich bitte an den Systemadministrator wenn Du der Meinung bist, dass das ein Fehler wre.',
    'listusers' => 'Mitglieder',
    'listthem' => 'anzeigen',
    'usersingroup' => 'Mitglieder der Gruppe "%s"',
    'usergroupadmin' => 'Usergruppen-Verwaltung',
    'add' => 'Hinzufgen',
    'remove' => 'Lschen',
    'availmembers' => 'Verfgbare Mitglieder',
    'groupmembers' => 'Mitglieder der Gruppe',
    'canteditgroup' => 'Um diese Gruppe bearbeiten zu knnen, musst Du selbst ein Mitglied der Gruppe sein. Wende Dich bitte an den Systemadministrator wenn Du der Meinung bist, dass das ein Fehler wre.',
    'cantlistgroup' => 'Um die Mitglieder dieser Gruppe sehen zu knnen, musst Du selbst ein Mitglied der Gruppe sein. Wende Dich bitte an den Systemadministrator wenn Du der Meinung bist, dass das ein Fehler wre.',
    'editgroupmsg' => 'Um die Gruppenmitgliedschaft eines Users zu ndern, den Usernamen anklicken und entsprechend Hinzufgen oder Lschen anklicken. Nur User in der rechten Liste sind Mitglieder der Gruppe. Um die nderungen zu bernehmen und zur Gruppenliste zurckzukehren, den Button <b>Speichern</b> klicken.',
    'listgroupmsg' => 'Liste aller Mitglieder der Gruppe "<b>%s</b>"',
    'search' => 'Suchen',
    'submit' => 'Abschicken',
    'limitresults' => 'Ergebnisse einschrnken',
    'group_id' => 'Gruppen-ID',
    'plugin_access_denied_msg' => 'Du versuchst ohne Berechtigung auf die Plugin-Verwaltungsseite zuzugreifen.  Bitte beachte, dass alle Versuche, ohne Berechtigung auf diese Seite zuzugreifen, aufgezeichnet werden.',
    'groupexists' => 'Gruppenname existiert schon',
    'groupexistsmsg' => 'Es existiert bereits eine Gruppe mit diesem Namen. Gruppennamen mssen eindeutig sein.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'Datenbank-Backups',
    'do_backup' => 'Backup anlegen',
    'backup_successful' => 'Backup der Datenbank war erfolgreich.',
    'db_explanation' => 'Um ein neues Backup der Datenbank anzulegen, bitte auf Neu anlegen (s.o.) klicken. Ein Klick auf einen Dateinamen ldt das Backup herunter.',
    'not_found' => "Falscher Pfad oder sicherheitsbedingte Einschrnkung oder mysqldump ist nicht ausfhrbar.<br" . XHTML . ">Bitte berprfe die Einstellung <strong>mysqldump_path</strong> in der Konfiguration und ggfs. die <a href=\"http://www.php.net/manual/en/features.safe-mode.php#ini.open-basedir\">open_basedir</a>-Einstellung in PHP.<br" . XHTML . ">Aktuelle Einstellung: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Backup fehlgeschlagen: Datei ist 0 Bytes gro.',
    'path_not_found' => "{$_CONF['backup_path']} existiert nicht oder ist kein Verzeichnis.",
    'no_access' => "Fehler: Konnte nicht auf das Verzeichnis {$_CONF['backup_path']} zugreifen.",
    'backup_file' => 'Backup-Datei',
    'size' => 'Gre',
    'bytes' => 'Bytes',
    'total_number' => 'Gesamtanzahl Backups: %d',
    'download' => 'Anklicken, um diese Datei runterzuladen',
    'new_backup' => 'Neues Backup',
    'delete_failure' => 'Eins oder mehrere Backups konnten nicht gelscht werden.',
    'delete_success' => 'Backupdateien erfolgreich gelscht.',
    'convert_menu' => 'Nach InnoDB konvertieren',
    'convert_title' => 'In InnoDB-Tabellen konvertieren',
    'convert_button' => 'Konvertieren',
    'sorry_no_innodb' => 'Sorry, die MySQL-Version auf dem Server untersttzt kein InnoDB.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Hinweis: Die Konvertierung kann etwas Zeit in Anspruch nehmen. Bitte etwas Geduld mitbringen.',
    'innodb_success' => 'Tabellen wurden erfolgreich konvertiert.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Tabellen optimieren',
    'optimize_title' => 'Tabellen Optimieren',
    'optimize_button' => 'Optimieren',
    'optimize_explain' => 'Das Optimieren der Tabellen mag helfen, die Geschwindigkeit des Auftritts zu verbessern. Die tatschliche Verbesserung hngt ab von der Tabellenverwendung und einige mgen mehr davon profitieren als andere. Bitte keinen riesigen Unterschied in der Geschwindigkeit erwarten. Das <a href="http://dev.mysql.com/doc/mysql/de/optimize-table.html">MySQL-Handbuch</a> gibt an: <q>die Wahrscheinlichkeit, dass Sie dies hufiger als einmal in der Woche oder im Monat tun mssen, ist sehr gering</q>.',
    'last_optimization' => 'Letzte Optimierung',
    'optimization_patience' => 'Hinweis: Die Optimierung kann etwas Zeit in Anspruch nehmen. Bitte etwas Geduld mitbringen.',
    'optimize_success' => 'Tabellen wurden erfolgreich optimiert.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Home',
    2 => 'Kontakt',
    3 => 'Beitrag',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Statistik',
    8 => 'Einstellungen',
    9 => 'Suchen',
    10 => 'Erweiterte Suche',
    11 => 'Verzeichnis'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Fehler 404',
    2 => 'Hmm, ich habe alles versucht, aber <b>%s</b> war nicht aufzufinden.',
    3 => "<p>Sorry, diese Seite oder Datei existiert nicht. Du knntest es auf der <a href=\"{$_CONF['site_url']}\">Startseite</a> oder mit der <a href=\"{$_CONF['site_url']}/search.php\">Suchfunktion</a> probieren, vielleicht wirst Du ja fndig ..."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Anmeldung erforderlich',
    2 => 'Sorry, aber um auf diesen Bereich zugreifen zu knnen, muss man als Benutzer registriert sein.',
    3 => 'Anmelden',
    4 => 'Neuer User'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'von',
    'tracked_on' => 'Empfangen am',
    'read_more' => '[mehr]',
    'intro_text' => 'Andere haben folgendes ber \'%s\' geschrieben:',
    'no_comments' => 'Keine Trackback-Kommentare fr diesen Eintrag.',
    'this_trackback_url' => 'Trackback-URL fr diesen Eintrag:',
    'num_comments' => '%d Trackback-Kommentare',
    'send_trackback' => 'Pings senden',
    'preview' => 'Vorschau',
    'editor_title' => 'Trackback-Kommentar senden',
    'trackback_url' => 'Trackback-URL',
    'entry_url' => 'URL des Eintrags',
    'entry_title' => 'Titel des Eintrags',
    'blog_name' => 'Site-Name',
    'excerpt' => 'Auszug',
    'truncate_warning' => 'Hinweis: Die empfangende Site knnte den Auszug krzen.',
    'button_send' => 'Abschicken',
    'button_preview' => 'Vorschau',
    'send_error' => 'Fehler',
    'send_error_details' => 'Fehler beim Senden des Trackback-Kommentars:',
    'url_missing' => 'Keine URL fr den Eintrag',
    'url_required' => 'Es muss mindestens die URL fr den Eintrag angegeben werden.',
    'target_missing' => 'Keine Trackback-URL',
    'target_required' => 'Bitte die Trackback-URL eingeben.',
    'error_socket' => 'Socket konnte nicht geffnet werden.',
    'error_response' => 'Antwort nicht verstanden.',
    'error_unspecified' => 'Fehler nicht nher spezifiziert.',
    'select_url' => 'Trackback-URL auswhlen',
    'not_found' => 'Trackback-URL nicht gefunden',
    'autodetect_failed' => 'Geeklog konnte keine Trackback-URL fr den Beitrag finden, zu dem der Kommentar gesendet werden sollte. Bitte gib die Trackback-URL von Hand ein.',
    'trackback_explain' => 'Aus den unten aufgefhrten Links kannst Du jetzt den Beitrag auswhlen, zu dem Dein Kommentar gesendet werden soll. Geeklog wird versuchen, die Trackback-URL selbst zu ermitteln. Andernfalls kannst Du die Trackback-URL aber auch <a href="%s">von Hand eingeben</a>.',
    'no_links_trackback' => 'Keine Links gefunden. Fr diesen Beitrag knnen keine Trackback-Kommentare gesendet werden.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback-Ergebnisse',
    'send_pings' => 'Pings senden',
    'send_pings_for' => 'Pings fr "%s" senden',
    'no_links_pingback' => 'Keine Links gefunden. Es wurden keine Pingbacks fr diesen Beitrag gesendet.',
    'pingback_success' => 'Pingback gesendet.',
    'no_pingback_url' => 'Keine Pingback-URL gefunden.',
    'resend' => 'Nochmal senden',
    'ping_all_explain' => 'Du kannst jetzt einen <a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a> zu den verlinkten Sites senden, einen Ping an Weblog-Verzeichnisse senden, oder einen <a href="http://de.wikipedia.org/wiki/Trackback">Trackback</a>-Kommentar verschicken, wenn Du ber einen Beitrag in einem anderen Weblog geschrieben hast.',
    'pingback_button' => 'Pingback senden',
    'pingback_short' => 'Einen Pingback an alle in diesem Beitrag verlinkten Sites senden.',
    'pingback_disabled' => '(Pingback deaktiviert)',
    'ping_button' => 'Ping senden',
    'ping_short' => 'Weblog-Verzeichnisse "anpingen".',
    'ping_disabled' => '(Ping deaktiviert)',
    'trackback_button' => 'Trackback senden',
    'trackback_short' => 'Einen Trackback-Kommentar senden.',
    'trackback_disabled' => '(Trackback deaktiviert)',
    'may_take_a_while' => 'Hinweis: Das Senden von Pingbacks und Pings kann eine Weile dauern.',
    'ping_results' => 'Ping-Ergebnisse',
    'unknown_method' => 'Unbekannte Ping-Methode',
    'ping_success' => 'Ping gesendet.',
    'error_site_name' => 'Bitte gib den Namen der Site ein.',
    'error_site_url' => 'Bitte gib die URL der Site ein.',
    'error_ping_url' => 'Bitte gib die Ping-URL der Site ein.',
    'no_services' => 'Es sind keine Weblog-Verzeichnisse konfiguriert.',
    'services_headline' => 'Weblog-Verzeichnisse',
    'service_explain' => 'Um ein Weblog-Verzeichnis zu ndern oder zu lschen, auf das ndern-Icon klicken. Um ein neues Weblog-Verzeichnis einzutragen, auf Neu anlegen (s.o.) klicken.',
    'service' => 'Verzeichnis',
    'ping_method' => 'Ping-Methode',
    'service_website' => 'Website',
    'service_ping_url' => 'Ping-URL',
    'ping_standard' => 'Normaler Ping',
    'ping_extended' => 'Erweiterter Ping',
    'ping_unknown' => '(unbekannte Methode)',
    'edit_service' => 'Weblog-Verzeichnis bearbeiten',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Hier kannst Du Deinen Trackback-Kommentar fr <a href="%s">%s</a> eingeben.',
    'editor_intro_none' => 'Trackback-Kommentar eingeben.',
    'trackback_note' => 'Um einen Trackback-Kommentar fr einen Artikel zu verschicken, benutze bitte den "Ping"-Eintrag in der Liste der Artikel. Um einen Trackback unabhngig von einem Artikel zu verschicken, bitte <a href="%s">hier klicken</a>.',
    'pingback_explain' => 'Gib eine URL ein, an die der Pingback geschickt werden soll. Der Pingback wird auf die Startseite Deiner Website verweisen.',
    'pingback_url' => 'Pingback-URL',
    'site_url' => 'Die URL dieser Website',
    'pingback_note' => 'Um einen Pingback fr einen Artikel zu verschicken, benutze bitte den "Ping"-Eintrag in der Liste der Artikel. Um einen Pingback unabhngig von einem Artikel zu verschicken, bitte <a href="%s">hier klicken</a>.',
    'pbtarget_missing' => 'Keine Pingback-URL',
    'pbtarget_required' => 'Gib bitte die Pingback-URL ein',
    'pb_error_details' => 'Fehler beim Senden des Pingbacks:',
    'delete_trackback' => 'Trackback direkt lschen: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Artikelverzeichnis',
    'title_year' => 'Artikelverzeichnis fr %d',
    'title_month_year' => 'Artikelverzeichnis fr %s %d',
    'nav_top' => 'Zurck zum Artikelverzeichnis',
    'no_articles' => 'Keine Artikel.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Sicherheits-Check',
    'results' => 'Ergebnis des Sicherheits-Checks',
    'okay' => 'Es scheint alles in Ordnung zu sein.',
    'please_fix' => 'Bitte die o.g. Fehler beheben, um den Webauftritt endgltig zu nutzen!',
    'please_note' => 'Kein Internetauftritt ist 100% sicher. Der Test kann nur bekannte, offensichtliche Probleme untersuchen.',
    'stay_informed' => 'Um ber Geeklog-Updates und Sicherheitsprobleme informiert zu bleiben, sollte man die  (low-traffic) %s Mailingliste abonnieren und ggf. mit der %s -Option im Adminmen nach verfgbaren Updates schauen.',
    'public_html' => '"public_html" sollte nie Teil der URL der Website sein. Bitte den Teil der %s noch einmal lesen und die Installation entsprechend ndern.',
    'installation' => 'Installationsanleitung',
    'directory' => 'Verzeichnis',
    'failed_tmp' => 'Konnte temporre Datei nicht im %s -Verzeichnis erstellen. Bitte die Rechte berprfen!',
    'fix_it' => 'Dies ist ein Sicherheitsrisiko und sollte behoben werden!',
    'reachable' => 'Auf das %s kann ber das Internet zugegriffen werden.',
    'not_reachable' => 'Prima! Auf das %s kann ber das Internet nicht zugegriffen werden.',
    'not_sure' => 'Es kommt ein HTTP-Ergebniscode %s beim Versuch, das %s zu testen. Es ist nicht klar, was das bedeutet ...',
    'remove_inst' => 'Das Installations-Verzeichnis %s sollte entfernt werden, sobald der Webauftritt fehlerfrei luft.',
    'remove_inst2' => 'Es beizubehalten wrde Angreifern die Mglichkeit geben, den Webauftritt zu zerstren, den Auftritt zu kapern oder wichtige Informationen zu erlangen.',
    'inst_removed' => 'Prima! Das Installations-Verzeichnis ist schon entfernt worden.',
    'fix_password' => 'Das <strong>Standardkennwort</strong> "password" des %s Root-Admin-Accounts wurde noch nicht gendert.',
    'password_okay' => 'Prima! Das Standardkennwort ist schon ausgetauscht worden.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n neue %i fr die letzten %t %s',
    'new_last' => 'letzte %t %s',
    'minutes' => 'Minuten',
    'hours' => 'Stunden',
    'days' => 'Tage',
    'weeks' => 'Wochen',
    'months' => 'Monate',
    'years' => 'Jahre',
    'minute' => 'Minute',
    'hour' => 'Stunde',
    'day' => 'Tag',
    'week' => 'Woche',
    'month' => 'Monat',
    'year' => 'Jahr'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Januar',
    2 => 'Februar',
    3 => 'Mrz',
    4 => 'April',
    5 => 'Mai',
    6 => 'Juni',
    7 => 'Juli',
    8 => 'August',
    9 => 'September',
    10 => 'Oktober',
    11 => 'November',
    12 => 'Dezember'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Sonntag',
    2 => 'Montag',
    3 => 'Dienstag',
    4 => 'Mittwoch',
    5 => 'Donnerstag',
    6 => 'Freitag',
    7 => 'Samstag'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Suchen',
    'limit_results' => 'Anzahl Ergebnisse',
    'submit' => 'Abschicken',
    'edit' => 'ndern',
    'edit_adv' => 'Erw. Editor',
    'admin_home' => 'Schaltzentrale',
    'create_new' => 'Neu anlegen',
    'create_new_adv' => 'Neu anlegen (Erw.)',
    'enabled' => 'Funktion aktivieren',
    'disabled' => 'Disabled',
    'title' => 'Titel',
    'page_title' => 'Seitentitel',
    'type' => 'Typ',
    'topic' => 'Kategorie',
    'info' => 'Info',
    'help_url' => 'URL f. Hilfe-Datei',
    'save' => 'Speichern',
    'cancel' => 'Abbruch',
    'install' => 'Install',
    'delete' => 'Lschen',
    'deleteitem' => 'Delete',
    'delete_sel' => 'Ausgewhlte lschen',
    'copy' => 'Kopieren',
    'no_results' => '- Keine Eintrge gefunden -',
    'data_error' => 'Es gab einen Fehler bei der Verarbeitung der Subscription-Daten. Bitte die Datenquelle berprfen.',
    'preview' => 'Vorschau',
    'records_found' => 'Eintrge',
    'addchild' => 'Add child',
    'list' => 'auflisten',
    'list_all' => 'Alle auflisten',
    'meta_description' => 'Metatag Description',
    'meta_keywords' => 'Metatag Keywords',
    'na' => 'n/v',
    'unavailable' => 'n/v',
    'warning' => '!!!',
    'token_expiry' => 'Achtung, zeitgesteuerte Sicherheitsfunktion (Security-Token). Nach %s lsst sich diese Seite nicht mehr speichern. nderungen gehen verloren.',
    'token_expired' => 'Das Security-Token fr diese Vernderung ist ausgelaufen. Bitte neu authentifizieren, um weiterzumachen.',
    'reauth_msg' => 'Das Security-Token fr diese Vernderung ist ausgelaufen. Wenn Du weitermachen willst, dann bitte unten neu authentifizieren. Damit wird sichergestellt, dass die gerade gemachten nderungen nicht verloren gehen.',
    'authenticate' => 'Authentifizieren'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Kommentare erlaubt',
    -1 => 'Keine Kommentare',
    1 => 'Kommentare geschlossen'
);

$LANG_commentmodes = array(
    'flat' => 'Flach',
    'nested' => 'Verschachtelt',
    'threaded' => 'Nach Thema',
    'nocomment' => 'Keine Kommentare'
);

$LANG_cookiecodes = array(
    0 => '(gar nicht)',
    3600 => '1 Stunde',
    7200 => '2 Stunden',
    10800 => '3 Stunden',
    28800 => '8 Stunden',
    86400 => '1 Tag',
    604800 => '1 Woche',
    2678400 => '1 Monat'
);

$LANG_dateformats = array(
    0 => 'Grundeinstellung'
);

$LANG_featurecodes = array(
    0 => 'Normaler Artikel',
    1 => 'Hauptartikel'
);

$LANG_frontpagecodes = array(
    0 => 'Nur unter der Kategorie',
    1 => 'Auch auf der Startseite'
);

$LANG_postmodes = array(
    'plaintext' => 'als Text',
    'html' => 'in HTML'
);

$LANG_sortcodes = array(
    'ASC' => 'lteste zuerst',
    'DESC' => 'Neueste zuerst'
);

$LANG_trackbackcodes = array(
    0 => 'Trackbacks erlaubt',
    -1 => 'Keine Trackbacks'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Verwaltung der Site',
    'sections' => 'Bereich Konfiguration',
    'restore' => 'Zurcksetzen',
    'add_element' => 'Element hinzufgen',
    'save_changes' => 'nderungen speichern',
    'reset_form' => 'Angaben zurcksetzen',
    'changes_made' => 'nderungen wurden erfolgreich bernommen',
    'title' => 'Konfigurations-Manager',
    'disable' => 'Funktion deaktivieren',
    'enable' => 'Funktion aktivieren',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Konfiguration durchsuchen',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Konfiguration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'Pfad Webroot',
    'site_url' => 'URL der Site',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'mail_cc_enabled' => 'Allow to Send Carbon Copies',
    'mail_cc_default' => '"Carbon Copy" on by Default',
    'site_name' => 'Name des Webauftritts',
    'site_slogan' => 'Slogan im Kopf',
    'owner_name' => 'Owner Name',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Pfad zum Log',
    'path_language' => 'Pfad zu Sprachdateien',
    'backup_path' => 'Pfad zum Backup',
    'path_data' => 'Pfad zu Data',
    'path_images' => 'Pfad zu Images',
    'path_pear' => 'Pfad zu Pear',
    'have_pear' => 'Pear auf dem Server vorhanden?',
    'mail_settings' => 'Einstellungen ',
    'allow_mysqldump' => 'MySQL-Dump erlauben',
    'mysqldump_path' => 'Pfad zu Executable',
    'mysqldump_options' => 'Optionen MySQL-Dump',
    'mysqldump_filename_mask' => 'Backupdateibezeichnung',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Elemente des Mens ',
    'path_themes' => 'Pfad zu Themes',
    'disable_new_user_registration' => 'Registrieren neuer User abschalten',
    'allow_user_themes' => 'User knnen Theme whlen',
    'allow_user_language' => 'User knnen Sprache whlen',
    'allow_user_photo' => 'User knnen Foto hochladen',
    'allow_username_change' => 'User knnen Username ndern',
    'allow_account_delete' => 'User knnen Account lschen',
    'hide_author_exclusion' => 'Beim Artikel steht kein Autor',
    'show_fullname' => 'Fullname wird angezeigt',
    'show_servicename' => 'Name des Service wird angezeigt',
    'custom_registration' => '"Custom Registration" aktivieren',
    'user_login_method' => 'User-Anmeldemethode ',
    'facebook_login' => 'Facebook OAuth-Anmeldemethode aktivieren',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'LinkedIn OAuth-Anmeldemethode aktivieren',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Twitter OAuth-Anmeldemethode aktivieren',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Admin Links sortieren',
    'language' => 'Sprache',
    'locale' => 'Locale',
    'date' => 'Datumsformat',
    'daytime' => 'Format Tag und Zeit',
    'shortdate' => 'Format kurzes Datum',
    'dateonly' => 'Format nur Datum',
    'timeonly' => 'Format nur Zeit',
    'week_start' => 'Wochenanfang',
    'hour_mode' => '12 oder 24h-Modus',
    'thousand_separator' => 'Tausender-Trennzeichen',
    'decimal_separator' => 'Dezimal-Trennzeichen',
    'decimal_count' => 'Stellen hinter dem Komma',
    'language_files' => 'Sprachdateien',
    'languages' => 'Sprachen',
    'timezone' => 'Zeitzone',
    'site_disabled_msg' => 'Anzeige bei Abschaltung von Geeklog oder URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Zeitzone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'IP in Cookies einbetten?',
    'default_perm_cookie_timeout' => 'Permanenter Timeout',
    'session_cookie_timeout' => 'Session-Timeout',
    'cookie_path' => 'Cookie-Pfad',
    'cookiedomain' => 'Cookie-Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Letzte Anmeldung aufzeichnen?',
    'num_search_results' => 'Anzahl Suchergebnisse',
    'loginrequired' => 'Anmelden generell ntig?',
    'submitloginrequired' => 'Anmelden fr Beitrge?',
    'commentsloginrequired' => 'Anmelden fr Kommentare?',
    'statsloginrequired' => 'Anmelden fr Statistik?',
    'searchloginrequired' => 'Anmelden fr Suche?',
    'profileloginrequired' => 'Anmelden fr Profileinsicht?',
    'emailuserloginrequired' => 'Anmelden fr E-Mail an User?',
    'emailstoryloginrequired' => 'Anmelden fr E-Mail- Artikelversand?',
    'directoryloginrequired' => 'Anmelden fr Artikelverzeichnis?',
    'storysubmission' => 'Artikel moderieren?',
    'usersubmission' => 'Neue User zur Moderation?',
    'listdraftstories' => 'Anzahl Artikel auf Entwurf anzeigen?',
    'notification' => 'Admin-Benachrichtigung',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speedlimit',
    'skip_preview' => 'Vorschau berspringen in Posts',
    'advanced_editor' => 'WYSIWYG-Editor?',
    'wikitext_editor' => 'Wikitext-Editor?',
    'cron_schedule_interval' => 'Zeitabstand fr Cronjobs',
    'sortmethod' => 'Kategorien sortieren',
    'showstorycount' => 'Anzahl Artikel anzeigen?',
    'showsubmissioncount' => 'Anzahl Artikel zur Moderation anzeigen?',
    'hide_home_link' => 'Home Link ausblenden?',
    'whosonline_threshold' => 'Session ist gltig (sec.)',
    'whosonline_anonymous' => 'Namen fr Gste ausblenden?',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => 'Einschalten?',
    'emailstorieslength' => 'Lnge der Artikel',
    'emailstoriesperdefault' => 'Neuen Usern alles zusenden?',
    'allow_domains' => 'Automatisch erlaubte Domains',
    'disallow_domains' => 'Automatisch verbotene Domains',
    'newstoriesinterval' => 'Zeitabstand fr neue Artikel',
    'newcommentsinterval' => 'Zeitabstand fr neue Kommentare',
    'newtrackbackinterval' => 'Zeitabstand fr neue Trackbacks',
    'hidenewstories' => 'Neue Artikel ausblenden',
    'hidenewcomments' => 'Neue Kommentare ausblenden',
    'hidenewtrackbacks' => 'Neue Trackbacks ausblenden',
    'hidenewplugins' => 'Neue Plugin-Eintrge ausblenden',
    'title_trim_length' => 'Titel abschneiden nach ',
    'trackback_enabled' => 'Trackback mglich?',
    'pingback_enabled' => 'Pingback mglich?',
    'ping_enabled' => 'Ping mglich?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed-Limit',
    'check_trackback_link' => 'Trackbacks gegenchecken',
    'pingback_self' => 'Pingback an eigene Site?',
    'pingback_excerpt' => 'Pingback-Auszug erzeugen?',
    'link_documentation' => 'Link zur Dokumentation?',
    'link_versionchecker' => 'Link zum Versions-Checker?',
    'maximagesperarticle' => 'Max. Bilder pro Artikel',
    'limitnews' => 'Artikel pro Seite',
    'minnews' => 'Min. Artikel pro Seite',
    'contributedbyline' => 'Autor anzeigen?',
    'hideviewscount' => 'Anzeigezhler ausblenden?',
    'hideemailicon' => 'E-Mail-Symbol ausblenden?',
    'hideprintericon' => 'Druck-Symbol ausblenden?',
    'allow_page_breaks' => 'Seitenumbrche erlauben?',
    'page_break_comments' => 'Kommentare auf Mehrseiten-Artikeln',
    'article_image_align' => 'Ausrichtung Kategorie-Symbol',
    'show_topic_icon' => 'Kategorie-Symbol anzeigen?',
    'draft_flag' => 'Als Grundeinstellung auf Entwurf',
    'frontpage' => 'Als Grundeinstellung auf der Titelseite',
    'hide_no_news_msg' => '"No News"-Message ausblenden?',
    'hide_main_page_navigation' => 'Main Page Navigation ausblenden?',
    'onlyrootfeatures' => 'Nur Root kann Hauptartikel schreiben?',
    'aftersave_story' => 'Nachdem der Artikel gespeichert wurde',
    'aftersave_user' => 'Nachdem der User gespeichert wurde',
    'show_right_blocks' => 'Immer rechte Blcke anzeigen?',
    'showfirstasfeatured' => 'Ersten Artikel als Hauptartikel anzeigen?',
    'backend' => 'Newsfeed einschalten?',
    'rdf_file' => 'Ausgabe-Unterverzeichnis',
    'rdf_limit' => 'Newsfeed Limit',
    'rdf_storytext' => 'Artikellnge',
    'rdf_language' => 'Sprache',
    'syndication_max_headlines' => 'Max. Anzahl von berschriften (portal blocks)',
    'comment_feeds_article_tag' => 'Article Tag',
    'comment_feeds_article_tag_position' => 'Article Tag Position',
    'comment_feeds_article_author_tag' => 'Article Author Tag',
    'comment_feeds_comment_author_tag' => 'Comment Author Tag',
    'copyrightyear' => 'Copyright-Jahr',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Pfad zu Mogrify',
    'path_to_netpbm' => 'Pfad zu Netpbm',
    'debug_image_upload' => 'Debug Image-Upload?',
    'keep_unscaled_image' => 'Bild in Originalgre behalten?',
    'allow_user_scaling' => 'User darf skalieren?',
    'jpeg_quality' => 'JPEG-Qualitt?',
    'max_image_width' => 'Max. Bildbreite?',
    'max_image_height' => 'Max. Bildhhe?',
    'max_image_size' => 'Max. Bildgre?',
    'max_topicicon_width' => 'Max. Breite?',
    'max_topicicon_height' => 'Max. Hhe?',
    'max_topicicon_size' => 'Max. Gre?',
    'max_photo_width' => 'Max. Fotobreite?',
    'max_photo_height' => 'Max. Fotohhe?',
    'max_photo_size' => 'Max. Fotogre?',
    'use_gravatar' => 'Gravatare von Gravatar.com benutzen?',
    'gravatar_rating' => 'Gravatar-Rating',
    'force_photo_width' => 'Fotogre erzwingen',
    'default_photo' => 'Standardfoto',
    'commentspeedlimit' => 'Kommentar Speed-Limit',
    'comment_limit' => 'Max. Anzahl Kommentare',
    'comment_mode' => 'Kommentar-Anzeigemodus',
    'comment_code' => 'Kommentar Grundeinstellung',
    'comment_edit' => 'Kommentare editierbar?',
    'comment_edittime' => 'Editierzeit (Sekunden)',
    'commentsubmission' => 'Kommentare moderieren',
    'passwordspeedlimit' => 'Passwort Speed-Limit',
    'login_attempts' => 'Max. Anmeldeversuche',
    'login_speedlimit' => 'Anmelde-Speed-Limit',
    'pass_alg' => 'Password Hash Algorithm',
    'pass_stretch' => 'Hash Stretch Count',
    'user_html' => 'Erlaubtes User HTML',
    'admin_html' => 'Erlaubtes Admin HTML',
    'advanced_html' => 'Zustzl. HTML f.d. WYSIWYG-Editor',
    'skip_html_filter_for_root' => 'HTML des Root ungefiltert?',
    'allowed_protocols' => 'Erlaubte Protokolle',
    'disable_autolinks' => 'Autotags ausschalten?',
    'clickable_links' => 'URLs anklickbar machen?',
    'linktext_maxlen' => 'Max Link Text Length',
    'compressed_output' => 'Komprimierten Output senden?',
    'frame_options' => 'Schutz gegen "Clickjacking"',
    'page_navigation_max_pages' => 'Max Pages for Navigation',
    'censormode' => 'Zensur-Modus?',
    'censorreplace' => 'Zensurwort wird ersetzt mit',
    'censorlist' => 'Liste zensierter Wrter',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'URL-Rewrite einschalten',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Grundeinstellung Meta Description',
    'meta_keywords' => 'Grundeinstellung Meta Keywords',
    'default_permissions_block' => 'Grundeinstellung Blockrechte',
    'default_permissions_story' => 'Grundeinstellung Artikelrechte',
    'default_permissions_topic' => 'Grundeinstellung Kategorierechte',
    'atom_max_stories' => 'Max. Artikel im Webservices-Feed',
    'disable_webservices' => 'Webservices ausschalten?',
    'restrict_webservices' => 'Webservices beschrnken?',
    'article_comment_close_enabled' => 'Automatisch Kommentarmglichkeit abschalten (Grundeinstellung)',
    'article_comment_close_days' => 'Tage nach denen Kommentare uneditierbar werden (hier nur Grundeinstellung)',
    'comment_close_rec_stories' => 'Anzahl letzter Artikel, die kommentierbar sein sollen',
    'allow_reply_notifications' => 'Benachrichtigung auf Kommentare erlauben?',
    'comment_on_same_page' => 'Comment on Same Page?',
    'show_comments_at_replying' => 'Show Comments at Replying?',
    'search_style' => 'Darstellung der Ergebnisse',
    'search_limits' => 'Seiteneinstellung',
    'search_show_num' => 'Ergebnisnummer zeigen?',
    'search_show_type' => 'Ergebnisart zeigen?',
    'search_show_sort' => 'Darf User Ergebnisse sortieren?',
    'search_show_limit' => 'Seiteneinstellung zeigen?',
    'search_separator' => 'Trennzeichen fr Gruppen',
    'search_def_keytype' => 'Grundeinstellung Suchmethode',
    'search_def_sort' => 'Grundeinstellung Sortierreihenfolge',
    'autotag_permissions_story' => '[story: ]-Rechte',
    'autotag_permissions_user' => '[user: ]-Rechte',
    'multiple_breadcrumbs' => 'Multiple Breadcrumbs',
    'disable_breadcrumbs_topics' => 'Disable Topic Breadcrumbs',
    'disable_breadcrumbs_articles' => 'Disable Article Breadcrumbs',
    'disable_breadcrumbs_plugins' => 'Disable Plugins Breadcrumbs',
    'breadcrumb_root_site_name' => 'Site Name as Breadcrumb Root?'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Artikel und Trackbacks',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blcke',
    'sg_users' => 'User und Beitrge',
    'sg_images' => 'Bilder',
    'sg_locale' => 'Sprache und Lokalisierung',
    'sg_misc' => 'Vermischtes'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Pfade',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'User',
    'fs_misc' => 'Vermischtes',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin-Block',
    'fs_locale' => 'Lokalisierung',
    'fs_language' => 'Sprache',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Anmeldeeinstellungen',
    'fs_search' => 'Suche',
    'fs_user_submission' => 'Registrierung User',
    'fs_submission' => 'Registrierungseinstellungen',
    'fs_topics_block' => 'Kategorien-Block',
    'fs_whosonline_block' => 'Wer-ist-online-Block',
    'fs_daily_digest' => 'Tgliche Zusammenfassung der Artikel',
    'fs_whatsnew_block' => 'Was-ist-neu-Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Artikel',
    'fs_theme_advanced' => 'Erweiterte Einstellungen',
    'fs_syndication' => 'Newsfeed',
    'fs_syndication_comment' => 'Comment Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Bilder in Artikeln',
    'fs_topicicon' => 'Kategorie-Symbol',
    'fs_userphoto' => 'Fotos',
    'fs_gravatar' => 'Gravatar.com',
    'fs_comments' => 'Kommentare',
    'fs_htmlfilter' => 'HTML-Filterung',
    'fs_censoring' => 'Zensieren',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Grundeinstellung Artikelrechte',
    'fs_perm_topic' => 'Grundeinstellung Kategorierechte',
    'fs_perm_block' => 'Grundeinstellung Blockrechte',
    'fs_webservices' => 'Webservices',
    'fs_autotag_permissions' => 'Autotag-Rechte',
    'fs_breadcrumbs' => 'Breadcrumbs',
    'fs_pass' => 'Password Settings'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Pfade',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_pear' => 'Pear',
    'tab_mysql' => 'MySQL',
    'tab_users' => 'User',
    'tab_misc' => 'Vermischtes',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin-Block',
    'tab_locale' => 'Lokalisierung',
    'tab_language' => 'Sprache',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Anmelden',
    'tab_search' => 'Suche',
    'tab_user_submission' => 'Registrierung',
    'tab_submission' => 'Registrierungseinstellungen',
    'tab_topics_block' => 'Kategorien-Block',
    'tab_whosonline_block' => 'Wer-ist-online-Block',
    'tab_daily_digest' => 'Zusammenfassung',
    'tab_whatsnew_block' => 'Was-ist-neu-Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Artikel',
    'tab_theme_advanced' => 'Erweiterte Einstellungen',
    'tab_syndication' => 'Newsfeed',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Bilder in Artikeln',
    'tab_topicicon' => 'Kategorie-Symbol',
    'tab_userphoto' => 'Fotos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Kommentare',
    'tab_htmlfilter' => 'HTML-Filterung',
    'tab_censoring' => 'Zensieren',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Rechte',
    'tab_webservices' => 'Webservices',
    'tab_topics' => 'Topics'
);

$LANG_configselects['Core'] = array(
    0 => array('Ja' => 1, 'Nein' => 0),
    1 => array('Ja' => true, 'Nein' => false),
    2 => array('Zurckweisen' => 0, 'Nur letzten behalten' => 1, 'Mehrfache Posts erlauben' => 2),
    3 => array('Trackbacks erlaubt' => 0, 'Keine Trackbacks' => -1),
    4 => array('Nichts checken' => 0, 'Site URL checken' => 1, 'Volle URL checken' => 2, 'Site URL und volle URL checken' => 3, 'Trackback IP mit Site IP vergleichen' => 4, 'IP und Site URL checken' => 5, 'IP und volle URL checken' => 6, 'IP, volle URL, und Site URL checken' => 7),
    5 => array('als Text' => 'plaintext', 'in HTML' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Letzte Seite' => 'last', 'Erste Seite' => 'first', 'Jede Seite' => 'all'),
    8 => array('Rechts' => 'right', 'Links' => 'left'),
    9 => array('Auf Seite weiterleiten' => 'item', 'Liste anzeigen' => 'list', 'Home anzeigen' => 'home', 'Admin anzeigen' => 'admin'),
    10 => array('Keine' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flach' => 'flat', 'Verschachtelt' => 'nested', 'Nach Thema' => 'threaded', 'Keine Kommentare' => 'nocomment'),
    12 => array('Kein Zugang' => 0, 'Nur lesen' => 2, 'Lesen-schreiben' => 3),
    13 => array('berspringen' => 0, 'Erlauben mit Speed-Limit' => 1, 'Erlauben ohne Speed-Limit' => 2),
    14 => array('Sonntag' => 'Sun', 'Montag' => 'Mon'),
    15 => array('Nummerisch' => 'sortnum', 'Alphabetisch' => 'alpha'),
    16 => array('Keine Anmeldung bentigt' => 0, 'Nur erweiterte Suche' => 1, 'Einfache und erweiterte Suche' => 2),
    17 => array('Kommentare eingeschaltet' => 0, 'Kommentare ausgeschaltet' => -1),
    18 => array('Aus' => 0, 'Ein (Exakte bereinstimmung)' => 1, 'Ein (Wortanfang)' => 2, 'Ein (Teilwort)' => 3),
    19 => array('Google' => 'google', 'Tabelle' => 'table'),
    20 => array('Exakter Ausdruck' => 'phrase', 'Alle Worte' => 'all', 'Eines der Worte' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Deaktiviert' => 0, 'Aktiviert' => 1, 'Aktiviert (Grundeinstellung nur auf der Startseite)' => 2),
    24 => array('Mitmachen' => 'contribute', 'Home' => 'home', 'Erweiterte Suche' => 'search', 'Verzeichnis' => 'directory', 'Mein Profil' => 'prefs', 'Plugin Eintrge' => 'plugins', 'Custom Eintrge' => 'custom', 'Statistik' => 'stats'),
    25 => array('Neuer Artikel' => 'story', 'Neuer Kommentar' => 'comment', 'Neuer Trackback' => 'trackback', 'Neuer Pingback' => 'pingback', 'Neuer User' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (aufst)' => 'hits|asc', 'Hits (abst)' => 'hits|desc', 'Datum (aufst)' => 'date|asc', 'Datum (abst)' => 'date|desc', 'Titel (aufst)' => 'title|asc', 'Titel (abst)' => 'title|desc', 'Autor (aufst)' => 'uid|asc', 'Autor (abst)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none')
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'yearOrRange' => 'This field must be in a year format such as 2010 or range like 2010 - 2012',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character',
    'page_navigation_max_pages' => 'This field must be between 2 - 21',
    'hash' => 'This field must be a hash function supported by your version of PHP'
);


?>
