<?php

###############################################################################
# polish_utf-8.php
# This is the Polish language file for Geeklog!
# Special thanks to Robert Stadnik geeklog@geeklog.now.pl for his work on this project
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten@securitygeeks.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Autor:',
    2 => 'czytaj dalej',
    3 => 'komentarzy',
    4 => 'Edycja',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Menu Admina:',
    10 => 'Panel Sterowania',
    11 => 'Artykuły',
    12 => 'Bloki',
    13 => 'Sekcje',
    14 => '',
    15 => '',
    16 => '',
    17 => 'Użytkownicy',
    18 => 'Zapytanie SQL',
    19 => 'Wyloguj',
    20 => 'Informacje Użytkownika:',
    21 => 'Login',
    22 => 'ID Użytkownika',
    23 => 'Poziom Zabezpieczeń',
    24 => 'Gall Anonim',
    25 => 'Komentuj',
    26 => 'Komentarze należą do osób, które je zamieściły. Nie bierzemy odpowiedzialności za ich treść.',
    27 => 'Najnowsze Komentarze',
    28 => 'Kasuj',
    29 => 'Komentarzy Brak.',
    30 => 'Starsze Artykuły',
    31 => 'Dozwolone Znaczniki HTML:',
    32 => 'Błąd, niewłaściwy login',
    33 => 'Błąd, nie można zapisać w logu',
    34 => 'Błąd',
    35 => 'Wyloguj',
    36 => 'dnia',
    37 => 'Brak artykułów użytkownika',
    38 => 'Syndykacja Treści',
    39 => 'Odśwież',
    40 => '',
    41 => 'Gość',
    42 => 'Autor:',
    43 => 'Odpowiedz',
    44 => 'Główny',
    45 => 'Numer Błędu MySQL',
    46 => 'Numer Komunikatu Błędu MySQL',
    47 => 'Menu Użytkownika',
    48 => 'Konto - Info',
    49 => 'Osobiste',
    50 => 'Błędna składnia SQL',
    51 => 'pomoc',
    52 => 'Nowy',
    53 => 'Panel Sterowania',
    54 => 'Nie można otworzyć pliku.',
    55 => 'Błąd przy',
    56 => 'Głosuj',
    57 => 'Hasło',
    58 => 'Login',
    59 => "Nie masz jeszcze konta? Załóż sobie <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">Nowy Użytkownik</a>",
    60 => 'Komentarze',
    61 => 'Załóż Konto',
    62 => 'słów',
    63 => 'Komentarze - Preferencje',
    64 => 'Wyślij Znajomemu',
    65 => 'Wersja do Wydruku',
    66 => '',
    67 => 'Witaj w Serwisie ',
    68 => 'strona główna',
    69 => 'kontakt',
    70 => 'szukaj',
    71 => 'napisz',
    72 => 'linki',
    73 => '',
    74 => '',
    75 => 'zaawansowane szukanie',
    76 => 'statystyka',
    77 => 'Pluginy',
    78 => '',
    79 => 'Co Nowego',
    80 => 'artykułów w ost.',
    81 => 'artykuł w ost.',
    82 => 'godz',
    83 => 'KOMENTARZE',
    84 => '',
    85 => 'wygasają po 48 h',
    86 => 'Brak nowych komentarzy',
    87 => 'wygasają po 2 tyg',
    88 => '',
    89 => '',
    90 => 'Strona Główna',
    91 => 'Strona wygenerowana w ',
    92 => 'sekund',
    93 => 'Prawa Autorskie',
    94 => 'Wszelkie znaki handlowe i prawa autorskie należą do ich właścicieli.',
    95 => 'Wersja',
    96 => 'Grupy',
    97 => 'Lista Słów',
    98 => 'Pluginy',
    99 => 'ARTYKUŁY',
    100 => 'Brak nowych artykułów',
    101 => '',
    102 => '',
    103 => 'Kopie zapasowe bazy',
    104 => 'przez',
    105 => 'Wyślij Maila',
    106 => 'Odsłon',
    107 => 'Wersja GL - Test',
    108 => 'Opróżnij Cache',
    109 => 'Zgłoś nadużycie',
    110 => 'Powiadom administratora o tym wpisie',
    111 => '',
    112 => 'Zarejestrowani Użytkownicy',
    113 => 'Dokumentacja',
    114 => 'POWIADOMIENIA ZWROTNE',
    115 => 'Brak nowych powiadomień zwrotnych dla komentarzy',
    116 => 'Powiadomienia zwrotne',
    117 => 'Katalog',
    118 => 'Dalszy ciąg na kolejnej stronie:',
    119 => "Nie pamiętasz <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">hasła</a>?",
    120 => 'Stały odnośnik do tego komentarza',
    121 => 'Komentarze (%d)',
    122 => 'Powiadomienia zwrotne (%d)',
    123 => 'Wszystkie znaczniki HTML są dozwolone',
    124 => 'Kliknij aby usunąć wszystkie zaznaczone pozycje',
    125 => 'Czy aby na pewno chcesz Usunąć wszystkie zaznaczone pozycje?',
    126 => 'Zaznacz lub odznacz wszystkie pozycje',
    127 => 'Stały odnośnik',
    128 => 'Zaloguj z OpenID:',
    129 => 'Konfiguracja',
    130 => 'Usługi Web-owe',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage",
    'facebook' => 'Login with Facebook',
    'twitter' => 'Login with Twitter',
    'linkedin' => 'Login with LinkedIn'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Napisz Komentarz',
    2 => 'Format',
    3 => 'Wyloguj',
    4 => 'Załóż Konto',
    5 => 'Login',
    6 => 'Aby zamieścić komentarz należy się zalogować.  Jeśli nie masz jeszcze konta, załóż sobie używając poniższego formularza.',
    7 => 'Ostatni komentarz zamieściłeś ',
    8 => " sekund temu.  Wymagana jest przerwa równa {$_CONF['commentspeedlimit']} sekund pomiędzy komentarzami",
    9 => 'Komentarz',
    10 => 'Wyślij Raport',
    11 => 'Wyślij Komentarz',
    12 => 'Proszę uzupełnić pola Tytuł i Komentarz. Pola te są wymagane do zamieszczenia komentarza.',
    13 => 'Twoje Informacje',
    14 => 'Podgląd',
    15 => 'Zgłoś tą wiadomość',
    16 => 'Tytuł',
    17 => 'Błąd',
    18 => 'Ważne Informacje',
    19 => 'Proszę starać się nie odbiegać od tematu.',
    20 => 'Proszę raczej odpowiadać na zamieszczane komentarze innych użytkowników zamiast rozpoczynania nowych wątków.',
    21 => 'Aby uniknąć powtarzania, zanim zamieścisz swój komentarz przeczytaj co napisali inni.',
    22 => 'Wpisz temat adekwatny do treści wiadomości.',
    23 => 'Twój adres email nie będzie ujawniony.',
    24 => 'Gall Anonim',
    25 => 'Czy chcesz zgłosić administratorowi ten komentarz?',
    26 => '%s zgłosił następujący komentarz:',
    27 => 'Raport nadużyć',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications',
    44 => 'Your Name',
    45 => "Thank you for your comment. You must wait {$_CONF['commentspeedlimit']} seconds to post a new comment."
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Profil Użytkownika',
    2 => 'Login',
    3 => 'Nazwa',
    4 => 'Hasło',
    5 => 'Email',
    6 => 'Strona Domowa',
    7 => 'O Sobie',
    8 => 'Klucz PGP',
    9 => 'Zapisz Informacje',
    10 => 'Ostatnie 10 komentarzy użytkownika',
    11 => 'Brak Komentarzy Użytkownika',
    12 => 'Preferencje Użytkownika',
    13 => 'Dzienne Zestawienie Artykułów',
    14 => 'Hasło jest generowane automatycznie. Zalecana jest szybka zmiana hasła. Aby zmienić hasło, należy się zalogować a następnie kliknąć na Konto Info w Menu Użytkownika.',
    15 => "Twoje {$_CONF['site_name']} konto zostało założone. Zaloguj się wykorzystując informacje poniżej. Proszę zachować tego maila w bezpiecznym miejscu.",
    16 => 'Informacje Dotyczące Twojego Konta',
    17 => 'Konto nie istnieje',
    18 => 'Podany adres email nie jest prawidłowy',
    19 => 'Podany login lub adres email już istnieje',
    20 => 'Podany adres email nie jest prawidłowy',
    21 => 'Błąd',
    22 => "Zarejestruj się w serwisie {$_CONF['site_name']}!",
    23 => "Konto w serwisie {$_CONF['site_name']} pozwoli ci zamieszczać komentarze i inne pozycje w twoim imieniu. Brak konta umożliwia tylko zamieszczanie jako anonim. Twój adres email <b><i>nigdy</i></b> nie będzie widoczny publicznie.",
    24 => 'Twoje hasło zostanie wysłane pod podany adres email.',
    25 => 'Nie pamiętasz hasła?',
    26 => 'Wpisz <em>albo</em> swój login <em>albo</em> adres email podany podczas rejestracji i kliknij Prześlij Hasło. Instrukcje jak ustawić nowe hasło zostaną wysłane do Ciebie mailem.',
    27 => 'Zarejestruj Się!',
    28 => 'Prześlij Hasło',
    29 => 'wylogowany z adresu',
    30 => 'zalogowany z adresu',
    31 => 'Wybrana funkcja wymaga wcześniejszego zalogowania',
    32 => 'Podpis',
    33 => 'Niewidoczne dla publiki',
    34 => 'Twoje prawdziwe imię',
    35 => 'Wpisz nowe hasło',
    36 => 'Początek od http://',
    37 => 'Zastosowane do twoich komentarzy',
    38 => 'Wszystko o tobie! Każdy może to przeczytać',
    39 => 'Twój publiczny klucz PGP dla wszystkich',
    40 => 'Bez Ikon Sekcji',
    41 => 'Chętny/a do Zatwierdzania Materiałów',
    42 => 'Format Daty',
    43 => 'Artykuły Max Ilość',
    44 => 'Bez bloków',
    45 => 'Wygląd - Ustawienia Użytkownika',
    46 => 'Wyłączone Pozycje Użytkownika',
    47 => 'Konfiguracja Bloków z Nowościami Użytkownika',
    48 => 'Sekcje',
    49 => 'Bez ikon w artykułach',
    50 => 'Odznacz jeśli nie jesteś zainteresowany',
    51 => 'Tylko nowe artykuły',
    52 => 'Domyślnie jest',
    53 => 'Otrzymujesz nowe artykuły co wieczór',
    54 => 'Zaznacz sekcje i autorów, których nie chcesz oglądać.',
    55 => 'Jeśli nic nie zaznaczysz oznacza to, że akceptujesz domyślną konfigurację. Przy zaznaczaniu wybranych bloków domyślne ustawienie jest anulowane. Nazwy bloków objętych domyślnym ustawieniem są pogrubione.',
    56 => 'Autorzy',
    57 => 'Wyświetlanie',
    58 => 'Sortowanie wg',
    59 => 'Limit Komentarzy',
    60 => 'Jak chcesz wyświetlać swoje komentarze?',
    61 => 'Od najnowszych czy od najstarszych?',
    62 => 'Domyślnie jest 100',
    63 => "Hasło zostało wysłane i powinno wkrótce do ciebie dotrzeć. Postępuj zgodnie ze wskazówkami w wiadomości. Dziękujemy za korzystanie z serwisu {$_CONF['site_name']}",
    64 => 'Komentarze - Ustawienia Użytkownika',
    65 => 'Spróbuj Zalogować się Ponownie',
    66 => "Być może login został błędnie wpisany.  Spróbuj zalogować się ponownie. Czy jesteś <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">nowym użytkownikiem</a>?",
    67 => 'Członkowstwo Od',
    68 => 'Pamiętaj Mnie Przez',
    69 => 'Jak długo pamiętać cię po zalogowaniu?',
    70 => "Dostosuj wygląd i zawartość serwisu {$_CONF['site_name']}",
    71 => "Jedną z extra możliwości serwisu {$_CONF['site_name']} jest możliwość dopasowania zawartości i wyglądu strony.  Aby skorzystać z tych udogodnień należy się najpierw <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">zarejestrować</a> w serwisie {$_CONF['site_name']}.  Jesteś już członkiem?  Zaloguj się!",
    72 => 'Pulpit',
    73 => 'Język',
    74 => 'Zmień wygląd strony!',
    75 => 'Artykuły Wysyłane Mailem do',
    76 => 'Jeżeli zaznaczysz jakąś sekcję z poniższej listy będziesz, pod koniec każdego dnia, otrzymywał nowe artykuły zamieszczone w tej sekcji. Zaznacz sekcje, które cię interesują!',
    77 => 'Zdjęcie',
    78 => 'Dodaj swoje zdjęcie!',
    79 => 'Zaznacz tutaj aby wykasować to zdjęcie',
    80 => 'Logowanie',
    81 => 'Wyślij Maila',
    82 => '10 najnowszych artykułów użytkownika',
    83 => 'Materiały zamieszczone przez użytkownika',
    84 => 'Wszystkich artykułów:',
    85 => 'Wszystkich komentarzy:',
    86 => 'Znajdź wszystkie materiały zamieszczone przez',
    87 => 'Twój login',
    88 => "Ktoś (prawdopodobnie Ty) chce uzyskać nowe hasło do tego konta \"%s\" w {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nJeśli chcesz kontynuować proszę kliknij ten link:\n\n",
    89 => "Jeśli nie chcesz kontynuować, zignoruj tą wiadomość (Twoje hasło pozostanie niezmienione).\n\n",
    90 => 'Poniżej możesz wprowadzić nowe hasło. Pamiętaj, że stare hasło jest aktywne do czasu przesłania tego zgłoszenia.',
    91 => 'Ustaw Nowe Hasło',
    92 => 'Wpisz Nowe Hasło',
    93 => 'Twoja ostatnia prośba o zmianę hasła była wysłana %d sekund temu. Wymagana jest przerwa co najmniej %d sekundowa pomiędzy takimi zgłoszeniami.',
    94 => 'Kasuj Konto "%s"',
    95 => 'Kliknij poniższy przycisk "kasuj konto" aby usunąć swoje konto z bazy danych. Proszę mieć na uwadze, że wszelkie artykuły i komentarze, zamieszczone przez Ciebie <strong>nie</strong> zostaną usunięte ale autor zmieni się na "Gall Anonim".',
    96 => 'kasuj konto',
    97 => 'Potwierdź Usunięcie Konta',
    98 => 'Czy aby napewno chcesz usunąć swoje konto? Po skasowaniu konta nie będzie można się ponownie zalogować na tej stronie (chyba, że założysz nowe konto). Jeśli tego chcesz kliknij ponownie "kasuj konto" w poniższym formularzu.',
    99 => 'Ochrona Prywatności dla',
    100 => 'Email od Admina',
    101 => 'TAK na emaile od Admina',
    102 => 'Email od Użytkowników',
    103 => 'TAK na emaile od innych użytkowników',
    104 => 'Pokaż Status Online',
    105 => 'Pokaż w bloku Who\'s Online',
    106 => 'Lokalizacja',
    107 => 'Pokaż w swoim publicznym profilu',
    108 => 'Potwierdź nowe hasło',
    109 => 'Wpisz tutaj ponownie Nowe hasło',
    110 => 'Obecne Hasło',
    111 => 'Proszę wpisać swoje Obecne hasło',
    112 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    113 => 'Nieudana Próba Zalogowania',
    114 => 'Konto WYłączone',
    115 => 'Twoje konto zostało wyłączone, nie można się zalogować. Proszę skontaktować się z Administratorem.',
    116 => 'Konto Czeka Na Aktywację',
    117 => 'Twoje konto czeka obecnie na aktywację przez administratora. You will not be able to login until your account has been approved.',
    118 => "Your {$_CONF['site_name']} account has now been activated by an administrator. You may now login to the site at the url below using your username (<username>) and password as previously emailed to you.",
    119 => 'Jeśli nie pamiętasz swojego hasła, kliknij na ten odnośnik aby otrzymać nowe:',
    120 => 'Konto Zostało Aktywowane',
    121 => 'Service',
    122 => 'Przepraszamy, rejestracja nowych użytkowników jest wyłączona',
    123 => "Czy jesteś <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">nowym użytkownikiem</a>?",
    124 => 'Potwierdzenie Adresu Email',
    125 => 'W obu polach należy wpisać taki sam adres email!',
    126 => 'Please repeat for confirmation',
    127 => 'Aby zmienić którekolwiek z tych ustawień, musisz podać swoje bieżące hasło.',
    128 => 'Twoje Imię',
    129 => 'Hasło &amp; Email',
    130 => 'O Sobie',
    131 => 'Daily Digest Options',
    132 => 'Daily Digest Feature',
    133 => 'Wyświetlanie Komentarzy',
    134 => 'Opcje Komentarzy',
    135 => '<li>Domyślny tryb wyświetlania komentarzy</li><li>Domyślne sortowanie komentarzy</li><li>Liczba wyświetlanych komentarzy - domyślnie jest 100</li>',
    136 => 'Nie Pokazuj Tematów i Autorów',
    137 => 'Filtruj Zawartość Artykułów',
    138 => 'Ustawienia Różne',
    139 => 'Layout i Język',
    140 => '<li>No Topic Icons if checked will not display the story topic icons</li><li>No boxes if checked will only show the Admin Menu, User Menu and Topics</li><li>Set the maximum number of stories to show per page</li><li>Set your theme, timezone and preferred date format</li>',
    141 => 'Ustawienia Prywatności',
    142 => 'The default setting is to allow users & admins to email fellow site members and show your status as online. Un-check these options to protect your privacy.',
    143 => 'Filtruj Zawartość Bloków',
    144 => 'Pokaż & ukryj pola',
    145 => 'Twój Profil Publiczny',
    146 => 'Hasło i email',
    147 => 'Edit your account password, email and autologin feature. You will need to enter the same password or email address twice as a confirmation.',
    148 => 'Informacje o Użytkowniku',
    149 => 'Modify your user information that will be shown to other users.<li>The signature will be added to any comments or forum posts you made</li><li>The BIO is a brief summary of yourself to share</li><li>Share your PGP Key</li>',
    150 => '',
    156 => 'Usuń Konto',
    157 => 'Delete Option',
    158 => 'Strefa Czasowa',
    159 => 'Ta wiadomość została wygenerowana automatycznie. Proszę nie odpowiadać.',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor',
    166 => 'Re-synch Remote Account',
    167 => 'Remote login',
    168 => 'You may also login with one on of the below remote authentication services'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Podgląd',
    'pe_namepass' => 'Użytkownik &amp; Hasło',
    'pe_userinfo' => 'O Sobie',
    'pe_layout' => 'Layout &amp; Język',
    'pe_content' => 'Zawartość',
    'pe_privacy' => 'Prywtność'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Brak Nowości',
    2 => 'Brak nowych artykułów.  Być może nie ma nowych artykułów w danej sekcji lub twoje ustawienia są zbyt limitujące.',
    3 => 'dla sekcji %s',
    4 => 'Dzisiejszy Artykuł Dnia',
    5 => 'Następny',
    6 => 'Poprzedni',
    7 => 'Pierwszy',
    8 => 'Ostatni'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Wystąpił błąd podczas wysyłania wiadomości. Spróbuj ponownie.',
    2 => 'Wiadomość wysłano.',
    3 => 'Proszę się upewnić, że adres email wpisany w pole Odpowiedz Do jest prawidłowy.',
    4 => 'Proszę się Przedstawić, wpisać Odpowiedz Do, Temat i Wiadomość',
    5 => 'Błąd: Nie ma takiego użytkownika.',
    6 => 'Wystąpił błąd.',
    7 => 'Profil Użytkownika',
    8 => 'Użytkownik',
    9 => 'URL Użytkownika',
    10 => 'Wyślij maila do',
    11 => 'Przedstaw Się:',
    12 => 'Twój email:',
    13 => 'Temat:',
    14 => 'Wiadomość:',
    15 => 'Bez znaczników HTML.',
    16 => 'Wyślij',
    17 => 'Wyślij Znajomemu',
    18 => 'Do (twój znajomy)',
    19 => 'Jego/Jej Adres Email',
    20 => 'Od (Przedstaw się;-)',
    21 => 'Twój Adres Email',
    22 => 'Należy wypełnić wszystkie pola',
    23 => "Tego maila wysłał %s (%s) z myślą, że może cię zainteresować poniższy artykuł z serwisu {$_CONF['site_url']}.  To nie jest SPAM a użyte adresy email nie zostały nigdzie zapisane celem ich późniejszego wykorzystania.",
    24 => 'Skomentuj ten artykuł tutaj',
    25 => 'Przed użyciem tej opcji musisz się zalogować.  Pozwoli nam to zabezpieczyć system przed niewłaściwym wykorzystaniem',
    26 => 'Ten formularz umożliwia wysłanie maila do wybranego użytkownika.  Wymagane jest wypełnienie wszystkich pól.',
    27 => 'Krótka Wiadomość',
    28 => '%s napisał: ',
    29 => "Dzienne zestawienie artykułów w Serwisie {$_CONF['site_name']} z dnia ",
    30 => 'Newsletter z dnia ',
    31 => 'Tytuł',
    32 => 'Data',
    33 => 'Cały artykuł dostępny tutaj ',
    34 => 'Koniec Wiadomości',
    35 => 'Sorry, ale ten użytkownik nie życzy sobie otrzymywania żadnych emaili.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Wyszukiwanie Zaawansowane',
    2 => 'Słowa Kluczowe',
    3 => 'Sekcja',
    4 => 'Wszystko',
    5 => 'Gdzie',
    6 => 'Artykuły',
    7 => 'Komentarze',
    8 => 'Autorzy',
    9 => 'Wszystko',
    10 => 'Szukaj',
    11 => 'Wyniki',
    12 => 'trafienia',
    13 => 'Wyniki: Brak danych',
    14 => 'Nie znaleziono żadnych danych spełniających twoje kryteria',
    15 => 'Proszę spróbować ponownie.',
    16 => 'Tytuł',
    17 => 'Data',
    18 => 'Autor',
    19 => "Przeszukuje całą bazę artykułów i komentarzy {$_CONF['site_name']} ",
    20 => 'Data',
    21 => 'do',
    22 => '(Format Daty RRRR-MM-DD)',
    23 => 'Odsłon',
    24 => 'Znaleziono %d pozycji',
    25 => 'Szukano',
    26 => 'pozycji ',
    27 => 'sekund',
    28 => 'Brak artykułów lub komentarzy których szukasz',
    29 => 'Artykuły i Komentarze - Wyniki',
    30 => '',
    31 => 'Nie znaleziono żadnych pluginów',
    32 => '',
    33 => 'URL',
    34 => 'Lokalizacja',
    35 => 'Cały Dzień',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Twoje zapytanie powinno zawierać co najmniej 3 znaki.',
    42 => 'Proszę używać następującego formatu daty: RRRR-MM-DD (rok-miesiąc-dzień).',
    43 => 'z wyrażeniem',
    44 => 'ze wszystkimi słowami',
    45 => 'z którymkolwiek ze słów',
    46 => 'Dalej',
    47 => 'Wstecz',
    48 => 'Autor',
    49 => 'Data',
    50 => 'Odsłon',
    51 => '',
    52 => 'Lokalizacja',
    53 => 'Artykuły - Wyniki',
    54 => 'Komentarze - Wyniki',
    55 => 'fraza',
    56 => 'AND',
    57 => 'OR',
    58 => 'WIęcej wyników &gt;&gt;',
    59 => 'Wyniki',
    60 => 'na stronę',
    61 => 'Zmień zapytanie',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Story',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Statystyka Serwisu',
    2 => 'Wszystkich Wizyt w Serwisie',
    3 => 'Artykułów(Komentarzy) w Serwisie',
    4 => '',
    5 => '',
    6 => '',
    7 => '10 Najpopularniejszych Artykułów',
    8 => 'Tytuł Artykułu',
    9 => 'Odsłon',
    10 => 'Wygląda na to, że w tym serwisie nie ma żadnych artykułów albo nikt nigdy żadnego nie przeczytał.',
    11 => '10 Najczęściej Komentowanych Artykułów',
    12 => 'Komentarzy',
    13 => 'Wygląda na to, że w tym serwisie nie ma żadnych artykułów albo nikt nigdy nie skomentował żadnego.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => '10 Najczęściej Emaliowanych Artykułów',
    23 => 'Emaile',
    24 => 'Wygląda na to, że nikt nie przesłał swoim znajomym żadnego artykułu',
    25 => '10 Najczęściej Komentowanych Zwrotnie Artykułów',
    26 => 'Brak komentarzy zwrotnych.',
    27 => 'Liczba aktywnych użytkowników',
    28 => '',
    29 => '',
    30 => 'Odsłon',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Odnośniki',
    2 => 'Wyślij Znajomemu',
    3 => 'Wersja Do Wydruku',
    4 => 'Opcje Artykułu',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Aby przesłać %s musisz się wcześniej zalogować.',
    2 => 'Login',
    3 => 'Nowy Użytkownik',
    4 => '',
    5 => '',
    6 => 'Prześlij Artykuł',
    7 => 'Wymagany jest Login',
    8 => 'Prześlij',
    9 => 'Przy przesyłaniu informacji do tego serwisu, prosimy postępować wg poniższych wskazówek...<ul><li>Należy wypełnić wszystkie pola<li>Zamieścić pełną i poprawną informację<li>Sprawdzić dokładnie podawane adresy</ul>',
    10 => 'Tytuł',
    11 => '',
    12 => 'Data Początkowa',
    13 => 'Data Końcowa',
    14 => 'Lokalizacja',
    15 => 'Opis',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Przeczytaj Uważnie',
    20 => '',
    21 => '',
    22 => 'Błąd: Puste Pola',
    23 => 'Wymagane jest wypełnienie wszystkich pól formularza.',
    24 => 'Zapisano',
    25 => 'Twój materiał %s został zapisany.',
    26 => 'Limit Czasowy',
    27 => 'Login',
    28 => 'Sekcja',
    29 => 'Artykuł',
    30 => 'Ostatni raz przesyłałeś ',
    31 => " sekund temu.  Wymagane jest co najmniej {$_CONF['speedlimit']} sekund przerwy pomiędzy zamieszczeniami",
    32 => 'Podgląd',
    33 => 'Podgląd Artykułu',
    34 => 'Wyloguj',
    35 => 'Znaczniki HTML nie są dozwolone',
    36 => 'Format',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Adres 1',
    45 => 'Adres 2',
    46 => 'Miasto/Miejscowość',
    47 => 'Województwo',
    48 => 'Kod Pocztowy',
    49 => '',
    50 => '',
    51 => 'Lokalizacja',
    52 => 'Kasuj',
    53 => 'Załóż Konto',
    54 => 'Artykuł Wstęp',
    55 => 'Artykuł Część Główna'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Wymagana jest Autoryzacja',
    2 => 'Odmowa! Niewłaściwy Login',
    3 => 'Niewłaściwe hasło użytkownika',
    4 => 'Login:',
    5 => 'Hasło:',
    6 => 'Wszelkie próby wejścia do segmentów administracyjnych są logowane i weryfikowane.<br' . XHTML . '>Dostęp tylko dla osób upoważnionych.',
    7 => 'login'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Niewystarczające Uprawnienia Administracyjne',
    2 => 'Nie masz wystarczających uprawnień do edycji tego bloku.',
    3 => 'Edytor Bloków',
    4 => 'Wystąpił błąd odczytu (szczegóły w pliku error.log).',
    5 => 'Yes',
    6 => 'No',
    7 => 'Wszystkie',
    8 => 'Poziom Zabezpieczenia Bloku',
    9 => 'Numer Bloku',
    10 => '',
    11 => 'Blok Portalowy',
    12 => 'Blok Normalny',
    13 => 'Opcje Bloku Portalowego',
    14 => 'URL pliku RDF',
    15 => 'Ostatnie Uaktualnienie Pliku RDF',
    16 => 'Opcje Bloku Normalnego',
    17 => 'Zawartość Bloku',
    18 => 'Proszę wpisać Tytuł Bloku, Poziom Zabezpieczenia i pola Zawartości',
    19 => 'Menadżer Bloków',
    20 => 'Regular Blocks',
    21 => 'PozZab Bloku',
    22 => 'Dynamic Blocks',
    23 => 'Numer Bloku',
    24 => 'Dynamic',
    25 => 'Aby zmodyfikować lub wykasować blok kliknij na blok poniżej.  Aby stworzyć nowy blok kliknij Nowy Blok powyżej.',
    26 => 'Blok Schematowy',
    27 => 'Blok PHP',
    28 => 'Opcje Bloku PHP',
    29 => 'Funkcje Bloku',
    30 => 'Jeśli chcesz aby twój blok obsługiwał kod PHP, wpisz nazwę funkcji powyżej.  Nazwa funkcji musi rozpoczynać się prefiksem "phpblock_" (np. phpblock_getweather).  Jeżeli nie będzie prefiksu, twoja funkcja NIE zostanie wywołana.  Związane jest to z uniemożliwieniem \'wrzucania\' skryptów przez hakerów, które mogą uszkodzić twój system.  Upewnij się, że nie ma pustych nawiasów "()" po nazwie funkcji.  Na koniec, zalecamy umieszczenie całego kodu PHP Block w /ścieżka/do/geeklog/system/lib-custom.php.  Pozwoli to na zachowanie wersji kodu bez zmian nawet przy aktualizacji Geekloga.',
    31 => 'Błąd w Bloku PHP.  Funkcja, %s, nie istnieje.',
    32 => 'Błąd. Puste pole(a)',
    33 => 'Musisz wpisać URL do pliku .rdf dla bloków portalowych',
    34 => 'Musisz wpisać tytuł i funkcję bloków PHP',
    35 => 'Musisz wpisać tytuł i zawartość dla bloków normalnych',
    36 => 'Musisz wpisać zawartość bloków schematowych',
    37 => 'Nieprawidłowa nazwa funkcji bloku PHP',
    38 => 'Funkcje dla Bloków PHP muszą mieć prefiks \'phpblock_\' (np. phpblock_getweather).  Prefiks \'phpblock_\' ze względów bezpieczeństwa aby uniknąć wykonywanie kodu.',
    39 => 'Strona',
    40 => 'Lewa',
    41 => 'Prawa',
    42 => 'Musisz wpisać porządek bloku i poziom zabezpieczeń dla domyślnych bloków Geekloga',
    43 => 'Tylko Strona Główna',
    44 => 'Multiple',
    45 => "Próbujesz wyedytować blok, do którego nie masz uprawnień.  Ta próba została zapisana w logu. Proszę <a href=\"{$_CONF['site_admin_url']}/block.php\">wrócić do ekranu administrowania blokami</a>.",
    46 => 'Nowy Blok',
    47 => 'None',
    48 => 'Nazwa Bloku',
    49 => ' (nazwa unikalna i bez spacji)',
    50 => 'The Block Name can not be empty',
    51 => 'uwzględnij http://',
    52 => 'Jeśli zostawisz puste, ikona pomocy dla tego bloku się nie pojawi',
    53 => 'Aktywne',
    54 => 'zapisz',
    55 => 'anuluj',
    56 => 'kasuj',
    57 => 'Przesuń Blok w Dół',
    58 => 'Przesuń Blok w Górę',
    59 => 'Przesuń blok na prawo',
    60 => 'Przesuń blok w lewo',
    61 => 'Brak Tytułu',
    62 => 'Limit Artykułów',
    63 => 'Nieprawidłówy Tytuł Bloku',
    64 => 'Pole Tytuł nie może być puste i nie może zawierać znaczników HTML!',
    65 => 'Sorotwanie',
    66 => 'Autotagi',
    67 => 'Zaznacz aby włączyć autotagi',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.',
    69 => 'Plugin Name'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Poprzednie Artykuły',
    2 => 'Następne Artykuły',
    3 => 'Tryb',
    4 => 'Format',
    5 => 'Edytor Artykułów',
    6 => 'Brak artykułów w systemie',
    7 => 'Autor',
    8 => 'zapisz',
    9 => 'podgląd',
    10 => 'anuluj',
    11 => 'kasuj',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Data',
    16 => 'Wstęp',
    17 => 'Część Główna',
    18 => 'Wejść',
    19 => 'Komentarze',
    20 => 'Ping',
    21 => 'Send Ping',
    22 => 'Lista Artykułów',
    23 => 'Aby zmodyfikować lub wykasować artykuł, kliknij na numer danego artykułu poniżej. Aby przeglądnąć artykuł kliknij na tytuł danego artykułu. Aby wpisać nowy artykuł kliknij na Nowy Artykuł powyżej.',
    24 => 'The ID you chose for this story is already in use. Please use another ID.',
    25 => 'Błąd podczas zapisywania artykułu',
    26 => 'Podgląd Artykułu',
    27 => 'Jeśli używasz [unscaledX] zamiast [imageX], zdjęcie zostanie zamieszczone w oryginalnym rozmiarze.',
    28 => '<p><b>PODGLĄD</b>: Podgląd artykułu z załączonymi zdjęciami działa najlepiej po uprzednim zapisaniu artykułu jako kopia robocza ZAMIAST klikaniu na przycisk podglądu.  Przycisk podglądu najlepiej używać gdy nie załączamy zdjęć.',
    29 => 'Trackbacks',
    30 => 'Błąd Uploadu Pliku',
    31 => 'Proszę wpisać Tytuł i Wstęp',
    32 => 'Artykuł Dnia',
    33 => 'Artykuł Dnia może być tylko jeden',
    34 => 'Wersja Robocza',
    35 => 'Tak',
    36 => 'Nie',
    37 => 'Więcej autorstwa',
    38 => 'Więcej z sekcji',
    39 => 'Emaile',
    40 => '',
    41 => "Próbujesz wyedytować artykuł do którego nie masz uprawnień.  Ta próba została zapisana w logu.  Możesz podglądnąć artykuł poniżej. Proszę <a href=\"{$_CONF['site_admin_url']}/story.php\">wrócić do strony administrującej artykułami.",
    42 => "Próbujesz wyedytować artykuł do którego nie masz uprawnień.  Ta próba została zapisana w logu.  Proszę <a href=\"{$_CONF['site_admin_url']}/story.php\">wrócić do strony administrującej artykułami</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>UWAGA:</b> jeśli przesuniesz datę do przodu, artykuł nie zostanie opublikowany wcześniej. Oznacza to również, że artykuł nie będzie uwzględniony w pliku RDF i zostanie pominięty przy wyszukiwaniu.',
    47 => 'Zdjęcia',
    48 => 'zdjęcie',
    49 => 'prawo',
    50 => 'lewo',
    51 => 'Aby dodać jedno ze zdjęć, które chcesz podpiąć do tego artykułu musisz wstawić specjalnie sformatowany tekst.  Tekst jest następujący [imageX], [imageX_right] lub [imageX_left] gdzie X to numer obrazka, który załączyłeś.  UWAGA: Musisz używać obrazków, które załączasz.  Inaczej nie będziesz w stanie zapisać swojego artykułu.<BR><P><B>PODGLĄD</B>: Podgląd artykułu z załączonymi obrazkami działa najlepiej po uprzednim zapisaniu artykułu jako kopia ZAMIAST użycia bezpośrednio klawisza podgląd.  Używaj klawisza podgląd tylko gdy nie podpinasz obrazków.',
    52 => '',
    53 => 'nie został użyty.  Musisz umieścić ten obrazek we wstępie lub w głównej części zanim zapiszsz zmiany',
    54 => 'Załączonych Obrazów Nie Użyto',
    55 => 'Pojawiły się następujące błędy podczas próby zapisu tego artykułu.  Proszę je poprawić przed ponownym zapisem',
    56 => 'Pokaż Ikonę Artykułu',
    57 => 'Pokaż nieskalowalne zdjęcie',
    58 => 'Zarządzanie Artykułami',
    59 => 'Opcja',
    60 => '',
    61 => 'Auto Archiwizacja',
    62 => 'Auto Kasacja',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Powiększ Edytor',
    68 => 'Zmniejsz Edytor',
    69 => 'Data Publikacji Artykułu',
    70 => 'Wybór Paska Narzędzi',
    71 => 'Pasek Podstawowy',
    72 => 'Common Toolbar',
    73 => 'Pasek Zaawansowany',
    74 => 'Pasek Zaawansowany II',
    75 => 'Pełna Opcja',
    76 => 'Opcje Publikowania',
    77 => 'Edytor Zaawansowany wymaga włączenia Javascript-u. Opcja może zostać wyłączona w głównym pliku config.php',
    78 => 'Kliknij <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">tutaj</a> aby włączyć edytor domyślny',
    79 => 'Podgląd',
    80 => 'Edytor',
    81 => 'Opcje Publikacji',
    82 => 'Zdjęcia',
    83 => 'Opcje Archiwizacji',
    84 => 'Dostęp',
    85 => 'Pokaż Wszystko',
    86 => 'Edytor Zaawansowany',
    87 => 'Artykuł - Statystyki',
    88 => 'Format w stylu Wiki',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.',
    'autotag_desc_story' => '[story: id alternate title] - Displays a link to a Story using the Story Title as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Edytor Sekcji',
    2 => 'ID Sekcji',
    3 => 'Nazwa Sekcji',
    4 => 'Ikona Sekcji',
    5 => '(bez spacji)',
    6 => 'Wykasowanie sekcji wykasuje wszystkie artykuły i bloki z nią powiązane',
    7 => 'Proszę wpisać ID Sekcji i Nazwę Sekcji',
    8 => 'Menadżer Sekcji',
    9 => 'Aby zmodyfikować lub wykasować sekcję, kliknij na daną sekcję.  Aby stworzyć nową sekcję kliknij na Nowa Sekcja powyżej. W nawiasie znajduje się twój poziom dostępu do każdej sekcji. Gwiazdka (*) oznacza domyślną sekcję.',
    10 => 'Sortowanie',
    11 => 'Artykułów/Stronę',
    12 => 'Odmowa Dostępu',
    13 => "Próbujesz wyedytować sekcję do której nie masz uprawnień.  Ta próba została zapisana w logu. Proszę <a href=\"{$_CONF['site_admin_url']}/topic.php\">wrócić do ekranu administrującego sekcjami</a>.",
    14 => 'Sortuj Wg',
    15 => 'alfabetycznie',
    16 => 'domyślnie jest',
    17 => 'Nowa Sekcja',
    18 => 'Panel Sterowania',
    19 => 'zapisz',
    20 => 'anuluj',
    21 => 'kasuj',
    22 => 'Domyślnie',
    23 => 'zrób z tego domyślną sekcję dla przesyłanych artykułów',
    24 => '(*)',
    25 => 'Sekcja Archiwalna',
    26 => 'domyślna sekcja dla archiwizowanych artykułów. Dozwolona jest tylko jedna sekcja.',
    27 => 'Lub Wgraj Ikonę Sekcji',
    28 => 'Max',
    29 => 'Błąd podczas przesyłania pliku',
    30 => 'Stories in Topic',
    31 => 'You have used a restricted Topic ID. Please choose another one.',
    32 => 'Parent Topic',
    33 => 'Inherit',
    34 => 'Items of child topic are inherited',
    35 => 'Hidden',
    36 => 'Topic will be hidden and cannot be viewed directly, only inherited',
    37 => 'Root',
    38 => 'All',
    39 => 'Homepage Only',
    40 => 'Assign one or more topics. ',
    41 => 'If "All" is selected then the item will appear for all topics. If "Homepage Only" is selected then item will appear just on the homepage. Else you must select at least one topic to assign the item to. ',
    42 => 'Inherit contains the list of assigned topics. If the topic is selected then the item will be inherited by the parent topic. You must save your item first before anything is listed in the inherit box. ',
    43 => 'Default contains the list of assigned topics. This is the default topic that will be used when displaying the item if the actual topic the user is in is not found. ',
    44 => 'Inherit',
    45 => 'Default',
    46 => 'Your parent topic cannot be the Archive topic. Please choose a different Parent Topic.',
    47 => 'An Archive Topic cannot have any child topics. Please remove any child topics before making a topic the Archive Topic.',
    48 => 'Parent Topic Id not found.',
    49 => 'This Topic ID is already being used. Please choose another one.',
    50 => 'Yes',
    51 => 'No',
    52 => 'Story',
    53 => 'Image',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'Home'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Edytor Użytkowników',
    2 => 'ID Użytkownika',
    3 => 'Login',
    4 => 'Pełna Nazwa',
    5 => 'Hasło',
    6 => 'Poziom Zabezpieczenia',
    7 => 'Adres Email',
    8 => 'Strona Domowa',
    9 => '(bez spacji)',
    10 => 'Proszę wpisać Login i Adres Email',
    11 => 'Menadżer Użytkowników',
    12 => 'Aby zmodyfikować lub usunąć użytkownika, kliknij na odpowiedni login poniżej.  Aby założyć nowego użytkownika kliknij nowy użytkownik po lewej. Możesz przeszukać bazę wpisując część loginu, adresu email lub pełnej nazwy (np. *son* lub *.edu) w poniższym formularzu.',
    13 => 'PozZab',
    14 => 'Data Rej.',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'zapisz',
    21 => 'Login już istnieje.',
    22 => 'Błąd',
    23 => 'Dodanie Grupowe',
    24 => 'Grupowy Import Użytkowników',
    25 => 'Można zaimportować grupowo użytkowników do Geekloga.  Plik tekstowy musi być rozdzielany znakami tabulacji oraz musi mieć następującą strukturę: imię i nazwisko, login, adres email.  Każdy zaimportowany użytkownik dostanie mailem hasło.  W jednej linii może występować tylko jeden użytkownik.  Nie zastosowanie do tych instrukcji spowoduje problemy, które mogą wymagać ręcznej obróbki dlatego sprawdź dwa razy zawarte informacje!',
    26 => '',
    27 => '',
    28 => 'Zaznacz tutaj aby usunąć obrazek',
    29 => 'Ścieżka',
    30 => 'Import',
    31 => 'Nowi Użytkownicy',
    32 => 'Przetwarzanie zakończone. Zaimportowano %d i napotkano %d błędów',
    33 => 'prześlij',
    34 => 'Błąd: Musisz podać plik do załadowania.',
    35 => 'Ostatni Login',
    36 => '(nigdy)',
    37 => 'UID',
    38 => 'Group Listing',
    39 => 'Password (again)',
    40 => 'Registration Date',
    41 => 'Last login Date',
    42 => 'Banned',
    43 => 'Awaiting Activation',
    44 => 'Awaiting Authorization',
    45 => 'Active',
    46 => 'User Status',
    47 => 'Edit',
    48 => 'Show Admin Groups',
    49 => 'Admin Group',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Note: "Online Days" is the number of days between the first registration and the last login.',
    53 => 'registered',
    54 => 'Batch Delete',
    55 => 'This only works if you have <code>$_CONF[\'lastlogin\'] = true;</code> in your config.php',
    56 => 'Please choose the type of user you want to delete and press "Update List". Then, uncheck those from the list you do not want to delete and press "Delete". Please note that you will only delete those that are currently visible in case the list spans over several pages.',
    57 => 'Phantom users',
    58 => 'Short-Time Users',
    59 => 'Old Users',
    60 => 'Users that registered more than ',
    61 => ' months ago, but never logged in.',
    62 => 'Users that registered more than ',
    63 => ' months ago, then logged in within 24 hours, but since then never came back to your site.',
    64 => 'Normal users, who simply did not visit your site since ',
    65 => ' months.',
    66 => 'Update List',
    67 => 'Months since registration',
    68 => 'Online Hours',
    69 => 'Offline Months',
    70 => 'could not be deleted',
    71 => 'sucessfully deleted',
    72 => 'No User selected for deletion',
    73 => 'Are You sure you want to permanently delete ALL selected users?',
    74 => 'Recent Users',
    75 => 'Users that registered in the last ',
    76 => ' months',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s',
    86 => 'Include',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Zatwierdź',
    2 => 'Kasuj',
    3 => 'Edytuj',
    4 => 'Profil',
    10 => 'Tytuł',
    11 => 'Data Początkowa',
    12 => 'URL',
    13 => 'Kategoria',
    14 => 'Data',
    15 => 'Sekcja',
    16 => 'Nazwa użytkownika',
    17 => 'Pełna nazwa użytkownika',
    18 => 'Email',
    34 => 'Panel Sterowania',
    35 => 'Przesłane Artykuły',
    36 => 'Parent or Comment',
    37 => '',
    38 => 'Prześlij',
    39 => 'Żadnych materiałów do zatwierdzenia',
    40 => 'Materiały przesłane przez użytkownika',
    41 => 'Comment Submissions',
    42 => 'Username',
    43 => 'Auto-publish Comments?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => 'Mail',
    2 => 'Od',
    3 => 'Odpowiedz',
    4 => 'Temat',
    5 => 'Wiadomość',
    6 => 'Wyślij do:',
    7 => 'Wszyscy',
    8 => 'Admin',
    9 => 'Opcje',
    10 => 'HTML',
    11 => 'Pilne!',
    12 => 'Wyślij',
    13 => 'Zresetuj',
    14 => 'Ignoruj ustawienia użytkownika',
    15 => 'Błąd podczas wysyłania do: ',
    16 => 'Wiadomość wysłana do: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>Wyślij następną wiadomość</a>",
    18 => 'Do',
    19 => 'UWAGA: jeśli chcesz wysłać wiadomość do wszystkich użytkowników, wybierz Logged-in Users z listy rozwijanej.',
    20 => "Wysłanych <successcount> wiadomości oraz <failcount> niewysłanych wiadomości.  Poniżej szczegóły dotyczące próby wysłania każdej wiadomości.  Możesz również <a href=\"{$_CONF['site_admin_url']}/mail.php\">Wysłać wiadomość</a> lub możesz <a href=\"{$_CONF['site_admin_url']}/moderation.php\">wrócić do strony administracyjnej</a>.",
    21 => 'Błąd',
    22 => 'Sukces',
    23 => 'Brak błędów',
    24 => 'Bez powodzenia',
    25 => '-- Wybierz Grupę --',
    26 => 'Proszę uzupełnić wszystkie pola i wybrać grupę z listy.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Instalowanie pluginów może spowodować uszkodzenie twojej instalacji Geekloga jak również systemu.  Ważne jest aby instalować pluginy ściągnięte z <a href="http://www.geeklog.net" target="_blank">Geeklog Homepage</a> ponieważ są one szczegółowo przez nas testowane na różnych systemach operacyjnych.  Ważne abyś miał świadomość, że instalacja pluginu wymaga wykonania kilku komend filesystemu, co wiąże się z bezpieczeństwem systemu, zwłaszcza gdy pluginy pochodzą od osób trzecich.  Pomimo tego ostrzeżenia, nie gwarantujemy sukcesu instalacyjnego ani nie możemy być pociągnięci do odpowiedzialności za jakiekolwiek szkody wynikłe z instalacji jakiegokolwiek pluginu.  Instalacja na własne ryzyko.  Instrukcje dotyczące ręcznej instalacji pluginu znajdują się w każdym pakiecie z pluginem.',
    2 => 'Umowa Instalacyjna Pluginów',
    3 => 'Plugin Formularz Instalacyjny',
    4 => 'Plugin Plik',
    5 => 'Zainstalowane Pluginy',
    6 => 'Ostrzeżenie: Plugin Już Zainstalowany!',
    7 => 'Plugin, który próbujesz zainstalować już istnieje.  Proszę wykasować istniejący plugin i zainstalować go ponownie',
    8 => 'Sprawdzanie Kompatybilności Pluginu Zakończone Niepowodzeniem',
    9 => 'Ten plugin wymaga nowszej wersji Geekloga. Albo uaktualnij swoją kopię <a href=http://www.geeklog.net>Geekloga</a> albo ściągnij nowszą wersję tego pluginu.',
    10 => '<br' . XHTML . '><b>Brak zainstalowanych pluginów.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Aby zmodyfikować lub wykasować plugin, kliknij na nazwę pluginu. Zobaczysz więcej informacji włącznie z adresem strony autora. Widoczne są wersje zainstalowana i wersja kodu. To pomoże stwierdzić czy dany plugin wymaga aktualizacji. Aby zainstalować lub uaktualnić dany plugin proszę zapoznać się z dołączoną do niego instrukcją.',
    12 => 'brak nazwy pluginu dla plugineditor()',
    13 => 'Edytor Pluginów',
    14 => 'Nowy Plugin',
    15 => 'Panel Sterowania',
    16 => 'Nazwa',
    17 => 'Wersja',
    18 => 'Wersja GL',
    19 => 'Aktywny',
    20 => 'Tak',
    21 => 'Nie',
    22 => 'Instaluj',
    23 => 'Zapisz',
    24 => 'Anuluj',
    25 => 'Kasuj',
    26 => 'Nazwa Pluginu',
    27 => 'Strona Domowa Pluginu',
    28 => 'Wersja Zainstalowana',
    29 => 'Wersja GL',
    30 => 'Skasować Plugin?',
    31 => 'Czy aby na pewno skasować ten plugin?  Ta operacja usunie wszelkie pliki, dane i strukturę używane przez ten plugin.  Jeśli chcesz kontynuwać kliknij kasuj poniżej.',
    32 => '<p><b>Błędny format tagu AutoLink</b></p>',
    33 => 'Wersja Kodu',
    34 => 'Aktualizacja',
    35 => 'Edit',
    36 => 'Code',
    37 => 'Data',
    38 => 'Update!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    43 => 'Load Order',
    44 => 'Move plugin up the load order',
    45 => 'Move plugin down the load order',
    46 => 'Click to Delete this Plugin',
    47 => 'Really Delete %s Plugin?',
    48 => 'Click to Enable this Plugin',
    49 => 'Click to Disable this Plugin',
    50 => 'Dependencies',
    51 => 'OK',
    52 => 'Unresolved',
    53 => 'Disabled',
    54 => 'Unavailable',
    55 => 'Uninstalled',
    56 => 'Wrong Version',
    57 => 'Unknown',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Close',
    61 => 'Status',
    62 => 'Click to Install this Plugin',
    63 => 'This Plugin Cannot be Installed',
    64 => 'This Plugin Cannot be Enabled',
    65 => 'The plugin upload function has been disabled due to the following errors:',
    66 => 'File uploads are disabled in your PHP configuration.',
    67 => 'The directory "%s" is not writable.',
    68 => 'You do not have the required permissions to install plugins.',
    69 => 'You do not have the required permissions to upload plugins.',
    99 => 'An unknown error occured',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'stwórz plik',
    2 => 'zapisz',
    3 => 'kasuj',
    4 => 'anuluj',
    10 => 'Syndykacja Treści',
    11 => 'Nowy Plik',
    12 => 'Panel Sterowania',
    13 => 'Aby zmodyfikować lub usunąć plik, kliknij na tytuł pliku poniżej. Aby stworzyć nowy plik, kliknij Nowy Plik powyżej.',
    14 => 'Tytuł',
    15 => 'Rodzaj',
    16 => 'Plik',
    17 => 'Format',
    18 => 'ost. aktualizacja',
    19 => 'Aktywny',
    20 => 'Tak',
    21 => 'Nie',
    22 => '<i>(plików brak)</i>',
    23 => 'Wszystkie Artykuły',
    24 => 'Edytor Plików',
    25 => 'Tytuł Pliku',
    26 => 'Limit',
    27 => 'Długość tekstu',
    28 => '(0 = bez tekstu, 1 = pełny tekst, inne = ograniczona liczba znaków.)',
    29 => 'Opis',
    30 => 'Ost. Aktualizacja',
    31 => 'Kodowanie',
    32 => 'Język',
    33 => 'Zawartość',
    34 => 'Tytułów',
    35 => 'Godzin',
    36 => 'Wybierz rodzaj pliku',
    37 => '',
    38 => 'Błąd: Brakujące Pola',
    39 => 'Wpisz Tytuł Pliku, Opis i Nazwę Pliku.',
    40 => 'Proszę podać liczbę tytułów lub czas w godzinach.',
    41 => 'Linki',
    42 => '',
    43 => 'All',
    44 => 'None',
    45 => 'Header-link in topic',
    46 => 'Limit Results',
    47 => 'Search',
    48 => 'Edit',
    49 => 'Feed Logo',
    50 => "Relative to site url ({$_CONF['site_url']})",
    51 => 'The filename you have chosen is already used by another feed. Please choose a different one.',
    52 => 'Error: existing Filename',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Hasło zostało wysłane i powinieneś go wkrótce otrzymać. Postępuj zgodnie ze wskazówkami w wiadomości. Dziękujemy za korzystanie z serwisu {$_CONF['site_name']}",
    2 => "Dziękujemy za przesłanie artykułu do {$_CONF['site_name']}.  Otrzymali go nasi pracownicy do zatwierdzenia. Po zatwierdzeniu twój artykuł będzie dostępny dla innych użytkowników naszego serwisu.",
    3 => '',
    4 => '',
    5 => 'Informacje dotyczące twojego konta zostały zapisane.',
    6 => 'Twoje preferencje dotyczące wyglądu zostały zapisane.',
    7 => 'Twoje preferencje dotyczące komentarzy zostały zapisane.',
    8 => 'Zostałeś/aś pomyślnie wylogowany/a.',
    9 => 'Artykuł został zapisany.',
    10 => 'Artykuł został wykasowany.',
    11 => 'Blok został zapisany.',
    12 => 'Blok został wykasowany.',
    13 => 'Sekcja została zapisana.',
    14 => 'Sekcja oraz wszystkie artykuły i bloki z nią związane zostały wykasowane.',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Nowy użytkownik został zapisany.',
    22 => 'Nowy użytkownik został wykasowany.',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Wiadomość wysłano.',
    28 => 'Plugin został zapisany',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => 'Odmowa Dostępu',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Komunikat Systemowy',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Plugin został zainstalowany!',
    45 => 'Plugin został wykasowany.',
    46 => '',
    47 => '',
    48 => "Dziekujemy za zainteresowanie członkowstwem w {$_CONF['site_name']}. Zweryfikujemy twoje zgłoszenie i po zatwierdzeniu zostanie wysłane hasło pod podany adres e-mail.",
    49 => 'Twoja grupa została zapisana.',
    50 => 'Grupa została wykasowana.',
    51 => 'Ten login juz istnieje. Prosze wybrac inny.',
    52 => 'Podany adres email nie wyglada na prawidlowy.',
    53 => 'Twoje nowe hasło zostało przyjęte. Proszę zalogowac sie ponizej wpisując nowe hasło.',
    54 => 'Twoja prośba o nowe hasło wygasła. Proszę spróbowac ponownie poniżej.',
    55 => 'Wkrótce powinien dotrzeć do Ciebie email. Postępuj zgodnie ze wskazówkami aby ustawić nowe hasło dla Twojego konta.',
    56 => 'Podany adres email jest już używany.',
    57 => 'Twoje konto zostało pomyślnie usunięte.',
    58 => 'Plik został zapisany.',
    59 => 'Plik został skasowany.',
    60 => 'Plugin został pomyślnie zaktualizowany',
    61 => 'Plugin %s: Nieznany komunikat placeholder',
    62 => 'The trackback comment has been deleted.',
    63 => 'An error occurred when deleting the trackback comment.',
    64 => 'Your trackback comment has been successfully sent.',
    65 => 'Weblog directory service successfully saved.',
    66 => 'The weblog directory service has been deleted.',
    67 => 'The new password does not match the confirmation password!',
    68 => 'You have to enter the correct current password.',
    69 => 'Your account has been blocked!',
    70 => 'Your account is awaiting administrator approval.',
    71 => 'Your account has now been confirmed and is awaiting administrator approval.',
    72 => 'An error occured while attempting to install the plugin. See error.log for details.',
    73 => 'An error occured while attempting to uninstall the plugin. See error.log for details.',
    74 => 'The pingback has been successfully sent.',
    75 => 'Trackbacks must be sent using a POST request.',
    76 => 'Do you really want to delete this item?',
    77 => 'WARNING:<br' . XHTML . '>You have set your default encoding to UTF-8. However, your server does not support multibyte encodings. Please install mbstring functions for PHP or choose a different character set/language.',
    78 => 'Please make sure that the email address and the confirmation email address are the same.',
    79 => 'The page you have been trying to open refers to a function that no longer exists on this site.',
    80 => 'The plugin that created this feed is currently disabled. You will not be able to edit this feed until you re-enable the parent plugin.',
    81 => 'You may have mistyped your login credentials.  Please try logging in again below.',
    82 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    83 => 'To change your password, email address, or for how long to remember you, please enter your current password.',
    84 => 'To delete your account, please enter your current password.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit stories.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Dostęp',
    'ownerroot' => 'Właściciel/Root',
    'group' => 'Grupa',
    'readonly' => 'Tylko-do-Odczytu',
    'accessrights' => 'Prawa Dostępu',
    'owner' => 'Właściciel',
    'grantgrouplabel' => 'Udziel Praw do Edycji Powyższej Grupie',
    'permmsg' => 'UWAGA: członkowie to wszyscy zalogowani użytkownicy na stronie a anonimowi to wszyscy użytkownicy przeglądający zawartość strony bez zalogowania.',
    'securitygroups' => 'Grupy Zabezpieczeń',
    'editrootmsg' => "Pomimo tego, że jesteś User Administrator, nie możesz edytować głównego użytkownka. Najpierw sam musisz zostać użytkownikiem głównym.  Możesz edytować pozostałych użytkowników. Wszelkie nie autoryzowane próby edycji użytkowników głównych są logowane.  Powrót do strony Administracja Użytkownikami serwisu <a href=\"{$_CONF['site_admin_url']}/user.php\"></a>.",
    'securitygroupsmsg' => 'Zaznacz grupy do których chcesz przypisać użytkownika.',
    'groupeditor' => 'Edytor Grup',
    'description' => 'Opis',
    'name' => 'Nazwa',
    'rights' => 'Uprawnienia',
    'missingfields' => 'Brakujące Pola',
    'missingfieldsmsg' => 'Musisz podać nazwę i opis grupy',
    'groupmanager' => 'Menadżer Grup',
    'newgroupmsg' => 'Aby zmodyfikować lub wykasować grupę kliknij na daną grupę poniżej. Aby stworzyć nową grupę kliknij nowa grupa powyżej. Grupy główne nie mogą być wykasowane są używane przez system.',
    'groupname' => 'Nazwa Grupy',
    'coregroup' => 'Grupa Główna',
    'yes' => 'Tak',
    'no' => 'Nie',
    'corerightsdescr' => "Ta grupa jest Główną Grupą strony {$_CONF['site_name']} .  Z tego względu prawa dla  tej grupy nie mogą być edytowane.  Poniżej znajduje się lista do-odczytu praw tej grupy.",
    'groupmsg' => 'Grupy Zabezpieczeń Groups w tym serwisie są hierarchiczne.  Poprzez dodanie tej grupy do jakiejkolwiek grupy poniżej, tym samym nadasz tej grupie takie same prawa.  Jeżeli to możliwe to zalecamy wykorzystanie poniższych grup przy nadawaniu praw jakiejkolwiek grupie.  Jeśli chcesz nadać tej grupie specjalne prawa, możesz wybrać uprawnienia do różnych funkcji serwisu w poniższej sekcji \'Uprawnienia\'.  Aby dodać tą grupę do którejkolwiek z poniższej listy, zaznacz po prostu wybraną grupę(y).',
    'coregroupmsg' => "To jest Grupa główna serisu {$_CONF['site_name']}.  Z tego względu grupy należące do tej kategorii nie mogą być edytowane.  Poniżej znajduje się lista, tylko do odczytu, grup z tej kategorii.",
    'rightsdescr' => 'Dostęp grupowy to wybranych uprawnień poniżej może być nadany bezpośrednio danej grupie LUB innej grupie, do której dana grupa należy.  Te z listy poniżej bez pola wyboru oznaczają uprawnienia tej grupy wynikające z faktu przynależności do grupy z danym uprawnieniem.  Uprawnienia z polami wyboru mogą zostać bezpośrednio nadane danej grupie.',
    'lock' => 'Blokada',
    'members' => 'Członkowie',
    'anonymous' => 'Anonim',
    'permissions' => 'Uprawnienia',
    'permissionskey' => 'R = odczyt, E = edycja, prawa do edycji zakładają prawa do odczytu',
    'edit' => 'Edycja',
    'none' => 'Brak',
    'accessdenied' => 'Odmowa Dostępu',
    'storydenialmsg' => "Brak dostępu do tego artykułu.  Prawdopodobnie nie jesteś członkiem serwisu {$_CONF['site_name']}.  Zapraszamy do <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\"> członkostwa</a> w serwisie {$_CONF['site_name']} aby otrzymać pełny dostęp!",
    'nogroupsforcoregroup' => 'Grupa nie należy do pozostałych grup',
    'grouphasnorights' => 'Grupa nie ma dostępu do żadnych funkcji administracyjnych tego serwisu',
    'newgroup' => 'Nowa Grupa',
    'adminhome' => 'Panel Sterowania',
    'save' => 'zapisz',
    'cancel' => 'anuluj',
    'delete' => 'kasuj',
    'canteditroot' => 'Wystąpiła próba edycji grupy Głównej. Niestety nie należysz do żadnej z grup Głównych dlatego nie masz dostępu do tej grupy.  Skontaktuj się z administratorem systemu jeśli uważasz, że to pomyłka',
    'listusers' => 'Listuj Użytkowników',
    'listthem' => 'listuj',
    'usersingroup' => 'Użytkownicy w grupie %s',
    'usergroupadmin' => 'Administracja Grupami Użytkowników',
    'add' => 'Dodaj',
    'remove' => 'Usuń',
    'availmembers' => 'Dostępni Członkowie',
    'groupmembers' => 'Członkowie Grupy',
    'canteditgroup' => 'Aby wyedytować tą grupę musisz do niej należeć. Proszę skontaktować się z administratorem jeśli uważasz, że nastąpiła pomyłka.',
    'cantlistgroup' => 'Aby zobaczyć członków tej grupy, musisz być jej członkiem. Skontaktuj się z administratorem jeśli uważasz, że to jest błąd.',
    'editgroupmsg' => 'To modify the group membership, click on the member names(s) and use the add or remove buttons. If the member is a member of the group, their name will appear on the right side only. Once you are complete - press <b>Save</b> to update the group and return to the main group admin page.',
    'listgroupmsg' => 'Listing of all current members in the group: <b>%s</b>',
    'search' => 'Search',
    'submit' => 'Submit',
    'limitresults' => 'Limit Results',
    'group_id' => 'Group ID',
    'plugin_access_denied_msg' => 'You are illegally trying access a plugin administration page.  Please note that all attempts to illegally access this page are logged.',
    'groupexists' => 'Group name already exists',
    'groupexistsmsg' => 'There is already a group with this name. Group names must be unique.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => '10 Kopii Zapasowych',
    'do_backup' => 'Wykonaj Kopię Zapasową',
    'backup_successful' => 'Kopia bazy wykonana pomyślnie.',
    'db_explanation' => 'Aby wykonać nową kopię zapasową twojego systemu, kliknij poniższy przycisk',
    'not_found' => "Niewłaściwa ścieżka lub program archiwizujący nie jest wykonywalny.<br" . XHTML . ">Sprawdź <strong>\$_DB_mysqldump_path</strong> ustawienia w config.php.<br" . XHTML . ">Zmienna jest obecnie ustawiona na: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Wykonanie Kopii Nie Powiodło Się: Rozmiar pliku 0 bajtów',
    'path_not_found' => "{$_CONF['backup_path']} nie istnieje lub nie jest katalogiem",
    'no_access' => "BŁĄD: Katalog {$_CONF['backup_path']} jest niedostępny.",
    'backup_file' => 'Plik kopii',
    'size' => 'Rozmiar',
    'bytes' => 'Bajtów',
    'total_number' => 'Wszystkich kopii bezpieczeństwa: %d',
    'download' => 'Click to download this file',
    'new_backup' => 'New Backup',
    'delete_failure' => 'One or more backup files could not be deleted.',
    'delete_success' => 'Backup file(s) successfully deleted.',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_button' => 'Convert',
    'sorry_no_innodb' => 'Sorry, your version of MySQL does not support InnoDB tables.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_patience' => 'Note: Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Główna',
    2 => 'Kontakt',
    3 => 'Napisz Artykuł',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Statystyka',
    8 => 'Osobiste',
    9 => 'Szukaj',
    10 => 'zaawansowane szukanie',
    11 => 'Directory'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Błąd 404',
    2 => 'Kurcze, wszędzie szukałem ale nie mogę znaleźć <b>%s</b>.',
    3 => "<p>Przykro nam ale dany plik nie istnieje. Sprawdź <a href=\"{$_CONF['site_url']}/search.php\">stronę z wyszukiwarką</a> aby sprawdzić czy można znaleźć co zgubiłeś."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Wymagany jest login',
    2 => 'Sorry, aby wejść na te strony musisz być zalogowany.',
    3 => 'Login',
    4 => 'Nowy Użytkownik'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'from',
    'tracked_on' => 'Tracked on',
    'read_more' => '[read more]',
    'intro_text' => 'Here\'s what others have to say about \'%s\':',
    'no_comments' => 'No trackback comments for this entry.',
    'this_trackback_url' => 'Trackback URL for this entry:',
    'num_comments' => '%d trackback comments',
    'send_trackback' => 'Send Pings',
    'preview' => 'Preview',
    'editor_title' => 'Send trackback comment',
    'trackback_url' => 'Trackback URL',
    'entry_url' => 'Entry URL',
    'entry_title' => 'Entry Title',
    'blog_name' => 'Site Name',
    'excerpt' => 'Excerpt',
    'truncate_warning' => 'Note: The receiving site may truncate your excerpt',
    'button_send' => 'Send',
    'button_preview' => 'Preview',
    'send_error' => 'Error',
    'send_error_details' => 'Error when sending trackback comment:',
    'url_missing' => 'No Entry URL',
    'url_required' => 'Please enter at least a URL for the entry.',
    'target_missing' => 'No Trackback URL',
    'target_required' => 'Please enter a trackback URL',
    'error_socket' => 'Could not open socket.',
    'error_response' => 'Response not understood.',
    'error_unspecified' => 'Unspecified error.',
    'select_url' => 'Select Trackback URL',
    'not_found' => 'Trackback URL not found',
    'autodetect_failed' => 'Geeklog could not detect the Trackback URL for the post you want to send your comment to. Please enter it manually below.',
    'trackback_explain' => 'From the links below, please select the URL you want to send your Trackback comment to. Geeklog will then try to determine the correct Trackback URL for that post. Or you can <a href="%s">enter it manually</a> if you know it already.',
    'no_links_trackback' => 'No links found. You can not send a Trackback comment for this entry.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback results',
    'send_pings' => 'Send Pings',
    'send_pings_for' => 'Send Pings for "%s"',
    'no_links_pingback' => 'No links found. No Pingbacks were sent for this entry.',
    'pingback_success' => 'Pingback sent.',
    'no_pingback_url' => 'No pingback URL found.',
    'resend' => 'Resend',
    'ping_all_explain' => 'You can now notify the sites you linked to (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), advertise that your site has been updated by pinging weblog directory services, or send a <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> comment in case you wrote about a post on someone else\'s site.',
    'pingback_button' => 'Send Pingback',
    'pingback_short' => 'Send Pingbacks to all sites linked from this entry.',
    'pingback_disabled' => '(Pingback disabled)',
    'ping_button' => 'Send Ping',
    'ping_short' => 'Ping weblog directory services.',
    'ping_disabled' => '(Ping disabled)',
    'trackback_button' => 'Send Trackback',
    'trackback_short' => 'Send a Trackback comment.',
    'trackback_disabled' => '(Trackback disabled)',
    'may_take_a_while' => 'Please note that sending Pingbacks and Pings may take a while.',
    'ping_results' => 'Ping results',
    'unknown_method' => 'Unknown ping method',
    'ping_success' => 'Ping sent.',
    'error_site_name' => 'Please enter the site\'s name.',
    'error_site_url' => 'Please enter the site\'s URL.',
    'error_ping_url' => 'Please enter a valid Ping URL.',
    'no_services' => 'No weblog directory services configured.',
    'services_headline' => 'Weblog Directory Services',
    'service_explain' => 'To modify or delete a weblog directory service, click on the edit icon of that service below. To add a new weblog directory service, click on "Create New" above.',
    'service' => 'Service',
    'ping_method' => 'Ping method',
    'service_website' => 'Website',
    'service_ping_url' => 'URL to ping',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Extended Ping',
    'ping_unknown' => '(unknown method)',
    'edit_service' => 'Edit Weblog Directory Service',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Prepare your trackback comment for <a href="%s">%s</a>.',
    'editor_intro_none' => 'Prepare your trackback comment.',
    'trackback_note' => 'To send a trackback comment for a story, go to the list of stories and click on "Send Ping" for the story. To send a trackback that is not related to a story, <a href="%s">click here</a>.',
    'pingback_explain' => 'Enter a URL to send the Pingback to. The pingback will point to your site\'s homepage.',
    'pingback_url' => 'Pingback URL',
    'site_url' => 'This site\'s URL',
    'pingback_note' => 'To send a pingback for a story, go to the list of stories and click on "Send Ping" for the story. To send a pingback that is not related to a story, <a href="%s">click here</a>.',
    'pbtarget_missing' => 'No Pingback URL',
    'pbtarget_required' => 'Please enter a pingback URL',
    'pb_error_details' => 'Error when sending the pingback:',
    'delete_trackback' => 'To delete this Trackback click: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Article Directory',
    'title_year' => 'Article Directory for %d',
    'title_month_year' => 'Article Directory for %s %d',
    'nav_top' => 'Back to Article Directory',
    'no_articles' => 'No articles.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n new %i in the last %t %s',
    'new_last' => 'last %t %s',
    'minutes' => 'minutes',
    'hours' => 'hours',
    'days' => 'days',
    'weeks' => 'weeks',
    'months' => 'months',
    'years' => 'years',
    'minute' => 'minute',
    'hour' => 'hour',
    'day' => 'day',
    'week' => 'week',
    'month' => 'month',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Styczeń',
    2 => 'Luty',
    3 => 'Marzec',
    4 => 'Kwiecień',
    5 => 'Maj',
    6 => 'Czerwiec',
    7 => 'Lipiec',
    8 => 'Sierpień',
    9 => 'Wrzesień',
    10 => 'Październik',
    11 => 'Listopad',
    12 => 'Grudzień'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Niedziela',
    2 => 'Poniedziałek',
    3 => 'Wtorek',
    4 => 'Środa',
    5 => 'Czwartek',
    6 => 'Piątek',
    7 => 'Sobota'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Search',
    'limit_results' => 'Limit Results',
    'submit' => 'Submit',
    'edit' => 'Edit',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Admin Home',
    'create_new' => 'Create New',
    'create_new_adv' => 'Create New (Adv.)',
    'enabled' => 'Enabled',
    'disabled' => 'Disabled',
    'title' => 'Title',
    'page_title' => 'Page Title',
    'type' => 'Type',
    'topic' => 'Topic',
    'info' => 'Info',
    'help_url' => 'Help File URL',
    'save' => 'Save',
    'cancel' => 'Cancel',
    'install' => 'Install',
    'delete' => 'Delete',
    'deleteitem' => 'Delete',
    'delete_sel' => 'Delete selected',
    'copy' => 'Copy',
    'no_results' => '- No entries found -',
    'data_error' => 'There was an error processing the subscription data. Please check the data source.',
    'preview' => 'Preview',
    'records_found' => 'Records found',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'authenticate' => 'Authenticate'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Comments Enabled',
    -1 => 'Comments Disabled',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => 'Flat',
    'nested' => 'Nested',
    'threaded' => 'Threaded',
    'nocomment' => 'No Comments'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 Hour',
    7200 => '2 Hours',
    10800 => '3 Hours',
    28800 => '8 Hours',
    86400 => '1 Day',
    604800 => '1 Week',
    2678400 => '1 Month'
);

$LANG_dateformats = array(
    0 => 'System Default'
);

$LANG_featurecodes = array(
    0 => 'Not Featured',
    1 => 'Featured'
);

$LANG_frontpagecodes = array(
    0 => 'Show Only in Topic',
    1 => 'Show on Front Page'
);

$LANG_postmodes = array(
    'plaintext' => 'Plain Old Text',
    'html' => 'HTML Formatted'
);

$LANG_sortcodes = array(
    'ASC' => 'Oldest First',
    'DESC' => 'Newest First'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback Enabled',
    -1 => 'Trackback Disabled'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Zapisz zmiany',
    'reset_form' => 'Resetuj zmiany',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Menadżer ustawień',
    'disable' => 'Kliknij aby wyłączyć tą opcję',
    'enable' => 'Enable',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Search Configuration',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Konfiguracja Geeklog-a'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'Ścieżka HTML',
    'site_url' => 'Adres URL',
    'site_admin_url' => 'Adres panelu administracyjnego',
    'site_mail' => 'E-Mail strony',
    'noreply_mail' => 'E-Mail w jedną stronę',
    'mail_cc_enabled' => 'Allow to Send Carbon Copies',
    'mail_cc_default' => '"Carbon Copy" on by Default',
    'site_name' => 'Nazwa strony',
    'site_slogan' => 'Slogan',
    'owner_name' => 'Owner Name',
    'microsummary_short' => 'Mikro streszczenie',
    'path_log' => 'Log',
    'path_language' => 'Język',
    'backup_path' => 'Kopia zapasowa',
    'path_data' => 'Dane',
    'path_images' => 'Zdjęcia',
    'path_pear' => 'Ścieżka do Pear',
    'have_pear' => 'Czy jest biblioteka Pear?',
    'mail_settings' => 'Ustawienia poczty',
    'allow_mysqldump' => 'Zezwalaj na zrzut MySQL',
    'mysqldump_path' => 'Ścieżka do plików wykonawczych',
    'mysqldump_options' => 'Opcje zrzutu MySQL',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => 'Layout',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Elementy Menu',
    'path_themes' => 'Ścieżka do katalogu z layoutami',
    'disable_new_user_registration' => 'Wyłącz rejestrację nowych użytkowników',
    'allow_user_themes' => 'Użytkownik może zmieniać layout',
    'allow_user_language' => 'Użytkownik może zmieniać język',
    'allow_user_photo' => 'Użytkownik może dodać swoje zdjęcie',
    'allow_username_change' => 'Użytkownik może zmienić nazwę konta',
    'allow_account_delete' => 'Użytkownik może usunąć swoje',
    'hide_author_exclusion' => 'Zezwalaj na ukrycie autora',
    'show_fullname' => 'Pokaż pełną nazwę użytkwonika',
    'show_servicename' => 'Pokazuj nazwę usługi',
    'custom_registration' => 'Włącz własną rejestrację',
    'user_login_method' => 'Metoda logowania użytkownika',
    'facebook_login' => 'Enable OAuth Login Method Facebook',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'Enable OAuth Login Method LinkedIn',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Enable OAuth Login Method Twitter',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'spamx' => 'Spam-X ustawienia',
    'sort_admin' => 'Sortowanie odnośników',
    'language' => 'Język',
    'locale' => 'Opcje regionalne',
    'date' => 'Format Daty',
    'daytime' => 'Format daty dziennej',
    'shortdate' => 'Format daty krótkiej',
    'dateonly' => 'Tylko data - format',
    'timeonly' => 'Tylko godzina - format',
    'week_start' => 'Początek Tygodnia',
    'hour_mode' => 'Tryb godzinowy',
    'thousand_separator' => 'Separator tysięczny',
    'decimal_separator' => 'Separator dziesiętny',
    'decimal_count' => 'Liczenie dziesiętne',
    'language_files' => 'Pliki językowe',
    'languages' => 'Języki',
    'timezone' => 'Strefa czasowa',
    'site_disabled_msg' => 'Komunikat lub odnośnik podczas wyłączenia strony',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Nazwa ciasteczka sesji',
    'cookie_name' => 'Nazwa ciasteczka stałego',
    'cookie_password' => 'Nazwa ciasteczka z hasłem',
    'cookie_theme' => 'Nazwa ciasteczka layoutu',
    'cookie_language' => 'Nazwa ciasteczka językowego',
    'cookie_tzid' => 'Nazwa ciasteczka strefy czasowej',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Czy ciasteczko ma zawierać adres IP?',
    'default_perm_cookie_timeout' => 'Stałe wygaśnięcie',
    'session_cookie_timeout' => 'Wygaśnięcie sesji',
    'cookie_path' => 'Ścieżka ciasteczek',
    'cookiedomain' => 'Domena ciasteczek',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Zarejestrować ostatnie logowanie?',
    'num_search_results' => 'Liczba wyników z wyszukiwarki',
    'loginrequired' => 'Wymagane zalogowanie?',
    'submitloginrequired' => 'Wymagane zalogowanie do przesłania materiałów?',
    'commentsloginrequired' => 'Wymagane zalogowanie do skomentowania?',
    'statsloginrequired' => 'Wymagane zalogowanie do przeglądania statystyk?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Story Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Story Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Stories?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'wikitext_editor' => 'Wikitext Editor?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Story Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Stories',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Stories Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Stories',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Maks. liczba zdjęć w artykule',
    'limitnews' => 'Liczba artykułów na stronę',
    'minnews' => 'Min. liczba artykułów na stronę',
    'contributedbyline' => 'Pokaż "Autor"?"',
    'hideviewscount' => 'Ukryj liczbę odsłon?',
    'hideemailicon' => 'Ukryj ikonę emaila?',
    'hideprintericon' => 'Ukryj ikonę drukowania?',
    'allow_page_breaks' => 'Zezwalaj na łamanie stron?',
    'page_break_comments' => 'Komentarze dla artykułów wielostronicowych',
    'article_image_align' => 'Wyrównywanie ikon sekcji',
    'show_topic_icon' => 'Pokaż ikonę sekcji?',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'Po zapisaniu artykułu',
    'aftersave_user' => 'Po zapisaniu użytkownika',
    'show_right_blocks' => 'Zawsze pokazuj prawe bloki?',
    'showfirstasfeatured' => 'Pokaż pierwszy artykuł jako Artykuł Dnia?',
    'backend' => 'Włącz kanały RSS?',
    'rdf_file' => 'Katalog z plikami do syndykacji treści',
    'rdf_limit' => 'Limit kanałów RSS',
    'rdf_storytext' => 'Długość artykułu w pliku RSS',
    'rdf_language' => 'Język kanału RSS',
    'syndication_max_headlines' => 'Maks. liczba tytułów (bloki portalowe)',
    'comment_feeds_article_tag' => 'Article Tag',
    'comment_feeds_article_tag_position' => 'Article Tag Position',
    'comment_feeds_article_author_tag' => 'Article Author Tag',
    'comment_feeds_comment_author_tag' => 'Comment Author Tag',
    'copyrightyear' => 'Prawa Autorskie Rok',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_code' => 'Comment Default',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'pass_alg' => 'Password Hash Algorithm',
    'pass_stretch' => 'Hash Stretch Count',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autotags?',
    'clickable_links' => 'Make URLs clickable?',
    'linktext_maxlen' => 'Max Link Text Length',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'page_navigation_max_pages' => 'Max Pages for Navigation',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Włącz przyjazne adresy URL',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Story Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Stories in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent stories enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'comment_on_same_page' => 'Comment on Same Page?',
    'show_comments_at_replying' => 'Show Comments at Replying?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order',
    'autotag_permissions_story' => '[story: ] Permissions',
    'autotag_permissions_user' => '[user: ] Permissions',
    'multiple_breadcrumbs' => 'Multiple Breadcrumbs',
    'disable_breadcrumbs_topics' => 'Disable Topic Breadcrumbs',
    'disable_breadcrumbs_articles' => 'Disable Article Breadcrumbs',
    'disable_breadcrumbs_plugins' => 'Disable Plugins Breadcrumbs',
    'breadcrumb_root_site_name' => 'Site Name as Breadcrumb Root?'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Strona',
    'sg_stories' => 'Artykuły i Powiadomienia Zwrotne',
    'sg_theme' => 'Layout',
    'sg_blocks' => 'Bloki',
    'sg_users' => 'Użytkownicy i Przesłane materiały',
    'sg_images' => 'Zdjęcia',
    'sg_locale' => 'Języki i Ustawienia regionalne',
    'sg_misc' => 'Różne'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Strona',
    'fs_paths' => 'Ścieżki',
    'fs_theme' => 'Layout',
    'fs_mail' => 'Poczta',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Użytkownicy',
    'fs_misc' => 'Różne',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Ustawienia regionalne',
    'fs_language' => 'Język',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Ciasteczka',
    'fs_login' => 'Ustawienia logowania',
    'fs_search' => 'Szukaj',
    'fs_user_submission' => 'Materiały użytkowników',
    'fs_submission' => 'Ustawienia przesyłania materiałów',
    'fs_topics_block' => 'Blok sekcji',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'Nowości',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Artykuł',
    'fs_theme_advanced' => 'Ustawienia zaawansowane',
    'fs_syndication' => 'Syndykacja treści',
    'fs_syndication_comment' => 'Comment Syndication',
    'fs_imagelib' => 'Katalog zdjęć',
    'fs_upload' => 'Ładuj',
    'fs_articleimg' => 'Zdjęcia w artykułach',
    'fs_topicicon' => 'Ikony sekcji',
    'fs_userphoto' => 'Zdjęcia',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Komentarze',
    'fs_htmlfilter' => 'Filtrowanie HTML',
    'fs_censoring' => 'Cenzura',
    'fs_iplookup' => 'Podgląd IP',
    'fs_perm_story' => 'Domyślne ustawienia dla artykułów',
    'fs_perm_topic' => 'Domyślne ustawienia dla sekcji',
    'fs_perm_block' => 'Domyślne ustawienia dla bloków',
    'fs_webservices' => 'Usługi WWW',
    'fs_autotag_permissions' => 'Autotag Usage Permissions',
    'fs_breadcrumbs' => 'Breadcrumbs',
    'fs_pass' => 'Password Settings'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Paths',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_pear' => 'Pear',
    'tab_mysql' => 'MySQL',
    'tab_users' => 'Users',
    'tab_misc' => 'Miscellaneous',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin Block',
    'tab_locale' => 'Locale',
    'tab_language' => 'Language',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Login Settings',
    'tab_search' => 'Search',
    'tab_user_submission' => 'User Submission',
    'tab_submission' => 'Submission Settings',
    'tab_topics_block' => 'Topics Block',
    'tab_whosonline_block' => 'Who\'s Online Block',
    'tab_daily_digest' => 'Daily Digest',
    'tab_whatsnew_block' => 'What\'s New Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Story',
    'tab_theme_advanced' => 'Advanced Settings',
    'tab_syndication' => 'Syndication',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Images in Articles',
    'tab_topicicon' => 'Topic Icons',
    'tab_userphoto' => 'Photos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Comments',
    'tab_htmlfilter' => 'HTML Filtering',
    'tab_censoring' => 'Censoring',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Permissions',
    'tab_webservices' => 'Webservices',
    'tab_topics' => 'Topics'
);

$LANG_configselects['Core'] = array(
    0 => array('Tak' => 1, 'Nie' => 0),
    1 => array('Tak' => true, 'Nie' => false),
    2 => array('Odrzuć' => 0, 'Tylko Najnowsze' => 1, 'Zezwalaj na Wiele Postów' => 2),
    3 => array('Trackback Włączony' => 0, 'Trackback Wyłączony' => -1),
    4 => array('Nie sprawdzaj Niczego' => 0, 'Sprawdź wedle adresu strony' => 1, 'Sprawdź cały URL' => 2, 'Sprawdź wedle adresu strony i kompletnego URL' => 3, 'Check IP against Site IP' => 4, 'Sprawdź IP i URL strony' => 5, 'Sprawdź IP i pełny URL' => 6, 'Sprawdź IP, pełny URL, i URL strony' => 7),
    5 => array('Tekst' => 'plaintext', 'HTML' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Ostatnia Strona' => 'last', 'Pierwsza Strona' => 'first', 'Wszystkie Strony' => 'all'),
    8 => array('Prawa' => 'right', 'Lewa' => 'left'),
    9 => array('Idź do strony' => 'item', 'Pokaż listę' => 'list', 'Pokaż stronę główną' => 'home', 'Pokaż panel sterowania' => 'admin'),
    10 => array('Brak' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Lista' => 'flat', 'Chronologicznie' => 'nested', 'Wg wątku' => 'threaded', 'Bez komentarzy' => 'nocomment'),
    12 => array('Brak dostępu' => 0, 'Tylko do Odczytu' => 2, 'Odczyt-Zapis' => 3),
    13 => array('Pomiń' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Niedziela' => 'Sun', 'Poniedziałek' => 'Mon'),
    15 => array('Liczbowo' => 'sortnum', 'Alfabetycznie' => 'alpha'),
    16 => array('Login nie wymagany' => 0, 'Tylko wyszukiwanie zaawansowane' => 1, 'Wyszukiwanie proste + zaawansowane' => 2),
    17 => array('Komentarze włączone' => 0, 'Komentarze wyłączone' => -1),
    18 => array('Wyłączone' => 0, 'Włączone (Dokładne trafienie)' => 1, 'Włączone (Początek słowa)' => 2, 'Włączone (Fragment słowa)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Stories' => 'story', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none')
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'yearOrRange' => 'This field must be in a year format such as 2010 or range like 2010 - 2012',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character',
    'page_navigation_max_pages' => 'This field must be between 2 - 21',
    'hash' => 'This field must be a hash function supported by your version of PHP'
);


?>
