<?php
//
// +---------------------------------------------------------------------------+
// | Japanese Mail Plugin for Geeklog - The Ultimate Weblog                    |
// +---------------------------------------------------------------------------+
// | config.php                                                                |
// +---------------------------------------------------------------------------+
// | Copyright (C) 2007 mystral-kk - geeklog AT mystral-k DOT net              |
// | Constructed with the Universal Plugin                                     |
// +---------------------------------------------------------------------------+
// |                                                                           |
// | This program is free software; you can redistribute it and/or             |
// | modify it under the terms of the GNU General Public License               |
// | as published by the Free Software Foundation; either version 2            |
// | of the License, or (at your option) any later version.                    |
// |                                                                           |
// | This program is distributed in the hope that it will be useful,           |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of            |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
// | GNU General Public License for more details.                              |
// |                                                                           |
// | You should have received a copy of the GNU General Public License         |
// | along with this program; if not, write to the Free Software Foundation,   |
// | Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           |
// |                                                                           |
// +---------------------------------------------------------------------------+
//

global $_DB_table_prefix, $_TABLES;

// Sets plugin table Prefix the same as Geeklog's

$_JPML_table_prefix = $_DB_table_prefix;

// Adds to $_TABLES array the tables your plugin uses

$_TABLES[ 'jpml_rules' ] = $_JPML_table_prefix . 'jpml_rules';

$_JPML_CONF = array();

// Plugin info

$_JPML_CONF['pi_version'] = '0.1.3';					// Plugin Version
$_JPML_CONF['gl_version'] = '1.4.1';					// GL Version plugin for
$_JPML_CONF['pi_url']     = 'http://mystral-kk.net/';	// Plugin Homepage

// Supported charsets

$_JPML_CONF['charsets'] = array (
	'--', 'ASCII', 'EUC-JP', 'ISO-2022-JP', 'ISO-8859-1', 'JIS', 'SJIS',
	'SJIS-win', 'UTF-8',
);

// Supported encodings

$_JPML_CONF['encodings'] = array (
	array ( 'name' => '',                 'value' => '' ),
	array ( 'name' => 'Base64',           'value' => 'B' ),
	array ( 'name' => 'Quoted Printable', 'value' => 'Q' ),
);

// Default rule if there is no matching one

$_JPML_CONF['default_rule'] = array (
	'id' => 0, 'rule' => '/.*/',
	'header_charset' => 'ISO-2022-JP', 'header_encoding' => 'B',
	'body_charset'   => 'ISO-2022-JP', 'body_encoding'   => ''
);

//=============================================================================
//  DO NOT EDIT THE ABOVE LINES UNLESS YOU KNOW WHAT YOU ARE DOING!
//=============================================================================

// Length of one line in headers

$_JPML_CONF['header_line_length'] = 65;

// Length of one line in body

$_JPML_CONF['body_line_length'] = 1020;

// Line-break characters in headers

$_JPML_CONF['header_linebreak'] = "\r\n";

// Line-break characters in message body

$_JPML_CONF['body_linebreak'] = substr( PHP_OS, 0, 3 ) == 'WIN' ? "\r\n" : "\n";

// Whether to detect the encoding of a given string.  In most cases, 'default' will
// do.  When characters are broken, it'll help to use 'auto' or 'encoding_name'.
//
//   'default'      : don't detect; $_CONF['default_charset'] is used instead
//   'auto'         : detect automatically
//   'encoding_name': assume 'encoding_name' to be the 'internal code' of jpmail

$_JPML_CONF['detect_encoding'] = 'auto';

?>