<?php
// functions.php for Revize



// Security measure for forceful browsing -
if (strpos ($_SERVER['PHP_SELF'], 'functions.php') !== false) {
    die ('This file can not be used on its own!');
}
// ----------------------------------------





// Import configuration file
require_once( 'config.php' );





// Setting =====================================================================

// Setting for Geeklog --------------------
$_CONF['show_right_blocks'] = 1;  // Show always sub(right) blocks
$_CONF['left_blocks_in_footer'] = true;  // Show sub(left) blocks in footer template

$g_what = 'menu';
$_IMAGE_TYPE = 'png';
// ----------------------------------------

// Setting for template files -------------
$result = DB_query ("SELECT name FROM {$_TABLES['blocks']} WHERE is_enabled = 1");
$nrows = DB_numRows ($result);
for ($i = 0; $i < $nrows; $i ++) {
    $A = DB_fetchArray ($result);
        if ($A['onleft'] == 1) {
            $_BLOCK_TEMPLATE[$A['name']] = 'blockheader-sub.thtml,blockfooter-sub.thtml';
        } else {
            $_BLOCK_TEMPLATE[$A['name']] = 'blockheader-sub.thtml,blockfooter-sub.thtml';
        }
}

$_BLOCK_TEMPLATE['_msg_block'] = 'blockheader-message.thtml,blockfooter-message.thtml';
$_BLOCK_TEMPLATE['whats_related_block'] = 'blockheader-related.thtml,blockfooter-related.thtml';
$_BLOCK_TEMPLATE['story_options_block'] = 'blockheader-related.thtml,blockfooter-related.thtml';
// ----------------------------------------





// Override lib-common.php functions ==============================================
// Some codes added/changed by Phize(http://geeklog-r.net)
//
// Table Of Contents:
//   *Revize_startBlock
//   *Revize_olderStuff
//   *Revize_whatsNewBlock
//   *Revize_siteHeader
//   *Revize_siteFooter

function Revize_startBlock( $title='', $helpfile='', $template='blockheader.thtml' )
{
    global $_CONF, $LANG01, $_IMAGE_TYPE;

    // Added by Phize <----
    global $_TABLES, $LANG11;
    // Added by Phize ---->

    // Added by Phize <----
    $value_class_help = 'icon help icon-help';
    // Added by Phize ---->

    $block = new Template( $_CONF['path_layout'] );
    $block->set_file( 'block', $template );
    $block->set_var( 'site_url', $_CONF['site_url'] );
    $block->set_var( 'layout_url', $_CONF['layout_url'] );
    $block->set_var( 'block_title', stripslashes( $title ));

    // Added by Phize <----
    if (strtolower($template) == 'blockheader-sub.thtml') {
        $class = DB_getItem( $_TABLES['blocks'] , 'name', "title = '" . $title . "'" );

        if (!empty($class)) {
            $class = $class . ' utility-' . $class;
            $block->set_var( 'attr_class', ' class="' . $class . '"' );
            $block->set_var( 'value_class', ' ' . $class );
        }
    }

    if (strtolower($template) == 'blockheader-related.thtml') {
        if ($title == $LANG11[1]) {
            $block->set_var( 'attr_class', ' class="related"' );
            $block->set_var( 'value_class', 'related' );
        }

        if ($title == $LANG11[4]) {
            $block->set_var( 'attr_class', ' class="option"' );
            $block->set_var( 'value_class', 'option' );
        }
    }
    // Added by Phize ---->

    if( !empty( $helpfile ))
    {
        // Added by Phize <----
        $img_help = $_CONF['layout_url'] . '/images/button_help.' . $_IMAGE_TYPE;
        $img_size = getimagesize($img_help);
        // Added by Phize ---->

        if( !stristr( $helpfile, 'http://' ))
        {
            // Changed by Phize <----
            $help = '<a class="blocktitle" href="' . $_CONF['site_url'] . '/help/' . $helpfile
                . '"><img src="' . $img_help
                . '" ' . $img_size[3] . ' alt="?" class="' . $value_class_help . '"></a>';
            // Changed by Phize ---->
        }
        else
        {
            // Changed by Phize <----
            $help = '<a class="blocktitle" href="' . $helpfile
                . '"><img src="' . $img_help
                . '" ' . $img_size[3] . ' alt="?" class="' . $value_class_help . '"></a>';
            // Changed by Phize ---->
        }

        $block->set_var( 'block_help', $help );
    }

    // Changed by Phize <----
    // Return resulting HTML
    return $block->finish( $block->parse( 'startHTML', 'block' ) );
    // Changed by Phize ---->
}



function Revize_olderStuff()
{
    global $_TABLES, $_CONF;

    $sql = "SELECT sid,tid,title,comments,UNIX_TIMESTAMP(date) AS day FROM {$_TABLES['stories']} WHERE (perm_anon = 2) AND (frontpage = 1) AND (date <= NOW()) AND (draft_flag = 0)" . COM_getTopicSQL( 'AND', 1 ) . " ORDER BY featured DESC, date DESC LIMIT {$_CONF['limitnews']}, {$_CONF['limitnews']}";
    $result = DB_query( $sql );
    $nrows = DB_numRows( $result );

    if( $nrows > 0 )
    {
        $dateonly = $_CONF['dateonly'];
        if( empty( $dateonly ))
        {
            $dateonly = '%d-%b'; // fallback: day - abbrev. month name
        }

        $day = 'noday';
        $string = '';

        for( $i = 0; $i < $nrows; $i++ )
        {
            $A = DB_fetchArray( $result );

            $daycheck = strftime( '%A', $A['day'] );
            if( $day != $daycheck )
            {
                if( $day != 'noday' )
                {
                    // Changed by Phize <----
                    $daylist = '<dd>' . COM_makeList( $oldnews, '' ) . '</dd>';
                    // Changed by Phize ---->

                    $daylist = preg_replace( "/(\015\012)|(\015)|(\012)/",
                                             '', $daylist );

                    // Changed by Phize <----
                    $string .= $daylist;
                    // Changed by Phize ---->
                }

                $day2 = strftime( $dateonly, $A['day'] );

                // Changed by Phize <----
                $string .= '<dt>' . $daycheck . $day2
                        . '</dt>' . LB;
                // Changed by Phize ---->

                $oldnews = array();
                $day = $daycheck;
            }

            $oldnews[] = '<a href="' . COM_buildUrl( $_CONF['site_url']
                . '/article.php?story=' . $A['sid'] ) . '">' . $A['title']
                . '</a> (' . COM_numberFormat( $A['comments'] ) . ')';
        }

        if( !empty( $oldnews ))
        {
            // Changed by Phize <----
            $daylist = '<dd>' . COM_makeList( $oldnews, '' ) . '</dd>';
            // Changed by Phize ---->

            $daylist = preg_replace( "/(\015\012)|(\015)|(\012)/", '', $daylist );
            $string .= $daylist;

            // Added by Phize <----
            $string = '<dl>' . $string . '</dl>';
            // Added by Phize ---->

            $string = addslashes( $string );

            DB_query( "UPDATE {$_TABLES['blocks']} SET content = '$string' WHERE name = 'older_stories'" );
        }
    }
}



function Revize_whatsNewBlock( $help = '', $title = '' )
{
    global $_CONF, $_TABLES, $_USER, $LANG01, $LANG_WHATSNEW, $page, $newstories;

    // Added by Phize <----
    global $LANG_LINKS;
    // Added by Phize ---->

    $retval = COM_startBlock( $title, $help,
                       COM_getBlockTemplate( 'whats_new_block', 'header' ));

    // Added by Phize <----
    $retval .= '<dl>';
    // Added by Phize ---->

    $topicsql = '';
    if(( $_CONF['hidenewstories'] == 0 ) || ( $_CONF['hidenewcomments'] == 0 )
            || ( $_CONF['trackback_enabled']
            && ( $_CONF['hidenewtrackbacks'] == 0 )))
    {
        $topicsql = COM_getTopicSql ('AND', 0, $_TABLES['stories']);
    }

    if( $_CONF['hidenewstories'] == 0 )
    {
        $archsql = '';
        $archivetid = DB_getItem( $_TABLES['topics'], 'tid', "archive_flag=1" );
        if( !empty( $archivetid ))
        {
            $archsql = " AND (tid <> '" . addslashes( $archivetid ) . "')";
        }

        // Find the newest stories
        $sql = "SELECT COUNT(*) AS count FROM {$_TABLES['stories']} WHERE (date >= (date_sub(NOW(), INTERVAL {$_CONF['newstoriesinterval']} SECOND))) AND (date <= NOW()) AND (draft_flag = 0)" . $archsql . COM_getPermSQL( 'AND' ) . $topicsql . COM_getLangSQL( 'sid', 'AND' );
        $result = DB_query( $sql );
        $A = DB_fetchArray( $result );
        $nrows = $A['count'];

        if( empty( $title ))
        {
            $title = DB_getItem( $_TABLES['blocks'], 'title', "name='whats_new_block'" );
        }

        // Any late breaking news stories?
        // Changed by Phize <----
        $retval .= '<dt>' . $LANG01[99] . '</dt>';
        // Changed by Phize ---->

        if( $nrows > 0 )
        {
            $newmsg = COM_formatTimeString( $LANG_WHATSNEW['new_string'],
                        $_CONF['newstoriesinterval'], $LANG01[11], $nrows);

            if( $newstories && ( $page < 2 ))
            {
                // Changed by Phize <----
                $retval .= $newmsg;
                // Changed by Phize ---->
            }
            else
            {
                // Changed by Phize <----
                $retval .= '<dd><a href="' . $_CONF['site_url']
                    . '/index.php?display=new">' . $newmsg . '</a></dd>';
                // Changed by Phize ---->
            }
        }
        else
        {
            // Changed by Phize <----
            $retval .= '<dd><p>' . $LANG01[100] . '</p></dd>';
            // Changed by Phize ---->
        }

        // Changed by Phize <----
        //if(( $_CONF['hidenewcomments'] == 0 ) || ( $_CONF['trackback_enabled']
        //        && ( $_CONF['hidenewtrackbacks'] == 0 ))
        //        || ( $_CONF['hidenewplugins'] == 0 ))
        //{
        //    $retval .= '<br>';
        //}
        // Changed by Phize ---->
    }

    if( $_CONF['hidenewcomments'] == 0 )
    {
        // Go get the newest comments
        // Changed by Phize <----
        $retval .= '<dt>' . $LANG01[83] . COM_formatTimeString( $LANG_WHATSNEW['new_last'],
                                        $_CONF['newcommentsinterval'] )
                . '</dt>';
        // Changed by Phize ---->

        $stwhere = '';

        if( !empty( $_USER['uid'] ))
        {
            $stwhere .= "({$_TABLES['stories']}.owner_id IS NOT NULL AND {$_TABLES['stories']}.perm_owner IS NOT NULL) OR ";
            $stwhere .= "({$_TABLES['stories']}.group_id IS NOT NULL AND {$_TABLES['stories']}.perm_group IS NOT NULL) OR ";
            $stwhere .= "({$_TABLES['stories']}.perm_members IS NOT NULL)";
        }
        else
        {
            $stwhere .= "({$_TABLES['stories']}.perm_anon IS NOT NULL)";
        }
        $sql = "SELECT DISTINCT COUNT(*) AS dups, type, {$_TABLES['stories']}.title, {$_TABLES['stories']}.sid, max({$_TABLES['comments']}.date) AS lastdate FROM {$_TABLES['comments']} LEFT JOIN {$_TABLES['stories']} ON (({$_TABLES['stories']}.sid = {$_TABLES['comments']}.sid)" . COM_getPermSQL( 'AND', 0, 2, $_TABLES['stories'] ) . " AND ({$_TABLES['stories']}.draft_flag = 0) AND ({$_TABLES['stories']}.commentcode = 0)" . $topicsql . COM_getLangSQL( 'sid', 'AND', $_TABLES['stories'] ) . ") WHERE ({$_TABLES['comments']}.date >= (DATE_SUB(NOW(), INTERVAL {$_CONF['newcommentsinterval']} SECOND))) AND ((({$stwhere}))) GROUP BY {$_TABLES['comments']}.sid,type, {$_TABLES['stories']}.title, {$_TABLES['stories']}.title, {$_TABLES['stories']}.sid ORDER BY 5 DESC LIMIT 15";

        $result = DB_query( $sql );

        $nrows = DB_numRows( $result );

        if( $nrows > 0 )
        {
            $newcomments = array();

            for( $x = 0; $x < $nrows; $x++ )
            {
                $A = DB_fetchArray( $result );

                if(( $A['type'] == 'article' ) || empty( $A['type'] ))
                {
                    $urlstart = '<a href="' . COM_buildUrl( $_CONF['site_url']
                        . '/article.php?story=' . $A['sid'] ) . '#comments' . '"';
                }

                $title = COM_undoSpecialChars( stripslashes( $A['title'] ));
                $titletouse = COM_truncate( $title, $_CONF['title_trim_length'],
                                            '...' );

                if( $title != $titletouse )
                {
                    $urlstart .= ' title="' . htmlspecialchars( $title ) . '">';
                }
                else
                {
                    $urlstart .= '>';
                }

                $acomment = str_replace( '$', '&#36;', $titletouse );
                $acomment = str_replace( ' ', '&nbsp;', $acomment );

                if( $A['dups'] > 1 )
                {
                    $acomment .= ' [+' . $A['dups'] . ']';
                }

                $newcomments[] = $urlstart . $acomment . '</a>';
            }

            // Changed by Phize <----
            $retval .= '<dd>' . COM_makeList( $newcomments, '' ) . '</dd>';
            // Changed by Phize ---->
        }
        else
        {
            // Changed by Phize <----
            $retval .= '<dd><p>' . $LANG01[86] . '</p></dd>' . LB;
            // Changed by Phize ---->
        }

        // Changed by Phize <----
        //if(( $_CONF['hidenewplugins'] == 0 )
        //        || ( $_CONF['trackback_enabled']
        //        && ( $_CONF['hidenewtrackbacks'] == 0 )))
        //{
        //    $retval .= '<br>';
        //}
        // Changed by Phize ---->
    }

    if( $_CONF['trackback_enabled'] && ( $_CONF['hidenewtrackbacks'] == 0 ))
    {
        // Changed by Phize <----
        $retval .= '<dt>' . $LANG01[114]
                . COM_formatTimeString( $LANG_WHATSNEW['new_last'],
                                        $_CONF['newtrackbackinterval'] )
                . '</dt>';
        // Changed by Phize ---->

        $sql = "SELECT DISTINCT COUNT(*) AS count,{$_TABLES['stories']}.title,t.sid,max(t.date) AS lastdate FROM {$_TABLES['trackback']} AS t,{$_TABLES['stories']} WHERE (t.type = 'article') AND (t.sid = {$_TABLES['stories']}.sid) AND (t.date >= (DATE_SUB(NOW(), INTERVAL {$_CONF['newtrackbackinterval']} SECOND)))" . COM_getPermSQL( 'AND', 0, 2, $_TABLES['stories'] ) . " AND ({$_TABLES['stories']}.draft_flag = 0) AND ({$_TABLES['stories']}.trackbackcode = 0)" . $topicsql . COM_getLangSQL( 'sid', 'AND', $_TABLES['stories'] ) . " GROUP BY t.sid, {$_TABLES['stories']}.title ORDER BY lastdate DESC LIMIT 15";
        $result = DB_query( $sql );

        $nrows = DB_numRows( $result );
        if( $nrows > 0 )
        {
            $newcomments = array();

            for( $i = 0; $i < $nrows; $i++ )
            {
                $A = DB_fetchArray( $result );

                $urlstart = '<a href="' . COM_buildUrl( $_CONF['site_url']
                    . '/article.php?story=' . $A['sid'] ) . '#trackback' . '"';

                $title = COM_undoSpecialChars( stripslashes( $A['title'] ));
                $titletouse = COM_truncate( $title, $_CONF['title_trim_length'],
                                            '...' );

                if( $title != $titletouse )
                {
                    $urlstart .= ' title="' . htmlspecialchars( $title ) . '">';
                }
                else
                {
                    $urlstart .= '>';
                }

                $acomment = str_replace( '$', '&#36;', $titletouse );
                $acomment = str_replace( ' ', '&nbsp;', $acomment );

                if( $A['count'] > 1 )
                {
                    $acomment .= ' [+' . $A['count'] . ']';
                }

                $newcomments[] = $urlstart . $acomment . '</a>';

            }

            // Changed by Phize <----
            $retval .= '<dd>' . COM_makeList( $newcomments, '' ) . '</dd>';
            // Changed by Phize ---->
        }
        else
        {
        // Changed by Phize <----
            $retval .= '<dd><p>' . $LANG01[115] . '</p></dd>' . LB;
        // Changed by Phize ---->
        }

        // Changed by Phize <----
        //if( $_CONF['hidenewplugins'] == 0 )
        //{
        //    $retval .= '<br>';
        //}
        // Changed by Phize ---->
    }

    if( $_CONF['hidenewplugins'] == 0 )
    {
        list( $headlines, $smallheadlines, $content ) = PLG_getWhatsNew();
        $plugins = sizeof( $headlines );
        if( $plugins > 0 )
        {
            for( $i = 0; $i < $plugins; $i++ )
            {
                // Changed by Phize <----
                $retval .= '<dt>' . $headlines[$i]
                        . $smallheadlines[$i] . '</dt>';
                // Changed by Phize ---->

                if( is_array( $content[$i] ))
                {
                    // Changed by Phize <----
                    $retval .= '<dd>' . COM_makeList( $content[$i], '' ) . '</dd>';
                    // Changed by Phize ---->
                }
                else
                {
                    // Changed by Phize <----
                    if( $content[$i] != ($LANG_LINKS[88] . LB) )
                    {
                        $retval .= '<dd>' . preg_replace('/\sclass="[^"]*"/i', '', $content[$i]) . '</dd>';
                    }
                    // Changed by Phize ---->
                }

                // Changed by Phize <----
                //if( $i + 1 < $plugins )
                //{
                //    $retval .= '<br>';
                //}
                // Changed by Phize ---->
            }
        }
    }

    // Added by Phize <----
    $retval .= '</dl>';
    // Added by Phize ---->

    $retval .= COM_endBlock( COM_getBlockTemplate( 'whats_new_block', 'footer' ));

    return $retval;
}



function Revize_siteHeader( $what = 'menu', $pagetitle = '', $headercode = '' )
{
    global $_CONF, $_TABLES, $_USER, $LANG01, $LANG_BUTTONS, $LANG_CHARSET,
           $LANG_DIRECTION, $_IMAGE_TYPE, $topic, $_COM_VERBOSE;

    // Added by Phize <----
    global $g_what, $_USER;

    $attr_class_first = ' class="first"';
    $attr_class_last = ' class="last"';
    $value_class_first = ' first';
    $value_class_last = ' last';
    // Added by Phize ---->

    $g_what = $what;

    // send out the charset header

    if( empty( $LANG_CHARSET )) {
        $charset = $_CONF['default_charset'];
        if( empty( $charset )) {
            $charset = 'iso-8859-1';
        }
    } else {
        $charset = $LANG_CHARSET;
    }
    header ('Content-Type: text/html; charset=' . $charset);

    // If we reach here then either we have the default theme OR
    // the current theme only needs the default variable substitutions

    $header = new Template( $_CONF['path_layout'] );
    $header->set_file( array(
        'header'        => 'header.thtml',
        'menuitem'      => 'menuitem.thtml',

        // Changed by Phize <----
        'menuitem_last' => 'menuitem.thtml',
        'menuitem_none' => 'menuitem.thtml',
        'leftblocks'    => 'blocks_1.thtml'
        // Changed by Phize ---->
        ));

    // get topic if not on home page
    if( !isset( $_GET['topic'] ))
    {
        if( isset( $_GET['story'] ))
        {
            $sid = COM_applyFilter( $_GET['story'] );
        }
        elseif( isset( $_GET['sid'] ))
        {
            $sid = COM_applyFilter( $_GET['sid'] );
        }
        elseif( isset( $_POST['story'] ))
        {
            $sid = COM_applyFilter( $_POST['story'] );
        }
        if( empty( $sid ) && $_CONF['url_rewrite'] &&
                ( strpos( $_SERVER['PHP_SELF'], 'article.php' ) !== false ))
        {
            COM_setArgNames( array( 'story', 'mode' ));
            $sid = COM_applyFilter( COM_getArgument( 'story' ));
        }
        if( !empty( $sid ))
        {
            $topic = DB_getItem( $_TABLES['stories'], 'tid', "sid='$sid'" );
        }
    }
    else
    {
        $topic = COM_applyFilter( $_GET['topic'] );
    }

    $feed_url = array();
    if( $_CONF['backend'] == 1 ) // add feed-link to header if applicable
    {
        $baseurl = SYND_getFeedUrl();

        $sql = 'SELECT format, filename, title, language FROM '
             . $_TABLES['syndication'] . " WHERE (header_tid = 'all')";
        if( !empty( $topic ))
        {
            $sql .= " OR (header_tid = '" . addslashes( $topic ) . "')";
        }
        $result = DB_query( $sql );
        $numRows = DB_numRows( $result );
        for( $i = 0; $i < $numRows; $i++ )
        {
            $A = DB_fetchArray( $result );
            if ( !empty( $A['filename'] ))
            {
                $format = explode( '-', $A['format'] );
                $format_type = strtolower( $format[0] );
                $format_name = ucwords( $format[0] );

                $feed_url[] = '<link rel="alternate" type="application/'
                          . $format_type . '+xml" hreflang="' . $A['language']
                          . '" href="' . $baseurl . $A['filename'] . '" title="'
                          . $format_name . ' Feed: ' . $A['title'] . '">';
            }
        }
    }
    $header->set_var( 'feed_url', implode( LB, $feed_url ));

    $relLinks = array();
    if( !COM_onFrontpage() )
    {
        $relLinks['home'] = '<link rel="home" href="' . $_CONF['site_url']
                          . '/" title="' . $LANG01[90] . '">';
    }
    $loggedInUser = ( isset( $_USER['uid'] ) && ( $_USER['uid'] > 1 ));
    if( $loggedInUser || (( $_CONF['loginrequired'] == 0 ) &&
                ( $_CONF['searchloginrequired'] == 0 )))
    {
        if(( substr( $_SERVER['PHP_SELF'], -strlen( '/search.php' ))
                != '/search.php' ) || isset( $_GET['mode'] ))
        {
            $relLinks['search'] = '<link rel="search" href="'
                                . $_CONF['site_url'] . '/search.php" title="'
                                . $LANG01[75] . '">';
        }
    }
    if( $loggedInUser || (( $_CONF['loginrequired'] == 0 ) &&
                ( $_CONF['directoryloginrequired'] == 0 )))
    {
        if( strpos( $_SERVER['PHP_SELF'], '/article.php' ) !== false ) {
            $relLinks['contents'] = '<link rel="contents" href="'
                        . $_CONF['site_url'] . '/directory.php" title="'
                        . $LANG01[117] . '">';
        }
    }
    // TBD: add a plugin API and a lib-custom.php function
    $header->set_var( 'rel_links', implode( LB, $relLinks ));

    if( empty( $pagetitle ) && isset( $_CONF['pagetitle'] ))
    {
        $pagetitle = $_CONF['pagetitle'];
    }
    if( empty( $pagetitle ))
    {
        if( empty( $topic ))
        {
            $pagetitle = $_CONF['site_slogan'];
        }
        else
        {
            $pagetitle = stripslashes( DB_getItem( $_TABLES['topics'], 'topic',
                                                   "tid = '$topic'" ));
        }
    }
    if( !empty( $pagetitle ))
    {
        $pagetitle = ' - ' . $pagetitle;
    }
    $header->set_var( 'page_title', $_CONF['site_name'] . $pagetitle );

    if( isset( $_CONF['advanced_editor'] ) && ( $_CONF['advanced_editor'] == 1 )
            && file_exists( $_CONF['path_layout']
                            . 'advanced_editor_header.thtml' ))
    {
        $header->set_file( 'editor'  , 'advanced_editor_header.thtml');
        $header->parse( 'advanced_editor', 'editor' );

    }
    else
    {
         $header->set_var( 'advanced_editor', '' );
    }

    $langAttr = '';
    if( isset( $_CONF['languages'] ) && isset( $_CONF['language_files'] ))
    {
        $langId = COM_getLanguageId();
    }
    else
    {
        // try to derive the language id from the locale
        $l = explode( '.', $_CONF['locale'] );
        $langId = $l[0];
    }
    if( !empty( $langId ))
    {
        $l = explode( '-', str_replace( '_', '-', $langId ));
        if(( count( $l ) == 1 ) && ( strlen( $langId ) == 2 ))
        {
            $langAttr = 'lang="' . $langId . '"';
        }
        else if( count( $l ) == 2 )
        {
            if(( $l[0] == 'i' ) || ( $l[0] == 'x' ))
            {
                $langId = implode( '-', $l );
                $langAttr = 'lang="' . $langId . '"';
            }
            else if( strlen( $l[0] ) == 2 )
            {
                $langId = implode( '-', $l );
                $langAttr = 'lang="' . $langId . '"';
            }
            else
            {
                $langId = $l[0];
            }
        }
    }
    $header->set_var( 'lang_id', $langId );
    $header->set_var( 'lang_attribute', $langAttr );

    $header->set_var( 'background_image', $_CONF['layout_url']
                                          . '/images/bg.' . $_IMAGE_TYPE );
    $header->set_var( 'site_url', $_CONF['site_url'] );
    $header->set_var( 'layout_url', $_CONF['layout_url'] );
    $header->set_var( 'site_mail', "mailto:{$_CONF['site_mail']}" );
    $header->set_var( 'site_name', $_CONF['site_name'] );
    $header->set_var( 'site_slogan', $_CONF['site_slogan'] );
    $rdf = substr_replace( $_CONF['rdf_file'], $_CONF['site_url'], 0,
                           strlen( $_CONF['path_html'] ) - 1 );
    $header->set_var( 'rdf_file', $rdf );
    $header->set_var( 'rss_url', $rdf );

    $msg = $LANG01[67] . ' ' . $_CONF['site_name'];

    if( !empty( $_USER['username'] ))
    {
        $msg .= ', ' . COM_getDisplayName( $_USER['uid'], $_USER['username'],
                                           $_USER['fullname'] );
    }

    $curtime =  COM_getUserDateTimeFormat();

    $header->set_var( 'welcome_msg', $msg );
    $header->set_var( 'datetime', $curtime[0] );
    $header->set_var( 'site_logo', $_CONF['layout_url']
                                   . '/images/logo.' . $_IMAGE_TYPE );

    // Changed by Phize <----
    $header->set_var( 'css_url', $_CONF['layout_url'] . '/css/import.css' );
    // Changed by Phize ---->

    $header->set_var( 'theme', $_CONF['theme'] );

    if( empty( $LANG_CHARSET ))
    {
        $charset = $_CONF['default_charset'];

        if( empty( $charset ))
        {
            $charset = 'iso-8859-1';
        }
    }
    else
    {
        $charset = $LANG_CHARSET;
    }

    $header->set_var( 'charset', $charset );
    if( empty( $LANG_DIRECTION ))
    {
        // default to left-to-right
        $header->set_var( 'direction', 'ltr' );
    }
    else
    {
        $header->set_var( 'direction', $LANG_DIRECTION );
    }

    // Now add variables for buttons like e.g. those used by the Yahoo theme
    $header->set_var( 'button_home', $LANG_BUTTONS[1] );
    $header->set_var( 'button_contact', $LANG_BUTTONS[2] );
    $header->set_var( 'button_contribute', $LANG_BUTTONS[3] );
    $header->set_var( 'button_sitestats', $LANG_BUTTONS[7] );
    $header->set_var( 'button_personalize', $LANG_BUTTONS[8] );
    $header->set_var( 'button_search', $LANG_BUTTONS[9] );
    $header->set_var( 'button_advsearch', $LANG_BUTTONS[10] );
    $header->set_var( 'button_directory', $LANG_BUTTONS[11] );

    // Get plugin menu options
    $plugin_menu = PLG_getMenuItems();

    if( $_COM_VERBOSE )
    {
        COM_errorLog( 'num plugin menu items in header = ' . count( $plugin_menu ), 1 );
    }

    // Now add nested template for menu items
    COM_renderMenu( $header, $plugin_menu );

    if( count( $plugin_menu ) == 0 )
    {
        $header->parse( 'plg_menu_elements', 'menuitem_none', true );
    }
    else
    {
        for( $i = 1; $i <= count( $plugin_menu ); $i++ )
        {
            $header->set_var( 'menuitem_url', current( $plugin_menu ));
            $header->set_var( 'menuitem_text', key( $plugin_menu ));

            // Changed by Phize <----
            if( $i == 1)
            {
                $header->set_var( 'attr_class', $attr_class_first );
                $header->set_var( 'value_class', $value_class_first );
                $header->parse( 'plg_menu_elements', 'menuitem', true );
            }
            else if( $i == count( $plugin_menu ) )
            {
                $header->set_var( 'attr_class', $attr_class_last );
                $header->set_var( 'value_class', $value_class_last );
                $header->parse( 'plg_menu_elements', 'menuitem', true );
            }
            else
            {
                $header->set_var( 'attr_class', '' );
                $header->set_var( 'value_class', '' );
                $header->parse( 'plg_menu_elements', 'menuitem', true );
            }
            // Changed by Phize ---->

            next( $plugin_menu );
        }
    }

    // Changed by Phize <----
    //if( $_CONF['left_blocks_in_footer'] == 1 )
    //{
    //    $header->set_var( 'geeklog_blocks', '' );
    //    $header->set_var( 'left_blocks', '' );
    //}
    //else
    //{
    // Changed by Phize ---->
        $lblocks = '';

        /* Check if an array has been passed that includes the name of a plugin
         * function or custom function
         * This can be used to take control over what blocks are then displayed
         */
        if( is_array( $what ))
        {
            $function = $what[0];
            if( function_exists( $function ))
            {
                $lblocks = $function( $what[1], 'left' );
            }
            else
            {
                $lblocks = COM_showBlocks( 'left', $topic );
            }
        }
        else if( $what <> 'none' )
        {
            // Now show any blocks -- need to get the topic if not on home page
            $lblocks = COM_showBlocks( 'left', $topic );
        }

        if( empty( $lblocks ))
        {
            $header->set_var( 'geeklog_blocks', '' );
            $header->set_var( 'left_blocks', '' );
        }
        else
        {
            $header->set_var( 'geeklog_blocks', $lblocks );
            $header->parse( 'left_blocks', 'leftblocks', true );
        }

    // Changed by Phize <----
    //}
    // Changed by Phize ---->

    // Call any plugin that may want to include extra Meta tags
    // or Javascript functions
    $header->set_var( 'plg_headercode', $headercode . PLG_getHeaderCode() );

    // Call to plugins to set template variables in the header
    PLG_templateSetVars( 'header', $header );

    // The following lines allow users to embed PHP in their templates.  This
    // is almost a contradition to the reasons for using templates but this may
    // prove useful at times ...
    // Don't use PHP in templates if you can live without it!

    $tmp = $header->parse( 'index_header', 'header' );

    ob_start();
    eval( '?>' . $tmp );
    $retval = ob_get_contents();
    ob_end_clean();

    return $retval;
}



function Revize_siteFooter( $rightblock = -1, $custom = '' )
{
    global $_CONF, $_TABLES, $LANG01, $LANG_BUTTONS, $_PAGE_TIMER, $topic;
    global $g_what;
    $what = $g_what;

    if( $rightblock < 0 )
    {
        if( isset( $_CONF['show_right_blocks'] ))
        {
            $rightblock = $_CONF['show_right_blocks'];
        }
        else
        {
            $rightblock = false;
        }
    }

    // Set template directory
    $footer = new Template( $_CONF['path_layout'] );

    // Set template file
    $footer->set_file( array(
            'footer'      => 'footer.thtml',
            // Changed by Phize <----
            'rightblocks' => 'blocks_2.thtml',
            'leftblocks'  => 'blocks_1.thtml'
            // Changed by Phize ---->
            ));

    // Do variable assignments
    DB_change( $_TABLES['vars'], 'value', 'value + 1', 'name', 'totalhits', '', true );

    $footer->set_var( 'site_url', $_CONF['site_url']);
    $footer->set_var( 'layout_url',$_CONF['layout_url']);
    $footer->set_var( 'site_mail', "mailto:{$_CONF['site_mail']}" );
    $footer->set_var( 'site_name', $_CONF['site_name'] );
    $footer->set_var( 'site_slogan', $_CONF['site_slogan'] );
    $rdf = substr_replace( $_CONF['rdf_file'], $_CONF['site_url'], 0,
                           strlen( $_CONF['path_html'] ) - 1 );
    $footer->set_var( 'rdf_file', $rdf );
    $footer->set_var( 'rss_url', $rdf );

    $year = date( 'Y' );
    $copyrightyear = $year;
    if( !empty( $_CONF['copyrightyear'] ))
    {
        $copyrightyear = $_CONF['copyrightyear'];
    }
    $footer->set_var( 'copyright_notice', '&nbsp;' . $LANG01[93] . ' &copy; '
            . $copyrightyear . ' ' . $_CONF['site_name'] . '<br>&nbsp;'
            . $LANG01[94] );
    $footer->set_var( 'copyright_msg', $LANG01[93] . ' &copy; '
            . $copyrightyear . ' ' . $_CONF['site_name'] );
    $footer->set_var( 'current_year', $year );
    $footer->set_var( 'lang_copyright', $LANG01[93] );
    $footer->set_var( 'trademark_msg', $LANG01[94] );
    $footer->set_var( 'powered_by', $LANG01[95] );
    $footer->set_var( 'geeklog_url', 'http://www.geeklog.net/' );
    $footer->set_var( 'geeklog_version', VERSION );

    /* Check if an array has been passed that includes the name of a plugin
     * function or custom function.
     * This can be used to take control over what blocks are then displayed
     */
    if( is_array( $custom ))
    {
        $function = $custom['0'];
        if( function_exists( $function ))
        {
            $rblocks = $function( $custom['1'], 'right' );
        }
    }
    elseif( $rightblock )
    {
        $rblocks = COM_showBlocks( 'right', $topic );
    }
    if( $rightblock && !empty( $rblocks ))
    {
        $footer->set_var( 'geeklog_blocks', $rblocks );
        $footer->parse( 'right_blocks', 'rightblocks', true );
    }
    else
    {
        $footer->set_var( 'geeklog_blocks', '' );
        $footer->set_var( 'right_blocks', '' );
    }

    $footer->set_var( 'button_home', $LANG_BUTTONS[1] );
    $footer->set_var( 'button_contact', $LANG_BUTTONS[2] );
    $footer->set_var( 'button_contribute', $LANG_BUTTONS[3] );
    $footer->set_var( 'button_calendar', $LANG_BUTTONS[6] );
    $footer->set_var( 'button_sitestats', $LANG_BUTTONS[7] );
    $footer->set_var( 'button_personalize', $LANG_BUTTONS[8] );
    $footer->set_var( 'button_search', $LANG_BUTTONS[9] );
    $footer->set_var( 'button_advsearch', $LANG_BUTTONS[10] );
    $footer->set_var( 'button_directory', $LANG_BUTTONS[11] );

    $lblocks = '';

    /* Check if an array has been passed that includes the name of a plugin
     * function or custom function
     * This can be used to take control over what blocks are then displayed
     */
    if( is_array( $what ))
    {
        $function = $what[0];
        if( function_exists( $function ))
        {
            $lblocks = $function( $what[1], 'left' );
        }
    }
    else if ( $what <> 'none' )
    {
        $lblocks = COM_showBlocks( 'left', $topic );
    }

    if( empty( $lblocks ))
    {
        $footer->set_var( 'geeklog_blocks', '' );
        $footer->set_var( 'left_blocks', '' );
    }
    else
    {
        $footer->set_var( 'geeklog_blocks', $lblocks );
        $footer->parse( 'left_blocks', 'leftblocks', true );
    }

    // Global centerspan variable set in index.php
    if( isset( $GLOBALS['centerspan'] ))
    {
        $footer->set_var( 'centerblockfooter-span', '</td></tr></table>' );
    }

    $exectime = $_PAGE_TIMER->stopTimer();
    $exectext = $LANG01[91] . ' ' . $exectime . ' ' . $LANG01[92];

    $footer->set_var( 'execution_time', $exectime );
    $footer->set_var( 'execution_textandtime', $exectext );

    // Call to plugins to set template variables in the footer
    PLG_templateSetVars( 'footer', $footer );

    // Actually parse the template and make variable substitutions
    $footer->parse( 'index_footer', 'footer' );

    // Return resulting HTML
    return $footer->finish( $footer->get_var( 'index_footer' ));
}
?>