/*
 * debug_print.c
 * ѰΥƥ
 */

#include <stdarg.h>
#include <stdio.h>
#include "debug_print.h"

/*
 * ѰꥹȤĥǥХåѽϴؿ
 */
int
__debug_print(char *fmt, ...)
{
    va_list ap; /* 硹˻ؤ */
    int allnum = 0;

#ifndef HAVE_VFPRINTF
    char *p, *sval;
    int ival;
    double dval;
#endif /* HAVE_VFPRINTF */


    va_start(ap, fmt); /* ǽΰؤ褦ˤ */


#ifdef HAVE_VFPRINTF /* using vfprintf */

    allnum = vfprintf(stderr, fmt, ap);

#else /* from K&R 2nd */

    for (p = fmt; *p; p++) {
        if (*p != '%') {
            putchar(*p);
            allnum++;
            continue;
        }

        switch(*++p) {

        case 'd': /*  */
            ival = va_arg(ap, int);
            allnum += printf("%d", ival);
            break;

        case 'f': /* ư */
            dval = va_arg(ap, double);
            allnum += printf("%f", dval);
            break;

        case 's': /* ʸ */
            for (sval = va_arg(ap, char *); *sval; sval++) {
                putchar(*sval);
                allnum++;
            }
            break;

        default:
            putchar(*p);
            allnum++;
            break;
        }
    }
#endif /* HAVE_VFPRINTF */

    va_end(ap);

    return allnum;
}
