/* Test program for gehl_bmp module */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "gehl_types.h"
#include "gehl.h"


int
main(int argc, char **argv)
{
    GEHL_IMG img, keep;
    int i, ret;
    char fname[256];

    if(argc < 2){
        fprintf(stderr, "Usage: %s imagefile.bmp\n", argv[0]);
        return -1;
    }

    memset(&img, 0, sizeof(GEHL_IMG));

    ret = GEHL_Load(argv[1], &img);
    if (ret != 0){
        fprintf(stderr, "read error\n");
        return -1;
    }

    GEHL_Copy(&keep, &img);

    for (i = 0; i < 360; i+=6) {
        GEHL_Rotate(&img, (double)i);
        sprintf(fname, "out_%03d.bmp", i);
        GEHL_Save(fname, &img, GEHL_FILEFORMAT_WINDIB);
        GEHL_Free(&img);
        GEHL_Copy(&img, &keep);
    }

    printf("finished\n");
    GEHL_Free(&img);
    GEHL_Free(&keep);

    return 0;
}
