#ifndef _gehl_types_h
#define _gehl_types_h


#ifdef __cplusplus
extern "C"{
#endif


#define HORIZONTAL  1
#define VERTICAL    2

#define DEG_0   0
#define DEG_90  1
#define DEG_180 2
#define DEG_270 3

#define GEHL_TYPE_UNKNOWN 0x0
#define GEHL_TYPE_BMP     0x0001


typedef struct __gehl_pal {
    unsigned char blue;
    unsigned char green;
    unsigned char red;
    unsigned char dummy;
} GEHL_PAL;

typedef struct __gehl_img {
    int width;
    int rowbytes;
    int height;
    int dpi;
    unsigned short bits;
    unsigned short black;
    GEHL_PAL *ppalette;
    char *pdata;
    char *pred;
    char *pgreen;
    char *pblue;
} GEHL_IMG;


#ifdef __cplusplus
}
#endif


#endif /* _gehl_types_h */

