/* Test program for gehl_bmp module */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "gehl_types.h"
#include "gehl.h"


int
main(int argc, char **argv)
{
    GEHL_IMG img;
    int ret;
    char fname[256];
    int degree;

    if(argc < 3){
        fprintf(stderr, "Usage: %s imagefile.bmp degree\n", argv[0]);
        return -1;
    }

    degree = atoi(argv[2]);

    memset(&img, 0, sizeof(GEHL_IMG));

    ret = GEHL_Load(argv[1], &img);
    if (ret != 0){
        fprintf(stderr, "read error\n");
        return -1;
    }

    GEHL_Rotate(&img, (double)degree);
    sprintf(fname, "out_%03d.bmp", degree);
    GEHL_Save(fname, &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);

    printf("finished\n");

    return 0;
}
