/* Test program for gehl_bmp module */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "gehl_types.h"
#include "gehl.h"


int
main(int argc, char **argv)
{
    GEHL_IMG img, keep;
    int ret;

    if(argc < 2){
        fprintf(stderr, "Usage: %s imagefile.bmp\n", argv[0]);
        return -1;
    }

    memset(&img, 0, sizeof(GEHL_IMG));

    ret = GEHL_Load(argv[1], &img);
    if (ret != 0){
        fprintf(stderr, "read error\n");
        return -1;
    }

    GEHL_Copy(&keep, &img);
    GEHL_Save("out_keep.bmp", &img, GEHL_FILEFORMAT_WINDIB);

#if 1 
    GEHL_Turnover(&img, HORIZONTAL);
    GEHL_Save("out_horizontal.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    GEHL_Turnover(&img, VERTICAL);
    GEHL_Save("out_vertical.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    GEHL_Rotate(&img, 90);
    GEHL_Save("out_090.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    GEHL_Rotate(&img, 180);
    GEHL_Save("out_180.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    GEHL_Rotate(&img, 270);
    GEHL_Save("out_270.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    GEHL_Rotate(&img, 253.0);
    GEHL_Save("out_060.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    ret = GEHL_Trim(&img, 25, 49, 250, 402);
    GEHL_Save("out_trim.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    if (GEHL_C2Mono(&img, 128) == 0)
        GEHL_Save("out_mono128.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    if (GEHL_C2Mono(&img, 64) == 0)
        GEHL_Save("out_mono064.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    if (GEHL_C2Mono(&img, 192) == 0)
        GEHL_Save("out_mono192.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif
#if 1
    if (GEHL_C2Gray(&img) == 0)
        GEHL_Save("out_gray.bmp", &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);
    GEHL_Copy(&img, &keep);
#endif

    GEHL_Free(&img);
    GEHL_Free(&keep);

    return 0;
}
