/*
 * gehl.h
 * Graphics Easy Hangling Library
 */
#ifndef _gehl_h
#define _gehl_h

#ifdef __cplusplus
extern "C"{
#endif


/* definition of file format */
#define GEHL_FILEFORMAT_FAILED  -2 /* failed to check */
#define GEHL_FILEFORMAT_UNKNOWN -1 /* unknown format */
#define GEHL_FILEFORMAT_WINDIB   1 /* Windows DIB (.bmp) */
#define GEHL_FILEFORMAT_JPEG     2 /* JPEG (.jpg, .jpeg) */
#define GEHL_FILEFORMAT_TIFF     3 /* TIFF (.tif, .tiff) */
#define GEHL_FILEFORMAT_PNG      4 /* PNG (.png) */

/* definition of filter */
#define GEHL_EDGEFILTER_SOBEL 0
#define GEHL_EDGEFILTER_PREWITT 1

#ifdef WIN32
#define GEHLEXPORT GEHLWIN32
#else
#define GEHLEXPORT extern
#endif /* WIN32 */

#ifdef WIN32
# ifdef GEHL_WIN32_EXPORTS
#define GEHLWIN32 __declspec(dllexport)
# else
#define GEHLWIN32 __declspec(dllimport)
# endif /* GEHL_WIN32_EXPORTS */
#endif /* WIN32 */


/* load image file */
GEHLEXPORT int
GEHL_Load(const char *fname, GEHL_IMG *img);

/* save image file */
GEHLEXPORT int
GEHL_Save(const char *fname, const GEHL_IMG *img, int format);

/* free image */
GEHLEXPORT int
GEHL_Free(GEHL_IMG *img);

/* turnover VERTICAL/HORIZONTAL */
GEHLEXPORT int
GEHL_Turnover(GEHL_IMG *img, int direction);

/* rotate 1-359 degree */
GEHLEXPORT int
GEHL_Rotate(GEHL_IMG *img, double degree);

/* trim (x, y)-(x+w, y+h) */
GEHLEXPORT int
GEHL_Trim(GEHL_IMG *img,
          int x, int y,
          int w, int h);

/* color to mono (24bit only) */
GEHLEXPORT int
GEHL_C2Mono(GEHL_IMG *img, int border);

/* color to grayscale (24bit only) */
GEHLEXPORT int
GEHL_C2Gray(GEHL_IMG *img);

/* copy */
GEHLEXPORT int
GEHL_Copy(GEHL_IMG *dest, const GEHL_IMG *src);

/* edge detect */
GEHLEXPORT int
GEHL_Edge(GEHL_IMG *img, int filter);


#ifdef __cplusplus
}
#endif

#endif /* _gehl_h */
