/*
 * gehl_bw.c
 * 顼Ͳ/졼벽
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gehl_types.h"
#include "gehl_bw.h"


/* Gray Scale θ */
/* Brightness = 0.299r + 0.587g + 0.114b */
/* -> (77r + 150g + 29b) / 256 */
/* / 256  >> 8 ֤ */
#define GRAY_R 77  // 0.298912*256
#define GRAY_G 150  // 0.586611*256
#define GRAY_B 29  // 0.114478*256


static int
C2Mono_24(GEHL_IMG *img, int border);

static int
C2Mono_8(GEHL_IMG *img, int border);

static int
C2Gray_24(GEHL_IMG *img);

/*
 * Ͳ
 *
 * :
 *   border --- Ͳ(0-255)
 * :
 *   img --- 
 *
 */
int
__GEHL_C2Mono(GEHL_IMG *img, int border)
{
    int ret = -1;


    if (NULL == img)
        return -1;
    if ((border < 0) || (border > 255))
        return -1;

    switch (img->bits) {

    case 8:
        ret = C2Mono_8(img, border);
        break;

    case 24:
        ret = C2Mono_24(img, border);
        break;

    default:
        break;
    }

    return ret;
}

/*
 * 8bit顼쥤Ͳ
 * (եޥåȼΤGEHL 8 bit-type Τޤ)
 *
 * :
 *   border --- Ͳ
 * :
 *   img --- 
 *
 */
static int
C2Mono_8(GEHL_IMG *img, int border)
{
    int i, x, y;
    int rb_dest;
    unsigned char *img_dest, value;
    unsigned char *src, *dest;

    rb_dest = img->rowbytes;

    /* ùβΰγ */
    img_dest = (unsigned char *)malloc(rb_dest * img->height);
    if (NULL == img_dest)
        return -1;
    memset(img_dest, 0, rb_dest * img->height);

    /* ѥåȥ顼Ͳ */
    for (i = 0; i < 256; i++) {
        value = (unsigned char)(
            (GRAY_R * img->ppalette[i].red
             + GRAY_G * img->ppalette[i].green
             + GRAY_B * img->ppalette[i].blue)
            >> 8
            );
        /* ȤꤢBlueȤޤ魯 */
        img->ppalette[i].blue = (value >= border) ? 1 : 0;
    } /* ä®ǤϤ */

    /* ͤΥѥåȤб */
    for (y = 0; y < img->height; y++) {

        src = img->pdata + y * img->rowbytes;
        dest = img_dest + y * rb_dest;

        for (x = 0; x < img->width; x++) {
            dest[x] = img->ppalette[src[x]].blue;
        }
    }

    /* ùβΰˡùβž */
    memmove(img->pdata, img_dest, rb_dest * img->height);
    free(img_dest);

    /* ѥåȤͤ˺ʤ */
    img->ppalette = (GEHL_PAL *)realloc(img->ppalette, sizeof(GEHL_PAL) * 2);
    if (NULL == img->ppalette)
        return -1;

    memset(img->ppalette, 0, sizeof(GEHL_PAL)*2);
    img->ppalette[1].red = 255;
    img->ppalette[1].green = 255;
    img->ppalette[1].blue = 255;
    img->bits = 1;
    img->black = 0; /* 0 --- , 1 ---  ǷǤ */
    img->rowbytes = rb_dest;

    return 0;
}

/*
 * 24bitͲ
 * (եޥåȼΤ GEHL 8 bit-type ˤ)
 *
 * :
 *   border --- Ͳ
 * :
 *   img --- 
 *
 */
static int
C2Mono_24(GEHL_IMG *img, int border)
{
    int x, y;
    int rb_dest;
    unsigned char *img_dest, value;
    unsigned char *srcR, *srcG, *srcB, *dest;

    rb_dest = img->rowbytes;

    /* ùβΰ */
    img_dest = (unsigned char *)malloc(rb_dest * img->height);
    if (NULL == img_dest)
        return -1;
    memset(img_dest, 0, rb_dest * img->height);


    /* ö졼ˤƤͲ */
    for (y = 0; y < img->height; y++) {

        srcR = img->pred + y * img->rowbytes;
        srcG = img->pgreen + y * img->rowbytes;
        srcB = img->pblue + y * img->rowbytes;
        
        dest = img_dest + y * rb_dest;

        for (x = 0; x < img->width; x++) {
            value = (unsigned char)(
                (GRAY_R * srcR[x]
                 + GRAY_G * srcG[x]
                 + GRAY_B * srcB[x])
                >> 8
                );
            dest[x] = ((value >= border) ? 1 : 0);
        }
    }

    /* ùΰ8bit-typeѤΰݤʤ(ʤʤ) */
    img->pdata = (char *)realloc(img->pdata, rb_dest * img->height);
    if (NULL == img->pdata) {
        free(img_dest);
        return -1;
    }
    memmove(img->pdata, img_dest, rb_dest * img->height);
    free(img_dest);
    img->pred = img->pgreen = img->pblue = NULL;

    /* ѥåȤʤ */
    img->ppalette = (GEHL_PAL *)malloc(sizeof(GEHL_PAL) * 2);
    if (NULL == img->ppalette)
        return -1;

    memset(img->ppalette, 0, sizeof(GEHL_PAL)*2);
    img->ppalette[1].red = 255;
    img->ppalette[1].green = 255;
    img->ppalette[1].blue = 255;
    img->bits = 1;
    img->black = 0; /* 0 --- , 1 ---  ǷǤ */
    img->rowbytes = rb_dest;

    return 0;
}

/*
 * 򥰥졼벽
 *
 * :
 *   img --- 
 *
 */
int
__GEHL_C2Gray(GEHL_IMG *img)
{
    int ret = -1;


    if (NULL == img)
        return -1;

    switch (img->bits) {

    case 24:
        ret = C2Gray_24(img);
        break;

    default:
        break;
    }

    return ret;
}

/*
 * 24bit򥰥졼벽
 * (եޥåȼΤ8bitˤ)
 *
 * :
 *   img --- 
 *
 */
static int
C2Gray_24(GEHL_IMG *img)
{
    int i, x, y;
    int rb_dest;
    unsigned char *img_dest;
    unsigned char *srcR, *srcG, *srcB, *dest;

    rb_dest = img->rowbytes;

    /* ùβΰ */
    img_dest = (unsigned char *)malloc(rb_dest * img->height);
    if (NULL == img_dest)
        return -1;
    memset(img_dest, 0, rb_dest * img->height);

    /* 졼Ѵ */
    for (y = 0; y < img->height; y++) {

        srcR = img->pred + y * img->rowbytes;
        srcG = img->pgreen + y * img->rowbytes;
        srcB = img->pblue + y * img->rowbytes;
        dest = img_dest + y * rb_dest;

        for (x = 0; x < img->width; x++) {
            dest[x] = (unsigned char)(
                (GRAY_R * srcR[x]
                 + GRAY_G * srcG[x]
                 + GRAY_B * srcB[x])
                >> 8
                );
        }
    }

    /* ùΰ8bit-typeѤΰݤʤ(ʤʤ) */
    img->pdata = (char *)realloc(img->pdata, rb_dest * img->height);
    if (NULL == img->pdata) {
        free(img_dest);
        return -1;
    }
    memmove(img->pdata, img_dest, rb_dest * img->height);
    img->pred = img->pgreen = img->pblue = NULL;
    free(img_dest);

    /* ѥåȤ */
    img->ppalette = (GEHL_PAL *)malloc(sizeof(GEHL_PAL) * 256);
    if (NULL == img->ppalette)
        return -1;

    for (i = 0; i < 256; i++) {
        img->ppalette[i].red = i;
        img->ppalette[i].green = i;
        img->ppalette[i].blue = i;
    }
    img->bits = 8;
    img->black = 0; /* 0 --- , 255 ---  ǷǤ */
    img->rowbytes = rb_dest;

    return 0;
}
