/*
 * gehl_fileio.c
 * ᡼ե
 */
#include <stdio.h>
#include <stdlib.h>
#include "gehl_types.h"
#include "gehl.h"
#include "gehl_fileio.h"
#include "gehl_bmp.h"

/* ؿץȥ */
static int
__GEHL_File_Check(const char *fname);


int
__GEHL_Load(const char *fname, GEHL_IMG *img)
{
    int ftype, ret = -1;

    ftype = __GEHL_File_Check(fname);

    switch(ftype) {

    case GEHL_FILEFORMAT_WINDIB:
        ret = GEHL_BMP_Load(fname, img);
        break;

    default:
        break;
    }

    return ret;
}


static int
__GEHL_File_Check(const char *fname)
{
    char sigchk[16];
    FILE *fp;

    fp = fopen(fname, "rb");
    if (NULL == fp) return GEHL_FILEFORMAT_FAILED;

    fread(sigchk, 1, 8, fp);

    /* Windows DIB? */
    if ((sigchk[0] == 'B')&&(sigchk[1] == 'M')) {
        fclose(fp);
        return GEHL_FILEFORMAT_WINDIB;
    }

    fclose(fp);
    return GEHL_FILEFORMAT_UNKNOWN;
}

int
__GEHL_Save(const char *fname, const GEHL_IMG *img, int format)
{
    int ret = -1;

    switch (format) {

    case GEHL_FILEFORMAT_WINDIB:
        ret = GEHL_BMP_Save(fname, img);
        break;

    default:
        break;
    }

    return ret;
}


int
__GEHL_Free(GEHL_IMG *img)
{
    if (NULL == img){
        return -1;
    }

    if (NULL != img->ppalette){
        free(img->ppalette);
        img->ppalette = NULL;
    }

    if (NULL != img->pdata){
        free(img->pdata);
        img->pdata = NULL;
    }

    return 0;
}
