/*
 * gehl_rotate.c
 * žǽ
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "gehl_types.h"
#include "gehl_rotate.h"
#include "gehl_turnover.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

/*
 * ľѤβž
 * ե꡼žϤޤ
 */

/*
 * RotateX_Y(GEHL_IMG *img);
 *
 * X --- color depth
 * Y --- degree
 */
static int
Rotate8(GEHL_IMG *img, double degree);

static int
Rotate8_90(GEHL_IMG *img);

static int
Rotate8_270(GEHL_IMG *img);

static int
Rotate8_Free(GEHL_IMG *img, double degree);

static int
Rotate24(GEHL_IMG *img, double degree);

static int
Rotate24_90(GEHL_IMG *img);

static int
Rotate24_270(GEHL_IMG *img);

static int
Rotate24_Free(GEHL_IMG *img, double degree);

static int
Rotate_180(GEHL_IMG *img);


static int
Rotate_Layer_8(GEHL_IMG *outimg,
               const GEHL_IMG *inimg,
               double degree);

static int
Rotate_Layer_24(GEHL_IMG *outimg,
                const GEHL_IMG *inimg,
                double degree);

static int
CalcRotate(int width,
           int height,
           double degree,
           int *afterwidth,
           int *afterheight);


/*
 * ž
 *
 * :
 *   degree --- ײɽ(-359.99359.99)
 * :
 *   img --- 
 */
int
__GEHL_Rotate(GEHL_IMG *img, double degree)
{
    int ret = -1;


    if (NULL == img)
        return ret;
    if ((degree < -359.99)||(degree > 359.99))
        return ret;
    
    if (degree == 0.0)
        return 0;
    if (degree < 0.0)
        degree += 360.0;

    switch(img->bits) {

    case 1:
    case 8:
        ret = Rotate8(img, degree);
        break;

    case 24:
        ret = Rotate24(img, degree);
        break;
    }

    return ret;
}

static int
Rotate8(GEHL_IMG *img, double degree)
{
    int ret = -1;
    int deg;
    
    deg = (int)(degree * 100);
    if (deg % 9000 != 0) {
        ret = Rotate8_Free(img, degree);
        return ret;
    }
    
    deg = deg / 100;
    switch (deg) {

    case 0:
        break;

    case 90:
        ret = Rotate8_90(img);
        break;

    case 180:
        ret = Rotate_180(img);
        break;

    case 270:
        ret = Rotate8_270(img);
        break;

    default:
        break;
    }

    return ret;
}

static int
Rotate8_90(GEHL_IMG *img)
{
    int x, y;
    int rb_dest;
    char *pbuf, *src, *psrc, *dest, *pdest;
    char *img_dest;
    int h_dest, w_dest;

    /* ХåեѰդ */
    rb_dest = img->height; /* 񤭽ФβХȿ */
    pbuf = calloc(rb_dest, 1);
    if (NULL == pbuf)
        return -1;

    /* 񤭽ФѥѰդ */
    w_dest = img->height;
    h_dest = img->width;
    img_dest = calloc(rb_dest * h_dest, 1);
    if (NULL == img_dest) {
        free(pbuf);
        return -1;
    }

    psrc = img->pdata + img->width * (img->height - 1); // ɤ߽Ф
    pdest = img_dest; // 񤭽Ф
    
    for (y = 0; y < h_dest; y++) {
        src = psrc + y;
        dest = pdest + y * w_dest;
        for (x = 0; x < w_dest; x++, src -= img->width) {
            pbuf[x] = *src;
        }
        memmove(dest, pbuf, w_dest);
    }

    img->pdata = (char *)realloc(img->pdata, rb_dest * h_dest);
    if (NULL == img->pdata) {
        free(img_dest);
        free(pbuf);
        return -1;
    }

    memmove(img->pdata, img_dest, rb_dest * h_dest);
    img->width = w_dest;
    img->height = h_dest;
    img->rowbytes = rb_dest;

    free(img_dest);
    free(pbuf);

    return 0;
}

static int
Rotate8_270(GEHL_IMG *img)
{
    int ret = -1;

    ret = Rotate8_90(img);
    if (ret) return ret;

    return Rotate_180(img);
}

/* 8bit ե꡼ž
   ׻Թ塢žؿǤ
   ŪʴȤä
   ȾײȤƹͤ */
static int
Rotate8_Free(GEHL_IMG *img, double degree)
{
    GEHL_IMG outimg;
    int outh, outw;
    int inh, inw;
    int ret;

    if ((degree < 0.0)||(degree > 360.0))
        return -1;
    degree = 360.0 - degree;

    memset(&outimg, 0, sizeof(GEHL_IMG));
    outimg.dpi = img->dpi;
    outimg.bits = img->bits;
    outimg.black = img->black;
    outimg.ppalette =img->ppalette;
    
    inw = img->width;
    inh = img->height;

    CalcRotate(img->width, img->height,
               degree,
               &outw, &outh);
    outimg.width = outimg.rowbytes = outw;
    outimg.height = outh;

    /* ž礭ˤ碌
       ΰݤ */
    outimg.pdata = malloc(outw * outh);
    if (NULL == outimg.pdata) {
	printf("Rotate8_Free(): can not allocate\n");
	return -1;
    }
    memset(outimg.pdata, 0, outw * outh);
    outimg.pred = outimg.pgreen = outimg.pblue = outimg.pdata;

    // test
    //printf("%03d: W:%d H:%d H*D:%d\n", (int)degree, inw, inh, inw*inh);
    //printf("    ->W:%d H:%d H*D:%d\n", outw, outh, outw*outh);

    ret = Rotate_Layer_8(&outimg, img, degree);
    if (ret) {
        free(outimg.pdata);
        return -1;
    }

    img->pdata = realloc(img->pdata, outw * outh);
    if (NULL == img->pdata) {
        free(outimg.pdata);
        return -1;
    }

    memmove(img->pdata, outimg.pdata, outw * outh);
    img->width = outimg.width;
    img->rowbytes = outimg.rowbytes;
    img->height = outimg.height;

    free(outimg.pdata);
    return 0;
}

static int
Rotate24(GEHL_IMG *img, double degree)
{
    int ret = -1;
    int deg;
    
    deg = (int)(degree * 100);
    if (deg % 9000 != 0) {
        ret = Rotate24_Free(img, degree);
        return ret;
    }
    
    deg = deg / 100;
    switch (deg) {

    case 0:
        break;

    case 90:
        ret = Rotate24_90(img);
        break;

    case 180:
        ret = Rotate_180(img);
        break;

    case 270:
        ret = Rotate24_270(img);
        break;

    default:
        break;
    }

    return ret;
}

static int
Rotate24_90(GEHL_IMG *img)
{
    int x, y;
    char *pbuf, *src, *psrc, *dest, *pdest;
    char *img_dest;
    int h_dest, w_dest, imgsize;

    h_dest = img->width;
    w_dest = img->height;
    imgsize = h_dest * w_dest;

    /* Хåեmalloc */
    pbuf = (char *)malloc(w_dest);
    if (NULL == pbuf) return -1;
    memset(pbuf, 0, w_dest);

    /* 񤭽Фѥmalloc */
    img_dest = (char *)malloc(3 * imgsize);
    if (NULL == img_dest) {
        free(pbuf);
        return -1;
    }
    memset(img_dest, 0, 3 * imgsize);

    /* Redž */
    src = img->pred + img->width * (img->height - 1);
    dest = img_dest;
    for (y = 0; y < h_dest; y++) {
        psrc = src + y;
        pdest = dest + y * w_dest;
        for (x = 0; x < w_dest; x++, psrc -= img->width) {
            pbuf[x] = *psrc;
        }
        memmove(pdest, pbuf, w_dest);
    }

    /* greenž */
    src = img->pgreen + img->width * (img->height - 1);
    dest = img_dest + imgsize;
    for (y = 0; y < h_dest; y++) {
        psrc = src + y;
        pdest = dest + y * w_dest;
        for (x = 0; x < w_dest; x++, psrc -= img->width) {
            pbuf[x] = *psrc;
        }
        memmove(pdest, pbuf, w_dest);
    }

    /* bluež */
    src = img->pblue + img->width * (img->height - 1);
    dest = img_dest + 2 * imgsize;
    for (y = 0; y < h_dest; y++) {
        psrc = src + y;
        pdest = dest + y * w_dest;
        for (x = 0; x < w_dest; x++, psrc -= img->width) {
            pbuf[x] = *psrc;
        }
        memmove(pdest, pbuf, w_dest);
    }

    memmove(img->pdata, img_dest, 3 * imgsize);

    img->width = img->rowbytes = w_dest;
    img->height = h_dest;

    free(img_dest);
    free(pbuf);

    return 0;
}

static int
Rotate24_270(GEHL_IMG *img)
{
    int ret = -1;

    ret = Rotate24_90(img);
    if (ret) return ret;

    return Rotate_180(img);
}

/* 24bit ե꡼ž */
static int
Rotate24_Free(GEHL_IMG *img, double degree)
{
    GEHL_IMG outimg;
    int outh, outw;
    int inh, inw;
    int ret;

    if ((degree < 0.0)||(degree > 360.0))
        return -1;
    degree = 360.0 - degree;

    memset(&outimg, 0, sizeof(GEHL_IMG));
    outimg.dpi = img->dpi;
    outimg.bits = img->bits;
    outimg.black = img->black;
    outimg.ppalette =img->ppalette;
    
    inw = img->width;
    inh = img->height;

    CalcRotate(img->width, img->height,
               degree,
               &outw, &outh);
    outimg.width = outimg.rowbytes = outw;
    outimg.height = outh;

    /* ž礭ˤ碌
       ΰݤ */
    outimg.pdata = malloc(3 * outw * outh);
    if (NULL == outimg.pdata) {
	printf("Rotate8_Free(): can not allocate\n");
	return -1;
    }
    memset(outimg.pdata, 0, 3 * outw * outh);
    outimg.pred = outimg.pdata;
    outimg.pgreen = outimg.pred + outw * outh;
    outimg.pblue = outimg.pgreen + outw * outh;

    // test
    printf("%03d: W:%d H:%d H*D:%d\n", (int)degree, inw, inh, 3*inw*inh);
    printf("    ->W:%d H:%d H*D:%d\n", outw, outh, 3*outw*outh);

    ret = Rotate_Layer_24(&outimg, img, degree);
    if (ret) {
        free(outimg.pdata);
        return -1;
    }

    img->pdata = realloc(img->pdata, 3 * outw * outh);
    if (NULL == img->pdata) {
        free(outimg.pdata);
        return -1;
    }
#if 1
    memmove(img->pdata, outimg.pdata, 3 * outw * outh);
    img->pred = img->pdata;
    img->pgreen = img->pred + outw * outh;
    img->pblue = img->pgreen + outw * outh;
    img->width = outimg.width;
    img->rowbytes = outimg.rowbytes;
    img->height = outimg.height;
#endif
    free(outimg.pdata);
    return 0;
}

/*
 * 180žؿ
 * ݤʤΤ
 * ȿžؿȤޤ魯...
 */
static int
Rotate_180(GEHL_IMG *img)
{
    int ret = -1;

    ret = __GEHL_Turnover(img, HORIZONTAL);
    if (!ret) ret = __GEHL_Turnover(img, VERTICAL);

    return ret;
}

/*
 * 쥤䡼žؿ(8bit)
 */
static int
Rotate_Layer_8(GEHL_IMG *outimg,
               const GEHL_IMG *inimg,
               double degree)
{
    int i, j, m, n;
    int width, height;
    double x, y, p, q;
    double r, c, s;
    int ixs, iys, oxs, oys;
    unsigned char *pin, *pout;

    width = inimg->width;
    height = inimg->height;

    ixs = inimg->width / 2;
    iys = inimg->height / 2;
    oxs = outimg->width / 2;
    oys = outimg->height / 2;

    r = degree * M_PI / 180.0;
    c = cos(r);
    s = sin(r);

    pin = inimg->pdata;
    pout = outimg->pdata;

    for (i = -oys; i < oys; i++) {

        for (j = -oxs; j < oxs; j++) {

            y = j * s + i * c;
            x = j * c - i * s;
            if (y > 0) m = y; else m = y - 1;
            if (x > 0) n = x; else n = x - 1;
            q = y - m;
            p = x - n;

            if ((m >= -iys) && (m < iys)
                && (n >= -ixs) && (n < ixs)) {
                pout[outimg->width * (i+oys) + j + oxs] =
                    pin[inimg->width * (m+iys) + n + ixs];
            } else {
                pout[outimg->width * (i+oys) + j + oxs] = 0;
            }

        }

    }

    return 0;
}

/*
 * 쥤䡼žؿ(24bit)
 */
static int
Rotate_Layer_24(GEHL_IMG *outimg,
                const GEHL_IMG *inimg,
                double degree)
{
    int i, j, m, n;
    int width, height;
    double x, y, p, q;
    double r, c, s;
    int ixs, iys, oxs, oys;
    unsigned char *pInr, *pIng, *pInb;
    unsigned char *pOutr, *pOutg, *pOutb;
    int posIn, posOut;

    width = inimg->width;
    height = inimg->height;

    ixs = inimg->width / 2;
    iys = inimg->height / 2;
    oxs = outimg->width / 2;
    oys = outimg->height / 2;

    r = degree * M_PI / 180.0;
    c = cos(r);
    s = sin(r);

    pInr = inimg->pred; pIng = inimg->pgreen; pInb = inimg->pblue;
    pOutr = outimg->pred; pOutg = outimg->pgreen; pOutb = outimg->pblue;

    for (i = -oys; i < oys; i++) {

        for (j = -oxs; j < oxs; j++) {

            y = j * s + i * c;
            x = j * c - i * s;
            if (y > 0) m = y; else m = y - 1;
            if (x > 0) n = x; else n = x - 1;
            q = y - m;
            p = x - n;
            posOut = outimg->width * (i+oys) + j + oxs;

            if ((m >= -iys) && (m < iys)
                && (n >= -ixs) && (n < ixs)) {
                posIn = inimg->width * (m+iys) + n + ixs;
                pOutr[posOut] = pInr[posIn];
                pOutg[posOut] = pIng[posIn];
                pOutb[posOut] = pInb[posIn];
            } else {
                pOutr[posOut] = 0;
                pOutg[posOut] = 0;
                pOutb[posOut] = 0;
            }

        }

    }

    return 0;
}

static int
CalcRotate(int width,
           int height,
           double degree,
           int *afterwidth,
           int *afterheight)
{
    int w1, h1, w2, h2;

    double r, c, s;

    r = degree * M_PI / 180.0;
    c = cos(r);
    s = sin(r);

    w1 = w2 = width;
    h1 = h2 = height;

    if ((degree > 0.0)&&(degree < 90.0)) {
        w1 = width; h1 = height;
        w2 = (-width); h2 = height;
    }
    else if ((degree > 90.0)&&(degree < 180.0)) {
        w1 = (-width); h1 = height;
        w2 = (-width); h2 = (-height);
    }
    else if ((degree > 180.0)&&(degree < 270.0)) {
        w1 = (-width); h1 = (-height);
        w2 = width; h2 = (-height);
    }
    else if ((degree > 270.0)&&(degree < 360.0)) {
        w1 = width; h1 = (-height);
        w2 = width; h2 = height;
    }

    *afterwidth  = ((double)w1 * c) + ((double)h1 * s);
    *afterheight = ((double)h2 * c) - ((double)w2 * s);

    return 0;
}
