/*
 * gehl_trim.c
 * ȥߥ󥰤
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gehl_types.h"
#include "gehl_trim.h"


static int
Trim8(GEHL_IMG *img,
      int x, int y,
      int w, int h);

static int
Trim24(GEHL_IMG *img,
       int x, int y,
       int w, int h);


/*
 * (x, y)-(x+w, y+h)ǥȥߥ󥰤ؿ
 *
 * :
 *   x --- ȥߥ󥰻xɸ
 *   y --- ȥߥ󥰻yɸ
 *   w --- ȥߥΰ(pixel)
 *   h --- ȥߥΰι⤵(pixel)
 * :
 *   img --- GEHL_IMG ¤ΤؤΥݥ
 */
int
__GEHL_Trim(GEHL_IMG *img,
            int x, int y,
            int w, int h)
{
    int ret = -1;

    if ((x < 0)||(y < 0))
        return ret;

    if ((w < 0)||(h < 0))
        return ret;

    if ((img->width < x + w)||(img->height < y + h))
        return ret;

    switch (img->bits) {

    case 1:
    case 8:
        ret = Trim8(img, x, y, w, h);
        break;

    case 24:
        ret = Trim24(img, x, y, w, h);
        break;

    default:
        break;
    }

    return ret;
}

/*
 * 8bitѥȥߥ󥰴ؿ
 *
 * :
 *   x --- ȥߥ󥰻xɸ
 *   y --- ȥߥ󥰻yɸ
 *   w --- ȥߥΰ(pixel)
 *   h --- ȥߥΰι⤵(pixel)
 * :
 *   img --- GEHL_IMG ¤ΤؤΥݥ
 */
static int
Trim8(GEHL_IMG *img,
      int x, int y,
      int w, int h)
{
    int ty;
    char *src, *dest;
    char *img_dest;

    img_dest = (char *)malloc(w * h);
    if (NULL == img_dest) {
        return -1;
    }
    memset(img_dest, 0, w * h);

    for (ty = 0; ty < h; ty++) {
        src = img->pdata + (ty + y) * img->rowbytes + x;
        dest = img_dest + ty * w;
        memcpy(dest, src, w);
    }

    img->pdata = (char *)realloc(img->pdata, w * h);
    if (NULL == img->pdata) {
        free(img_dest);
        return -1;
    }

    memmove(img->pdata, img_dest, w * h);
    img->width = w;
    img->height = h;
    img->rowbytes = w;

    free(img_dest);

    return 0;
}

/*
 * 24bitѥȥߥ󥰴ؿ
 *
 * :
 *   x --- ȥߥ󥰻xɸ
 *   y --- ȥߥ󥰻yɸ
 *   w --- ȥߥΰ(pixel)
 *   h --- ȥߥΰι⤵(pixel)
 * :
 *   img --- GEHL_IMG ¤ΤؤΥݥ
 */
static int
Trim24(GEHL_IMG *img,
      int x, int y,
      int w, int h)
{
    int ty;
    char *src, *dest;
    char *img_dest;
    int imgsize;

    imgsize = w * h;
    img_dest = (char *)malloc(3 * imgsize);
    if (NULL == img_dest) {
        return -1;
    }
    memset(img_dest, 0, 3 * imgsize);

    /* redȥߥ */
    for (ty = 0; ty < h; ty++) {
        src = img->pred + (ty + y) * img->width + x;
        dest = img_dest + ty * w;
        memcpy(dest, src, w);
    }

    /* greenȥߥ */
    for (ty = 0; ty < h; ty++) {
        src = img->pgreen + (ty + y) * img->width + x;
        dest = img_dest + imgsize + ty * w;
        memcpy(dest, src, w);
    }

    /* blueȥߥ */
    for (ty = 0; ty < h; ty++) {
        src = img->pblue + (ty + y) * img->width + x;
        dest = img_dest + 2 * imgsize + ty * w;
        memcpy(dest, src, w);
    }

    img->pdata = (char *)realloc(img->pdata, 3 * imgsize);
    if (NULL == img->pdata) {
        free(img_dest);
        return -1;
    }

    img->pred = img->pdata;
    img->pgreen = img->pred + imgsize;
    img->pblue = img->pgreen + imgsize;
    memmove(img->pdata, img_dest, 3 * imgsize);
    img->width = img->rowbytes = w;
    img->height = h;

    free(img_dest);

    return 0;
}
