/*
 * gehl_util.c
 * Ѵؿ
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gehl_types.h"
#include "gehl_util.h"

/*
 * ᡼򥳥ԡ
 *
 * :
 *   src --- ԡΥ᡼
 * :
 *   dest --- ԡΥ᡼
 *
 */
extern int
__GEHL_Copy(GEHL_IMG *dest, const GEHL_IMG *src)
{
    int i, npalette;
    int imgsize;

    if ((NULL == src)||(NULL == dest))
        return -1;

    *dest = *src;
    dest->ppalette = NULL;
    dest->pdata = NULL;
    dest->pred = dest->pgreen = dest->pblue = NULL;

    npalette = 0;
    if (dest->bits <= 8) {
        for (i = 0, npalette = 1; i < dest->bits; i++)
            npalette *= 2;
    }

    if (npalette) {
        dest->ppalette = (GEHL_PAL*)malloc(sizeof(GEHL_PAL)*npalette);
        if (NULL == dest->ppalette)
            return -1;
        memcpy(dest->ppalette, src->ppalette, sizeof(GEHL_PAL) * npalette);
    }

    if (npalette)
        imgsize = src->width * src->height;
    else
        imgsize = 3 * src->width * src->height;

    dest->pdata = (unsigned char *)malloc(imgsize);
    if (NULL == dest->pdata)
        return -1;
    memcpy(dest->pdata, src->pdata, imgsize);

    if (npalette == 0) {
        dest->pred = dest->pdata;
        dest->pgreen = dest->pred + (src->width * src->height);
        dest->pblue = dest->pgreen + (src->width * src->height);
    }

    return 0;
}

