/* Test program for gehl_bmp module */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "gehl_types.h"
#include "gehl.h"


int
main(int argc, char **argv)
{
    GEHL_IMG img, keep;
    int ret;
    char fname[256];

    if(argc < 2){
        fprintf(stderr, "Usage: %s imagefile.bmp degree\n", argv[0]);
        return -1;
    }
    memset(&img, 0, sizeof(GEHL_IMG));

    ret = GEHL_Load(argv[1], &img);
    if (ret != 0){
        fprintf(stderr, "read error\n");
        return -1;
    }

    GEHL_Copy(&keep, &img);

    ret = GEHL_Edge(&img, GEHL_EDGEFILTER_SOBEL);
    if (ret) {
        fprintf(stderr, "sobel failure\n");
        GEHL_Free(&img);
        GEHL_Free(&keep);
        return -1;
    }
    sprintf(fname, "out_sobel.bmp");
    GEHL_Save(fname, &img, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&img);

    ret = GEHL_Edge(&keep, GEHL_EDGEFILTER_PREWITT);
    if (ret) {
        fprintf(stderr, "prewitt failure\n");
        GEHL_Free(&keep);
        return -1;
    }
    sprintf(fname, "out_prewitt.bmp");
    GEHL_Save(fname, &keep, GEHL_FILEFORMAT_WINDIB);
    GEHL_Free(&keep);

    printf("finished\n");

    return 0;
}
