/*
 * Decompiled with CFR 0.152.
 */
package mkgethtml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import mkgethtml.Config;
import mkgethtml.Enumeration;
import mkgethtml.UrlHandler;
import models.Chapter;
import models.PageConfig;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import resource.text.Messages;
import utils.CommonValue;
import utils.InstallCert;
import utils.IpHandler;

public class GetHtmlCss {
    public static Boolean checkPageFound(Element listTagAUrl, String firstChapterLink, String lastChapterLink, PageConfig p) {
        int size = listTagAUrl.select("a").size();
        String chapterLinkToCompare = "";
        if (p.getOverMaxSizePageCountState() == Enumeration.OverMaxSizePageCountState.MOVE_TO_PAGE_WITHOUT_CHAPTER_LIST) {
            if (size < 1) {
                return true;
            }
            return false;
        }
        if (p.getOverMaxSizePageCountState() == Enumeration.OverMaxSizePageCountState.MOVE_TO_LAST) {
            chapterLinkToCompare = listTagAUrl.select("a").eq(size - 1).attr("href").toString();
            return chapterLinkToCompare.equalsIgnoreCase(lastChapterLink);
        }
        chapterLinkToCompare = listTagAUrl.select("a").eq(0).attr("href").toString();
        return chapterLinkToCompare.equalsIgnoreCase(firstChapterLink);
    }

    public static Document filterHtml(Document doc, String cssRemoveContent) {
        try {
            String[] listFilter;
            String[] stringArray = listFilter = cssRemoveContent.split(";");
            int n = listFilter.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (!str.isEmpty()) {
                    if (GetHtmlCss.isHtmlAttr(str).booleanValue()) {
                        String attrName = str.substring(str.indexOf("[") + 1, str.length() - 1);
                        doc.select(str).removeAttr(attrName);
                    } else {
                        doc.select(str).remove();
                    }
                }
                ++n2;
            }
        }
        catch (Exception e1) {
            System.out.println(e1.getMessage());
        }
        return doc;
    }

    public static Elements filterHtml(Elements e, String cssRemoveContent) {
        if (cssRemoveContent != null) {
            String strContentFilter = "";
            String strRemoveContentX = cssRemoveContent;
            int iStart = cssRemoveContent.indexOf(34);
            int iEnd = cssRemoveContent.lastIndexOf(34);
            if (iStart > -1 && iEnd > -1) {
                strContentFilter = cssRemoveContent.substring(iStart + 1, iEnd);
                strRemoveContentX = String.valueOf(cssRemoveContent.substring(0, iStart - 1)) + cssRemoveContent.substring(iEnd + 1);
            }
            try {
                String[] listFilter;
                String[] stringArray = listFilter = strRemoveContentX.split(";");
                int n = listFilter.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (!str.isEmpty()) {
                        if (GetHtmlCss.isHtmlAttr(str).booleanValue()) {
                            String attrName = str.substring(str.indexOf("[") + 1, str.length() - 1);
                            e.select(str).removeAttr(attrName);
                        } else {
                            e.select(str).remove();
                        }
                    }
                    ++n2;
                }
                if (!strContentFilter.isEmpty()) {
                    String[] listFilterStr = strContentFilter.split(",");
                    String sb = e.html();
                    String[] stringArray2 = listFilterStr;
                    int n3 = listFilterStr.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String str = stringArray2[n4];
                        sb = sb.replace(str, "");
                        ++n4;
                    }
                    e.html(sb.toString());
                }
            }
            catch (Exception e1) {
                System.out.println(e1.getMessage());
            }
        }
        return e;
    }

    public static Chapter getChapterTitleAndContent(int id, String chapterUrl, String cssChapterTitle, String cssChapterContent, String cssRemoveContent, Boolean isEnableChapterSign, Boolean isUseJsoupGet) throws IOException {
        Chapter back = new Chapter();
        Document htmlPage = null;
        String html = GetHtmlCss.getHtmlStringFromURLbyCharset(chapterUrl, isUseJsoupGet);
        if (html.isEmpty()) {
            return back;
        }
        htmlPage = Jsoup.parse(html, Config.get(Enumeration.EnumConfigKey.ENCODING).toString());
        Boolean bIsHasCapcha = GetHtmlCss.checkIsHasGoogleCapchaBlock(htmlPage, chapterUrl);
        if (!bIsHasCapcha.booleanValue()) {
            Elements content = htmlPage.select(cssChapterContent);
            if (content == null) {
                return back;
            }
            if (isEnableChapterSign.booleanValue()) {
                if (htmlPage.select(cssChapterTitle).size() == 0) {
                    back.setTitle(CommonValue.getChapterNameWithSignal(id + 1, ""));
                } else {
                    back.setTitle(CommonValue.getChapterNameWithSignal(id + 1, htmlPage.select(cssChapterTitle).first().text().trim()));
                }
            } else if (!cssChapterTitle.isEmpty() && !htmlPage.select(cssChapterTitle).isEmpty()) {
                back.setTitle(htmlPage.select(cssChapterTitle).first().text().trim());
            } else {
                back.setTitle("");
            }
            Elements imgs = content.select("img");
            htmlPage.children().stream().close();
            StringBuilder sb = new StringBuilder();
            int startPos = 0;
            int lastPos = -1;
            sb.append(content.html());
            int i = 0;
            while (i < imgs.size()) {
                lastPos = sb.indexOf("<img", startPos);
                String strInsert = String.format(Messages.getGlobalString("log.viewImageOfChapter"), ((Element)imgs.get(i)).attr("src").toString(), i + 1);
                if (lastPos > -1) {
                    sb.insert(lastPos, strInsert);
                }
                startPos = lastPos + strInsert.length() + 10;
                ++i;
            }
            content.html(sb.toString());
            content = GetHtmlCss.filterHtml(content, cssRemoveContent);
            if (imgs.size() > 0) {
                back.setContent(String.valueOf(CommonValue.getIDandTitleString(id, back.getTitle())) + Messages.getGlobalString("log.chapterHasImage") + content.html());
            } else {
                back.setContent(String.valueOf(CommonValue.getIDandTitleString(id, back.getTitle())) + content.html());
            }
        } else {
            back.setIsHasCapchaBlock(bIsHasCapcha);
        }
        return back;
    }

    public static StringBuilder customHtmlStringBeforeParse(StringBuilder html, String url) {
        if (url.contains("truyen.tangthuvien")) {
            int start = 0;
            int end = 0;
            start = html.indexOf("box-chap");
            if (start > 0) {
                end = html.indexOf("</div>", start += 10);
            }
            if (start > 0 && end > 0) {
                String content = html.subSequence(start, end).toString();
                content = content.replaceAll("\\r|\\n", "<br>");
                html.replace(start, end, "");
                html.insert(start, content);
            }
        }
        return html;
    }

    public static String getHtmlStringFromURLbyCharset(String url, Boolean isUseJsoupGet) {
        String back = "";
        try {
            if (isUseJsoupGet.booleanValue()) {
                Document docHTML = null;
                docHTML = Jsoup.connect(url).userAgent(CommonValue.USER_AGENT).timeout(CommonValue.TIME_OUT * 1000).get();
                docHTML.outputSettings().charset(Config.get(Enumeration.EnumConfigKey.ENCODING).toString());
                back = docHTML.html();
            } else {
                URL u = new URL(url);
                InputStream is = null;
                HttpURLConnection conn = null;
                int respondCode = 0;
                conn = (HttpURLConnection)u.openConnection();
                conn.setConnectTimeout(CommonValue.TIME_OUT * 1000);
                conn.setRequestProperty("User-Agent", CommonValue.USER_AGENT);
                if (url.contains("truyencv")) {
                    conn.setRequestProperty("X-Forwarded-For", IpHandler.getNewIPAddress());
                    conn.setRequestProperty("Cookie", Config.get(Enumeration.EnumConfigKey.TRUYENCVUSERID).toString());
                }
                if (url.contains("wikidich")) {
                    conn.setRequestProperty("Host", "wikidich.com");
                }
                conn.connect();
                respondCode = conn.getResponseCode();
                if (respondCode == 301) {
                    String redirect = conn.getHeaderField("Location");
                    conn.disconnect();
                    conn = redirect.startsWith("https://") ? (HttpsURLConnection)new URL(redirect).openConnection() : (HttpURLConnection)new URL(redirect).openConnection();
                    conn.setConnectTimeout(CommonValue.TIME_OUT * 1000);
                    conn.setRequestProperty("User-Agent", CommonValue.USER_AGENT);
                    if (url.contains("truyencv")) {
                        conn.setRequestProperty("X-Forwarded-For", IpHandler.getNewIPAddress());
                    }
                    if (url.contains("wikidich")) {
                        conn.setRequestProperty("Host", "wikidich.com");
                    }
                }
                is = conn.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String tempReader = "";
                StringBuilder sb = new StringBuilder();
                while ((tempReader = br.readLine()) != null) {
                    sb.append(tempReader);
                    sb.append("\n");
                }
                br.close();
                if (conn != null) {
                    conn.disconnect();
                }
                sb = GetHtmlCss.customHtmlStringBeforeParse(sb, url);
                back = sb.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return back;
    }

    public static ArrayList<String> getListChaptersOnPage(Element listTagAUrl) throws IOException {
        ArrayList<String> listChapter = new ArrayList<String>();
        listTagAUrl.select("a").forEach(a -> listChapter.add(a.attr("href").toString()));
        return listChapter;
    }

    public static Element getListTagAUrlSpecialCssQuery(Document doc, String cssQueryListChapter, ArrayList<String> specialList) {
        int end;
        int start;
        Elements list = doc.select(cssQueryListChapter).select("a");
        try {
            start = Integer.parseInt(specialList.get(0));
            end = UrlHandler.eval(specialList.get(1).replace("n", String.valueOf(list.size())));
        }
        catch (Exception e) {
            start = 0;
            end = list.size();
        }
        Element listTagAUrl = doc.createElement("div");
        int i = start;
        while (i < end) {
            listTagAUrl.appendChild((Node)list.get(i));
            ++i;
        }
        return listTagAUrl;
    }

    public static String getRespondLocation(String url) throws IOException, SSLHandshakeException {
        URL u = new URL(url);
        HttpURLConnection huc = (HttpURLConnection)u.openConnection();
        huc.setRequestMethod("GET");
        try {
            huc.connect();
        }
        catch (SSLHandshakeException e) {
            try {
                InstallCert.main(new String[]{u.getHost()});
                huc.connect();
                throw new Exception();
            }
            catch (Exception e1) {
                throw new SSLHandshakeException(e.getMessage());
            }
        }
        return huc.getURL().toString();
    }

    public static ArrayList<String> getSpecialStringFromQuery(String cssQueryListChapter) {
        String specString = cssQueryListChapter.split("[\\{\\}]")[1];
        String[] arrSpecString = specString.split("&");
        ArrayList<String> arrListSpec = new ArrayList<String>();
        int i = 0;
        while (i < arrSpecString.length) {
            if (!arrSpecString[i].isEmpty()) {
                String[] arrTemp = arrSpecString[i].split("=");
                arrListSpec.add(arrTemp[1].toLowerCase());
            }
            ++i;
        }
        if (arrListSpec.size() < 1) {
            arrListSpec.add("0");
            arrListSpec.add("n");
        }
        return arrListSpec;
    }

    public static Boolean isHtmlAttr(String tagToCheck) {
        return tagToCheck.trim().startsWith("[");
    }

    private static Boolean checkIsHasGoogleCapchaBlock(Document document, String sHostName) {
        String sHtmlContent;
        Elements e;
        Boolean bIsHasCapcha = false;
        if (document != null && sHostName.contains("truyencv") && (e = document.select("body")) != null && (sHtmlContent = e.html()).indexOf("recaptcha") > 0) {
            bIsHasCapcha = true;
        }
        return bIsHasCapcha;
    }
}

