/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import main.CopyRightInfo;
import main.DownloadRange;
import main.FindAndReplace;
import mkgethtml.Config;
import mkgethtml.Enumeration;
import models.PageConfig;
import resource.text.Messages;
import thread.TManual;

public class ManualGetUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    JProgressBar progressBar = new JProgressBar();
    JButton btnDownload = new JButton(Messages.getString("ManualGetUI.btnDownload.text"));
    JButton btnCancel = new JButton(Messages.getString("ManualGetUI.btnCancel.text"));
    JLabel lblStatus = new JLabel(Messages.getString("ManualGetUI.lblNone.text"));
    JTextArea txtInput;
    JTextArea txtLog;
    JComboBox<PageConfig> comboBox;
    JButton btnResume;
    TManual threadMannualGet;
    JPopupMenu popupMenu;
    JButton btnHelp;
    PageConfig p;
    JCheckBox chckbxDownloadWithSelected;
    CopyRightInfo cri;

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ManualGetUI frame = new ManualGetUI();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ManualGetUI() {
        this.initlize();
    }

    public ManualGetUI(String pageCode) {
        this.initlize();
        PageConfig check = new PageConfig(pageCode.toLowerCase().trim());
        int size = this.comboBox.getItemCount();
        int i = 0;
        while (i < size) {
            if (this.comboBox.getItemAt(i).equals(check)) {
                this.comboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    void enableForm(Boolean b) {
        this.btnDownload.setEnabled(b);
        this.btnCancel.setEnabled(b == false);
    }

    void getListToCombo() {
        this.comboBox.removeAllItems();
        ArrayList<PageConfig> list = Config.getAllHostConfig();
        for (PageConfig pageConfig : list) {
            if (!pageConfig.getIsManualGet().booleanValue()) continue;
            this.comboBox.addItem(pageConfig);
        }
    }

    void initlize() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (!ManualGetUI.this.btnDownload.isEnabled()) {
                    int confirm = JOptionPane.showOptionDialog(null, Messages.getGlobalString("warning.inDownloading"), Messages.getGlobalString("title.Downloading"), 0, 3, null, new String[]{Messages.getGlobalString("yes"), Messages.getGlobalString("no")}, Messages.getGlobalString("no"));
                    if (confirm == 0) {
                        ManualGetUI.this.threadMannualGet.cancel();
                        arg0.getWindow().dispose();
                    }
                } else {
                    arg0.getWindow().dispose();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ManualGetUI.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        Locale.setDefault(new Locale(Config.get(Enumeration.EnumConfigKey.LANGUAGE).toString()));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ManualGetUI.class.getResource("/resource/box-16.png")));
        this.setTitle(Messages.getString("ManualGetUI.this.title"));
        this.setDefaultCloseOperation(0);
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e2) {
            e2.printStackTrace();
        }
        this.setBounds(100, 100, 691, 522);
        this.popupMenu = new JPopupMenu();
        ManualGetUI.addPopup(this, this.popupMenu);
        JMenuItem mntmPasteHtml = new JMenuItem(Messages.getString("ManualGetUI.mntmPasteHtml.text"));
        mntmPasteHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ManualGetUI.this.txtInput.setText(Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString());
                }
                catch (HeadlessException | UnsupportedFlavorException | IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        mntmPasteHtml.setIcon(new ImageIcon(ManualGetUI.class.getResource("/resource/Paste-16.png")));
        this.popupMenu.add(mntmPasteHtml);
        JMenuItem mntmDownload = new JMenuItem(Messages.getString("ManualGetUI.mntmDownload.text"));
        mntmDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualGetUI.this.btnDownload.doClick();
            }
        });
        JSeparator separator = new JSeparator();
        this.popupMenu.add(separator);
        mntmDownload.setIcon(new ImageIcon(ManualGetUI.class.getResource("/resource/Down-16.png")));
        this.popupMenu.add(mntmDownload);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, Messages.getString("ManualGetUI.panel.borderTitle"), 4, 2, null, null));
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(null, Messages.getString("ManualGetUI.panel_1.borderTitle"), 4, 2, null, null));
        panel_1.setLayout(new GridLayout(0, 1, 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        panel_1.add(scrollPane);
        this.txtLog = new JTextArea();
        this.txtLog.setFont(new Font("SansSerif", 0, 11));
        this.txtLog.setEditable(false);
        this.txtLog.setCursor(Cursor.getPredefinedCursor(2));
        this.txtLog.setBackground(Color.GRAY);
        this.txtLog.setForeground(new Color(0, 255, 0));
        this.txtLog.setLineWrap(true);
        scrollPane.setViewportView(this.txtLog);
        GroupLayout gl_contentPane = new GroupLayout(this.contentPane);
        gl_contentPane.setHorizontalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(panel, -1, 665, Short.MAX_VALUE).addComponent(panel_1, -1, 665, Short.MAX_VALUE));
        gl_contentPane.setVerticalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_contentPane.createSequentialGroup().addComponent(panel, -1, 382, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panel_1, -2, 137, -2)));
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBorder(new TitledBorder(null, "HTML (CTRL+V)", 1, 2, null, null));
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ManualGetUI.this.p = (PageConfig)ManualGetUI.this.comboBox.getSelectedItem();
                ManualGetUI.this.btnHelp.setText(String.valueOf(Messages.getString("ManualGetUI.btnHelp.text")) + "\"" + ManualGetUI.this.p.getPageCode() + "\"");
            }
        });
        JLabel lblHost = new JLabel(Messages.getString("ManualGetUI.lblHost.text"));
        this.btnResume = new JButton(Messages.getString("ManualGetUI.btnResumeretry.text"));
        this.btnResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManualGetUI.this.threadMannualGet.start();
                ManualGetUI.this.btnResume.setEnabled(false);
            }
        });
        this.btnResume.setEnabled(false);
        this.btnHelp = new JButton(Messages.getString("ManualGetUI.btnHelp.text"));
        this.btnHelp.setHorizontalAlignment(2);
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ManualGetUI.this.p.getScriptJS().trim() != "") {
                    Object[] options = new String[]{Messages.getGlobalString("btn.copyScript"), Messages.getGlobalString("btn.close")};
                    Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                    if (JOptionPane.showOptionDialog(null, ManualGetUI.this.p.getTextGuide(), Messages.getGlobalString("title.help"), 0, 1, null, options, options[0]) == 0) {
                        c.setContents(new StringSelection(ManualGetUI.this.p.getScriptJS()), null);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, ManualGetUI.this.p.getTextGuide(), String.valueOf(Messages.getString("ManualGetUI.btnHelp.text")) + ManualGetUI.this.p.getPageCode(), 1);
                }
            }
        });
        this.btnHelp.setIcon(new ImageIcon(ManualGetUI.class.getResource("/resource/help-desk-icon.png")));
        this.btnHelp.setBorder(null);
        this.btnHelp.setContentAreaFilled(false);
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getString("ManualGetUI.panel_2.borderTitle"), 1, 2, null, new Color(0, 0, 0)));
        panel_2.setLayout(new GridLayout(2, 2, 0, 0));
        this.chckbxDownloadWithSelected = new JCheckBox(Messages.getString("ManualGetUI.chckbxDownloadWithSelected.text"));
        this.chckbxDownloadWithSelected.setToolTipText(Messages.getString("ManualGetUI.chckbxDownloadWithSelected.toolTipText"));
        panel_2.add(this.chckbxDownloadWithSelected);
        final JCheckBox chckbxAddEbookInfo = new JCheckBox(Messages.getString("ManualGetUI.chckbxAddebookinfo.text"));
        chckbxAddEbookInfo.setToolTipText(Messages.getString("ManualGetUI.chckbxAddEbookInfo.toolTipText"));
        chckbxAddEbookInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ManualGetUI.this.txtInput.getText().trim().equals("")) {
                    JOptionPane.showMessageDialog(null, Messages.getGlobalString("warning.pleaseInputContent"));
                    ManualGetUI.this.txtInput.requestFocus();
                } else if (chckbxAddEbookInfo.isSelected()) {
                    ManualGetUI.this.cri = new CopyRightInfo(ManualGetUI.this.btnDownload);
                    ManualGetUI.this.cri.setVisible(true);
                }
                chckbxAddEbookInfo.setSelected(false);
            }
        });
        panel_2.add(chckbxAddEbookInfo);
        chckbxAddEbookInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    ManualGetUI.this.popupMenu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
                }
            }
        });
        this.chckbxDownloadWithSelected.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ManualGetUI.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ManualGetUI.this.txtInput.getText().isEmpty()) {
                    JOptionPane.showMessageDialog(null, Messages.getGlobalString("warning.pleaseInputContent"));
                    return;
                }
                JFileChooser jfc = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter(Messages.getGlobalString("file.fileExtensionHTML"), "htm", "html");
                FileNameExtensionFilter filter1 = new FileNameExtensionFilter(Messages.getGlobalString("file.fileExtensionTXT"), "txt");
                jfc.addChoosableFileFilter(filter);
                jfc.addChoosableFileFilter(filter1);
                jfc.setDialogTitle(Messages.getGlobalString("file.chooseSavePath"));
                String defaultFileName = "";
                if (ManualGetUI.this.txtInput.getText().contains("<title>")) {
                    int i1 = ManualGetUI.this.txtInput.getText().indexOf("<title>");
                    int i2 = ManualGetUI.this.txtInput.getText().indexOf("</title>");
                    defaultFileName = ManualGetUI.this.txtInput.getText().substring(i1 + 7, i2);
                    defaultFileName = defaultFileName.replaceAll("[\\|\\\\\\/\\;\\:\\\"\\*\\<\\>\\?]+", " ");
                }
                try {
                    if (defaultFileName != "") {
                        String recentFolder = String.valueOf((String)Config.get(Enumeration.EnumConfigKey.RECENT_FOLDER)) + File.separator + defaultFileName;
                        jfc.setSelectedFile(new File(recentFolder));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    jfc.setSelectedFile(new File(File.listRoots()[1] + File.separator + defaultFileName));
                }
                jfc.setFileFilter(filter);
                if (jfc.showSaveDialog(null) != 0) {
                    return;
                }
                String path = jfc.getSelectedFile().getPath();
                if (filter.equals(jfc.getFileFilter())) {
                    if (!path.toLowerCase().contains(".html")) {
                        path = String.valueOf(path) + ".html";
                    }
                } else if (filter1.equals(jfc.getFileFilter()) && !path.toLowerCase().contains(".txt")) {
                    if (!path.toLowerCase().contains(".txt")) {
                        path = String.valueOf(path) + ".txt";
                    }
                } else {
                    path = String.valueOf(path) + ".html";
                }
                Config.put(Enumeration.EnumConfigKey.RECENT_FOLDER, jfc.getSelectedFile().getParentFile().getPath());
                Config.saveConfig(Enumeration.ConfigType.Setting);
                ManualGetUI.this.txtLog.setText("");
                if (ManualGetUI.this.chckbxDownloadWithSelected.isSelected()) {
                    DownloadRange.visiable = true;
                    ManualGetUI.this.chckbxDownloadWithSelected.setSelected(false);
                }
                ManualGetUI.this.threadMannualGet = new TManual(ManualGetUI.this.btnCancel, ManualGetUI.this.btnDownload, ManualGetUI.this.btnResume, ManualGetUI.this.txtInput.getText(), path, ManualGetUI.this.lblStatus, ManualGetUI.this.txtLog, ManualGetUI.this.progressBar, (PageConfig)ManualGetUI.this.comboBox.getSelectedItem(), ManualGetUI.this.cri != null ? ManualGetUI.this.cri.ebookInfo : "", false);
                ManualGetUI.this.threadMannualGet.start();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManualGetUI.this.threadMannualGet.cancel();
                ManualGetUI.this.btnResume.setEnabled(true);
            }
        });
        this.txtInput = new JTextArea();
        this.txtInput.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ManualGetUI.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.txtInput.setWrapStyleWord(true);
        this.txtInput.setLineWrap(true);
        this.txtInput.setFont(new Font("SansSerif", 0, 11));
        this.txtInput.setBackground(Color.WHITE);
        this.txtInput.setForeground(SystemColor.textHighlight);
        final UndoManager undo = new UndoManager();
        Document doc = this.txtInput.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        this.txtInput.getActionMap().put("Undo", new AbstractAction("Undo"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.txtInput.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.txtInput.getActionMap().put("Redo", new AbstractAction("Redo"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.txtInput.getInputMap().put(KeyStroke.getKeyStroke("control R"), "Redo");
        scrollPane_1.setViewportView(this.txtInput);
        JPanel panel_5 = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)panel_5.getLayout();
        flowLayout_1.setAlignment(0);
        flowLayout_1.setVgap(1);
        flowLayout_1.setHgap(1);
        scrollPane_1.setColumnHeaderView(panel_5);
        JButton btnSearchReplace = new JButton(Messages.getString("ManualGetUI.btnSearchReplace.text"));
        btnSearchReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAndReplace far = new FindAndReplace(ManualGetUI.this.txtInput);
                far.setVisible(true);
            }
        });
        btnSearchReplace.setToolTipText(Messages.getString("ManualGetUI.btnSearchReplace.toolTipText"));
        btnSearchReplace.setBorderPainted(false);
        btnSearchReplace.setMargin(new Insets(1, 1, 1, 1));
        btnSearchReplace.setContentAreaFilled(false);
        btnSearchReplace.setActionCommand(Messages.getString("ManualGetUI.btnSearchReplace.actionCommand"));
        btnSearchReplace.setIcon(new ImageIcon(ManualGetUI.class.getResource("/resource/Find and Replace-16.png")));
        panel_5.add(btnSearchReplace);
        JButton btnUndo = new JButton(Messages.getString("ManualGetUI.btnUndo.text_1"));
        btnUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (undo.canUndo()) {
                    undo.undo();
                }
            }
        });
        btnUndo.setMargin(new Insets(1, 1, 1, 1));
        btnUndo.setContentAreaFilled(false);
        btnUndo.setIcon(new ImageIcon(ManualGetUI.class.getResource("/resource/Undo-16.png")));
        btnUndo.setToolTipText(Messages.getString("ManualGetUI.btnUndo.toolTipText_1"));
        panel_5.add(btnUndo);
        JButton btnRedo = new JButton(Messages.getString("ManualGetUI.btnRedi.text"));
        btnRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (undo.canRedo()) {
                    undo.redo();
                }
            }
        });
        btnRedo.setToolTipText(Messages.getString("ManualGetUI.btnRedo.toolTipText"));
        btnRedo.setMargin(new Insets(1, 1, 1, 1));
        btnRedo.setContentAreaFilled(false);
        btnRedo.setBorderPainted(false);
        btnRedo.setIcon(new ImageIcon(ManualGetUI.class.getResource("/resource/Redo-16.png")));
        panel_5.add(btnRedo);
        JButton btnPasteLink = new JButton(Messages.getString("ManualGetUI.btnPasteLink.text"));
        btnPasteLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String link = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
                    if (link.length() < 2000) {
                        ManualGetUI.this.txtInput.append("<a href=\"" + link + "\">Paste Link</a>\r\n");
                    }
                }
                catch (HeadlessException | UnsupportedFlavorException | IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        btnPasteLink.setToolTipText(Messages.getString("ManualGetUI.btnPasteLink.toolTipText"));
        btnPasteLink.setIcon(new ImageIcon(ManualGetUI.class.getResource("/resource/Link-16.png")));
        btnPasteLink.setMargin(new Insets(1, 1, 1, 1));
        btnPasteLink.setContentAreaFilled(false);
        panel_5.add(btnPasteLink);
        JButton btnCleanText = new JButton(Messages.getString("ManualGetUI.btnCleanText.text"));
        btnCleanText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManualGetUI.this.txtInput.setText("");
                ManualGetUI.this.txtInput.requestFocus();
            }
        });
        btnCleanText.setToolTipText(Messages.getString("ManualGetUI.btnCleanText.toolTipText"));
        btnCleanText.setIcon(new ImageIcon(ManualGetUI.class.getResource("/resource/Erase-16.png")));
        btnCleanText.setMargin(new Insets(1, 1, 1, 1));
        btnCleanText.setContentAreaFilled(false);
        panel_5.add(btnCleanText);
        panel.setLayout(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("2dlu"), ColumnSpec.decode("60px"), ColumnSpec.decode("2dlu"), ColumnSpec.decode("442px:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode("112px")}, new RowSpec[]{FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("23px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("23px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("69px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("125px:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("23px"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode("23px")}));
        panel.add((Component)lblHost, "2, 2, center, center");
        panel.add((Component)panel_2, "4, 6, left, top");
        panel.add((Component)this.btnResume, "6, 6, fill, top");
        panel.add(this.comboBox, "4, 2, fill, center");
        panel.add((Component)this.btnHelp, "4, 4, fill, center");
        panel.add((Component)this.btnCancel, "6, 4, fill, top");
        panel.add((Component)this.btnDownload, "6, 2, fill, top");
        panel.add((Component)scrollPane_1, "2, 8, 5, 1, fill, fill");
        JLabel lblNewLabel = new JLabel(Messages.getString("ManualGetUI.lblNewLabel.text"));
        panel.add((Component)lblNewLabel, "2, 10");
        panel.add((Component)this.lblStatus, "4, 10");
        panel.add((Component)this.progressBar, "2, 12, 5, 1, fill, fill");
        this.contentPane.setLayout(gl_contentPane);
        this.enableForm(true);
        this.getListToCombo();
    }
}

