/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javafx.application.Platform;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.CopyRightInfo;
import main.DownloadRange;
import main.Info;
import main.Main;
import main.ManualGetUI;
import main.Update;
import mkbrowser.MKBrowser;
import mkgethtml.Config;
import mkgethtml.Enumeration;
import mkgethtml.GetHtmlCss;
import models.PageConfig;
import resource.text.Messages;
import thread.TAuto;
import utils.CheckUpdate;
import utils.CommonValue;
import utils.FileUtil;
import utils.UrlHandler;

public class UI {
    public JFrame jfrmUiGetHtml;
    private JTextField txtURL;
    JComboBox<PageConfig> cboPageConfigList;
    JProgressBar progressBar;
    JLabel lblStatus;
    TAuto tAuto;
    JButton btnCancel;
    JButton btnDownload;
    JButton btnResume;
    public JTextArea txtLog;
    JPopupMenu popupMenu;
    JCheckBox chckbxAddEbookInfo;
    JCheckBox chckbxDownloadFrom;
    public JCheckBox chckbxOneFilePer;
    JButton btnHelp;
    PageConfig p;
    JComboBox<String> cboHostType;
    JMenuItem mntmLoginTo;
    public JButton btnHostCount;
    CopyRightInfo cri;
    int isHelpShowHitCount = 0;
    int countChildWindow = 0;
    private JTextField txtFilter;

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public static void main(String[] args) throws IOException {
        CommonValue.initValue();
        System.setProperty("file.encoding", "UTF-8");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.window.jfrmUiGetHtml.setVisible(true);
            }
        });
    }

    public UI() {
        this.initialize();
        try {
            Object chkOneFilePerChapState = Config.get(Enumeration.EnumConfigKey.REMEMBER_ONE_PER_FILE);
            if (chkOneFilePerChapState != null) {
                Boolean chkState = (Boolean)chkOneFilePerChapState;
                this.chckbxOneFilePer.setSelected(chkState);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    CheckUpdate checkUpdate(Boolean isCheckOnly) throws IOException {
        CheckUpdate check = new CheckUpdate();
        if (!check.isUpdated().booleanValue() && !isCheckOnly.booleanValue()) {
            Update frameUpdate = null;
            frameUpdate = check.isAppUpdated == false ? new Update(String.format(Messages.getGlobalString("notify.updateSoftware"), CommonValue.APP_VERSION, check.jarName.replaceAll("[^\\.\\d]", "")), check.message, Messages.getGlobalString("btn.update"), Messages.getGlobalString("btn.skip"), check) : new Update(Messages.getGlobalString("notify.updateNweConfigFile"), check.message, Messages.getGlobalString("btn.update"), Messages.getGlobalString("btn.skip"), check);
            frameUpdate.frmUpdate.setVisible(true);
        }
        return check;
    }

    void doWork() {
        if (!this.txtURL.getText().toLowerCase().trim().contains("http://") && !this.txtURL.getText().toLowerCase().trim().contains("https://")) {
            JOptionPane.showMessageDialog(null, Messages.getGlobalString("warning.linkPathMustBeStartWithHttp"));
            return;
        }
        try {
            URL u = new URL(this.txtURL.getText());
            int checkHost = Config.isSupportHost(u.getHost());
            if (checkHost == 0) {
                JOptionPane.showMessageDialog(null, String.format(Messages.getGlobalString("notify.hostDoesNotSupportTryAddOne"), u.getHost()));
                return;
            }
            if (checkHost == -1 && JOptionPane.showConfirmDialog(null, String.format(Messages.getGlobalString("message.hostUseForManualGet"), u.getHost()), Messages.getGlobalString("title.notify"), 0, 3) == 0) {
                new ManualGetUI(u.getHost()).setVisible(true);
                return;
            }
            String urlCheck = u.toString();
            try {
                urlCheck = GetHtmlCss.getRespondLocation(u.toString());
            }
            catch (SSLHandshakeException e) {
                this.txtLog.append(e.getMessage());
                this.txtLog.append("\n-----------------------------");
                this.txtLog.append(String.format(Messages.getGlobalString("log.certificateDoesNotExist"), u.getHost()));
                this.txtLog.append(String.format("log.addedNewCertificate", new Object[0]));
                this.txtLog.append("\n-----------------------------");
                this.txtLog.append(String.format(Messages.getGlobalString("log.restartAppToApplyChangeCert"), new Object[0]));
                this.txtLog.append("\n-----------------------------");
                this.txtLog.setCaretPosition(this.txtLog.getText().length());
                return;
            }
            catch (IOException e) {
                this.txtLog.append(e.getMessage());
                e.printStackTrace();
            }
            if (!u.toString().equalsIgnoreCase(urlCheck)) {
                JOptionPane.showMessageDialog(null, String.format(Messages.getGlobalString("message.pathDownloadInvalid"), new Object[0]));
                return;
            }
            JFileChooser jfc = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(Messages.getGlobalString("file.fileExtensionHTML"), "htm", "html");
            FileNameExtensionFilter filter1 = new FileNameExtensionFilter(Messages.getGlobalString("file.fileExtensionTXT"), "txt");
            jfc.addChoosableFileFilter(filter);
            jfc.addChoosableFileFilter(filter1);
            jfc.setDialogTitle(Messages.getGlobalString("file.chooseSavePath"));
            try {
                String fileName = u.getPath();
                if (fileName.charAt(fileName.length() - 1) == '/') {
                    fileName = fileName.substring(0, fileName.length() - 1);
                }
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                String recentFolder = String.valueOf((String)Config.get(Enumeration.EnumConfigKey.RECENT_FOLDER)) + File.separator + fileName;
                jfc.setSelectedFile(new File(recentFolder));
            }
            catch (Exception e) {
                e.printStackTrace();
                jfc.setSelectedFile(new File(u.getPath()));
            }
            jfc.setFileFilter(filter);
            if (jfc.showSaveDialog(null) != 0) {
                return;
            }
            String path = jfc.getSelectedFile().getPath();
            if (filter.equals(jfc.getFileFilter())) {
                if (!path.toLowerCase().contains(".html")) {
                    path = String.valueOf(path) + ".html";
                }
            } else if (filter1.equals(jfc.getFileFilter()) && !path.toLowerCase().contains(".txt")) {
                if (!path.toLowerCase().contains(".txt")) {
                    path = String.valueOf(path) + ".txt";
                }
            } else {
                path = String.valueOf(path) + ".html";
            }
            if (this.chckbxDownloadFrom.isSelected()) {
                DownloadRange.visiable = true;
                this.chckbxDownloadFrom.setSelected(false);
            }
            Config.put(Enumeration.EnumConfigKey.RECENT_FOLDER, jfc.getSelectedFile().getParentFile().getPath());
            Config.saveConfig(Enumeration.ConfigType.Setting);
            this.tAuto = new TAuto(this.btnCancel, this.btnDownload, this.btnResume, u.toString(), path, this.lblStatus, this.txtLog, this.progressBar, this.cri != null ? this.cri.ebookInfo : "", this.chckbxOneFilePer.isSelected());
            this.tAuto.start();
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    void updateHostCount() {
        this.btnHostCount.setText(String.valueOf(Config.getAllHostConfig().size()) + " Host");
    }

    void getListToCombo(String filterChain) {
        this.cboPageConfigList.removeAllItems();
        int filterGroup = 0;
        filterGroup = this.cboHostType.getSelectedIndex();
        if (filterChain.length() < 3) {
            for (PageConfig pageConfig : Config.getAllHostConfig()) {
                if (pageConfig.getIsManualGet().booleanValue()) continue;
                if (filterGroup == 0) {
                    this.cboPageConfigList.addItem(pageConfig);
                    continue;
                }
                if (filterGroup == 1 && pageConfig.getIsVietNameseHost().booleanValue()) {
                    this.cboPageConfigList.addItem(pageConfig);
                    continue;
                }
                if (filterGroup != 2 || pageConfig.getIsVietNameseHost().booleanValue()) continue;
                this.cboPageConfigList.addItem(pageConfig);
            }
        } else {
            for (PageConfig pageConfig : Config.getAllHostConfig()) {
                if (pageConfig.getIsManualGet().booleanValue() || !pageConfig.getPageCode().contains(filterChain)) continue;
                if (filterGroup == 0) {
                    this.cboPageConfigList.addItem(pageConfig);
                    continue;
                }
                if (filterGroup == 1 && pageConfig.getIsVietNameseHost().booleanValue()) {
                    this.cboPageConfigList.addItem(pageConfig);
                    continue;
                }
                if (filterGroup != 2) continue;
                this.cboPageConfigList.addItem(pageConfig);
            }
        }
    }

    private void initialize() {
        try {
            Locale.setDefault(new Locale(Config.get(Enumeration.EnumConfigKey.LANGUAGE).toString()));
        }
        catch (Exception e3) {
            Object del = Config.get(Enumeration.EnumConfigKey.DELETE_ON_EXIST);
            Config.reConfig();
            if (del != null) {
                Config.put(Enumeration.EnumConfigKey.DELETE_ON_EXIST, del.toString());
            }
            Locale.setDefault(new Locale(Config.get(Enumeration.EnumConfigKey.LANGUAGE).toString()));
        }
        this.jfrmUiGetHtml = new JFrame();
        this.jfrmUiGetHtml.getContentPane().setForeground(Color.RED);
        this.jfrmUiGetHtml.getContentPane().setFocusCycleRoot(true);
        this.jfrmUiGetHtml.getContentPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    UI.this.popupMenu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
                }
            }
        });
        this.jfrmUiGetHtml.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (!UI.this.btnDownload.isEnabled()) {
                    int confirm = JOptionPane.showOptionDialog(null, Messages.getGlobalString("warning.inDownloading"), Messages.getGlobalString("title.downloading"), 0, 3, null, new String[]{Messages.getGlobalString("btn.yes"), Messages.getGlobalString("btn.no")}, Messages.getGlobalString("btn.no"));
                    if (confirm == 0) {
                        Platform.exit();
                        FileUtil.deleteOldFiles();
                        System.exit(0);
                    }
                } else {
                    Platform.exit();
                    FileUtil.deleteOldFiles();
                    System.exit(0);
                }
            }

            @Override
            public void windowOpened(WindowEvent arg0) {
                UI.this.getListToCombo("");
                UI.this.btnHostCount.setText(String.valueOf(Config.getAllHostConfig().size()) + " Host");
            }
        });
        this.jfrmUiGetHtml.setIconImage(Toolkit.getDefaultToolkit().getImage(UI.class.getResource("/resource/box-16.png")));
        this.jfrmUiGetHtml.setTitle(String.valueOf(CommonValue.getAppName()) + " - by Mkbyme");
        this.jfrmUiGetHtml.setBounds(100, 100, 630, 480);
        this.jfrmUiGetHtml.setDefaultCloseOperation(0);
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e2) {
            e2.printStackTrace();
        }
        this.popupMenu = new JPopupMenu();
        UI.addPopup(this.jfrmUiGetHtml, this.popupMenu);
        JMenuItem mntmPaste = new JMenuItem(Messages.getString("UI.mntmPaste.text"));
        mntmPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString().length() < 2000) {
                        UI.this.txtURL.setText(Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString());
                    }
                }
                catch (HeadlessException | UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                }
            }
        });
        mntmPaste.setIcon(new ImageIcon(UI.class.getResource("/resource/Paste-16.png")));
        this.popupMenu.add(mntmPaste);
        JMenuItem mntmDownload = new JMenuItem(Messages.getString("UI.mntmDownload.text"));
        mntmDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UI.this.btnDownload.doClick();
            }
        });
        JSeparator separator_3 = new JSeparator();
        this.popupMenu.add(separator_3);
        mntmDownload.setIcon(new ImageIcon(UI.class.getResource("/resource/Down-16.png")));
        this.popupMenu.add(mntmDownload);
        JMenuBar menuBar = new JMenuBar();
        this.jfrmUiGetHtml.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu(Messages.getString("UI.mnFile.text"));
        menuBar.add(mnFile);
        JMenuItem mntmCit = new JMenuItem(Messages.getString("UI.mntmCit.text"));
        mntmCit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.pageConfigManager.setVisible(true);
            }
        });
        JMenuItem mntmCaSMi = new JMenuItem(Messages.getString("UI.mntmCaSMi.text"));
        mntmCaSMi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Runtime.getRuntime().exec("java -jar " + CommonValue.getAppJARFile().getAbsolutePath() + " launcher off");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        mntmCaSMi.setIcon(new ImageIcon(UI.class.getResource("/resource/box-16.png")));
        mnFile.add(mntmCaSMi);
        JSeparator separator_2 = new JSeparator();
        mnFile.add(separator_2);
        JMenuItem mntmOpenBrowser = new JMenuItem(Messages.getString("UI.mntmOpenBrowser.text"));
        mntmOpenBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Main.browser == null) {
                    Main.browser = new MKBrowser();
                }
                Main.browser.setVisible(true);
                Main.browser.loadURL("https://google.com");
            }
        });
        mntmOpenBrowser.setIcon(new ImageIcon(UI.class.getResource("/resource/browser-16.png")));
        mnFile.add(mntmOpenBrowser);
        JSeparator separator_6 = new JSeparator();
        mnFile.add(separator_6);
        mntmCit.setIcon(new ImageIcon(UI.class.getResource("/resource/Dropbox Filled-16.png")));
        mnFile.add(mntmCit);
        JMenuItem mntmSetting = new JMenuItem(Messages.getString("UI.mntmSetting.text"));
        mntmSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Main.setting.setVisible(true);
            }
        });
        mntmSetting.setIcon(new ImageIcon(UI.class.getResource("/resource/settings.png")));
        mnFile.add(mntmSetting);
        JSeparator separator_1 = new JSeparator();
        mnFile.add(separator_1);
        JMenuItem mntmMannualGet = new JMenuItem(Messages.getString("UI.mntmMannualGet.text"));
        mntmMannualGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new ManualGetUI().setVisible(true);
            }
        });
        mntmMannualGet.setIcon(new ImageIcon(UI.class.getResource("/resource/Whole Hand-16.png")));
        mnFile.add(mntmMannualGet);
        JSeparator separator = new JSeparator();
        mnFile.add(separator);
        JMenuItem mntmThot = new JMenuItem(Messages.getString("UI.mntmThot.text"));
        mntmThot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!UI.this.btnDownload.isEnabled()) {
                    int confirm = JOptionPane.showOptionDialog(null, Messages.getGlobalString("warning.inDownloading"), Messages.getGlobalString("title.downloading"), 0, 3, null, new String[]{Messages.getGlobalString("btn.yes"), Messages.getGlobalString("btn.no")}, Messages.getGlobalString("btn.no"));
                    if (confirm == 0) {
                        System.exit(0);
                    }
                } else {
                    System.exit(0);
                }
            }
        });
        mntmThot.setIcon(new ImageIcon(UI.class.getResource("/resource/log-out.png")));
        mnFile.add(mntmThot);
        JMenu mnAbout = new JMenu(Messages.getString("UI.mnAbout.text"));
        menuBar.add(mnAbout);
        JMenuItem mntmTcGi = new JMenuItem(Messages.getString("UI.mntmTcGi.text"));
        mntmTcGi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(null, "code by Mkbyme\nemail: mkbyme@gmail.com\nfacebook: fb.com/mkbyme", Messages.getGlobalString("title.author"), 1);
            }
        });
        mntmTcGi.setIcon(new ImageIcon(UI.class.getResource("/resource/copyright.png")));
        mnAbout.add(mntmTcGi);
        JMenuItem mntmTrGip = new JMenuItem(Messages.getString("UI.mntmTrGip.text"));
        mntmTrGip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Info i = new Info();
                i.setAlwaysOnTop(true);
                i.setAutoRequestFocus(true);
                i.setVisible(true);
            }
        });
        mntmTrGip.setIcon(new ImageIcon(UI.class.getResource("/resource/information.png")));
        mnAbout.add(mntmTrGip);
        JMenuItem mntmCheckUpdate = new JMenuItem(Messages.getString("UI.mntmCheckUpdate.text"));
        mntmCheckUpdate.setIcon(new ImageIcon(UI.class.getResource("/resource/Available Updates-16.png")));
        mntmCheckUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        CheckUpdate check = new CheckUpdate();
                        try {
                            check = UI.this.checkUpdate(false);
                            if (check.isAppUpdated & check.isConfigUpdated) {
                                JOptionPane.showMessageDialog(null, String.format(Messages.getGlobalString("notify.wasLastestUpdateVersion"), check.jarName, check.fileSize, new SimpleDateFormat("HH:mm:ss dd/MM/yyyy").format(check.date)));
                            }
                        }
                        catch (HeadlessException | IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                t.start();
            }
        });
        mnAbout.add(mntmCheckUpdate);
        JMenuItem mntmHomePage = new JMenuItem(Messages.getString("UI.mntmHomePage.text"));
        mntmHomePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Desktop.getDesktop().browse(new URI("https://sourceforge.net/projects/gethtmlfromurl/"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        JSeparator separator_4 = new JSeparator();
        mnAbout.add(separator_4);
        mntmHomePage.setIcon(new ImageIcon(UI.class.getResource("/resource/Home-16.png")));
        mnAbout.add(mntmHomePage);
        JMenuItem mntmFanPage = new JMenuItem(Messages.getString("UI.mntmFanPage.text"));
        mntmFanPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.facebook.com/gethtmlfromurl/?rc=p"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        mntmFanPage.setIcon(new ImageIcon(UI.class.getResource("/resource/Facebook-16.png")));
        mnAbout.add(mntmFanPage);
        JMenu mnHelpLink = new JMenu(Messages.getString("UI.mnHelpLink.text"));
        menuBar.add(mnHelpLink);
        JMenuItem mntmHowToUse = new JMenuItem(Messages.getString("UI.mntmHowToUse.text"));
        mntmHowToUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Desktop.getDesktop().browse(new URI("http://forum.truyencv.com/showthread.php?t=2125"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        mntmHowToUse.setIcon(new ImageIcon(UI.class.getResource("/resource/box-16.png")));
        mnHelpLink.add(mntmHowToUse);
        JMenuItem mntmHowToConvert = new JMenuItem(Messages.getString("UI.mntmHowToConvert.text"));
        mntmHowToConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e1) {
                try {
                    Desktop.getDesktop().browse(new URI("http://forum.truyencv.com/showthread.php?t=2266"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        mntmHowToConvert.setIcon(new ImageIcon(UI.class.getResource("/resource/help-desk-icon.png")));
        mnHelpLink.add(mntmHowToConvert);
        JMenuItem mntmHowToAdd = new JMenuItem(Messages.getString("UI.mntmHowToAdd.text"));
        mntmHowToAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e1) {
                try {
                    Desktop.getDesktop().browse(new URI("http://forum.truyencv.com/showthread.php?t=2125&page=6&p=31601&viewfull=1#post31601"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        mntmHowToAdd.setIcon(new ImageIcon(UI.class.getResource("/resource/Whole Hand-16.png")));
        mnHelpLink.add(mntmHowToAdd);
        JSeparator separator_5 = new JSeparator();
        mnHelpLink.add(separator_5);
        JMenuItem menuItem = new JMenuItem(Messages.getString("UI.menuItem.text_1"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CheckUpdate check = new CheckUpdate();
                check.isAppUpdated = true;
                check.isConfigUpdated = false;
                check.jarName = CommonValue.getAppJARFile().getName();
                check.setFileDownloadLink(CommonValue.getDownloadLinkConfigFile());
                Update frameUpdate = new Update(Messages.getGlobalString("title.downloadConfigFile"), Messages.getGlobalString("message.downloadConfigFile"), Messages.getGlobalString("btn.download"), Messages.getGlobalString("btn.skip"), check);
                frameUpdate.frmUpdate.setVisible(true);
            }
        });
        menuItem.setIcon(new ImageIcon(UI.class.getResource("/resource/Dropbox Filled-16.png")));
        mnHelpLink.add(menuItem);
        JMenu mnTweak = new JMenu(Messages.getString("UI.mnTweak.text"));
        menuBar.add(mnTweak);
        this.mntmLoginTo = new JMenuItem(Messages.getString("UI.mntmLoginto.text"));
        this.mntmLoginTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Main.browser == null) {
                    Main.browser = new MKBrowser();
                }
                UI.this.cboPageConfigList.getSelectedItem();
                Main.browser.setVisible(true);
                UI.this.p = (PageConfig)UI.this.cboPageConfigList.getSelectedItem();
                String url = "https://google.com";
                String pageCode = "google.com";
                if (UI.this.p != null) {
                    pageCode = UI.this.p.getPageCode();
                    url = UrlHandler.normalizeHost(pageCode);
                }
                Main.browser.loadURL(url, pageCode);
            }
        });
        this.mntmLoginTo.setIcon(new ImageIcon(UI.class.getResource("/resource/login-icon-16.png")));
        mnTweak.add(this.mntmLoginTo);
        JLabel lblUrl = new JLabel(Messages.getString("UI.lblUrl.text"));
        this.txtURL = new JTextField();
        this.txtURL.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent arg0) {
                if (!UI.this.txtURL.getText().equals(Messages.getString("UI.txtURL.text"))) {
                    UI.this.txtURL.setForeground(Color.BLACK);
                }
            }
        });
        this.txtURL.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (UI.this.txtURL.getText().equals(Messages.getString("UI.txtURL.text"))) {
                    UI.this.txtURL.setText("");
                    UI.this.txtURL.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (UI.this.txtURL.getText().isEmpty()) {
                    UI.this.txtURL.setText(Messages.getString("UI.txtURL.text"));
                    UI.this.txtURL.setForeground(Color.GRAY);
                }
            }
        });
        this.txtURL.setText(Messages.getString("UI.txtURL.text"));
        this.txtURL.setForeground(Color.GRAY);
        this.txtURL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    UI.this.popupMenu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
                }
            }
        });
        this.txtURL.setColumns(10);
        this.btnDownload = new JButton(Messages.getString("UI.btnDownload.text"));
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UI.this.doWork();
            }
        });
        this.cboPageConfigList = new JComboBox();
        this.cboPageConfigList.setFont(new Font("Tahoma", 0, 13));
        this.cboPageConfigList.setBorder(null);
        this.cboPageConfigList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                UI.this.p = (PageConfig)UI.this.cboPageConfigList.getSelectedItem();
                if (UI.this.p != null) {
                    UI.this.btnHelp.setText(String.valueOf(Messages.getString("UI.btnHelp.text")) + "\"" + UI.this.p.getPageCode() + "\"");
                    UI.this.mntmLoginTo.setText(String.format(Messages.getString("UI.mntmLoginto.textFormat"), UI.this.p.getPageCode()));
                }
            }
        });
        this.btnCancel = new JButton(Messages.getString("UI.btnCancel.text"));
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UI.this.tAuto.cancel();
                UI.this.btnResume.setEnabled(true);
            }
        });
        this.btnResume = new JButton(Messages.getString("UI.btnResume.text"));
        this.btnResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UI.this.tAuto.start();
                UI.this.btnResume.setEnabled(false);
            }
        });
        this.btnResume.setEnabled(false);
        this.btnHelp = new JButton(Messages.getString("UI.btnHelp.text"));
        this.btnHelp.setHorizontalAlignment(2);
        this.btnHelp.setHorizontalTextPosition(4);
        this.btnHelp.setAutoscrolls(true);
        this.btnHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    UI.this.popupMenu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
                }
            }
        });
        this.btnHelp.setContentAreaFilled(false);
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int buttonOption = 0;
                Object[] options = new String[]{Messages.getGlobalString("btn.copyLinkDemo"), Messages.getGlobalString("btn.close")};
                if (!UI.this.p.getScriptJS().trim().isEmpty()) {
                    options = new String[]{Messages.getGlobalString("btn.copyLinkDemo"), Messages.getGlobalString("btn.copyScript"), Messages.getGlobalString("btn.close")};
                    buttonOption = 1;
                }
                int result = JOptionPane.showOptionDialog(null, UI.this.p.getTextGuide(), Messages.getGlobalString("title.help"), buttonOption, 1, null, options, options[0]);
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (result == 0) {
                    c.setContents(new StringSelection(UI.this.p.getUrlPageTest()), null);
                } else if (result == 1) {
                    c.setContents(new StringSelection(UI.this.p.getScriptJS()), null);
                }
            }
        });
        this.btnHelp.setIcon(new ImageIcon(UI.class.getResource("/resource/help-desk-icon.png")));
        this.jfrmUiGetHtml.getContentPane().setLayout(new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("99px"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("319px:grow"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("110px"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("23px"), FormSpecs.UNRELATED_GAP_ROWSPEC, RowSpec.decode("24px"), RowSpec.decode("30px"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode("25px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("top:74px:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("23px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("24px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("155px:grow"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC}));
        JLabel lblFilterHost = new JLabel(Messages.getString("UI.lblFilterHost.text"));
        this.jfrmUiGetHtml.getContentPane().add((Component)lblFilterHost, "2, 4, right, fill");
        JPanel panel_2 = new JPanel();
        panel_2.setAlignmentY(0.0f);
        panel_2.setAlignmentX(0.0f);
        this.jfrmUiGetHtml.getContentPane().add((Component)panel_2, "4, 4, fill, center");
        panel_2.setLayout(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("left:max(60dlu;default)"), ColumnSpec.decode("122px:grow"), ColumnSpec.decode("20px")}, new RowSpec[]{RowSpec.decode("24px")}));
        this.cboHostType = new JComboBox();
        this.cboHostType.addItem(Messages.getGlobalString("const.hostType.All"));
        this.cboHostType.addItem(Messages.getGlobalString("const.hostType.vietnam"));
        this.cboHostType.addItem(Messages.getGlobalString("const.hostType.International"));
        this.cboHostType.setSelectedIndex(0);
        this.cboHostType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                UI.this.getListToCombo("");
            }
        });
        panel_2.add(this.cboHostType, "1, 1, fill, fill");
        this.txtFilter = new JTextField();
        panel_2.add((Component)this.txtFilter, "2, 1, fill, fill");
        this.txtFilter.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent arg0) {
                if (UI.this.txtFilter.getText().isEmpty() && !UI.this.txtFilter.isFocusOwner()) {
                    UI.this.txtFilter.setText(Messages.getString("UI.txtFilter.text"));
                    UI.this.txtFilter.setForeground(Color.GRAY);
                }
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent arg0) {
            }
        });
        this.txtFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                UI.this.getListToCombo(UI.this.txtFilter.getText());
                if (UI.this.txtFilter.getText().length() > 2 && arg0.getKeyCode() == 10 && UI.this.isHelpShowHitCount == 0) {
                    ++UI.this.isHelpShowHitCount;
                    UI.this.btnHelp.doClick();
                } else if (UI.this.isHelpShowHitCount > 0) {
                    --UI.this.isHelpShowHitCount;
                    UI.this.txtFilter.requestFocus(false);
                    UI.this.txtURL.requestFocus();
                }
            }
        });
        this.txtFilter.setForeground(Color.GRAY);
        this.txtFilter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (UI.this.txtFilter.getText().equals(Messages.getString("UI.txtFilter.text"))) {
                    UI.this.txtFilter.setText("");
                    UI.this.txtFilter.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (UI.this.txtFilter.getText().isEmpty()) {
                    UI.this.txtFilter.setText(Messages.getString("UI.txtFilter.text"));
                    UI.this.txtFilter.setForeground(Color.GRAY);
                }
            }
        });
        this.txtFilter.setText(Messages.getString("UI.txtFilter.text"));
        this.txtFilter.setColumns(10);
        JButton btnX = new JButton("");
        btnX.setToolTipText(Messages.getString("UI.btnX.toolTipText"));
        panel_2.add((Component)btnX, "3, 1, left, top");
        btnX.setInheritsPopupMenu(true);
        btnX.setDefaultCapable(false);
        btnX.setSelectedIcon(new ImageIcon(UI.class.getResource("/resource/Delete-16-hover.png")));
        btnX.setIcon(new ImageIcon(UI.class.getResource("/resource/Delete-16.png")));
        btnX.setPreferredSize(new Dimension(45, 24));
        btnX.setMargin(new Insets(0, 0, 0, 0));
        btnX.setForeground(Color.GRAY);
        btnX.setBorder(new CompoundBorder());
        btnX.setBackground(SystemColor.control);
        btnX.setFocusable(false);
        btnX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UI.this.txtFilter.setText("");
                UI.this.getListToCombo("");
            }
        });
        this.btnHostCount = new JButton(Messages.getString("UI.btnBtnhostcount.text"));
        this.btnHostCount.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                String message = Messages.getString("UI.hostInfoMessage");
                int totalHost = Config.getAllHostConfig().size();
                int[] countList = new int[]{0, 0, 0, 0};
                Config.getAllHostConfig().forEach(a -> {
                    if (a.getIsManualGet().booleanValue()) {
                        nArray[1] = countList[1] + 1;
                    } else if (a.getIsForumType().booleanValue()) {
                        nArray[2] = countList[2] + 1;
                    } else if (a.getIsVietNameseHost().booleanValue()) {
                        nArray[3] = countList[3] + 1;
                    } else {
                        nArray[0] = countList[0] + 1;
                    }
                });
                message = String.format(message, countList[0], countList[1], countList[2], countList[3], totalHost);
                JOptionPane.showMessageDialog(null, message, Messages.getString("UI.hostInfoMesageTitle"), 1);
            }
        });
        this.btnHostCount.setFont(new Font("Tahoma", 1, 13));
        this.btnHostCount.setToolTipText(Messages.getString("UI.btnBtnhostcount.toolTipText"));
        this.btnHostCount.setHorizontalAlignment(4);
        this.btnHostCount.setContentAreaFilled(false);
        this.btnHostCount.setBorderPainted(false);
        this.btnHostCount.setBorder(null);
        this.btnHostCount.setForeground(new Color(50, 205, 50));
        this.btnHostCount.setBackground(Color.LIGHT_GRAY);
        this.jfrmUiGetHtml.getContentPane().add((Component)this.btnHostCount, "2, 5, fill, fill");
        JPanel pnlOption = new JPanel();
        this.jfrmUiGetHtml.getContentPane().add((Component)pnlOption, "4, 9, fill, fill");
        pnlOption.setLayout(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("max(120dlu;default)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("default:grow")}, new RowSpec[]{RowSpec.decode("default:grow")}));
        JPanel panel_1 = new JPanel();
        pnlOption.add((Component)panel_1, "1, 1, default, fill");
        panel_1.setBorder(new TitledBorder(null, Messages.getString("UI.panel_1.borderTitle"), 1, 2, null, null));
        panel_1.setLayout(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("143px")}, new RowSpec[]{RowSpec.decode("max(20px;default)"), FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode("max(20px;default)")}));
        this.chckbxDownloadFrom = new JCheckBox(Messages.getString("UI.chckbxDownloadFrom.text"));
        panel_1.add((Component)this.chckbxDownloadFrom, "1, 1, fill, fill");
        this.chckbxDownloadFrom.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    UI.this.popupMenu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
                }
            }
        });
        this.chckbxAddEbookInfo = new JCheckBox(Messages.getString("UI.chckbxAddEbookInfo.text"));
        this.chckbxAddEbookInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (UI.this.txtURL.getText().trim().equals("")) {
                    JOptionPane.showMessageDialog(null, Messages.getGlobalString("warning.inputFilePathFirst"));
                    UI.this.txtURL.requestFocus();
                } else if (UI.this.chckbxAddEbookInfo.isSelected()) {
                    UI.this.cri = new CopyRightInfo(UI.this.btnDownload);
                    UI.this.cri.setVisible(true);
                }
                UI.this.chckbxAddEbookInfo.setSelected(false);
            }
        });
        panel_1.add((Component)this.chckbxAddEbookInfo, "1, 3, fill, fill");
        JPanel panel_3 = new JPanel();
        panel_3.setBorder(new TitledBorder(null, Messages.getString("UI.panel_3.borderTitle"), 4, 2, null, null));
        pnlOption.add((Component)panel_3, "3, 1, fill, fill");
        panel_3.setLayout(new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow")}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.chckbxOneFilePer = new JCheckBox(Messages.getString("UI.chckbxOneFilePer.text"));
        this.chckbxOneFilePer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                Config.put(Enumeration.EnumConfigKey.REMEMBER_ONE_PER_FILE, UI.this.chckbxOneFilePer.isSelected(), true);
            }
        });
        panel_3.add((Component)this.chckbxOneFilePer, "2, 1, fill, center");
        this.chckbxAddEbookInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                if (arg0.isPopupTrigger()) {
                    UI.this.popupMenu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
                }
            }
        });
        JLabel lblTrngThi = new JLabel(Messages.getString("UI.lblTrngThi.text"));
        this.jfrmUiGetHtml.getContentPane().add((Component)lblTrngThi, "2, 11, right, default");
        this.lblStatus = new JLabel(Messages.getString("UI.lblStatus.text"));
        this.jfrmUiGetHtml.getContentPane().add((Component)this.lblStatus, "4, 11, 3, 1, fill, center");
        this.progressBar = new JProgressBar();
        this.jfrmUiGetHtml.getContentPane().add((Component)this.progressBar, "2, 13, 5, 1, fill, fill");
        this.progressBar.setPreferredSize(new Dimension(100, 14));
        this.jfrmUiGetHtml.getContentPane().add((Component)lblUrl, "2, 2, right, center");
        this.jfrmUiGetHtml.getContentPane().add((Component)this.btnHelp, "4, 7, fill, top");
        this.jfrmUiGetHtml.getContentPane().add(this.cboPageConfigList, "4, 5, fill, fill");
        this.jfrmUiGetHtml.getContentPane().add((Component)this.txtURL, "4, 2, fill, fill");
        this.jfrmUiGetHtml.getContentPane().add((Component)this.btnResume, "6, 7, fill, center");
        this.jfrmUiGetHtml.getContentPane().add((Component)this.btnCancel, "6, 5, fill, center");
        this.jfrmUiGetHtml.getContentPane().add((Component)this.btnDownload, "6, 2, fill, center");
        JPanel panel = new JPanel();
        this.jfrmUiGetHtml.getContentPane().add((Component)panel, "2, 15, 5, 1, fill, fill");
        panel.setBorder(new TitledBorder(null, Messages.getString("UI.panel.borderTitle"), 1, 2, null, null));
        panel.setLayout(new GridLayout(0, 1, 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setAutoscrolls(true);
        scrollPane.setVerticalScrollBarPolicy(22);
        panel.add(scrollPane);
        this.txtLog = new JTextArea();
        this.txtLog.setDisabledTextColor(new Color(255, 255, 255));
        this.txtLog.setBackground(Color.GRAY);
        this.txtLog.setForeground(Color.GREEN);
        this.txtLog.setEditable(false);
        this.txtLog.setFont(new Font("SansSerif", 0, 11));
        scrollPane.setViewportView(this.txtLog);
    }
}

